/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.decompose.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;

public class DecomposeSchemeEditPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener {
    private static final String FORM_ID = "eb_decompose_scheme";
    private static final String BIZ_MODEL = "bizmodel";
    private static final String MODEL = "model";
    private static final String SAVE = "save";
    private static final String ENTITYVIEW = "entityview";
    public static final String BUDGETPERIOD_TEXT = "budgetperiodtext";
    public static final String BUDGETPERIOD = "budgetperiod";
    public static final String AUDITTAIL = "audittrail";
    public static final String CURRENCY = "currency";
    public static final String[] btnString = new String[]{"bizmodel", "audittrail", "version", "datatype", "currency", "entityview"};

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        FormShowParameter showParameter = (FormShowParameter)args.getSource();
        String formId = showParameter.getFormId();
        if (FORM_ID.equals(formId)) {
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
        }
        super.loadCustomControlMetas(args);
    }

    @Override
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BUDGETPERIOD_TEXT});
        this.addItemClickListeners(new String[]{"decompose_add", "decompose_edit"});
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        IPageCache pageCache = parentView.getPageCache();
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (SAVE.equals(operateKey)) {
            if (pageCache == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)pageCache.get("KEY_MODEL_ID"))) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"BusinessModelListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                String modelId = pageCache.get("KEY_MODEL_ID");
                this.getModel().setValue(MODEL, (Object)modelId);
            }
            Long id = (Long)this.getModel().getValue("id");
            String number = (String)this.getModel().getValue("number");
            if (this.checkNumberRepeat(id, number).booleanValue()) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadResFormat((String)"%1\uff1a\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"DecomposeSchemePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[]{number}));
            }
            if (this.checkInput(number)) {
                args.setCancel(true);
            }
            String name = "";
            OrmLocaleValue nameLocal = (OrmLocaleValue)this.getModel().getValue("name");
            if (nameLocal != null) {
                name = nameLocal.getLocaleValue();
            }
            if (StringUtils.isEmpty((String)name)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u89e3\u65b9\u6848\u540d\u79f0\u3002", (String)"DecomposeSchemePlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean checkInput(String number) {
        String regEx = "[A-Za-z0-9_]+";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(number);
        if (!matcher.matches()) {
            StringBuilder errorInfo = new StringBuilder();
            errorInfo.append(number);
            errorInfo.append(" : ");
            errorInfo.append(ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u80fd\u5305\u542b\u6570\u5b57\u3001\u5b57\u6bcd\u548c\u4e0b\u5212\u7ebf\u3002", (String)"EbSchemeGroupPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.getView().showTipNotification(errorInfo.toString());
            return true;
        }
        return false;
    }

    private Boolean checkNumberRepeat(Long id, String number) {
        Long modelId = this.getModelId();
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        qFilter.and(new QFilter(MODEL, "=", (Object)modelId));
        if (id != null && id != 0L) {
            qFilter = qFilter.and(new QFilter("id", "!=", (Object)id));
        }
        return QueryServiceHelper.exists((String)FORM_ID, (QFilter[])qFilter.toArray());
    }

    public void initialize() {
        super.initialize();
        this.addBeforeF7SelectListeners(btnString);
    }

    private void addBeforeF7SelectListeners(String ... keys) {
        for (String key : keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(key);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private String getCurrentDimNum(String ctrlKey) {
        String dimNum = null;
        for (SysDimensionEnum dimensionEnum : SysDimensionEnum.values()) {
            if (!ctrlKey.contains(dimensionEnum.getNumber().toLowerCase(Locale.ENGLISH))) continue;
            dimNum = dimensionEnum.getNumber();
        }
        return dimNum;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        IDataEntityProperty property = beforeF7SelectEvent.getProperty();
        if (property == null) {
            return;
        }
        String propertyKey = property.getName();
        ListShowParameter showP = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qs = showP.getListFilterParameter().getQFilters();
        Long modelId = this.getModelId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        if (BIZ_MODEL.equals(propertyKey)) {
            qs.add(new QFilter(MODEL, "=", (Object)modelId));
        } else if (ENTITYVIEW.equals(propertyKey)) {
            DynamicObject dimension = QueryServiceHelper.queryOne((String)"epm_dimension", (String)"id", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)modelId), new QFilter("number", "=", (Object)SysDimensionEnum.Entity.getNumber())});
            if (dimension != null) {
                Long businessModelId = this.getbizModelId();
                if (businessModelId == 0L) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"DecomposeSchemePlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                List orgViewIds = modelCacheHelper.getViewGroupViewsByBusModelAndDimNumber(businessModelId, "Entity");
                qs.add(new QFilter("id", "in", (Object)orgViewIds));
            }
        } else {
            MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)this.getDimNumber(propertyKey)), (String)ListSelectedRow.class.getName());
            f7Param.setBusModelId(this.getbizModelId());
            f7Param.setCanSelectRoot(false);
            if (AUDITTAIL.equals(propertyKey)) {
                QFilter filter = new QFilter("use", "!=", (Object)"40");
                f7Param.addCustomFilter(filter);
            } else if (CURRENCY.equals(propertyKey)) {
                QFilter filter = new QFilter("number", "!=", (Object)"EC");
                filter.and("number", "!=", (Object)"PC");
                f7Param.addCustomFilter(filter);
            } else {
                f7Param.setOnlySelLeaf(true);
            }
            NewF7Utils.openF7((BeforeF7SelectEvent)beforeF7SelectEvent, (MemberF7Parameter)f7Param);
        }
    }

    private String getDimNumber(String propertyKey) {
        String dimNumber = null;
        switch (propertyKey) {
            case "audittrail": {
                dimNumber = SysDimensionEnum.AuditTrail.getNumber();
                break;
            }
            case "currency": {
                dimNumber = SysDimensionEnum.Currency.getNumber();
                break;
            }
            case "datatype": {
                dimNumber = SysDimensionEnum.DataType.getNumber();
                break;
            }
            case "version": {
                dimNumber = SysDimensionEnum.Version.getNumber();
                break;
            }
        }
        return dimNumber;
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (BUDGETPERIOD_TEXT.equals(key)) {
            this.switchBudgetperiod(key);
        }
    }

    private void switchBudgetperiod(String key) {
        Long modelId = this.getModelId();
        MemberF7Parameter f7Param = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)SysDimensionEnum.BudgetPeriod.getNumber()), (String)ListSelectedRow.class.getName());
        f7Param.setCanSelectBudgetPeriodRoot(false);
        String value = (String)this.getModel().getValue(BUDGETPERIOD);
        if (!StringUtils.isEmpty((String)value)) {
            String[] split = value.split(",");
            LinkedHashSet<Long> selectIds = new LinkedHashSet<Long>(split.length);
            for (String s : split) {
                selectIds.add(IDUtils.toLong((Object)s));
            }
            if (!CollectionUtils.isEmpty(selectIds)) {
                f7Param.setSelectIds(selectIds);
            }
        }
        NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, BUDGETPERIOD_TEXT));
    }

    public String getCurrentDimNumber(String key) {
        return this.getCurrentDimNum(key);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null) {
            if (BUDGETPERIOD_TEXT.equals(actionId)) {
                this.handleBudgetperiod(returnData);
            } else if (AUDITTAIL.equals(actionId)) {
                ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
                this.getModel().setValue(AUDITTAIL, rows.get(0).getPrimaryKeyValue());
            }
        }
    }

    private void handleBudgetperiod(Object returnData) {
        ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
        if (rows != null) {
            Long[] ids = new Long[rows.size()];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = (Long)rows.get(i).getPrimaryKeyValue();
            }
            HashSet<Long> periodIds = new HashSet<Long>(16);
            HashSet<String> periodNames = new HashSet<String>(16);
            QFilter qFilter = new QFilter("id", "in", (Object)ids);
            DynamicObjectCollection query = QueryServiceHelper.query((String)"epm_bperiodmembertree", (String)"id,parent,name,number,isleaf,level", (QFilter[])new QFilter[]{qFilter}, (String)"level,number asc");
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
            for (DynamicObject dynamicObject : query) {
                Long id = dynamicObject.getLong("id");
                String name = dynamicObject.getString("name");
                Member member = modelCacheHelper.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, id);
                List parents = modelCacheHelper.getParents(null, member, false);
                if (!CollectionUtils.isEmpty(periodIds)) {
                    List collect = parents.stream().map(BaseCache::getId).collect(Collectors.toList());
                    List names = parents.stream().map(Member::getName).collect(Collectors.toList());
                    if (Collections.disjoint(periodIds, collect)) {
                        periodIds.add(id);
                        periodNames.add(name);
                    }
                    if (!Collections.disjoint(periodNames, names)) continue;
                    periodIds.add(id);
                    periodNames.add(name);
                    continue;
                }
                periodIds.add(id);
                periodNames.add(name);
            }
            List collect = periodIds.stream().sorted().collect(Collectors.toList());
            List names = periodNames.stream().sorted().collect(Collectors.toList());
            this.getModel().setValue(BUDGETPERIOD_TEXT, (Object)String.join((CharSequence)",", names));
            ArrayList<String> periodList = new ArrayList<String>(10);
            for (Long periodId : collect) {
                periodList.add(String.valueOf(periodId));
            }
            this.getModel().setValue(BUDGETPERIOD, (Object)String.join((CharSequence)",", periodList));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long id = (Long)this.getModel().getValue("id");
        QFilter qFilter = new QFilter("scheme", "=", (Object)id);
        if (QueryServiceHelper.exists((String)"eb_decompose_task", (QFilter[])qFilter.toArray())) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BIZ_MODEL, "datatype", "version", AUDITTAIL, BUDGETPERIOD_TEXT, CURRENCY});
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        if (IDUtils.isNotNull((Long)this.getModelId())) {
            String budgerperiod = (String)this.getModel().getValue(BUDGETPERIOD);
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
            if (StringUtils.isNotEmpty((String)budgerperiod)) {
                String[] split = budgerperiod.split(",");
                ArrayList<String> budgerperiodNames = new ArrayList<String>(10);
                for (String s : split) {
                    Member member = modelCacheHelper.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, Long.valueOf(s));
                    if (member == null) continue;
                    budgerperiodNames.add(member.getName());
                }
                this.getModel().setValue(BUDGETPERIOD_TEXT, (Object)String.join((CharSequence)",", budgerperiodNames));
            }
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{BIZ_MODEL, ENTITYVIEW});
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if (SAVE.equals(key)) {
            boolean issuccess;
            boolean bl = issuccess = e.getOperationResult().getValidateResult().isSuccess() && e.getOperationResult().isSuccess();
            if (issuccess) {
                this.getView().returnDataToParent(e.getOperationResult().getSuccessPkIds().get(0));
                this.getView().close();
            } else {
                List errorInfos = e.getOperationResult().getAllErrorOrValidateInfo();
                if (errorInfos == null || errorInfos.isEmpty()) {
                    this.getView().showTipNotification(e.getOperationResult().getMessage());
                }
            }
        }
    }

    private Long getbizModelId() {
        DynamicObject bizmodel = (DynamicObject)this.getModel().getValue(BIZ_MODEL);
        return bizmodel == null ? 0L : bizmodel.getLong("id");
    }

    @Override
    public Long getModelId() {
        IPageCache pageCache;
        Long modelId = 0L;
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            parentView = this.getView();
        }
        if ((pageCache = parentView.getPageCache()) != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)pageCache.get("KEY_MODEL_ID"))) {
            modelId = Long.parseLong(pageCache.get("KEY_MODEL_ID"));
        } else {
            Long tempModelId = (Long)this.getView().getFormShowParameter().getCustomParam("modelId");
            if (tempModelId != null) {
                modelId = tempModelId;
            }
        }
        return modelId;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (BIZ_MODEL.equals(name)) {
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
            Map viewsByBusModel = modelCacheHelper.getViewsByBusModelIncludeBase(this.getbizModelId());
            Long view = (Long)viewsByBusModel.get(SysDimensionEnum.Entity.getNumber());
            this.getModel().setValue(ENTITYVIEW, (Object)view);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        Object idObj = this.getModel().getValue("id");
        if (idObj instanceof Long && IDUtils.isNotNull((Long)((Long)idObj))) {
            e.setCheckDataChange(false);
        }
        super.beforeClosed(e);
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
    }
}

