/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.decompose.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.report.CellStyle;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.New;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.dataupload.DataReleaseUtils;
import kd.epm.eb.business.decompose.service.DecomposeSchemeService;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.decompose.DynamicObjectUtil;
import kd.epm.eb.common.decompose.TaskStatus;
import kd.epm.eb.common.decompose.entity.DecomposeSchemeStatus;
import kd.epm.eb.common.decompose.entity.DecomposeSchemeType;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class DecomposeSchemeListPlugin
extends AbstractListPlugin {
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_ID = "id";
    private static final String SCHEME = "scheme";
    private static final String ADJUST_START = "adjustStart";
    private List<String> list = new LinkedList<String>();
    private static final String FORM_SCHEME = "eb_decompose_scheme";
    private static final String FORM_PROCESS = "bgm_decompose_process";
    private static final String FORM_TASK = "eb_decompose_task";
    private static final String DECOMPOSE_ADD = "decompose_add";
    private static final String DECOMPOSE_EDIT = "decompose_edit";
    private static final String DECOMPOSE_START = "decompose_start";
    private static final String DECOMPOSE_STOP = "decompose_stop";
    public static final String DECOMPOSE_DEL = "decompose_del";
    public static final String DELETE_SCHEME_CONFIRM = "delete_scheme_confirm";
    public static final String DECOMPOSE_PROCESS = "decompose_process";
    private static final String DATA_RELEASE = "data_release";
    private static final String RELEASE_LOG = "release_log";
    private static final String BTN_RECALCULATE = "btn_recalculate";
    private static final String FORM_ID_RECALCULATE = "eb_decompose_recalculate";
    private static final String NUMBER = "number";
    private static final String TYPE = "type";
    private DecomposeSchemeService decomposeSchemeService = DecomposeSchemeService.getInstance();
    private static final String IS_NO_LIMIT_KEY = "IS_NO_LIMIT_FLAG";
    private static final Log log = LogFactory.getLog(DecomposeSchemeListPlugin.class);

    public void getEntityType(GetEntityTypeEventArgs args) {
        try {
            args.setNewEntityType((MainEntityType)args.getOriginalEntityType().clone());
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Long getModelId() {
        String modelId = this.getPageCache().get("KEY_MODEL_ID");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)modelId)) {
            return super.getModelId();
        }
        Long parseLong = Long.parseLong(modelId);
        return parseLong;
    }

    public void initialize() {
        super.initialize();
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    private void loadModelId(String clickKey) {
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectSchemeList = listview.getSelectedRows();
        ControlFilters controlFilters = this.getControlFilters();
        if (controlFilters == null) {
            Long modelId = UserSelectUtils.getUserSelectModelId((IFormView)this.getView());
            this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
            return;
        }
        List filter = controlFilters.getFilter("model.id");
        if (CollectionUtils.isNotEmpty((Collection)filter) && filter.get(0) != null && !"".equals(String.valueOf(filter.get(0)))) {
            this.getPageCache().put("KEY_MODEL_ID", String.valueOf(filter.get(0)));
        } else if (DECOMPOSE_ADD.equals(clickKey)) {
            this.getPageCache().put("KEY_MODEL_ID", String.valueOf(0L));
        } else if (CollectionUtils.isEmpty((Collection)selectSchemeList) || selectSchemeList.size() > 1) {
            this.getPageCache().put("KEY_MODEL_ID", String.valueOf(0L));
        } else {
            Object primaryKeyValue = selectSchemeList.get(0).getPrimaryKeyValue();
            if (primaryKeyValue instanceof Long) {
                Long id = (Long)primaryKeyValue;
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)FORM_SCHEME, (String)"model");
                this.getPageCache().put("KEY_MODEL_ID", dynamicObject.getString("model.id"));
            } else {
                this.getPageCache().put("KEY_MODEL_ID", String.valueOf(0L));
            }
        }
        Long modelId = this.getModelId();
        if (IDUtils.isNotNull((Long)modelId)) {
            UserSelectUtils.saveUserSelectModelId((IFormView)this.getView(), (long)modelId);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection data = super.getData(start, limit);
                for (DynamicObject datum : data) {
                    Long model = datum.getLong("model.id");
                    if (IDUtils.isNull((Long)model)) continue;
                    IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)model);
                    String budgetperiod = datum.getString("budgetperiod");
                    String[] split = budgetperiod.split(",");
                    ArrayList<String> names = new ArrayList<String>(10);
                    for (String s : split) {
                        Member member;
                        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)s) || (member = modelCacheHelper.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, Long.valueOf(Long.parseLong(s)))) == null) continue;
                        names.add(member.getName());
                    }
                    datum.set("budgetperiod", (Object)String.join((CharSequence)",", names));
                }
                this.getQueryResult().setDataCount(data.size());
                return data;
            }
        });
    }

    @Override
    public void registerListener(EventObject e) {
        ListView source = (ListView)e.getSource();
        if (source == null) {
            super.registerListener(e);
            return;
        }
        ListSelectedRowCollection selectedRows = source.getSelectedRows();
        if (selectedRows == null || selectedRows.size() == 0) {
            super.registerListener(e);
            return;
        }
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        String source;
        String column = arg0.getFieldName();
        if (NUMBER.equals(column) && StringUtils.isBlank((String)(source = this.getView().getEntityId()))) {
            throw new KDBizException("view is null.");
        }
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        this.loadModelId(itemKey);
        switch (itemKey) {
            case "decompose_edit": 
            case "decompose_stop": {
                ListSelectedRowCollection selectSchemeList = this.getSelectSchemeList();
                if (selectSchemeList.size() <= 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"DecomposeSchemeListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
        }
        super.beforeItemClick(evt);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (DECOMPOSE_ADD.equals(key)) {
            BaseShowParameter param = new BaseShowParameter();
            param.setFormId(FORM_SCHEME);
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, DECOMPOSE_ADD));
            this.getView().showForm((FormShowParameter)param);
            OperationLogUtil.log((String)this.getBizAppId(), (String)FORM_SCHEME, null, (String)"addNew", (MultiLangEnumBridge)new MultiLangEnumBridge("\u65b0\u589e", "DecomposeSchemeListPlugin_48", "epm-eb-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u65b0\u589e\u6210\u529f", "DecomposeSchemeListPlugin_49", "epm-eb-formplugin"), null);
        } else if (DECOMPOSE_START.equals(key)) {
            this.decomposeStart();
        } else if (DECOMPOSE_STOP.equals(key)) {
            this.decomposeStop();
        } else if (DECOMPOSE_DEL.equals(key)) {
            this.decomposeDelete();
        } else if (DECOMPOSE_PROCESS.equals(key)) {
            this.decomposeProcess();
        } else if (BTN_RECALCULATE.equals(key)) {
            this.openRecalculateView();
        } else if (DATA_RELEASE.equals(key)) {
            this.dataRelease();
        } else if (RELEASE_LOG.equals(key)) {
            this.showReleaseLog();
        }
    }

    private void showReleaseLog() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows) || selectedRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"DecomposeSchemeListPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter param = new ListShowParameter();
        param.setBillFormId("eb_datarelease_log");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setCustomParam("schemeId", selectedRows.get(0).getPrimaryKeyValue());
        this.getView().showForm((FormShowParameter)param);
    }

    private void dataRelease() {
        try {
            QFilter statusFilter;
            long entityView;
            QFilter srcOrgViewFilter;
            long bizModelId;
            QFilter bizModelFilter;
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectedRows) || selectedRows.size() != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"DecomposeSchemeListPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Long schemeId = IDUtils.toLong((Object)selectedRows.get(0).getPrimaryKeyValue());
            DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)FORM_SCHEME);
            String type = scheme.getString(TYPE);
            if (DecomposeSchemeType.TARGET.getValue().equals(type)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8c03\u6574\u5206\u89e3\u65b9\u6848\u518d\u6267\u884c\u4e0b\u8fbe\u64cd\u4f5c\u3002", (String)"DecomposeSchemeListPlugin_41", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            DecomposeSchemeService decomposeSchemeService = DecomposeSchemeService.getInstance();
            List decomposeAdjusts = decomposeSchemeService.getIssueAdjusts(scheme, true);
            long modelId = scheme.getLong("model.id");
            QFilter modelFilter = new QFilter("srcmodel", "=", (Object)modelId);
            DynamicObject[] releaseSchemes = BusinessDataServiceHelper.load((String)"eb_datareleasescheme", (String)"id,srcmodel,targetmodelentity.tarmodel,targetmodelentity.tarbizmodel,targetmodelentity.tarorgview,targetmodelentity.receiveversion,targetmodelentity.receivedatatype,targetmodelentity.msgreceivers,targetmodelentity.datareleasemap", (QFilter[])new QFilter[]{modelFilter, bizModelFilter = new QFilter("srcbizmodel", "=", (Object)(bizModelId = scheme.getLong("bizmodel.id"))), srcOrgViewFilter = new QFilter("srcorgview", "=", (Object)(entityView = scheme.getLong("entityview.id"))), statusFilter = new QFilter(FIELD_STATUS, "=", (Object)true)});
            if (releaseSchemes.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u4e0b\u8fbe\u7684\u6570\u636e\u4e0b\u8fbe\u65b9\u6848\u3002", (String)"DecomposeSchemeListPlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            decomposeAdjusts.removeIf(dynamicObject -> dynamicObject.getLong("entityview") != entityView);
            if (CollectionUtils.isEmpty((Collection)decomposeAdjusts)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u4e0b\u8fbe\u7684\u5ba1\u6279\u8c03\u6574\u8bb0\u5f55\u3002", (String)"DecomposeSchemeListPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Map allDataMapping = DataReleaseUtils.getAllDataMapping((Long)modelId, (Long)bizModelId);
            Map allMemberMapping = DataReleaseUtils.getAllMemberMapping((long)modelId);
            OlapTraceServiceHelper.setTraceOpInfo((String)scheme.getString(NUMBER));
            OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(DecomposeSchemeType.TARGET.getValue().equals(type) ? OlapDataAuditEventEnum.TargetDecompose : OlapDataAuditEventEnum.DecomposeAdjust));
            boolean totalSuccess = true;
            for (DynamicObject releaseScheme : releaseSchemes) {
                boolean success;
                DynamicObjectCollection targetmodelentity = releaseScheme.getDynamicObjectCollection("targetmodelentity");
                if (!CollectionUtils.isNotEmpty((Collection)targetmodelentity) || (success = decomposeSchemeService.buildChildAdjust(releaseScheme, decomposeAdjusts, allDataMapping, allMemberMapping, scheme))) continue;
                totalSuccess = false;
            }
            if (totalSuccess) {
                scheme.set("releasestatus", (Object)"1");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0b\u8fbe\u6210\u529f\u3002", (String)"DecomposeSchemeListPlugin_44", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                scheme.set("releasestatus", (Object)"2");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0b\u8fbe\u5931\u8d25\u3002", (String)"DecomposeSchemeListPlugin_45", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            scheme.set("releaseuser", (Object)UserUtils.getUserId());
            scheme.set("releasedate", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scheme});
            this.getView().invokeOperation("refresh");
            this.writeLog("release", new MultiLangEnumBridge("\u4e0b\u8fbe", "DecomposeSchemeListPlugin_46", "epm-eb-formplugin"), new MultiLangEnumBridge("\u6570\u636e\u4e0b\u8fbe", "DecomposeSchemeListPlugin_47", "epm-eb-formplugin"));
        }
        catch (Exception e) {
            if (e instanceof KDBizException) {
                throw new KDBizException(e.getMessage());
            }
            log.error("DecomposeDataReleaseError", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e0b\u8fbe\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void decomposeProcess() {
        ListSelectedRowCollection selectSchemeList = this.getSelectSchemeList();
        if (selectSchemeList.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"DecomposeSchemeListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRow listSelectedRow = selectSchemeList.get(0);
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)FORM_SCHEME);
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)listSelectedRow.getPrimaryKeyValue(), (DynamicObjectType)dynamicObject.getDynamicObjectType());
        if (DecomposeSchemeStatus.SAVE.getNumber().equals(scheme.getString(FIELD_STATUS))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u6682\u5b58\u72b6\u6001\u624d\u5141\u8bb8\u67e5\u8be2\u5206\u89e3\u8fdb\u5ea6\u3002", (String)"DecomposeSchemeListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter param = new FormShowParameter();
        param.setFormId(FORM_PROCESS);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setCustomParam("schemeId", selectSchemeList.get(0).getPrimaryKeyValue());
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, DECOMPOSE_ADD));
        this.getView().showForm(param);
    }

    private void decomposeDelete() {
        ListSelectedRowCollection selectSchemeList = this.getSelectSchemeList();
        if (!CollectionUtils.isEmpty((Collection)selectSchemeList)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664\u5df2\u9009\u65b9\u6848\uff1f", (String)"TargetSchemeListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETE_SCHEME_CONFIRM, (IFormPlugin)this));
        }
    }

    private ListSelectedRowCollection getSelectSchemeList() {
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection list = listview.getSelectedRows();
        if (list.size() < 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"DecomposeSchemePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return list;
    }

    private void decomposeStop() {
        ListSelectedRowCollection list = this.getSelectSchemeList();
        if (list.size() > 0) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)FORM_SCHEME);
            DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)list.get(0).getPrimaryKeyValue(), (DynamicObjectType)dynamicObject.getDynamicObjectType());
            this.getPageCache().put(SCHEME, SerializationUtils.serializeToBase64((Object)scheme));
            if (!DecomposeSchemeStatus.START.getNumber().equals(scheme.getString(FIELD_STATUS))) {
                String message = ResManager.loadKDString((String)"\u4ec5\u5206\u89e3\u4e2d\u72b6\u6001\u7684\u5206\u89e3\u65b9\u6848\u5141\u8bb8\u53d6\u6d88\u5206\u89e3\u3002", (String)"DecomposeSchemePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
                OperationLogUtil.log((String)this.getBizAppId(), (String)FORM_SCHEME, null, (String)"cancel_execute", (MultiLangEnumBridge)new MultiLangEnumBridge("\u53d6\u6d88\u6267\u884c", "DecomposeSchemeListPlugin_53", "epm-eb-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u7f16\u53f7\uff1a%1$s\uff0c\u53d6\u6d88\u6267\u884c\u5931\u8d25\uff0c%2$s\u3002", "DecomposeSchemeListPlugin_57", "epm-eb-formplugin"), (String[])new String[]{scheme.getString(NUMBER), message});
                return;
            }
            this.decomposeStop(scheme);
        }
    }

    private void decomposeStop(DynamicObject scheme) {
        scheme.set(FIELD_STATUS, (Object)DecomposeSchemeStatus.SAVE.getNumber());
        scheme.set("modifytime", (Object)TimeServiceHelper.now());
        scheme.set("modifyoperator", (Object)UserUtils.getUserId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scheme}, (OperateOption)OperateOption.create());
        IListView listView = (IListView)this.getView();
        listView.clearSelection();
        listView.refresh();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65b9\u6848\u53d6\u6d88\u5206\u89e3\u6210\u529f\u3002", (String)"DecomposeSchemePlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        OperationLogUtil.log((String)this.getBizAppId(), (String)FORM_SCHEME, null, (String)"cancel_decompose", (MultiLangEnumBridge)new MultiLangEnumBridge("\u53d6\u6d88\u6267\u884c", "DecomposeSchemeListPlugin_53", "epm-eb-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u7f16\u53f7\uff1a%1$s\uff0c\u53d6\u6d88\u6267\u884c\u6210\u529f\u3002", "DecomposeSchemeListPlugin_54", "epm-eb-formplugin"), (String[])new String[]{scheme.getString(NUMBER)});
    }

    private void decomposeStart() {
        ListSelectedRowCollection list = this.getSelectSchemeList();
        if (list.size() > 0) {
            if (list.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6bcf\u6b21\u4ec5\u5141\u8bb8\u9488\u5bf9\u4e00\u4e2a\u5206\u89e3\u65b9\u6848\u8fdb\u884c\u6267\u884c\u5206\u89e3\u64cd\u4f5c\u3002", (String)"DecomposeSchemePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)FORM_SCHEME);
            DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)list.get(0).getPrimaryKeyValue(), (DynamicObjectType)dynamicObject.getDynamicObjectType());
            this.getPageCache().put(SCHEME, SerializationUtils.serializeToBase64((Object)scheme));
            if (!DecomposeSchemeStatus.SAVE.getNumber().equals(scheme.getString(FIELD_STATUS))) {
                String message = ResManager.loadKDString((String)"\u4ec5\u6682\u5b58\u72b6\u6001\u7684\u5206\u89e3\u65b9\u6848\u5141\u8bb8\u6267\u884c\u5206\u89e3\u3002", (String)"DecomposeSchemePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
                OperationLogUtil.log((String)this.getBizAppId(), (String)FORM_SCHEME, null, (String)"execute_scheme", (MultiLangEnumBridge)new MultiLangEnumBridge("\u6267\u884c\u65b9\u6848", "DecomposeSchemeListPlugin_51", "epm-eb-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u7f16\u53f7\uff1a%1$s\uff0c\u6267\u884c\u65b9\u6848\u5931\u8d25\uff0c%2$s\u3002", "DecomposeSchemeListPlugin_58", "epm-eb-formplugin"), (String[])new String[]{scheme.getString(NUMBER), message});
                return;
            }
            this.decomposeSchemeService.validHasStartingScheme(scheme);
            if (DecomposeSchemeType.ADJUST.getValue().equals(scheme.getString(TYPE))) {
                this.beforeAdjustStart();
            } else {
                this.schemeStart(scheme);
            }
        }
    }

    private void beforeAdjustStart() {
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(ADJUST_START, (IFormPlugin)this);
        String msg = ResManager.loadKDString((String)"\u6267\u884c\u5206\u89e3\u540e\uff0c\u5c06\u9010\u7ea7\u4e0b\u8fbe\u5206\u89e3\u4efb\u52a1\uff0c\u4e14\u6267\u884c\u8303\u56f4\u5185\u7684\u6570\u636e\u5728\u5206\u89e3\u5b8c\u6210\u524d\u4e0d\u5141\u8bb8\u518d\u6b21\u53d1\u751f\u5ba1\u6279\u8c03\u6574\u3002", (String)"DecomposeSchemePlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, confirmCallBackListener);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if (ADJUST_START.equals(e.getCallBackId()) && e.getResult() == MessageBoxResult.Yes) {
            String schemeStr = this.getPageCache().get(SCHEME);
            DynamicObject scheme = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)schemeStr);
            this.schemeStart(scheme);
        } else if (DELETE_SCHEME_CONFIRM.equals(e.getCallBackId()) && e.getResult() == MessageBoxResult.Yes) {
            ListSelectedRowCollection selectSchemeList = this.getSelectSchemeList();
            this.schemeDelete(selectSchemeList);
            this.refreshList();
        }
    }

    public void refreshList() {
        BillList billList = this.getBillListControl();
        billList.clearSelection();
        billList.refresh();
    }

    private void schemeDelete(ListSelectedRowCollection scheme) {
        ArrayList<Long> schemeIds = new ArrayList<Long>(10);
        for (ListSelectedRow listSelectedRow : scheme) {
            schemeIds.add((Long)listSelectedRow.getPrimaryKeyValue());
        }
        Map map = BusinessDataServiceHelper.loadFromCache((String)FORM_SCHEME, (QFilter[])new QFilter[]{new QFilter(FIELD_ID, "in", schemeIds)});
        HashSet<String> numberSet = new HashSet<String>(16);
        for (Map.Entry next : map.entrySet()) {
            DynamicObject value = (DynamicObject)next.getValue();
            numberSet.add(value.getString(NUMBER));
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)value.getString(FIELD_STATUS), (CharSequence)DecomposeSchemeStatus.SAVE.getNumber())) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u6682\u5b58\u72b6\u6001\u7684\u5206\u89e3\u65b9\u6848\u5141\u8bb8\u5220\u9664\u3002", (String)"DecomposeSchemePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qFilter = new QFilter(SCHEME, "in", schemeIds);
        DynamicObject[] ids = BusinessDataServiceHelper.load((String)FORM_TASK, (String)FIELD_ID, (QFilter[])new QFilter[]{qFilter});
        if (ids.length > 0) {
            String message = ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u5206\u89e3\u65b9\u6848\u542b\u6709\u5206\u89e3\u660e\u7ec6\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DecomposeSchemePlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            OperationLogUtil.log((String)this.getBizAppId(), (String)FORM_SCHEME, null, (String)"delete", (MultiLangEnumBridge)new MultiLangEnumBridge("\u5220\u9664", "DecomposeSchemeListPlugin_50", "epm-eb-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u7f16\u53f7\u201c%1$s\u201d\u5220\u9664\u5931\u8d25\uff0c%2$s\u3002", "DecomposeSchemeListPlugin_56", "epm-eb-formplugin"), (String[])new String[]{org.apache.commons.lang3.StringUtils.join(numberSet, (String)","), message});
        } else {
            int count = DeleteServiceHelper.delete((String)FORM_SCHEME, (QFilter[])new QFilter[]{new QFilter(FIELD_ID, "in", schemeIds)});
            this.deleteDimQuote(schemeIds);
            if (count > 0) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"DecomposeSchemeListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.getView().updateView();
                OperationLogUtil.log((String)this.getBizAppId(), (String)FORM_SCHEME, null, (String)"delete", (MultiLangEnumBridge)new MultiLangEnumBridge("\u5220\u9664", "DecomposeSchemeListPlugin_50", "epm-eb-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u7f16\u53f7\uff1a%1$s\uff0c\u5220\u9664\u6210\u529f\u3002", "DecomposeSchemeListPlugin_55", "epm-eb-formplugin"), (String[])new String[]{org.apache.commons.lang3.StringUtils.join(numberSet, (String)",")});
            }
        }
    }

    public void deleteDimQuote(List<Long> billIds) {
        if (billIds == null || billIds.size() == 0) {
            return;
        }
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"delete", (Object[])new Object[]{MemberQuoteResourceEnum.DecomposeScheme.getType(), billIds});
    }

    private void schemeStart(DynamicObject scheme) {
        boolean startFlag = false;
        if (DecomposeSchemeType.ADJUST.getValue().equals(scheme.getString(TYPE))) {
            startFlag = this.adjustSchemeStart(scheme);
        } else if (DecomposeSchemeType.TARGET.getValue().equals(scheme.getString(TYPE))) {
            startFlag = this.targetSchemeStart(scheme);
        }
        if (startFlag) {
            scheme.set(FIELD_STATUS, (Object)DecomposeSchemeStatus.START.getNumber());
            scheme.set("modifytime", (Object)TimeServiceHelper.now());
            scheme.set("modifyoperator", (Object)UserUtils.getUserId());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scheme}, (OperateOption)OperateOption.create());
            IListView listView = (IListView)this.getView();
            listView.clearSelection();
            listView.refresh();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65b9\u6848\u6267\u884c\u6210\u529f\u3002", (String)"DecomposeSchemePlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            OperationLogUtil.log((String)this.getBizAppId(), (String)FORM_SCHEME, null, (String)"execute_scheme", (MultiLangEnumBridge)new MultiLangEnumBridge("\u6267\u884c\u65b9\u6848", "DecomposeSchemeListPlugin_51", "epm-eb-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u7f16\u53f7\uff1a%1$s\uff0c\u6267\u884c\u65b9\u6848\u6210\u529f\u3002", "DecomposeSchemeListPlugin_52", "epm-eb-formplugin"), (String[])new String[]{scheme.getString(NUMBER)});
        }
    }

    private boolean targetSchemeStart(DynamicObject scheme) {
        QFilter qFilter = new QFilter(SCHEME, "=", scheme.getPkValue());
        qFilter.and(FIELD_STATUS, "in", Arrays.asList(TaskStatus.WAIT.getValue(), -1, TaskStatus.START.getValue()));
        String selectProperties = "id,status,dataflag,modifydate,modifier";
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)FORM_TASK, (String)selectProperties, (QFilter[])qFilter.toArray());
        if (tasks.length < 1) {
            String message = ResManager.loadKDString((String)"\u65e0\u5f85\u5206\u89e3\u6570\u636e\u3002", (String)"DecomposeSchemePlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            OperationLogUtil.log((String)"bgmd", (String)FORM_SCHEME, null, (String)"execute_scheme", (MultiLangEnumBridge)new MultiLangEnumBridge("\u6267\u884c\u65b9\u6848", "DecomposeSchemeListPlugin_51", "epm-eb-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u7f16\u53f7\uff1a%1$s\uff0c\u6267\u884c\u65b9\u6848\u5931\u8d25\uff0c%2$s\u3002", "DecomposeSchemeListPlugin_58", "epm-eb-formplugin"), (String[])new String[]{scheme.getString(NUMBER), message});
            this.getView().showTipNotification(message);
            return false;
        }
        for (DynamicObject task : tasks) {
            if (task.getInt(FIELD_STATUS) == -1) {
                task.set(FIELD_STATUS, (Object)TaskStatus.WAIT.getValue());
            }
            DynamicObjectUtil.init2Update((DynamicObject)task);
        }
        Object[] save = SaveServiceHelper.save((DynamicObject[])tasks);
        if (save.length > 0) {
            IListView listView = (IListView)this.getView();
            listView.clearSelection();
            listView.refresh();
        }
        return true;
    }

    private boolean adjustSchemeStart(DynamicObject scheme) {
        try {
            this.decomposeSchemeService.saveTaskByScheme(scheme);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        return true;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        IListView listView = (IListView)this.getView();
        if (DECOMPOSE_ADD.equals(actionId)) {
            if (ObjectUtils.isEmpty((Object)e.getReturnData())) {
                return;
            }
            listView.clearSelection();
            listView.refresh();
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        CommonBaseDataFilterColumn filterColumn = (CommonBaseDataFilterColumn)args.getFilterColumn("model.name");
        if (filterColumn == null) {
            return;
        }
        this.loadModelId("");
        Long modelId = this.getModelId();
        List modelFilter = ModelUtil.getModelFilter((IFormView)this.getView(), (boolean)false);
        Set modelIds = ModelUtil.getModelIds((IFormView)this.getView(), (boolean)false);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"model", (String)"epm_model", (String)"id,name", (QFilter[])modelFilter.toArray(new QFilter[modelFilter.size()]), null);
        filterColumn.getComboItems().clear();
        ArrayList comboItems = new ArrayList(16);
        col.forEach(e -> comboItems.add(new ComboItem(new LocaleString(e.getString("name")), e.getString(FIELD_ID))));
        filterColumn.setComboItems(comboItems);
        if (CollectionUtils.isNotEmpty((Collection)modelIds) && IDUtils.isNotNull((Long)modelId) && modelIds.contains(modelId)) {
            filterColumn.setDefaultValue(String.valueOf(modelId));
        } else {
            modelId = CollectionUtils.isNotEmpty((Collection)modelIds) ? (Long)modelIds.stream().findFirst().get() : Long.valueOf(0L);
        }
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        if (args != null) {
            SearchClickEvent searchClickEvent = args.getSearchClickEvent();
            if (searchClickEvent == null) {
                return;
            }
            List selectMainOrgIds = searchClickEvent.getSelectMainOrgIds();
            if (selectMainOrgIds != null && selectMainOrgIds.size() == 0) {
                Set modelIds = ModelUtil.getModelIds((IFormView)this.getView(), (boolean)false);
                args.getSearchClickEvent().getSelectMainOrgIds().addAll(new ArrayList(modelIds));
                this.getPageCache().put(IS_NO_LIMIT_KEY, IS_NO_LIMIT_KEY);
            } else {
                this.getPageCache().remove(IS_NO_LIMIT_KEY);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        boolean isNoLimit;
        boolean bl = isNoLimit = this.getPageCache() != null && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(IS_NO_LIMIT_KEY)) && this.getPageCache().get(IS_NO_LIMIT_KEY).equals(IS_NO_LIMIT_KEY);
        if (e.getMainOrgQFilter() == null) {
            Set modelIds = ModelUtil.getModelIds((IFormView)this.getView(), (boolean)false);
            QFilter qFilter = new QFilter("model", "in", (Object)modelIds);
            e.getQFilters().add(qFilter);
            return;
        }
        if (isNoLimit) {
            Object value;
            Set modelIds = ModelUtil.getModelIds((IFormView)this.getView(), (boolean)false);
            if (CollectionUtils.isNotEmpty((Collection)modelIds) && (value = e.getMainOrgQFilter().getValue()) instanceof List) {
                ((List)value).clear();
                ((List)value).addAll(new ArrayList(modelIds));
            }
        } else {
            Object value = e.getMainOrgQFilter().getValue();
            if (value instanceof List) {
                ((List)value).clear();
                ((List)value).add(this.getModelId());
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        IPageCache pageCache;
        Object source = args.getSource();
        if (source instanceof New && ((pageCache = this.getPageCache()) == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)pageCache.get("KEY_MODEL_ID")))) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"BusinessModelListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        super.beforeDoOperation(args);
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        if (packageDataEvent == null) {
            return;
        }
        if (packageDataEvent.getRowData() == null) {
            return;
        }
        Object source = packageDataEvent.getSource();
        if (source == null || !(source instanceof ColumnDesc)) {
            return;
        }
        String fieldKey = ((ColumnDesc)source).getKey();
        if (!FIELD_STATUS.equals(fieldKey)) {
            return;
        }
        String statusValue = this.getStatusStr(packageDataEvent);
        this.list.add(statusValue);
    }

    private String getStatusStr(PackageDataEvent packageDataEvent) {
        Object status = packageDataEvent.getRowData().get(FIELD_STATUS);
        String statusValue = status instanceof String ? (String)status : "";
        return statusValue;
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        Object source = eventObject.getSource();
        if (source instanceof BillList) {
            BillList billList = (BillList)source;
            List<CellStyle> cellStyles = this.loadCellStyles();
            billList.setCellStyle(cellStyles);
        }
    }

    private List<CellStyle> loadCellStyles() {
        ArrayList<CellStyle> resultList = new ArrayList<CellStyle>(this.list.size() * 2);
        for (int i = 0; i < this.list.size(); ++i) {
            CellStyle cellStyle = new CellStyle();
            String statusStr = this.list.get(i);
            String color = this.selectColor(statusStr);
            cellStyle.setForeColor(color);
            cellStyle.setRow(i);
            cellStyle.setFieldKey(FIELD_STATUS);
            resultList.add(cellStyle);
        }
        this.list.clear();
        return resultList;
    }

    private String selectColor(String statusStr) {
        String color = DecomposeSchemeStatus.START.getNumber().equals(statusStr) ? "#55A0F5" : (DecomposeSchemeStatus.FINISHED.getNumber().equals(statusStr) ? "#26B175" : "#666666");
        return color;
    }

    private void openRecalculateView() {
        FormShowParameter formShowParameter = new FormShowParameter();
        ListSelectedRowCollection selectSchemeList = this.getSelectSchemeList();
        if (selectSchemeList != null) {
            if (selectSchemeList.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"DecomposeSchemeListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (selectSchemeList.size() == 1) {
                ListSelectedRow listSelectedRow = selectSchemeList.get(0);
                DynamicObject decomposeScheme = BusinessDataServiceHelper.loadSingle((Object)listSelectedRow.getPrimaryKeyValue(), (String)FORM_SCHEME);
                formShowParameter.setCustomParam("decompose_scheme_selected", (Object)ObjectSerialUtil.toSerializedToDynaObj((DynamicObject)decomposeScheme));
            }
        }
        formShowParameter.setFormId(FORM_ID_RECALCULATE);
        formShowParameter.setCustomParam("parentid", (Object)this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        this.loadModelId("");
        Long modelId = this.getModelId();
        if (IDUtils.isNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"BusinessModelListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
        this.getView().showForm(formShowParameter);
    }
}

