/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.decompose.plugin;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.epm.eb.common.decompose.entity.DecomposeSchemeStatus;
import kd.epm.eb.common.utils.UserUtils;

public class DecomposeSchemeOperationPlugin
extends AbstractOperationServicePlugIn {
    private static final String FIELD_MODIFYOPERATOR = "modifyoperator";
    private static final String FIELD_MODIFYTIME = "modifytime";
    private static final String FIELD_CREATEOPERATOR = "createoperator";
    private static final String FIELD_CREATETIME = "createtime";
    private static final String FIELD_STATUS = "status";
    private int count = 0;

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        String key;
        this.count = 0;
        switch (key = args.getOperationKey() != null ? args.getOperationKey().toLowerCase(Locale.ENGLISH) : "") {
            case "save": {
                this.saveData(args);
                break;
            }
        }
        super.beforeExecuteOperationTransaction(args);
    }

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        this.addField(args);
        super.onPreparePropertys(args);
    }

    private void addField(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        this.checkAndAdd(fieldKeys, FIELD_MODIFYOPERATOR);
        this.checkAndAdd(fieldKeys, FIELD_MODIFYTIME);
        this.checkAndAdd(fieldKeys, FIELD_STATUS);
        args.setFieldKeys(fieldKeys);
    }

    private void checkAndAdd(List<String> fieldKeys, String modifyoperator) {
        if (fieldKeys != null && !fieldKeys.contains(modifyoperator)) {
            fieldKeys.add(modifyoperator);
        }
    }

    private void saveData(BeforeOperationArgs args) {
        Long userId = UserUtils.getUserId();
        Date nowDate = new Date();
        DynamicObject[] dataEntities = args.getDataEntities();
        this.count = dataEntities.length;
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject dataEntity = dataEntities[i];
            dataEntity.set(FIELD_MODIFYOPERATOR, (Object)userId);
            dataEntity.set(FIELD_CREATEOPERATOR, (Object)userId);
            dataEntity.set(FIELD_MODIFYTIME, (Object)nowDate);
            dataEntity.set(FIELD_CREATETIME, (Object)nowDate);
            dataEntity.set(FIELD_STATUS, (Object)DecomposeSchemeStatus.SAVE.getNumber());
        }
        super.beforeExecuteOperationTransaction(args);
    }

    public void onReturnOperation(ReturnOperationArgs operationArgs) {
        IOperationResult operationResult = operationArgs.getOperationResult();
        if (operationResult == null || operationResult.getSuccessPkIds() == null) {
            return;
        }
        List successPkIds = this.operationResult.getSuccessPkIds();
        if (successPkIds.size() != this.count) {
            this.operationResult.setShowMessage(true);
            this.operationResult.setMessage(ResManager.loadKDString((String)"\u672a\u5168\u90e8\u5b8c\u6210", (String)"DecomposeSchemeOperationPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }
}

