/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.decompose.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.decompose.service.DataDecomposeService;
import kd.epm.eb.business.decompose.service.DecomposeSchemeService;
import kd.epm.eb.business.decompose.service.DecomposeTaskService;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.common.decompose.DecDimensionUtil;
import kd.epm.eb.common.decompose.DecomposeStatus;
import kd.epm.eb.common.decompose.DynamicObjectUtil;
import kd.epm.eb.common.decompose.TaskStatus;
import kd.epm.eb.common.decompose.entity.AdjustDecomposeDetail;
import kd.epm.eb.common.decompose.entity.AdjustDecomposeRecord;
import kd.epm.eb.common.decompose.entity.BgNumberCell;
import kd.epm.eb.common.decompose.entity.DecDimension;
import kd.epm.eb.common.decompose.entity.DecomposeAgentEnum;
import kd.epm.eb.common.decompose.entity.DecomposeConstant;
import kd.epm.eb.common.decompose.entity.DecomposeSchemeStatus;
import kd.epm.eb.common.decompose.entity.DecomposeSchemeType;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.enums.AdjustDecomposeTypeEnum;
import kd.epm.eb.common.enums.AggOprtEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.adjustdecompose.AdjustServiceHelper;
import kd.epm.eb.common.utils.fileImport.entity.ImportEntity;
import kd.epm.eb.ebBusiness.serviceHelper.MemberPermHelper;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.adminmode.utils.AdminModelUtil;
import kd.epm.eb.formplugin.decompose.plugin.DecomposeTreeNode;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class DecomposeTaskPlugin
extends AbstractFormPlugin
implements TreeNodeQueryListener,
ItemClickListener,
TreeNodeClickListener,
RowClickEventListener,
TabSelectListener,
CellClickListener,
BeforeF7SelectListener {
    private DecomposeTaskService decomposeTaskService = DecomposeTaskService.getInstance();
    private DataDecomposeService dataDecomposeService = DataDecomposeService.getInstance();
    private DecomposeSchemeService decomposeSchemeService = DecomposeSchemeService.getInstance();
    private static final Log log = LogFactory.getLog(DataDecomposeService.class);
    private IModelCacheHelper modelCacheHelper;
    private String viewJson;
    private String unit;

    public IModelCacheHelper getModelCacheHelper() {
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        }
        return this.modelCacheHelper;
    }

    public void initialize() {
        super.initialize();
        TreeView treeView = (TreeView)this.getView().getControl("lefttree");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("target_entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addCellClickListener((CellClickListener)this);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addItemClickListener((ItemClickListener)this);
        tab.addTabSelectListener((TabSelectListener)this);
        tab.addClickListener((ClickListener)this);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
            return;
        }
        String column = hyperLinkClickEvent.getFieldName();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("target_entryentity");
        String dimension = (String)entryGrid.getModel().getValue("target_decdimension", rowIndex);
        String dimensionJson = (String)entryGrid.getModel().getValue("target_decdimensionjson", rowIndex);
        DynamicObject dynamicObject = this.decomposeTaskService.queryTaskById(((Long)entryGrid.getModel().getValue("targetid", rowIndex)).longValue());
        int status = dynamicObject.getInt("status");
        if (TaskStatus.WAIT.getValue() != status) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5f85\u5206\u89e3\u7684\u6570\u636e\u624d\u5141\u8bb8\u5207\u6362\u5206\u89e3\u7ef4\u5ea6\u987a\u5e8f\u3002", (String)"DecomposeTaskPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("target_decdimension".equals(column)) {
            this.getPageCache().put("dimensionIndex", String.valueOf(rowIndex));
            this.showDimensionOrderForm(dimension, dimensionJson);
        }
    }

    private void showDimensionOrderForm(String dimension, String decDimensions) {
        FormShowParameter formShow = new FormShowParameter();
        formShow.setFormId("bgm_decompose_dim_order");
        HashMap<String, String> params = new HashMap<String, String>(16);
        String replace = dimension.replace("\uff0c", ",");
        params.put("dimension", replace);
        params.put("dimensionList", decDimensions);
        formShow.setCustomParams(params);
        String caption = ResManager.loadKDString((String)"\u5206\u89e3\u7ef4\u5ea6\u987a\u5e8f\u8bbe\u7f6e", (String)"TargetSchemeListPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        formShow.setCaption(caption);
        formShow.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "dimension_order");
        formShow.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShow);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("model");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"bizmodelswitch", "searchnext", "searchbefore"});
        Toolbar mbar = (Toolbar)this.getView().getControl("toolbarap");
        mbar.addItemClickListener((ItemClickListener)this);
        Toolbar advcontoolbar = (Toolbar)this.getView().getControl("toolbarap1");
        advcontoolbar.addItemClickListener((ItemClickListener)this);
        this.addItemClickListeners(new String[]{"floatmenuap"});
        TreeEntryGrid taskTreeView = (TreeEntryGrid)this.getView().getControl("tree_entryentity");
        taskTreeView.addCellClickListener((TreeNodeQueryListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(event -> TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), this.getView(), this.getPageCache(), new TreeSearchUtil.TreeSearchParam("lefttree", "lefttreecache")));
        this.setEntryGridColor("scheme_task_entryentity", "status");
        this.setEntryGridColor("task_entryentity", "task_status");
        this.setEntryGridColor("target_entryentity", "target_status");
    }

    public void afterBindData(EventObject e) {
        try {
            super.afterBindData(e);
            IFormView formView = this.getView();
            for (int i = 1; i <= DecomposeConstant.CUSTOM_DIM_NUM; ++i) {
                formView.setVisible(Boolean.valueOf(false), new String[]{"task_customdim" + i, "target_customdim" + i});
            }
            formView.setVisible(Boolean.valueOf(false), new String[]{"btn_start", "btn_issue", "last_period"});
            this.showSchemeTask();
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        try {
            super.propertyChanged(e);
            String name = e.getProperty().getName();
            ChangeData[] changeSet = e.getChangeSet();
            int rowIndex = 0;
            if (changeSet.length > 0) {
                rowIndex = changeSet[0].getRowIndex();
            }
            String needChange = this.getPageCache().get("needChange");
            switch (name) {
                case "model": {
                    DynamicObject model = (DynamicObject)this.getModel().getValue("model");
                    if (StringUtils.isEmpty((String)needChange)) {
                        if (this.showChangeFlagConfirm("confirm_model_change")) {
                            return;
                        }
                        this.modelChanged(null);
                        UserSelectUtils.saveUserSelectModelId((IFormView)this.getView(), (long)model.getLong("id"));
                        break;
                    }
                    this.getPageCache().remove("needChange");
                    break;
                }
                case "decompose_agent": {
                    this.decomposeAgentChanged();
                    break;
                }
                case "tab_change": {
                    this.getPageCache().put("change_flag_cache", "1");
                    this.inputChange(rowIndex);
                    break;
                }
                case "tab_ratio": {
                    this.getPageCache().put("change_flag_cache", "1");
                    this.ratioChange(rowIndex);
                    break;
                }
                case "tab_result": {
                    this.getPageCache().put("change_flag_cache", "1");
                    this.resultChange(rowIndex);
                    break;
                }
            }
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
    }

    private void resultChange(int index) {
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("tree_entryentity", index);
        BigDecimal tabPendingtrial = entryRowEntity.getBigDecimal("tab_pendingtrial");
        BigDecimal tabResult = entryRowEntity.getBigDecimal("tab_result");
        if (BigDecimal.ZERO.compareTo(tabResult) != 0) {
            entryRowEntity.set("issueflag", (Object)"1");
        }
        this.setDataNoProperChange("tab_change", tabResult.subtract(tabPendingtrial), index);
        int rootIndex = this.getRootIndex(index);
        if (rootIndex == -1) {
            return;
        }
        this.sumDecomposeValue(this.getModel().getEntryEntity("tree_entryentity"), index);
        Object pid = entryRowEntity.get("pid");
        if (!Objects.equals(pid, 0L)) {
            this.enableTreeEntryEntityCell(rootIndex, false);
        }
    }

    private void ratioChange(int index) {
        int rootIndex;
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("tree_entryentity", index);
        BigDecimal tabRatio = entryRowEntity.getBigDecimal("tab_ratio");
        if (BigDecimal.ZERO.compareTo(tabRatio) != 0) {
            entryRowEntity.set("issueflag", (Object)"1");
        }
        if ((rootIndex = this.getRootIndex(index)) == -1) {
            return;
        }
        this.sumDecomposeValue(this.getModel().getEntryEntity("tree_entryentity"), index);
        Object pid = entryRowEntity.get("pid");
        if (!Objects.equals(pid, 0L)) {
            this.calcAmount(DecomposeAgentEnum.RATIO.getValue(), rootIndex);
            this.enableTreeEntryEntityCell(rootIndex, false);
        }
    }

    private void inputChange(int index) {
        boolean decomposeValid;
        int rootIndex;
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("tree_entryentity", index);
        BigDecimal tabChange = entryRowEntity.getBigDecimal("tab_change");
        if (BigDecimal.ZERO.compareTo(tabChange) != 0) {
            entryRowEntity.set("issueflag", (Object)"1");
        }
        if ((rootIndex = this.getRootIndex(index)) == -1) {
            return;
        }
        String schemeType = this.getSchemeType();
        if (DecomposeSchemeType.ADJUST.getValue().equals(schemeType)) {
            BigDecimal tabPendingtrial = entryRowEntity.getBigDecimal("tab_pendingtrial");
            this.setDataNoProperChange("tab_result", tabPendingtrial.add(tabChange), index);
        }
        this.sumDecomposeValue(this.getModel().getEntryEntity("tree_entryentity"), index);
        Object pid = entryRowEntity.get("pid");
        String decomposeAgent = (String)this.getModel().getValue("decompose_agent");
        boolean bl = decomposeValid = DecomposeAgentEnum.INPUT.getValue().equals(decomposeAgent) || DecomposeSchemeType.ADJUST.getValue().equals(schemeType) || DecomposeAgentEnum.AVG.getValue().equals(decomposeAgent) || DecomposeAgentEnum.LAST_PERIOD.getValue().equals(decomposeAgent);
        if (!Objects.equals(pid, 0L) && decomposeValid) {
            this.calcAmount(DecomposeAgentEnum.INPUT.getValue(), rootIndex);
            this.enableTreeEntryEntityCell(rootIndex, false);
        }
    }

    private void calcAmount(String type, int rootIndex) {
        block2: {
            List<Integer> childrenIndexList;
            BigDecimal tabValue;
            DynamicObjectCollection entryEntity;
            block3: {
                boolean needCalc;
                String schemeType = this.getSchemeType();
                entryEntity = this.getModel().getEntryEntity("tree_entryentity");
                DynamicObject root = (DynamicObject)entryEntity.get(rootIndex);
                tabValue = root.getBigDecimal("tab_value");
                childrenIndexList = this.getAllChildrenIndex(entryEntity, root.getLong("id"), rootIndex);
                boolean bl = needCalc = DecomposeSchemeType.TARGET.getValue().equals(schemeType) && !CollectionUtils.isEmpty(childrenIndexList);
                if (!needCalc) break block2;
                if (!DecomposeAgentEnum.INPUT.getValue().equals(type)) break block3;
                for (int i = rootIndex; i <= childrenIndexList.get(childrenIndexList.size() - 1); ++i) {
                    DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                    BigDecimal tabChange = dynamicObject.getBigDecimal("tab_change");
                    BigDecimal divide = tabChange.multiply(new BigDecimal(100)).divide(tabValue, 15, RoundingMode.HALF_UP);
                    this.setDataNoProperChange("tab_ratio", divide, i);
                }
                break block2;
            }
            if (!DecomposeAgentEnum.RATIO.getValue().equals(type)) break block2;
            for (int i = rootIndex; i <= childrenIndexList.get(childrenIndexList.size() - 1); ++i) {
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                BigDecimal tabRatio = dynamicObject.getBigDecimal("tab_ratio");
                BigDecimal divide = tabValue.multiply(tabRatio).divide(new BigDecimal(100), 15, RoundingMode.HALF_UP);
                this.setDataNoProperChange("tab_change", divide, i);
            }
        }
    }

    private void sumDecomposeValue(DynamicObjectCollection entryEntity, int index) {
        boolean validAgent;
        IDataModel dataModel = this.getModel();
        int parentIndex = this.getParentIndex(index);
        if (parentIndex == -1) {
            return;
        }
        String decomposeAgent = (String)dataModel.getValue("decompose_agent");
        String schemeType = this.getSchemeType();
        DynamicObject parentRow = (DynamicObject)entryEntity.get(parentIndex);
        Long pkValue = (Long)parentRow.getPkValue();
        List<Integer> childrenIndex = this.getChildrenIndex(dataModel.getEntryEntity("tree_entryentity"), pkValue, parentIndex);
        boolean bl = validAgent = DecomposeAgentEnum.INPUT.getValue().equals(decomposeAgent) || DecomposeAgentEnum.AVG.getValue().equals(decomposeAgent) || DecomposeAgentEnum.LAST_PERIOD.getValue().equals(decomposeAgent);
        if (DecomposeSchemeType.TARGET.getValue().equals(schemeType) && validAgent) {
            BigDecimal newData = BigDecimal.ZERO;
            for (Integer integer : childrenIndex) {
                DynamicObject rowEntity = (DynamicObject)entryEntity.get(integer.intValue());
                BigDecimal tabChange = rowEntity.getBigDecimal("tab_change");
                String tabAggoprt = rowEntity.getString("tab_aggoprt");
                newData = this.decomposeTaskService.getNewAmountByAggoprt(tabAggoprt, newData, tabChange);
            }
            this.setDataNoProperChange("tab_change", newData, parentIndex);
        } else if (DecomposeSchemeType.TARGET.getValue().equals(schemeType) && DecomposeAgentEnum.RATIO.getValue().equals(decomposeAgent)) {
            BigDecimal newData = BigDecimal.ZERO;
            for (Integer integer : childrenIndex) {
                DynamicObject rowEntity = (DynamicObject)entryEntity.get(integer.intValue());
                BigDecimal tabRatio = rowEntity.getBigDecimal("tab_ratio");
                String tabAggoprt = rowEntity.getString("tab_aggoprt");
                newData = this.decomposeTaskService.getNewAmountByAggoprt(tabAggoprt, newData, tabRatio);
            }
            this.setDataNoProperChange("tab_ratio", newData, parentIndex);
        } else {
            if (DecomposeSchemeType.TARGET.getValue().equals(schemeType) && !this.validAgent(decomposeAgent)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u89e3\u52a8\u56e0\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"DecomposeTaskPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (DecomposeSchemeType.ADJUST.getValue().equals(schemeType)) {
                BigDecimal newData = BigDecimal.ZERO;
                for (Integer integer : childrenIndex) {
                    DynamicObject rowEntity = (DynamicObject)entryEntity.get(integer.intValue());
                    BigDecimal tabChange = rowEntity.getBigDecimal("tab_change");
                    String tabAggoprt = rowEntity.getString("tab_aggoprt");
                    newData = this.decomposeTaskService.getNewAmountByAggoprt(tabAggoprt, newData, tabChange);
                }
                this.setDataNoProperChange("tab_change", newData, parentIndex);
                long pid = (Long)this.getModel().getValue("pid", parentIndex);
                if (pid != 0L || DecomposeSchemeType.TARGET.getValue().equals(schemeType)) {
                    this.setDataNoProperChange("tab_result", newData.add(parentRow.getBigDecimal("tab_pendingtrial")), parentIndex);
                }
            }
        }
        this.sumDecomposeValue(entryEntity, parentIndex);
    }

    private void setDataNoProperChange(String key, Object newData, int index) {
        this.getModel().beginInit();
        if (index != -1) {
            this.getModel().setValue(key, newData, index);
        } else {
            this.getModel().setValue(key, newData);
        }
        this.getModel().endInit();
        if (index != -1) {
            this.getView().updateView(key, index);
        } else {
            this.getView().updateView(key);
        }
    }

    private List<Integer> getChildrenIndex(DynamicObjectCollection entryEntity, Long pkValue, int index) {
        LinkedList<Integer> children = new LinkedList<Integer>();
        for (int i = index + 1; i < entryEntity.size(); ++i) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("tree_entryentity", i);
            Long pid = (Long)entryRowEntity.get("pid");
            if (Objects.equals(pkValue, pid)) {
                children.add(i);
                continue;
            }
            if (pid == 0L) break;
        }
        return children;
    }

    private List<Integer> getAllChildrenIndex(DynamicObjectCollection entryEntity, Long pkValue, int index) {
        LinkedList<Integer> children = new LinkedList<Integer>();
        LinkedList<Long> pidList = new LinkedList<Long>();
        pidList.add(pkValue);
        for (int i = index + 1; i < entryEntity.size(); ++i) {
            DynamicObject entryRowEntity = (DynamicObject)entryEntity.get(i);
            Long pid = (Long)entryRowEntity.get("pid");
            if (pidList.contains(pid)) {
                children.add(i);
                pidList.add(entryRowEntity.getLong("id"));
                continue;
            }
            if (pid == 0L) break;
        }
        return children;
    }

    private int getParentIndex(int index) {
        if (index == 0) {
            return -1;
        }
        IDataModel model = this.getModel();
        Long pid = model.getEntryRowEntity("tree_entryentity", index).getLong("pid");
        for (int i = index - 1; i >= 0; --i) {
            DynamicObject entryRowEntity = model.getEntryRowEntity("tree_entryentity", i);
            Long pkValue = (Long)entryRowEntity.getPkValue();
            if (!Objects.equals(pkValue, pid)) continue;
            return i;
        }
        return -1;
    }

    private int getRootIndex(int index) {
        if (index == 0) {
            return -1;
        }
        IDataModel model = this.getModel();
        Long pid = model.getEntryRowEntity("tree_entryentity", index).getLong("pid");
        if (Objects.equals(pid, 0L)) {
            return index;
        }
        for (int i = index - 1; i >= 0; --i) {
            DynamicObject entryRowEntity = model.getEntryRowEntity("tree_entryentity", i);
            Long pkValue = (Long)entryRowEntity.getPkValue();
            if (!Objects.equals(pkValue, pid)) continue;
            if (entryRowEntity.getLong("pid") == 0L) {
                return i;
            }
            return this.getRootIndex(i);
        }
        return -1;
    }

    private boolean validAgent(String agent) {
        DecomposeAgentEnum[] values = DecomposeAgentEnum.values();
        boolean include = false;
        for (DecomposeAgentEnum decomposeAgentEnum : values) {
            if (!decomposeAgentEnum.getValue().equals(agent)) continue;
            include = true;
            break;
        }
        return include;
    }

    private void decomposeAgentChanged() {
        String value = (String)this.getModel().getValue("decompose_agent");
        if (this.validAgent(value)) {
            String needConfirm = this.getPageCache().get("needConfirm");
            if (DecomposeAgentEnum.LAST_PERIOD.getValue().equals(value) || DecomposeAgentEnum.AVG.getValue().equals(value)) {
                if (StringUtils.isEmpty((String)needConfirm)) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u7ee7\u7eed\u64cd\u4f5c\u5c06\u4f1a\u6e05\u9664\u672a\u4fdd\u5b58\u7684\u6570\u636e\uff0c\u662f\u5426\u786e\u8ba4\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"DecomposeTaskPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirm_agent_change", (IFormPlugin)this));
                    return;
                }
            } else {
                this.enableTreeEntryEntityCell(0, true);
            }
            this.getPageCache().put("decompose_agent", value);
        } else if (StringUtils.isEmpty((String)value) && DecomposeSchemeType.TARGET.getValue().equals(this.getSchemeType())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u89e3\u52a8\u56e0\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"DecomposeTaskPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.setLastPeriodVisible();
    }

    private void setLastPeriodVisible() {
        String value = (String)this.getModel().getValue("decompose_agent");
        this.getView().setVisible(Boolean.valueOf(DecomposeAgentEnum.LAST_PERIOD.getValue().equals(value)), new String[]{"last_period"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        try {
            String key = ((Control)evt.getSource()).getKey();
            if ("bizmodelswitch".equals(key)) {
                this.showBizModelForm();
            } else if ("searchbefore".equals(key)) {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam("lefttree", "lefttreecache", TreeSearchUtil.SearchBtnStatus.LEFT));
            } else if ("searchnext".equals(key)) {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam("lefttree", "lefttreecache", TreeSearchUtil.SearchBtnStatus.RIGHT));
            }
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
    }

    private boolean showChangeFlagConfirm(String callBackId) {
        String changeFlag = this.getPageCache().get("change_flag_cache");
        if ("1".equals(changeFlag)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5206\u89e3\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u7ee7\u7eed\u64cd\u4f5c\u5c06\u4f1a\u6e05\u9664\u672a\u4fdd\u5b58\u7684\u6570\u636e\uff0c\u662f\u5426\u786e\u8ba4\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"DecomposeTaskPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(callBackId, (IFormPlugin)this));
            return true;
        }
        return false;
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        AdminModelUtil.checkAdminModeBeforeItemClick(evt, this.getModelId(), this.getView(), Sets.newHashSet((Object[])new String[]{"btn_exit"}));
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        try {
            String key;
            switch (key = evt.getItemKey()) {
                case "btn_start": {
                    this.start();
                    break;
                }
                case "dec_submit": {
                    this.submitDecLog(true, true);
                    break;
                }
                case "dec_save": {
                    this.submitDecLog(false, true);
                    break;
                }
                case "btn_issue": {
                    this.beforeIssue();
                    break;
                }
                case "btn_cancel": {
                    this.cancel();
                    break;
                }
                case "btn_unit": 
                case "btn_unit4": {
                    this.setUnitTitle(key);
                    break;
                }
                case "btn_refresh": {
                    this.btnRefresh();
                    break;
                }
                case "btn_done": {
                    this.complete();
                    break;
                }
                case "floatmenuitemap": {
                    this.showFloat();
                    break;
                }
                case "clear_value": {
                    this.clearValue();
                    break;
                }
                case "btn_export": {
                    this.exportData();
                    break;
                }
                case "btn_import": {
                    this.openImportPage();
                    break;
                }
            }
        }
        catch (Exception ex) {
            log.error(CommonServiceHelper.getStackTraceStr((Throwable)ex));
            throw new KDBizException(ex.getMessage());
        }
    }

    private void openImportPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("decompose_import");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u5bfc\u5165", (String)"DecomposeTaskPlugin_50", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "close_import");
        showParameter.setCloseCallBack(callBack);
        this.getView().showForm(showParameter);
    }

    private void exportData() {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        String schemeType = this.getSchemeType();
        String agent = (String)this.getModel().getValue("decompose_agent");
        long taskId = Long.parseLong(this.getPageCache().get("currentTaskId"));
        DynamicObject task = this.getTask(taskId);
        String decDimensionJson = task.getString("decdimensionjson");
        List decDimensions = JSONArray.parseArray((String)decDimensionJson, DecDimension.class);
        DecDimension decDimension = this.getDecDimension();
        ImportEntity importEntity = this.decomposeTaskService.prepareTemplateData(modelCache, schemeType, decDimensions, decDimension.getDimNumber(), agent);
        Map sheetHeaderMap = importEntity.getSheetHeaderMap();
        ArrayList dataList = new ArrayList(10);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("tree_entryentity");
        Long viewId = this.getViewId(decDimension.getDimNumber());
        for (DynamicObject dynamicObject : entryEntity) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>(sheetHeaderMap.size());
            String src = dynamicObject.getString("tab_dimensionjson");
            Map demensionMap = this.decomposeTaskService.stringtoMap(src);
            Member decMember = this.decomposeTaskService.getMemberFromJson(modelCache, demensionMap, decDimension.getDimNumber(), viewId);
            for (DecDimension dimension : decDimensions) {
                Member member = this.decomposeTaskService.getMemberFromJson(modelCache, demensionMap, dimension.getDimNumber(), Long.valueOf(0L));
                dataMap.put(dimension.getDimNumber(), member.getName());
            }
            dataMap.put("pid", dynamicObject.getLong("pid"));
            dataMap.put("id", dynamicObject.getLong("id"));
            dataMap.put("number", decMember.getNumber());
            dataMap.put("parentNumber", decMember.getParentNumber());
            Member parent = modelCache.getMember(decDimension.getDimNumber(), viewId, decMember.getParentNumber());
            if (parent != null) {
                dataMap.put("grandParentNumber", parent.getParentNumber());
            }
            long pid = dynamicObject.getLong("pid");
            BigDecimal value = dynamicObject.getBigDecimal("tab_value");
            BigDecimal change = dynamicObject.getBigDecimal("tab_change");
            dataMap.put("change", change);
            if (pid == 0L) {
                dataMap.put("value", value);
            }
            if (DecomposeSchemeType.ADJUST.getValue().equals(schemeType)) {
                BigDecimal totalValue = dynamicObject.getBigDecimal("tab_result");
                BigDecimal pendingtrial = dynamicObject.getBigDecimal("tab_pendingtrial");
                dataMap.put("pendingtrial", pendingtrial);
                dataMap.put("result", totalValue);
                dataList.add(dataMap);
                continue;
            }
            if (!DecomposeSchemeType.TARGET.getValue().equals(schemeType)) continue;
            BigDecimal ratio = dynamicObject.getBigDecimal("tab_ratio");
            dataMap.put("ratio", ratio);
            dataList.add(dataMap);
        }
        String url = this.decomposeTaskService.exportData(importEntity, dataList);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
        this.writeLog("export", new MultiLangEnumBridge("\u5bfc\u51fa", "RelQueryExecuteRecordPlugin_46", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5bfc\u51fa\u6210\u529f\u3002", "RelQueryExecuteRecordPlugin_45", "epm-eb-formplugin"));
    }

    private void clearValue() {
        DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity("tree_entryentity");
        IFormView view = this.getView();
        for (DynamicObject dynamicObject : entryEntitys) {
            if (DecomposeSchemeType.ADJUST.getValue().equals(this.getSchemeType())) {
                BigDecimal pendingtrial = dynamicObject.getBigDecimal("tab_pendingtrial");
                dynamicObject.set("tab_result", (Object)pendingtrial);
            }
            dynamicObject.set("tab_ratio", (Object)BigDecimal.ZERO);
            dynamicObject.set("tab_change", (Object)BigDecimal.ZERO);
            dynamicObject.set("issueflag", (Object)"1");
        }
        view.updateView("tree_entryentity");
        this.enableTreeEntryEntityCell(0, true);
    }

    private void showFloat() {
        String showFloat = this.getPageCache().get("showFloat");
        if ("false".equals(showFloat)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flex_float"});
            this.getPageCache().put("showFloat", "true");
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flex_float"});
            this.getPageCache().put("showFloat", "false");
        }
    }

    private Long getSchemeIdFromNodeId(String focusNodeId) {
        if (StringUtils.isNotEmpty((String)focusNodeId)) {
            String[] strings = focusNodeId.split("!");
            return Long.parseLong(strings[0]);
        }
        return 0L;
    }

    private Long getEntityIdFromNodeId(String focusNodeId) {
        if (StringUtils.isNotEmpty((String)focusNodeId)) {
            String[] strings = focusNodeId.split("!");
            return Long.parseLong(strings[strings.length - 1]);
        }
        return 0L;
    }

    private void complete() {
        TreeView tree = (TreeView)this.getView().getControl("lefttree");
        Long schemeId = this.getSchemeIdFromNodeId(tree.getTreeState().getFocusNodeId());
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"eb_decompose_scheme", (String)"id,status");
        if (dynamicObject != null) {
            String status = dynamicObject.getString("status");
            if (!DecomposeSchemeStatus.FINISHED.getNumber().equals(status)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5206\u89e3\u65b9\u6848\u8fd8\u5b58\u5728\u672a\u5b8c\u6210\u5206\u89e3\u7684\u6570\u636e\uff0c\u65b9\u6848\u8bbe\u7f6e\u5206\u89e3\u5b8c\u6210\u540e\uff0c\u5c06\u4e0d\u80fd\u7ee7\u7eed\u8fdb\u884c\u76ee\u6807\u5206\u89e3\u3002", (String)"DecomposeTaskPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirm_complete", (IFormPlugin)this));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u5206\u89e3\u5b8c\u6210\u3002", (String)"DecomposeTaskPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        try {
            switch (callBackId) {
                case "confirm_complete": {
                    if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                    TreeView tree = (TreeView)this.getView().getControl("lefttree");
                    String focusNodeId = tree.getTreeState().getFocusNodeId();
                    long schemeId = this.getSchemeIdFromNodeId(focusNodeId);
                    this.decomposeTaskService.updateSchemeStatus(schemeId, DecomposeSchemeStatus.FINISHED);
                    this.finishDecomposeTask(schemeId);
                    break;
                }
                case "confirm_select": {
                    if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                    EntryGrid entryGrid = (EntryGrid)this.getView().getControl("target_entryentity");
                    String dimensionIndex = this.getPageCache().get("dimensionIndex");
                    int index = Integer.parseInt(dimensionIndex);
                    String newDimension = this.getPageCache().get("newDimension");
                    entryGrid.getModel().setValue("target_decdimension", (Object)newDimension, index);
                    this.saveTargetDecDimension();
                    entryGrid.clickCell("target_status", index);
                    break;
                }
                case "confirm_refresh": {
                    if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                    this.getPageCache().put("change_flag_cache", "0");
                    this.refreshTabData();
                    break;
                }
                case "confirm_model_change": {
                    if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                        this.getPageCache().put("change_flag_cache", "0");
                        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
                        UserSelectUtils.saveUserSelectModelId((IFormView)this.getView(), (long)model.getLong("id"));
                        this.setDefaultBusinessModel(null);
                        break;
                    }
                    this.getPageCache().put("needChange", "false");
                    this.getModel().setValue("model", (Object)Long.parseLong(this.getPageCache().get("model")));
                    break;
                }
                case "confirm_tab_select": {
                    Tab tab = (Tab)this.getView().getControl("tabap");
                    if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                        this.getPageCache().put("change_flag_cache", "0");
                        String selectTab = this.getPageCache().get("selectTab");
                        tab.selectTab(selectTab);
                        break;
                    }
                    String currentTab = this.getPageCache().get("currentTab");
                    tab.activeTab(currentTab);
                    break;
                }
                case "confirm_bizmodel_change": {
                    if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                    this.getPageCache().put("change_flag_cache", "0");
                    String bizModelIdStr = this.getPageCache().get("bizModelId");
                    this.businessModelChanged(Long.parseLong(bizModelIdStr));
                    break;
                }
                case "confirm_tree_click": {
                    if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                    TreeView tv = (TreeView)this.getView().getControl("lefttree");
                    String focusNodeId = tv.getTreeState().getFocusNodeId();
                    this.treeClick(focusNodeId);
                    this.getPageCache().put("change_flag_cache", "0");
                    break;
                }
                case "confirm_agent_change": {
                    String value = (String)this.getModel().getValue("decompose_agent");
                    if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                        this.agentChange(0);
                        this.getPageCache().put("decompose_agent", value);
                    } else {
                        String agent = this.getPageCache().get("decompose_agent");
                        if (DecomposeAgentEnum.LAST_PERIOD.getValue().equals(agent) || DecomposeAgentEnum.AVG.getValue().equals(agent)) {
                            this.getPageCache().put("needConfirm", "false");
                        }
                        this.getModel().setValue("decompose_agent", (Object)agent);
                    }
                    this.getPageCache().remove("needConfirm");
                    break;
                }
                case "confirm_cell_click": {
                    EntryGrid entryGrid = (EntryGrid)this.getView().getControl("target_entryentity");
                    if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                        int focusRow = entryGrid.getEntryState().getFocusRow();
                        this.getPageCache().put("change_flag_cache", "0");
                        this.doCellClick("target_entryentity", focusRow);
                        break;
                    }
                    int currentIndex = Integer.parseInt(this.getPageCache().get("currentIndex"));
                    entryGrid.selectRows(currentIndex);
                    break;
                }
                case "confirm_issue_click": {
                    if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                    this.issue();
                    break;
                }
                case "confirm_cancel_decompose": {
                    if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                    ArrayList<Long> idList = new ArrayList<Long>(10);
                    if (this.getCancelIdList(idList).booleanValue()) {
                        this.doCancel(idList);
                    }
                    break;
                }
            }
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
    }

    private void putViewJsonIntoCache(String viewJson) {
        this.getView().getPageCache().put("viewjson", viewJson);
    }

    private String getViewJson() {
        if (this.viewJson == null) {
            this.viewJson = this.getView().getPageCache().get("viewjson");
        }
        return this.viewJson;
    }

    private void agentChange(int rootIndex) {
        String agent = (String)this.getModel().getValue("decompose_agent");
        if (this.validAgent(agent)) {
            this.setLastPeriodVisible();
            if (!DecomposeAgentEnum.AVG.getValue().equals(agent) && !DecomposeAgentEnum.LAST_PERIOD.getValue().equals(agent)) {
                this.enableTreeEntryEntityCell(rootIndex, true);
            }
            this.getPageCache().put("agentChange", agent);
            Tab tab = (Tab)this.getView().getControl("tabap");
            String currentTab = tab.getCurrentTab();
            this.getPageCache().remove("change_flag_cache");
            this.initTabData(currentTab);
            this.getPageCache().remove("agentChange");
        }
    }

    private void finishDecomposeTask(Long schemeId) {
        DynamicObject[] dynamicObjects;
        for (DynamicObject dynamicObject : dynamicObjects = this.decomposeTaskService.queryTaskBySchemeId(schemeId.longValue())) {
            dynamicObject.set("status", (Object)TaskStatus.DONE.getValue());
            DynamicObjectUtil.init2Update((DynamicObject)dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        this.btnRefresh();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u89e3\u5df2\u5b8c\u6210\u3002", (String)"DecomposeTaskPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void activeNextTab() {
        List decDimensions;
        Tab tab = (Tab)this.getView().getControl("tabap");
        String currentTab = tab.getCurrentTab();
        int next = Integer.parseInt(currentTab.replace("dimenpage", "")) + 1;
        if (next <= (decDimensions = JSONArray.parseArray((String)this.getPageCache().get("thisDecdimensionjsonCache"), DecDimension.class)).size()) {
            String nextTab = "dimenpage" + next;
            tab.activeTab(nextTab);
            tab.selectTab(nextTab);
        }
    }

    private void btnRefresh() {
        String panel = this.getPageCache().get("panel");
        if ("scheme_taskpanel".equals(panel) || "entity_taskpanel".equals(panel)) {
            this.buildLeftTreeData(this.getModelId(), this.getBizModelId(), false);
            TreeView tv = (TreeView)this.getView().getControl("lefttree");
            String focusNodeId = tv.getTreeState().getFocusNodeId();
            if (StringUtils.isNotEmpty((String)focusNodeId)) {
                this.treeClick(focusNodeId);
            }
        } else if ("decompose_targetpanel".equals(panel)) {
            if (this.showChangeFlagConfirm("confirm_refresh")) {
                return;
            }
            this.refreshTabData();
            DynamicObjectCollection taskEntryEntity = this.getModel().getEntryEntity("target_entryentity");
            List taskIds = taskEntryEntity.stream().map(e -> e.getLong("targetid")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "in", taskIds);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_decompose_task", (String)"id,value", (QFilter[])qFilter.toArray());
            block0: for (DynamicObject dynamicObject : taskEntryEntity) {
                for (DynamicObject object : dynamicObjects) {
                    if (!IDUtils.equals((Object)dynamicObject.getLong("targetid"), (Object)object.getLong("id"))) continue;
                    dynamicObject.set("target_value", (Object)this.getNewAmount(object.getBigDecimal("value")));
                    continue block0;
                }
            }
            this.getView().updateView("target_entryentity");
        }
    }

    private void setUnitTitle(String key) {
        String unit = this.getUnit();
        if (unit == null) {
            this.setUnit("0");
            unit = "0";
        }
        HashMap map = new HashMap(1);
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        if ("btn_unit".equals(key) && !StringUtils.equals((String)"0", (String)unit)) {
            this.setUnit("0");
            this.refreshAmount();
            hashMap.put("zh_CN", "--");
        } else if ("btn_unit4".equals(key) && !StringUtils.equals((String)"4", (String)unit)) {
            this.setUnit("4");
            this.refreshAmount();
            hashMap.put("zh_CN", ResManager.loadKDString((String)"\u4e07", (String)"DecomposeTaskPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        map.put("text", hashMap);
        this.getView().updateControlMetadata("unit", map);
    }

    private void refreshAmount() {
        DynamicObjectCollection taskEntryEntity = this.getModel().getEntryEntity("task_entryentity");
        for (Object dynamicObject : taskEntryEntity) {
            BigDecimal taskValue = (BigDecimal)dynamicObject.get("task_value");
            dynamicObject.set("task_value", this.getRefreshAmount(taskValue));
        }
        this.getView().updateView("task_entryentity");
        this.setEntryGridColor("task_entryentity", "task_status");
        DynamicObjectCollection targetEntryEntity = this.getModel().getEntryEntity("target_entryentity");
        for (DynamicObject dynamicObject : targetEntryEntity) {
            BigDecimal targetValue = (BigDecimal)dynamicObject.get("target_value");
            dynamicObject.set("target_value", this.getRefreshAmount(targetValue));
        }
        this.getView().updateView("target_entryentity");
        this.setEntryGridColor("target_entryentity", "target_status");
        DynamicObjectCollection treeEntryEntity = this.getModel().getEntryEntity("tree_entryentity");
        for (DynamicObject dynamicObject : treeEntryEntity) {
            BigDecimal tabValue = (BigDecimal)dynamicObject.get("tab_value");
            BigDecimal tabPendingtrial = (BigDecimal)dynamicObject.get("tab_pendingtrial");
            BigDecimal tabChange = (BigDecimal)dynamicObject.get("tab_change");
            BigDecimal tabResult = (BigDecimal)dynamicObject.get("tab_result");
            BigDecimal lastPeriod = (BigDecimal)dynamicObject.get("last_period");
            dynamicObject.set("tab_value", this.getRefreshAmount(tabValue));
            dynamicObject.set("tab_pendingtrial", this.getRefreshAmount(tabPendingtrial));
            dynamicObject.set("tab_change", this.getRefreshAmount(tabChange));
            dynamicObject.set("tab_result", this.getRefreshAmount(tabResult));
            dynamicObject.set("last_period", this.getRefreshAmount(lastPeriod));
        }
        this.getView().updateView("tree_entryentity");
        this.enableTreeEntryEntityCell(0, true);
    }

    private Object getRefreshAmount(BigDecimal value) {
        String unit = this.getUnit();
        if (StringUtils.equals((String)"0", (String)unit)) {
            return value.multiply(new BigDecimal(10000));
        }
        if (StringUtils.equals((String)"4", (String)unit)) {
            return value.divide(new BigDecimal(10000), 15, RoundingMode.HALF_UP);
        }
        return BigDecimal.ZERO;
    }

    private Boolean getSelecttaskIdList(List<Long> taskIdList) {
        EntryGrid taskEntryGrid = (EntryGrid)this.getView().getControl("task_entryentity");
        int[] selectRows = taskEntryGrid.getSelectRows();
        if (selectRows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"DecomposeSchemePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        for (int fromRowId : selectRows) {
            String decdimension = (String)taskEntryGrid.getModel().getValue("task_decdimension", fromRowId);
            if (StringUtils.isEmpty((String)decdimension)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u5f85\u5206\u89e3\u7684\u7ef4\u5ea6\u3002", (String)"DecomposeTaskPlugin_51", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            Long taskId = (Long)taskEntryGrid.getModel().getValue("taskid", fromRowId);
            taskIdList.add(taskId);
        }
        return true;
    }

    private Boolean getCancelIdList(List<Long> idList) {
        EntryGrid taskEntryGrid = (EntryGrid)this.getView().getControl("task_entryentity");
        EntryGrid targetEntryGrid = (EntryGrid)this.getView().getControl("target_entryentity");
        int[] taskSelectRows = taskEntryGrid.getSelectRows();
        int[] targetSelectRows = targetEntryGrid.getSelectRows();
        if (taskSelectRows.length < 1 && targetSelectRows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"DecomposeSchemePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (taskSelectRows.length >= 1 && targetSelectRows.length < 1) {
            for (int taskSelectRow : taskSelectRows) {
                String status = (String)taskEntryGrid.getModel().getValue("task_status", taskSelectRow);
                if (!TaskStatus.START.getText().equals(status)) continue;
                Long taskId = (Long)taskEntryGrid.getModel().getValue("taskid", taskSelectRow);
                idList.add(taskId);
            }
        } else if (taskSelectRows.length < 1) {
            for (int targetSelect : targetSelectRows) {
                String status = (String)taskEntryGrid.getModel().getValue("target_status", targetSelect);
                if (!TaskStatus.START.getText().equals(status)) continue;
                Long taskId = (Long)targetEntryGrid.getModel().getValue("targetid", targetSelect);
                idList.add(taskId);
            }
        }
        if (CollectionUtils.isEmpty(idList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5904\u7406\u4e2d\u7684\u4efb\u52a1\u5141\u8bb8\u53d6\u6d88\u5206\u89e3\u3002", (String)"DecomposeTaskPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void start() {
        LinkedList<Long> taskIdList = new LinkedList<Long>();
        if (this.getSelecttaskIdList(taskIdList).booleanValue()) {
            this.showDecomposeTarget();
            this.getModel().deleteEntryData("target_entryentity");
            QFilter qFilter = new QFilter("id", "in", taskIdList);
            this.putTaskByEntryEntityKey(qFilter, "target_entryentity");
        }
    }

    private void cancel() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
        if (scheme == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5206\u89e3\u65b9\u6848\u4e0d\u5b58\u5728\u3002", (String)"DecomposeTaskPlugin_53", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (!DecomposeSchemeStatus.START.getNumber().equals(scheme.getString("status"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5206\u89e3\u4e2d\u7684\u65b9\u6848\u5141\u8bb8\u53d6\u6d88\u5206\u89e3\u3002", (String)"DecomposeTaskPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        LinkedList<Long> taskIdList = new LinkedList<Long>();
        if (this.getCancelIdList(taskIdList).booleanValue()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u4f1a\u5c06\u5f85\u5206\u89e3\u503c\u91cd\u65b0\u5e73\u5747\u5206\u89e3\u81f3\u660e\u7ec6\u6210\u5458\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u53d6\u6d88\u5206\u89e3\uff1f", (String)"DecomposeTaskPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirm_cancel_decompose", (IFormPlugin)this));
        }
    }

    private void doCancel(List<Long> taskIdList) {
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        DynamicObject[] tasks = this.decomposeTaskService.queryTaskByIds(taskIdList);
        boolean present = Arrays.stream(tasks).anyMatch(dynamicObject -> TaskStatus.START.getValue().intValue() != dynamicObject.getInt("status"));
        if (present) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5904\u7406\u4e2d\u7684\u4efb\u52a1\u5141\u8bb8\u53d6\u6d88\u5206\u89e3\u3002", (String)"DecomposeTaskPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<BgNumberCell> numberCells = new ArrayList<BgNumberCell>(tasks.length);
        for (DynamicObject task : tasks) {
            if (TaskStatus.WAIT.getValue().intValue() == task.getInt("status")) continue;
            String decdimensionjson = task.getString("decdimensionjson");
            List decDimensions = JSONArray.parseArray((String)decdimensionjson, DecDimension.class);
            for (DecDimension decDimension : decDimensions) {
                decDimension.setStatus(DecomposeStatus.WAIT.getValue());
                decDimension.setAgent(DecomposeAgentEnum.INPUT.getValue());
            }
            task.set("decdimensionjson", (Object)JSONArray.toJSONString((Object)decDimensions));
            task.set("status", (Object)TaskStatus.WAIT.getValue());
            DynamicObjectUtil.init2Update((DynamicObject)task);
            String srcdimensionjson = task.getString("srcdimensionjson");
            Map memberMap = this.decomposeTaskService.stringtoMap(srcdimensionjson);
            long taskId = task.getLong("id");
            QFilter qFilter = new QFilter("task", "=", (Object)taskId);
            DynamicObjectCollection logs = QueryServiceHelper.query((String)"eb_decompose_log", (String)"id", (QFilter[])qFilter.toArray());
            List logIds = logs.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            DeleteServiceHelper.delete((String)"eb_decompose_log", (QFilter[])qFilter.toArray());
            logIds.add(taskId);
            DeleteServiceHelper.delete((String)"eb_decomposeadjust", (QFilter[])new QFilter("eb_decomposeadjustsub.decomposetask", "in", logIds).toArray());
            Long datasetId = DecDimensionUtil.getDatasetId((IModelCacheHelper)modelCacheHelper, (Map)memberMap);
            BgNumberCell bgNumberCell = new BgNumberCell(datasetId, memberMap, task.getBigDecimal("value"));
            numberCells.add(bgNumberCell);
        }
        this.addOlapAuditLog();
        this.dataDecomposeService.avgToDetail(this.getModelId().longValue(), numberCells);
        SaveServiceHelper.save((DynamicObject[])tasks);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6210\u529f\u3002", (String)"DecomposeTaskPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.updateViewStatus();
    }

    private void updateViewStatus() {
        EntryGrid taskEntryGrid = (EntryGrid)this.getControl("task_entryentity");
        EntryGrid targetEntryGrid = (EntryGrid)this.getControl("target_entryentity");
        DynamicObject[] dataEntitys = targetEntryGrid.getEntryData().getDataEntitys();
        int[] taskSelectRows = taskEntryGrid.getSelectRows();
        int[] targetSelectRows = targetEntryGrid.getSelectRows();
        if (taskSelectRows.length >= 1) {
            this.getTaskByEntity();
        } else if (targetSelectRows.length >= 1) {
            ArrayList<Long> idList = new ArrayList<Long>(10);
            this.updateTreeNodeStatus(DecomposeStatus.WAIT.getText());
            for (int i = 0; i < dataEntitys.length; ++i) {
                Long id = (Long)this.getModel().getValue("targetid", i);
                idList.add(id);
                this.getModel().setValue("target_status", (Object)TaskStatus.WAIT.getText(), i);
            }
            QFilter qFilter = new QFilter("id", "in", idList);
            this.getPageCache().remove("lastPeriodMap");
            this.getPageCache().remove("avgMap");
            this.getPageCache().put("change_flag_cache", "0");
            this.putTaskByEntryEntityKey(qFilter, "target_entryentity");
        }
        this.enableTreeEntryEntityCell(0, true);
    }

    private void validScheme() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
        DynamicObject schemeFromDb = BusinessDataServiceHelper.loadSingle((Object)scheme.getPkValue(), (String)"eb_decompose_scheme", (String)"id,status,type");
        if (schemeFromDb == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u65b9\u6848\u4e0d\u5b58\u5728\u3002", (String)"DecomposeTaskPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (!DecomposeSchemeStatus.START.getNumber().equals(schemeFromDb.getString("status"))) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u4ec5\u5141\u8bb8\u64cd\u4f5c\u5206\u89e3\u4e2d\u7684\u65b9\u6848\u3002", (String)"DecomposeTaskPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void submitDecLog(boolean isSubmit, boolean showTip) {
        this.validScheme();
        this.getPageCache().put("change_flag_cache", "0");
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
        IModelCacheHelper modelCacheContext = this.getModelCacheHelper();
        DecDimension thisDecDimension = this.getDecDimension();
        if (thisDecDimension == null) {
            return;
        }
        Long taskId = Long.parseLong(this.getPageCache().get("currentTaskId"));
        DynamicObject task = this.getTask(taskId);
        if (TaskStatus.DONE.getValue().intValue() == task.getInt("status")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u72b6\u6001\u4e3a\u5df2\u5904\u7406\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u6216\u4fdd\u5b58\u3002", (String)"DecomposeTaskPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (TaskStatus.DONE.getValue().equals(thisDecDimension.getStatus())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5206\u89e3\u6570\u636e\u4e0d\u5141\u8bb8\u518d\u6b21\u63d0\u4ea4\u6216\u4fdd\u5b58\u3002", (String)"DecomposeTaskPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String cur_decDimensionJson_cache = this.getPageCache().get("thisDecdimensionjsonCache");
        String cur_this_decDimension_cache = this.getPageCache().get("thisDecDimensionCache");
        List decDimensions = JSONArray.parseArray((String)this.getPageCache().get("thisDecdimensionjsonCache"), DecDimension.class);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("tree_entryentity");
        DynamicObjectCollection decomposeLogs = new DynamicObjectCollection();
        ArrayList<AdjustDecomposeRecord> decomposeAdjusts = new ArrayList<AdjustDecomposeRecord>(10);
        HashSet<Long> idList = new HashSet<Long>(16);
        HashSet<Long> pidList = new HashSet<Long>(16);
        HashMap<Long, BigDecimal> pendingtrialMap = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, BigDecimal> changeMap = new HashMap<Long, BigDecimal>(16);
        Long parent = 0L;
        String viewJson = this.getViewJson();
        String schemeType = this.getSchemeType();
        Long entityViewId = this.getEntityViewId(scheme.getLong("id"));
        boolean hasIssueFlag = false;
        for (DynamicObject entryRowEntity : entryEntity) {
            Member metricMember;
            long id = entryRowEntity.getLong("id");
            long pid = entryRowEntity.getLong("pid");
            BigDecimal value = this.getNewSaveAmount(entryRowEntity.getBigDecimal("tab_value"));
            BigDecimal change = this.getNewSaveAmount(entryRowEntity.getBigDecimal("tab_change"));
            BigDecimal pendingtrial = this.getNewSaveAmount(entryRowEntity.getBigDecimal("tab_pendingtrial"));
            String srcdimensionjson = entryRowEntity.getString("tab_dimensionjson");
            Map srcdimensionMap = this.decomposeTaskService.stringtoMap(srcdimensionjson);
            List list = DecDimensionUtil.getDecDimensionListFromSrc((IModelCacheHelper)modelCacheContext, (String)srcdimensionjson, (String)viewJson, (DynamicObject)scheme);
            if (pid != 0L) {
                idList.add(id);
                DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"eb_decompose_log");
                log.set("id", (Object)id);
                log.set("pid", (Object)pid);
                log.set("task", (Object)taskId);
                log.set("value", (Object)change);
                log.set("change", (Object)change);
                log.set("pendingtrial", (Object)pendingtrial);
                log.set("parent", (Object)parent);
                String issueFlag = entryRowEntity.getString("issueflag");
                if (BigDecimal.ZERO.compareTo(change) != 0 && StringUtils.equals((String)issueFlag, (String)"1")) {
                    hasIssueFlag = true;
                }
                log.set("issueflag", (Object)issueFlag);
                log.set("srcdimensionjson", (Object)AdjustServiceHelper.toJsonString((Map)srcdimensionMap));
                if (isSubmit) {
                    boolean isLeaf = false;
                    if (list.size() < 1) {
                        isLeaf = true;
                        log.set("status", (Object)DecomposeStatus.DONE.getValue());
                    }
                    if (BigDecimal.ZERO.compareTo(change) != 0 && "1".equals(entryRowEntity.getString("issueflag"))) {
                        decomposeAdjusts.add(this.getAdjustDynamicObject(id, modelCacheContext, entryRowEntity, isLeaf, entityViewId, schemeType));
                    }
                    DecDimensionUtil.setDecDimension((DynamicObject)log, (DecDimension)thisDecDimension);
                    log.set("submitflag", (Object)"1");
                } else {
                    log.set("submitflag", (Object)"0");
                }
                decomposeLogs.add((Object)log);
                continue;
            }
            hasIssueFlag = false;
            parent = id;
            pidList.add(parent);
            pendingtrialMap.put(parent, pendingtrial);
            changeMap.put(parent, change);
            if (!isSubmit || value.compareTo(change) == 0 || !(metricMember = modelCacheContext.getMember(SysDimensionEnum.Metric.getNumber(), null, (String)srcdimensionMap.get(SysDimensionEnum.Metric.getNumber()))).hasAgg()) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u89e3\u76ee\u6807\u503c\u4e0d\u7b49\u4e8e\u5206\u89e3\u503c\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"DecomposeTaskPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!hasIssueFlag) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6709\u6548\u7684\u5206\u89e3\u503c\uff0c\u8bf7\u5728\u53ef\u7f16\u8f91\u7684\u5355\u5143\u683c\u4e2d\u5f55\u5165\u5206\u89e3\u503c\u3002", (String)"DecomposeTaskPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (decomposeLogs.isEmpty()) {
            return;
        }
        try (TXHandle tx = TX.required((String)"submitDecLog");){
            try {
                DynamicObject[] logs;
                QFilter qFilter = new QFilter("id", "in", idList);
                DeleteServiceHelper.delete((String)"eb_decompose_log", (QFilter[])qFilter.toArray());
                SaveServiceHelper.save((DynamicObject[])((DynamicObject[])decomposeLogs.toArray((Object[])new DynamicObject[0])));
                for (DynamicObject log : logs = this.decomposeTaskService.queryDecLogsByIds(pidList)) {
                    if (isSubmit) {
                        log.set("status", (Object)DecomposeStatus.DONE.getValue());
                    }
                    if (decDimensions == null || decDimensions.size() <= 0 || !((DecDimension)decDimensions.get(0)).getDimNumber().equals(thisDecDimension.getDimNumber())) continue;
                    log.set("pendingtrial", pendingtrialMap.get(log.getLong("id")));
                    log.set("change", changeMap.get(log.getLong("id")));
                }
                SaveServiceHelper.save((DynamicObject[])logs);
                this.updateDecomposeTask(task, thisDecDimension, entryEntity, isSubmit);
                if (isSubmit) {
                    this.updateAdjustSub(pidList, taskId);
                    AdjustServiceHelper.saveAdjustDecomposeRecord(decomposeAdjusts);
                    this.addOlapAuditLog();
                    Map viewMap = (Map)JSON.parseObject((String)viewJson, HashMap.class);
                    Map dimViewMap = AdjustServiceHelper.getDimViewMap((Map)viewMap);
                    this.olapSave(entryEntity, modelCacheContext, dimViewMap);
                    this.activeNextTab();
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"DecomposeTaskPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else if (showTip) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DecomposeTaskPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
            catch (Throwable e) {
                log.error(e);
                tx.markRollback();
                this.getPageCache().put("thisDecdimensionjsonCache", cur_decDimensionJson_cache);
                this.getPageCache().put("thisDecDimensionCache", cur_this_decDimension_cache);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private void addOlapAuditLog() {
        DynamicObject object = (DynamicObject)this.getModel().getValue("scheme");
        if (object == null) {
            return;
        }
        String type = object.getString("type");
        String schemeNumber = object.getString("number");
        OlapTraceServiceHelper.setTraceOpInfo((String)schemeNumber);
        OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(DecomposeSchemeType.TARGET.getValue().equals(type) ? OlapDataAuditEventEnum.TargetDecompose : OlapDataAuditEventEnum.DecomposeAdjust));
    }

    /*
     * Exception decompiling
     */
    private void updateAdjustSub(Set<Long> pidList, Long taskId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateDecomposeTask(DynamicObject task) {
        DynamicObjectUtil.init2Update((DynamicObject)task);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
    }

    private void updateDecomposeTask(DynamicObject task, DecDimension thisDecDimension, DynamicObjectCollection entryEntity, boolean isSubmit) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Long taskId = task.getLong("id");
        task.set("status", (Object)TaskStatus.START.getValue());
        String newDecdimensionjson = task.getString("decdimensionjson");
        if (isSubmit) {
            thisDecDimension.setStatus(DecomposeStatus.DONE.getValue());
            this.updateTreeNodeStatus(DecomposeStatus.DONE.getText());
            for (int i = 0; i < entryEntity.size(); ++i) {
                view.setEnable(Boolean.valueOf(false), i, new String[]{"tab_result", "tab_change", "tab_ratio"});
            }
            view.setEnable(Boolean.valueOf(false), new String[]{"decompose_agent", "dec_save", "dec_submit", "clear_value", "btn_import"});
        }
        String agent = (String)this.getModel().getValue("decompose_agent");
        thisDecDimension.setAgent(agent);
        this.getPageCache().put("thisDecDimensionCache", JSON.toJSONString((Object)thisDecDimension));
        newDecdimensionjson = DecDimensionUtil.setThisDecDimension((String)newDecdimensionjson, (DecDimension)thisDecDimension);
        this.getPageCache().put("thisDecdimensionjsonCache", newDecdimensionjson);
        task.set("decdimensionjson", (Object)newDecdimensionjson);
        this.updateDecomposeTask(task);
        DynamicObjectCollection targetEntryEntity = this.getModel().getEntryEntity("target_entryentity");
        for (int i = 0; i < targetEntryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)targetEntryEntity.get(i);
            Long targetid = entry.getLong("targetid");
            if (!taskId.equals(targetid)) continue;
            model.setValue("target_decdimensionjson", (Object)newDecdimensionjson, i);
            model.setValue("target_status", (Object)TaskStatus.getTextByValue((Integer)task.getInt("status")), i);
            break;
        }
        this.setEntryGridColor("target_entryentity", "target_status");
    }

    private void updateTreeNodeStatus(String status) {
        DynamicObjectCollection treeEntryEntity = this.getModel().getEntryEntity("tree_entryentity");
        for (int i = 0; i < treeEntryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)treeEntryEntity.get(i);
            long pid = entry.getLong("pid");
            if (pid != 0L) continue;
            this.getModel().setValue("tab_status", (Object)status, i);
        }
    }

    private AdjustDecomposeRecord getAdjustDynamicObject(Long logId, IModelCacheHelper modelCacheContext, DynamicObject entryRowEntity, boolean isLeaf, Long entityViewId, String schemeType) {
        String srcdimensionjson = entryRowEntity.getString("tab_dimensionjson");
        Map srcdimensionMap = this.decomposeTaskService.stringtoMap(srcdimensionjson);
        AdjustDecomposeRecord record = new AdjustDecomposeRecord();
        record.setModelId(this.getModelId());
        record.setBusinessModelId(this.getBizModelId());
        record.setDataSetId(DecDimensionUtil.getDatasetId((IModelCacheHelper)modelCacheContext, (Map)srcdimensionMap));
        record.setMemberMap(srcdimensionMap);
        record.setEntityId(this.decomposeTaskService.getMemberIdFromJson(modelCacheContext, srcdimensionMap, SysDimensionEnum.Entity.getNumber()));
        record.setAccountId(this.decomposeTaskService.getMemberIdFromJson(modelCacheContext, srcdimensionMap, SysDimensionEnum.Account.getNumber()));
        record.setBudgetPeriodId(this.decomposeTaskService.getMemberIdFromJson(modelCacheContext, srcdimensionMap, SysDimensionEnum.BudgetPeriod.getNumber()));
        record.setVersionId(this.decomposeTaskService.getMemberIdFromJson(modelCacheContext, srcdimensionMap, SysDimensionEnum.Version.getNumber()));
        record.setDataTypeId(this.decomposeTaskService.getMemberIdFromJson(modelCacheContext, srcdimensionMap, SysDimensionEnum.DataType.getNumber()));
        record.setAuditTrailId(this.decomposeTaskService.getMemberIdFromJson(modelCacheContext, srcdimensionMap, SysDimensionEnum.AuditTrail.getNumber()));
        record.setCurrencyId(this.decomposeTaskService.getMemberIdFromJson(modelCacheContext, srcdimensionMap, SysDimensionEnum.Currency.getNumber()));
        AdjustDecomposeDetail detail = new AdjustDecomposeDetail();
        if (DecomposeSchemeType.ADJUST.getValue().equals(schemeType)) {
            detail.setType(AdjustDecomposeTypeEnum.DECOMPOSE.getNumber());
            Long viewId = this.getViewId(SysDimensionEnum.Entity.getNumber());
            detail.setEntityViewId(viewId);
            String viewjson = this.getViewJson();
            if (StringUtils.isNotEmpty((String)viewjson)) {
                detail.setViewMap(this.decomposeTaskService.stringtoMap(viewjson));
            }
        } else {
            detail.setType(AdjustDecomposeTypeEnum.TARGET_DECOMPOSE.getNumber());
            if (isLeaf) {
                detail.setStatus(DecomposeStatus.NOT_NEED_DECOMPOSE.getValue());
            } else {
                detail.setStatus(DecomposeStatus.WAIT.getValue());
            }
            detail.setEntityViewId(entityViewId);
        }
        detail.setPendingTrial((Object)this.getNewSaveAmount(entryRowEntity.getBigDecimal("tab_pendingtrial")));
        detail.setAdjustTrial((Object)this.getNewSaveAmount(entryRowEntity.getBigDecimal("tab_change")));
        detail.setFixTrial((Object)this.getNewSaveAmount(entryRowEntity.getBigDecimal("tab_result")));
        detail.setDecomposeTaskId(logId);
        record.addDetail(detail);
        return record;
    }

    private void beforeIssue() {
        if (this.showChangeFlagConfirm("confirm_issue_click")) {
            return;
        }
        this.validScheme();
        this.issue();
    }

    private void issue() {
        DynamicObject[] tasks;
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
        ArrayList<Long> taskIdList = new ArrayList<Long>(10);
        ArrayList<Object[]> params = new ArrayList<Object[]>(10);
        TreeView tree = (TreeView)this.getView().getControl("lefttree");
        IModelCacheHelper modelCacheContext = this.getModelCacheHelper();
        long entityId = this.getEntityIdFromNodeId(tree.getTreeState().getFocusNodeId());
        QFilter qFilter = new QFilter("scheme", "=", (Object)this.getSchemeId());
        qFilter.and("entity", "=", (Object)entityId);
        qFilter.and("status", "in", Arrays.asList(TaskStatus.WAIT.getValue(), TaskStatus.START.getValue()));
        for (DynamicObject task : tasks = BusinessDataServiceHelper.load((String)"eb_decompose_task", (String)"id,srcdimensionjson,decdimensionjson,modifydate,modifier,status", (QFilter[])qFilter.toArray())) {
            String dimensionjson = task.getString("srcdimensionjson");
            Map memberMap = this.decomposeTaskService.stringtoMap(dimensionjson);
            boolean entityDimLeaf = this.isEntityDimLeaf(memberMap);
            String decdimensionjson = task.getString("decdimensionjson");
            List decDimensions = JSONArray.parseArray((String)decdimensionjson, DecDimension.class);
            for (DecDimension decDimension : decDimensions) {
                if (SysDimensionEnum.Entity.getNumber().equals(decDimension.getDimNumber()) && !DecomposeStatus.DONE.getValue().equals(decDimension.getStatus())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7ef4\u5ea6\u5b58\u5728\u672a\u5206\u89e3\u4efb\u52a1\uff0c\u4e0d\u53ef\u4e0b\u8fbe\u3002", (String)"DecomposeTaskPlugin_54", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!entityDimLeaf || DecomposeStatus.DONE.getValue().equals(decDimension.getStatus())) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7ef4\u5ea6\u5b58\u5728\u672a\u5206\u89e3\u4efb\u52a1\uff0c\u65e0\u6cd5\u4e0b\u8fbe\u3002", (String)"DecomposeTaskPlugin_56", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            task.set("status", (Object)TaskStatus.DONE.getValue());
            DynamicObjectUtil.init2Update((DynamicObject)task);
            long taskId = task.getLong("id");
            taskIdList.add(taskId);
            params.add(new Object[]{taskId});
        }
        QFilter qFilter1 = new QFilter("task", "in", taskIdList);
        qFilter1.and("submitflag", "=", (Object)"0");
        if (QueryServiceHelper.exists((String)"eb_decompose_log", (QFilter[])qFilter1.toArray())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u89e3\u6570\u636e\u672a\u63d0\u4ea4\uff0c\u8bf7\u5148\u63d0\u4ea4\u5206\u89e3\u6570\u636e\u3002", (String)"DecomposeTaskPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        SaveServiceHelper.save((DynamicObject[])tasks);
        DynamicObjectCollection childAdjusts = this.decomposeSchemeService.getAdjusts(this.getScheme(), modelCacheContext, Collections.singletonList(entityId));
        if (childAdjusts.isEmpty()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4e0b\u8fbe\u6210\u529f\u3002", (String)"DecomposeTaskPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            DynamicObject[] adjustTasks = this.decomposeSchemeService.adjustToDecomposeTask(modelCacheContext, childAdjusts, scheme);
            SaveServiceHelper.save((DynamicObject[])adjustTasks);
        }
        if (params.size() > 0) {
            DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)"update t_eb_decomposeadjustsub set fstatus=2 where fdecomposetask=? ", params);
        }
        long schemeId = scheme.getLong("id");
        this.buildLeftTreeData(this.getModelId(), this.getBizModelId(), true);
        if (!this.decomposeTaskService.existsTaskByStatus(schemeId, Arrays.asList(TaskStatus.WAIT.getValue(), TaskStatus.START.getValue()))) {
            this.decomposeTaskService.updateSchemeStatus(schemeId, DecomposeSchemeStatus.FINISHED);
        }
        this.writeLog("assign", new MultiLangEnumBridge("\u4e0b\u8fbe", "DecomposeTaskPlugin_57", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4e0b\u8fbe\u6210\u529f\u3002", "DecomposeTaskPlugin_3", "epm-eb-formplugin"));
    }

    private void olapSave(DynamicObjectCollection entryEntity, IModelCacheHelper modelCacheContext, Map<String, Long> dimViewMap) {
        Long modelId = this.getModelId();
        ArrayList<BgNumberCell> list = new ArrayList<BgNumberCell>(10);
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
        String type = scheme.getString("type");
        DecDimension thisDecDimension = this.getDecDimension();
        if (thisDecDimension == null) {
            return;
        }
        HashMap<String, Map<String, Long>> cellViewMap = new HashMap<String, Map<String, Long>>(16);
        for (DynamicObject entryRowEntity : entryEntity) {
            long pid = entryRowEntity.getLong("pid");
            BigDecimal value = this.getNewSaveAmount(entryRowEntity.getBigDecimal("tab_value"));
            String srcdimensionjson = entryRowEntity.getString("tab_dimensionjson");
            Map memberMap = this.decomposeTaskService.stringtoMap(srcdimensionjson);
            Long datasetId = DecDimensionUtil.getDatasetId((IModelCacheHelper)modelCacheContext, (Map)memberMap);
            if (pid == 0L) {
                if (DecomposeSchemeType.TARGET.getValue().equals(type)) {
                    log.warn("\u76ee\u6807\u5206\u89e3\u5f00\u59cb\u5220\u9664\u660e\u7ec6\uff0c\u7ef4\u5ea6\u7ec4\u5408\uff1a" + memberMap);
                    this.dataDecomposeService.delDetail(modelId.longValue(), datasetId, memberMap);
                    continue;
                }
                log.warn("\u8c03\u6574\u5206\u89e3\u5f00\u59cb\u56de\u9000\u660e\u7ec6\uff0c\u7ef4\u5ea6\u7ec4\u5408\uff1a" + memberMap);
                String dimNumber = thisDecDimension.getDimNumber();
                this.dataDecomposeService.adjustBack(modelId, datasetId, memberMap, value, dimNumber, dimViewMap);
                continue;
            }
            BigDecimal change = this.getNewSaveAmount(entryRowEntity.getBigDecimal("tab_change"));
            String issueFlag = entryRowEntity.getString("issueflag");
            if (BigDecimal.ZERO.compareTo(change) != 0 && StringUtils.equals((String)issueFlag, (String)"1")) {
                BgNumberCell bgNumberCell = new BgNumberCell(datasetId, memberMap, change);
                list.add(bgNumberCell);
            }
            cellViewMap.put(memberMap.toString(), dimViewMap);
        }
        if (DecomposeSchemeType.TARGET.getValue().equals(type)) {
            this.dataDecomposeService.avgToDetail(modelId.longValue(), list);
        } else {
            this.dataDecomposeService.adjustToOlap(modelId.longValue(), list, cellViewMap);
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        try {
            String tabKey = tabSelectEvent.getTabKey();
            this.getPageCache().put("selectTab", tabKey);
            String currentTab = this.getPageCache().get("currentTab");
            if (tabKey.equals(currentTab)) {
                return;
            }
            this.initTabData(tabKey);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private void refreshTabData() {
        this.buildLeftTreeData(this.getModelId(), this.getBizModelId(), false);
        Tab tab = (Tab)this.getView().getControl("tabap");
        String currentTab = tab.getCurrentTab();
        this.initTabData(currentTab);
    }

    private DynamicObject getTask(Long taskId) {
        DynamicObject task = this.decomposeTaskService.queryTaskById(taskId.longValue());
        if (task == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u4efb\u52a1\u4e0d\u5b58\u5728\u3002", (String)"DecomposeTaskPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return task;
    }

    private boolean isEntityDimLeaf(Map<String, String> memberMap) {
        String dim = SysDimensionEnum.Entity.getNumber();
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        Member member = modelCacheHelper.getMember(dim, this.getViewId(dim), memberMap.get(dim));
        if (member != null) {
            return member.isLeaf();
        }
        return false;
    }

    private void initTabData(String tabKey) {
        Tab tab = (Tab)this.getView().getControl("tabap");
        String currentTab = this.getPageCache().get("currentTab");
        long taskId = Long.parseLong(this.getPageCache().get("currentTaskId"));
        DynamicObject task = this.getTask(taskId);
        String decDimensionJson = task.getString("decdimensionjson");
        String viewjson = task.getString("viewjson");
        Map viewMap = (Map)JSON.parseObject((String)viewjson, HashMap.class);
        Map dimViewMap = AdjustServiceHelper.getDimViewMap((Map)viewMap);
        this.putViewJsonIntoCache(viewjson);
        this.getPageCache().put("thisDecdimensionjsonCache", decDimensionJson);
        IModelCacheHelper modelCacheContext = this.getModelCacheHelper();
        int tabNum = Integer.parseInt(tabKey.replace("dimenpage", ""));
        List decDimensions = JSONArray.parseArray((String)decDimensionJson, DecDimension.class);
        if (decDimensions.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u5f85\u5206\u89e3\u7684\u7ef4\u5ea6\u3002", (String)"DecomposeTaskPlugin_51", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DecDimension thisDecDimension = (DecDimension)decDimensions.get(tabNum - 1);
        DecDimension previousDecDimen = DecDimensionUtil.getPreviousDecDimen((DecDimension)thisDecDimension, (List)decDimensions);
        if (previousDecDimen != null && !DecomposeStatus.DONE.getValue().equals(previousDecDimen.getStatus())) {
            tab.activeTab(currentTab);
            this.getView().showTipNotification(ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u672a\u63d0\u4ea4\u5206\u89e3\u7ed3\u679c\uff0c\u8bf7\u63d0\u4ea4\u540e\u518d\u5207\u6362\u7ef4\u5ea6\u5206\u89e3\u3002", (String)"DecomposeTaskPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[]{this.decomposeTaskService.getDimNameByDimNumber(modelCacheContext, previousDecDimen.getDimNumber())}));
            return;
        }
        if (this.showChangeFlagConfirm("confirm_tab_select")) {
            return;
        }
        this.getPageCache().put("currentTab", tabKey);
        this.getPageCache().put("change_flag_cache", "0");
        this.getPageCache().put("thisDecDimensionCache", JSON.toJSONString((Object)thisDecDimension));
        this.initTabDecDimen(this.getView(), modelCacheContext, decDimensions);
        IFormView view = this.getView();
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)view.getControl("tree_entryentity");
        this.getView().setEnable(Boolean.valueOf(TaskStatus.DONE.getValue().intValue() != task.getInt("status") && !DecomposeStatus.DONE.getValue().equals(thisDecDimension.getStatus())), new String[]{"decompose_agent", "dec_save", "dec_submit", "clear_value", "btn_import"});
        if (!DecomposeStatus.DONE.getValue().equals(thisDecDimension.getStatus()) && TaskStatus.DONE.getValue().equals(task.getInt("status"))) {
            return;
        }
        String dimNumber = thisDecDimension.getDimNumber();
        String dimMember = thisDecDimension.getDimMember();
        DynamicObject[] decomposeRows = this.decomposeTaskService.queryDecLogsByTaskAndDim(taskId, previousDecDimen);
        if (decomposeRows == null || decomposeRows.length == 0) {
            decomposeRows = this.newDecomposeRows(previousDecDimen, task);
        }
        this.getPageCache().put("needConfirm", "false");
        String schemeType = this.getSchemeType();
        String agent = this.getPageCache().get("agentChange");
        if (StringUtils.isEmpty((String)agent)) {
            agent = thisDecDimension.getAgent();
        }
        if (StringUtils.isEmpty((String)agent)) {
            agent = DecomposeAgentEnum.INPUT.getValue();
        }
        if (DecomposeSchemeType.TARGET.getValue().equals(schemeType)) {
            this.getModel().setValue("decompose_agent", (Object)agent);
            this.setLastPeriodVisible();
        } else if (DecomposeSchemeType.ADJUST.getValue().equals(schemeType)) {
            this.getModel().setValue("decompose_agent", null);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"disable"});
        }
        this.getPageCache().remove("needConfirm");
        String decomposeAgent = (String)this.getModel().getValue("decompose_agent");
        LinkedList<DecomposeTreeNode> decomposeTreeNodes = new LinkedList<DecomposeTreeNode>();
        for (DynamicObject row : decomposeRows) {
            BigDecimal value = row.getBigDecimal("value");
            BigDecimal change = row.getBigDecimal("change");
            long logId = row.getLong("id");
            String srcdimensionjson = row.getString("srcdimensionjson");
            Map memberMap = this.decomposeTaskService.stringtoMap(srcdimensionjson);
            Long dimViewId = (Long)dimViewMap.get(dimNumber);
            Member thisMember = modelCacheContext.getMember(dimNumber, dimViewId, (String)memberMap.get(dimNumber));
            if (thisMember == null) continue;
            DecomposeTreeNode treeNode = new DecomposeTreeNode();
            decomposeTreeNodes.add(treeNode);
            treeNode.setExpand(true);
            treeNode.setPid(0L);
            treeNode.setId(logId);
            treeNode.setLevel(0);
            treeNode.setSrcdimensionjson(srcdimensionjson);
            treeNode.setTabDecdim1(thisMember.getName());
            treeNode.setTabAggoprt(this.decomposeTaskService.getAggType(srcdimensionjson, dimNumber, modelCacheContext, dimViewId));
            treeNode.setIssueflag("1");
            treeNode.setTabValue(this.getNewAmount(value));
            treeNode.setTabStatus(DecomposeStatus.getTextByValue((int)row.getInt("status")));
            treeNode.setTabChange(this.getNewAmount(change));
            log.info("decompose thisDecDimension.getStatus()\uff1a" + thisDecDimension.getStatus());
            if (DecomposeStatus.DONE.getValue().equals(thisDecDimension.getStatus())) {
                log.info("decompose finish");
                BigDecimal pendingtrial = row.getBigDecimal("pendingtrial");
                if (decDimensions.size() > 0 && !((DecDimension)decDimensions.get(0)).getDimNumber().equals(thisDecDimension.getDimNumber())) {
                    pendingtrial = pendingtrial.add(change);
                }
                treeNode.setTabPendingtrial(this.getNewAmount(pendingtrial));
                treeNode.setTabResult(this.getNewAmount(pendingtrial));
                treeNode.setTabRatio(new BigDecimal(100));
                DynamicObject[] dynamicObjects = this.decomposeTaskService.queryDecLogsByParent(logId);
                List<Member> members = this.getChildrenByView(modelCacheContext, dimNumber, dimMember);
                if (!CollectionUtils.isNotEmpty(members)) continue;
                treeNode.setIsgroupnode(true);
                this.expendOneLevel(decomposeTreeNodes, modelCacheContext, dynamicObjects, logId, value, dimNumber, members);
                continue;
            }
            log.info("decompose not finish");
            List<Member> members = this.getChildrenByView(modelCacheContext, dimNumber, dimMember);
            if (!CollectionUtils.isNotEmpty(members)) continue;
            treeNode.setIsgroupnode(true);
            this.expendOneLevel(decomposeTreeNodes, modelCacheContext, members, memberMap, treeNode, treeNode.getTabValue(), this.isEntityDimLeaf(memberMap), thisDecDimension, decomposeAgent, schemeType, dimViewMap);
        }
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData(treeEntryGrid.getKey());
        this.createRows(decomposeTreeNodes, treeEntryGrid, dataModel, null);
        this.initTabRowDimen(modelCacheContext, decDimensions, dimNumber, dimViewMap);
        view.updateView(treeEntryGrid.getKey());
        this.enableTreeEntryEntityCell(0, true);
    }

    private void createRows(List<DecomposeTreeNode> decomposeTreeNodes, TreeEntryGrid treeEntryGrid, IDataModel dataModel, Integer InsertRow) {
        dataModel.beginInit();
        int[] ints = InsertRow != null ? dataModel.batchInsertEntryRow("tree_entryentity", InsertRow.intValue(), decomposeTreeNodes.size()) : dataModel.batchCreateNewEntryRow("tree_entryentity", decomposeTreeNodes.size());
        dataModel.endInit();
        ArrayList<Integer> expandIds = new ArrayList<Integer>(decomposeTreeNodes.size());
        for (int i = 0; i < decomposeTreeNodes.size(); ++i) {
            DecomposeTreeNode decomposeTreeNode = decomposeTreeNodes.get(i);
            DynamicObject entryRowEntity = dataModel.getEntryRowEntity("tree_entryentity", ints[i]);
            entryRowEntity.set("id", (Object)decomposeTreeNode.getId());
            entryRowEntity.set("pid", (Object)decomposeTreeNode.getPid());
            entryRowEntity.set("level", (Object)decomposeTreeNode.getLevel());
            entryRowEntity.set("tab_dimensionjson", (Object)decomposeTreeNode.getSrcdimensionjson());
            entryRowEntity.set("tab_decdim1", (Object)decomposeTreeNode.getTabDecdim1());
            entryRowEntity.set("tab_value", (Object)decomposeTreeNode.getTabValue());
            entryRowEntity.set("tab_status", (Object)decomposeTreeNode.getTabStatus());
            entryRowEntity.set("tab_aggoprt", (Object)decomposeTreeNode.getTabAggoprt());
            entryRowEntity.set("tab_change", (Object)decomposeTreeNode.getTabChange());
            entryRowEntity.set("issueflag", (Object)decomposeTreeNode.getIssueflag());
            entryRowEntity.set("last_period", (Object)decomposeTreeNode.getLastPeriod());
            entryRowEntity.set("isgroupnode", (Object)decomposeTreeNode.isIsgroupnode());
            entryRowEntity.set("disable", (Object)decomposeTreeNode.getDisable());
            entryRowEntity.set("tab_result", (Object)decomposeTreeNode.getTabResult());
            entryRowEntity.set("tab_pendingtrial", (Object)decomposeTreeNode.getTabPendingtrial());
            entryRowEntity.set("tab_ratio", (Object)decomposeTreeNode.getTabRatio());
            if (!decomposeTreeNode.isExpand()) continue;
            expandIds.add(i);
        }
        if (InsertRow == null) {
            int[] expandIds1 = expandIds.stream().mapToInt(Integer::intValue).toArray();
            if (treeEntryGrid == null) {
                treeEntryGrid = (TreeEntryGrid)this.getView().getControl("tree_entryentity");
            }
            treeEntryGrid.collapse(expandIds1);
            treeEntryGrid.expandOne(expandIds1);
        }
    }

    private DynamicObject[] newDecomposeRows(DecDimension thisDecDimension, DynamicObject task) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"eb_decompose_log");
        log.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        log.set("parent", (Object)0L);
        log.set("task", (Object)task.getLong("id"));
        log.set("value", (Object)task.getBigDecimal("value"));
        log.set("change", (Object)task.getBigDecimal("value"));
        log.set("srcdimensionjson", (Object)task.getString("srcdimensionjson"));
        log.set("issueflag", (Object)"1");
        DecDimensionUtil.setDecDimension((DynamicObject)log, (DecDimension)thisDecDimension);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
        return new DynamicObject[]{log};
    }

    private void initTabTitle(IFormView view, IModelCacheHelper modelCacheContext, List<DecDimension> decDimensions) {
        int i;
        Tab tab = (Tab)this.getView().getControl("tabap");
        for (i = 1; i <= DecomposeConstant.DEC_DIM_NUM; ++i) {
            view.setVisible(Boolean.valueOf(false), new String[]{"dimenpage" + i});
        }
        for (i = 0; i < decDimensions.size(); ++i) {
            String dimNumber = decDimensions.get(i).getDimNumber();
            Dimension dimension = modelCacheContext.getDimension(dimNumber);
            String tabKey = "dimenpage" + (i + 1);
            view.setVisible(Boolean.valueOf(true), new String[]{tabKey});
            TabPage tabPage = (TabPage)view.getControl(tabKey);
            tabPage.setText(new LocaleString(dimension.getName()));
        }
        String firstTab = "dimenpage1";
        this.getPageCache().remove("currentTab");
        tab.selectTab(firstTab);
        tab.activeTab(firstTab);
    }

    private void initTabDecDimen(IFormView view, IModelCacheHelper modelCacheContext, List<DecDimension> decDimensions) {
        for (int i = 1; i <= DecomposeConstant.CUSTOM_DIM_NUM; ++i) {
            view.setVisible(Boolean.valueOf(false), new String[]{"tab_decdim" + i});
        }
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl("tree_entryentity");
        DecDimension thisDecDimension = this.getDecDimension();
        Dimension dimension = modelCacheContext.getDimension(thisDecDimension.getDimNumber());
        String decdimNum = "tab_decdim1";
        view.setVisible(Boolean.valueOf(true), new String[]{decdimNum});
        treeEntryGrid.setColumnProperty(decdimNum, "header", (Object)new LocaleString(dimension.getName()));
        int num = 1;
        for (DecDimension decDimension : decDimensions) {
            if (StringUtils.equals((String)decDimension.getDimNumber(), (String)thisDecDimension.getDimNumber())) continue;
            Dimension dimension1 = modelCacheContext.getDimension(decDimension.getDimNumber());
            String decdimKey1 = "tab_decdim" + (num + 1);
            view.setVisible(Boolean.valueOf(true), new String[]{"tab_decdim" + (num + 1)});
            treeEntryGrid.setColumnProperty(decdimKey1, "header", (Object)new LocaleString(dimension1.getName()));
            ++num;
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        try {
            Control control = (Control)evt.getSource();
            if (control.getKey().equals("lefttree")) {
                this.queryLeftTreeNodeChildren(evt);
            } else if (control.getKey().equals("tree_entryentity")) {
                DynamicObject next;
                IModelCacheHelper modelCache = this.getModelCacheHelper();
                int rowKey = evt.getRowKey();
                if (rowKey < 0) {
                    return;
                }
                IDataModel dataModel = this.getModel();
                int entryRowCount = this.getModel().getEntryRowCount("tree_entryentity");
                DynamicObject obj = this.getModel().getEntryRowEntity("tree_entryentity", rowKey);
                long pid = obj.getLong("id");
                DynamicObject dynamicObject = next = rowKey + 2 > entryRowCount ? null : this.getModel().getEntryRowEntity("tree_entryentity", rowKey + 1);
                if (next != null && next.getLong("pid") == pid && StringUtils.isNotEmpty((String)next.getString("id"))) {
                    return;
                }
                String srcdimensionjson = obj.getString("tab_dimensionjson");
                Map memberMap = this.decomposeTaskService.stringtoMap(srcdimensionjson);
                DecDimension decDimension = this.getDecDimension();
                String thisDecDimen = decDimension.getDimNumber();
                int rootIndex = this.getRootIndex(rowKey);
                DynamicObject rootObj = this.getModel().getEntryRowEntity("tree_entryentity", rootIndex);
                DynamicObject row = this.getModel().getEntryRowEntity("tree_entryentity", rowKey);
                String schemeType = this.getSchemeType();
                String decomposeAgent = (String)dataModel.getValue("decompose_agent");
                LinkedList<DecomposeTreeNode> decomposeTreeNodes = new LinkedList<DecomposeTreeNode>();
                DecomposeTreeNode decomposeTreeNode = new DecomposeTreeNode();
                decomposeTreeNode.setLevel(row.getInt("level"));
                decomposeTreeNode.setId(row.getLong("id"));
                decomposeTreeNode.setLastPeriod(row.getBigDecimal("last_period"));
                decomposeTreeNode.setTabChange(row.getBigDecimal("tab_change"));
                decomposeTreeNode.setPid(row.getLong("pid"));
                List<Member> members = this.getChildrenByView(modelCache, decDimension.getDimNumber(), (String)memberMap.get(thisDecDimen));
                String viewJson = this.getViewJson();
                Map viewMap = (Map)JSON.parseObject((String)viewJson, HashMap.class);
                Map dimViewMap = AdjustServiceHelper.getDimViewMap((Map)viewMap);
                if (CollectionUtils.isNotEmpty(members)) {
                    this.expendOneLevel(decomposeTreeNodes, modelCache, members, memberMap, decomposeTreeNode, rootObj.getBigDecimal("tab_value"), false, decDimension, decomposeAgent, schemeType, dimViewMap);
                }
                this.createRows(decomposeTreeNodes, null, dataModel, rowKey);
                this.enableTreeEntryEntityCell(rootIndex, true);
                List decDimensions = JSONArray.parseArray((String)this.getPageCache().get("thisDecdimensionjsonCache"), DecDimension.class);
                this.initTabRowDimen(modelCache, decDimensions, thisDecDimen, dimViewMap);
                this.getView().updateView("tree_entryentity");
            }
        }
        catch (Exception e) {
            log.error(CommonServiceHelper.getStackTraceStr((Throwable)e));
            throw new KDBizException(e.getMessage());
        }
    }

    private boolean hasNoZeroChild(DynamicObjectCollection entryEntity, List<Integer> children) {
        if (children.isEmpty()) {
            return false;
        }
        boolean hasNotZero = false;
        for (int i : children) {
            DynamicObject child = (DynamicObject)entryEntity.get(i);
            if (BigDecimal.ZERO.compareTo(child.getBigDecimal("tab_change")) == 0) continue;
            hasNotZero = true;
            break;
        }
        return hasNotZero;
    }

    private DecDimension getDecDimension() {
        return (DecDimension)JSON.parseObject((String)this.getPageCache().get("thisDecDimensionCache"), DecDimension.class);
    }

    private void enableTreeEntryEntityCell(int rootIndex, boolean isAll) {
        DecDimension decDimension = this.getDecDimension();
        String decomposeAgent = (String)this.getModel().getValue("decompose_agent");
        int startIndex = 0;
        if (!isAll) {
            startIndex = rootIndex;
        }
        DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity("tree_entryentity");
        IFormView view = this.getView();
        for (int i = startIndex; i < entryEntitys.size(); ++i) {
            Long rootId;
            DynamicObject obj = (DynamicObject)entryEntitys.get(i);
            long pid = obj.getLong("pid");
            Long id = obj.getLong("id");
            if (pid == 0L && !isAll && !id.equals(rootId = Long.valueOf(((DynamicObject)entryEntitys.get(startIndex)).getLong("id")))) {
                return;
            }
            if (DecomposeStatus.DONE.getValue().equals(decDimension.getStatus())) {
                obj.set("issueflag", (Object)"0");
            } else if (pid != 0L) {
                String srcdimensionjson = obj.getString("tab_dimensionjson");
                Map memberMap = this.decomposeTaskService.stringtoMap(srcdimensionjson);
                List<Integer> children = this.getAllChildrenIndex(entryEntitys, id, i);
                if (!children.isEmpty()) {
                    if (this.isEntityDimLeaf(memberMap) && !StringUtils.equals((String)decDimension.getDimNumber(), (String)SysDimensionEnum.Entity.getNumber())) {
                        obj.set("issueflag", (Object)"0");
                    } else if (this.hasNoZeroChild(entryEntitys, children)) {
                        obj.set("issueflag", (Object)"0");
                    } else {
                        obj.set("issueflag", (Object)"1");
                    }
                }
            } else {
                obj.set("issueflag", (Object)"0");
            }
            String issueFlag = obj.getString("issueflag");
            if (!"1".equals(issueFlag)) {
                view.setEnable(Boolean.valueOf(false), i, new String[]{"tab_change", "tab_result", "tab_ratio"});
                continue;
            }
            if (pid == 0L) continue;
            if (DecomposeSchemeType.TARGET.getValue().equals(this.getSchemeType())) {
                if (DecomposeAgentEnum.INPUT.getValue().equals(decomposeAgent)) {
                    view.setEnable(Boolean.valueOf(false), i, new String[]{"tab_result", "tab_ratio"});
                    view.setEnable(Boolean.valueOf(true), i, new String[]{"tab_change"});
                    continue;
                }
                if (DecomposeAgentEnum.RATIO.getValue().equals(decomposeAgent)) {
                    view.setEnable(Boolean.valueOf(false), i, new String[]{"tab_result", "tab_change"});
                    view.setEnable(Boolean.valueOf(true), i, new String[]{"tab_ratio"});
                    continue;
                }
                if (!DecomposeAgentEnum.LAST_PERIOD.getValue().equals(decomposeAgent) && !DecomposeAgentEnum.AVG.getValue().equals(decomposeAgent)) continue;
                view.setEnable(Boolean.valueOf(false), i, new String[]{"tab_result", "tab_change", "tab_ratio"});
                continue;
            }
            if (!DecomposeSchemeType.ADJUST.getValue().equals(this.getSchemeType())) continue;
            view.setEnable(Boolean.valueOf(true), i, new String[]{"tab_change", "tab_result"});
        }
        view.updateView("tree_entryentity");
    }

    private Map<String, DynamicObject> decLogArrayToMap(DynamicObjectCollection childRows, String dimension) {
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(16);
        for (DynamicObject log : childRows) {
            String srcdimensionjson = log.getString("srcdimensionjson");
            JSONObject srcdimensionJsonObject = JSON.parseObject((String)srcdimensionjson);
            map.put(srcdimensionJsonObject.getString(dimension), log);
        }
        return map;
    }

    public List<Member> getChildrenByView(IModelCacheHelper modelCacheContext, String dimNumber, String numberNumber) {
        Long viewId = this.getViewId(dimNumber);
        Member member1 = modelCacheContext.getMember(dimNumber, viewId, numberNumber);
        if (member1 != null) {
            return member1.getChildrenNotWithCosmic().stream().sorted(Comparator.comparing(BaseCache::getSeq)).collect(Collectors.toList());
        }
        return new ArrayList<Member>(10);
    }

    private void expendOneLevel(List<DecomposeTreeNode> decomposeTreeNodes, IModelCacheHelper modelCacheContext, List<Member> members, Map<String, String> memberMap, DecomposeTreeNode decomposeTreeNode, BigDecimal tabValue, boolean loadAll, DecDimension decDimension, String decomposeAgent, String schemeType, Map<String, Long> dimViewMap) {
        BigDecimal parentAmount;
        int level = decomposeTreeNode.getLevel();
        if (!loadAll && level >= DecomposeConstant.TREE_MAX_LEVEL) {
            return;
        }
        ++level;
        Long pid = decomposeTreeNode.getId();
        DynamicObjectCollection childRows = this.decomposeTaskService.queryDecLogsByPid(pid.longValue());
        if (decomposeTreeNode.getPid() == 0L) {
            if (childRows.size() == 0) {
                decomposeTreeNode.setTabChange(BigDecimal.ZERO);
            }
            if (DecomposeSchemeType.ADJUST.getValue().equals(schemeType)) {
                BigDecimal totalValue = this.decomposeTaskService.getValueFromOlap(memberMap, modelCacheContext, dimViewMap);
                BigDecimal pendingtrial = this.getNewAmount(totalValue);
                decomposeTreeNode.setTabPendingtrial(pendingtrial);
                decomposeTreeNode.setTabResult(this.getNewAmount(totalValue));
            } else if (DecomposeSchemeType.TARGET.getValue().equals(schemeType)) {
                BigDecimal divide = decomposeTreeNode.getTabChange().multiply(new BigDecimal(100)).divide(decomposeTreeNode.getTabValue(), 15, RoundingMode.HALF_UP);
                decomposeTreeNode.setTabRatio(divide);
                BigDecimal lastTotalAmount = null;
                if (DecomposeAgentEnum.LAST_PERIOD.getValue().equals(decomposeAgent) && BigDecimal.ZERO.compareTo(lastTotalAmount = this.getLastPeriodAmount(decomposeTreeNode.getSrcdimensionjson(), modelCacheContext, dimViewMap)) != 0) {
                    decomposeTreeNode.setLastPeriod(this.getNewAmount(lastTotalAmount));
                }
                if (DecomposeAgentEnum.LAST_PERIOD.getValue().equals(decomposeAgent) && BigDecimal.ZERO.compareTo(lastTotalAmount) != 0 || DecomposeAgentEnum.AVG.getValue().equals(decomposeAgent)) {
                    decomposeTreeNode.setTabChange(decomposeTreeNode.getTabValue());
                    decomposeTreeNode.setTabRatio(new BigDecimal(100));
                }
            }
        }
        Map<String, DynamicObject> logMap = this.decLogArrayToMap(childRows, decDimension.getDimNumber());
        Map memberValueMap = new HashMap(16);
        Long datasetId = DecDimensionUtil.getDatasetId((IModelCacheHelper)modelCacheContext, memberMap);
        ArrayList<HashMap<String, String>> memberMaps = new ArrayList<HashMap<String, String>>(members.size());
        Set<Object> logIds = new HashSet(members.size());
        members.removeIf(e -> DecomposeSchemeType.ADJUST.getValue().equals(schemeType) && e.isDisable() || StringUtils.equals((String)e.getAggType(), (String)AggOprtEnum.SKIP.getSign()) || e.getNumber().endsWith("offsetentry"));
        ArrayList<String> noBudgetMember = new ArrayList<String>(16);
        for (Member member1 : members) {
            Member lastPeriodMember;
            String lastPeriod;
            Map<String, String> memberMap1 = new HashMap<String, String>(memberMap);
            memberMap1.put(decDimension.getDimNumber(), member1.getNumber());
            if (DecomposeAgentEnum.LAST_PERIOD.getValue().equals(decomposeAgent) && DecomposeSchemeType.TARGET.getValue().equals(schemeType) && (lastPeriod = (memberMap1 = this.decomposeTaskService.getLastMember(memberMap1)).get(SysDimensionEnum.BudgetPeriod.getNumber())) != null && (lastPeriodMember = modelCacheContext.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), Long.valueOf(0L), lastPeriod)) == null) {
                noBudgetMember.add(lastPeriod);
            }
            memberMaps.add((HashMap<String, String>)memberMap1);
            DynamicObject logObj = logMap.get(member1.getNumber());
            if (logObj == null) continue;
            logIds.add(logObj.getLong("id"));
        }
        DynamicObjectCollection dynamicObjects = this.decomposeTaskService.queryDecLogsByPids(logIds);
        logIds = dynamicObjects.stream().map(e -> e.getLong("pid")).collect(Collectors.toSet());
        if (!noBudgetMember.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u4e0a\u4e00\u5e74\u671f\u95f4\u6210\u5458%1\u4e0d\u5b58\u5728", (String)"DecomposeTaskPlugin_58", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)"\u3001", noBudgetMember)}));
        } else if (DecomposeSchemeType.ADJUST.getValue().equals(schemeType) || DecomposeAgentEnum.LAST_PERIOD.getValue().equals(decomposeAgent)) {
            memberValueMap = this.dataDecomposeService.queryValues(decDimension.getDimNumber(), datasetId, memberMaps, modelCacheContext, dimViewMap);
        }
        BigDecimal lastParentAmount = this.getNewSaveAmount(decomposeTreeNode.getLastPeriod());
        BigDecimal parentAmountRemain = parentAmount = this.getNewSaveAmount(decomposeTreeNode.getTabChange());
        BigDecimal currentTotalAmount = this.getNewSaveAmount(tabValue);
        Integer firstHasLastDataIndex = null;
        for (int i = 0; i < members.size(); ++i) {
            long id;
            Member childMember = members.get(i);
            memberMap.put(decDimension.getDimNumber(), childMember.getNumber());
            DecomposeTreeNode treeNode = new DecomposeTreeNode();
            decomposeTreeNodes.add(treeNode);
            treeNode.setPid(pid);
            treeNode.setLevel(level);
            treeNode.setSrcdimensionjson(JSON.toJSONString(memberMap));
            treeNode.setTabDecdim1(childMember.getName());
            treeNode.setTabAggoprt(childMember.getAggType());
            treeNode.setIssueflag("1");
            treeNode.setIsgroupnode(false);
            treeNode.setDisable(this.getDisableStr(childMember));
            BigDecimal change = BigDecimal.ZERO;
            DynamicObject logObj = logMap.get(childMember.getNumber());
            if (logObj != null) {
                id = logObj.getLong("id");
                change = logObj.getBigDecimal("change");
            } else {
                id = GlobalIdUtil.genGlobalLongId();
            }
            treeNode.setId(id);
            treeNode.setTabChange(this.getNewAmount(change));
            if (DecomposeSchemeType.ADJUST.getValue().equals(schemeType)) {
                BigDecimal pendingtrial = memberValueMap.getOrDefault(childMember.getNumber(), BigDecimal.ZERO);
                treeNode.setTabPendingtrial(this.getNewAmount(pendingtrial));
                treeNode.setTabResult(this.getNewAmount(pendingtrial.add(change)));
            } else if (DecomposeSchemeType.TARGET.getValue().equals(schemeType)) {
                if (BigDecimal.ZERO.compareTo(change) != 0 && BigDecimal.ZERO.compareTo(currentTotalAmount) != 0) {
                    treeNode.setTabRatio(change.multiply(new BigDecimal(100)).divide(currentTotalAmount, 15, RoundingMode.HALF_UP));
                }
                if (DecomposeAgentEnum.LAST_PERIOD.getValue().equals(decomposeAgent)) {
                    BigDecimal lastPeriodAmount = BigDecimal.ZERO;
                    lastPeriodAmount = SysDimensionEnum.BudgetPeriod.getNumber().equals(decDimension.getDimNumber()) ? memberValueMap.getOrDefault(DecomposeTaskService.getInstance().getLastBudgetPeriod(childMember.getNumber()), BigDecimal.ZERO) : memberValueMap.getOrDefault(childMember.getNumber(), BigDecimal.ZERO);
                    BigDecimal currentPeriodAmount = BigDecimal.ZERO;
                    if (BigDecimal.ZERO.compareTo(lastParentAmount) != 0) {
                        if (firstHasLastDataIndex == null) {
                            firstHasLastDataIndex = decomposeTreeNodes.size() - 1;
                        }
                        currentPeriodAmount = parentAmount.multiply(lastPeriodAmount).divide(lastParentAmount, 15, RoundingMode.HALF_UP);
                        parentAmountRemain = parentAmountRemain.subtract(currentPeriodAmount);
                    }
                    treeNode.setTabChange(this.getNewAmount(currentPeriodAmount));
                    treeNode.setLastPeriod(this.getNewAmount(lastPeriodAmount));
                    BigDecimal divide = currentPeriodAmount.multiply(new BigDecimal(100)).divide(currentTotalAmount, 15, RoundingMode.HALF_UP);
                    treeNode.setTabRatio(divide);
                } else if (DecomposeAgentEnum.AVG.getValue().equals(decomposeAgent)) {
                    if (firstHasLastDataIndex == null) {
                        firstHasLastDataIndex = decomposeTreeNodes.size() - 1;
                    }
                    BigDecimal apportionValue = parentAmount.divide(BigDecimal.valueOf(members.size()), 15, RoundingMode.HALF_UP);
                    parentAmountRemain = parentAmountRemain.subtract(apportionValue);
                    treeNode.setTabChange(this.getNewAmount(apportionValue));
                    BigDecimal divide = apportionValue.multiply(new BigDecimal(100)).divide(currentTotalAmount, 15, RoundingMode.HALF_UP);
                    treeNode.setTabRatio(divide);
                }
            }
            List<Object> children = new ArrayList(10);
            if (!childMember.isLeaf() && level < DecomposeConstant.TREE_MAX_LEVEL) {
                children = this.getChildrenByView(modelCacheContext, decDimension.getDimNumber(), childMember.getNumber());
                children.removeIf(e -> DecomposeSchemeType.ADJUST.getValue().equals(schemeType) && e.isDisable() || StringUtils.equals((String)e.getAggType(), (String)AggOprtEnum.SKIP.getSign()) || e.getNumber().endsWith("offsetentry"));
                if (children.size() > 0) {
                    treeNode.setIsgroupnode(true);
                }
            }
            if (!loadAll && !logIds.contains(id)) continue;
            if (!childMember.isLeaf() && level < DecomposeConstant.TREE_MAX_LEVEL) {
                treeNode.setExpand(true);
            }
            if (!CollectionUtils.isNotEmpty(children)) continue;
            this.expendOneLevel(decomposeTreeNodes, modelCacheContext, children, memberMap, treeNode, tabValue, loadAll, decDimension, decomposeAgent, schemeType, dimViewMap);
        }
        if (parentAmountRemain.compareTo(BigDecimal.ZERO) != 0 && firstHasLastDataIndex != null) {
            DecomposeTreeNode remainNode = decomposeTreeNodes.get(firstHasLastDataIndex);
            remainNode.setTabChange(remainNode.getTabChange().add(this.getNewAmount(parentAmountRemain)));
        }
    }

    private String getDisableStr(Member member) {
        String disable = member.isDisable() ? ResManager.loadKDString((String)"\u7981\u7528", (String)"MemberListF7_7", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u542f\u7528", (String)"MemberListF7_8", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        return disable;
    }

    private Map<String, DynamicObject> getFromPid(DynamicObject[] dynamicObjects, Long pid, String dimNumber) {
        return Arrays.stream(dynamicObjects).filter(o -> pid.equals(o.getLong("pid"))).collect(Collectors.toMap(e -> {
            String srcdimensionjson = e.getString("srcdimensionjson");
            Map srcdimensionMap = this.decomposeTaskService.stringtoMap(srcdimensionjson);
            return (String)srcdimensionMap.get(dimNumber);
        }, e -> e));
    }

    private void expendOneLevel(List<DecomposeTreeNode> decomposeTreeNodes, IModelCacheHelper modelCacheContext, DynamicObject[] dynamicObjects, Long pid, BigDecimal value, String dimNumber, List<Member> members) {
        Map<String, DynamicObject> logMap = this.getFromPid(dynamicObjects, pid, dimNumber);
        for (Member childMember : members) {
            DynamicObject dynamicObject = logMap.get(childMember.getNumber());
            if (dynamicObject == null) continue;
            long id = dynamicObject.getLong("id");
            String srcdimensionjson = dynamicObject.getString("srcdimensionjson");
            DecomposeTreeNode treeNode = new DecomposeTreeNode();
            decomposeTreeNodes.add(treeNode);
            treeNode.setId(id);
            treeNode.setPid(pid);
            treeNode.setSrcdimensionjson(srcdimensionjson);
            treeNode.setTabDecdim1(childMember.getName());
            BigDecimal change = dynamicObject.getBigDecimal("value");
            BigDecimal pendingtrial = dynamicObject.getBigDecimal("pendingtrial");
            treeNode.setTabChange(this.getNewAmount(change));
            treeNode.setTabRatio(change.multiply(new BigDecimal(100)).divide(value, 15, RoundingMode.HALF_UP));
            String schemeType = this.getSchemeType();
            if (DecomposeSchemeType.ADJUST.getValue().equals(schemeType)) {
                treeNode.setTabPendingtrial(this.getNewAmount(pendingtrial));
                treeNode.setTabResult(this.getNewAmount(pendingtrial.add(change)));
            }
            treeNode.setExpand(true);
            List<Member> childrenMembers = this.getChildrenByView(modelCacheContext, dimNumber, childMember.getNumber());
            if (!CollectionUtils.isNotEmpty(childrenMembers)) continue;
            this.expendOneLevel(decomposeTreeNodes, modelCacheContext, dynamicObjects, id, value, dimNumber, childrenMembers);
        }
    }

    private BigDecimal getLastPeriodAmount(String stringStringMap, IModelCacheHelper modelCacheContext, Map<String, Long> dimViewMap) {
        Map hashMap = this.decomposeTaskService.stringtoMap(stringStringMap);
        Map lastMember = this.decomposeTaskService.getLastMember(hashMap);
        return this.decomposeTaskService.getValueFromOlap(lastMember, modelCacheContext, dimViewMap);
    }

    private String getUnit() {
        if (this.unit == null) {
            this.unit = this.getPageCache().get("unit");
        }
        return this.unit;
    }

    private void setUnit(String unit) {
        this.getPageCache().put("unit", unit);
        this.unit = unit;
    }

    private BigDecimal getNewAmount(BigDecimal value) {
        if (StringUtils.equals((String)"4", (String)this.getUnit())) {
            return value.divide(new BigDecimal(10000), 15, RoundingMode.HALF_UP);
        }
        return value;
    }

    private BigDecimal getNewSaveAmount(BigDecimal value) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (StringUtils.equals((String)"4", (String)this.getUnit())) {
            return value.multiply(new BigDecimal(10000));
        }
        return value;
    }

    private void initTabRowDimen(IModelCacheHelper modelCacheContext, List<DecDimension> decDimensions, String dimNumber, Map<String, Long> dimViewMap) {
        IDataModel dataModel = this.getModel();
        int num = 1;
        for (DecDimension decDimension : decDimensions) {
            if (StringUtils.equals((String)decDimension.getDimNumber(), (String)dimNumber)) continue;
            String decdimKey = "tab_decdim" + (num + 1);
            int rowCount = dataModel.getEntryRowCount("tree_entryentity");
            for (int rowId = 0; rowId < rowCount; ++rowId) {
                DynamicObject entryRowEntity = dataModel.getEntryRowEntity("tree_entryentity", rowId);
                String srcdimensionjson = entryRowEntity.getString("tab_dimensionjson");
                JSONObject jsonObject = JSON.parseObject((String)srcdimensionjson);
                String memberNumber = jsonObject.getString(decDimension.getDimNumber());
                Long dimViewId = dimViewMap.get(decDimension.getDimNumber());
                Member member = modelCacheContext.getMember(decDimension.getDimNumber(), dimViewId, memberNumber);
                entryRowEntity.set(decdimKey, (Object)member.getName());
            }
            ++num;
        }
    }

    private void putTaskByEntryEntityKey(QFilter qFilter, String entryEntityKey) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryEntityKey);
        String proTitle = entryEntityKey.replace("_entryentity", "");
        this.setCustomDimColumnTitle(proTitle, entryGrid);
        String selectProperties = "id,status,srcdimensionjson,decdimensionjson,viewjson,value,entity.name,modifier.id,scheme.type";
        DynamicObject[] tasks = "task_entryentity".equals(entryEntityKey) ? BusinessDataServiceHelper.load((String)"eb_decompose_task", (String)selectProperties, (QFilter[])qFilter.toArray(), (String)"status,modifydate desc") : BusinessDataServiceHelper.load((String)"eb_decompose_task", (String)selectProperties, (QFilter[])qFilter.toArray());
        this.getModel().deleteEntryData(entryEntityKey);
        IModelCacheHelper modelCacheContext = this.getModelCacheHelper();
        String unit = this.getUnit();
        if (unit == null) {
            unit = "0";
            this.setUnit(unit);
        }
        IDataModel dataModel = this.getModel();
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
        dataModel.setValue(proTitle + "_version", (Object)scheme.getDynamicObject("version").getString("name"));
        dataModel.setValue(proTitle + "_datatype", (Object)scheme.getDynamicObject("datatype").getString("name"));
        dataModel.setValue(proTitle + "_audittrail", (Object)scheme.getDynamicObject("audittrail").getString("name"));
        dataModel.setValue(proTitle + "_currency", (Object)scheme.getDynamicObject("currency").getString("name"));
        if (tasks.length < 1) {
            return;
        }
        for (DynamicObject row : tasks) {
            String srcdimensionjson = row.getString("srcdimensionjson");
            Map srcdimensionMap = this.decomposeTaskService.stringtoMap(srcdimensionjson);
            Member metricMember = modelCacheContext.getMember(SysDimensionEnum.Metric.getNumber(), null, (String)srcdimensionMap.get(SysDimensionEnum.Metric.getNumber()));
            if (!this.decomposeTaskService.metricIsCurrencyOrUnCurrencyAndHasAgg(metricMember)) continue;
            String budgetPeriod = this.decomposeTaskService.getMemberNameFromJson(modelCacheContext, srcdimensionMap, SysDimensionEnum.BudgetPeriod.getNumber());
            String account = this.decomposeTaskService.getMemberNameFromJson(modelCacheContext, srcdimensionMap, SysDimensionEnum.Account.getNumber());
            String changeType = this.decomposeTaskService.getMemberNameFromJson(modelCacheContext, srcdimensionMap, SysDimensionEnum.ChangeType.getNumber());
            String decDimensionJson = row.getString("decdimensionjson");
            List decDimensions = JSONArray.parseArray((String)decDimensionJson, DecDimension.class);
            int rowId = this.getModel().createNewEntryRow(entryEntityKey);
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(entryEntityKey, rowId);
            entryRowEntity.set(proTitle + "id", (Object)row.getLong("id"));
            entryRowEntity.set(proTitle + "_entity", (Object)row.getString("entity.name"));
            entryRowEntity.set(proTitle + "_account", (Object)account);
            entryRowEntity.set(proTitle + "_metric", (Object)metricMember.getName());
            entryRowEntity.set(proTitle + "_budgetperiod", (Object)budgetPeriod);
            entryRowEntity.set(proTitle + "_changetype", (Object)changeType);
            entryRowEntity.set(proTitle + "_decdimension", (Object)this.decomposeTaskService.getDecdimensionStr(modelCacheContext, decDimensions));
            entryRowEntity.set(proTitle + "_status", (Object)TaskStatus.getTextByValue((Integer)row.getInt("status")));
            entryRowEntity.set(proTitle + "_value", (Object)this.getNewAmount(row.getBigDecimal("value")));
            if ("task_entryentity".equals(entryEntityKey)) {
                entryRowEntity.set(proTitle + "_decomposer", row.get("modifier"));
            } else {
                entryRowEntity.set(proTitle + "_decdimensionjson", (Object)decDimensionJson);
                entryRowEntity.set(proTitle + "_viewjson", (Object)row.getString("viewjson"));
            }
            Map viewMap = (Map)JSON.parseObject((String)row.getString("viewjson"), HashMap.class);
            Map dimViewMap = AdjustServiceHelper.getDimViewMap((Map)viewMap);
            this.setCustomDimColumn(modelCacheContext, srcdimensionMap, dimViewMap, entryRowEntity, proTitle);
        }
        this.getModel().setDataChanged(false);
        if ("task_entryentity".equals(entryEntityKey)) {
            entryGrid.setPageIndex(1);
        }
        this.getView().updateView(entryEntityKey);
        this.clearSelection(entryEntityKey);
        if ("target_entryentity".equals(entryEntityKey)) {
            entryGrid.clickCell("target_status", 0);
            entryGrid.selectRows(0);
            this.setEntryGridColor(entryEntityKey, "target_status");
        } else {
            this.setEntryGridColor(entryEntityKey, "task_status");
        }
    }

    private void setEntryGridColor(String entryGridKey, String fieldKey) {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(entryGridKey);
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryGridKey);
        this.decomposeTaskService.setEntryGridColor(dynamicObjects, entryGrid, fieldKey);
    }

    private void clearSelection(String entryEntityKey) {
        if ("target_entryentity".equals(entryEntityKey)) {
            EntryGrid control = (EntryGrid)this.getControl("task_entryentity");
            control.clearEntryState();
        } else if ("task_entryentity".equals(entryEntityKey)) {
            EntryGrid control = (EntryGrid)this.getControl("target_entryentity");
            control.clearEntryState();
        }
    }

    public void afterCreateNewData(EventObject e) {
        try {
            super.afterCreateNewData(e);
            Long modelId = UserSelectUtils.getUserSelectModelId((IFormView)this.getView());
            if (IDUtils.isNotNull((Long)modelId)) {
                this.getModel().setValue("model", (Object)modelId);
                long businessModelId = UserSelectUtils.getUserSelectBusinessModelId((IFormView)this.getView(), (long)modelId);
                this.modelChanged(businessModelId);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"DecomposeTaskPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            ArrayList<ComboItem> itemList = new ArrayList<ComboItem>(10);
            for (DecomposeAgentEnum value : DecomposeAgentEnum.values()) {
                ComboItem item = new ComboItem(new LocaleString(value.getName()), value.getValue());
                itemList.add(item);
            }
            ComboEdit dimCombo = (ComboEdit)this.getControl("decompose_agent");
            dimCombo.setComboItems(itemList);
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
    }

    private void modelChanged(Long bizModelId) {
        this.getPageCache().put("model", String.valueOf(this.getModelId()));
        this.setDefaultBusinessModel(bizModelId);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        try {
            String actionId = evt.getActionId();
            if ("bizmodelclick".equals(actionId)) {
                Long bizModelId1;
                Long bizModelId;
                ListSelectedRowCollection returnData;
                if (evt.getReturnData() instanceof ListSelectedRowCollection && (returnData = (ListSelectedRowCollection)evt.getReturnData()).size() > 0 && !Objects.equals(bizModelId = (Long)returnData.get(0).getPrimaryKeyValue(), bizModelId1 = this.getBizModelId())) {
                    this.getPageCache().put("bizModelId", String.valueOf(bizModelId));
                    if (this.showChangeFlagConfirm("confirm_bizmodel_change")) {
                        return;
                    }
                    this.businessModelChanged(bizModelId);
                }
            } else if ("dimension_order".equals(actionId)) {
                if (evt.getReturnData() != null) {
                    String returnData = (String)evt.getReturnData();
                    String replace = returnData.replace(",", "\uff0c");
                    EntryGrid entryGrid = (EntryGrid)this.getView().getControl("target_entryentity");
                    String dimensionIndex = this.getPageCache().get("dimensionIndex");
                    int index = Integer.parseInt(dimensionIndex);
                    String dimension = (String)entryGrid.getModel().getValue("target_decdimension", index);
                    if (!StringUtils.equals((String)replace, (String)dimension)) {
                        this.getPageCache().put("newDimension", replace);
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u91cd\u65b0\u8bbe\u7f6e\u201c\u5206\u89e3\u7ef4\u5ea6\u987a\u5e8f\u201d\uff0c\u5c06\u4f1a\u6e05\u7a7a\u672a\u4fdd\u5b58\u7684\u6570\u636e\uff0c\u662f\u5426\u786e\u8ba4\u91cd\u65b0\u8bbe\u7f6e\uff1f", (String)"DecomposeTaskPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirm_select", (IFormPlugin)this));
                    }
                }
            } else if ("close_import".equals(actionId) && evt.getReturnData() != null) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f!", (String)"DecomposeTaskPlugin_49", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                Tab tab = (Tab)this.getView().getControl("tabap");
                String currentTab = tab.getCurrentTab();
                this.initTabData(currentTab);
                this.submitDecLog(false, false);
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private void saveTargetDecDimension() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("target_entryentity");
        String dimensionIndex = this.getPageCache().get("dimensionIndex");
        int index = Integer.parseInt(dimensionIndex);
        String dimensionJson = (String)entryGrid.getModel().getValue("target_decdimensionjson", index);
        String dimensionStr = (String)entryGrid.getModel().getValue("target_decdimension", index);
        long targetId = (Long)entryGrid.getModel().getValue("targetid", index);
        List decDimensions = JSONArray.parseArray((String)dimensionJson, DecDimension.class);
        HashMap<String, DecDimension> hashMap = new HashMap<String, DecDimension>(16);
        for (DecDimension decDimension : decDimensions) {
            String[] dimNumber = decDimension.getDimNumber();
            IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
            Dimension dimension = modelCacheHelper.getDimension((String)dimNumber);
            if (dimension == null) continue;
            String name = dimension.getName();
            hashMap.put(name, decDimension);
        }
        String[] split = dimensionStr.split("\uff0c");
        ArrayList<DecDimension> list = new ArrayList<DecDimension>(10);
        for (String s : split) {
            DecDimension decDimension = (DecDimension)hashMap.get(s);
            if (decDimension == null) continue;
            list.add(decDimension);
        }
        if (CollectionUtils.isNotEmpty(list)) {
            String newDimensionJson = JSONArray.toJSONString(list);
            entryGrid.getModel().setValue("target_decdimensionjson", (Object)newDimensionJson);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)targetId, (String)"eb_decompose_task", (String)"decdimensionjson");
            dynamicObject.set("decdimensionjson", (Object)newDimensionJson);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    private void setDefaultBusinessModel(Long bizModelId) {
        if (bizModelId == null || bizModelId == 0L) {
            QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
            DynamicObjectCollection businessModelCollection = QueryServiceHelper.query((String)"eb_businessmodel", (String)"id,name,number", (QFilter[])qFilter.toArray(), (String)"createdate");
            if (businessModelCollection == null || businessModelCollection.size() == 0) {
                return;
            }
            bizModelId = ((DynamicObject)businessModelCollection.get(0)).getLong("id");
        }
        this.businessModelChanged(bizModelId);
    }

    private void businessModelChanged(Long bizModelId) {
        UserSelectUtils.saveUserSelectBusinessModelId((IFormView)this.getView(), (long)this.getModelId(), (long)bizModelId);
        this.showSchemeTask();
        this.getModel().setValue("bizmodel", (Object)bizModelId);
        this.setBizModelCache(bizModelId);
        this.updateBizModelLabels();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_done", "btn_cancel"});
        this.buildLeftTreeData(this.getModelId(), bizModelId, true);
    }

    protected Long getBizModelId() {
        Long bizModelId = 0L;
        DynamicObject bizmodel = (DynamicObject)this.getModel().getValue("bizmodel");
        if (bizmodel != null) {
            return (Long)bizmodel.getPkValue();
        }
        return bizModelId;
    }

    private void deleteAll() {
        IDataModel model = this.getModel();
        this.showSchemeTask();
        model.deleteEntryData("scheme_task_entryentity");
        model.deleteEntryData("task_entryentity");
        model.deleteEntryData("target_entryentity");
        model.deleteEntryData("tree_entryentity");
        this.getView().updateView("scheme_task_entryentity");
        this.getView().updateView("task_entryentity");
        this.getView().updateView("target_entryentity");
        this.getView().updateView("tree_entryentity");
    }

    private void setBizModelCache(Long bizModelId) {
        this.getView().getPageCache().put("bizmodel", String.valueOf(bizModelId));
    }

    private void updateBizModelLabels() {
        String modelname = ((DynamicObject)this.getModel().getValue("bizmodel")).getString("name");
        ((Label)this.getControl("bizmodellabel")).setText(modelname);
    }

    private void showBizModelForm() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_listf7");
        listShowParameter.setBillFormId("eb_businessmodel");
        listShowParameter.setShowUsed(true);
        listShowParameter.setLookUp(true);
        listShowParameter.setMultiSelect(false);
        listShowParameter.setShowApproved(true);
        listShowParameter.setShowTitle(false);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        listShowParameter.getOpenStyle().setInlineStyleCss(css);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bizmodelclick"));
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("bizmodel");
        ArrayList<QFilter> qFilterList = basedataEdit.getQFilters();
        if (qFilterList == null) {
            qFilterList = new ArrayList<QFilter>(16);
        }
        qFilterList.add(new QFilter("model", "=", (Object)this.getModelId()));
        if (listShowParameter.getCustomParams() != null) {
            listShowParameter.getCustomParams().put("noNeedDefaultQFilter", "true");
        }
        listShowParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    @Override
    public Long getModelId() {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        if (model == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ModifyNotePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return (Long)model.getPkValue();
    }

    private QFilter getLeftTreeQfilter(Long modelId, Long bizModelId) {
        QFilter qFilter = new QFilter("scheme.model", "=", (Object)modelId);
        qFilter.and("scheme.bizmodel", "=", (Object)bizModelId);
        LinkedList<String> list = new LinkedList<String>();
        list.add(DecomposeSchemeStatus.START.getNumber());
        list.add(DecomposeSchemeStatus.FINISHED.getNumber());
        qFilter.and("scheme.status", "in", list);
        this.andHasPermEntityQfilter(qFilter, modelId, bizModelId);
        return qFilter;
    }

    private void andHasPermEntityQfilter(QFilter qFilter, Long modelId, Long bizModelId) {
        boolean modelManage = MemberPermHelper.ifUserHasRootPermByModel((long)UserUtils.getUserId(), (String)String.valueOf(modelId));
        if (!modelManage) {
            HashSet hasPermEntitySet = new HashSet(16);
            List viewIds = this.getIModelCacheHelper().getViewGroupViewsByBusModelAndDimNumber(bizModelId, SysDimensionEnum.Entity.getNumber());
            for (Long viewId : viewIds) {
                Set readPermMembIds = DimMembPermHelper.getReadPermMembIds((String)SysDimensionEnum.Entity.getNumber(), (Long)modelId, (Long)bizModelId, (Long)viewId, (boolean)true);
                if (readPermMembIds == null) continue;
                hasPermEntitySet.addAll(readPermMembIds);
            }
            if (hasPermEntitySet.isEmpty()) {
                qFilter.and("1", "=", (Object)2);
            } else {
                qFilter.and("entity", "in", hasPermEntitySet);
            }
        }
    }

    private void queryLeftTreeNodeChildren(TreeNodeEvent event) {
        String schemeId = (String)event.getNodeId();
        TreeView tv = (TreeView)event.getSource();
        this.queryLeftTreeNodeChildren(tv, schemeId, null);
    }

    private void queryLeftTreeNodeChildren(TreeView tv, String schemeId, String focusNodeId) {
        try {
            LinkedList<TreeNode> nodes = new LinkedList<TreeNode>();
            TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("lefttreecache"), TreeNode.class);
            TreeNode schemeNode = rootNode.getTreeNode(schemeId, 1);
            QFilter qFilter = this.getLeftTreeQfilter(this.getModelId(), this.getBizModelId());
            qFilter.and("scheme", "=", (Object)Long.parseLong(schemeId));
            String oql = "select entity.id,entity.number,entity.name from eb_decompose_task where " + qFilter + " group by entity.id,entity.number,entity.name";
            DataSet ds = ORM.create().queryDataSet(this.getClass().getName(), oql, new Object[0]);
            if (ds == null || ds.isEmpty()) {
                return;
            }
            IModelCacheHelper modelCacheContext = this.getModelCacheHelper();
            HashMap<String, TreeNode> treeNodeMap = new HashMap<String, TreeNode>(16);
            List<Object> members = new ArrayList(10);
            List<Object> pViewMembers = new ArrayList(10);
            String dim = SysDimensionEnum.Entity.getNumber();
            Long viewId = this.getEntityViewId(Long.parseLong(schemeId));
            while (ds.hasNext()) {
                Row row = ds.next();
                Long memberId = row.getLong("entity.id");
                Member member = modelCacheContext.getMember(dim, viewId, memberId);
                if (member == null) continue;
                members.add(member);
            }
            members = members.stream().sorted(Comparator.comparing(Member::getLevel)).collect(Collectors.toList());
            pViewMembers = pViewMembers.stream().sorted(Comparator.comparing(Member::getLevel)).collect(Collectors.toList());
            Long bizModelId = this.getBizModelId();
            for (Member member : members) {
                this.addChild(nodes, schemeNode, schemeId, modelCacheContext, member, treeNodeMap, viewId, bizModelId);
            }
            for (Member member : pViewMembers) {
                this.addChild(nodes, schemeNode, schemeId, modelCacheContext, member, treeNodeMap, viewId, bizModelId);
            }
            for (TreeNode treeNode : nodes) {
                if (StringUtils.equals((String)treeNode.getId(), (String)focusNodeId)) {
                    treeNode.setIsOpened(true);
                    break;
                }
                if (treeNode.getTreeNode(focusNodeId, 100) == null) continue;
                treeNode.setIsOpened(true);
            }
            this.getPageCache().put("lefttreecache", SerializationUtils.toJsonString((Object)rootNode));
            TreeSearchUtil.clearSearchPageCache(this.getPageCache(), new TreeSearchUtil.TreeSearchParam("lefttree", "lefttreecache"));
            tv.addNodes(nodes);
        }
        catch (Exception e) {
            log.error(CommonServiceHelper.getStackTraceStr((Throwable)e));
            throw new KDBizException(e.getMessage());
        }
    }

    private void addChild(List<TreeNode> nodes, TreeNode schemeNode, String schemeId, IModelCacheHelper modelCacheContext, Member member, Map<String, TreeNode> treeNodeMap, Long viewId, Long bizModelId) {
        if (member != null) {
            String nodeId = schemeId + "!" + member.getId();
            String memberName = member.getName();
            String parentId = this.getParentId(modelCacheContext, member, treeNodeMap, schemeId, viewId, bizModelId);
            if (StringUtils.isNotEmpty((String)parentId)) {
                TreeNode parentTreeNode = treeNodeMap.get(parentId);
                TreeNode treeNode = new TreeNode(parentId, nodeId, memberName);
                treeNodeMap.put(nodeId, treeNode);
                parentTreeNode.addChild(treeNode);
                nodes.add(treeNode);
            } else {
                TreeNode treeNode = new TreeNode(schemeId, nodeId, memberName);
                treeNodeMap.put(nodeId, treeNode);
                schemeNode.addChild(treeNode);
                nodes.add(treeNode);
            }
        }
    }

    private String getParentId(IModelCacheHelper modelCacheContext, Member member, Map<String, TreeNode> treeNodeMap, String schemeId, Long viewId, Long bizModelId) {
        if (member == null) {
            return null;
        }
        String parentId = schemeId + "!" + member.getParentId();
        if (treeNodeMap.containsKey(parentId)) {
            return parentId;
        }
        String dimNumber = member.getDimension().getNumber();
        Long parentId1 = member.getParentId();
        Member member1 = modelCacheContext.getMember(dimNumber, viewId, parentId1);
        return this.getParentId(modelCacheContext, member1, treeNodeMap, schemeId, viewId, bizModelId);
    }

    private void buildLeftTreeData(Long modelId, Long bizModelId, boolean clickFlag) {
        TreeView tv = (TreeView)this.getView().getControl("lefttree");
        tv.getTreeState().getSelectedNodeId();
        String focusNodeId = tv.getTreeState().getFocusNodeId();
        String focusSchemeId = null;
        if (focusNodeId != null) {
            focusSchemeId = focusNodeId.split("!")[0];
        }
        tv.deleteAllNodes();
        QFilter qFilter = this.getLeftTreeQfilter(modelId, bizModelId);
        String oql = "select scheme.id,scheme.number,scheme.name from eb_decompose_task where " + qFilter + " group by scheme.id,scheme.number,scheme.name";
        DataSet ds = ORM.create().queryDataSet(this.getClass().getName(), oql, new Object[0]);
        if (ds == null || ds.isEmpty()) {
            this.deleteAll();
            return;
        }
        TreeNode rootNode = new TreeNode();
        rootNode.setIsOpened(true);
        rootNode.setId("0");
        rootNode.setText("0");
        HashSet<Long> schemeIds = new HashSet<Long>(16);
        while (ds.hasNext()) {
            Row row = ds.next();
            Long schemeId = row.getLong("scheme.id");
            String schemeName = row.getString("scheme.name");
            if (!schemeIds.add(schemeId)) continue;
            TreeNode treeNode = new TreeNode("0", String.valueOf(schemeId), schemeName, true);
            rootNode.addChild(treeNode);
        }
        ds.close();
        this.getPageCache().put("lefttreecache", SerializationUtils.toJsonString((Object)rootNode));
        TreeSearchUtil.clearSearchPageCache(this.getPageCache(), new TreeSearchUtil.TreeSearchParam("lefttree", "lefttreecache"));
        tv.addNode(rootNode);
        tv.setRootVisible(false);
        List childrenNodes = rootNode.getChildren();
        TreeNode selectNode = (TreeNode)childrenNodes.get(0);
        if (StringUtils.isNotEmpty((String)focusSchemeId)) {
            for (TreeNode treeNode : childrenNodes) {
                if (!StringUtils.equals((String)focusSchemeId, (String)treeNode.getId())) continue;
                selectNode = treeNode;
                break;
            }
        }
        this.getModel().setValue("scheme", (Object)Long.parseLong(selectNode.getId()));
        this.queryLeftTreeNodeChildren(tv, selectNode.getId(), focusNodeId);
        rootNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("lefttreecache"), TreeNode.class);
        TreeNode focusNode = rootNode.getTreeNode(focusNodeId, 100);
        if (clickFlag) {
            if (focusNode == null) {
                focusNode = selectNode;
            }
            tv.focusNode(focusNode);
            tv.treeNodeClick(focusNode.getParentid(), focusNode.getId());
        } else {
            tv.focusNode(focusNode);
        }
        tv.expand(selectNode.getId());
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        try {
            String nodeId = (String)evt.getNodeId();
            if (this.showChangeFlagConfirm("confirm_tree_click")) {
                return;
            }
            this.treeClick(nodeId);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private void treeClick(String nodeId) {
        try {
            DynamicObject dynamicObject;
            this.deleteAll();
            String[] strings = nodeId.split("!");
            Long schemeId = this.getSchemeIdFromNodeId(nodeId);
            this.getModel().setValue("scheme", (Object)schemeId);
            if (strings.length > 1) {
                this.getPageCache().put("entityIdCache", strings[1]);
            }
            if (strings.length == 1) {
                this.showSchemeTask();
                dynamicObject = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"eb_decompose_scheme", (String)"id,status,type");
                if (dynamicObject != null) {
                    String type = dynamicObject.getString("type");
                    this.showDecomposeComplete(DecomposeSchemeType.TARGET.getValue().equals(type));
                }
                this.getTaskByScheme(schemeId);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_issue"});
            } else {
                this.showEntityTask();
                this.showDecomposeComplete(false);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_issue"});
                this.getTaskByEntity();
            }
            dynamicObject = (DynamicObject)this.getModel().getValue("scheme");
            this.getView().setVisible(Boolean.valueOf(DecomposeSchemeType.TARGET.getValue().equals(dynamicObject.getString("type"))), new String[]{"btn_cancel"});
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private void showDecomposeComplete(boolean b) {
        this.getView().setVisible(Boolean.valueOf(b), new String[]{"btn_done"});
    }

    private void showSchemeTask() {
        this.getPageCache().put("panel", "scheme_taskpanel");
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"scheme_taskpanel", "btn_start"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"entity_taskpanel", "decompose_targetpanel", "btn_issue", "decompose_result", "floatmenuap"});
        IDataModel model = this.getModel();
        model.deleteEntryData("task_entryentity");
        model.deleteEntryData("target_entryentity");
        model.deleteEntryData("tree_entryentity");
    }

    private void showDecomposeTarget() {
        IFormView iFormView = this.getView();
        this.getPageCache().put("panel", "decompose_targetpanel");
        iFormView.setVisible(Boolean.valueOf(true), new String[]{"decompose_targetpanel", "btn_issue"});
        iFormView.setVisible(Boolean.valueOf(false), new String[]{"entity_taskpanel", "scheme_taskpanel", "btn_start", "decompose_result", "floatmenuap"});
        IDataModel model = this.getModel();
        model.deleteEntryData("task_entryentity");
        model.deleteEntryData("scheme_task_entryentity");
        for (int i = 1; i <= DecomposeConstant.CUSTOM_DIM_NUM; ++i) {
            iFormView.setVisible(Boolean.valueOf(false), new String[]{"target_customdim" + i});
        }
    }

    private void showEntityTask() {
        this.getPageCache().put("panel", "entity_taskpanel");
        IFormView iFormView = this.getView();
        iFormView.setVisible(Boolean.valueOf(true), new String[]{"entity_taskpanel", "btn_start", "floatmenuap"});
        iFormView.setVisible(Boolean.valueOf(false), new String[]{"scheme_taskpanel", "decompose_targetpanel", "btn_issue", "decompose_result"});
        IDataModel model = this.getModel();
        model.deleteEntryData("scheme_task_entryentity");
        model.deleteEntryData("target_entryentity");
        model.deleteEntryData("tree_entryentity");
        for (int i = 1; i <= DecomposeConstant.CUSTOM_DIM_NUM; ++i) {
            iFormView.setVisible(Boolean.valueOf(false), new String[]{"task_customdim" + i});
        }
    }

    private void getTaskByEntity() {
        String entityId = this.getPageCache().get("entityIdCache");
        if (StringUtils.isNotEmpty((String)entityId)) {
            DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
            if (scheme == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5206\u89e3\u65b9\u6848\u4e0d\u5b58\u5728\u3002", (String)"DecomposeTaskPlugin_53", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            Long schemeId = scheme.getLong("id");
            this.getModel().setValue("scheme", (Object)schemeId);
            QFilter qFilter1 = new QFilter("scheme.id", "=", (Object)schemeId);
            qFilter1.and("scheme.status", "!=", (Object)DecomposeSchemeStatus.SAVE.getNumber());
            qFilter1.and("entity.id", "=", (Object)Long.parseLong(entityId));
            this.putTaskByEntryEntityKey(qFilter1, "task_entryentity");
        }
    }

    private void setCustomDimColumn(IModelCacheHelper modelCacheContext, Map<String, String> srcdimensionMap, Map<String, Long> dimViewMap, DynamicObject entryRowEntity, String proTitle) {
        Map customdimKeyMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("customdimKeyMap"), Map.class);
        List dimensionList = modelCacheContext.getDimensionListByBusModel(this.getBizModelId());
        for (Dimension dimension : dimensionList) {
            String fieldKey;
            if (dimension.isPreset() || (fieldKey = (String)customdimKeyMap.get(proTitle + "_" + dimension.getNumber())) == null) continue;
            this.getView().setVisible(Boolean.valueOf(true), new String[]{fieldKey});
            Long dimViewId = dimViewMap.get(dimension.getNumber());
            Member member = dimension.getMember(dimViewId, srcdimensionMap.get(dimension.getNumber()));
            if (member == null) {
                member = dimension.getMember(dimViewId, dimension.getNoneNumber());
            }
            entryRowEntity.set(fieldKey, (Object)this.decomposeTaskService.getMemberName(member));
        }
    }

    private void setCustomDimColumnTitle(String proTitle, EntryGrid entryGrid) {
        int customdimNum = 1;
        IModelCacheHelper modelCacheContext = this.getModelCacheHelper();
        List dimensionList = modelCacheContext.getDimensionListByBusModel(this.getBizModelId());
        HashMap<String, String> customdimKeyMap = new HashMap<String, String>(dimensionList.size());
        for (Dimension dimension : dimensionList) {
            if (dimension.isPreset()) continue;
            String fieldKey = proTitle + "_customdim" + customdimNum;
            customdimKeyMap.put(proTitle + "_" + dimension.getNumber(), fieldKey);
            entryGrid.setColumnProperty(fieldKey, "header", (Object)new LocaleString(dimension.getName()));
            ++customdimNum;
        }
        this.getPageCache().put("customdimKeyMap", SerializationUtils.toJsonString(customdimKeyMap));
    }

    private void getTaskByScheme(Long schemeId) {
        QFilter qFilter = new QFilter("scheme.id", "=", (Object)schemeId);
        qFilter.and("scheme.status", "!=", (Object)DecomposeSchemeStatus.SAVE.getNumber());
        this.andHasPermEntityQfilter(qFilter, this.getModelId(), this.getBizModelId());
        String selectProperties = "status,srcdimensionjson,scheme.number,scheme.name,entity.id,entity.number,entity.name";
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)"eb_decompose_task", (String)selectProperties, (QFilter[])qFilter.toArray(), (String)"status,modifydate desc");
        IDataModel model = this.getModel();
        model.deleteEntryData("scheme_task_entryentity");
        if (tasks.length < 1) {
            return;
        }
        IModelCacheHelper modelCacheContext = this.getModelCacheHelper();
        for (DynamicObject row : tasks) {
            Map srcdimensionMap = this.decomposeTaskService.stringtoMap(row.getString("srcdimensionjson"));
            Member metricMember = modelCacheContext.getMember(SysDimensionEnum.Metric.getNumber(), null, (String)srcdimensionMap.get(SysDimensionEnum.Metric.getNumber()));
            if (!this.decomposeTaskService.metricIsCurrencyOrUnCurrencyAndHasAgg(metricMember)) continue;
            String version = this.decomposeTaskService.getMemberNameFromJson(modelCacheContext, srcdimensionMap, SysDimensionEnum.Version.getNumber());
            String dataType = this.decomposeTaskService.getMemberNameFromJson(modelCacheContext, srcdimensionMap, SysDimensionEnum.DataType.getNumber());
            String budgetPeriod = this.decomposeTaskService.getMemberNameFromJson(modelCacheContext, srcdimensionMap, SysDimensionEnum.BudgetPeriod.getNumber());
            int rowId = model.createNewEntryRow("scheme_task_entryentity");
            DynamicObject entryRowEntity = model.getEntryRowEntity("scheme_task_entryentity", rowId);
            entryRowEntity.set("number", (Object)row.getString("scheme.number"));
            entryRowEntity.set("name", (Object)row.getString("scheme.name"));
            entryRowEntity.set("datatype", (Object)dataType);
            entryRowEntity.set("version", (Object)version);
            entryRowEntity.set("budgetperiods", (Object)budgetPeriod);
            entryRowEntity.set("status", (Object)TaskStatus.getTextByValue((Integer)row.getInt("status")));
            entryRowEntity.set("entity", (Object)row.getString("entity.name"));
        }
        this.getModel().setDataChanged(false);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("scheme_task_entryentity");
        entryGrid.setPageIndex(1);
        this.getView().updateView("scheme_task_entryentity");
        this.setEntryGridColor("scheme_task_entryentity", "status");
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        try {
            EntryGrid entryGrid = (EntryGrid)cellClickEvent.getSource();
            String fieldKey = cellClickEvent.getFieldKey();
            if ("target_decdimension".equals(fieldKey)) {
                return;
            }
            int row = cellClickEvent.getRow();
            if (row < 0) {
                return;
            }
            if (this.showChangeFlagConfirm("confirm_cell_click")) {
                return;
            }
            this.doCellClick(entryGrid.getKey(), row);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private Long getEntityViewId(Long schemeId) {
        DynamicObject scheme = QueryServiceHelper.queryOne((String)"eb_decompose_scheme", (String)"entityview.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeId)});
        if (scheme != null) {
            return scheme.getLong("entityview.id");
        }
        return 0L;
    }

    private Long getViewId(String dimNumber) {
        IModelCacheHelper modelCacheHelper;
        Map viewsByBusModel;
        Long viewId = null;
        String viewJson = this.getViewJson();
        if (!StringUtils.isEmpty((String)viewJson)) {
            JSONObject jsonObject = JSONObject.parseObject((String)viewJson);
            viewId = jsonObject.getLong(dimNumber);
        }
        if (viewId == null && (viewsByBusModel = (modelCacheHelper = this.getModelCacheHelper()).getViewsByBusModel(this.getBizModelId())) != null) {
            viewId = (Long)viewsByBusModel.get(dimNumber);
        }
        if (viewId == null) {
            viewId = 0L;
        }
        return viewId;
    }

    private Long getSchemeId() {
        DynamicObject object = (DynamicObject)this.getModel().getValue("scheme");
        if (object == null) {
            return 0L;
        }
        return object.getLong("id");
    }

    private DynamicObject getScheme() {
        DynamicObject object = (DynamicObject)this.getModel().getValue("scheme");
        if (object == null) {
            throw new KDBizException("scheme is null");
        }
        return BusinessDataServiceHelper.loadSingle((Object)object.getPkValue(), (String)"eb_decompose_scheme");
    }

    private String getSchemeType() {
        DynamicObject object = (DynamicObject)this.getModel().getValue("scheme");
        if (object == null) {
            return null;
        }
        return object.getString("type");
    }

    private void doCellClick(String key, int index) {
        IFormView view = this.getView();
        if ("target_entryentity".equals(key)) {
            IModelCacheHelper modelCacheContext = this.getModelCacheHelper();
            view.setVisible(Boolean.valueOf(true), new String[]{"decompose_result"});
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(key, index);
            Long taskId = entryRowEntity.getLong("targetid");
            EntryGrid entryGrid = (EntryGrid)view.getControl("target_entryentity");
            int focusRow = entryGrid.getEntryState().getFocusRow();
            this.getPageCache().put("currentIndex", String.valueOf(focusRow));
            this.getPageCache().put("currentTaskId", String.valueOf(taskId));
            String decDimensionJson = entryRowEntity.getString("target_decdimensionjson");
            List decDimensions = JSONArray.parseArray((String)decDimensionJson, DecDimension.class);
            String schemeType = this.getSchemeType();
            if (DecomposeSchemeType.TARGET.getValue().equals(schemeType)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"tab_ratio"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"tab_pendingtrial", "tab_result"});
                this.getPageCache().put("decompose_agent", (String)this.getModel().getValue("decompose_agent"));
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"decompose_agent"});
            } else if (DecomposeSchemeType.ADJUST.getValue().equals(schemeType)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"tab_ratio", "last_period"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"decompose_agent"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"tab_pendingtrial", "tab_result"});
            }
            this.initTabTitle(view, modelCacheContext, decDimensions);
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        IDataEntityProperty property = beforeF7SelectEvent.getProperty();
        if (property == null) {
            return;
        }
        String key = property.getName();
        ListShowParameter showP = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if ("model".equals(key)) {
            ArrayList qFilterList = ((BasedataEdit)this.getControl("model")).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList(10);
            }
            qFilterList.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
            showP.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }
}

