/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.decompose.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.CellStyle;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.decompose.TaskStatus;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class DecomposeTaskProcessPlugin
extends AbstractFormPlugin
implements TreeNodeQueryListener,
SearchEnterListener {
    private static final String FORM_DECOMPOSE_TASK = "eb_decompose_task";
    private static final String FORM_DECOMPOSE_SCHEME = "eb_decompose_scheme";
    private static final String TREE_ENTRYENTITY = "treeentryentity";
    private static final String LAST_PROCESS_DATE = "last_process_date";
    private static final String LAST_ACCEPT_DATE = "last_accept_date";
    private static final String MODIFIER = "modifier";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String PID = "pid";
    private static final String ID = "id";
    private static final String TOOLBARAP = "toolbarap";
    private static final String SEARCH_MEMBER = "searchmember";
    private static final String MEMBER_PREVIOUS = "upmember";
    private static final String MEMBER_DOWN = "downmember";
    private static final String CACHE_SEARCHRESULT = "searchResult";
    private static final String CACHE_CURRENTFOCUS = "currentFocus";

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREE_ENTRYENTITY);
        treeEntry.addCellClickListener((TreeNodeQueryListener)this);
        this.addItemClickListeners(new String[]{TOOLBARAP});
        Search searchMember = (Search)this.getControl(SEARCH_MEMBER);
        searchMember.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{MEMBER_PREVIOUS, MEMBER_DOWN});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (BTN_REFRESH.equals(itemKey)) {
            this.refresh();
        }
    }

    private void refresh() {
        int focusRowIndex = this.getModel().getEntryCurrentRowIndex(TREE_ENTRYENTITY);
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREE_ENTRYENTITY);
        ArrayList exids = (ArrayList)treeEntry.getExpandNodes();
        if (exids == null) {
            exids = new ArrayList(10);
        }
        this.initMemberTree();
        treeEntry = (TreeEntryGrid)this.getControl(TREE_ENTRYENTITY);
        ArrayList<Integer> rowIndexs = new ArrayList<Integer>(10);
        for (int i = 0; i < exids.size(); ++i) {
            int row = -1;
            DynamicObjectCollection objs = this.getModel().getEntryEntity(TREE_ENTRYENTITY);
            for (int j = 0; j < objs.size(); ++j) {
                if (!exids.contains(((DynamicObject)objs.get(j)).getString(ID))) continue;
                row = j;
                if (rowIndexs.contains(row)) {
                    row = -1;
                    continue;
                }
                rowIndexs.add(row);
                break;
            }
            if (row < 0) continue;
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("rowkey", row);
            map.put(ID, ((DynamicObject)objs.get(row)).get(ID));
            treeEntry.loadChildrenData(map);
        }
        treeEntry.expandOne(rowIndexs.stream().mapToInt(Integer::intValue).toArray());
        treeEntry.selectRows(focusRowIndex);
        this.setTreeNodeColor();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        try {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Long schemeId = (Long)formShowParameter.getCustomParam("schemeId");
            this.getPageCache().put("schemeId", String.valueOf(schemeId));
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)schemeId, (String)FORM_DECOMPOSE_SCHEME);
            if (dynamicObject != null) {
                DynamicObject bizmodel;
                Long businessModelId;
                this.getPageCache().put("modelId", String.valueOf(dynamicObject.getDynamicObject("model").getLong(ID)));
                DynamicObject entityview = dynamicObject.getDynamicObject("entityview");
                if (entityview != null) {
                    Long entityviewId = (Long)entityview.getPkValue();
                    this.getPageCache().put("viewId", String.valueOf(entityviewId));
                }
                if (IDUtils.isNotNull((Long)(businessModelId = (Long)(bizmodel = dynamicObject.getDynamicObject("bizmodel")).getPkValue()))) {
                    this.getPageCache().put("businessModelId", String.valueOf(businessModelId));
                }
            }
            this.initMemberTree();
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
    }

    @Override
    public Long getModelId() {
        String modelId = this.getPageCache().get("modelId");
        if (modelId == null) {
            return 0L;
        }
        return Long.parseLong(modelId);
    }

    private void initMemberTree() {
        Long modelId = this.getModelId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        String viewId = this.getPageCache().get("viewId");
        Member root = modelCache.getRootMember(SysDimensionEnum.Entity.getNumber(), Long.valueOf(Long.parseLong(viewId)));
        ArrayList<Member> members = new ArrayList<Member>(10);
        members.add(root);
        this.getModel().deleteEntryData(TREE_ENTRYENTITY);
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREE_ENTRYENTITY);
        if (CollectionUtils.isEmpty((Collection)root.getChildrenNotWithCosmic())) {
            return;
        }
        IDataModel dataModel = this.getModel();
        int[] rows = dataModel.batchCreateNewEntryRow(TREE_ENTRYENTITY, members.size());
        for (int i = 0; i < members.size(); ++i) {
            Member member = (Member)members.get(i);
            int row = rows[i];
            DynamicObject entryRowEntity = dataModel.getEntryRowEntity(TREE_ENTRYENTITY, row);
            entryRowEntity.set("entitynumber", (Object)member.getNumber());
            entryRowEntity.set("entityname", (Object)member.getName());
            entryRowEntity.set(ID, (Object)member.getId());
            entryRowEntity.set(PID, (Object)0);
            this.expendOneLevel(dataModel, member, row);
        }
        treeEntry.setCollapse(true);
        treeEntry.expandOne(rows);
        this.setTreeNodeColor();
        this.getView().updateView(TREE_ENTRYENTITY);
    }

    private void setTreeNodeColor() {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREE_ENTRYENTITY);
        treeEntryGrid.setCellStyle(this.loadCellStyles());
    }

    private void expendOneLevel(IDataModel dataModel, Member member, int row) {
        List retainList = member.getChildrenNotWithCosmic(true);
        if (CollectionUtils.isEmpty((Collection)retainList)) {
            return;
        }
        this.getModel().beginInit();
        int[] rows = dataModel.batchInsertEntryRow(TREE_ENTRYENTITY, row, retainList.size());
        this.getModel().endInit();
        for (int i = 0; i < retainList.size(); ++i) {
            Member childMember = (Member)retainList.get(i);
            DynamicObject entryRowEntity = dataModel.getEntryRowEntity(TREE_ENTRYENTITY, rows[i]);
            entryRowEntity.set("entitynumber", (Object)childMember.getNumber());
            entryRowEntity.set("entityname", (Object)childMember.getName());
            Long entityId = childMember.getId();
            entryRowEntity.set(ID, (Object)entityId);
            entryRowEntity.set(PID, (Object)member.getId());
            Map<Long, DynamicObject> dynamicObjectMap = this.queryTasks(this.getSchemeId(), childMember.getId());
            DynamicObject dynamicObject = dynamicObjectMap.get(entityId);
            if (dynamicObject != null) {
                int status = dynamicObject.getInt("status");
                if (TaskStatus.DONE.getValue() == status) {
                    entryRowEntity.set("status_name", (Object)ResManager.loadKDString((String)"\u5904\u7406\u5b8c\u6210", (String)"DecomposeTaskProcessPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    entryRowEntity.set(LAST_ACCEPT_DATE, (Object)dynamicObject.getDate("createdate"));
                    entryRowEntity.set(LAST_PROCESS_DATE, (Object)dynamicObject.getDate("modifydate"));
                    entryRowEntity.set(MODIFIER, dynamicObject.get("modifier.name"));
                } else if (TaskStatus.START.getValue() == status) {
                    entryRowEntity.set("status_name", (Object)ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"DecomposeTaskProcessPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    entryRowEntity.set(LAST_ACCEPT_DATE, (Object)dynamicObject.getDate("createdate"));
                    entryRowEntity.set(LAST_PROCESS_DATE, (Object)dynamicObject.getDate("modifydate"));
                    entryRowEntity.set(MODIFIER, dynamicObject.get("modifier.name"));
                } else if (TaskStatus.WAIT.getValue() == status) {
                    entryRowEntity.set("status_name", (Object)ResManager.loadKDString((String)"\u672a\u5904\u7406", (String)"DecomposeTaskProcessPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    entryRowEntity.set(LAST_ACCEPT_DATE, (Object)dynamicObject.getDate("createdate"));
                }
                entryRowEntity.set("status", (Object)status);
            }
            if (childMember.isLeaf()) continue;
            entryRowEntity.set("isgroupnode", (Object)true);
        }
    }

    private Map<Long, DynamicObject> queryTasks(Long schemeId, Long entityId) {
        HashMap<Long, DynamicObject> hashMap = new HashMap<Long, DynamicObject>(16);
        QFilter qFilter = new QFilter("scheme", "=", (Object)schemeId);
        qFilter.and(new QFilter("entity", "=", (Object)entityId));
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)FORM_DECOMPOSE_TASK, (String)"id,entity.number,entity.name,status,modifier,createdate,modifydate", (QFilter[])qFilter.toArray());
        if (tasks.length > 0) {
            List createDate = Arrays.stream(tasks).sorted(Comparator.comparing(a -> a.getDate("createdate"), Comparator.nullsFirst(Comparator.naturalOrder()))).collect(Collectors.toList());
            List modifyDate = Arrays.stream(tasks).sorted(Comparator.comparing(a -> a.getDate("modifydate"), Comparator.nullsFirst(Comparator.naturalOrder()))).collect(Collectors.toList());
            List done = Arrays.stream(tasks).filter(dynamicObject -> TaskStatus.DONE.getValue().intValue() == dynamicObject.getInt("status")).collect(Collectors.toList());
            List start = Arrays.stream(tasks).filter(dynamicObject -> TaskStatus.START.getValue().intValue() == dynamicObject.getInt("status")).collect(Collectors.toList());
            DynamicObject create = (DynamicObject)createDate.get(0);
            DynamicObject modify = (DynamicObject)modifyDate.get(modifyDate.size() - 1);
            modify.set("createdate", (Object)create.getDate("createdate"));
            if (!CollectionUtils.isEmpty(done)) {
                if (done.size() == tasks.length) {
                    modify.set("status", (Object)TaskStatus.DONE.getValue());
                } else {
                    modify.set("status", (Object)TaskStatus.START.getValue());
                }
                hashMap.put(entityId, modify);
            } else if (!CollectionUtils.isEmpty(start)) {
                modify.set("status", (Object)TaskStatus.START.getValue());
                hashMap.put(entityId, modify);
            } else {
                modify.set("status", (Object)TaskStatus.WAIT.getValue());
                hashMap.put(entityId, modify);
            }
        } else {
            hashMap.put(entityId, null);
        }
        return hashMap;
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        Member member;
        DynamicObject next;
        Long modelId = this.getModelId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        String dimNumber = SysDimensionEnum.Entity.getNumber();
        int rowKey = evt.getRowKey();
        if (rowKey < 0) {
            return;
        }
        int entryRowCount = this.getModel().getEntryRowCount(TREE_ENTRYENTITY);
        DynamicObject obj = this.getModel().getEntryRowEntity(TREE_ENTRYENTITY, rowKey);
        long pid = obj.getLong(ID);
        DynamicObject dynamicObject = next = rowKey + 2 > entryRowCount ? null : this.getModel().getEntryRowEntity(TREE_ENTRYENTITY, rowKey + 1);
        if (next != null && next.getLong(PID) == pid && StringUtils.isNotEmpty((String)next.getString("entitynumber"))) {
            return;
        }
        String viewId = this.getPageCache().get("viewId");
        if (StringUtils.isNotEmpty((String)viewId)) {
            member = modelCache.getMember(dimNumber, Long.valueOf(Long.parseLong(viewId)), Long.valueOf(pid));
            if (member == null) {
                String businessModelId = this.getPageCache().get("businessModelId");
                Long view = modelCache.getViewByBusModelAndDimNumber(Long.valueOf(Long.parseLong(businessModelId)), dimNumber);
                member = modelCache.getMember(dimNumber, view, Long.valueOf(pid));
            }
        } else {
            member = modelCache.getMember(dimNumber, null, Long.valueOf(pid));
        }
        this.expendOneLevel(this.getModel(), member, rowKey);
        this.setTreeNodeColor();
        this.getView().updateView(TREE_ENTRYENTITY);
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREE_ENTRYENTITY);
        this.getModel().updateCache();
        this.collapseExpNode(rowKey + 1, member.getChildrenNotWithCosmic().size(), treeEntry);
    }

    private void collapseExpNode(int beginRow, int rowCount, TreeEntryGrid entryGrid) {
        if (rowCount == 0) {
            return;
        }
        int[] allRowIndexs = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            allRowIndexs[i] = beginRow + i;
        }
        entryGrid.collapseOne(allRowIndexs);
    }

    private long getSchemeId() {
        String schemeId = this.getPageCache().get("schemeId");
        if (StringUtils.isNotEmpty((String)schemeId)) {
            return Long.parseLong(schemeId);
        }
        return 0L;
    }

    private List<CellStyle> loadCellStyles() {
        ArrayList<CellStyle> resultList = new ArrayList<CellStyle>(10);
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(TREE_ENTRYENTITY);
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
            CellStyle cellStyle = new CellStyle();
            int status = dynamicObject.getInt("status");
            String color = this.selectColor(status);
            cellStyle.setForeColor(color);
            cellStyle.setRow(i);
            cellStyle.setFieldKey("status_name");
            resultList.add(cellStyle);
        }
        return resultList;
    }

    private String selectColor(int status) {
        String color = TaskStatus.START.getValue().equals(status) ? "#55A0F5" : (TaskStatus.DONE.getValue().equals(status) ? "#26B175" : (TaskStatus.WAIT.getValue().equals(status) ? "#666666" : "black"));
        return color;
    }

    public void search(SearchEnterEvent evt) {
        String text = evt.getText().trim();
        if (StringUtils.isEmpty((String)text)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8981\u67e5\u8be2\u7684\u5185\u5bb9\u3002", (String)"DecomposeTaskProcessPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.clearSearchCache();
        this.searchMember(text);
        this.setTreeNodeColor();
    }

    protected void clearSearchCache() {
        this.getPageCache().put(CACHE_SEARCHRESULT, null);
    }

    private List<Member> getMembersByView() {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        String viewIdStr = this.getPageCache().get("viewId");
        if (StringUtils.isNotEmpty((String)viewIdStr)) {
            return modelCacheHelper.getMembers(Long.valueOf(Long.parseLong(viewIdStr)), SysDimensionEnum.Entity.getNumber());
        }
        Dimension dimension = modelCacheHelper.getDimension("Entity");
        return dimension.getAllMembers();
    }

    private void searchMember(String text) {
        List<Member> members = this.getMembersByView();
        HashMap<Long, Member> memberMap = new HashMap<Long, Member>(members.size());
        for (Member member2 : members) {
            memberMap.put(member2.getId(), member2);
        }
        Member root = null;
        for (Map.Entry entry : memberMap.entrySet()) {
            Member value = (Member)entry.getValue();
            if (!SysDimensionEnum.Entity.getNumber().equals(value.getNumber())) continue;
            root = value;
            break;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>(members.size());
        List list = members.stream().filter(member -> member.getName().contains(text) || member.getNumber().contains(text)).collect(Collectors.toList());
        for (Member member3 : list) {
            arrayList.add(member3.getId());
        }
        if (arrayList.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u9879\u3002", (String)"DecomposeTaskProcessPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long focusId = (Long)arrayList.get(0);
        ArrayList<Long> parentList = new ArrayList<Long>(10);
        if (root == null) {
            return;
        }
        this.findHasLoadParent(memberMap, focusId, parentList, root.getId());
        ArrayList<Integer> expendRows = new ArrayList<Integer>(parentList.size());
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREE_ENTRYENTITY);
        for (int i = parentList.size() - 1; i > 0; --i) {
            Long parentId = (Long)parentList.get(i);
            int rowIndex = this.getEntryEntityRow(parentId);
            expendRows.add(rowIndex);
            this.expendOneEvevt(rowIndex, treeEntryGrid);
        }
        int row = this.getEntryEntityRow((Long)parentList.get(0));
        this.getView().updateView(TREE_ENTRYENTITY);
        treeEntryGrid.expandOne(expendRows.stream().mapToInt(Integer::intValue).toArray());
        treeEntryGrid.selectRows(row);
        this.getPageCache().put(CACHE_CURRENTFOCUS, focusId.toString());
        this.getPageCache().put(CACHE_SEARCHRESULT, SerializationUtils.serializeToBase64(arrayList));
    }

    private int getEntryEntityRow(Long id) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TREE_ENTRYENTITY);
        for (DynamicObject object : entryEntity) {
            if (id.longValue() != object.getLong(ID)) continue;
            return object.getInt("seq") - 1;
        }
        return -1;
    }

    private void findHasLoadParent(Map<Long, Member> map, Long id, List<Long> parentList, Long rootId) {
        parentList.add(id);
        Member object = map.get(id);
        if (object != null) {
            Long parentId = object.getParentId();
            if (parentId == 0L) {
                return;
            }
            Member parent = map.get(parentId);
            if (parent == null) {
                parentList.add(rootId);
                return;
            }
            this.findHasLoadParent(map, parentId, parentList, rootId);
        }
    }

    private void expendOneEvevt(int row, TreeEntryGrid treeEntry) {
        TreeNodeEvent treeNodeEvent = new TreeNodeEvent((Object)treeEntry);
        treeNodeEvent.setRowKey(row);
        this.queryTreeNodeChildren(treeNodeEvent);
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "upmember": 
            case "downmember": {
                this.memberSearchOperate(key);
                break;
            }
        }
    }

    private void memberSearchOperate(String key) {
        String focusId = this.getPageCache().get(CACHE_CURRENTFOCUS);
        String result = this.getPageCache().get(CACHE_SEARCHRESULT);
        if (focusId == null || result == null) {
            return;
        }
        Long focusRowId = Long.parseLong(focusId);
        List searchResult = (List)SerializationUtils.deSerializeFromBase64((String)result);
        int i = searchResult.indexOf(focusRowId);
        if (i == -1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5931\u8d25\u3002", (String)"DecomposeTaskProcessPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (MEMBER_PREVIOUS.equals(key)) {
            if (--i < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u7b2c\u4e00\u6761", (String)"DecomposeTaskProcessPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if (MEMBER_DOWN.equals(key) && ++i > searchResult.size() - 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u662f\u6700\u540e\u4e00\u884c\u6570\u636e\u3002", (String)"DecomposeTaskProcessPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        focusRowId = (Long)searchResult.get(i);
        List<Member> members = this.getMembersByView();
        if (members.size() == 0) {
            return;
        }
        HashMap<Long, Member> map = new HashMap<Long, Member>(members.size());
        Member root = null;
        for (Member member : members) {
            if (SysDimensionEnum.Entity.getNumber().equals(member.getNumber())) {
                root = member;
            }
            map.put(member.getId(), member);
        }
        if (root == null) {
            return;
        }
        ArrayList<Long> parentList = new ArrayList<Long>(10);
        this.findHasLoadParent(map, focusRowId, parentList, root.getId());
        ArrayList<Integer> expendRows = new ArrayList<Integer>(parentList.size());
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREE_ENTRYENTITY);
        for (int j = parentList.size() - 1; j > 0; --j) {
            Long parentId = (Long)parentList.get(j);
            int rowIndex = this.getEntryEntityRow(parentId);
            expendRows.add(rowIndex);
            this.expendOneEvevt(rowIndex, treeEntryGrid);
        }
        this.setTreeNodeColor();
        this.getView().updateView(TREE_ENTRYENTITY);
        treeEntryGrid.expandOne(expendRows.stream().mapToInt(Integer::intValue).toArray());
        treeEntryGrid.selectRows(this.getEntryEntityRow((Long)parentList.get(0)));
        this.getPageCache().put(CACHE_CURRENTFOCUS, focusRowId.toString());
    }
}

