/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.decompose.plugin.target;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.entity.memberF7.LeftTreeF7Parameter;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.MemberF7.ParameterF7Builder;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;

public class TargetSchemeAddPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener {
    public static final String MODEL = "model";
    public static final String BIZCTRL = "bizctrl";
    public static final String BIZMODEL = "bizmodel";
    public static final String DATATYPE = "datatype";
    public static final String VERSION = "version";
    public static final String AUDITTRAIL = "audittrail";
    public static final String CHANGE_TYPE = "changetype";
    public static final String CHANGE_TYPE_TEXT = "changetypetext";
    public static final String CURRENCY = "currency";
    public static final String BUDGETPERIOD = "budgetperiod";
    public static final String BUDGETPERIOD_TEXT = "budgetperiodtext";
    public static final String ACCOUNT = "account";
    public static final String ACCOUNT_TEXT = "accounttext";
    public static final String SAVE = "save";
    public static final String TOOLBARAP = "toolbarap";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, new String[]{BIZMODEL, DATATYPE, VERSION, AUDITTRAIL, CURRENCY});
        this.addClickListeners(new String[]{ACCOUNT_TEXT, BUDGETPERIOD_TEXT, CHANGE_TYPE_TEXT});
        this.addItemClickListeners(new String[]{TOOLBARAP});
    }

    private boolean checkInfo() {
        Long pkId = (Long)this.getModel().getValue("id");
        String number = (String)this.getModel().getValue("number");
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
        String localeValue = name.getLocaleValue();
        if (localeValue == null || StringUtils.isEmpty((String)localeValue.trim())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TargetSchemeAddPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        QFilter model = new QFilter(MODEL, "=", (Object)this.getCacheModelId(MODEL));
        QFilter numberFilter = new QFilter("number", "=", (Object)number);
        QFilter nameFilter = new QFilter("name", "=", (Object)localeValue);
        QFilter idFilter = new QFilter("id", "!=", (Object)pkId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bgm_targetscheme", (String)"id,number,name", (QFilter[])new QFilter[]{model, numberFilter, idFilter});
        if (!CollectionUtils.isEmpty((Collection)query)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"TargetSchemeAddPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bgm_targetscheme", (String)"id,number,name", (QFilter[])new QFilter[]{model, nameFilter, idFilter});
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"TargetSchemeAddPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        DynamicObject bizCtrl = (DynamicObject)this.getModel().getValue(BIZCTRL);
        QFilter bizFilter = new QFilter(BIZCTRL, "=", (Object)bizCtrl.getLong("id"));
        DynamicObject bizModel = (DynamicObject)this.getModel().getValue(BIZMODEL);
        QFilter bizModelFilter = new QFilter(BIZMODEL, "=", (Object)bizModel.getLong("id"));
        DynamicObject currency = (DynamicObject)this.getModel().getValue(CURRENCY);
        QFilter currencyFilter = new QFilter(CURRENCY, "=", (Object)currency.getLong("id"));
        DynamicObject audittrail = (DynamicObject)this.getModel().getValue(AUDITTRAIL);
        QFilter audittrailFilter = new QFilter(AUDITTRAIL, "=", (Object)audittrail.getLong("id"));
        DynamicObject version = (DynamicObject)this.getModel().getValue(VERSION);
        QFilter versionFilter = new QFilter(VERSION, "=", (Object)version.getLong("id"));
        DynamicObject dateType = (DynamicObject)this.getModel().getValue(DATATYPE);
        QFilter dateTypeFilter = new QFilter(DATATYPE, "=", (Object)dateType.getLong("id"));
        String changeType = (String)this.getModel().getValue(CHANGE_TYPE);
        String budgetperiod = (String)this.getModel().getValue(BUDGETPERIOD);
        String account = (String)this.getModel().getValue(ACCOUNT);
        QFilter[] qFilters = new QFilter[]{idFilter, model, bizFilter, bizModelFilter, currencyFilter, audittrailFilter, versionFilter, dateTypeFilter};
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bgm_targetscheme", (String)"id,number,name,changetype,budgetperiod,account", (QFilter[])qFilters);
        if (!CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                String changetype = dynamicObject.getString(CHANGE_TYPE);
                String budgetPeriod = dynamicObject.getString(BUDGETPERIOD);
                String accountStr = dynamicObject.getString(ACCOUNT);
                if (!StringUtils.equals((String)changeType, (String)changetype) || !StringUtils.equals((String)budgetPeriod, (String)budgetperiod) || !StringUtils.equals((String)accountStr, (String)account)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5185\u5bb9\u65b9\u6848\u5df2\u5b58\u5728\u3002", (String)"TargetSchemeAddPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey()) {
            case "budgetperiodtext": {
                this.switchBudgetperiod(key);
                break;
            }
            case "changetypetext": {
                this.switchChangeType(key);
                break;
            }
            case "accounttext": {
                this.switchAccount(key);
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{BIZCTRL});
        this.cacheModelInfo();
        this.getModel().setValue(BIZCTRL, (Object)this.getCacheModelId(BIZCTRL));
        this.getModel().setValue(MODEL, (Object)this.getCacheModelId(MODEL));
        Object pkId = ((BaseShowParameter)this.getView().getFormShowParameter()).getPkId();
        this.getPageCache().put("pkId", String.valueOf(pkId));
        this.presetCurrency();
        this.presetChangeType();
        this.presetAudittrail();
    }

    public void initialize() {
        super.initialize();
    }

    public void afterLoadData(EventObject e) {
        OperationStatus status;
        this.getView().setEnable(Boolean.valueOf(false), new String[]{BIZCTRL});
        super.afterLoadData(e);
        this.cacheModelInfo();
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
        DynamicObject bizModel = (DynamicObject)this.getModel().getValue(BIZCTRL);
        this.getPageCache().put(MODEL, String.valueOf(model.getLong("id")));
        this.getPageCache().put(BIZCTRL, String.valueOf(bizModel.getLong("id")));
        if (this.getCacheModelId(MODEL) != 0L) {
            Member member;
            String[] split;
            String account = (String)this.getModel().getValue(ACCOUNT);
            String budgerperiod = (String)this.getModel().getValue(BUDGETPERIOD);
            String changeType = (String)this.getModel().getValue(CHANGE_TYPE);
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getCacheModelId(MODEL));
            if (StringUtils.isNotEmpty((String)account)) {
                split = account.split(",");
                ArrayList<String> accountNames = new ArrayList<String>(10);
                for (String s : split) {
                    member = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, Long.valueOf(s));
                    accountNames.add(member.getName());
                }
                this.getModel().setValue(ACCOUNT_TEXT, (Object)String.join((CharSequence)",", accountNames));
            }
            if (StringUtils.isNotEmpty((String)budgerperiod)) {
                split = budgerperiod.split(",");
                ArrayList<String> budgerperiodNames = new ArrayList<String>(10);
                for (String s : split) {
                    member = modelCacheHelper.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, Long.valueOf(s));
                    budgerperiodNames.add(member.getName());
                }
                this.getModel().setValue(BUDGETPERIOD_TEXT, (Object)String.join((CharSequence)",", budgerperiodNames));
            }
            if (StringUtils.isNotEmpty((String)changeType)) {
                split = changeType.split(",");
                ArrayList<String> changeTypeNames = new ArrayList<String>(10);
                for (String s : split) {
                    member = modelCacheHelper.getMember(SysDimensionEnum.ChangeType.getNumber(), null, Long.valueOf(s));
                    changeTypeNames.add(member.getName());
                }
                this.getModel().setValue(CHANGE_TYPE_TEXT, (Object)String.join((CharSequence)",", changeTypeNames));
            }
        }
        if ((status = this.getView().getFormShowParameter().getStatus()).getValue() == OperationStatus.VIEW.getValue()) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.EDIT);
            this.setViewEdit();
        }
        this.getModel().setDataChanged(false);
    }

    private void setViewEdit() {
        IFormView view = this.getView();
        view.setEnable(Boolean.valueOf(false), new String[]{"number", BIZCTRL, BIZMODEL, DATATYPE, VERSION, AUDITTRAIL, CHANGE_TYPE_TEXT, CURRENCY, BUDGETPERIOD_TEXT, ACCOUNT_TEXT});
        view.setEnable(Boolean.valueOf(true), new String[]{"name"});
    }

    private void presetAudittrail() {
        QFilter qFilter = new QFilter(MODEL, "=", (Object)this.getCacheModelId(MODEL));
        QFilter number = new QFilter("number", "=", (Object)"EntityInput");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_audittrialmembertree", (String)"id,number", (QFilter[])new QFilter[]{qFilter.and(number)});
        this.getModel().setValue(AUDITTRAIL, (Object)dynamicObject.getLong("id"));
    }

    private void presetChangeType() {
        QFilter qFilter = new QFilter(MODEL, "=", (Object)this.getCacheModelId(MODEL));
        QFilter number = new QFilter("number", "=", (Object)"CurrentPeriod");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_changetypemembertree", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter.and(number)});
        this.getModel().setValue(CHANGE_TYPE, (Object)dynamicObject.getLong("id"));
        this.getModel().setValue(CHANGE_TYPE_TEXT, (Object)dynamicObject.getString("name"));
    }

    private void presetCurrency() {
        QFilter modelFilter = new QFilter(MODEL, "=", (Object)this.getCacheModelId(MODEL));
        QFilter number = new QFilter("number", "=", (Object)"CNY");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_currencymembertree", (String)"id,number", (QFilter[])new QFilter[]{modelFilter.and(number)});
        this.getModel().setValue(CURRENCY, (Object)dynamicObject.getLong("id"));
    }

    private void cacheModelInfo() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String bizCtrl = (String)customParams.get(BIZCTRL);
        String model = (String)customParams.get(MODEL);
        this.getPageCache().put(MODEL, model);
        this.getPageCache().put(BIZCTRL, bizCtrl);
    }

    private Long getCacheModelId(String key) {
        String s = this.getPageCache().get(key);
        return IDUtils.toLong((Object)s);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name;
        switch (name = beforeF7SelectEvent.getProperty().getName()) {
            case "datatype": {
                this.switchDataType(beforeF7SelectEvent);
                break;
            }
            case "bizmodel": {
                this.switchBizModel(beforeF7SelectEvent);
                break;
            }
            case "version": {
                this.switchVersion(beforeF7SelectEvent);
                break;
            }
            case "currency": {
                this.switchCurrency(beforeF7SelectEvent);
                break;
            }
            case "audittrail": {
                this.switchAudittaril(beforeF7SelectEvent);
                break;
            }
        }
    }

    private void switchChangeType(String key) {
        long bizModelId = this.getCacheModelId(BIZCTRL);
        Long modelId = this.getModelId();
        MemberF7Parameter f7Param = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)this.getCurrentDimNumber(key)), (String)ListSelectedRow.class.getName());
        f7Param.setBusModelId(Long.valueOf(bizModelId));
        f7Param.setOnlySelLeaf(true);
        String value = (String)this.getModel().getValue(CHANGE_TYPE);
        if (!StringUtils.isEmpty((String)value)) {
            String[] split;
            LinkedHashSet objects = Sets.newLinkedHashSet();
            for (String s : split = value.split(",")) {
                objects.add(Long.valueOf(s));
            }
            if (!CollectionUtils.isEmpty((Collection)objects)) {
                f7Param.setSelectIds((Set)objects);
            }
        }
        NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, CHANGE_TYPE_TEXT));
    }

    private void switchAudittaril(BeforeF7SelectEvent beforeF7SelectEvent) {
        long bizModelId = this.getCacheModelId(BIZCTRL);
        Long modelId = this.getModelId();
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)SysDimensionEnum.AuditTrail.getNumber()), (String)ListSelectedRow.class.getName());
        f7Param.setBusModelId(Long.valueOf(bizModelId));
        NewF7Utils.openF7((BeforeF7SelectEvent)beforeF7SelectEvent, (MemberF7Parameter)f7Param);
    }

    private void switchAccount(String key) {
        long bizModelId = this.getCacheModelId(BIZCTRL);
        DynamicObject bizmodel = (DynamicObject)this.getModel().getValue(BIZMODEL);
        if (bizmodel == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u96c6\uff0c\u7136\u540e\u518d\u9009\u62e9\u79d1\u76ee\u3002", (String)"TargetSchemeAddPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long modelId = this.getModelId();
        MemberF7Parameter f7Param = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)this.getCurrentDimNumber(key)), (String)ListSelectedRow.class.getName());
        f7Param.setBusModelId(Long.valueOf(bizModelId));
        f7Param.setDatasetId(Long.valueOf(bizmodel.getLong("id")));
        String value = (String)this.getModel().getValue(ACCOUNT);
        if (!StringUtils.isEmpty((String)value)) {
            String[] split;
            LinkedHashSet objects = Sets.newLinkedHashSet();
            for (String s : split = value.split(",")) {
                objects.add(Long.valueOf(s));
            }
            if (!CollectionUtils.isEmpty((Collection)objects)) {
                f7Param.setSelectIds((Set)objects);
            }
        }
        NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, ACCOUNT_TEXT));
    }

    private void switchBudgetperiod(String key) {
        long bizModelId = this.getCacheModelId(BIZCTRL);
        Long modelId = this.getModelId();
        MemberF7Parameter f7Param = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)this.getCurrentDimNumber(key)), (String)ListSelectedRow.class.getName());
        f7Param.setBusModelId(Long.valueOf(bizModelId));
        f7Param.setCanSelectRoot(false);
        String value = (String)this.getModel().getValue(BUDGETPERIOD);
        if (!StringUtils.isEmpty((String)value)) {
            String[] split;
            LinkedHashSet objects = Sets.newLinkedHashSet();
            for (String s : split = value.split(",")) {
                objects.add(Long.valueOf(s));
            }
            if (!CollectionUtils.isEmpty((Collection)objects)) {
                f7Param.setSelectIds((Set)objects);
            }
        }
        NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, BUDGETPERIOD_TEXT));
    }

    private void switchCurrency(BeforeF7SelectEvent beforeF7SelectEvent) {
        long bizModelId = this.getCacheModelId(BIZCTRL);
        Long modelId = this.getModelId();
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (SysDimensionEnum)SysDimensionEnum.Currency), (String)ListSelectedRow.class.getName());
        f7Param.setBusModelId(Long.valueOf(bizModelId));
        f7Param.setOnlySelLeaf(true);
        NewF7Utils.openF7((BeforeF7SelectEvent)beforeF7SelectEvent, (MemberF7Parameter)f7Param);
    }

    private void switchVersion(BeforeF7SelectEvent beforeF7SelectEvent) {
        long bizModelId = this.getCacheModelId(BIZCTRL);
        Long modelId = this.getModelId();
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (SysDimensionEnum)SysDimensionEnum.Version), (String)ListSelectedRow.class.getName());
        f7Param.setBusModelId(Long.valueOf(bizModelId));
        f7Param.setOnlySelLeaf(true);
        f7Param.addCustomFilter(new QFilter("number", "!=", (Object)"ACTUAL"));
        NewF7Utils.openF7((BeforeF7SelectEvent)beforeF7SelectEvent, (MemberF7Parameter)f7Param);
    }

    private void switchBizModel(BeforeF7SelectEvent beforeF7SelectEvent) {
        long bizModelId = this.getCacheModelId(BIZCTRL);
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("businessmodel", "=", (Object)bizModelId));
    }

    public String getCurrentDimNumber(String key) {
        if (ACCOUNT_TEXT.equals(key)) {
            return "Account";
        }
        if (DATATYPE.equals(key)) {
            return "DataType";
        }
        if (VERSION.equals(key)) {
            return "Version";
        }
        if (CURRENCY.equals(key)) {
            return "Currency";
        }
        if (BUDGETPERIOD_TEXT.equals(key)) {
            return "BudgetPeriod";
        }
        if (AUDITTRAIL.equals(key)) {
            return "AuditTrail";
        }
        if (CHANGE_TYPE_TEXT.equals(key)) {
            return "ChangeType";
        }
        return null;
    }

    private void switchDataType(BeforeF7SelectEvent beforeF7SelectEvent) {
        long bizModelId = this.getCacheModelId(BIZCTRL);
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        QFilter longNumber = new QFilter("longnumber", "ftlike", (Object)"DataType!Budget");
        QFilter budget = new QFilter("longnumber", "!=", (Object)"DataType!Budget");
        QFilter qFilter = new QFilter("isleaf", "=", (Object)"1");
        showParameter.getListFilterParameter().getQFilters().add(qFilter.and(longNumber).and(budget));
        ParameterF7Builder builder = new ParameterF7Builder("left");
        this.switchLeftTreeF7(beforeF7SelectEvent, bizModelId, (LeftTreeF7Parameter)builder.build());
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            String tips = NumberCheckUtils.checkNumberRule((String)this.getModel().getValue("number").toString());
            if (StringUtils.isNotEmpty((String)tips)) {
                throw new KDBizException(tips);
            }
            boolean isCancel = this.checkInfo();
            args.setCancel(isCancel);
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        List successPkIds;
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        String operateKey = args.getOperateKey();
        if (StringUtils.equals((String)operateKey, (String)SAVE) && !CollectionUtils.isEmpty((Collection)(successPkIds = operationResult.getSuccessPkIds()))) {
            this.getView().returnDataToParent(successPkIds.get(0));
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TargetSchemeAddPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getView().close();
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null) {
            switch (actionId) {
                case "changetypetext": {
                    this.handleChangeType(returnData);
                    break;
                }
                case "accounttext": {
                    this.handleAccount(returnData);
                    break;
                }
                case "budgetperiodtext": {
                    this.handleBudgetperiod(returnData);
                    break;
                }
            }
        }
    }

    private void handleBudgetperiod(Object returnData) {
        ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
        if (rows != null) {
            Long[] ids = new Long[rows.size()];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = (Long)rows.get(i).getPrimaryKeyValue();
            }
            ArrayList<Long> periodIds = new ArrayList<Long>(10);
            ArrayList<String> periodNames = new ArrayList<String>(10);
            QFilter qFilter = new QFilter("id", "in", (Object)ids);
            DynamicObjectCollection query = QueryServiceHelper.query((String)"epm_bperiodmembertree", (String)"id,parent,name,number,isleaf,level", (QFilter[])new QFilter[]{qFilter}, (String)"level,number asc");
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getCacheModelId(MODEL));
            for (DynamicObject dynamicObject : query) {
                Long id = dynamicObject.getLong("id");
                String name = dynamicObject.getString("name");
                Member member = modelCacheHelper.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, id);
                List parents = modelCacheHelper.getParents(null, member, false);
                if (!CollectionUtils.isEmpty(periodIds)) {
                    List<Object> list;
                    List<Long> collect = parents.stream().map(BaseCache::getId).collect(Collectors.toList());
                    List<String> names = parents.stream().map(Member::getName).collect(Collectors.toList());
                    if (!Collections.disjoint(periodIds, collect)) {
                        list = this.retainAllLong(periodIds, collect);
                        periodIds.removeAll(list);
                    }
                    if (!Collections.disjoint(periodNames, names)) {
                        list = this.retainAllString(periodNames, names);
                        periodNames.removeAll(list);
                    }
                }
                periodIds.add(id);
                periodNames.add(name);
            }
            this.getModel().setValue(BUDGETPERIOD_TEXT, (Object)String.join((CharSequence)",", periodNames));
            ArrayList<String> periodList = new ArrayList<String>(10);
            for (Long periodId : periodIds) {
                periodList.add(String.valueOf(periodId));
            }
            this.getModel().setValue(BUDGETPERIOD, (Object)String.join((CharSequence)",", periodList));
        }
    }

    private void handleAccount(Object returnData) {
        ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
        if (rows != null) {
            Long[] ids = new Long[rows.size()];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = (Long)rows.get(i).getPrimaryKeyValue();
            }
            ArrayList<Long> accountIds = new ArrayList<Long>(10);
            ArrayList<String> accountNames = new ArrayList<String>(10);
            QFilter qFilter = new QFilter("id", "in", (Object)ids);
            DynamicObjectCollection accounts = QueryServiceHelper.query((String)"epm_accountmembertree", (String)"id,parent,name,number,isleaf,level", (QFilter[])new QFilter[]{qFilter}, (String)"level,number asc");
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getCacheModelId(MODEL));
            for (DynamicObject account : accounts) {
                Long id = account.getLong("id");
                String name = account.getString("name");
                Member member = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, id);
                List parents = modelCacheHelper.getParents(null, member, false);
                if (!CollectionUtils.isEmpty(accountIds)) {
                    List<Object> list;
                    List<Long> collect = parents.stream().map(BaseCache::getId).collect(Collectors.toList());
                    List<String> names = parents.stream().map(Member::getName).collect(Collectors.toList());
                    if (!Collections.disjoint(accountIds, collect)) {
                        list = this.retainAllLong(accountIds, collect);
                        accountIds.removeAll(list);
                    }
                    if (!Collections.disjoint(accountNames, names)) {
                        list = this.retainAllString(accountNames, names);
                        accountNames.removeAll(list);
                    }
                }
                accountIds.add(id);
                accountNames.add(name);
            }
            this.getModel().setValue(ACCOUNT_TEXT, (Object)String.join((CharSequence)",", accountNames));
            ArrayList<String> accountList = new ArrayList<String>(10);
            for (Long accountId : accountIds) {
                accountList.add(String.valueOf(accountId));
            }
            this.getModel().setValue(ACCOUNT, (Object)String.join((CharSequence)",", accountList));
        }
    }

    private List<Long> retainAllLong(List<Long> collection, List<Long> retain) {
        ArrayList<Long> list = new ArrayList<Long>(Math.min(collection.size(), retain.size()));
        for (Long obj : collection) {
            if (!retain.contains(obj)) continue;
            list.add(obj);
        }
        return list;
    }

    private List<String> retainAllString(List<String> collection, List<String> retain) {
        ArrayList<String> list = new ArrayList<String>(Math.min(collection.size(), retain.size()));
        for (String obj : collection) {
            if (!retain.contains(obj)) continue;
            list.add(obj);
        }
        return list;
    }

    private void handleChangeType(Object returnData) {
        ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
        if (rows != null) {
            Long[] ids = new Long[rows.size()];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = (Long)rows.get(i).getPrimaryKeyValue();
            }
            QFilter qFilter = new QFilter("id", "in", (Object)ids);
            DynamicObjectCollection query = QueryServiceHelper.query((String)"epm_changetypemembertree", (String)"id,name,number,isleaf", (QFilter[])new QFilter[]{qFilter}, (String)"level,number asc");
            List isLeaf = query.stream().filter(e -> e.getBoolean("isleaf")).collect(Collectors.toList());
            if (query.size() != isLeaf.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578b\u4ec5\u5141\u8bb8\u9009\u62e9\u660e\u7ec6\u8282\u70b9\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TargetSchemeAddPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                ArrayList<Long> changeTypeIds = new ArrayList<Long>(10);
                ArrayList<String> changeTypeNames = new ArrayList<String>(10);
                for (DynamicObject dynamicObject : query) {
                    changeTypeIds.add(dynamicObject.getLong("id"));
                    changeTypeNames.add(dynamicObject.getString("name"));
                }
                this.getModel().setValue(CHANGE_TYPE_TEXT, (Object)String.join((CharSequence)",", changeTypeNames));
                ArrayList<String> changeTypeList = new ArrayList<String>(10);
                for (Long changeType : changeTypeIds) {
                    changeTypeList.add(String.valueOf(changeType));
                }
                this.getModel().setValue(CHANGE_TYPE, (Object)String.join((CharSequence)",", changeTypeList));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (BIZMODEL.equals(name)) {
            this.getModel().setValue(ACCOUNT, null);
            this.getModel().setValue(ACCOUNT_TEXT, null);
        }
    }

    @Override
    public Long getModelId() {
        String s = this.getPageCache().get(MODEL);
        if (StringUtils.isNotEmpty((String)s)) {
            return IDUtils.toLong((Object)s);
        }
        return 0L;
    }
}

