/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.decompose.plugin.target;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.target.TargetSchemeDimMemberMapPojo;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.Builder;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UploadUtil;
import kd.epm.eb.common.utils.excel.BgExcelReader;
import kd.epm.eb.common.utils.excel.BgExcelWriter;
import kd.epm.eb.common.utils.fileImport.entity.Header;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.decompose.plugin.target.TargetSchemeDimMapperPlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class TargetSchemeDimMapperImportPlugin
extends AbstractFormPlugin
implements UploadListener {
    protected static Log log = LogFactory.getLog(TargetSchemeDimMapperImportPlugin.class);
    private static final String OPER = "*";
    private static final String BTN_OK = "btnok";
    private static final String BTN_DOWNLOAD = "btndownload";

    private static String getNameCn() {
        return ResManager.loadKDString((String)"\u540d\u79f0", (String)"TargetSchemeDimMapperImportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String getNumberCn() {
        return ResManager.loadKDString((String)"\u5185\u7801", (String)"TargetSchemeDimMapperImportPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, BTN_DOWNLOAD});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"newandcover"});
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>(16);
        dataMap.put("maxatmcount", 1);
        this.getView().updateControlMetadata("attachmentpanelap", dataMap);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.importData();
                break;
            }
            case "btndownload": {
                this.downloadTemplate();
                break;
            }
        }
    }

    private void returnExceptionMessage(String message) {
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            throw new KDBizException(message);
        }
    }

    private void importData() {
        String fileUrl = this.getPageCache().get("file_url");
        if (StringUtils.isBlank((CharSequence)fileUrl)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u9644\u4ef6\u3002", (String)"TargetSchemeDimMapperImportPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        List inputStreams = UploadUtil.getFileInputStreams((String)fileUrl);
        List<XSSFWorkbook> uploadBooks = this.getXssfWorkbooks(inputStreams);
        String message = this.checkFileFormat(uploadBooks);
        this.returnExceptionMessage(message);
        ArrayList<List<String>> dataList = new ArrayList<List<String>>(10);
        String selectDimNumber = (String)this.getView().getFormShowParameter().getCustomParam("selectDimNumber");
        int endColIndex = SysDimensionEnum.Account.getNumber().equals(selectDimNumber) ? 7 : 3;
        for (XSSFWorkbook workbook : uploadBooks) {
            BgExcelReader excelReader = BgExcelReader.getInstance().readByWorkbook((Workbook)workbook);
            List datas = excelReader.read(3, 0, endColIndex);
            dataList.addAll(datas);
        }
        if (CollectionUtils.isEmpty(dataList)) {
            this.returnExceptionMessage(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"TargetSchemeDimMapperImportPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ArrayList<List<String>> errList = new ArrayList<List<String>>(4);
        List<List<String>> successList = this.validExcel(dataList, errList);
        List<TargetSchemeDimMemberMapPojo> mapObjList = this.toObj(successList);
        this.getView().returnDataToParent(mapObjList);
        if (errList.size() > 0) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u5b58\u5728\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5\u3002", (String)"TargetSchemeDimMapperImportPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f", (String)"CentralizedFileServiceImpl_70", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        this.getView().close();
    }

    protected List<XSSFWorkbook> getXssfWorkbooks(List<InputStream> inputStreams) {
        ArrayList<XSSFWorkbook> xssfWorkbooks = new ArrayList<XSSFWorkbook>();
        try {
            for (InputStream inputStream : inputStreams) {
                XSSFWorkbook xssfWorkbook = new XSSFWorkbook(inputStream);
                xssfWorkbooks.add(xssfWorkbook);
            }
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"TargetSchemeDimMapperImportPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return xssfWorkbooks;
    }

    private String checkFileFormat(List<XSSFWorkbook> uploadBooks) {
        try {
            for (XSSFWorkbook uploadBook : uploadBooks) {
                XSSFSheet uploadSheet = uploadBook.getSheetAt(0);
                XSSFRow row3 = uploadSheet.getRow(2);
                if (row3 == null) {
                    return ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u6ca1\u6709\u83b7\u53d6\u5230\u8868\u5934\u4fe1\u606f\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"TargetSchemeDimMapperImportPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
                Map<String, Header> sheetHeaderMap = this.getHeaderData();
                for (Map.Entry<String, Header> entry : sheetHeaderMap.entrySet()) {
                    int colNum = Integer.parseInt(entry.getKey());
                    if (row3.getCell(colNum).getStringCellValue().trim().equals(entry.getValue().getHeader())) continue;
                    return ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"TargetSchemeDimMapperImportPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
            }
        }
        catch (Exception e) {
            return ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"TargetSchemeDimMapperImportPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    protected Map<String, Header> getHeaderData() {
        LinkedHashMap<String, Header> headerMap = new LinkedHashMap<String, Header>(16);
        String selectDimName = (String)this.getView().getFormShowParameter().getCustomParam("selectDimName");
        String selectDimNumber = (String)this.getView().getFormShowParameter().getCustomParam("selectDimNumber");
        if (SysDimensionEnum.Account.getNumber().equals(selectDimNumber)) {
            Header headerAccountNumber = new Header();
            headerAccountNumber.setHeader(ResManager.loadKDString((String)"\u79d1\u76ee\u5185\u7801*", (String)"TargetSchemeDimMapperImportPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            Header headerAccountName = new Header();
            headerAccountName.setHeader(ResManager.loadKDString((String)"\u79d1\u76ee\u540d\u79f0", (String)"TargetSchemeDimMapperImportPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            Header headerSubDimNumber = new Header();
            headerSubDimNumber.setHeader(ResManager.loadKDString((String)"\u8f85\u52a9\u627f\u63a5\u7ef4\u5ea6\u7f16\u7801", (String)"TargetSchemeDimMapperImportPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            Header headerSubDimName = new Header();
            headerSubDimName.setHeader(ResManager.loadKDString((String)"\u8f85\u52a9\u627f\u63a5\u7ef4\u5ea6\u540d\u79f0", (String)"TargetSchemeDimMapperImportPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            Header headerSubMemberNumber = new Header();
            headerSubMemberNumber.setHeader(ResManager.loadKDString((String)"\u8f85\u52a9\u627f\u63a5\u7ef4\u5ea6\u6210\u5458\u5185\u7801", (String)"TargetSchemeDimMapperImportPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            Header headerSubMemberName = new Header();
            headerSubMemberName.setHeader(ResManager.loadKDString((String)"\u8f85\u52a9\u627f\u63a5\u7ef4\u5ea6\u6210\u5458\u540d\u79f0", (String)"TargetSchemeDimMapperImportPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            headerMap.put("0", headerAccountNumber);
            headerMap.put("1", headerAccountName);
            headerMap.put("2", headerAccountNumber);
            headerMap.put("3", headerAccountName);
            headerMap.put("4", headerSubDimNumber);
            headerMap.put("5", headerSubDimName);
            headerMap.put("6", headerSubMemberNumber);
            headerMap.put("7", headerSubMemberName);
        } else {
            Header headerNumber = new Header();
            headerNumber.setHeader(selectDimName + TargetSchemeDimMapperImportPlugin.getNumberCn() + "#" + selectDimNumber + "." + "number" + OPER);
            Header headerName = new Header();
            headerName.setHeader(selectDimName + TargetSchemeDimMapperImportPlugin.getNameCn() + "#" + selectDimNumber + "." + "name");
            headerMap.put("0", headerNumber);
            headerMap.put("1", headerName);
            headerMap.put("2", headerNumber);
            headerMap.put("3", headerName);
        }
        return headerMap;
    }

    private List<List<String>> validExcel(List<List<String>> dataList, List<List<String>> errList) {
        Long srcModelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
        Long scrBussModel = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("scrBussModel"));
        Long tarBussModel = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("tarBussModel"));
        String selectDimNumber = (String)this.getView().getFormShowParameter().getCustomParam("selectDimNumber");
        String selectDimName = (String)this.getView().getFormShowParameter().getCustomParam("selectDimName");
        IModelCacheHelper srcModelCache = ModelCacheContext.getOrCreate((Long)srcModelId);
        Long tarViewId = srcModelCache.getViewByBusModelAndDimNumber(tarBussModel, selectDimNumber);
        Set<Object> srcAllMembers = new HashSet();
        Set<Object> tarAllMembers = new HashSet();
        if (SysDimensionEnum.Account.getNumber().equals(selectDimNumber)) {
            List srcDatasetIds = BusinessModelServiceHelper.getInstance().queryDataSetIds(scrBussModel);
            srcAllMembers = DatasetServiceHelper.getInstance().listAccountByDatasetId(srcDatasetIds).stream().map(BaseCache::getNumber).collect(Collectors.toSet());
            List tarDatasetIds = BusinessModelServiceHelper.getInstance().queryDataSetIds(tarBussModel);
            tarAllMembers = DatasetServiceHelper.getInstance().listAccountByDatasetId(tarDatasetIds).stream().map(BaseCache::getNumber).collect(Collectors.toSet());
        } else {
            List tarviews;
            List srcviews = srcModelCache.getViewGroupViewsByBusModelAndDimNumber(scrBussModel, selectDimNumber);
            if (srcviews != null) {
                for (Object srcview : srcviews) {
                    Set li1 = srcModelCache.getMembers((Long)srcview, selectDimNumber).stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                    if (li1 == null || li1.isEmpty()) continue;
                    srcAllMembers.addAll(li1);
                }
            } else {
                srcAllMembers = srcModelCache.getMembers(null, selectDimNumber).stream().map(BaseCache::getNumber).collect(Collectors.toSet());
            }
            if ((tarviews = srcModelCache.getViewGroupViewsByBusModelAndDimNumber(tarBussModel, selectDimNumber)) != null) {
                for (Long tarview : tarviews) {
                    Set li1 = srcModelCache.getMembers(tarview, selectDimNumber).stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                    if (li1 == null || li1.isEmpty()) continue;
                    tarAllMembers.addAll(li1);
                }
            } else {
                tarAllMembers = srcModelCache.getMembers(tarViewId, selectDimNumber).stream().map(BaseCache::getNumber).collect(Collectors.toSet());
            }
        }
        boolean hasErr = Boolean.FALSE;
        ArrayList<List<String>> successList = new ArrayList<List<String>>(16);
        for (int i = 0; i < dataList.size(); ++i) {
            List<String> row = dataList.get(i);
            String srcMember = row.get(0);
            String tarMember = row.get(2);
            ArrayList<String> errMsgList = new ArrayList<String>(16);
            if (StringUtils.isBlank((CharSequence)srcMember) && StringUtils.isBlank((CharSequence)tarMember)) {
                errMsgList.add(ResManager.loadKDString((String)"\u76ee\u6807\u6d4b\u7b97\u7ef4\u5ea6\u6210\u5458\u5185\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u76ee\u6807\u627f\u63a5\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"TargetSchemeDimMapperImportPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (StringUtils.isBlank((CharSequence)srcMember)) {
                errMsgList.add(ResManager.loadKDString((String)"\u76ee\u6807\u6d4b\u7b97\u7ef4\u5ea6\u6210\u5458\u5185\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"TargetSchemeDimMapperImportPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (StringUtils.isBlank((CharSequence)tarMember)) {
                errMsgList.add(ResManager.loadKDString((String)"\u76ee\u6807\u627f\u63a5\u7ef4\u5ea6\u6210\u5458\u5185\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"TargetSchemeDimMapperImportPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                if (!srcAllMembers.contains(srcMember)) {
                    errMsgList.add(ResManager.loadResFormat((String)"\u76ee\u6807\u6d4b\u7b97\u7ef4\u5ea6\u6210\u5458\uff1a%1\u4e0d\u5b58\u5728\u3002", (String)"TargetSchemeDimMapperImportPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[]{srcMember}));
                }
                if (!tarAllMembers.contains(tarMember)) {
                    errMsgList.add(ResManager.loadResFormat((String)"\u76ee\u6807\u627f\u63a5\u7ef4\u5ea6\u6210\u5458\uff1a%1\u4e0d\u5b58\u5728\u3002", (String)"TargetSchemeDimMapperImportPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[]{tarMember}));
                }
                if (SysDimensionEnum.Account.getNumber().equals(selectDimNumber)) {
                    this.checkSubDimExist(tarBussModel, selectDimNumber, srcModelCache, row, tarMember, errMsgList);
                }
                for (int j = 0; j < dataList.size(); ++j) {
                    List<String> strings;
                    boolean disjoint;
                    if (i == j || (disjoint = Collections.disjoint(row, strings = dataList.get(j)))) continue;
                    if (SysDimensionEnum.Account.getNumber().equals(selectDimNumber)) {
                        if (!String.join((CharSequence)"", row.get(2), row.get(4), row.get(6)).equals(String.join((CharSequence)"", strings.get(2), strings.get(4), strings.get(6)))) continue;
                        errMsgList.add(ResManager.loadKDString((String)"\u5b58\u5728\u76ee\u6807\u627f\u63a5\u7ef4\u5ea6\u6210\u5458\u5185\u7801\u91cd\u590d\u7684\u884c\u3002", (String)"TargetSchemeDimMapperImportPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (!row.get(2).equals(strings.get(2))) continue;
                    errMsgList.add(ResManager.loadKDString((String)"\u5b58\u5728\u76ee\u6807\u627f\u63a5\u7ef4\u5ea6\u6210\u5458\u5185\u7801\u91cd\u590d\u7684\u884c\u3002", (String)"TargetSchemeDimMapperImportPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
            if (!errMsgList.isEmpty()) {
                hasErr = Boolean.TRUE;
                row.add(String.join((CharSequence)",", errMsgList));
                errList.add(row);
                continue;
            }
            successList.add(row);
        }
        if (hasErr) {
            this.downloadImportErrorExcel(errList, selectDimNumber, selectDimName);
        }
        return successList;
    }

    private void checkSubDimExist(Long tarBussModel, String selectDimNumber, IModelCacheHelper srcModelCache, List<String> row, String tarMember, List<String> errMsgList) {
        String subDimNumber = row.get(4);
        String subMemberNumber = row.get(6);
        if (StringUtils.isNotBlank((CharSequence)subMemberNumber) && StringUtils.isBlank((CharSequence)subDimNumber)) {
            errMsgList.add(ResManager.loadResFormat((String)"\u586b\u5199\u8f85\u52a9\u627f\u63a5\u7ef4\u5ea6\u6210\u5458\u7684\u540c\u65f6\uff0c\u8bf7\u586b\u5199\u8f85\u52a9\u627f\u63a5\u7ef4\u5ea6\u3002", (String)"TargetSchemeDimMapperImportPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[]{subMemberNumber}));
        }
        if (StringUtils.isNotBlank((CharSequence)subDimNumber)) {
            Member member = srcModelCache.getMember(selectDimNumber, null, tarMember);
            if (member == null) {
                return;
            }
            Long tarDatasetId = member.getDatasetId();
            List dimensionsByDataSet = srcModelCache.getDimensionList(tarDatasetId).stream().map(BaseCache::getNumber).collect(Collectors.toList());
            if (!dimensionsByDataSet.contains(subDimNumber)) {
                errMsgList.add(ResManager.loadResFormat((String)"\u8f85\u52a9\u627f\u63a5\u7ef4\u5ea6\uff1a%1\u4e0d\u5b58\u5728\u3002", (String)"TargetSchemeDimMapperImportPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[]{subDimNumber}));
            }
            Long subViewId = srcModelCache.getViewByBusModelAndDimNumber(tarBussModel, subDimNumber);
            Set subAllMembers = srcModelCache.getMembers(subViewId, subDimNumber).stream().map(BaseCache::getNumber).collect(Collectors.toSet());
            if (StringUtils.isNotBlank((CharSequence)subMemberNumber) && !subAllMembers.contains(subMemberNumber)) {
                errMsgList.add(ResManager.loadResFormat((String)"\u8f85\u52a9\u627f\u63a5\u7ef4\u5ea6\u6210\u5458\uff1a%1\u4e0d\u5b58\u5728\u3002", (String)"TargetSchemeDimMapperImportPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[]{subMemberNumber}));
            }
        }
    }

    private void downloadImportErrorExcel(List<List<String>> errList, String selectDimNumber, String selectDimName) {
        BgExcelWriter excelWriter;
        String tempPath = "";
        String fileName = ResManager.loadKDString((String)"\u7ef4\u5ea6\u627f\u63a5\u6210\u5458\u5bfc\u5165\u51fa\u9519\u8be6\u60c5.xlsx", (String)"TargetSchemeDimMapperImportPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        if (SysDimensionEnum.Account.getNumber().equals(selectDimNumber)) {
            tempPath = "target/targetDimMappingWithAccount.xlsx";
            excelWriter = BgExcelWriter.getInstance().readTemplateByClasspath(tempPath);
            excelWriter.setStarPosition(3, 0);
        } else {
            excelWriter = this.getBgExcelWriterWithOutAccount(selectDimNumber, selectDimName);
        }
        for (List<String> row : errList) {
            excelWriter.createRow(row);
        }
        String url = excelWriter.getDownloadUrl(fileName);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
    }

    private BgExcelWriter getBgExcelWriterWithOutAccount(String selectDimNumber, String selectDimName) {
        String tempPath = "target/targetDimMappingWithOutAccount.xlsx";
        BgExcelWriter excelWriter = BgExcelWriter.getInstance().readTemplateByClasspath(tempPath);
        excelWriter.setStarPosition(2, 0);
        StringBuilder dimNumberSb = new StringBuilder();
        dimNumberSb.append(selectDimName).append(TargetSchemeDimMapperImportPlugin.getNumberCn()).append("#").append(selectDimNumber).append(".").append("number").append(OPER);
        StringBuilder dimNameSb = new StringBuilder();
        dimNameSb.append(selectDimName).append(TargetSchemeDimMapperImportPlugin.getNameCn()).append("#").append(selectDimNumber).append(".").append("name");
        excelWriter.createRow(new Object[]{dimNumberSb.toString(), dimNameSb.toString(), dimNumberSb.toString(), dimNameSb.toString()});
        return excelWriter;
    }

    private List<TargetSchemeDimMemberMapPojo> toObj(List<List<String>> dataList) {
        Long srcModelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
        Long scrBussModel = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("scrBussModel"));
        Long tarBussModel = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("tarBussModel"));
        String selectDimNumber = (String)this.getView().getFormShowParameter().getCustomParam("selectDimNumber");
        IModelCacheHelper srcModelCache = ModelCacheContext.getOrCreate((Long)srcModelId);
        Long srcViewId = srcModelCache.getViewByBusModelAndDimNumber(scrBussModel, selectDimNumber);
        Long tarViewId = srcModelCache.getViewByBusModelAndDimNumber(tarBussModel, selectDimNumber);
        Map<String, Member> srcMemberMap = srcModelCache.getMembers(srcViewId, selectDimNumber).stream().collect(Collectors.toMap(BaseCache::getNumber, e -> e));
        Map<String, Member> tarMemberMap = srcModelCache.getMembers(tarViewId, selectDimNumber).stream().collect(Collectors.toMap(BaseCache::getNumber, e -> e));
        ArrayList<TargetSchemeDimMemberMapPojo> objList = new ArrayList<TargetSchemeDimMemberMapPojo>(dataList.size());
        for (List<String> row : dataList) {
            String subDimNumber;
            String srcMemberNumber = row.get(0);
            String tarMemberNumber = row.get(2);
            TargetSchemeDimMemberMapPojo mapObj = (TargetSchemeDimMemberMapPojo)Builder.of(TargetSchemeDimMemberMapPojo::new).with(TargetSchemeDimMemberMapPojo::setScrMember, (Object)srcMemberNumber).with(TargetSchemeDimMemberMapPojo::setScrMemberName, (Object)(srcMemberMap.get(srcMemberNumber) != null ? srcMemberMap.get(srcMemberNumber).getName() : srcModelCache.getMemberByAnyView(scrBussModel, selectDimNumber, srcMemberNumber).getName())).with(TargetSchemeDimMemberMapPojo::setTarMember, (Object)tarMemberNumber).with(TargetSchemeDimMemberMapPojo::setTarMemberName, (Object)(tarMemberMap.get(tarMemberNumber) != null ? tarMemberMap.get(tarMemberNumber).getName() : srcModelCache.getMemberByAnyView(tarBussModel, selectDimNumber, tarMemberNumber).getName())).build();
            if (SysDimensionEnum.Account.getNumber().equals(selectDimNumber) && StringUtils.isNotBlank((CharSequence)(subDimNumber = row.get(4)))) {
                Long subViewId = srcModelCache.getViewByBusModelAndDimNumber(tarBussModel, subDimNumber);
                Dimension subDim = srcModelCache.getDimension(subDimNumber);
                mapObj.setSubDimensionId(subDim.getId());
                mapObj.setSubDimension(subDim.getNumber());
                String subMemberNumber = row.get(6);
                Map<String, Member> subMemberMap = srcModelCache.getMembers(subViewId, subDimNumber).stream().collect(Collectors.toMap(BaseCache::getNumber, e -> e));
                if (StringUtils.isNotBlank((CharSequence)subMemberNumber)) {
                    mapObj.setSubMember(subMemberNumber);
                    mapObj.setSubMemberName(subMemberMap.get(subMemberNumber).getName());
                }
            }
            objList.add(mapObj);
        }
        return objList;
    }

    private void downloadTemplate() {
        String selectDimName = (String)this.getView().getFormShowParameter().getCustomParam("selectDimName");
        String selectDimNumber = (String)this.getView().getFormShowParameter().getCustomParam("selectDimNumber");
        if (SysDimensionEnum.Account.getNumber().equals(selectDimNumber)) {
            String fileName = ResManager.loadResFormat((String)"\u7ef4\u5ea6\u627f\u63a5\u6210\u5458\u6620\u5c04_%1", (String)"TargetSchemeDimMapperImportPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[]{DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
            InputStream inputStream = null;
            try {
                BgExcelWriter excelWriter = TargetSchemeDimMapperPlugin.createWorkBookWriter(true);
                String url = excelWriter.getDownloadUrl(fileName + ".xlsx");
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TargetSchemeDimMapperImportPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        log.error(e.getMessage());
                    }
                }
            }
        }
        BgExcelWriter excelWriter = TargetSchemeDimMapperPlugin.createWorkBookWriter(false);
        excelWriter.setStarPosition(2, 0);
        StringBuilder dimNumberSb = new StringBuilder();
        dimNumberSb.append(selectDimName).append(TargetSchemeDimMapperImportPlugin.getNumberCn()).append("#").append(selectDimNumber).append(".").append("number").append(OPER);
        StringBuilder dimNameSb = new StringBuilder();
        dimNameSb.append(selectDimName).append(TargetSchemeDimMapperImportPlugin.getNameCn()).append("#").append(selectDimNumber).append(".").append("name");
        excelWriter.createRow(new Object[]{dimNumberSb.toString(), dimNameSb.toString(), dimNumberSb.toString(), dimNameSb.toString()});
        String fileName = ResManager.loadResFormat((String)"\u7ef4\u5ea6\u627f\u63a5\u6210\u5458\u6620\u5c04_%1", (String)"TargetSchemeDimMapperImportPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[]{DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        String url = excelWriter.getDownloadUrl(fileName + ".xlsx");
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        String fileUrl = this.getPageCache().get("file_url");
        List urls = null;
        urls = fileUrl == null ? new ArrayList(10) : (List)SerializationUtils.fromJsonString((String)fileUrl, List.class);
        for (Object url : evt.getUrls()) {
            urls.add((String)((Map)url).get("url"));
        }
        this.getPageCache().put("file_url", SerializationUtils.toJsonString(urls));
    }

    public void afterRemove(UploadEvent evt) {
        Object[] objects;
        String fileUrl = this.getPageCache().get("file_url");
        if (fileUrl == null) {
            return;
        }
        List urls = (List)SerializationUtils.fromJsonString((String)fileUrl, List.class);
        for (Object object : objects = evt.getUrls()) {
            String url = (String)((Map)object).get("url");
            urls.remove(url);
        }
        this.getPageCache().put("file_url", SerializationUtils.toJsonString((Object)urls));
    }
}

