/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.decompose.plugin.target;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BasedataFuzzySearchEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.events.ListRowSortEvent;
import kd.bos.mvc.form.FormDataModel;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.utils.BgMemMappingServiceHelper;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.control.ControlModelFuzzySearchCommon;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.collections4.CollectionUtils;

public class TargetSchemeDimMapperListPlugin
extends AbstractFormPlugin
implements ClickListener,
ListRowClickListener,
BeforeF7SelectListener,
BasedataFuzzySearchListener {
    private static final String ADD_NEW = "tblnew";
    private static final String MODIFY = "tblmod";
    private static final String DEL = "tbldel";
    private static final String REFRESH = "tblrefresh";
    private static final String KEY_SCR_BUSMODEL_ID = "KEY_SCR_BUSMODEL_ID";
    private static final String DEL_CALLBACK = "del";
    private static final String YES = "Yes";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addCreateListDataProviderListener(this::beforeCreateListDataProvider);
        billList.addListRowClickListener((ListRowClickListener)this);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        billList.addListRowSortListeners(this::listRowSort);
        billList.addSetFilterListener(this::setFilter);
    }

    private void setFilter(SetFilterEvent e) {
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        e.getQFilters().add(filter);
    }

    private void listRowSort(ListRowSortEvent listRowSortEvent) {
        BillList billList = (BillList)listRowSortEvent.getSource();
        String key = billList.getKey();
        if ("billlistap".equals(key)) {
            this.refreshData();
        }
    }

    private void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                int billDataCount = this.getBillDataCount();
                DynamicObjectCollection pageData = super.getData(start, limit);
                this.getQueryResult().setDataCount(billDataCount);
                TargetSchemeDimMapperListPlugin.this.setCountCache("listCount", billDataCount);
                return pageData;
            }

            public int getRealCount() {
                return TargetSchemeDimMapperListPlugin.this.getCountCache("listCount");
            }
        });
    }

    private int getCountCache(String key) {
        String count = this.getPageCache().get(key);
        if (StringUtils.isEmpty((String)count)) {
            return -1;
        }
        return Integer.parseInt(count);
    }

    private void setCountCache(String key, int count) {
        String countCache = null;
        if (count != -1) {
            countCache = String.valueOf(count);
        }
        this.getPageCache().put(key, countCache);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit model = (BasedataEdit)this.getControl("model");
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (((FormDataModel)e.getSource()).getProperty("model") != null) {
            Long modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
            if (IDUtils.isNotNull((Long)modelId)) {
                this.getModel().setValue("model", (Object)modelId);
                this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"DimMemberMappingListPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        this.getPageCache().put(KEY_SCR_BUSMODEL_ID, this.getView().getFormShowParameter().getCustomParam(KEY_SCR_BUSMODEL_ID).toString());
        this.refreshData();
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "tblnew": {
                long modelId = this.getModelId();
                if (modelId == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"TargetSchemeDimMapperListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    break;
                }
                HashMap<String, Object> params = new HashMap<String, Object>(16);
                params.put("KEY_MODEL_ID", modelId);
                params.put(KEY_SCR_BUSMODEL_ID, this.getPageCache().get(KEY_SCR_BUSMODEL_ID));
                BaseShowParameter parameter = new BaseShowParameter();
                parameter.setFormId("bgm_targetschemedimmapper");
                parameter.setCustomParams(params);
                parameter.setCaption(ResManager.loadKDString((String)"\u7ef4\u5ea6\u627f\u63a5\u6620\u5c04\u65b0\u589e", (String)"TargetSchemeDimMapperListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                parameter.setBillStatus(BillOperationStatus.ADDNEW);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ADD_NEW);
                parameter.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)parameter);
                this.writeLog("view", new MultiLangEnumBridge("\u65b0\u589e", "TargetSchemeDimMapperListPlugin_9", "epm-eb-formplugin"), new MultiLangEnumBridge("\u65b0\u589e\u6210\u529f", "TargetSchemeDimMapperListPlugin_10", "epm-eb-formplugin"));
                break;
            }
            case "tblmod": {
                BillList bl = (BillList)this.getView().getControl("billlistap");
                ListSelectedRowCollection sRows = bl.getSelectedRows();
                if (sRows.size() != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8bb0\u5f55\u8fdb\u884c\u4fee\u6539\u3002", (String)"TargetSchemeDimMapperListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    break;
                }
                Object pkId = ((BillList)this.getView().getControl("billlistap")).getSelectedRows().get(0).getPrimaryKeyValue();
                this.modify(pkId);
                this.writeLog("update", new MultiLangEnumBridge("\u4fee\u6539", "TargetSchemeDimMapperListPlugin_11", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4fee\u6539\u6210\u529f", "TargetSchemeDimMapperListPlugin_12", "epm-eb-formplugin"));
                break;
            }
            case "tbldel": {
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                if (selectedRows.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"TargetSchemeDimMapperListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    break;
                }
                long primaryKeyValue = (Long)selectedRows.get(0).getPrimaryKeyValue();
                List<String> schemeNameList = this.checkTargetSchemeRecord(primaryKeyValue);
                if (CollectionUtils.isNotEmpty(schemeNameList)) {
                    String schemeNameStr = String.join((CharSequence)",", schemeNameList);
                    this.getView().showConfirm(ResManager.loadResFormat((String)"\u76ee\u6807\u4e0b\u8fbe\u65b9\u6848\uff1a%1\uff0c\u4f7f\u7528\u4e86\u7ef4\u5ea6\u627f\u63a5\u6620\u5c04\u7684\u76ee\u6807\u6d4b\u7b97\u548c\u627f\u63a5\u4e1a\u52a1\u6a21\u578b\u7ec4\u5408\uff0c\u5220\u9664\u53ef\u80fd\u4f1a\u5f71\u54cd\u76f8\u5173\u7684\u76ee\u6807\u5206\u89e3\u529f\u80fd\uff0c\u786e\u8ba4\u5220\u9664\uff1f", (String)"TargetSchemeDimMapperListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[]{schemeNameStr}), MessageBoxOptions.YesNo, new ConfirmCallBackListener(DEL_CALLBACK));
                    break;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u9009\u62e9\u7684\u6570\u636e\uff1f", (String)"TargetSchemeDimMapperListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(DEL_CALLBACK));
                break;
            }
            case "tblrefresh": {
                this.refreshData();
                break;
            }
        }
    }

    private List<String> checkTargetSchemeRecord(long primaryKeyValue) {
        DynamicObject dimMapper = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"bgm_targetschemedimmapper");
        DynamicObject scrBussModel = (DynamicObject)dimMapper.get("scrbussmodel");
        long scrBussModelId = scrBussModel.getLong("id");
        DynamicObject tarBussModel = (DynamicObject)dimMapper.get("tarbussmodel");
        long tarBussModelId = tarBussModel.getLong("id");
        QFilter model = new QFilter("model", "=", (Object)this.getModelId());
        QFilter businessModel = new QFilter("targetscheme.bizctrl", "=", (Object)scrBussModelId);
        QFilter bizCtrl = new QFilter("bizctrl", "=", (Object)tarBussModelId);
        String selectFields = "targetscheme.name,desc";
        DynamicObjectCollection records = QueryServiceHelper.query((String)"bgm_targetschemerecord", (String)selectFields, (QFilter[])new QFilter[]{model, businessModel, bizCtrl});
        return records.stream().map(e -> e.getString("targetscheme.name")).collect(Collectors.toList());
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("model".equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            ArrayList qFilterList = ((BasedataEdit)this.getControl("model")).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList();
            }
            qFilterList.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if ("MODEL".equalsIgnoreCase(propName)) {
            Object obj = this.getModel().getValue("model");
            if (obj == null) {
                this.getPageCache().put("KEY_MODEL_ID", null);
            }
            if (obj instanceof DynamicObject) {
                long modelId = ((DynamicObject)obj).getLong("id");
                this.getPageCache().put("KEY_MODEL_ID", Long.toString(modelId));
                this.getPageCache().remove(KEY_SCR_BUSMODEL_ID);
            }
            this.refreshData();
        }
    }

    protected void refreshData() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.getSelectedRows().clear();
        billList.clearSelection();
        billList.refreshData();
    }

    @Override
    public Long getModelId() {
        DynamicObject model;
        long modelId = 0L;
        String modelIdStr = this.getPageCache().get("KEY_MODEL_ID");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)modelIdStr)) {
            modelId = Long.parseLong(modelIdStr);
        } else if (this.getModel().getProperty("model") != null && (model = (DynamicObject)this.getModel().getValue("model")) != null) {
            modelId = model.getLong("id");
        }
        return modelId;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String key = e.getActionId();
        if (ADD_NEW.equals(key) || MODIFY.equals(key)) {
            this.refreshData();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (DEL_CALLBACK.equals(callBackId) && YES.equals(evt.getResultValue())) {
            this.delMapping();
        }
    }

    private void delMapping() {
        String message;
        HashSet mappingIds = new HashSet(16);
        HashSet<Object> delete = new HashSet<Object>(16);
        HashSet<Long> queryId = new HashSet<Long>(16);
        ArrayList<String> noDelNumber = new ArrayList<String>(16);
        ArrayList<String> delNumber = new ArrayList<String>(16);
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bgm_targetschemedimmapper");
        for (Object primaryKeyValue : primaryKeyValues) {
            queryId.add((Long)primaryKeyValue);
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bgm_targetschemedimmapper", (String)"id,model,number,usestatus", (QFilter[])new QFilter[]{new QFilter("id", "in", queryId)}, null);){
            if (ds != null) {
                while (ds.hasNext()) {
                    Row row = ds.next();
                    if (row.getBoolean("usestatus").booleanValue()) {
                        noDelNumber.add(row.getString("number"));
                        continue;
                    }
                    delete.add(row.get("id"));
                    delNumber.add(row.getString("number"));
                }
            }
        }
        if (noDelNumber.size() != 0) {
            message = ResManager.loadKDString((String)"\u542f\u7528\u72b6\u6001\u7684\u7ef4\u5ea6\u627f\u63a5\u6620\u5c04\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"TargetSchemeDimMapperListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(message, Integer.valueOf(5000));
            this.writeLog(null, "delete", new MultiLangEnumBridge("\u5220\u9664", "TargetSchemeDimMapperListPlugin_13", "epm-eb-formplugin"), new MultiLangEnumBridge("\u7f16\u53f7\u201c%1$s\u201d\u5220\u9664\u5931\u8d25\uff0c%2$s\u3002", "TargetSchemeDimMapperListPlugin_15", "epm-eb-formplugin"), new String[]{org.apache.commons.lang3.StringUtils.join(noDelNumber, (String)","), message}, false);
        }
        if (delete.size() != 0) {
            DeleteServiceHelper.delete((IDataEntityType)dynamicObject.getDataEntityType(), (Object[])delete.toArray());
            BgMemMappingServiceHelper.clearCacheByMapping(mappingIds);
            message = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"TargetSchemeDimMapperListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(message);
            this.writeLog(null, "delete", new MultiLangEnumBridge("\u5220\u9664", "TargetSchemeDimMapperListPlugin_13", "epm-eb-formplugin"), new MultiLangEnumBridge("\u7f16\u53f7\uff1a%1$s\uff0c\u5220\u9664\u6210\u529f\u3002", "TargetSchemeDimMapperListPlugin_14", "epm-eb-formplugin"), new String[]{org.apache.commons.lang3.StringUtils.join(delNumber, (String)",")});
        }
        this.refreshData();
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        super.hyperLinkClick(hyperLinkClickEvent);
        BillList bl = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection sRows = bl.getSelectedRows();
        Object pkId = ((BillList)this.getView().getControl("billlistap")).getSelectedRows().get(sRows.size() - 1).getPrimaryKeyValue();
        this.modify(pkId);
    }

    private void modify(Object pkId) {
        long primaryKeyValue = (Long)pkId;
        List<String> schemeNameList = this.checkTargetSchemeRecord(primaryKeyValue);
        HashMap<String, Object> openParameter = new HashMap<String, Object>(16);
        openParameter.put("formId", "bgm_targetschemedimmapper");
        openParameter.put("pkId", String.valueOf(pkId));
        openParameter.put("KEY_MODEL_ID", this.getModelId());
        if (CollectionUtils.isNotEmpty(schemeNameList)) {
            openParameter.put("quoteFlag", "1");
        } else {
            openParameter.put("quoteFlag", "0");
        }
        FormShowParameter formShowParameter = FormShowParameter.createFormShowParameter(openParameter);
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MODIFY));
        this.getView().showForm(formShowParameter);
    }

    public void handleData(BasedataFuzzySearchEvent searchEvent) {
        ControlModelFuzzySearchCommon.getInstance().reWriteData(searchEvent);
    }
}

