/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.decompose.plugin.target;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BasedataFuzzySearchEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.target.TargetSchemeDimMapperPojo;
import kd.epm.eb.common.dao.target.TargetSchemeDimMemberMapPojo;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.excel.BgExcelWriter;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.utils.PluginUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class TargetSchemeDimMapperPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
ClickListener,
BasedataFuzzySearchListener,
CellClickListener {
    private static final String BAR_NEW = "bar_new";
    private static final String BAR_DELETE = "bar_delete";
    private static final String SCR_BUSS_MODEL = "scrbussmodel";
    private static final String TAR_BUSS_MODEL = "tarbussmodel";
    private static final String SELECT_DIMENSION = "select_dimension";
    private static final String SELECT_DIMENSION_NAME = "dimensionname";
    private static final String SCR_MEMBER_NAME = "scrmembername";
    private static final String SCR_MEMBER = "scrmember";
    private static final String TAR_MEMBER_NAME = "tarmembername";
    private static final String TAR_MEMBER = "tarmember";
    private static final String SUB_DIMENSION = "subdimensionid";
    private static final String SUB_DIMENSION_NUMBER = "subdimension";
    private static final String SUB_MEMBER_NAME = "submembername";
    private static final String SUB_MEMBER = "submember";
    private static final String TARGET_SCENARIO_NUMBER = "Target_sys";
    private static final String KEY_SCR_BUSMODEL_ID = "KEY_SCR_BUSMODEL_ID";
    private static final String DIMENSION_CACHE = "dim_cache";
    private static final String BTN_ADDLINE = "addentry";
    private static final String BTN_DELLINE = "deleteentry";
    private static final String SAVE = "save";
    private static final String YES = "Yes";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String USE_STATUS = "usestatus";
    private static final String IMPORT = "import";
    private static final String EXPORT = "export";
    private static final String OPER = "*";
    private static final String IMPORT_CLOSE = "import_close";
    public static String[] excelTitleWithAccount = new String[]{ResManager.loadKDString((String)"\u79d1\u76ee\u5185\u7801*", (String)"TargetSchemeDimMapperImportPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u79d1\u76ee\u540d\u79f0", (String)"TargetSchemeDimMapperImportPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u79d1\u76ee\u5185\u7801*", (String)"TargetSchemeDimMapperImportPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u79d1\u76ee\u540d\u79f0", (String)"TargetSchemeDimMapperImportPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8f85\u52a9\u627f\u63a5\u7ef4\u5ea6\u7f16\u7801", (String)"TargetSchemeDimMapperImportPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8f85\u52a9\u627f\u63a5\u7ef4\u5ea6\u540d\u79f0", (String)"TargetSchemeDimMapperImportPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8f85\u52a9\u627f\u63a5\u7ef4\u5ea6\u6210\u5458\u5185\u7801", (String)"TargetSchemeDimMapperImportPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8f85\u52a9\u627f\u63a5\u7ef4\u5ea6\u6210\u5458\u540d\u79f0", (String)"TargetSchemeDimMapperImportPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0])};

    private static String getNameCn() {
        return ResManager.loadKDString((String)"\u540d\u79f0", (String)"TargetSchemeDimMapperPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String getNumberCn() {
        return ResManager.loadKDString((String)"\u5185\u7801", (String)"TargetSchemeDimMapperPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit scrBussModel = (BasedataEdit)this.getControl(SCR_BUSS_MODEL);
        scrBussModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit tarBussModel = (BasedataEdit)this.getControl(TAR_BUSS_MODEL);
        tarBussModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit subDim = (BasedataEdit)this.getControl(SUB_DIMENSION);
        subDim.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit scrMember = (TextEdit)this.getControl(SCR_MEMBER_NAME);
        scrMember.addClickListener((ClickListener)this);
        TextEdit tarMember = (TextEdit)this.getControl(TAR_MEMBER_NAME);
        tarMember.addClickListener((ClickListener)this);
        TextEdit subMember = (TextEdit)this.getControl(SUB_MEMBER_NAME);
        subMember.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{SELECT_DIMENSION, BTN_ADDLINE, BTN_DELLINE, IMPORT, EXPORT});
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        entry.addCellClickListener((CellClickListener)this);
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BaseShowParameter param = (BaseShowParameter)this.getView().getFormShowParameter();
        if (param != null) {
            IPageCache pageCache = this.getPageCache();
            Long modelId = (Long)PluginUtils.getCustomParams(this.getView(), "KEY_MODEL_ID");
            if (modelId != null && modelId != 0L) {
                pageCache.put("KEY_MODEL_ID", String.valueOf(modelId));
                this.getModel().setValue("model", (Object)modelId);
            }
            if (BillOperationStatus.ADDNEW.getValue() != param.getStatus().getValue()) {
                this.initMixedDimension(false);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BAR_NEW, BAR_DELETE});
    }

    public void afterCreateNewData(EventObject e) {
        String customParams;
        super.afterCreateNewData(e);
        IPageCache pageCache = this.getPageCache();
        Long modelId = (Long)PluginUtils.getCustomParams(this.getView(), "KEY_MODEL_ID");
        if (modelId != null && modelId != 0L) {
            pageCache.put("KEY_MODEL_ID", String.valueOf(modelId));
            this.getModel().setValue("model", (Object)modelId);
        }
        if (StringUtils.isNotBlank((CharSequence)(customParams = (String)PluginUtils.getCustomParams(this.getView(), KEY_SCR_BUSMODEL_ID)))) {
            Long scrBussModelId = Long.valueOf(customParams);
            pageCache.put(KEY_SCR_BUSMODEL_ID, String.valueOf(scrBussModelId));
            this.getModel().setValue(SCR_BUSS_MODEL, (Object)scrBussModelId);
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
    }

    public void afterImportData(ImportDataEventArgs e) {
        CacheServiceHelper.remove((String)"CONTROL_MAPPING_CACHE1");
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        List mapObjList;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (SCR_MEMBER_NAME.equals(actionId)) {
            this.fillDimMember(e, actionId);
        }
        if (TAR_MEMBER_NAME.equals(actionId)) {
            this.fillDimMember(e, actionId);
        }
        if (SUB_MEMBER_NAME.equals(actionId)) {
            this.fillDimMember(e, actionId);
        }
        if (IMPORT_CLOSE.equals(actionId) && (mapObjList = (List)e.getReturnData()) != null) {
            this.refreshDataEntity(mapObjList);
        }
    }

    private void refreshDataEntity(List<TargetSchemeDimMemberMapPojo> mapObjList) {
        this.getModel().beginInit();
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection entryEntity = dataModel.getEntryEntity("entryentity");
        String dimNumber = (String)this.getModel().getValue(SELECT_DIMENSION);
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            block0: for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject row = (DynamicObject)entryEntity.get(i);
                String scrMemberNumber = row.getString(SCR_MEMBER);
                Iterator<TargetSchemeDimMemberMapPojo> ite = mapObjList.iterator();
                while (ite.hasNext()) {
                    TargetSchemeDimMemberMapPojo obj = ite.next();
                    if (!obj.getScrMember().equals(scrMemberNumber)) continue;
                    dataModel.setValue(SCR_MEMBER, (Object)obj.getScrMember(), i);
                    dataModel.setValue(SCR_MEMBER_NAME, (Object)obj.getScrMemberName(), i);
                    dataModel.setValue(TAR_MEMBER, (Object)obj.getTarMember(), i);
                    dataModel.setValue(TAR_MEMBER_NAME, (Object)obj.getTarMemberName(), i);
                    if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
                        dataModel.setValue(SUB_DIMENSION, (Object)obj.getSubDimensionId(), i);
                        dataModel.setValue(SUB_DIMENSION_NUMBER, (Object)obj.getSubDimension(), i);
                        dataModel.setValue(SUB_MEMBER, (Object)obj.getSubMember(), i);
                        dataModel.setValue(SUB_MEMBER_NAME, (Object)obj.getSubMemberName(), i);
                    }
                    ite.remove();
                    continue block0;
                }
            }
        }
        for (TargetSchemeDimMemberMapPojo obj : mapObjList) {
            int newRowIndex = this.getModel().createNewEntryRow("entryentity");
            dataModel.setValue(SCR_MEMBER, (Object)obj.getScrMember(), newRowIndex);
            dataModel.setValue(SCR_MEMBER_NAME, (Object)obj.getScrMemberName(), newRowIndex);
            dataModel.setValue(TAR_MEMBER, (Object)obj.getTarMember(), newRowIndex);
            dataModel.setValue(TAR_MEMBER_NAME, (Object)obj.getTarMemberName(), newRowIndex);
            if (!SysDimensionEnum.Account.getNumber().equals(dimNumber)) continue;
            dataModel.setValue(SUB_DIMENSION, (Object)obj.getSubDimensionId(), newRowIndex);
            dataModel.setValue(SUB_DIMENSION_NUMBER, (Object)obj.getSubDimension(), newRowIndex);
            dataModel.setValue(SUB_MEMBER, (Object)obj.getSubMember(), newRowIndex);
            dataModel.setValue(SUB_MEMBER_NAME, (Object)obj.getSubMemberName(), newRowIndex);
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private void fillDimMember(ClosedCallBackEvent e, String key) {
        ListSelectedRowCollection selectedRowCollection = (ListSelectedRowCollection)e.getReturnData();
        String dimNumber = (String)this.getModel().getValue(SELECT_DIMENSION);
        if (selectedRowCollection != null && selectedRowCollection.size() != 0) {
            ListSelectedRow returnData = selectedRowCollection.get(0);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(selectRows[0]);
            if (SCR_MEMBER_NAME.equals(key)) {
                dynamicObject.set(SCR_MEMBER_NAME, (Object)returnData.getName());
                dynamicObject.set(SCR_MEMBER, (Object)returnData.getNumber());
            } else if (TAR_MEMBER_NAME.equals(key)) {
                dynamicObject.set(TAR_MEMBER_NAME, (Object)returnData.getName());
                dynamicObject.set(TAR_MEMBER, (Object)returnData.getNumber());
                if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
                    int i = this.getSelectRowNumber();
                    this.getModel().setValue(SUB_DIMENSION, null, i);
                    this.getModel().setValue(SUB_DIMENSION_NUMBER, null, i);
                    this.getModel().setValue(SUB_MEMBER_NAME, null, i);
                    this.getModel().setValue(SUB_MEMBER, null, i);
                }
            } else if (SUB_MEMBER_NAME.equals(key)) {
                dynamicObject.set(SUB_MEMBER_NAME, (Object)returnData.getName());
                dynamicObject.set(SUB_MEMBER, (Object)returnData.getNumber());
            }
            this.getView().updateView("entryentity");
        }
    }

    private int getSelectRowNumber() {
        EntryGrid entryEntity = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryEntity.getSelectRows();
        int i = 0;
        if (selectRows.length != 0) {
            i = selectRows[0];
        }
        return i;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String action = e.getCallBackId();
        if ((SCR_BUSS_MODEL.equals(action) || TAR_BUSS_MODEL.equals(action) || SELECT_DIMENSION.equals(action)) && YES.equals(e.getResultValue())) {
            this.clearLine();
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        if (e.getSource() instanceof BasedataEdit) {
            BasedataEdit basedataEdit = (BasedataEdit)e.getSource();
            if (SCR_BUSS_MODEL.equals(basedataEdit.getKey())) {
                ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(SCR_BUSS_MODEL)).getQFilters();
                if (qFilterList == null) {
                    qFilterList = new ArrayList<QFilter>(16);
                }
                qFilterList.add(new QFilter("model", "=", (Object)this.getModelId()));
                qFilterList.add(new QFilter("scenarioentry.appscenario.number", "=", (Object)TARGET_SCENARIO_NUMBER));
                Object tarBussModel = this.getModel().getValue(TAR_BUSS_MODEL);
                if (tarBussModel != null) {
                    Long tarBussModelId = this.getBussModelId(tarBussModel);
                    qFilterList.add(new QFilter("id", "!=", (Object)tarBussModelId));
                }
                showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            } else if (TAR_BUSS_MODEL.equals(basedataEdit.getKey())) {
                ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(TAR_BUSS_MODEL)).getQFilters();
                if (qFilterList == null) {
                    qFilterList = new ArrayList<QFilter>(16);
                }
                qFilterList.add(new QFilter("model", "=", (Object)this.getModelId()));
                Object scrBussModel = this.getModel().getValue(SCR_BUSS_MODEL);
                Long scrBussModelId = this.getBussModelId(scrBussModel);
                qFilterList.add(new QFilter("id", "!=", (Object)scrBussModelId));
                showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            } else if (SUB_DIMENSION.equals(basedataEdit.getKey())) {
                ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(SUB_DIMENSION)).getQFilters();
                if (qFilterList == null) {
                    qFilterList = new ArrayList<QFilter>(16);
                }
                qFilterList.add(new QFilter("model", "=", (Object)this.getModelId()));
                qFilterList.add(new QFilter("issysdimension", "=", (Object)"0"));
                int i = this.getSelectRowNumber();
                String number = (String)this.getModel().getValue(TAR_MEMBER, i);
                IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
                Member member = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, number);
                List<Object> dimNumbers = new ArrayList(16);
                if (member != null) {
                    Long datasetId = member.getDatasetId();
                    dimNumbers = modelCache.getDimensionList(datasetId).stream().filter(dimension -> !dimension.isPreset()).map(BaseCache::getNumber).collect(Collectors.toList());
                } else {
                    Object tarBussModel = this.getModel().getValue(TAR_BUSS_MODEL);
                    Long tarBussModelId = this.getBussModelId(tarBussModel);
                    dimNumbers = modelCache.getDimensionListByBusModel(tarBussModelId).stream().filter(d -> !d.isPreset()).map(BaseCache::getNumber).collect(Collectors.toList());
                }
                this.getSubDimNumber(dimNumbers);
                qFilterList.add(new QFilter(NUMBER, "in", dimNumbers));
                showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            }
        }
    }

    private void getSubDimNumber(List<String> dimNumbers) {
        String dimCache;
        if (CollectionUtils.isNotEmpty(dimNumbers) && StringUtils.isNotBlank((CharSequence)(dimCache = this.getPageCache().get(DIMENSION_CACHE)))) {
            Map dimensionMap = (Map)SerializationUtils.deSerializeFromBase64((String)dimCache);
            Set retain = dimensionMap.keySet();
            dimNumbers.removeAll(retain);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "scrbussmodel": 
            case "tarbussmodel": {
                this.initMixedDimension(true);
                this.checkEntryEntity(propName);
                break;
            }
            case "select_dimension": {
                this.changeEntryEntityTableHead();
                this.updateSelectDimName();
                this.checkEntryEntity(propName);
                break;
            }
            case "subdimensionid": {
                int i = this.getSelectRowNumber();
                this.updateSubDimensionNumber(i);
                this.getModel().setValue(SUB_MEMBER_NAME, null, i);
                this.getModel().setValue(SUB_MEMBER, null, i);
                break;
            }
            case "scrmembername": 
            case "tarmembername": 
            case "submembername": {
                this.setNameAndNumberNull(propName, e);
                break;
            }
        }
    }

    private void setNameAndNumberNull(String key, PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        String newValueS = "";
        String oldValueS = "";
        if (newValue != null) {
            newValueS = newValue.toString();
        }
        if (oldValue != null) {
            oldValueS = oldValue.toString();
        }
        EntryGrid entryEntity = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryEntity.getSelectRows();
        int index = 0;
        if (newValueS.isEmpty() && !oldValueS.isEmpty() || !newValueS.isEmpty() && oldValueS.isEmpty()) {
            if (SCR_MEMBER_NAME.equals(key)) {
                if (selectRows.length > 0) {
                    index = selectRows[0];
                    this.getModel().setValue(SCR_MEMBER_NAME, null, index);
                    this.getModel().setValue(SCR_MEMBER, null, index);
                } else {
                    this.getModel().setValue(SCR_MEMBER_NAME, null);
                    this.getModel().setValue(SCR_MEMBER, null);
                }
            } else if (TAR_MEMBER_NAME.equals(key)) {
                if (selectRows.length > 0) {
                    index = selectRows[0];
                    this.getModel().setValue(TAR_MEMBER_NAME, null, index);
                    this.getModel().setValue(TAR_MEMBER, null, index);
                } else {
                    this.getModel().setValue(TAR_MEMBER_NAME, null);
                    this.getModel().setValue(TAR_MEMBER, null);
                }
            } else if (SUB_MEMBER_NAME.equals(key)) {
                if (selectRows.length > 0) {
                    index = selectRows[0];
                    this.getModel().setValue(SUB_MEMBER_NAME, null, index);
                    this.getModel().setValue(SUB_MEMBER, null, index);
                } else {
                    this.getModel().setValue(TAR_MEMBER_NAME, null);
                    this.getModel().setValue(SUB_MEMBER, null);
                }
            }
        }
    }

    private void checkEntryEntity(String key) {
        if (this.checkSelect(false)) {
            int count = this.getModel().getEntryRowCount("entryentity");
            if (this.checkEntryOneRowValue(count)) {
                switch (key) {
                    case "scrbussmodel": {
                        if (this.getModel().getValue(SCR_BUSS_MODEL) == null) break;
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u91cd\u65b0\u9009\u62e9\u76ee\u6807\u4e1a\u52a1\u6a21\u578b\u4f1a\u6e05\u9664\u5f53\u524d\u7684\u6240\u6709\u7ef4\u5ea6\u627f\u63a5\u6210\u5458\u6620\u5c04\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"TargetSchemeDimMapperPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(SCR_BUSS_MODEL, (IFormPlugin)this));
                        break;
                    }
                    case "tarbussmodel": {
                        if (this.getModel().getValue(TAR_BUSS_MODEL) == null) break;
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u91cd\u65b0\u9009\u62e9\u627f\u63a5\u4e1a\u52a1\u6a21\u578b\u4f1a\u6e05\u9664\u5f53\u524d\u7684\u6240\u6709\u7ef4\u5ea6\u627f\u63a5\u6210\u5458\u6620\u5c04\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"TargetSchemeDimMapperPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(TAR_BUSS_MODEL, (IFormPlugin)this));
                        break;
                    }
                    case "select_dimension": {
                        if (this.getModel().getValue(SELECT_DIMENSION) == null) break;
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u91cd\u65b0\u9009\u62e9\u7ef4\u5ea6\u4f1a\u6e05\u9664\u5f53\u524d\u7684\u6240\u6709\u7ef4\u5ea6\u627f\u63a5\u6210\u5458\u6620\u5c04\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"TargetSchemeDimMapperPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(SELECT_DIMENSION, (IFormPlugin)this));
                        break;
                    }
                }
            } else {
                this.clearLine();
            }
        } else {
            this.clearLine();
        }
    }

    private boolean checkEntryOneRowValue(int count) {
        if (count > 1) {
            return true;
        }
        if (count == 1) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            if (entryEntity == null || entryEntity.get(0) == null) {
                return false;
            }
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(0);
            return StringUtils.isNotBlank((CharSequence)dynamicObject.getString(SCR_MEMBER)) || StringUtils.isNotBlank((CharSequence)dynamicObject.getString(SCR_MEMBER_NAME)) || StringUtils.isNotBlank((CharSequence)dynamicObject.getString(TAR_MEMBER)) || StringUtils.isNotBlank((CharSequence)dynamicObject.getString(TAR_MEMBER_NAME)) || dynamicObject.get(SUB_DIMENSION) != null || StringUtils.isNotBlank((CharSequence)dynamicObject.getString(SUB_DIMENSION_NUMBER)) || StringUtils.isNotBlank((CharSequence)dynamicObject.getString(SUB_MEMBER)) || StringUtils.isNotBlank((CharSequence)dynamicObject.getString(SUB_MEMBER_NAME));
        }
        return false;
    }

    private void clearLine() {
        this.getModel().deleteEntryData("entryentity");
        this.getModel().batchCreateNewEntryRow("entryentity", 1);
    }

    private void updateSelectDimName() {
        String dimCache;
        String selectDim = (String)this.getModel().getValue(SELECT_DIMENSION);
        if (StringUtils.isNotBlank((CharSequence)selectDim) && StringUtils.isNotBlank((CharSequence)(dimCache = this.getPageCache().get(DIMENSION_CACHE)))) {
            Map dimensionMap = (Map)SerializationUtils.deSerializeFromBase64((String)dimCache);
            String dimName = ((Dimension)dimensionMap.get(selectDim)).getName();
            this.getModel().setValue(SELECT_DIMENSION_NAME, (Object)dimName);
        }
    }

    private void initMixedDimension(boolean defaultFlag) {
        Long modelId = this.getModelId();
        if (modelId == null) {
            return;
        }
        ComboEdit combo = (ComboEdit)this.getControl(SELECT_DIMENSION);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        Object scrBussModel = this.getModel().getValue(SCR_BUSS_MODEL);
        Long scrBussModelId = this.getBussModelId(scrBussModel);
        Object tarBussModel = this.getModel().getValue(TAR_BUSS_MODEL);
        Long tarBussModelId = this.getBussModelId(tarBussModel);
        if (scrBussModelId > 0L && tarBussModelId > 0L) {
            IModelCacheHelper cacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
            List srcDimensions = cacheHelper.getDimensionListByBusModel(scrBussModelId);
            List tarDimensions = cacheHelper.getDimensionListByBusModel(tarBussModelId);
            Map dimMap = cacheHelper.getDimensionMap();
            List scrDimNumber = srcDimensions.stream().filter(e -> {
                if (SysDimensionEnum.Account.getNumber().equals(e.getNumber()) || SysDimensionEnum.Entity.getNumber().equals(e.getNumber())) {
                    return true;
                }
                return !e.isPreset();
            }).map(BaseCache::getNumber).collect(Collectors.toList());
            List tarDimNumber = tarDimensions.stream().filter(e -> {
                if (SysDimensionEnum.Account.getNumber().equals(e.getNumber()) || SysDimensionEnum.Entity.getNumber().equals(e.getNumber())) {
                    return true;
                }
                return !e.isPreset();
            }).map(BaseCache::getNumber).collect(Collectors.toList());
            scrDimNumber.retainAll(tarDimNumber);
            HashMap<String, Dimension> retainMap = new HashMap<String, Dimension>(scrDimNumber.size());
            if (!scrDimNumber.isEmpty()) {
                for (String dimNumber : scrDimNumber) {
                    Dimension dimension = (Dimension)dimMap.get(dimNumber);
                    String dimName = dimension.getName();
                    retainMap.put(dimNumber, dimension);
                    items.add(new ComboItem(new LocaleString(dimName), dimNumber));
                    if (!defaultFlag || !SysDimensionEnum.Account.getNumber().equals(dimNumber)) continue;
                    this.getModel().setValue(SELECT_DIMENSION, (Object)dimNumber);
                    this.getModel().setValue(SELECT_DIMENSION_NAME, (Object)dimName);
                }
            }
            combo.setComboItems(items);
            this.getPageCache().put(DIMENSION_CACHE, SerializationUtils.serializeToBase64(retainMap));
            this.changeEntryEntityTableHead();
            this.updateSelectDimName();
            if (!defaultFlag) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{NUMBER});
                String quoteFlag = (String)this.getView().getFormShowParameter().getCustomParam("quoteFlag");
                if ("1".equalsIgnoreCase(quoteFlag)) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{NUMBER, SCR_BUSS_MODEL, TAR_BUSS_MODEL, SELECT_DIMENSION});
                }
            }
        }
    }

    private void changeEntryEntityTableHead() {
        String selectDim = (String)this.getModel().getValue(SELECT_DIMENSION);
        if (StringUtils.isNotBlank((CharSequence)selectDim)) {
            EntryGrid grid = (EntryGrid)this.getControl("entryentity");
            String dimCache = this.getPageCache().get(DIMENSION_CACHE);
            if (StringUtils.isNotBlank((CharSequence)dimCache)) {
                Map dimensionMap = (Map)SerializationUtils.deSerializeFromBase64((String)dimCache);
                String dimName = ((Dimension)dimensionMap.get(selectDim)).getName();
                String dimNumber = dimName + TargetSchemeDimMapperPlugin.getNumberCn();
                grid.setColumnProperty(SCR_MEMBER_NAME, "header", (Object)new LocaleString(dimName));
                grid.setColumnProperty(SCR_MEMBER, "header", (Object)new LocaleString(dimNumber));
                grid.setColumnProperty(TAR_MEMBER_NAME, "header", (Object)new LocaleString(dimName));
                grid.setColumnProperty(TAR_MEMBER, "header", (Object)new LocaleString(dimNumber));
            }
            if (!SysDimensionEnum.Account.getNumber().equals(selectDim)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{SUB_DIMENSION, SUB_DIMENSION_NUMBER, SUB_MEMBER_NAME, SUB_MEMBER});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{SUB_DIMENSION, SUB_DIMENSION_NUMBER, SUB_MEMBER_NAME, SUB_MEMBER});
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (source.getKey().equals(SCR_MEMBER_NAME) || source.getKey().equals(TAR_MEMBER_NAME) || source.getKey().equals(SUB_MEMBER_NAME)) {
            String dimNumber = (String)this.getModel().getValue(SELECT_DIMENSION);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, source.getKey());
            Long modelId = this.getModelId();
            Object bussModel = new Object();
            String value = "";
            switch (source.getKey()) {
                case "scrmembername": {
                    bussModel = this.getModel().getValue(SCR_BUSS_MODEL);
                    value = (String)this.getModel().getValue(SCR_MEMBER, this.getSelectRowNumber());
                    break;
                }
                case "tarmembername": {
                    bussModel = this.getModel().getValue(TAR_BUSS_MODEL);
                    value = (String)this.getModel().getValue(TAR_MEMBER, this.getSelectRowNumber());
                    break;
                }
                case "submembername": {
                    int selectRowNumber = this.getSelectRowNumber();
                    DynamicObject subDimension = (DynamicObject)this.getModel().getValue(SUB_DIMENSION, selectRowNumber);
                    dimNumber = (String)this.getModel().getValue(SUB_DIMENSION_NUMBER, selectRowNumber);
                    if (subDimension == null || StringUtils.isBlank((CharSequence)dimNumber) || !subDimension.get(NUMBER).equals(dimNumber)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8f85\u52a9\u627f\u63a5\u7ef4\u5ea6\u3002", (String)"TargetSchemeDimMapperPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    bussModel = this.getModel().getValue(TAR_BUSS_MODEL);
                    value = (String)this.getModel().getValue(SUB_MEMBER, this.getSelectRowNumber());
                    break;
                }
            }
            Long busModelId = this.getBussModelId(bussModel);
            Long viewId = BusinessModelServiceHelper.getInstance().getViewId(busModelId, dimNumber, this.getModelId());
            MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
            f7Param.setBusModelId(busModelId);
            f7Param.setViewId(viewId);
            f7Param.setEnableView(true);
            if (IDUtils.isNotNull((Long)f7Param.getBusModelId())) {
                f7Param.setDatasetIds(DatasetServiceHelper.getInstance().getDataSetIdByBizModelId(f7Param.getBusModelId()));
            }
            f7Param.setSelectIds(this.getMemberEchoIds(dimNumber, busModelId, value));
            f7Param.setCanSelectRoot(false);
            NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)closeCallBack);
        }
        if (source.getKey().equals(BTN_ADDLINE) && this.checkSelect(true)) {
            this.addLine();
        }
        if (source.getKey().equals(BTN_DELLINE)) {
            this.delLine();
        }
        if (source.getKey().equals(IMPORT)) {
            this.openImportPage();
        }
        if (source.getKey().equals(EXPORT)) {
            this.exportExcel();
        }
    }

    private Set<Long> getMemberEchoIds(String dimNumber, Long businessModelId, String value) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        LinkedHashSet objects = Sets.newLinkedHashSet();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            String[] split;
            for (String s : split = value.split(",")) {
                Member member = modelCacheHelper.getMemberByAnyView(businessModelId, dimNumber, s);
                if (member == null) continue;
                objects.add(member.getId());
            }
        }
        return objects;
    }

    private void openImportPage() {
        if (this.checkSelect(true)) {
            HashMap<String, String> openParameter = new HashMap<String, String>(16);
            openParameter.put("formId", "epm_import");
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(openParameter);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            Long modelId = this.getModelId();
            showParameter.setCustomParam("model", (Object)modelId);
            String dimNumber = (String)this.getModel().getValue(SELECT_DIMENSION);
            showParameter.setCustomParam("selectDimNumber", (Object)dimNumber);
            String dimName = (String)this.getModel().getValue(SELECT_DIMENSION_NAME);
            showParameter.setCustomParam("selectDimName", (Object)dimName);
            Object scrBussModel = this.getModel().getValue(SCR_BUSS_MODEL);
            Long scrBussModelId = this.getBussModelId(scrBussModel);
            Object tarBussModel = this.getModel().getValue(TAR_BUSS_MODEL);
            Long tarBussModelId = this.getBussModelId(tarBussModel);
            showParameter.setCustomParam("scrBussModel", (Object)scrBussModelId);
            showParameter.setCustomParam("tarBussModel", (Object)tarBussModelId);
            FormConfig formConfig = FormMetadataCache.getFormConfig((String)"epm_import");
            showParameter.setFormConfig(formConfig);
            showParameter.addCustPlugin("kd.epm.eb.formplugin.decompose.plugin.target.TargetSchemeDimMapperImportPlugin");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, IMPORT_CLOSE));
            showParameter.setCaption(ResManager.loadKDString((String)"\u7ef4\u5ea6\u627f\u63a5\u6210\u5458\u6620\u5c04\u5bfc\u5165", (String)"TargetSchemeDimMapperPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.getView().showForm(showParameter);
        }
    }

    private void exportExcel() {
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        if (rowCount == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u627f\u63a5\u6210\u5458\u6620\u5c04\u65e0\u6570\u636e\u53ef\u5bfc\u51fa", (String)"TargetSchemeDimMapperPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String dimNumber = (String)this.getModel().getValue(SELECT_DIMENSION);
        BgExcelWriter excelWriter = SysDimensionEnum.Account.getNumber().equals(dimNumber) ? this.createRowsWithAccount(rowCount) : this.createRowsWithOutAccount(rowCount);
        String fileName = ResManager.loadResFormat((String)"\u7ef4\u5ea6\u627f\u63a5\u6210\u5458\u6620\u5c04\u6e05\u5355_%1", (String)"TargetSchemeDimMapperPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[]{DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        String url = excelWriter.getDownloadUrl(fileName + ".xlsx");
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
    }

    private BgExcelWriter createRowsWithOutAccount(int rowCount) {
        BgExcelWriter excelWriter = TargetSchemeDimMapperPlugin.createWorkBookWriter(false);
        excelWriter.setStarPosition(2, 0);
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject entryData = this.getModel().getEntryRowEntity("entryentity", i);
            if (i == 0) {
                String dimName = (String)this.getModel().getValue(SELECT_DIMENSION_NAME);
                String dimNumber = (String)this.getModel().getValue(SELECT_DIMENSION);
                StringBuilder dimNumberSb = new StringBuilder();
                dimNumberSb.append(dimName).append(TargetSchemeDimMapperPlugin.getNumberCn()).append("#").append(dimNumber).append(".").append(NUMBER).append(OPER);
                StringBuilder dimNameSb = new StringBuilder();
                dimNameSb.append(dimName).append(TargetSchemeDimMapperPlugin.getNameCn()).append("#").append(dimNumber).append(".").append(NAME);
                excelWriter.createRow(new Object[]{dimNumberSb.toString(), dimNameSb.toString(), dimNumberSb.toString(), dimNameSb.toString()});
            }
            String scrMember = entryData.getString(SCR_MEMBER);
            String scrMemberName = entryData.getString(SCR_MEMBER_NAME);
            String tarMember = entryData.getString(TAR_MEMBER);
            String tarMemberName = entryData.getString(TAR_MEMBER_NAME);
            excelWriter.createRow(new Object[]{scrMember, scrMemberName, tarMember, tarMemberName});
        }
        return excelWriter;
    }

    private BgExcelWriter createRowsWithAccount(int rowCount) {
        BgExcelWriter excelWriter = TargetSchemeDimMapperPlugin.createWorkBookWriter(true);
        excelWriter.setStarPosition(3, 0);
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject entryData = this.getModel().getEntryRowEntity("entryentity", i);
            String scrMember = entryData.getString(SCR_MEMBER);
            String scrMemberName = entryData.getString(SCR_MEMBER_NAME);
            String tarMember = entryData.getString(TAR_MEMBER);
            String tarMemberName = entryData.getString(TAR_MEMBER_NAME);
            String subDimensionNumber = entryData.getString(SUB_DIMENSION_NUMBER);
            DynamicObject subDimension = entryData.getDynamicObject(SUB_DIMENSION);
            String subDimensionName = "";
            if (subDimension != null) {
                subDimensionName = subDimension.getString(NAME);
            }
            String subMember = entryData.getString(SUB_MEMBER);
            String subMemberName = entryData.getString(SUB_MEMBER_NAME);
            excelWriter.createRow(new Object[]{scrMember, scrMemberName, tarMember, tarMemberName, subDimensionNumber, subDimensionName, subMember, subMemberName});
        }
        return excelWriter;
    }

    public static BgExcelWriter createWorkBookWriter(Boolean isAccount) {
        int colLength = isAccount != false ? 8 : 4;
        XSSFWorkbook workbook = new XSSFWorkbook();
        workbook.createSheet("Sheet1");
        Sheet sheet = workbook.getSheetAt(0);
        Row rowHead = sheet.createRow(0);
        Cell cell = rowHead.createCell(0);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, colLength - 1));
        cell.setCellValue(ResManager.loadKDString((String)"\u7ef4\u5ea6\u627f\u63a5\u6210\u5458\u6620\u5c04", (String)"TargetSchemeDimMapperPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        CellStyle title1 = workbook.createCellStyle();
        title1.setAlignment(HorizontalAlignment.CENTER);
        title1.setVerticalAlignment(VerticalAlignment.CENTER);
        Font font = workbook.createFont();
        font.setFontHeightInPoints((short)20);
        title1.setFont(font);
        cell.setCellStyle(title1);
        Row rowHead1 = sheet.createRow(1);
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 0, 1));
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 2, colLength - 1));
        CellStyle title2 = workbook.createCellStyle();
        title2.setAlignment(HorizontalAlignment.CENTER);
        Cell cell1 = rowHead1.createCell(0);
        cell1.setCellValue(ResManager.loadKDString((String)"\u76ee\u6807\u6d4b\u7b97\u7ef4\u5ea6\u6210\u5458", (String)"TargetSchemeDimMapperPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        cell1.setCellStyle(title2);
        Cell cell2 = rowHead1.createCell(2);
        cell2.setCellValue(ResManager.loadKDString((String)"\u76ee\u6807\u627f\u63a5\u7ef4\u5ea6\u6210\u5458", (String)"TargetSchemeDimMapperPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        cell2.setCellStyle(title2);
        for (int i = 0; i < colLength; ++i) {
            sheet.setColumnWidth(i, 6000);
        }
        if (isAccount.booleanValue()) {
            Row titleRow = sheet.createRow(2);
            for (int i = 0; i < excelTitleWithAccount.length; ++i) {
                String titleName = excelTitleWithAccount[i];
                Cell cellTitle = titleRow.createCell(i);
                cellTitle.setCellValue(titleName);
            }
        }
        BgExcelWriter excelWriter = BgExcelWriter.getInstance().readTemplate((Workbook)workbook);
        return excelWriter;
    }

    private boolean checkSelect(boolean showTip) {
        return this.checkModel(showTip) && this.checkSelectScrBussModel(showTip) && this.checkSelectTarBussModel(showTip) && this.checkSelectDim(showTip);
    }

    private boolean checkSelectDim(boolean showTip) {
        boolean re = true;
        String dimNumber = (String)this.getModel().getValue(SELECT_DIMENSION);
        if (StringUtils.isBlank((CharSequence)dimNumber)) {
            re = false;
            if (showTip) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6", (String)"TargetSchemeDimMapperPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        return re;
    }

    private boolean checkSelectTarBussModel(boolean showTip) {
        boolean re = true;
        DynamicObject tarBussModel = (DynamicObject)this.getModel().getValue(TAR_BUSS_MODEL);
        if (tarBussModel == null) {
            re = false;
            if (showTip) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u627f\u63a5\u4e1a\u52a1\u6a21\u578b\u3002", (String)"TargetSchemeDimMapperPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        return re;
    }

    private boolean checkSelectScrBussModel(boolean showTip) {
        boolean re = true;
        DynamicObject scrBussModel = (DynamicObject)this.getModel().getValue(SCR_BUSS_MODEL);
        if (scrBussModel == null) {
            re = false;
            if (showTip) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u4e1a\u52a1\u6a21\u578b\u3002", (String)"TargetSchemeDimMapperPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        return re;
    }

    private boolean checkModel(boolean showTip) {
        boolean re = true;
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        if (model == null) {
            re = false;
            if (showTip) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"TargetSchemeDimMapperPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        return re;
    }

    @Override
    public Long getModelId() {
        String modelId = this.getPageCache().get("KEY_MODEL_ID");
        if (StringUtils.isBlank((CharSequence)modelId)) {
            return super.getModelId();
        }
        return Long.valueOf(modelId);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (SAVE.equals(operate.getOperateKey())) {
            String tips = NumberCheckUtils.checkNumberRule((String)this.getModel().getValue(NUMBER).toString());
            if (StringUtils.isNotEmpty((CharSequence)tips)) {
                throw new KDBizException(tips);
            }
            if (BooleanUtils.isFalse((Boolean)this.validate())) {
                args.setCancel(true);
            }
        }
    }

    private boolean validate() {
        DynamicObjectCollection entrys;
        boolean result = true;
        IDataModel model = this.getModel();
        Object value = model.getValue(NUMBER);
        Object name = model.getValue(NAME);
        if (Objects.nonNull(value)) {
            if (value.toString().matches("[\u4e00-\u9fa5]+")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u5141\u8bb8\u8f93\u5165\u4e2d\u6587", (String)"TargetSchemeDimMapperPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (StringUtils.isEmpty((CharSequence)value.toString().trim()) || StringUtils.isEmpty((CharSequence)name.toString())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u6216\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"TargetSchemeDimMapperPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        IModelCacheHelper cacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        DynamicObject scrBussModel = (DynamicObject)model.getValue(SCR_BUSS_MODEL);
        DynamicObject tarBussModel = (DynamicObject)model.getValue(TAR_BUSS_MODEL);
        Map tarViewIds = cacheHelper.getViewsByBusModel(Long.valueOf(tarBussModel.getLong("id")));
        String dimNumber = (String)model.getValue(SELECT_DIMENSION);
        if (scrBussModel != null && tarBussModel != null && StringUtils.isNotBlank((CharSequence)dimNumber)) {
            QFilter[] qFilters;
            TargetSchemeDimMapperPojo pojo = new TargetSchemeDimMapperPojo(Long.valueOf(scrBussModel.getLong("id")), Long.valueOf(tarBussModel.getLong("id")), dimNumber);
            QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
            Long id = (Long)model.getValue("id");
            if (id != null && id != 0L) {
                QFilter idFilter = new QFilter("id", "!=", (Object)id);
                qFilters = new QFilter[]{filter, idFilter};
            } else {
                qFilters = new QFilter[]{filter};
            }
            DynamicObject[] tarDimMapper = BusinessDataServiceHelper.load((String)"bgm_targetschemedimmapper", (String)"scrbussmodel.id, tarbussmodel.id, select_dimension", (QFilter[])qFilters);
            ArrayList<TargetSchemeDimMapperPojo> pojos = new ArrayList<TargetSchemeDimMapperPojo>(tarDimMapper.length);
            if (tarDimMapper.length > 0) {
                for (DynamicObject object : tarDimMapper) {
                    pojos.add(new TargetSchemeDimMapperPojo(Long.valueOf(object.getLong("scrbussmodel.id")), Long.valueOf(object.getLong("tarbussmodel.id")), object.getString(SELECT_DIMENSION)));
                }
                if (pojos.contains(pojo)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u4e1a\u52a1\u6a21\u578b\u3001\u627f\u63a5\u4e1a\u52a1\u6a21\u578b\u3001\u7ef4\u5ea6\u7ec4\u5408\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\u3002", (String)"TargetSchemeDimMapperPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return false;
                }
            }
        }
        if ((entrys = model.getEntryEntity("entryentity")).size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u81f3\u5c11\u5b58\u5728\u4e00\u884c\u8bb0\u5f55\u3002", (String)"TargetSchemeDimMapperPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        HashMap<String, Integer> scrMemberMap = new HashMap<String, Integer>(16);
        HashMap<String, Integer> tarMemberMap = new HashMap<String, Integer>(16);
        HashMap<Integer, List<List<Member>>> leafMemberDescartesMap = new HashMap<Integer, List<List<Member>>>(16);
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            String scrMemberName = entry.getString(SCR_MEMBER_NAME);
            String tarMemberName = entry.getString(TAR_MEMBER_NAME);
            if (StringUtils.isBlank((CharSequence)scrMemberName) && StringUtils.isBlank((CharSequence)tarMemberName)) {
                entry.set(SCR_MEMBER, (Object)"");
                entry.set(TAR_MEMBER, (Object)"");
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u76ee\u6807\u6d4b\u7b97\u7ef4\u5ea6\u6210\u5458\u548c\u76ee\u6807\u627f\u63a5\u7ef4\u5ea6\u6210\u5458\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"TargetSchemeDimMapperPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1}));
                return false;
            }
            if (StringUtils.isBlank((CharSequence)scrMemberName)) {
                entry.set(SCR_MEMBER, (Object)"");
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u76ee\u6807\u6d4b\u7b97\u7ef4\u5ea6\u6210\u5458\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"TargetSchemeDimMapperPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1}));
                return false;
            }
            if (StringUtils.isBlank((CharSequence)tarMemberName)) {
                entry.set(TAR_MEMBER, (Object)"");
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u76ee\u6807\u627f\u63a5\u7ef4\u5ea6\u6210\u5458\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"TargetSchemeDimMapperPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1}));
                return false;
            }
            if (!result) continue;
            String scrMemberNumber = entry.getString(SCR_MEMBER);
            String tarMemberNumber = entry.getString(TAR_MEMBER);
            DynamicObject subDim = entry.getDynamicObject(SUB_DIMENSION);
            String subDimNumber = entry.getString(SUB_MEMBER);
            Member scrMember = cacheHelper.getMemberByAnyView(Long.valueOf(scrBussModel.getLong("id")), dimNumber, scrMemberNumber);
            Member tarMember = cacheHelper.getMemberByAnyView(Long.valueOf(tarBussModel.getLong("id")), dimNumber, tarMemberNumber);
            if (scrMember == null) {
                this.getModel().setValue(SCR_MEMBER_NAME, null, i);
                this.getModel().setValue(SCR_MEMBER, null, i);
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u76ee\u6807\u6d4b\u7b97\u7ef4\u5ea6\u6210\u5458\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"TargetSchemeDimMapperPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1}));
                return false;
            }
            if (tarMember == null) {
                this.getModel().setValue(TAR_MEMBER_NAME, null, i);
                this.getModel().setValue(TAR_MEMBER, null, i);
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u76ee\u6807\u627f\u63a5\u7ef4\u5ea6\u6210\u5458\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"TargetSchemeDimMapperPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1}));
                return false;
            }
            if (subDim != null && StringUtils.isBlank((CharSequence)subDimNumber)) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5df2\u9009\u62e9\u7b2c%1\u884c\u8f85\u52a9\u7ef4\u5ea6\uff0c\u8bf7\u9009\u62e9\u76f8\u5e94\u7684\u8f85\u52a9\u7ef4\u5ea6\u6210\u5458\u3002", (String)"TargetSchemeDimMapperPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1}));
                return false;
            }
            if (!result) continue;
            if (!(result = this.checkMemberContains(result, cacheHelper, scrBussModel.getLong("id"), dimNumber, scrMember, scrMemberMap, i, scrMemberNumber, SCR_MEMBER))) {
                return result;
            }
            if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
                List<List<Member>> leafMemberDescartes = this.getDescartesByAccountAndSubDim(cacheHelper, tarViewIds, entry, tarMember, i);
                if (leafMemberDescartesMap.size() > 0) {
                    for (Map.Entry leafEntry : leafMemberDescartesMap.entrySet()) {
                        int row = (Integer)leafEntry.getKey();
                        List leafList = (List)leafEntry.getValue();
                        if (Collections.disjoint(leafMemberDescartes, leafList)) continue;
                        String subMemberNumber = entry.getString(SUB_MEMBER);
                        if (StringUtils.isNotBlank((CharSequence)subMemberNumber)) {
                            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u548c\u7b2c%2\u884c\u7684\u76ee\u6807\u627f\u63a5\u7ef4\u5ea6\u6210\u5458\u548c\u8f85\u52a9\u7ef4\u5ea6\u6210\u5458\u660e\u7ec6\u8282\u70b9\u7ec4\u5408\u91cd\u590d\u3002", (String)"TargetSchemeDimMapperPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1, row + 1}));
                            return false;
                        }
                        this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u548c\u7b2c%2\u884c\u7684\u76ee\u6807\u627f\u63a5\u7ef4\u5ea6\u6210\u5458\u91cd\u590d\u6216\u5b58\u5728\u4e0a\u4e0b\u7ea7\u5173\u7cfb\u3002", (String)"TargetSchemeDimMapperPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1, row + 1}));
                        return false;
                    }
                    if (!result) continue;
                    leafMemberDescartesMap.put(i, leafMemberDescartes);
                    continue;
                }
                leafMemberDescartesMap.put(i, leafMemberDescartes);
                continue;
            }
            if (result = this.checkMemberContains(result, cacheHelper, tarBussModel.getLong("id"), dimNumber, tarMember, tarMemberMap, i, tarMemberNumber, TAR_MEMBER)) continue;
            return result;
        }
        return result;
    }

    private List<List<Member>> getDescartesByAccountAndSubDim(IModelCacheHelper cacheHelper, Map<String, Long> viewIds, DynamicObject entry, Member member, int i) {
        List leafLists;
        String subMemberNumber;
        Member subMember;
        List tarLeafMembers = cacheHelper.getLeaf(member);
        String subDimNumber = entry.getString(SUB_DIMENSION_NUMBER);
        String subMemberName = entry.getString(SUB_MEMBER_NAME);
        Long viewId = viewIds.get(subDimNumber);
        if (StringUtils.isBlank((CharSequence)subMemberName)) {
            entry.set(SUB_MEMBER, (Object)"");
        }
        if ((subMember = cacheHelper.getMember(subDimNumber, viewId, subMemberNumber = entry.getString(SUB_MEMBER))) == null) {
            this.getModel().setValue(SUB_MEMBER_NAME, null, i);
            this.getModel().setValue(SUB_MEMBER, null, i);
        }
        if (StringUtils.isNotBlank((CharSequence)subDimNumber) && StringUtils.isNotBlank((CharSequence)subMemberNumber) && subMember != null) {
            List subLeafMembers = cacheHelper.getLeaf(subMember);
            leafLists = Lists.cartesianProduct((List[])new List[]{tarLeafMembers, subLeafMembers});
        } else {
            ArrayList<List> subNoneLeafMembers = new ArrayList<List>(16);
            subNoneLeafMembers.add(tarLeafMembers);
            Long datasetId = member.getDatasetId();
            List<String> dimNumbers = cacheHelper.getDimensionList(datasetId).stream().filter(dimension -> !dimension.isPreset()).map(BaseCache::getNumber).collect(Collectors.toList());
            this.getSubDimNumber(dimNumbers);
            if (CollectionUtils.isNotEmpty(dimNumbers)) {
                for (String dimNumber : dimNumbers) {
                    ArrayList<Member> subNoneMembers = new ArrayList<Member>(16);
                    Dimension dimension2 = cacheHelper.getDimension(dimNumber);
                    String noneNumber = dimension2.getNoneNumber();
                    Member noneMember = cacheHelper.getMember(dimNumber, viewId, noneNumber);
                    subNoneMembers.add(noneMember);
                    subNoneLeafMembers.add(subNoneMembers);
                }
            }
            leafLists = Lists.cartesianProduct(subNoneLeafMembers);
        }
        return leafLists;
    }

    private boolean checkMemberContains(boolean result, IModelCacheHelper cacheHelper, Long businessModelId, String dimNumber, Member member, Map<String, Integer> tarMemberMap, int i, String memberNumber, String memberType) {
        List curLeafMemberNumbers = member.getAllMembers().stream().map(BaseCache::getNumber).collect(Collectors.toList());
        for (Map.Entry<String, Integer> tarMemberEntry : tarMemberMap.entrySet()) {
            String beforeMemberNumber = tarMemberEntry.getKey();
            Long viewId = cacheHelper.getViewByBusModelAndDimNumber(businessModelId, dimNumber);
            Member beforeMember = cacheHelper.getMember(dimNumber, viewId, beforeMemberNumber);
            if (beforeMember == null) {
                beforeMember = cacheHelper.getMemberByAnyView(businessModelId, dimNumber, beforeMemberNumber);
            }
            List beforeLeafMemberNumbers = beforeMember.getAllMembers().stream().map(BaseCache::getNumber).collect(Collectors.toList());
            int row = tarMemberEntry.getValue();
            if (SCR_MEMBER.equals(memberType)) {
                if (memberNumber.equals(beforeMemberNumber)) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u548c\u7b2c%2\u884c\u7684\u76ee\u6807\u6d4b\u7b97\u7ef4\u5ea6\u6210\u5458\u91cd\u590d\u3002", (String)"TargetSchemeDimMapperPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1, row + 1}));
                    return false;
                }
                if (!curLeafMemberNumbers.contains(beforeMemberNumber) && !beforeLeafMemberNumbers.contains(memberNumber)) continue;
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u548c\u7b2c%2\u884c\u7684\u76ee\u6807\u6d4b\u7b97\u7ef4\u5ea6\u6210\u5458\u5b58\u5728\u4e0a\u4e0b\u7ea7\u5173\u7cfb\u3002", (String)"TargetSchemeDimMapperPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1, row + 1}));
                return false;
            }
            if (!TAR_MEMBER.equals(memberType)) continue;
            if (memberNumber.equals(beforeMemberNumber)) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u548c\u7b2c%2\u884c\u7684\u76ee\u6807\u627f\u63a5\u7ef4\u5ea6\u6210\u5458\u91cd\u590d\u3002", (String)"TargetSchemeDimMapperPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1, row + 1}));
                return false;
            }
            if (!curLeafMemberNumbers.contains(beforeMemberNumber) && !beforeLeafMemberNumbers.contains(memberNumber)) continue;
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u548c\u7b2c%2\u884c\u7684\u76ee\u6807\u627f\u63a5\u7ef4\u5ea6\u6210\u5458\u5b58\u5728\u4e0a\u4e0b\u7ea7\u5173\u7cfb\u3002", (String)"TargetSchemeDimMapperPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1, row + 1}));
            return false;
        }
        if (result) {
            tarMemberMap.put(memberNumber, i);
        }
        return result;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (SAVE.equals(operate.getOperateKey()) && args.getOperationResult().isSuccess()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{NUMBER});
        }
    }

    protected void addLine() {
        this.getModel().createNewEntryRow("entryentity");
    }

    protected void delLine() {
        int rowIndex = ((EntryGrid)this.getControl("entryentity")).getEntryState().getFocusRow();
        if (rowIndex >= 0) {
            this.getModel().deleteEntryRow("entryentity", rowIndex);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u884c\u3002", (String)"TargetSchemeDimMapperPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public String getBizEntityNumber() {
        return this.getModel().getDataEntityType().getName();
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
    }

    public void handleData(BasedataFuzzySearchEvent searchEvent) {
    }

    private Long getBussModelId(Object bussModel) {
        if (bussModel != null) {
            return ((DynamicObject)bussModel).getLong("id");
        }
        return 0L;
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        super.click((EventObject)cellClickEvent);
    }

    private void updateSubDimensionNumber(int i) {
        DynamicObject subDim = (DynamicObject)this.getModel().getValue(SUB_DIMENSION, i);
        if (subDim != null) {
            String subDimNumber = subDim.getString(NUMBER);
            this.getModel().setValue(SUB_DIMENSION_NUMBER, (Object)subDimNumber, i);
        } else {
            this.getModel().setValue(SUB_DIMENSION_NUMBER, null, i);
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }
}

