/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.decompose.plugin.target;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BasedataFuzzySearchEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.target.service.TargetSchemeService;
import kd.epm.eb.common.decompose.entity.DecomposeSchemeStatus;
import kd.epm.eb.common.decompose.entity.TargetSchemeRecordStatusEnum;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.control.ControlModelFuzzySearchCommon;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class TargetSchemeIssuedConfirmPlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener,
BasedataFuzzySearchListener {
    private static final Log log = LogFactory.getLog(TargetSchemeIssuedConfirmPlugin.class);
    private static final String CONFIRM = "btnok";
    private static final String CONFIRM_START = "btnokandstart";
    private static final String CANCEL = "btncancel";
    private static final String PASS_LABEL_AP = "labelap";
    private static final String IMAGE_AP = "imageap";
    private static final String STATUS = "status";

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CONFIRM, CANCEL, CONFIRM_START});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Label label = (Label)this.getView().getControl(PASS_LABEL_AP);
        label.setText(ResManager.loadKDString((String)"\u76ee\u6807\u6570\u636e\u5c06\u5206\u53d1\u7ed9\u5bf9\u5e94\u7684\u9884\u7b97\u7ec4\u7ec7\uff0c\u8bf7\u786e\u8ba4\u6267\u884c\u3002", (String)"TargetSchemeIssuedConfirmPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey()) {
            case "btnok": 
            case "btnokandstart": {
                this.targetSchemeDecompose(key);
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
        }
    }

    private void targetSchemeDecompose(String key) {
        String schemeStatus = null;
        if (CONFIRM_START.equals(key)) {
            schemeStatus = DecomposeSchemeStatus.START.getNumber();
            this.getView().setReturnData((Object)"1");
            this.getView().returnDataToParent((Object)"1");
        } else if (CONFIRM.equals(key)) {
            schemeStatus = DecomposeSchemeStatus.SAVE.getNumber();
            this.getView().setReturnData((Object)"2");
            this.getView().returnDataToParent((Object)"2");
        }
        long modelId = (Long)PluginUtils.getCustomParams(this.getView(), "modelId");
        long bizModelId = (Long)PluginUtils.getCustomParams(this.getView(), "bizModelId");
        long srcBizCtrlId = (Long)PluginUtils.getCustomParams(this.getView(), "srcBizCtrlId");
        long tarBizCtrlId = (Long)PluginUtils.getCustomParams(this.getView(), "tarBizCtrlId");
        long recordId = (Long)PluginUtils.getCustomParams(this.getView(), "recordId");
        TargetSchemeService instance = TargetSchemeService.getInstance();
        try {
            List datas = instance.getSrcOlap(Long.valueOf(recordId));
            OlapTraceServiceHelper.setTraceOpInfo((String)String.format("recordId:%d", recordId));
            OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.TargetDecompose));
            instance.executeTargetSchemeToDecompose(recordId, datas, modelId, bizModelId, srcBizCtrlId, tarBizCtrlId, schemeStatus);
        }
        catch (Exception e) {
            if (e instanceof KDBizException) {
                throw e;
            }
            this.delDecomposeSchemeByRecord(modelId, recordId);
            log.error("target scheme issued error", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u6807\u4e0b\u8fbe\u5931\u8d25", (String)"TargetSchemeIssuedConfirmPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObject targetSchemeRecord = BusinessDataServiceHelper.loadSingle((Object)recordId, (String)"bgm_targetschemerecord");
        targetSchemeRecord.set(STATUS, (Object)TargetSchemeRecordStatusEnum.ISSUED.getValue());
        SaveServiceHelper.update((DynamicObject)targetSchemeRecord);
        QFilter filter = new QFilter("targetrecord", "=", (Object)recordId);
        DynamicObject decomposeScheme = BusinessDataServiceHelper.loadSingle((String)"eb_decompose_scheme", (String)"id, number, name, status", (QFilter[])new QFilter[]{filter});
        if (decomposeScheme != null && DecomposeSchemeStatus.FINISHED.getNumber().equals(decomposeScheme.getString(STATUS))) {
            this.getView().setReturnData((Object)"3");
            this.getView().returnDataToParent((Object)"3");
        }
        this.getView().close();
    }

    private void delDecomposeSchemeByRecord(long modelId, long recordId) {
        QFilter model = new QFilter("model", "=", (Object)modelId);
        QFilter filter = new QFilter("targetrecord", "=", (Object)recordId);
        DynamicObject decomposeScheme = BusinessDataServiceHelper.loadSingle((String)"eb_decompose_scheme", (String)"id, number, name, status", (QFilter[])new QFilter[]{model, filter});
        if (decomposeScheme != null) {
            long schemeId = decomposeScheme.getLong("id");
            QFilter scheme = new QFilter("scheme", "=", (Object)schemeId);
            DynamicObject[] tasks = BusinessDataServiceHelper.load((String)"eb_decompose_task", (String)"id, account, srcdimensionjson, firstflag", (QFilter[])new QFilter[]{scheme});
            ArrayList<Long> taskIds = new ArrayList<Long>(tasks.length);
            if (tasks.length > 0) {
                for (DynamicObject task : tasks) {
                    long taskId = task.getLong("id");
                    taskIds.add(taskId);
                }
            }
            DeleteServiceHelper.delete((String)"eb_decompose_log", (QFilter[])new QFilter("task", "in", taskIds).toArray());
            DeleteServiceHelper.delete((String)"eb_decompose_task", (QFilter[])new QFilter("scheme", "=", (Object)schemeId).toArray());
            DeleteServiceHelper.delete((String)"eb_decompose_scheme", (QFilter[])new QFilter("id", "=", (Object)schemeId).or(new QFilter("targetrecord", "=", (Object)recordId)).toArray());
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    protected void refreshData() {
        BillList list = (BillList)this.getControl("billlistap");
        if (list != null) {
            list.clearSelection();
            list.refreshData();
        }
    }

    @Override
    public Long getModelId() {
        DynamicObject model;
        long modelId = 0L;
        String modelIdStr = this.getPageCache().get("KEY_MODEL_ID");
        if (StringUtils.isNotEmpty((CharSequence)modelIdStr)) {
            modelId = Long.parseLong(modelIdStr);
        } else if (this.getModel().getProperty("model") != null && (model = (DynamicObject)this.getModel().getValue("model")) != null) {
            modelId = model.getLong("id");
        }
        return modelId;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
    }

    public void handleData(BasedataFuzzySearchEvent searchEvent) {
        ControlModelFuzzySearchCommon.getInstance().reWriteData(searchEvent);
    }
}

