/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.decompose.plugin.target;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.decompose.service.DataDecomposeService;
import kd.epm.eb.business.target.service.TargetSchemeService;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.decompose.DecDimensionUtil;
import kd.epm.eb.common.decompose.entity.DecomposeSchemeStatus;
import kd.epm.eb.common.decompose.entity.TargetSchemeRecordStatusEnum;
import kd.epm.eb.common.decompose.entity.TaskFirstFlag;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.EpmTreeUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.adminmode.utils.AdminModelUtil;
import kd.epm.eb.model.utils.ModelUtil;

public class TargetSchemeListPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener,
ListRowClickListener,
HyperLinkClickListener {
    public static final String MODEL = "model";
    public static final String BIZ_CTRL = "bizctrl";
    public static final String BIZ_CTRL_LABEL = "bizctrllabel";
    public static final String BTN_ADD = "btnadd";
    public static final String BTN_EDIT = "btnedit";
    public static final String BTN_DEL = "btndel";
    public static final String TOOLBARAP = "toolbarap";
    public static final String DATATYPE = "datatype";
    public static final String BIZ_CTRL_SWITCH = "bizctrlswitch";
    public static final String TARGET_SCHEME = "targetscheme";
    public static final String TARGET_SCHEME_ID = "targetschemeid";
    public static final String TARGET_RECORD = "targetrecord";
    public static final String SCHEME_ISSUED = "schemeissued";
    public static final String CANCEL_ISSUED = "cancelissued";
    public static final String REFRESH = "refresh";
    public static final String TREEVIEWAP = "treeviewap";
    public static final String FOCUS_NODE_ID = "focusnodeid";
    public static final String HEAD_NODE_ID = "headnodeid";
    public static final String TARGET_SCHEME_ADD = "targetschemeadd";
    public static final String TARGET_SCHEME_EDIT = "targetschemeedit";
    public static final String TARGET_RECORD_ADD = "target_record_add";
    public static final String TARGET_RECORD_EDIT = "target_record_edit";
    public static final String TARGET_SCHEME_BILL = "targetschemebill";
    public static final String TARGET_RECORD_BILL = "targetrecordbill";
    public static final String DELETE_SCHEME_CONFIRM = "deletescheme_confirm";
    public static final String DELETE_RECORD_CONFIRM = "deleterecord_confirm";
    public static final String NUMBER = "number";
    public static final String ROOT_ID = "-1";
    public static final String ACCOUNT_TEXT = "accounttext";
    public static final String ENTITY = "entity";
    public static final String TARGET_SCHEME_ACCOUNT_TEXT = "targetscheme_accounttext";
    public static final String DIM_MAPPER = "dimmapper";
    public static final String KEY_SCR_BUSMODEL_ID = "KEY_SCR_BUSMODEL_ID";
    public static final String STATUS = "status";
    public static final String TARGET_DATA = "targetdata";
    public static final String RECORD_EDIT = "record_edit";
    public static final String RECORD_DELETE = "record_delete";

    public void initialize() {
        super.initialize();
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEWAP);
        tree.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                TargetSchemeListPlugin.this.getPageCache().put(TargetSchemeListPlugin.FOCUS_NODE_ID, evt.getNodeId().toString());
                TargetSchemeListPlugin.this.treeOnClick();
                TargetSchemeListPlugin.this.refreshSchemeBill();
            }
        });
        BillList schemeBillList = (BillList)this.getControl(TARGET_SCHEME_BILL);
        schemeBillList.addCreateListDataProviderListener(this::schemeBeforeCreateListDataProvider);
        schemeBillList.addListRowClickListener((ListRowClickListener)this);
        schemeBillList.addHyperClickListener((HyperLinkClickListener)this);
        schemeBillList.addSetFilterListener(this::setSchemeFilter);
        BillList recordBillList = (BillList)this.getControl(TARGET_RECORD_BILL);
        recordBillList.addCreateListDataProviderListener(this::recordBeforeCreateListDataProvider);
        recordBillList.addListRowClickListener((ListRowClickListener)this);
        recordBillList.addHyperClickListener((HyperLinkClickListener)this);
        recordBillList.addSetFilterListener(this::setRecordFilter);
    }

    private void setRecordFilter(SetFilterEvent setFilterEvent) {
        List qFilters = setFilterEvent.getQFilters();
        qFilters.add(this.getRecordFilter());
    }

    private void setSchemeFilter(SetFilterEvent setFilterEvent) {
        List qFilters = setFilterEvent.getQFilters();
        qFilters.add(this.getSchemeFilter());
    }

    private QFilter getSchemeFilter() {
        long modelId = this.getModelId();
        QFilter qModel = new QFilter(MODEL, "=", (Object)modelId);
        qModel.and(new QFilter(BIZ_CTRL, "=", (Object)this.getBizCtrlId()));
        return qModel;
    }

    private QFilter getRecordFilter() {
        long modelId = this.getModelId();
        QFilter qModel = new QFilter(MODEL, "=", (Object)modelId);
        qModel.and(new QFilter(TARGET_SCHEME, "=", (Object)Long.valueOf(this.getCurrentNodeId())));
        return qModel;
    }

    private void treeOnClick() {
        String currentNodeId = this.getCurrentNodeId();
        BillList scheme = (BillList)this.getControl(TARGET_SCHEME_BILL);
        BillList record = (BillList)this.getControl(TARGET_RECORD_BILL);
        if (ROOT_ID.equals(currentNodeId)) {
            this.refreshSchemeBill();
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TARGET_RECORD, CANCEL_ISSUED, SCHEME_ISSUED, RECORD_EDIT, RECORD_DELETE});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{TARGET_SCHEME});
        } else {
            this.refreshRecordBill();
            this.getView().setVisible(Boolean.valueOf(true), new String[]{TARGET_RECORD, CANCEL_ISSUED, SCHEME_ISSUED, RECORD_EDIT, RECORD_DELETE});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TARGET_SCHEME});
        }
        scheme.clearSelection();
        record.clearSelection();
        TreeView control = (TreeView)this.getControl(TREEVIEWAP);
        this.getPageCache().put(FOCUS_NODE_ID, control.getTreeState().getFocusNodeId());
    }

    private void refreshSchemeBill() {
        BillList billList = (BillList)this.getControl(TARGET_SCHEME_BILL);
        billList.refresh();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_ADD, BTN_EDIT, BTN_DEL, BIZ_CTRL_SWITCH, REFRESH});
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(MODEL);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{TOOLBARAP});
    }

    public void afterCreateNewData(EventObject e) {
        Long modelId = UserSelectUtils.getUserSelectModelId((IFormView)this.getView());
        if (IDUtils.isNotNull((Long)modelId)) {
            this.getModel().setValue(MODEL, (Object)modelId);
            this.getPageCache().put(MODEL, modelId.toString());
            this.modelChanged(modelId);
            this.setDefaultBusinessModel();
            this.refreshSchemeBill();
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"TargetSchemeListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getPageCache().put(FOCUS_NODE_ID, ROOT_ID);
        this.initSchemeTree(null, this.getModelId(), this.getBizCtrlId());
        this.getView().setVisible(Boolean.valueOf(false), new String[]{TARGET_RECORD, CANCEL_ISSUED, RECORD_EDIT, RECORD_DELETE});
    }

    public void modelChanged(Long modelId) {
        this.getPageCache().put(MODEL, modelId.toString());
        this.getPageCache().remove(BIZ_CTRL);
        this.setDefaultBusinessModel();
        this.refreshSchemeBill();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{TARGET_RECORD, CANCEL_ISSUED, SCHEME_ISSUED});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{TARGET_SCHEME});
    }

    private void setDefaultBusinessModel() {
        long bizCtrlId = this.getBizCtrlId();
        String name = null;
        if (bizCtrlId == 0L) {
            Object scenarioentry;
            DynamicObject dynamicObject;
            long bizModelId = UserSelectUtils.getUserSelectBusinessModelId((IFormView)this.getView(), (long)this.getModelId());
            boolean needQuery = true;
            if (bizModelId != 0L && (dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)bizModelId, (String)"eb_businessmodel")) != null && (scenarioentry = dynamicObject.get("scenarioentry")) != null) {
                for (DynamicObject object : (DynamicObjectCollection)scenarioentry) {
                    Object o = object.get("appscenario.number");
                    if (!"Target_sys".equals(o)) continue;
                    name = dynamicObject.getString("name");
                    bizCtrlId = bizModelId;
                    needQuery = false;
                    break;
                }
            }
            if (needQuery) {
                String modelId = this.getPageCache().get(MODEL);
                long id = 0L;
                if (StringUtils.isNotEmpty((String)modelId)) {
                    id = Long.parseLong(modelId);
                }
                QFilter modelFilter = new QFilter(MODEL, "=", (Object)id);
                modelFilter.and("scenarioentry.appscenario.number", "=", (Object)"Target_sys");
                String selects = "id,number,name,issyspreset,scenarioentry.appscenario.number,scenarioentry.appscenario.name";
                DynamicObjectCollection businessModelCollection = QueryServiceHelper.query((String)"eb_businessmodel", (String)selects, (QFilter[])new QFilter[]{modelFilter}, (String)"modifydate desc");
                if (CollectionUtils.isEmpty((Collection)businessModelCollection)) {
                    this.getModel().setValue(BIZ_CTRL, (Object)bizCtrlId);
                    this.initSchemeTree(null, Long.valueOf(modelId), bizCtrlId);
                    name = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"TargetSchemeListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    ((Label)this.getControl(BIZ_CTRL_LABEL)).setText(name);
                    return;
                }
                bizCtrlId = ((DynamicObject)businessModelCollection.get(0)).getLong("id");
                UserSelectUtils.saveUserSelectBusinessModelId((IFormView)this.getView(), (long)this.getModelId(), (long)bizCtrlId);
                name = ((DynamicObject)businessModelCollection.get(0)).getString("name");
            }
            this.bizctrlChanged(bizCtrlId);
        }
        this.getModel().setValue(BIZ_CTRL, (Object)bizCtrlId);
        if (!StringUtils.isEmpty(name)) {
            ((Label)this.getControl(BIZ_CTRL_LABEL)).setText(name);
            return;
        }
        this.updateBizModelLabels();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (DELETE_SCHEME_CONFIRM.equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                String currentNodeId = this.getCurrentNodeId();
                long primaryKeyValue = Long.parseLong(currentNodeId);
                DynamicObject scheme = QueryServiceHelper.queryOne((String)"bgm_targetscheme", (String)NUMBER, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)primaryKeyValue)});
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bgm_targetschemerecord", (String)"id,number", (QFilter[])new QFilter[]{new QFilter(TARGET_SCHEME, "=", (Object)primaryKeyValue)});
                if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
                    String message = ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u6709\u4e0b\u8fbe\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"TargetSchemeListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(message);
                    MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u5220\u9664", "TargetSchemeListPlugin_28", "epm-eb-formplugin");
                    MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u7f16\u53f7\u201c%1$s\u201d\u5220\u9664\u5931\u8d25\uff0c%2$s\u3002", "TargetSchemeListPlugin_30", "epm-eb-formplugin");
                    OperationLogUtil.log((String)this.getBizAppId(), (String)"bgm_targetscheme", (String)BTN_DEL, (String)BTN_DEL, (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (String[])new String[]{scheme.getString(NUMBER), message});
                } else {
                    int id = DeleteServiceHelper.delete((String)"bgm_targetscheme", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)primaryKeyValue)});
                    if (id > 0) {
                        HashSet<Long> targetSchemeIds = new HashSet<Long>();
                        targetSchemeIds.add(primaryKeyValue);
                        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"delete", (Object[])new Object[]{MemberQuoteResourceEnum.TargetScheme.getType(), targetSchemeIds});
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"TargetSchemeListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        this.initSchemeTree(null, this.getModelId(), this.getBizCtrlId());
                        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u5220\u9664", "TargetSchemeListPlugin_28", "epm-eb-formplugin");
                        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u7f16\u53f7\uff1a\u201c%1$s\u201d\uff0c\u5220\u9664\u6210\u529f\u3002", "TargetSchemeListPlugin_29", "epm-eb-formplugin");
                        OperationLogUtil.log((String)this.getBizAppId(), (String)"bgm_targetscheme", (String)BTN_DEL, (String)BTN_DEL, (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (String[])new String[]{scheme.getString(NUMBER)});
                    }
                }
            }
        } else if (DELETE_RECORD_CONFIRM.equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                BillList targetRecord = (BillList)this.getControl(TARGET_RECORD_BILL);
                ListSelectedRowCollection schemeRows = targetRecord.getSelectedRows();
                Long primaryKeyValue = (Long)schemeRows.get(0).getPrimaryKeyValue();
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bgm_targetschemerecord", (String)"id,number,status", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)primaryKeyValue)});
                String status = dynamicObject.getString(STATUS);
                if (!TargetSchemeRecordStatusEnum.SAVE.getValue().equals(status)) {
                    String message = ResManager.loadKDString((String)"\u65e0\u6cd5\u5220\u9664\u975e\u6682\u5b58\u72b6\u6001\u7684\u4e0b\u8fbe\u8bb0\u5f55\u3002", (String)"TargetSchemeListPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(message);
                    MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u5220\u9664", "TargetSchemeListPlugin_28", "epm-eb-formplugin");
                    MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u7f16\u53f7\u201c%1$s\u201d\u5220\u9664\u5931\u8d25\uff0c%2$s\u3002", "TargetSchemeListPlugin_30", "epm-eb-formplugin");
                    OperationLogUtil.log((String)this.getBizAppId(), (String)"bgm_targetschemerecord", (String)RECORD_DELETE, (String)RECORD_DELETE, (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (String[])new String[]{dynamicObject.getString(NUMBER), message});
                } else {
                    int id = DeleteServiceHelper.delete((String)"bgm_targetschemerecord", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)primaryKeyValue)});
                    if (id > 0) {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"TargetSchemeListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        targetRecord.clearSelection();
                        this.refreshRecordBill();
                        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u5220\u9664", "TargetSchemeListPlugin_28", "epm-eb-formplugin");
                        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u7f16\u53f7\uff1a\u201c%1$s\u201d\uff0c\u5220\u9664\u6210\u529f\u3002", "TargetSchemeListPlugin_29", "epm-eb-formplugin");
                        OperationLogUtil.log((String)this.getBizAppId(), (String)"bgm_targetschemerecord", (String)RECORD_DELETE, (String)RECORD_DELETE, (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (String[])new String[]{dynamicObject.getString(NUMBER)});
                    }
                }
            }
        } else if (CANCEL_ISSUED.equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.cancelIssued();
        }
    }

    @Override
    public Long getModelId() {
        String modelId = this.getPageCache().get(MODEL);
        if (StringUtils.isEmpty((String)modelId)) {
            return 0L;
        }
        return Long.valueOf(modelId);
    }

    public Long getBizCtrlId() {
        String bizModel = this.getPageCache().get(BIZ_CTRL);
        if (StringUtils.isEmpty((String)bizModel)) {
            return 0L;
        }
        return Long.valueOf(bizModel);
    }

    private void bizctrlChanged(Long bizctrlId) {
        this.getPageCache().put(BIZ_CTRL, bizctrlId.toString());
        this.refreshSchemeBill();
        this.initSchemeTree(null, this.getModelId(), bizctrlId);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{TARGET_RECORD, CANCEL_ISSUED, SCHEME_ISSUED});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{TARGET_SCHEME});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "refresh": {
                this.refreshBill();
                break;
            }
            case "schemeissued": {
                this.schemeIssued();
                break;
            }
            case "dimmapper": {
                this.openDimMapperPage();
                break;
            }
            case "cancelissued": {
                BillList targetRecord = (BillList)this.getControl(TARGET_RECORD_BILL);
                ListSelectedRowCollection recordRows = targetRecord.getSelectedRows();
                if (recordRows.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u884c\u6570\u636e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"TargetSchemeListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (recordRows.size() != 1) break;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u4f1a\u6e05\u7a7a\u76ee\u6807\u627f\u63a5\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u53d6\u6d88\u4e0b\u8fbe\uff1f", (String)"TargetSchemeListPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(itemKey, (IFormPlugin)this));
                break;
            }
            case "targetdata": {
                this.openReportQueryProcessPage();
                break;
            }
            case "record_edit": 
            case "record_delete": {
                this.showRecordEditForm(itemKey);
                break;
            }
        }
    }

    private void showRecordEditForm(String itemKey) {
        BillList targetRecord = (BillList)this.getControl(TARGET_RECORD_BILL);
        ListSelectedRowCollection recordRows = targetRecord.getSelectedRows();
        if (recordRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u884c\u6570\u636e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"TargetSchemeListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (recordRows.size() == 1 && RECORD_EDIT.equals(itemKey)) {
            Long primaryKeyValue = (Long)recordRows.get(0).getPrimaryKeyValue();
            this.showTargetRecordEdit(primaryKeyValue);
            MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4fee\u6539", "TargetSchemeListPlugin_22", "epm-eb-formplugin");
            MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u4fee\u6539\u6210\u529f", "TargetSchemeListPlugin_27", "epm-eb-formplugin");
            OperationLogUtil.log((String)this.getBizAppId(), (String)"bgm_targetschemerecord", (String)RECORD_EDIT, (String)RECORD_EDIT, (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, null);
        } else if (recordRows.size() == 1 && RECORD_DELETE.equals(itemKey)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664\u5df2\u9009\u65b9\u6848\uff1f", (String)"TargetSchemeListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETE_RECORD_CONFIRM, (IFormPlugin)this));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void openReportQueryProcessPage() {
        if (this.validateModelAndBizModel()) {
            BillList targetScheme = (BillList)this.getControl(TARGET_SCHEME_BILL);
            BillList targetRecord = (BillList)this.getControl(TARGET_RECORD_BILL);
            ListSelectedRowCollection schemeRows = targetScheme.getSelectedRows();
            ListSelectedRowCollection recordRows = targetRecord.getSelectedRows();
            Long primaryKeyValue = 0L;
            String targetFlag = "";
            HashMap<String, String> params = new HashMap<String, String>(16);
            if (schemeRows.size() == 0 && recordRows.size() == 0) {
                String currentNodeId = this.getCurrentNodeId();
                if (ROOT_ID.equals(currentNodeId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u884c\u6570\u636e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"TargetSchemeListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                primaryKeyValue = Long.parseLong(currentNodeId);
                targetFlag = "scheme";
            } else if (schemeRows.size() == 1) {
                primaryKeyValue = (Long)schemeRows.get(0).getPrimaryKeyValue();
                targetFlag = "scheme";
            } else if (recordRows.size() == 1) {
                primaryKeyValue = (Long)recordRows.get(0).getPrimaryKeyValue();
                targetFlag = "record";
                DynamicObjectCollection schemes = QueryServiceHelper.query((String)"eb_decompose_scheme", (String)"id,number,model", (QFilter[])new QFilter(TARGET_RECORD, "=", (Object)primaryKeyValue).toArray());
                if (CollectionUtils.isEmpty((Collection)schemes)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u76ee\u6807\u4e0b\u8fbe\u65b9\u6848\u5c1a\u672a\u4e0b\u8fbe\u3002", (String)"TargetSchemeListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                TargetSchemeService instance = TargetSchemeService.getInstance();
                List tarDatasetIds = instance.getMappingDataSetByTargetRecord(primaryKeyValue.longValue());
                params.put("tarDataSets", SerializationUtils.toJsonString((Object)tarDatasetIds));
            }
            if (IDUtils.isNull((Long)primaryKeyValue)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u884c\u6570\u636e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"TargetSchemeListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            params.put("KEY_MODEL_ID", this.getModelId().toString());
            params.put("targetFlag", targetFlag);
            params.put("targetPkId", primaryKeyValue.toString());
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("eb_reportqueryprocess");
            parameter.setCustomParams(params);
            parameter.setCaption(ResManager.loadKDString((String)"\u62a5\u8868\u67e5\u8be2", (String)"TargetSchemeListPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, TARGET_DATA);
            parameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(parameter);
        }
    }

    private void cancelIssued() {
        BillList targetRecord = (BillList)this.getControl(TARGET_RECORD_BILL);
        ListSelectedRowCollection recordRows = targetRecord.getSelectedRows();
        Long primaryKeyValue = (Long)recordRows.get(0).getPrimaryKeyValue();
        DynamicObject targetSchemeRecord = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"bgm_targetschemerecord");
        String number = targetSchemeRecord.getString(NUMBER);
        if (TargetSchemeRecordStatusEnum.ISSUED.getValue().equals(targetSchemeRecord.getString(STATUS))) {
            Long modelId = this.getModelId();
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            QFilter model = new QFilter(MODEL, "=", (Object)modelId);
            QFilter filter = new QFilter(TARGET_RECORD, "=", (Object)primaryKeyValue);
            DynamicObject decomposeScheme = BusinessDataServiceHelper.loadSingle((String)"eb_decompose_scheme", (String)"id, number, name, status", (QFilter[])new QFilter[]{model, filter});
            if (decomposeScheme != null) {
                if (DecomposeSchemeStatus.SAVE.getNumber().equalsIgnoreCase(decomposeScheme.getString(STATUS))) {
                    long schemeId = decomposeScheme.getLong("id");
                    QFilter scheme = new QFilter("scheme", "=", (Object)schemeId);
                    DynamicObject[] tasks = BusinessDataServiceHelper.load((String)"eb_decompose_task", (String)"id, account, srcdimensionjson, firstflag", (QFilter[])new QFilter[]{scheme});
                    ArrayList<Long> taskIds = new ArrayList<Long>(tasks.length);
                    ArrayList<Long> firstTaskIds = new ArrayList<Long>(tasks.length);
                    if (tasks.length > 0) {
                        for (DynamicObject task : tasks) {
                            long taskId = task.getLong("id");
                            if (TaskFirstFlag.FIRST_FLAG.getNumber().equals(task.getString("firstflag"))) {
                                this.delOlapDetail(modelId, modelCache, task);
                                firstTaskIds.add(taskId);
                            }
                            taskIds.add(taskId);
                        }
                        if (CollectionUtils.isEmpty(firstTaskIds)) {
                            for (DynamicObject task : tasks) {
                                this.delOlapDetail(modelId, modelCache, task);
                            }
                        }
                    }
                    DynamicObjectCollection logs = QueryServiceHelper.query((String)"eb_decompose_log", (String)"id", (QFilter[])new QFilter("task", "in", taskIds).toArray());
                    List logIds = logs.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
                    DeleteServiceHelper.delete((String)"eb_decompose_log", (QFilter[])new QFilter("id", "in", logIds).toArray());
                    DeleteServiceHelper.delete((String)"eb_decompose_task", (QFilter[])new QFilter("scheme", "=", (Object)schemeId).toArray());
                    DeleteServiceHelper.delete((String)"eb_decompose_scheme", (QFilter[])new QFilter("id", "=", (Object)schemeId).or(new QFilter(TARGET_RECORD, "=", (Object)primaryKeyValue)).toArray());
                    logIds.addAll(taskIds);
                    DeleteServiceHelper.delete((String)"eb_decomposeadjust", (QFilter[])new QFilter("eb_decomposeadjustsub.decomposetask", "in", logIds).toArray());
                    targetSchemeRecord.set(STATUS, (Object)TargetSchemeRecordStatusEnum.SAVE.getValue());
                    SaveServiceHelper.update((DynamicObject)targetSchemeRecord);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u4e0b\u8fbe\u6210\u529f\u3002", (String)"TargetSchemeListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.refreshRecordBill();
                    MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u53d6\u6d88\u4e0b\u8fbe", "TargetSchemeListPlugin_33", "epm-eb-formplugin");
                    MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u7f16\u53f7\uff1a\u201c%1$s\u201d\uff0c\u53d6\u6d88\u4e0b\u8fbe\u6210\u529f\u3002", "TargetSchemeListPlugin_34", "epm-eb-formplugin");
                    OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), (String)CANCEL_ISSUED, (String)CANCEL_ISSUED, (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (String[])new String[]{number});
                } else {
                    String message = ResManager.loadKDString((String)"\u5206\u89e3\u65b9\u6848\u5df2\u5f00\u59cb\u6267\u884c\uff0c\u65e0\u6cd5\u53d6\u6d88\u3002", (String)"TargetSchemeListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(message);
                    MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u53d6\u6d88\u4e0b\u8fbe", "TargetSchemeListPlugin_33", "epm-eb-formplugin");
                    MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u7f16\u53f7\uff1a\u201c%1$s\u201d\uff0c\u53d6\u6d88\u4e0b\u8fbe\u5931\u8d25\uff0c%2$s\u3002", "TargetSchemeListPlugin_35", "epm-eb-formplugin");
                    OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), (String)CANCEL_ISSUED, (String)CANCEL_ISSUED, (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (String[])new String[]{number, message});
                }
            } else {
                String message = ResManager.loadKDString((String)"\u672a\u627e\u5230\u5206\u89e3\u65b9\u6848\u3002", (String)"TargetSchemeListPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
                MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u53d6\u6d88\u4e0b\u8fbe", "TargetSchemeListPlugin_33", "epm-eb-formplugin");
                MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u7f16\u53f7\uff1a\u201c%1$s\u201d\uff0c\u53d6\u6d88\u4e0b\u8fbe\u5931\u8d25\uff0c%2$s\u3002", "TargetSchemeListPlugin_35", "epm-eb-formplugin");
                OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), (String)CANCEL_ISSUED, (String)CANCEL_ISSUED, (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (String[])new String[]{number, message});
            }
        } else {
            String message = ResManager.loadKDString((String)"\u76ee\u6807\u65b9\u6848\u672a\u4e0b\u8fbe\uff0c\u65e0\u6cd5\u53d6\u6d88\u3002", (String)"TargetSchemeListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u53d6\u6d88\u4e0b\u8fbe", "TargetSchemeListPlugin_33", "epm-eb-formplugin");
            MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u7f16\u53f7\uff1a\u201c%1$s\u201d\uff0c\u53d6\u6d88\u4e0b\u8fbe\u5931\u8d25\uff0c%2$s\u3002", "TargetSchemeListPlugin_35", "epm-eb-formplugin");
            OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), (String)CANCEL_ISSUED, (String)CANCEL_ISSUED, (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (String[])new String[]{number, message});
        }
    }

    private void delOlapDetail(Long modelId, IModelCacheHelper modelCache, DynamicObject task) {
        String srcDimensionJson = task.getString("srcdimensionjson");
        Map memberMap = (Map)JSON.parseObject((String)srcDimensionJson, HashMap.class);
        Long datasetId = DecDimensionUtil.getDatasetId((IModelCacheHelper)modelCache, (Map)memberMap);
        DataDecomposeService instance = DataDecomposeService.getInstance();
        instance.delDetail(modelId.longValue(), datasetId, memberMap);
    }

    private void openDimMapperPage() {
        if (this.validateModelAndBizModel()) {
            HashMap<String, Long> params = new HashMap<String, Long>(16);
            params.put("KEY_MODEL_ID", this.getModelId());
            params.put(KEY_SCR_BUSMODEL_ID, this.getBizCtrlId());
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bgm_targetdimmapperlist");
            parameter.setCustomParams(params);
            parameter.setCaption(ResManager.loadKDString((String)"\u7ef4\u5ea6\u627f\u63a5\u6620\u5c04\u5217\u8868", (String)"TargetSchemeListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, DIM_MAPPER);
            parameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(parameter);
        }
    }

    public String getModelCustomKey() {
        return "KEY_MODEL_ID";
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (MODEL.equals(key)) {
            DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
            if (model != null) {
                Long modelId = model.getLong("id");
                UserSelectUtils.saveUserSelectModelId((IFormView)this.getView(), (long)modelId);
                this.modelChanged(modelId);
            } else {
                this.getPageCache().put(MODEL, null);
                this.getModel().setValue(BIZ_CTRL, (Object)0L);
                TreeView tree = (TreeView)this.getControl(TREEVIEWAP);
                tree.deleteAllNodes();
                TreeNode root = new TreeNode();
                root.setId(ROOT_ID);
                root.setParentid("");
                root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"TargetSchemeListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                tree.addNode(root);
                String name = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"TargetSchemeListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                ((Label)this.getControl(BIZ_CTRL_LABEL)).setText(name);
                this.refreshSchemeBill();
                this.refreshRecordBill();
                this.getView().setVisible(Boolean.valueOf(false), new String[]{TARGET_RECORD, CANCEL_ISSUED, SCHEME_ISSUED, RECORD_EDIT, RECORD_DELETE});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{TARGET_SCHEME});
            }
        } else if (BIZ_CTRL.equals(key)) {
            DynamicObject bizctrl = (DynamicObject)this.getModel().getValue(BIZ_CTRL);
            if (bizctrl != null) {
                long bizctrlId = bizctrl.getLong("id");
                UserSelectUtils.saveUserSelectBusinessModelId((IFormView)this.getView(), (long)this.getModelId(), (long)bizctrlId);
                this.bizctrlChanged(bizctrlId);
            } else {
                this.getPageCache().put(BIZ_CTRL, null);
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey()) {
            case "btnadd": 
            case "btnedit": {
                this.showSchemeEditForm(key);
                break;
            }
            case "btndel": {
                this.deleteData();
                break;
            }
            case "bizctrlswitch": {
                BasedataEdit clickModel = (BasedataEdit)this.getView().getControl(BIZ_CTRL);
                clickModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
                clickModel.click();
                break;
            }
        }
    }

    private void showSchemeEditForm(String key) {
        if (this.validateModelAndBizModel()) {
            this.showTargetScheme(key);
        }
    }

    private void showTargetRecordEdit(Long primaryKeyValue) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put(MODEL, this.getPageCache().get(MODEL));
        params.put("businessmodel", this.getPageCache().get(BIZ_CTRL));
        params.put("pkId", primaryKeyValue);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, TARGET_RECORD_EDIT);
        this.showForm(params, closeCallBack, primaryKeyValue, "bgm_targetschemerecord");
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRow currentClickRow = evt.getCurrentListSelectedRow();
        String value = currentClickRow == null ? null : String.valueOf(currentClickRow.getPrimaryKeyValue());
        this.getPageCache().put("currentClickRowEntryKey", value);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
            return;
        }
        super.hyperLinkClick(hyperLinkClickEvent);
        String column = hyperLinkClickEvent.getFieldName();
        String rowId = this.getPageCache().get("currentClickRowEntryKey");
        if (StringUtils.isEmpty((String)rowId)) {
            return;
        }
        BillList targetScheme = (BillList)this.getControl(TARGET_SCHEME_BILL);
        BillList targetRecord = (BillList)this.getControl(TARGET_RECORD_BILL);
        ListSelectedRowCollection schemeRows = targetScheme.getSelectedRows();
        ListSelectedRowCollection recordRows = targetRecord.getSelectedRows();
        if (ACCOUNT_TEXT.equals(column)) {
            this.showAccountsForm(column, rowId);
        } else if (ENTITY.equals(column)) {
            this.showEntityForm(rowId);
        } else if (TARGET_SCHEME_ACCOUNT_TEXT.equals(column)) {
            this.showAccountsForm(column, rowId);
        } else if (NUMBER.equals(column)) {
            if (!CollectionUtils.isEmpty((Collection)schemeRows)) {
                this.showSchemeForm(rowId);
            } else if (!CollectionUtils.isEmpty((Collection)recordRows)) {
                this.showRecordForm(rowId);
            }
        }
    }

    private void showRecordForm(String rowId) {
        Long pkId = Long.valueOf(rowId);
        HashMap<String, String> openParameter = new HashMap<String, String>(16);
        openParameter.put("formId", "bgm_targetschemerecord");
        openParameter.put("pkId", rowId);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bgm_targetschemerecord", (String)"id,targetscheme,status", (QFilter[])new QFilter("id", "=", (Object)pkId).toArray());
        if (dynamicObject == null) {
            return;
        }
        DynamicObject targetscheme = (DynamicObject)dynamicObject.get(TARGET_SCHEME);
        BaseShowParameter showParameter = (BaseShowParameter)FormShowParameter.createFormShowParameter(openParameter);
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("businessmodel", String.valueOf(this.getBizCtrlId()));
        customParams.put("pkId", pkId);
        customParams.put(MODEL, String.valueOf(this.getModelId()));
        customParams.put(TARGET_SCHEME_ID, targetscheme.getLong("id"));
        showParameter.setCustomParams(customParams);
        String status = dynamicObject.getString(STATUS);
        if (TargetSchemeRecordStatusEnum.ISSUED.getValue().equals(status)) {
            showParameter.setStatus(OperationStatus.VIEW);
        } else {
            showParameter.setStatus(OperationStatus.EDIT);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, TARGET_RECORD_EDIT);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showSchemeForm(String rowId) {
        HashMap<String, String> openParameter = new HashMap<String, String>(16);
        openParameter.put("formId", "bgm_targetscheme");
        openParameter.put("pkId", rowId);
        BaseShowParameter showParameter = (BaseShowParameter)FormShowParameter.createFormShowParameter(openParameter);
        DynamicObjectCollection records = QueryServiceHelper.query((String)"bgm_targetschemerecord", (String)"id,number", (QFilter[])new QFilter(TARGET_SCHEME, "=", (Object)Long.parseLong(rowId)).toArray());
        if (!CollectionUtils.isEmpty((Collection)records)) {
            showParameter.setStatus(OperationStatus.VIEW);
        } else {
            showParameter.setStatus(OperationStatus.EDIT);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, TARGET_SCHEME_EDIT);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showEntityForm(String rowId) {
        QFilter qfRowId = new QFilter("id", "=", (Object)IDUtils.toLong((Object)rowId));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bgm_targetschemerecord", (String)"id,entity,entityview", (QFilter[])new QFilter[]{qfRowId});
        if (dynamicObject == null) {
            return;
        }
        ArrayList<String> entities = new ArrayList<String>(10);
        String entity = dynamicObject.getString(ENTITY);
        if (!StringUtils.isEmpty((String)entity)) {
            String[] split = entity.split(",");
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
            Long view = null;
            if (dynamicObject.get("entityview") != null && dynamicObject.getLong("entityview") != 0L) {
                view = dynamicObject.getLong("entityview");
            } else {
                String[] viewIds = BusinessModelServiceHelper.getViewIds((Long)this.getBizCtrlId(), (boolean)false);
                view = (Long)viewIds.get("Entity");
            }
            for (String s : split) {
                Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), view, s);
                if (member == null) continue;
                entities.add(String.valueOf(member.getId()));
            }
            FormShowParameter formShow = new FormShowParameter();
            if (view != null && view != 0L) {
                formShow.setCustomParam("viewId", (Object)view);
            }
            formShow.setCustomParam("orgIds", entities);
            formShow.setCustomParam("modelId", (Object)this.getModelId());
            formShow.setFormId("eb_ruleallotorginfo");
            String caption = ResManager.loadKDString((String)"\u76ee\u6807\u4e0b\u8fbe\u7ec4\u7ec7\u8be6\u60c5", (String)"TargetSchemeListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            formShow.setCaption(caption);
            formShow.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(formShow);
        }
    }

    private void showAccountsForm(String column, String rowId) {
        String accountId;
        QFilter qfRowId = new QFilter("id", "=", (Object)IDUtils.toLong((Object)rowId));
        DynamicObject dynamicObject = ACCOUNT_TEXT.equals(column) ? QueryServiceHelper.queryOne((String)"bgm_targetscheme", (String)"id,account,accounttext", (QFilter[])new QFilter[]{qfRowId}) : (TARGET_SCHEME_ACCOUNT_TEXT.equals(column) ? QueryServiceHelper.queryOne((String)"bgm_targetschemerecord", (String)"id,targetscheme.account as account", (QFilter[])new QFilter[]{qfRowId}) : new DynamicObject());
        ArrayList<String> accountIds = new ArrayList<String>(10);
        String string = accountId = dynamicObject == null ? "" : dynamicObject.getString("account");
        if (!StringUtils.isEmpty((String)accountId)) {
            String[] split = accountId.split(",");
            accountIds.addAll(Arrays.asList(split));
            FormShowParameter formShow = new FormShowParameter();
            formShow.setCustomParam("accountIds", accountIds);
            formShow.setCustomParam("modelId", (Object)this.getModelId());
            formShow.setFormId("eb_controlruleaccounts");
            String caption = ResManager.loadKDString((String)"\u76ee\u6807\u4e0b\u8fbe\u65b9\u6848\u79d1\u76ee\u8be6\u60c5", (String)"TargetSchemeListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            if (TARGET_SCHEME_ACCOUNT_TEXT.equals(column)) {
                caption = ResManager.loadKDString((String)"\u76ee\u6807\u4e0b\u8fbe\u8bb0\u5f55\u79d1\u76ee\u8be6\u60c5", (String)"TargetSchemeListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
            formShow.setCaption(caption);
            formShow.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(formShow);
        }
    }

    private void schemeIssued() {
        String currentNodeId = this.getCurrentNodeId();
        if (!StringUtils.equals((String)ROOT_ID, (String)currentNodeId)) {
            this.showTargetRecord(Long.valueOf(currentNodeId));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u884c\u6570\u636e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"TargetSchemeListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void showTargetRecord(Long primaryKeyValue) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put(MODEL, this.getPageCache().get(MODEL));
        params.put("businessmodel", this.getPageCache().get(BIZ_CTRL));
        params.put(TARGET_SCHEME_ID, primaryKeyValue);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, TARGET_RECORD_ADD);
        this.showForm(params, closeCallBack, 0L, "bgm_targetschemerecord");
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u65b9\u6848\u4e0b\u8fbe", "TargetSchemeListPlugin_31", "epm-eb-formplugin");
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u65b9\u6848\u4e0b\u8fbe\u6210\u529f", "TargetSchemeListPlugin_32", "epm-eb-formplugin");
        OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), (String)SCHEME_ISSUED, (String)SCHEME_ISSUED, (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, null);
    }

    private void refreshBill() {
        Long modelId = this.getModelId();
        if (modelId == 0L) {
            return;
        }
        String currentNodeId = this.getCurrentNodeId();
        if (ROOT_ID.equals(currentNodeId)) {
            this.refreshSchemeBill();
        } else {
            this.refreshRecordBill();
        }
        this.initSchemeTree(null, this.getModelId(), this.getBizCtrlId());
    }

    private void focusNode(TreeNode root) {
        String foursId = this.getPageCache().get(FOCUS_NODE_ID);
        TreeView treeView = (TreeView)this.getControl(TREEVIEWAP);
        TreeNode focusNodeById = this.findFocusNodeById(foursId, root);
        if (focusNodeById != null) {
            treeView.focusNode(focusNodeById);
        }
    }

    private TreeNode findFocusNodeById(String id, TreeNode tree) {
        if (StringUtils.isEmpty((String)id) || tree == null) {
            return null;
        }
        if (id.equals(tree.getId())) {
            return tree;
        }
        if (tree.getChildren() != null) {
            for (TreeNode c : tree.getChildren()) {
                TreeNode fc = this.findFocusNodeById(id, c);
                if (fc == null) continue;
                return fc;
            }
        }
        return null;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        Long returnData;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (BIZ_CTRL.equals(actionId)) {
            String id = (String)e.getReturnData();
            if (StringUtils.isEmpty((String)id)) {
                return;
            }
            QFilter qFilter = new QFilter("id", "=", (Object)Long.valueOf(id));
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_businessmodel", (String)"id,name,number", (QFilter[])new QFilter[]{qFilter});
            ((Label)this.getControl(BIZ_CTRL_LABEL)).setText(dynamicObject.getString("name"));
            this.getModel().setValue(BIZ_CTRL, (Object)dynamicObject.getString("id"));
        } else if (TARGET_SCHEME_ADD.equals(actionId) && (returnData = (Long)e.getReturnData()) != null) {
            this.initSchemeTree(String.valueOf(returnData), this.getModelId(), this.getBizCtrlId());
            BillList billList = (BillList)this.getControl(TARGET_SCHEME_BILL);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            int index = 0;
            for (int i = 0; i < selectedRows.size(); ++i) {
                if (!selectedRows.get(i).getPrimaryKeyValue().equals(returnData)) continue;
                index = i;
                break;
            }
            billList.selectRows(index);
        }
        this.refreshBill();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        if (BIZ_CTRL.equals(key)) {
            beforeF7SelectEvent.setCancel(true);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("eb_bizmodelselect");
            formShowParameter.setCustomParam("appNumber", (Object)"targetSchemeBizmodelSelect");
            formShowParameter.setCustomParam(MODEL, (Object)String.valueOf(this.getModelId()));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BIZ_CTRL);
            formShowParameter.setCloseCallBack(closeCallBack);
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(formShowParameter);
        } else if (MODEL.equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList qFilterList = ((BasedataEdit)this.getControl(MODEL)).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList(10);
            }
            qFilterList.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    private void deleteData() {
        if (this.validateModelAndBizModel()) {
            String currentNodeId = this.getCurrentNodeId();
            if (ROOT_ID.equals(currentNodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u884c\u6570\u636e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"TargetSchemeListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664\u5df2\u9009\u65b9\u6848\uff1f", (String)"TargetSchemeListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETE_SCHEME_CONFIRM, (IFormPlugin)this));
            }
        }
    }

    private boolean validateModelAndBizModel() {
        Long modelId = this.getModelId();
        if (modelId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"TargetSchemeListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Long bizCtrlId = this.getBizCtrlId();
        if (bizCtrlId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"TargetSchemeListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return true;
    }

    private void updateBizModelLabels() {
        String modelName = ((DynamicObject)this.getModel().getValue(BIZ_CTRL)).getString("name");
        ((Label)this.getControl(BIZ_CTRL_LABEL)).setText(modelName);
    }

    private void showTargetScheme(String key) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put(MODEL, this.getPageCache().get(MODEL));
        params.put(BIZ_CTRL, this.getPageCache().get(BIZ_CTRL));
        if (BTN_ADD.equals(key)) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, TARGET_SCHEME_ADD);
            this.showForm(params, closeCallBack, 0L, "bgm_targetscheme");
            MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u65b0\u589e", "TargetSchemeListPlugin_25", "epm-eb-formplugin");
            MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u65b0\u589e\u6210\u529f", "TargetSchemeListPlugin_26", "epm-eb-formplugin");
            OperationLogUtil.log((String)this.getBizAppId(), (String)"bgm_targetscheme", (String)BTN_ADD, (String)BTN_ADD, (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, null);
        } else if (BTN_EDIT.equals(key)) {
            String currentNodeId = this.getCurrentNodeId();
            if (ROOT_ID.equals(currentNodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u884c\u6570\u636e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"TargetSchemeListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, TARGET_SCHEME_EDIT);
                long primaryKeyValue = Long.parseLong(currentNodeId);
                this.showForm(params, closeCallBack, primaryKeyValue, "bgm_targetscheme");
                MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4fee\u6539", "TargetSchemeListPlugin_22", "epm-eb-formplugin");
                MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u4fee\u6539\u6210\u529f", "TargetSchemeListPlugin_27", "epm-eb-formplugin");
                OperationLogUtil.log((String)this.getBizAppId(), (String)"bgm_targetscheme", (String)BTN_EDIT, (String)BTN_EDIT, (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, null);
            }
        }
    }

    private void showForm(Map<String, Object> params, CloseCallBack closeCallBack, long id, String formId) {
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId(formId);
        if (id != 0L) {
            param.setPkId((Object)id);
            if ("bgm_targetscheme".equals(formId)) {
                DynamicObjectCollection records = QueryServiceHelper.query((String)"bgm_targetschemerecord", (String)"id,number", (QFilter[])new QFilter(TARGET_SCHEME, "=", (Object)id).toArray());
                if (!CollectionUtils.isEmpty((Collection)records)) {
                    param.setStatus(OperationStatus.VIEW);
                } else {
                    param.setStatus(OperationStatus.EDIT);
                }
            } else if ("bgm_targetschemerecord".equals(formId)) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bgm_targetschemerecord", (String)"id,targetscheme,status", (QFilter[])new QFilter("id", "=", (Object)id).toArray());
                String status = dynamicObject.getString(STATUS);
                if (TargetSchemeRecordStatusEnum.ISSUED.getValue().equals(status)) {
                    param.setStatus(OperationStatus.VIEW);
                } else {
                    param.setStatus(OperationStatus.EDIT);
                }
            }
        }
        if (params.size() > 0) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm((FormShowParameter)param);
    }

    private void refreshRecordBill() {
        BillList billList = (BillList)this.getControl(TARGET_RECORD_BILL);
        billList.refresh();
    }

    private void recordBeforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                int billDataCount = this.getBillDataCount();
                DynamicObjectCollection dynamicObjects = super.getData(start, limit);
                if (TargetSchemeListPlugin.this.getModelId() == 0L) {
                    return super.getData(start, limit);
                }
                IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)TargetSchemeListPlugin.this.getModelId());
                Map viewIds = BusinessModelServiceHelper.getViewIds((Long)TargetSchemeListPlugin.this.getBizCtrlId(), (boolean)false);
                Long view = (Long)viewIds.get("Entity");
                for (DynamicObject datum : dynamicObjects) {
                    String entity = datum.getString(TargetSchemeListPlugin.ENTITY);
                    String[] split = entity.split(",");
                    ArrayList<String> names = new ArrayList<String>(10);
                    for (String s : split) {
                        Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), view, s);
                        if (member == null) {
                            member = modelCacheHelper.getMemberByAnyView(TargetSchemeListPlugin.this.getBizCtrlId(), SysDimensionEnum.Entity.getNumber(), s);
                        }
                        if (member == null) continue;
                        names.add(member.getName());
                    }
                    datum.set(TargetSchemeListPlugin.ENTITY, (Object)String.join((CharSequence)",", names));
                }
                this.getQueryResult().setDataCount(billDataCount);
                TargetSchemeListPlugin.this.setCountCache("recordCount", billDataCount);
                return dynamicObjects;
            }

            public int getRealCount() {
                return TargetSchemeListPlugin.this.getCountCache("recordCount");
            }
        });
    }

    private void schemeBeforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                int billDataCount = this.getBillDataCount();
                DynamicObjectCollection dynamicObjects = super.getData(start, limit);
                this.getQueryResult().setDataCount(billDataCount);
                TargetSchemeListPlugin.this.setCountCache("schemeCount", billDataCount);
                return dynamicObjects;
            }

            public int getRealCount() {
                return TargetSchemeListPlugin.this.getCountCache("schemeCount");
            }
        });
    }

    private void setCountCache(String key, int count) {
        String countCache = null;
        if (count != -1) {
            countCache = String.valueOf(count);
        }
        this.getPageCache().put(key, countCache);
    }

    private int getCountCache(String key) {
        String count = this.getPageCache().get(key);
        if (StringUtils.isEmpty((String)count)) {
            return -1;
        }
        return Integer.parseInt(count);
    }

    private String getCurrentNodeId() {
        TreeView treeView = (TreeView)this.getControl(TREEVIEWAP);
        String nodeId = treeView.getTreeState().getFocusNodeId();
        if (nodeId == null) {
            return ROOT_ID;
        }
        return nodeId;
    }

    private void initSchemeTree(String newId, Long modelId, Long bizctrlId) {
        String rootId = ROOT_ID;
        if (modelId != 0L) {
            TreeNode root = new TreeNode();
            root.setId(rootId);
            root.setParentid("");
            root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"TargetSchemeListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            HashMap dataMap = new HashMap(16);
            root.setData(dataMap);
            QFBuilder qb = new QFBuilder();
            qb.add(new QFilter(MODEL, "=", (Object)modelId));
            qb.add(new QFilter(BIZ_CTRL, "=", (Object)bizctrlId));
            DynamicObjectCollection targetSchemes = QueryServiceHelper.query((String)"bgm_targetscheme", (String)"id,number,name,createdate", (QFilter[])qb.toArrays(), (String)"createdate asc");
            ArrayList<Map<String, String>> treeList = new ArrayList<Map<String, String>>(10);
            if (!targetSchemes.isEmpty()) {
                for (DynamicObject targetScheme : targetSchemes) {
                    Map<String, String> memberMap = this.createMemberMap(targetScheme);
                    treeList.add(memberMap);
                }
                treeList.sort(Comparator.comparing(t -> (String)t.get("createdate")));
                this.setEntryNode(root, treeList, rootId);
                EpmTreeUtils.spreadAllNode((TreeNode)root);
                this.setTreeCache(root);
                this.getPageCache().put(HEAD_NODE_ID, rootId);
                TreeView tree = (TreeView)this.getControl(TREEVIEWAP);
                tree.deleteAllNodes();
                tree.addNode(root);
                if (newId != null) {
                    TreeNode newNode = root.getTreeNode(newId, 20);
                    if (newNode != null) {
                        tree.focusNode(newNode);
                        this.getPageCache().put(FOCUS_NODE_ID, tree.getTreeState().getFocusNodeId());
                        tree.treeNodeClick("", newNode.getId());
                    }
                } else {
                    this.focusNode(root);
                }
            } else {
                TreeView tree = (TreeView)this.getControl(TREEVIEWAP);
                tree.deleteAllNodes();
                tree.addNode(root);
            }
            this.refreshSchemeBill();
        }
    }

    private Map<String, String> createMemberMap(DynamicObject dynamicObject) {
        HashMap<String, String> memberMap = new HashMap<String, String>(16);
        if (dynamicObject != null) {
            memberMap.put("id", dynamicObject.getString("id"));
            memberMap.put(NUMBER, dynamicObject.getString(NUMBER));
            memberMap.put("name", dynamicObject.getString("name"));
            String createdate = dynamicObject.getString("createdate");
            if (createdate == null) {
                createdate = TimeServiceHelper.now().toString();
            }
            memberMap.put("createdate", createdate);
        }
        return memberMap;
    }

    private void setEntryNode(TreeNode root, List<Map<String, String>> rootNodeList, String headId) {
        HashMap<String, List<Map<String, String>>> nodeMap = new HashMap<String, List<Map<String, String>>>(16);
        nodeMap.put(headId, rootNodeList);
        this.createNode(root, nodeMap, headId);
    }

    private void setTreeCache(TreeNode root) {
        this.getPageCache().put("treelist", SerializationUtils.serializeToBase64((Object)root));
    }

    private void createNode(TreeNode root, Map<String, List<Map<String, String>>> nodeMap, String headId) {
        List<Map<String, String>> list = nodeMap.get(headId);
        if (list != null) {
            ArrayList<TreeNode> children = root.getChildren();
            if (children == null) {
                children = new ArrayList<TreeNode>(10);
                root.setChildren(children);
            }
            for (Map<String, String> map : list) {
                HashMap dataMap = new HashMap(16);
                TreeNode entry = new TreeNode();
                entry.setParentid(headId);
                entry.setId(map.get("id"));
                entry.setText(map.get("name"));
                entry.setData(dataMap);
                String entryHeadId = map.get("id");
                this.createNode(entry, nodeMap, entryHeadId);
                children.add(entry);
            }
        }
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        AdminModelUtil.checkAdminModeBeforeItemClick(evt, this.getModelId(), this.getView(), Sets.newHashSet((Object[])new String[]{"exit"}));
    }

    @Override
    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        AdminModelUtil.checkAdminModeBeforeClick(evt, this.getModelId(), this.getView());
    }
}

