/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.decompose.plugin.target;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.target.entity.TargetSchemeDimMapper;
import kd.epm.eb.business.target.service.TargetSchemeService;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.decompose.entity.TargetSchemeRecordStatusEnum;
import kd.epm.eb.common.entity.memberF7.LeftTreeF7Parameter;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.MemberF7.ParameterF7Builder;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;

public class TargetSchemeRecordAddPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener,
TreeNodeClickListener,
TreeNodeCheckListener {
    public static final String TARGET_SCHEME = "targetscheme";
    public static final String BIZCTRL = "bizctrl";
    public static final String DATATYPE = "datatype";
    public static final String VERSION = "version";
    public static final String AUDITTRAIL = "audittrail";
    public static final String TOOLBARAP = "toolbarap";
    public static final String ISSUED = "issued";
    public static final String REFRESH = "refresh";
    public static final String TREE_LEFT = "treeleft";
    public static final String TREE_RIGHT = "treeright";
    public static final String MODEL = "model";
    public static final String LEFT_TREE_CACHE = "lefttreecache";
    public static final String RIGHT_TREE_CACHE = "righttreecache";
    public static final String L_LIST = "llist";
    public static final String L_FOCUS = "lfocus";
    public static final String L_OLD_NODE_CACHE = "loldnode";
    public static final String R_LIST = "rlist";
    public static final String R_FOCUS = "rfocus";
    public static final String R_OLD_NODE_CACHE = "roldnode";
    public static final int MAX_LEVEL = 20;
    public static final String GET_LOOK_UP_LIST = "getLookUpList";
    public static final String CLICK = "click";
    public static final String ID = "id";
    public static final String TARGET_SCHEME_MESSAGE = "targetSchemeMessage";
    public static final String TARGET_SCHEME_ISSUED_CONFIRM = "targetSchemeIssuedConfirm";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, new String[]{BIZCTRL, DATATYPE, VERSION, AUDITTRAIL, TARGET_SCHEME, "entityview"});
        this.addClickListeners(new String[]{ISSUED, "save"});
        TreeView treeLeft = (TreeView)this.getView().getControl(TREE_LEFT);
        TreeView treeRight = (TreeView)this.getView().getControl(TREE_RIGHT);
        treeLeft.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        treeRight.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"btngo", "btnallgo", "btnback", "btnallback"});
        this.addClickListeners(new String[]{"allexpand", "allshrink"});
        this.addClickListeners(new String[]{"searchbefore", "searchnext", "searchbefore1", "searchnext1"});
        IPageCache pageCache = this.getPageCache();
        IFormView view = this.getView();
        Search sl = (Search)this.getControl("searchapleft");
        sl.addEnterListener(event -> TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), view, pageCache, new TreeSearchUtil.TreeSearchParam(TREE_LEFT, LEFT_TREE_CACHE, L_LIST, L_FOCUS, L_OLD_NODE_CACHE)));
        Search sr = (Search)this.getControl("searchapright");
        sr.addEnterListener(event -> TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), view, pageCache, new TreeSearchUtil.TreeSearchParam(TREE_RIGHT, RIGHT_TREE_CACHE, R_LIST, R_FOCUS, R_OLD_NODE_CACHE)));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.cacheSchemeInfo();
        this.fillSchemeInfo();
        this.initRightTree();
        this.initLeftTree();
        this.getView().setEnable(Boolean.valueOf(false), new String[]{TARGET_SCHEME, "businessmodel", "number"});
    }

    private void initRightTree() {
        TreeView rightTree = (TreeView)this.getControl(TREE_RIGHT);
        rightTree.deleteAllNodes();
        TreeNode root = this.getRightRoot();
        this.cacheRightRoot(root);
        rightTree.addNode(root);
        rightTree.expand(root.getId());
    }

    protected void cacheRightRoot(TreeNode rootRight) {
        Queue<TreeNode> queue = TreeSearchUtil.getQueue(rootRight);
        HashMap<String, String> textMap = new HashMap<String, String>(16);
        while (!queue.isEmpty()) {
            TreeNode node = queue.poll();
            if (StringUtils.equals((String)node.getId(), (String)rootRight.getId())) continue;
            textMap.put(node.getId(), node.getText());
            List children = node.getChildren();
            if (children == null) continue;
            for (TreeNode child : children) {
                child.setParentid(node.getId());
                textMap.put(child.getId(), child.getText());
            }
        }
        this.getPageCache().put(RIGHT_TREE_CACHE, SerializationUtils.toJsonString((Object)rootRight));
        this.getPageCache().put("rightTreeNodeIds", ObjectSerialUtil.toByteSerialized(textMap));
    }

    protected TreeNode getRightRoot() {
        TreeNode rightTreeNode = new TreeNode();
        TreeNode leftTreeNode = this.getCacheLeftRoot();
        rightTreeNode.setId("-1");
        rightTreeNode.setText(ResManager.loadKDString((String)"\u5df2\u5206\u914d\u7ec4\u7ec7", (String)"TargetSchemeRecordAddPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        rightTreeNode.setData(new HashMap(16));
        String entity = (String)this.getModel().getValue("entity");
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        if (!StringUtils.isEmpty((String)entity)) {
            String[] split;
            for (String s : split = entity.split(",")) {
                TreeNode treeNode;
                Member member = modelCacheHelper.getMemberByAnyView(SysDimensionEnum.Entity.getNumber(), s);
                List children = leftTreeNode.getChildren();
                if (CollectionUtils.isEmpty((Collection)children) || (treeNode = this.getCheckedNode(children, member.getNumber())) == null) continue;
                rightTreeNode.addChild(this.copyTreeNode(treeNode));
            }
        }
        return rightTreeNode;
    }

    private TreeNode getCheckedNode(List<TreeNode> children, String number) {
        for (TreeNode child : children) {
            TreeNode checkedNode;
            Map tempMap = (Map)child.getData();
            if (tempMap == null) continue;
            String tempNumber = (String)tempMap.get("number");
            if (StringUtils.equals((String)number, (String)tempNumber)) {
                return child;
            }
            if (CollectionUtils.isEmpty((Collection)child.getChildren()) || (checkedNode = this.getCheckedNode(child.getChildren(), number)) == null) continue;
            return checkedNode;
        }
        return null;
    }

    private void initLeftTree() {
        TreeView leftTree = (TreeView)this.getControl(TREE_LEFT);
        TreeNode root = this.getLeftRoot();
        leftTree.deleteAllNodes();
        this.cacheLeftRoot(root);
        leftTree.addNode(root);
        leftTree.expand(root.getId());
        TreeSearchUtil.clearSearchPageCache(this.getPageCache(), new TreeSearchUtil.TreeSearchParam(TREE_LEFT, LEFT_TREE_CACHE));
    }

    protected void cacheLeftRoot(TreeNode rootLeft) {
        this.getPageCache().put(LEFT_TREE_CACHE, SerializationUtils.toJsonString((Object)rootLeft));
    }

    protected TreeNode getLeftRoot() {
        TreeNode memberTree = new TreeNode();
        Long modelID = Long.valueOf(this.getCacheModelId(MODEL).toString());
        QFilter qFilter = new QFilter(MODEL, "=", (Object)modelID);
        qFilter.and("membersource", "!=", (Object)MemberSourceEnum.ANALYZE_VIEW.getIndex());
        String memberKey = "epm_entitymembertree";
        Long viewId = null;
        if (this.getModel().getValue("entityview") != null) {
            viewId = ((DynamicObject)this.getModel().getValue("entityview")).getLong(ID);
        }
        if (viewId != null) {
            qFilter.and("view", "=", viewId);
            memberKey = "eb_viewmember";
        } else {
            qFilter.and("isexchangerate", "!=", (Object)"1");
        }
        DynamicObjectCollection org = QueryServiceHelper.query((String)memberKey, (String)"id,number,name,parent", (QFilter[])new QFilter[]{qFilter}, (String)"level,number");
        if (org == null || org.isEmpty()) {
            return memberTree;
        }
        HashMap<String, String> treeRootNode = new HashMap<String, String>(16);
        treeRootNode.put(ID, ((DynamicObject)org.get(0)).getString(ID));
        treeRootNode.put("number", ((DynamicObject)org.get(0)).getString("number"));
        treeRootNode.put("name", ((DynamicObject)org.get(0)).getString("name"));
        this.getPageCache().put("treeRootNode", ObjectSerialUtil.toByteSerialized(treeRootNode));
        String rootID = ((DynamicObject)org.get(0)).getString(ID);
        memberTree.setId(rootID);
        memberTree.setText(((DynamicObject)org.get(0)).getString("name"));
        org.remove(0);
        Set noPermMembIds = DimMembPermHelper.getReadPermMembIds((String)SysDimensionEnum.Entity.getNumber(), (Long)modelID, (Long)this.getCacheModelId("businessmodel"), (Long)(viewId != null ? IDUtils.toLong((Object)viewId) : null), (boolean)false);
        if (noPermMembIds != null) {
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelID);
            List views = modelCache.getViewGroupViewsByBusModelAndDimNumber(this.getCacheModelId("businessmodel"), SysDimensionEnum.Entity.getNumber());
            for (Long l : views) {
                Set noPerms;
                if (l.equals(IDUtils.toLong((Object)viewId)) || (noPerms = DimMembPermHelper.getReadPermMembIds((String)SysDimensionEnum.Entity.getNumber(), (Long)modelID, (Long)this.getCacheModelId("businessmodel"), (Long)l, (boolean)false)) == null || noPerms.isEmpty()) continue;
                noPermMembIds.addAll(noPerms);
            }
        }
        List<Map<String, String>> memberList = this.getMemberList(org, noPermMembIds, rootID);
        HashMap<String, List<Map<String, String>>> memberMap = new HashMap<String, List<Map<String, String>>>(16);
        for (Map map : memberList) {
            memberMap.computeIfAbsent((String)map.get("parentid"), (Function<String, List<Map<String, String>>>)((Function<String, List>)f -> new ArrayList(16))).add(map);
        }
        this.setEntryNode(memberTree, memberMap, rootID);
        return memberTree;
    }

    public TreeNode setEntryNode(TreeNode root, Map<String, List<Map<String, String>>> memberMap, String headId) {
        List<Map<String, String>> rootNodeList = memberMap.get(headId);
        if (rootNodeList != null) {
            for (Map<String, String> map : rootNodeList) {
                if (!map.get("parentid").equals(headId)) continue;
                TreeNode entry = new TreeNode();
                entry.setParentid(headId);
                entry.setId(map.get(ID));
                entry.setText(map.get("name"));
                String entryHeadId = map.get(ID);
                map.put("isNew", "1");
                entry.setData(map);
                this.setEntryNode(entry, memberMap, entryHeadId);
                ArrayList<TreeNode> children = root.getChildren();
                if (children == null) {
                    children = new ArrayList<TreeNode>(10);
                    root.setChildren(children);
                }
                children.add(entry);
            }
        }
        return root;
    }

    private List<Map<String, String>> getMemberList(DynamicObjectCollection dcs, Set<Long> noPermMembId, String rootId) {
        ArrayList<Map<String, String>> memberList = new ArrayList<Map<String, String>>(10);
        if (noPermMembId == null) {
            noPermMembId = new HashSet<Long>(10);
        }
        if (dcs != null && dcs.size() > 0) {
            for (DynamicObject task : dcs) {
                String id = task.getString(ID);
                if (noPermMembId.contains(Long.valueOf(id))) continue;
                HashMap<String, String> memberMap = new HashMap<String, String>(16);
                memberMap.put(ID, task.get(ID).toString());
                memberMap.put("number", task.getString("number"));
                memberMap.put("name", task.getString("number") + "\n\n" + task.getString("name"));
                String pid = task.getString("parent");
                if (noPermMembId.contains(Long.valueOf(pid))) {
                    pid = rootId;
                }
                memberMap.put("parentid", pid);
                memberList.add(memberMap);
            }
        }
        return memberList;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey()) {
            case "btngo": {
                this.singleMoveRight();
                break;
            }
            case "btnallgo": {
                this.allMoveRight();
                break;
            }
            case "allexpand": {
                this.spreadAll();
                break;
            }
            case "allshrink": {
                this.collapseAll();
                break;
            }
            case "btnback": {
                this.singleMoveLeft();
                break;
            }
            case "btnallback": {
                this.allMoveLeft();
                break;
            }
            case "searchbefore1": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(TREE_LEFT, LEFT_TREE_CACHE, L_LIST, L_FOCUS, L_OLD_NODE_CACHE, TreeSearchUtil.SearchBtnStatus.LEFT));
                break;
            }
            case "searchnext1": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(TREE_LEFT, LEFT_TREE_CACHE, L_LIST, L_FOCUS, L_OLD_NODE_CACHE, TreeSearchUtil.SearchBtnStatus.RIGHT));
                break;
            }
            case "searchbefore": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(TREE_RIGHT, RIGHT_TREE_CACHE, R_LIST, R_FOCUS, R_OLD_NODE_CACHE, TreeSearchUtil.SearchBtnStatus.LEFT));
                break;
            }
            case "searchnext": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(TREE_RIGHT, RIGHT_TREE_CACHE, R_LIST, R_FOCUS, R_OLD_NODE_CACHE, TreeSearchUtil.SearchBtnStatus.RIGHT));
                break;
            }
            case "issued": {
                this.issued(key);
                break;
            }
            case "save": {
                this.saveData(key);
                break;
            }
        }
    }

    protected void spreadAll() {
        TreeNode leftRoot = this.getCacheLeftRoot();
        if (leftRoot == null) {
            return;
        }
        TreeView treeLeft = (TreeView)this.getView().getControl(TREE_LEFT);
        if (leftRoot.getChildren() != null) {
            leftRoot.setIsOpened(true);
            this.spreadChild(leftRoot);
        }
        treeLeft.deleteAllNodes();
        treeLeft.addNode(leftRoot);
    }

    protected void spreadChild(TreeNode leftRoot) {
        leftRoot.getChildren().forEach(t -> {
            if (t.getChildren() != null) {
                t.setIsOpened(true);
                this.spreadChild((TreeNode)t);
            }
        });
    }

    protected void collapseAll() {
        TreeNode leftRoot = this.getCacheLeftRoot();
        if (leftRoot == null) {
            return;
        }
        TreeView treeLeft = (TreeView)this.getView().getControl(TREE_LEFT);
        if (leftRoot.getChildren() != null) {
            this.collapseChild(leftRoot);
        }
        treeLeft.deleteAllNodes();
        treeLeft.addNode(leftRoot);
    }

    protected void collapseChild(TreeNode leftRoot) {
        leftRoot.getChildren().forEach(t -> {
            if (t.getChildren() != null) {
                t.setIsOpened(false);
                this.collapseChild((TreeNode)t);
            }
        });
    }

    private void singleMoveLeft() {
        if (this.beforeSetEntityCheck()) {
            TreeView rightTree = (TreeView)this.getView().getControl(TREE_RIGHT);
            List checkOrgIds = rightTree.getTreeState().getCheckedNodeIds();
            if (checkOrgIds.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u53f3\u4fa7\u6811\u7684\u4e00\u4e2a\u8282\u70b9\u3002", (String)"TargetSchemeRecordAddPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            TreeNode rightTreeNode = this.getCacheRightRoot();
            checkOrgIds.forEach(arg_0 -> ((TreeNode)rightTreeNode).deleteChildNode(arg_0));
            rightTree.deleteAllNodes();
            rightTree.addNode(rightTreeNode);
            rightTree.expand(rightTreeNode.getId());
            this.cacheRightRoot(rightTreeNode);
            this.setEntity();
        }
    }

    private void allMoveLeft() {
        if (this.beforeSetEntityCheck()) {
            TreeView rightTree = (TreeView)this.getView().getControl(TREE_RIGHT);
            TreeNode rightTreeNode = this.getCacheRightRoot();
            rightTreeNode.setChildren(null);
            rightTree.deleteAllNodes();
            rightTree.addNode(rightTreeNode);
            rightTree.expand(rightTreeNode.getId());
            this.cacheRightRoot(rightTreeNode);
            this.setEntity();
        }
    }

    private boolean beforeSetEntityCheck() {
        Object bizctrl = this.getModel().getValue(BIZCTRL);
        Object datatype = this.getModel().getValue(DATATYPE);
        Object version = this.getModel().getValue(VERSION);
        Object audittrail = this.getModel().getValue(AUDITTRAIL);
        if (bizctrl == null || datatype == null || version == null || audittrail == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u76ee\u6807\u627f\u63a5\u8bbe\u7f6e\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"TargetSchemeRecordAddPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void setEntity() {
        Map<String, String> rightTreeNodeIds = this.getRightTreeNodeIds();
        HashSet<String> values = new HashSet<String>(16);
        for (Map.Entry<String, String> entry : rightTreeNodeIds.entrySet()) {
            String value = entry.getValue();
            values.add(value.split("\n\n")[0]);
        }
        List<String> entities = this.handleEntity(values);
        if (!CollectionUtils.isEmpty(entities)) {
            this.getModel().setValue("entity", (Object)String.join((CharSequence)",", entities));
        } else {
            this.getModel().setValue("entity", (Object)"");
        }
        this.initRightTree();
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.cacheSchemeInfo();
        DynamicObject targetScheme = (DynamicObject)this.getModel().getValue(TARGET_SCHEME);
        this.getModel().setValue("businessmodel", (Object)this.getCacheInfo("businessmodel"));
        this.getModel().setValue(TARGET_SCHEME, (Object)targetScheme.getLong(ID));
        this.getView().setEnable(Boolean.valueOf(false), new String[]{TARGET_SCHEME, "number", "businessmodel"});
        this.initLeftTree();
        this.initRightTree();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status.getValue() == OperationStatus.VIEW.getValue()) {
            this.setEnable();
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"save", ISSUED, REFRESH});
        }
        this.getModel().setDataChanged(false);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (REFRESH.equals(itemKey)) {
            this.refresh();
        }
    }

    private void saveData(String key) {
        if (!this.checkInfo()) {
            this.doSaveData(key);
        } else {
            this.getPageCache().put("saveSuccess", "");
        }
    }

    private void doSaveData(String key) {
        DynamicObject dynamicObject;
        String pkId = this.getPageCache().get("pkId");
        Long userId = UserUtils.getUserId();
        DynamicObjectType dataEntityType = (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"bgm_targetschemerecord").getDataEntityType();
        Object number = this.getModel().getValue("number");
        if (StringUtils.isEmpty((String)pkId)) {
            dynamicObject = new DynamicObject(dataEntityType);
            long id = GlobalIdUtil.genGlobalLongId();
            dynamicObject.set(ID, (Object)id);
            dynamicObject.set("creator", (Object)userId);
            dynamicObject.set("createdate", (Object)new Date());
            dynamicObject.set("number", number);
            dynamicObject.set(TARGET_SCHEME, this.getModel().getValue(TARGET_SCHEME));
            dynamicObject.set(MODEL, this.getModel().getValue(MODEL));
            dynamicObject.set("status", this.getModel().getValue("status"));
        } else {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(pkId), (String)"bgm_targetschemerecord");
        }
        dynamicObject.set("entityview", this.getModel().getValue("entityview"));
        dynamicObject.set("desc", this.getModel().getValue("desc"));
        dynamicObject.set(BIZCTRL, this.getModel().getValue(BIZCTRL));
        dynamicObject.set(DATATYPE, this.getModel().getValue(DATATYPE));
        dynamicObject.set(VERSION, this.getModel().getValue(VERSION));
        dynamicObject.set(AUDITTRAIL, this.getModel().getValue(AUDITTRAIL));
        dynamicObject.set("entity", this.getModel().getValue("entity"));
        dynamicObject.set("modifier", (Object)userId);
        dynamicObject.set("modifydate", (Object)new Date());
        BusinessDataServiceHelper.save((IDataEntityType)dataEntityType, (Object[])new Object[]{dynamicObject});
        this.getPageCache().put("saveSuccess", "true");
        this.getPageCache().put("pkId", String.valueOf(dynamicObject.getLong(ID)));
        if ("save".equals(key)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TargetSchemeRecordAddPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getModel().setDataChanged(false);
        this.refresh();
        if (StringUtils.isEmpty((String)pkId)) {
            MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u65b0\u589e\u4fdd\u5b58", "TargetSchemeRecordAddPlugin_16", "epm-eb-formplugin");
            MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u7f16\u53f7\uff1a\u201c%1$s\u201d\uff0c\u4fdd\u5b58\u6210\u529f\u3002", "TargetSchemeRecordAddPlugin_18", "epm-eb-formplugin");
            OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), (String)"save", (String)"save", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (String[])new String[]{number.toString()});
        } else {
            MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4fee\u6539\u4fdd\u5b58", "TargetSchemeRecordAddPlugin_17", "epm-eb-formplugin");
            MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u7f16\u53f7\uff1a\u201c%1$s\u201d\uff0c\u4fdd\u5b58\u6210\u529f\u3002", "TargetSchemeRecordAddPlugin_18", "epm-eb-formplugin");
            OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), (String)"save", (String)"save", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (String[])new String[]{number.toString()});
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            boolean isCancel = this.checkInfo();
            args.setCancel(isCancel);
            this.getPageCache().put("saveSuccess", "");
        }
    }

    private boolean checkInfo() {
        boolean isCancel = false;
        Map<String, String> rightTreeNodeIds = this.getRightTreeNodeIds();
        if (CollectionUtils.isEmpty(rightTreeNodeIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"TargetSchemeRecordAddPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            isCancel = true;
        }
        return isCancel;
    }

    private List<String> handleEntity(Set<String> strings) {
        DynamicObjectCollection query;
        ArrayList<String> entities = new ArrayList<String>(10);
        IModelCacheHelper cacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Long viewId = cacheHelper.getViewByBusModelAndDimNumber(this.getCacheModelId("businessmodel"), "Entity");
        for (String string : strings) {
            Member member = cacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), viewId, string);
            if (member == null) {
                member = cacheHelper.getMemberByAnyView(SysDimensionEnum.Entity.getNumber(), string);
            }
            List parents = cacheHelper.getParents(viewId, member, false);
            List<String> collect = parents.stream().map(BaseCache::getNumber).collect(Collectors.toList());
            List children = cacheHelper.getChildren(member, false);
            List collect1 = children.stream().map(BaseCache::getNumber).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(entities)) {
                if (!Collections.disjoint(entities, collect)) {
                    List<String> retainAll = this.retainAll(entities, collect);
                    entities.removeAll(retainAll);
                    entities.add(string);
                    continue;
                }
                if (!Collections.disjoint(entities, collect1)) continue;
                entities.add(string);
                continue;
            }
            entities.add(string);
        }
        DynamicObject targetScheme = (DynamicObject)this.getModel().getValue(TARGET_SCHEME);
        DynamicObject bizctrl = (DynamicObject)this.getModel().getValue(BIZCTRL);
        DynamicObject datatype = (DynamicObject)this.getModel().getValue(DATATYPE);
        DynamicObject version = (DynamicObject)this.getModel().getValue(VERSION);
        DynamicObject audittrail = (DynamicObject)this.getModel().getValue(AUDITTRAIL);
        QFilter schemeFilter = new QFilter(TARGET_SCHEME, "=", (Object)targetScheme.getLong(ID));
        QFilter bizctrlFilter = new QFilter(BIZCTRL, "=", (Object)bizctrl.getLong(ID));
        QFilter datatypeFilter = new QFilter(DATATYPE, "=", (Object)datatype.getLong(ID));
        QFilter versionFilter = new QFilter(VERSION, "=", (Object)version.getLong(ID));
        QFilter audittrailFilter = new QFilter(AUDITTRAIL, "=", (Object)audittrail.getLong(ID));
        QFilter model = new QFilter(MODEL, "=", (Object)this.getModelId());
        String id = this.getCacheInfo("pkId");
        model.and(schemeFilter).and(bizctrlFilter).and(datatypeFilter).and(versionFilter).and(audittrailFilter);
        if (!StringUtils.isEmpty((String)id)) {
            QFilter idQFilter = new QFilter(ID, "!=", (Object)Long.valueOf(id));
            model.and(idQFilter);
        }
        if (!CollectionUtils.isEmpty((Collection)(query = QueryServiceHelper.query((String)"bgm_targetschemerecord", (String)"id,entity", (QFilter[])new QFilter[]{model})))) {
            for (DynamicObject dynamicObject : query) {
                String[] split;
                String entity = dynamicObject.getString("entity");
                if (StringUtils.isEmpty((String)entity)) continue;
                for (String s : split = entity.split(",")) {
                    Member member = cacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), viewId, s);
                    if (member == null) {
                        member = cacheHelper.getMemberByAnyView(SysDimensionEnum.Entity.getNumber(), s);
                    }
                    List parents = cacheHelper.getParents(viewId, member, true);
                    List children = cacheHelper.getChildren(member, true);
                    List parent = parents.stream().map(BaseCache::getNumber).collect(Collectors.toList());
                    List child = children.stream().map(BaseCache::getNumber).collect(Collectors.toList());
                    if (Collections.disjoint(parent, entities) && Collections.disjoint(child, entities)) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u4e0b\u8fbe\u65b9\u6848\u6240\u9009\u7684\u4e0b\u8fbe\u7ec4\u7ec7\u5df2\u5b58\u5728\u4e0b\u8fbe\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u91cd\u65b0\u4e0b\u8fbe\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TargetSchemeRecordAddPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return null;
                }
            }
        }
        return entities;
    }

    private List<String> retainAll(List<String> collection, List<String> retain) {
        ArrayList<String> list = new ArrayList<String>(Math.min(collection.size(), retain.size()));
        for (String obj : collection) {
            if (!retain.contains(obj)) continue;
            list.add(obj);
        }
        return list;
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult operationResult;
        List successPkIds;
        String operateKey = args.getOperateKey();
        if (StringUtils.equals((String)operateKey, (String)"save") && !CollectionUtils.isEmpty((Collection)(successPkIds = (operationResult = args.getOperationResult()).getSuccessPkIds()))) {
            this.getPageCache().put("pkId", String.valueOf(successPkIds.get(0)));
            this.getPageCache().put("saveSuccess", "true");
            this.refresh();
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key;
        switch (key = beforeF7SelectEvent.getProperty().getName()) {
            case "bizctrl": {
                this.switchBizctrl(beforeF7SelectEvent);
                break;
            }
            case "datatype": {
                this.switchDataType(beforeF7SelectEvent);
                break;
            }
            case "version": {
                this.switchVersion(beforeF7SelectEvent);
                break;
            }
            case "audittrail": {
                this.switchAudittaril(beforeF7SelectEvent);
                break;
            }
            case "entityview": {
                Long businessmodel = this.getCacheModelId("businessmodel");
                if (IDUtils.isEmptyLong((Long)businessmodel).booleanValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"TargetSchemeRecordAddPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
                List views = modelCache.getViewGroupViewsByBusModelAndDimNumber(businessmodel, SysDimensionEnum.Entity.getNumber());
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().getQFilters().add(new QFilter(ID, "in", (Object)views.toArray()));
                break;
            }
        }
    }

    public String getCurrentDimNumber(String controlKey) {
        if (DATATYPE.equals(controlKey)) {
            return "DataType";
        }
        if (VERSION.equals(controlKey)) {
            return "Version";
        }
        if (AUDITTRAIL.equals(controlKey)) {
            return "AuditTrail";
        }
        return null;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (TARGET_SCHEME_ISSUED_CONFIRM.equals(actionId)) {
            String returnData = (String)e.getReturnData();
            if ("1".equalsIgnoreCase(returnData)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u81ea\u52a8\u542f\u7528\u5206\u89e3\u65b9\u6848\u8fdb\u884c\u6267\u884c\u3002", (String)"TargetSchemeRecordAddPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if ("2".equalsIgnoreCase(returnData)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u6682\u5b58\u5206\u89e3\u65b9\u6848\uff0c\u53ef\u6309\u9700\u542f\u7528\u6267\u884c\u3002", (String)"TargetSchemeRecordAddPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if ("3".equalsIgnoreCase(returnData)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u89e3\u65b9\u6848\u5df2\u81ea\u52a8\u5206\u89e3\u5b8c\u6210\u3002", (String)"TargetSchemeRecordAddPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.refresh();
            if (StringUtils.isNotEmpty((String)returnData)) {
                Object number = this.getModel().getValue("number");
                MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4e0b\u8fbe", "TargetSchemeRecordAddPlugin_19", "epm-eb-formplugin");
                MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u7f16\u53f7\uff1a\u201c%1$s\u201d\uff0c\u4fdd\u5b58\u6210\u529f\u3002", "TargetSchemeRecordAddPlugin_20", "epm-eb-formplugin");
                OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), (String)ISSUED, (String)ISSUED, (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (String[])new String[]{number.toString()});
            }
        }
    }

    private void issued(String key) {
        this.saveData(key);
        String pkId = this.getPageCache().get("pkId");
        String saveSuccess = this.getPageCache().get("saveSuccess");
        if (StringUtils.isEmpty((String)pkId) || StringUtils.isEmpty((String)saveSuccess)) {
            return;
        }
        long id = Long.parseLong(this.getPageCache().get("pkId"));
        DynamicObject targetSchemeRecord = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bgm_targetschemerecord");
        String status = targetSchemeRecord.getString("status");
        String number = targetSchemeRecord.getString("number");
        if (TargetSchemeRecordStatusEnum.ISSUED.getValue().equals(status)) {
            String message = ResManager.loadKDString((String)"\u76ee\u6807\u65b9\u6848\u5df2\u4e0b\u8fbe\u3002", (String)"TargetSchemeRecordAddPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4e0b\u8fbe", "TargetSchemeRecordAddPlugin_19", "epm-eb-formplugin");
            MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u7f16\u53f7\uff1a\u201c%1$s\u201d\uff0c\u4e0b\u8fbe\u5931\u8d25\uff0c%2$s\u3002", "TargetSchemeRecordAddPlugin_21", "epm-eb-formplugin");
            OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), (String)ISSUED, (String)ISSUED, (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (String[])new String[]{number, message});
        } else {
            TargetSchemeService instance = TargetSchemeService.getInstance();
            List srcOlap = instance.getSrcOlap(Long.valueOf(id));
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)srcOlap)) {
                DynamicObject targetScheme = (DynamicObject)this.getModel().getValue(TARGET_SCHEME);
                DynamicObject bizModel = targetScheme.getDynamicObject("bizmodel");
                long bizModelId = bizModel.getLong(ID);
                DynamicObject srcBizCtrl = (DynamicObject)this.getModel().getValue("businessmodel");
                long srcBizCtrlId = srcBizCtrl.getLong(ID);
                DynamicObject tarBizCtrl = (DynamicObject)this.getModel().getValue(BIZCTRL);
                long tarBizCtrlId = tarBizCtrl.getLong(ID);
                Long modelId = this.getModelId();
                List checkDimMappers = instance.checkDimMapper(srcOlap, modelId.longValue(), bizModelId, srcBizCtrlId, tarBizCtrlId);
                if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)checkDimMappers)) {
                    String message = ResManager.loadKDString((String)"\u7ef4\u5ea6\u627f\u63a5\u6620\u5c04\u672a\u5339\u914d\u3002", (String)"TargetSchemeRecordAddPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    this.openTargetSchemeIssueMessage(id, checkDimMappers, modelId, bizModelId, srcBizCtrlId, tarBizCtrlId);
                    MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4e0b\u8fbe", "TargetSchemeRecordAddPlugin_19", "epm-eb-formplugin");
                    MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u7f16\u53f7\uff1a\u201c%1$s\u201d\uff0c\u4e0b\u8fbe\u5931\u8d25\uff0c%2$s\u3002", "TargetSchemeRecordAddPlugin_21", "epm-eb-formplugin");
                    OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), (String)ISSUED, (String)ISSUED, (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (String[])new String[]{number, message});
                } else {
                    this.openTargetSchemeIssuedConfirm(id, modelId, bizModelId, srcBizCtrlId, tarBizCtrlId);
                }
            } else {
                String message = ResManager.loadKDString((String)"\u76ee\u6807\u4e0b\u8fbe\u7684\u7ec4\u7ec7\uff0c\u65e0\u76ee\u6807\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TargetSchemeRecordAddPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
                MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4e0b\u8fbe", "TargetSchemeRecordAddPlugin_19", "epm-eb-formplugin");
                MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u7f16\u53f7\uff1a\u201c%1$s\u201d\uff0c\u4e0b\u8fbe\u5931\u8d25\uff0c%2$s\u3002", "TargetSchemeRecordAddPlugin_21", "epm-eb-formplugin");
                OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), (String)ISSUED, (String)ISSUED, (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (String[])new String[]{number, message});
            }
        }
    }

    private void openTargetSchemeIssueMessage(long id, List<TargetSchemeDimMapper> checkDimMappers, long modelId, long bizModelId, long srcBizCtrlId, long tarBizCtrlId) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("dimMappers", JSON.toJSONString(checkDimMappers));
        params.put("modelId", modelId);
        params.put("bizModelId", bizModelId);
        params.put("srcBizCtrlId", srcBizCtrlId);
        params.put("tarBizCtrlId", tarBizCtrlId);
        params.put("recordId", id);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bgm_targetschemmessage");
        parameter.setCustomParams(params);
        parameter.setCaption(ResManager.loadKDString((String)"\u76ee\u6807\u65b9\u6848\u4e0b\u8fbe\u63d0\u793a\u4fe1\u606f", (String)"TargetSchemeRecordAddPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, TARGET_SCHEME_MESSAGE);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private void openTargetSchemeIssuedConfirm(long id, long modelId, long bizModelId, long srcBizCtrlId, long tarBizCtrlId) {
        HashMap<String, Long> params = new HashMap<String, Long>(16);
        params.put("modelId", modelId);
        params.put("bizModelId", bizModelId);
        params.put("srcBizCtrlId", srcBizCtrlId);
        params.put("tarBizCtrlId", tarBizCtrlId);
        params.put("recordId", id);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bgm_targetissuedconfirm");
        parameter.setCustomParams(params);
        parameter.setCaption(ResManager.loadKDString((String)"\u4e0b\u8fbe\u64cd\u4f5c\u786e\u8ba4", (String)"TargetSchemeRecordAddPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, TARGET_SCHEME_ISSUED_CONFIRM);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private void refresh() {
        String pkId = this.getCacheInfo("pkId");
        if (!StringUtils.isEmpty((String)pkId)) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(pkId), (String)"bgm_targetschemerecord");
            if (StringUtils.equals((String)TargetSchemeRecordStatusEnum.ISSUED.getValue(), (String)dynamicObject.getString("status"))) {
                this.setEnable();
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"save", ISSUED, REFRESH});
            } else if (StringUtils.equals((String)TargetSchemeRecordStatusEnum.SAVE.getValue(), (String)dynamicObject.getString("status"))) {
                this.initRightTree();
            }
        }
    }

    private void setEnable() {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"number", "desc", TARGET_SCHEME, "businessmodel", BIZCTRL, DATATYPE, VERSION, AUDITTRAIL, "btngo", "btnallgo", "btnback", "btnallback"});
    }

    private void switchAudittaril(BeforeF7SelectEvent beforeF7SelectEvent) {
        long bizModelId = this.getCacheModelId(BIZCTRL);
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        ParameterF7Builder builder = new ParameterF7Builder("left");
        QFilter isLeaf = new QFilter("isleaf", "=", (Object)"1");
        showParameter.getListFilterParameter().getQFilters().add(isLeaf);
        this.switchLeftTreeF7(beforeF7SelectEvent, bizModelId, (LeftTreeF7Parameter)builder.build());
    }

    private void switchVersion(BeforeF7SelectEvent beforeF7SelectEvent) {
        long bizModelId = this.getCacheModelId(BIZCTRL);
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        QFilter isLeaf = new QFilter("isleaf", "=", (Object)"1");
        QFilter qFilter = new QFilter("number", "!=", (Object)"ACTUAL");
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        qFilters.add(isLeaf);
        qFilters.add(qFilter);
        ParameterF7Builder builder = new ParameterF7Builder("left");
        this.switchLeftTreeF7(beforeF7SelectEvent, bizModelId, (LeftTreeF7Parameter)builder.build());
    }

    private void switchDataType(BeforeF7SelectEvent beforeF7SelectEvent) {
        long bizModelId = this.getCacheModelId("businessmodel");
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        QFilter isLeaf = new QFilter("isleaf", "=", (Object)"1");
        showParameter.getListFilterParameter().getQFilters().add(isLeaf);
        ParameterF7Builder builder = new ParameterF7Builder("left");
        this.switchLeftTreeF7(beforeF7SelectEvent, bizModelId, (LeftTreeF7Parameter)builder.build());
    }

    private void switchBizctrl(BeforeF7SelectEvent beforeF7SelectEvent) {
        QFilter qf = new QFilter(MODEL, "=", (Object)this.getModelId());
        DynamicObject businessModel = (DynamicObject)this.getModel().getValue("businessmodel");
        QFilter qFilter = new QFilter(ID, "!=", (Object)businessModel.getLong(ID));
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        qFilters.add(qf);
        qFilters.add(qFilter);
    }

    @Override
    public Long getModelId() {
        String modelId = this.getPageCache().get(MODEL);
        if (StringUtils.isEmpty((String)modelId)) {
            return 0L;
        }
        return Long.valueOf(modelId);
    }

    private Long getCacheModelId(String key) {
        String s = this.getPageCache().get(key);
        return IDUtils.toLong((Object)s);
    }

    private void cacheSchemeInfo() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String businessModel = (String)customParams.get("businessmodel");
        String model = (String)customParams.get(MODEL);
        Long targetSchemeId = (Long)customParams.get("targetschemeid");
        Long pkId = (Long)customParams.get("pkId");
        this.getPageCache().put(MODEL, model);
        this.getPageCache().put("businessmodel", businessModel);
        this.getPageCache().put(TARGET_SCHEME, String.valueOf(targetSchemeId));
        if (pkId != null) {
            this.getPageCache().put("pkId", String.valueOf(pkId));
        }
    }

    private void fillSchemeInfo() {
        Long id = Long.valueOf(this.getCacheInfo(TARGET_SCHEME));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bgm_targetscheme", (String)"id,number,name,datatype,version,audittrail", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)id)});
        if (dynamicObject != null) {
            Long modelId = IDUtils.toLong((Object)this.getCacheInfo(MODEL));
            Long bussModelId = Long.valueOf(this.getCacheInfo("businessmodel"));
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            this.getModel().setValue("businessmodel", (Object)bussModelId);
            Long view = modelCacheHelper.getViewByBusModelAndDimNumber(bussModelId, SysDimensionEnum.Entity.getNumber());
            this.getModel().setValue("entityview", (Object)view);
            this.getModel().setValue(MODEL, (Object)modelId);
            this.getModel().setValue(TARGET_SCHEME, (Object)this.getCacheModelId(TARGET_SCHEME));
            this.getPageCache().put("schemeNumber", dynamicObject.getString("number"));
            this.getModel().setValue(DATATYPE, (Object)dynamicObject.getLong(DATATYPE));
            this.getModel().setValue(VERSION, (Object)dynamicObject.getLong(VERSION));
            long auditTrailId = dynamicObject.getLong(AUDITTRAIL);
            Member auditTrail = modelCacheHelper.getMember(SysDimensionEnum.AuditTrail.getNumber(), null, Long.valueOf(auditTrailId));
            if (auditTrail != null && auditTrail.isLeaf()) {
                this.getModel().setValue(AUDITTRAIL, (Object)auditTrailId);
            } else {
                this.getModel().setValue(AUDITTRAIL, null);
            }
            this.setRecordNumber();
            this.getView().updateView();
        }
    }

    private String getCacheInfo(String key) {
        return this.getPageCache().get(key);
    }

    private void setRecordNumber() {
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"bgm_targetschemerecord");
        DynamicObject targetScheme = (DynamicObject)this.getModel().getValue(TARGET_SCHEME);
        object.set(TARGET_SCHEME, (Object)targetScheme);
        ICodeRuleService service = (ICodeRuleService)ServiceFactory.getService((String)"ICodeRuleService");
        String number = service.getNumber("bgm_targetschemerecord", object, null);
        this.getModel().setValue("number", (Object)number);
    }

    public void treeNodeCheck(TreeNodeCheckEvent treeNodeCheckEvent) {
    }

    private void singleMoveRight() {
        if (this.beforeSetEntityCheck()) {
            TreeView leftTree = (TreeView)this.getView().getControl(TREE_LEFT);
            TreeView rightTree = (TreeView)this.getView().getControl(TREE_RIGHT);
            TreeNode leftTreeRoot = this.getCacheLeftRoot();
            TreeNode rightTreeRoot = this.getCacheRightRoot();
            Map<String, String> rightTreeNodeIds = this.getRightTreeNodeIds();
            rightTreeNodeIds.put(leftTreeRoot.getId(), "");
            List selectIds = leftTree.getTreeState().getSelectedNodeId();
            selectIds.forEach(selectId -> {
                if (!rightTreeNodeIds.containsKey(selectId)) {
                    TreeNode node = leftTreeRoot.getTreeNode(selectId, 20);
                    rightTreeRoot.addChild(this.copyTreeNode(node));
                }
            });
            rightTree.deleteAllNodes();
            rightTree.addNode(rightTreeRoot);
            rightTree.expand(rightTreeRoot.getId());
            this.cacheRightRoot(rightTreeRoot);
            this.setEntity();
        }
    }

    private void allMoveRight() {
        if (this.beforeSetEntityCheck()) {
            TreeView rightTree = (TreeView)this.getView().getControl(TREE_RIGHT);
            TreeNode leftTreeRoot = this.getCacheLeftRoot();
            TreeNode rightTreeRoot = this.getCacheRightRoot();
            rightTreeRoot.setChildren(null);
            this.copyWholeTree(leftTreeRoot, rightTreeRoot);
            rightTree.deleteAllNodes();
            rightTree.addNode(rightTreeRoot);
            rightTree.expand(rightTreeRoot.getId());
            this.cacheRightRoot(rightTreeRoot);
            this.setEntity();
        }
    }

    protected TreeNode getCacheLeftRoot() {
        if (StringUtils.isNotEmpty((String)this.getPageCache().get(LEFT_TREE_CACHE))) {
            return (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(LEFT_TREE_CACHE), TreeNode.class);
        }
        return null;
    }

    protected TreeNode getCacheRightRoot() {
        return (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(RIGHT_TREE_CACHE), TreeNode.class);
    }

    private Map<String, String> getRightTreeNodeIds() {
        HashMap<String, String> nodeMap;
        String nodeIdsStr = this.getPageCache().get("rightTreeNodeIds");
        if (nodeIdsStr == null) {
            nodeMap = new HashMap<String, String>(16);
            this.getPageCache().put("rightTreeNodeIds", ObjectSerialUtil.toByteSerialized(nodeMap));
        } else {
            nodeMap = (HashMap<String, String>)ObjectSerialUtil.deSerializedBytes((String)nodeIdsStr);
        }
        return nodeMap;
    }

    private TreeNode copyTreeNode(TreeNode node) {
        TreeNode newNode = new TreeNode();
        newNode.setId(node.getId());
        newNode.setText(node.getText());
        return newNode;
    }

    public void copyWholeTree(TreeNode fromTree, TreeNode toTree) {
        List children = fromTree.getChildren();
        if (children != null) {
            children.forEach(child -> {
                TreeNode copyChild = this.copyTreeNode((TreeNode)child);
                this.copyWholeTree((TreeNode)child, copyChild);
                toTree.addChild(copyChild);
            });
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (BIZCTRL.equals(name) || DATATYPE.equals(name) || VERSION.equals(name) || AUDITTRAIL.equals(name)) {
            this.getModel().setValue("entity", (Object)"");
            this.initRightTree();
        }
        if ("entityview".equals(name)) {
            this.initLeftTree();
            this.initRightTree();
        }
    }
}

