/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.decomposescheme;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.applybill.DecpRowData;
import kd.epm.eb.common.applybill.DecpStepData;
import kd.epm.eb.common.applybill.DecpStepManager;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.excel.WriteExcelUtil;

public class BgSplitSchemeUtil {
    public static final String head_sign = "SCHEME_HEAD";
    public static final String step_sign = "SCHEME_STEPS";
    public static final String stepEnd_sign = "SCHEME_STEPEND";
    private static final String[] head_keys = new String[]{"number", "name", "model", "enable", "explain", "bizctrlrange", "creator", "createtime", "modifier", "modifytime"};

    public static void exportSchemes(DynamicObject[] schemeObjs, IFormView formView) {
        for (DynamicObject object : schemeObjs) {
            ArrayList<List<String>> data = new ArrayList<List<String>>();
            BgSplitSchemeUtil.export_head(data, object);
            BgSplitSchemeUtil.export_step(data, object);
            String fileName = BgSplitSchemeUtil.getFileName(object);
            WriteExcelUtil.writeExcel((IFormView)formView, data, (String)fileName);
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5bfc\u51fa", "BgSplitSchemeUtil_11", "epm-eb-formplugin");
            MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u7f16\u53f7\uff1a%1$s\uff0c\u5bfc\u51fa\u6210\u529f\u3002", "BgSplitSchemeUtil_12", "epm-eb-formplugin");
            OperationLogUtil.log((String)formView.getFormShowParameter().getAppId(), (String)object.getDataEntityType().getName(), null, (String)"export", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[]{object.getString("number")});
        }
    }

    private static String getFileName(DynamicObject object) {
        String number = object.getString("number");
        String name = object.getString("name");
        return ResManager.loadResFormat((String)"\u5206\u89e3\u65b9\u6848_%1(%2).xlsx", (String)"BgSplitSchemeUtil_1_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{name, number});
    }

    private static void export_step(List<List<String>> data, DynamicObject object) {
        BgSplitSchemeUtil.addSign(data, step_sign);
        String rowsdataStr = object.getString("rowsdata");
        if (StringUtils.isNotEmpty((String)rowsdataStr)) {
            Long modelId = object.getLong("model.id");
            IModelCacheHelper iModelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            Long bizCtrlRangeId = object.getLong("bizctrlrange.id");
            Map viewIds = BusinessModelServiceHelper.getViewIds((Long)bizCtrlRangeId);
            Long viewId = (Long)viewIds.get(SysDimensionEnum.Entity.getNumber());
            Dimension dimension = iModelCacheHelper.getDimension(SysDimensionEnum.Entity.getNumber());
            DecpStepManager decpStepManager = (DecpStepManager)SerializationUtils.fromJsonString((String)rowsdataStr, DecpStepManager.class);
            List stepDataList = decpStepManager.getStepDataList();
            for (DecpStepData stepData : stepDataList) {
                BgSplitSchemeUtil.addStepBaseInfo(data, stepData);
                List rowDataList = stepData.getRowDataList();
                BgSplitSchemeUtil.addStepRowInfo(data, rowDataList, dimension, viewId);
                BgSplitSchemeUtil.addSign(data, stepEnd_sign);
            }
        }
    }

    private static void addStepBaseInfo(List<List<String>> data, DecpStepData stepData) {
        ArrayList<String> row = new ArrayList<String>();
        row.add(stepData.getNumber());
        row.add(stepData.getName());
        data.add(row);
        row = new ArrayList();
        row.add(ResManager.loadKDString((String)"\u4e0b\u8fbe\u7ec4\u7ec7(\u7f16\u7801)", (String)"BgSplitSchemeUtil_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        row.add(ResManager.loadKDString((String)"\u4e0b\u8fbe\u7ec4\u7ec7(\u540d\u79f0)", (String)"BgSplitSchemeUtil_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        row.add(ResManager.loadKDString((String)"\u5206\u89e3\u7ec4\u7ec7(\u7f16\u7801)", (String)"BgSplitSchemeUtil_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        row.add(ResManager.loadKDString((String)"\u5206\u89e3\u7ec4\u7ec7(\u540d\u79f0)", (String)"BgSplitSchemeUtil_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        row.add(ResManager.loadKDString((String)"\u5206\u89e3\u8d1f\u8d23\u4eba(\u5de5\u53f7)", (String)"BgSplitSchemeUtil_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        row.add(ResManager.loadKDString((String)"\u5206\u89e3\u8d1f\u8d23\u4eba(\u540d\u79f0)", (String)"BgSplitSchemeUtil_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        row.add(ResManager.loadKDString((String)"\u6709\u4e0b\u4e00\u6b65\u5206\u89e3", (String)"BgSplitSchemeUtil_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        data.add(row);
    }

    private static void addStepRowInfo(List<List<String>> data, List<DecpRowData> rowDataList, Dimension dimension, Long viewId) {
        HashSet<Long> orgIds = new HashSet<Long>(16);
        HashSet userIds = new HashSet(16);
        for (DecpRowData rowData : rowDataList) {
            orgIds.add(rowData.getDecpOrgId());
            orgIds.add(rowData.getOrderOrgId());
            userIds.addAll(rowData.getChargePersonsId());
        }
        Map<Long, Member> orgMembs = dimension.getMember(viewId, orgIds).stream().collect(Collectors.toMap(m -> m.getId(), m -> m));
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", userIds)});
        for (DecpRowData rowData : rowDataList) {
            ArrayList<String> row = new ArrayList<String>(7);
            Member member = orgMembs.get(rowData.getOrderOrgId());
            BgSplitSchemeUtil.addObjNameAndNum(row, member);
            member = orgMembs.get(rowData.getDecpOrgId());
            BgSplitSchemeUtil.addObjNameAndNum(row, member);
            ArrayList users = new ArrayList(rowData.getChargePersonsId().size());
            rowData.getChargePersonsId().forEach(uId -> {
                DynamicObject userObj = (DynamicObject)objectDynamicObjectMap.get(uId);
                if (userObj != null) {
                    users.add(userObj);
                }
            });
            BgSplitSchemeUtil.addObjNameAndNum(row, users);
            row.add(String.valueOf(rowData.isHasNextStep()));
            data.add(row);
        }
    }

    private static void addObjNameAndNum(List<String> row, Object val) {
        if (val == null) {
            row.add(null);
            row.add(null);
        } else if (val instanceof Member) {
            row.add(((Member)val).getNumber());
            row.add(((Member)val).getName());
        } else if (val instanceof DynamicObject) {
            row.add(((DynamicObject)val).getString("number"));
            row.add(((DynamicObject)val).getString("name"));
        } else if (val instanceof ArrayList) {
            List objects = (List)val;
            StringBuilder nameSB = new StringBuilder();
            StringBuilder numberSB = new StringBuilder();
            for (DynamicObject obj : objects) {
                numberSB.append(obj.getString("number")).append(',');
                nameSB.append(obj.getString("name")).append(',');
            }
            if (nameSB.length() > 0) {
                nameSB.deleteCharAt(nameSB.length() - 1);
                numberSB.deleteCharAt(numberSB.length() - 1);
            }
            row.add(numberSB.toString());
            row.add(nameSB.toString());
        } else {
            row.add(null);
            row.add(null);
        }
    }

    private static void addSign(List<List<String>> data, String sign) {
        ArrayList<String> row = new ArrayList<String>();
        row.add(sign);
        data.add(row);
    }

    private static void export_head(List<List<String>> data, DynamicObject object) {
        BgSplitSchemeUtil.addSign(data, head_sign);
        DynamicObjectType objectType = object.getDynamicObjectType();
        ArrayList<String> propNameRow = new ArrayList<String>();
        ArrayList<String> propValRow = new ArrayList<String>();
        for (String key : head_keys) {
            DynamicProperty property = objectType.getProperty(key);
            Object o = object.get((IDataEntityProperty)property);
            String propName = property.getDisplayName().getLocaleValue();
            if (property instanceof BasedataProp) {
                String numberKey = ((BasedataProp)property).getNumberProp();
                String nameKey = ((BasedataProp)property).getDisplayProp();
                if (key.equals("model")) {
                    numberKey = "shownumber";
                }
                propNameRow.add(ResManager.loadResFormat((String)"%1(\u7f16\u7801)", (String)"BgSplitSchemeUtil_9_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{propName}));
                propNameRow.add(ResManager.loadResFormat((String)"%1(\u540d\u79f0)", (String)"BgSplitSchemeUtil_10_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{propName}));
                DynamicObject val = (DynamicObject)o;
                if (val == null) {
                    propValRow.add(null);
                    propValRow.add(null);
                    continue;
                }
                propValRow.add(val.getString(numberKey));
                propValRow.add(val.getString(nameKey));
                continue;
            }
            propNameRow.add(propName);
            if (o == null) {
                propValRow.add(null);
                continue;
            }
            propValRow.add(o.toString());
        }
        data.add(propNameRow);
        data.add(propValRow);
    }
}

