/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.decomposescheme;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.applybill.DecpRowData;
import kd.epm.eb.common.applybill.DecpStepData;
import kd.epm.eb.common.applybill.DecpStepManager;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.entity.memberF7.BaseF7Parameter;
import kd.epm.eb.common.entity.memberF7.LeftTreeF7Parameter;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;

public class DecomposeSchemeEditPlugin
extends AbstractBasePlugin
implements ClickListener,
BeforeF7SelectListener,
TabSelectListener {
    private static final String KEY_MODEL_ID = "KEY_MODEL_ID";
    private static final String CACHE_DECOMPOSEORG_INDEX = "Cache_Decomposeorg_Index";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String ORDER_ORG = "orderorg";
    private static final String DECOMPOSE_ORG = "decomposeorg";
    private static final String DECOMPOSE_PERSONS = "decomposepersons";
    private static final String HASNEXTSTEP = "hasnextstep";
    private static final String STEP = "step";
    private static final String STEP_FIRST = "step1";
    private String doingOrderOrgChange = null;
    private String hasCheckedDataKey = "hasCheckedDataKey";
    private DecpStepManager allStepData;

    public void initialize() {
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = (Long)this.getCustomFormParam(KEY_MODEL_ID);
        if (IDUtils.isNull((Long)modelId)) {
            modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"model", (boolean)false);
        }
        if (IDUtils.isNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4efb\u4f55\u4f53\u7cfb\uff0c\u8bf7\u65b0\u589e\u4f53\u7cfb\u3002", (String)"DecomposeSchemeEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("model", (Object)modelId);
        this.cacheModelId(modelId);
    }

    private void cacheModelId(Long modelId) {
        this.getPageCache().put(KEY_MODEL_ID, String.valueOf(modelId));
    }

    @Override
    public void registerListener(EventObject e) {
        this.addF7SelectListener(this, new String[]{"bizctrlrange", DECOMPOSE_ORG, ORDER_ORG, "model"});
        this.addItemClickListeners(new String[]{"decptools"});
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        int[] rowIndexs = e.getRowIndexs();
    }

    private boolean isDoingOrderOrgChange() {
        return this.doingOrderOrgChange != null;
    }

    private void setDoingOrderOrgChange(boolean yes) {
        this.doingOrderOrgChange = yes ? "true" : null;
    }

    private boolean checkedData() {
        String s = this.getPageCache().get(this.hasCheckedDataKey);
        return s != null;
    }

    private void setCheckedData(boolean yes) {
        if (yes) {
            this.getPageCache().put(this.hasCheckedDataKey, "true");
        } else {
            this.getPageCache().remove(this.hasCheckedDataKey);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "addstep": {
                if (!this.checkBaseInfo().booleanValue()) break;
                this.showNewDecpStepForm();
                break;
            }
            case "delstep": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u5f53\u524d\u6b65\u9aa4\u53ca\u540e\u9762\u6240\u6709\u6b65\u9aa4?", (String)"DecomposeSchemeListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("delStep", (IFormPlugin)this));
                break;
            }
            case "editstep": {
                this.showEditDecpStepForm();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.equals("delStep") && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.delDecpStep(-1);
        }
    }

    private void showNewDecpStepForm() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_decpstepform");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "NewDecpStepForm"));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        int size = this.getOrCacheDecpStepData(null).size();
        formShowParameter.setCustomParam("number", (Object)(STEP + (size + 1)));
        this.getView().showForm(formShowParameter);
    }

    private void showEditDecpStepForm() {
        DecpStepData decpStepData;
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_decpstepform");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "EditDecpStepForm"));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        String tabKey = this.getCurrentTabKey();
        if (tabKey == null || (decpStepData = this.getOrCacheDecpStepData(null).getStepDataByNumber(tabKey)) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u89e3\u6b65\u9aa4\u3002", (String)"DecomposeSchemeListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        formShowParameter.setCustomParam("number", (Object)decpStepData.getNumber());
        formShowParameter.setCustomParam("name", (Object)decpStepData.getName());
        this.getView().showForm(formShowParameter);
    }

    private String getCurrentTabKey() {
        Tab tab = (Tab)this.getControl("tabap");
        return tab.getCurrentTab();
    }

    public TabPageAp createNewTabPageAp(String tabKey, String tabName) {
        TabPageAp page = new TabPageAp();
        page.setKey(tabKey);
        page.setName(new LocaleString(tabKey + ":" + tabName));
        return page;
    }

    private void delDecpStep(int stepIndex) {
        String currentStepKey;
        DecpStepManager decpStepData = this.getOrCacheDecpStepData(null);
        if (stepIndex == -1 && (stepIndex = decpStepData.getStepIndex(currentStepKey = this.getCurrentTabKey())) == -1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u89e3\u6b65\u9aa4\u3002", (String)"DecomposeSchemeListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Tab tab = (Tab)this.getControl("tabap");
        for (int index = decpStepData.size() - 1; index >= stepIndex; --index) {
            String stepKey = (String)decpStepData.getStepKeys().get(index);
            decpStepData.delStepData(stepKey);
            tab.deleteControls(new String[]{stepKey});
        }
        this.getOrCacheDecpStepData(decpStepData);
        if (stepIndex == 0) {
            this.getModel().deleteEntryData(ENTRY_ENTITY);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap2"});
        } else {
            DecpStepData preStepData = decpStepData.getStepDataByIndex(stepIndex - 1);
            tab.activeTab(preStepData.getNumber());
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (ORDER_ORG.equals(key)) {
            this.qfilterOrderOrg(e);
        } else if (DECOMPOSE_ORG.equals(key)) {
            this.qfilterDecpOrg(e);
        } else if (key.equals("model")) {
            this.qfilterModel(e);
        } else if (key.equals("bizctrlrange")) {
            this.qfilterBizCtrlRange(e);
        }
    }

    private void qfilterBizCtrlRange(BeforeF7SelectEvent e) {
        long modelId = this.getModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"DecomposeSchemeListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        } else {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            List qFilterList = showParameter.getListFilterParameter().getQFilters();
            qFilterList.add(new QFilter("model", "=", (Object)modelId));
        }
    }

    private Boolean checkBaseInfo() {
        String number = this.getModel().getDataEntity().getString("number");
        if (StringUtils.isEmpty((String)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7f16\u7801", (String)"DecomposeSchemeListPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        String name = this.getModel().getDataEntity().getString("name");
        if (StringUtils.isEmpty((String)name)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u540d\u79f0", (String)"DecomposeSchemeListPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        Long modelid = (Long)this.getValue("model", "id");
        if (modelid == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"DecomposeSchemeListPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        Long bizCtrlRangeId = this.getBizCtrlRangeId();
        if (bizCtrlRangeId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"DecomposeSchemeListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void qfilterOrderOrg(BeforeF7SelectEvent e) {
        LeftTreeF7Parameter leftTreeF7Parameter = new LeftTreeF7Parameter();
        leftTreeF7Parameter.setMultiple(false);
        leftTreeF7Parameter.setKeepTree(true);
        Long bizCtrlRangeId = this.getBizCtrlRangeId();
        if (!this.isFisrtStep()) {
            DecpStepManager decpStepData = this.getOrCacheDecpStepData(null);
            String currentTabKey = this.getCurrentTabKey();
            int stepIndex = decpStepData.getStepIndex(currentTabKey);
            DecpStepData preStepData = decpStepData.getStepDataByIndex(stepIndex - 1);
            Set orderOrgIds = preStepData.getRowDataList().stream().filter(row -> row.isHasNextStep()).map(DecpRowData::getDecpOrgId).collect(Collectors.toSet());
            ArrayList orderOrgNums = new ArrayList(16);
            if (orderOrgIds.size() > 0) {
                Map viewIds = BusinessModelServiceHelper.getViewIds((Long)bizCtrlRangeId);
                IModelCacheHelper iModelCacheHelper = this.getIModelCacheHelper();
                Dimension dimension = iModelCacheHelper.getDimension(SysDimensionEnum.Entity.getNumber());
                List member = dimension.getMember((Long)viewIds.get(dimension.getNumber()), orderOrgIds);
                member.forEach(member1 -> orderOrgNums.add(member1.getNumber()));
            }
            leftTreeF7Parameter.setOptionalNumber(orderOrgNums);
        }
        this.switchF7(e, bizCtrlRangeId, (BaseF7Parameter)leftTreeF7Parameter);
    }

    private boolean isFisrtStep() {
        String currentTabKey = this.getCurrentTabKey();
        return currentTabKey.equals(STEP_FIRST);
    }

    private void qfilterDecpOrg(BeforeF7SelectEvent e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            e.setCancel(true);
            return;
        }
        DynamicObject rowObj = this.getModel().getEntryRowEntity(ENTRY_ENTITY, selectRows[0]);
        DynamicObject dynamicObject = rowObj.getDynamicObject(ORDER_ORG);
        if (dynamicObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0b\u8fbe\u7ec4\u7ec7\u3002", (String)"DecomposeSchemeEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        } else {
            Long bizCtrlRangeId = this.getBizCtrlRangeId();
            if (bizCtrlRangeId == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"DecomposeSchemeListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            Map viewIds = BusinessModelServiceHelper.getViewIds((Long)bizCtrlRangeId);
            String orderOrgNum = dynamicObject.getString("number");
            String decpOrgNum = rowObj.getString("decomposeorg.number");
            Set<String> otherDecpOrgNum = this.getOtherDecpOrgNumOnSameOrderOrg(orderOrgNum);
            otherDecpOrgNum.remove(decpOrgNum);
            List<String> allChilds = this.getAllChildrens(orderOrgNum, otherDecpOrgNum, (Long)viewIds.get(SysDimensionEnum.Entity.getNumber()));
            LeftTreeF7Parameter leftTreeF7Parameter = new LeftTreeF7Parameter();
            leftTreeF7Parameter.setMultiple(true);
            leftTreeF7Parameter.setKeepTree(true);
            leftTreeF7Parameter.setOptionalNumber(allChilds);
            this.getPageCache().put(CACHE_DECOMPOSEORG_INDEX, String.valueOf(e.getRow()));
            e.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, DECOMPOSE_ORG));
            this.switchF7(e, bizCtrlRangeId, (BaseF7Parameter)leftTreeF7Parameter);
        }
    }

    private Set<String> getOtherDecpOrgNumOnSameOrderOrg(String orderOrgNum) {
        HashSet<String> numbers = new HashSet<String>(16);
        DynamicObjectCollection entityRows = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (DynamicObject row : entityRows) {
            String num1;
            String num = row.getString("orderorg.number");
            if (!orderOrgNum.equals(num) || (num1 = row.getString("decomposeorg.number")) == null) continue;
            numbers.add(num1);
        }
        return numbers;
    }

    private Long getEntityViewId() {
        Long bizCtrlRangeId = this.getBizCtrlRangeId();
        Map viewIds = BusinessModelServiceHelper.getViewIds((Long)bizCtrlRangeId);
        return (Long)viewIds.get(SysDimensionEnum.Entity.getNumber());
    }

    private void qfilterModel(BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        ArrayList qFilterList = ((BasedataEdit)this.getControl("model")).getQFilters();
        if (qFilterList == null) {
            qFilterList = new ArrayList();
        }
        qFilterList.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
        showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        switch (event.getActionId()) {
            case "releaseorg": {
                this.releaseorgCloseBack(event, event.getActionId());
                break;
            }
            case "decomposeorg": {
                this.decomposeorgCloseBack(event, event.getActionId());
                break;
            }
            case "NewDecpStepForm": {
                this.decpStepNewCloseBack(event);
                break;
            }
            case "EditDecpStepForm": {
                this.decpStepEditCloseBack(event);
                break;
            }
            case "continueSave": {
                this.continuSave(event);
                break;
            }
        }
    }

    private void continuSave(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (returnData != null) {
            this.setCheckedData(true);
            this.getView().invokeOperation("save");
        }
    }

    public void afterCopyData(EventObject e) {
        this.initStepData();
    }

    public void decpStepNewCloseBack(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (returnData == null) {
            return;
        }
        HashMap numName = (HashMap)returnData;
        String name = (String)numName.get("name");
        String number = (String)numName.get("number");
        DecpStepManager allDecpStepData = this.getOrCacheDecpStepData(null);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap2"});
        DecpStepData decpStepData = new DecpStepData(name, number);
        allDecpStepData.addStepData(decpStepData);
        this.rebuildTab(decpStepData.getNumber());
        this.getOrCacheDecpStepData(allDecpStepData);
        this.setInitDataByPreStep(decpStepData.getNumber());
    }

    private void setInitDataByPreStep(String currentStepNum) {
        DecpStepManager decpStepManager = this.getOrCacheDecpStepData(null);
        int stepIndex = decpStepManager.getStepIndex(currentStepNum);
        if (stepIndex > 0) {
            DecpStepData preStepData = decpStepManager.getStepDataByIndex(stepIndex - 1);
            ArrayList<Long> decpOrgIds = new ArrayList<Long>();
            List rowDataList = preStepData.getRowDataList();
            for (DecpRowData rowData : rowDataList) {
                if (!rowData.isHasNextStep() || rowData.getDecpOrgId() == null || rowData.getDecpOrgId().equals(0L)) continue;
                decpOrgIds.add(rowData.getDecpOrgId());
            }
            if (!decpOrgIds.isEmpty()) {
                IDataModel dataModel = this.getModel();
                dataModel.batchCreateNewEntryRow(ENTRY_ENTITY, decpOrgIds.size());
                for (int index = 0; index < decpOrgIds.size(); ++index) {
                    dataModel.setValue(ORDER_ORG, decpOrgIds.get(index), index);
                }
            }
        }
        this.lockOrderOrgColumn(-1);
    }

    public void decpStepEditCloseBack(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (returnData == null) {
            return;
        }
        HashMap numName = (HashMap)returnData;
        String tabName = (String)numName.get("name");
        String tabNumber = (String)numName.get("number");
        DecpStepManager allDecpStepData = this.getOrCacheDecpStepData(null);
        DecpStepData decpStepData = allDecpStepData.getStepDataByNumber(tabNumber);
        decpStepData.setName(tabName);
        this.getOrCacheDecpStepData(allDecpStepData);
        this.rebuildTab(tabNumber);
    }

    private void rebuildTab(String currentTabKey) {
        DecpStepManager allDecpStepData = this.getOrCacheDecpStepData(null);
        Tab tabEdit = (Tab)this.getControl("tabap");
        TabAp tabap = new TabAp();
        tabap.setKey("tabap");
        tabap.setGrow(0);
        for (DecpStepData tabData : allDecpStepData.getStepDataList()) {
            TabPageAp page = this.createNewTabPageAp(tabData.getNumber(), tabData.getName());
            tabap.getItems().add(page);
        }
        Map features = tabap.createControl();
        HashMap<String, String> busyTips = new HashMap<String, String>(1);
        busyTips.put("zh_CN", ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u4faf\u3002", (String)"EbShareSchemeEntityEditPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        features.put("busyTip", busyTips);
        this.getView().updateControlMetadata("tabap", features);
        tabEdit.selectTab(currentTabKey);
        tabEdit.activeTab(currentTabKey);
    }

    private DecpStepManager getOrCacheDecpStepData(DecpStepManager decpStepDatas) {
        if (decpStepDatas == null) {
            if (this.allStepData == null) {
                String cacheStr = this.getPageCache().get("DecpStepData");
                this.allStepData = cacheStr == null ? new DecpStepManager() : (DecpStepManager)SerializationUtils.deSerializeFromBase64((String)cacheStr);
            }
            return this.allStepData;
        }
        this.allStepData = decpStepDatas;
        this.getPageCache().put("DecpStepData", SerializationUtils.serializeToBase64((Object)decpStepDatas));
        return decpStepDatas;
    }

    private void releaseorgCloseBack(ClosedCallBackEvent event, String key) {
        if (event.getReturnData() == null) {
            return;
        }
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)event.getReturnData();
        boolean size = false;
        if (returnData == null || returnData.size() == 0) {
            return;
        }
        this.getModel().setValue(key, returnData.get(0).getPrimaryKeyValue());
    }

    private void decomposeorgCloseBack(ClosedCallBackEvent event, String key) {
        IDataModel model = this.getModel();
        if (event.getReturnData() == null) {
            return;
        }
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)event.getReturnData();
        if (returnData == null || returnData.size() == 0) {
            return;
        }
        this.checkBackDecpOrgOnSameBranch(returnData);
        String startRowStr = this.getPageCache().get(CACHE_DECOMPOSEORG_INDEX);
        int startRow = Integer.parseInt(startRowStr);
        this.getModel().setValue(key, returnData.get(0).getPrimaryKeyValue(), startRow);
        if (returnData.size() > 1) {
            for (int i = 1; i < returnData.size(); ++i) {
                int newIndex = model.insertEntryRow(ENTRY_ENTITY, startRow + i);
                this.getModel().setValue(key, returnData.get(i).getPrimaryKeyValue(), newIndex);
            }
        }
    }

    private void checkBackDecpOrgOnSameBranch(ListSelectedRowCollection returnData) {
        IModelCacheHelper iModelCacheHelper = this.getIModelCacheHelper();
        Long entityViewId = this.getEntityViewId();
        List orgIds = returnData.stream().map(row -> IDUtils.toLong((Object)row.getPrimaryKeyValue())).collect(Collectors.toList());
        Dimension dimension = iModelCacheHelper.getDimension(SysDimensionEnum.Entity.getNumber());
        List members = dimension.getMember(entityViewId, orgIds);
        HashSet<String> longNumbers = new HashSet<String>(16);
        for (Member member : members) {
            String currentLongNum = "!" + member.getLongNumber() + "!";
            for (String otherLongNum : longNumbers) {
                if (!currentLongNum.contains(otherLongNum) && !otherLongNum.contains(currentLongNum)) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u540c\u65f6\u9009\u62e9\u76f8\u540c\u5206\u652f\u4e0b\u7684\u6210\u5458\u3002", (String)"DecomposeSchemeEditPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            longNumbers.add(currentLongNum);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.lockPageByStatus();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (key.equals("model")) {
            this.dealModelChange(e);
        } else if (key.equals("bizctrlrange")) {
            this.dealBizCtrlRangeChange(e);
        } else if (key.equals(ORDER_ORG)) {
            this.dealOrderOrgChange(e);
        } else if (key.equals(HASNEXTSTEP)) {
            this.dealNextStepBoxChange(e);
        }
    }

    private void dealModelChange(PropertyChangedArgs e) {
        this.getModel().setValue("bizctrlrange", null);
    }

    private void dealOrderOrgChange(PropertyChangedArgs e) {
        if (this.isDoingOrderOrgChange()) {
            return;
        }
        String currentTabKey = this.getCurrentTabKey();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex1 = e.getChangeSet()[0].getRowIndex();
        if (currentTabKey.equals(STEP_FIRST)) {
            DynamicObjectCollection rows = this.getModel().getEntryEntity(ENTRY_ENTITY);
            DecpStepManager decpStepData = this.getOrCacheDecpStepData(null);
            for (int rowIndex = 0; rowIndex < rows.size(); ++rowIndex) {
                DynamicObject row = (DynamicObject)rows.get(rowIndex);
                if (rowIndex != rowIndex1) {
                    row.set(ORDER_ORG, newValue);
                }
                row.set(DECOMPOSE_ORG, null);
                row.set(HASNEXTSTEP, (Object)false);
            }
            this.getView().updateView(ENTRY_ENTITY);
            for (int stepIndex = 1; stepIndex < decpStepData.size(); ++stepIndex) {
                DecpStepData stepData = decpStepData.getStepDataByIndex(stepIndex);
                stepData.getRowDataList().clear();
            }
            this.getOrCacheDecpStepData(decpStepData);
        } else {
            this.getModel().setValue(DECOMPOSE_ORG, null);
        }
    }

    private void dealBizCtrlRangeChange(PropertyChangedArgs e) {
        DecpStepManager decpStepData = this.getOrCacheDecpStepData(null);
        if (decpStepData.size() > 0) {
            this.delDecpStep(0);
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (key.equals(DECOMPOSE_ORG)) {
            this.dealDecpOrgChange(e);
        }
    }

    private void dealDecpOrgChange(PropertyChangedArgs e) {
        Object oldValue = e.getChangeSet()[0].getOldValue();
        if (oldValue != null) {
            this.getModel().setValue(HASNEXTSTEP, (Object)false, e.getChangeSet()[0].getRowIndex());
        }
    }

    private void dealNextStepBoxChange(PropertyChangedArgs e) {
        boolean hasNextStep = (Boolean)e.getChangeSet()[0].getNewValue();
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
        Object decpOrg = this.getModel().getValue(DECOMPOSE_ORG, currentRowIndex);
        if (decpOrg == null) {
            return;
        }
        String currentTab = this.getCurrentTabKey();
        DecpStepManager decpStepManager = this.getOrCacheDecpStepData(null);
        int stepIndex = decpStepManager.getStepIndex(currentTab);
        if (decpStepManager.size() > stepIndex + 1) {
            if (hasNextStep) {
                this.addRowToNextStep(decpStepManager, stepIndex, decpOrg);
            } else {
                this.delRowOnNextSteps(decpStepManager, stepIndex, decpOrg);
            }
            this.getOrCacheDecpStepData(decpStepManager);
        }
    }

    private void addRowToNextStep(DecpStepManager decpStepManager, int stepIndex, Object decpOrg) {
        DecpStepData nextStepData = decpStepManager.getStepDataByIndex(stepIndex + 1);
        DecpRowData newRowData = new DecpRowData();
        newRowData.setOrderOrgId(Long.valueOf(((DynamicObject)decpOrg).getLong("id")));
        newRowData.setRowIndex(nextStepData.getRowDataList().size());
        nextStepData.getRowDataList().add(newRowData);
    }

    private void delRowOnNextSteps(DecpStepManager decpStepManager, int stepIndex, Object decpOrg) {
        if (decpStepManager.size() > stepIndex + 1) {
            HashSet<Long> orgIds = new HashSet<Long>();
            orgIds.add(((DynamicObject)decpOrg).getLong("id"));
            HashSet<Long> toDelOrgIds = new HashSet<Long>();
            for (int index = stepIndex + 1; index < decpStepManager.size(); ++index) {
                DecpStepData nextStepData = decpStepManager.getStepDataByIndex(index);
                Iterator iterator = nextStepData.getRowDataList().iterator();
                while (iterator.hasNext()) {
                    DecpRowData rowData = (DecpRowData)iterator.next();
                    if (!orgIds.contains(rowData.getOrderOrgId())) continue;
                    iterator.remove();
                    if (!rowData.isHasNextStep() || rowData.getDecpOrgId() == 0L) continue;
                    toDelOrgIds.add(rowData.getDecpOrgId());
                }
                orgIds.clear();
                orgIds.addAll(toDelOrgIds);
                toDelOrgIds.clear();
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("addentryrow".equals(operateKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                this.getModel().insertEntryRow(ENTRY_ENTITY, this.getModel().getEntryRowCount(ENTRY_ENTITY));
            } else {
                this.getModel().insertEntryRow(ENTRY_ENTITY, selectRows[selectRows.length - 1] + 1);
            }
        } else if ("save".equals(operateKey)) {
            this.beforeSave(args);
        }
    }

    private void beforeSave(BeforeDoOperationEventArgs args) {
        String currentTab = this.getCurrentTabKey();
        DecpStepManager decpStepManager = this.getOrCacheDecpStepData(null);
        if (this.checkedData()) {
            this.setCheckedData(false);
            this.setDataBeforeSave(decpStepManager);
        } else {
            DecpStepData stepData = decpStepManager.getStepDataByNumber(currentTab);
            this.selectEntityDataToModel(stepData);
            String checkInfo = this.verifyData(decpStepManager);
            if (StringUtils.isEmpty((String)checkInfo)) {
                List<String> checkBranchResult = this.checkContainBranch();
                if (!checkBranchResult.isEmpty()) {
                    CommonServiceHelper.showConfirmForm(checkBranchResult, (AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u6821\u9a8c\u4fe1\u606f", (String)"DecomposeSchemeListPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4fdd\u5b58\u65f6\u53ef\u80fd\u4f1a\u5bfc\u81f4\u5206\u89e3\u6570\u636e\u9057\u6f0f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DecomposeSchemeListPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]), (String)"continueSave");
                    args.setCancel(true);
                } else {
                    this.setDataBeforeSave(decpStepManager);
                }
                this.getOrCacheDecpStepData(decpStepManager);
            } else {
                args.setCancel(true);
                this.getView().showTipNotification(checkInfo);
            }
        }
    }

    private void setDataBeforeSave(DecpStepManager decpStepManager) {
        Long orderOrgId = ((DecpRowData)decpStepManager.getStepDataByIndex(0).getRowDataList().get(0)).getOrderOrgId();
        this.getModel().setValue("releaseorg", (Object)orderOrgId);
        this.getModel().setValue("rowsdata", (Object)SerializationUtils.toJsonString((Object)decpStepManager));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (DynamicObject rowObj : entryEntity) {
            rowObj.getDataEntityState().setBizChanged(2, true);
        }
        this.getModel().updateEntryCache(entryEntity);
    }

    public void afterLoadData(EventObject e) {
        this.initStepData();
    }

    private void initStepData() {
        String decpStepManager = (String)this.getModel().getValue("rowsdata");
        if (!StringUtils.isEmpty((String)decpStepManager)) {
            this.allStepData = (DecpStepManager)SerializationUtils.fromJsonString((String)decpStepManager, DecpStepManager.class);
            if (this.allStepData.size() > 0) {
                this.rebuildTab(this.allStepData.getStepDataByIndex(0).getNumber());
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap2"});
                this.getOrCacheDecpStepData(this.allStepData);
            }
        }
        this.getModel().setDataChanged(false);
    }

    private String verifyData(DecpStepManager decpStepManager) {
        String number = (String)this.getValue("number", null);
        String numbeCheckMes = NumberCheckUtils.checkNumberRule((String)number);
        if (StringUtils.isNotEmpty((String)numbeCheckMes)) {
            return numbeCheckMes;
        }
        List allStepData = decpStepManager.getStepDataList();
        if (allStepData.isEmpty()) {
            return ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u5206\u89e3\u6b65\u9aa4\u3002", (String)"DecomposeSchemeListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        int stepIndex = 0;
        for (DecpStepData stepData : allStepData) {
            DecpStepData nextStep = null;
            if (stepData.getRowDataList().isEmpty()) {
                return ResManager.loadResFormat((String)"\u6b65\u9aa4\uff1a%1 \u6570\u636e\u4e3a\u7a7a", (String)"DecomposeSchemeListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[]{stepData.getName()});
            }
            int index = 1;
            if (stepIndex < allStepData.size() - 1) {
                nextStep = (DecpStepData)allStepData.get(stepIndex + 1);
            }
            for (DecpRowData rowData : stepData.getRowDataList()) {
                if (rowData.getOrderOrgId() == null || 0L == rowData.getOrderOrgId()) {
                    return ResManager.loadResFormat((String)"\u6b65\u9aa4%1\u7b2c%2\u884c\u4e0b\u8fbe\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"DecomposeSchemeListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[]{stepData.getName(), index});
                }
                if (rowData.getDecpOrgId() == null || 0L == rowData.getDecpOrgId()) {
                    return ResManager.loadResFormat((String)"\u6b65\u9aa4\uff1a%1 \u7b2c%2\u884c\u5206\u89e3\u7ec4\u7ec7\u4e3a\u7a7a", (String)"DecomposeSchemeListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[]{stepData.getName(), index});
                }
                if (rowData.getChargePersonsId() == null || rowData.getChargePersonsId().isEmpty()) {
                    return ResManager.loadResFormat((String)"\u6b65\u9aa4\uff1a%1 \u7b2c%2\u884c\u8d23\u4efb\u4eba\u4e3a\u7a7a", (String)"DecomposeSchemeListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[]{stepData.getName(), index});
                }
                if (rowData.isHasNextStep()) {
                    boolean hasRefRow = false;
                    if (nextStep != null) {
                        for (DecpRowData rowData1 : nextStep.getRowDataList()) {
                            if (!rowData.getDecpOrgId().equals(rowData1.getOrderOrgId())) continue;
                            hasRefRow = true;
                            break;
                        }
                    }
                    if (!hasRefRow) {
                        return ResManager.loadResFormat((String)"\u6b65\u9aa4\uff1a%1 \u7b2c%2\u884c\u672a\u8bbe\u7f6e\u540e\u7eed\u5206\u89e3\u6b65\u9aa4", (String)"DecomposeSchemeListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[]{stepData.getName(), index});
                    }
                }
                ++index;
            }
            ++stepIndex;
        }
        return null;
    }

    private List<String> checkContainBranch() {
        DecpStepManager decpStepData = this.getOrCacheDecpStepData(null);
        List stepDataList = decpStepData.getStepDataList();
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Long bizCtrlRangeId = this.getBizCtrlRangeId();
        Map viewIds = BusinessModelServiceHelper.getViewIds((Long)bizCtrlRangeId);
        Long viewId = (Long)viewIds.get(SysDimensionEnum.Entity.getNumber());
        Dimension dimension = modelCacheHelper.getDimension(SysDimensionEnum.Entity.getNumber());
        ArrayList<String> result = new ArrayList<String>();
        for (DecpStepData stepData : stepDataList) {
            HashMap<Long, Set> orgIdMap = new HashMap<Long, Set>();
            for (DecpRowData row : stepData.getRowDataList()) {
                Set decpOrgIds = orgIdMap.computeIfAbsent(row.getOrderOrgId(), key -> new HashSet());
                decpOrgIds.add(row.getDecpOrgId());
            }
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : orgIdMap.entrySet()) {
                Long orderOrg = (Long)entry.getKey();
                Set decpOrgIds = (Set)entry.getValue();
                Member orderOrgMemb = dimension.getMember(viewId, orderOrg);
                List children = orderOrgMemb.getChildren();
                List decpOrgMember = dimension.getMember(viewId, (Collection)decpOrgIds);
                HashSet<String> allParentNums = new HashSet<String>();
                for (Member m : children) {
                    if (m == null) continue;
                    allParentNums.add(m.getNumber());
                }
                for (Member m : decpOrgMember) {
                    if (m == null) continue;
                    for (String pNum : m.getLongNumber().split("!")) {
                        allParentNums.remove(pNum);
                    }
                }
                if (allParentNums.isEmpty()) continue;
                sb.append(orderOrgMemb.getName()).append(',');
            }
            if (!StringUtils.isNotEmpty((String)sb.toString()) || sb.charAt(sb.length() - 1) != ',') continue;
            sb.deleteCharAt(sb.length() - 1);
            result.add(ResManager.loadResFormat((String)"\u6b65\u9aa4\uff1a%1\u4e2d\u4e0b\u8fbe\u7ec4\u7ec7[%2]\u7684\u5206\u89e3\u7ec4\u7ec7\u672a\u5305\u542b\u6240\u6709\u5206\u652f\u3002", (String)"DecomposeSchemeListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[]{stepData.getNumber(), sb.toString()}));
        }
        return result;
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String currentTabKey;
        int stepIndex;
        DecpStepManager decpStepData;
        DecpStepData nextStepData;
        super.beforeDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        if (entryName.equals(ENTRY_ENTITY) && (nextStepData = (decpStepData = this.getOrCacheDecpStepData(null)).getStepDataByIndex((stepIndex = decpStepData.getStepIndex(currentTabKey = this.getCurrentTabKey())) + 1)) != null) {
            int[] rowIndexs;
            for (int index : rowIndexs = e.getRowIndexs()) {
                DynamicObject decpOrg = (DynamicObject)this.getModel().getValue(DECOMPOSE_ORG, index);
                boolean hasNext = (Boolean)this.getModel().getValue(HASNEXTSTEP, index);
                if (!hasNext || decpOrg == null) continue;
                this.delRowOnNextSteps(decpStepData, stepIndex, decpOrg);
            }
            this.getOrCacheDecpStepData(decpStepData);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        int insertRow = e.getInsertRow();
        if (insertRow > -1) {
            Object preOrg = this.getModel().getValue(ORDER_ORG, insertRow - 1);
            if (preOrg != null) {
                this.setDoingOrderOrgChange(true);
                this.getModel().setValue(ORDER_ORG, preOrg, insertRow);
                this.setDoingOrderOrgChange(false);
            }
            this.lockOrderOrgColumn(insertRow);
        }
    }

    private List<String> getAllChildrens(String releaseorgNum, Set<String> otherDecpOrgNum, Long viewId) {
        ArrayList<String> result = new ArrayList<String>(16);
        if (StringUtils.isEmpty((String)releaseorgNum)) {
            return result;
        }
        List members = this.getIModelCacheHelper().getMember(SysDimensionEnum.Entity.getNumber(), viewId, releaseorgNum, RangeEnum.ALL_EXCLUDE.getIndex());
        List excludeMembs = this.getIModelCacheHelper().getMembers(SysDimensionEnum.Entity.getNumber(), viewId, otherDecpOrgNum);
        block0: for (Member member : members) {
            String longNumber = member.getLongNumber() + "!";
            for (Member excludeMemb : excludeMembs) {
                String excludeLongNumber = excludeMemb.getLongNumber() + "!";
                if (!longNumber.contains(excludeLongNumber) && !excludeLongNumber.contains(longNumber)) continue;
                continue block0;
            }
            result.add(member.getNumber());
        }
        return result;
    }

    public String getCurrentDimNumber(String controlKey) {
        String dimNum = "";
        if (ORDER_ORG.equals(controlKey) || DECOMPOSE_ORG.equals(controlKey)) {
            dimNum = SysDimensionEnum.Entity.getNumber();
        }
        return dimNum;
    }

    @Override
    public Long getModelId() {
        Long modelId = 0L;
        Object model = this.getModel().getValue("model");
        if (model == null || "".equals(model)) {
            return modelId;
        }
        modelId = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
        return modelId;
    }

    public Long getBizCtrlRangeId() {
        Long value = (Long)this.getValue("bizctrlrange", "id");
        return value;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.isEnableForm()) {
            this.getModel().setDataChanged(false);
        }
    }

    private void lockPageByStatus() {
        if (this.isEnableForm()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"advconap", "name", "model", "explain", "bizctrlrange"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_save"});
        }
    }

    private boolean isEnableForm() {
        String status = (String)this.getValue("enable", null);
        return "1".equals(status);
    }

    private Set<Long> getSplitOrgByScheme(long schemeId) {
        Set<Long> orgIds = new HashSet<Long>(16);
        if (schemeId == 0L) {
            return orgIds;
        }
        DynamicObjectCollection orgDys = QueryServiceHelper.query((String)"eb_bgdecompose", (String)"org", (QFilter[])new QFilter[]{new QFilter("decomposescheme", "=", (Object)schemeId)});
        if (orgDys != null && orgDys.size() > 0) {
            orgIds = orgDys.stream().map(dy -> dy.getLong("org")).collect(Collectors.toSet());
        }
        return orgIds;
    }

    private Boolean checkSplitStatus() {
        long schemeId = (Long)this.getModel().getDataEntity().getPkValue();
        Set<Long> orgIds = this.getSplitOrgByScheme(schemeId);
        Boolean isSplite = false;
        if (orgIds.size() > 0) {
            isSplite = true;
        }
        return isSplite;
    }

    public IModelCacheHelper getIModelCacheHelper() {
        return ModelCacheContext.getOrCreate((Long)this.getModelId());
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String lastTabKey;
        String tabKey = tabSelectEvent.getTabKey();
        if (tabKey.equals(lastTabKey = this.getOrCacheLastTabKey(null))) {
            return;
        }
        this.rebuildEntityData(tabKey, lastTabKey);
        this.getOrCacheLastTabKey(tabKey);
    }

    private void rebuildEntityData(String currentTabKey, String lastTabKey) {
        DecpStepManager decpStepData = this.getOrCacheDecpStepData(null);
        DecpStepData currentStep = decpStepData.getStepDataByNumber(currentTabKey);
        DecpStepData lastStep = decpStepData.getStepDataByNumber(lastTabKey);
        this.selectEntityDataToModel(lastStep);
        this.fillBackModelDataToEntity(currentStep);
        this.getOrCacheDecpStepData(decpStepData);
        this.lockOrderOrgColumn(-1);
    }

    private void lockOrderOrgColumn(int rowIndex) {
    }

    private void fillBackModelDataToEntity(DecpStepData stepData) {
        List rowDataList;
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData(ENTRY_ENTITY);
        if (stepData != null && (rowDataList = stepData.getRowDataList()).size() > 0) {
            dataModel.batchCreateNewEntryRow(ENTRY_ENTITY, rowDataList.size());
            dataModel.beginInit();
            for (int index = 0; index < rowDataList.size(); ++index) {
                DecpRowData decpRowData = (DecpRowData)rowDataList.get(index);
                dataModel.setValue(ORDER_ORG, (Object)decpRowData.getOrderOrgId(), index);
                dataModel.setValue(DECOMPOSE_ORG, (Object)decpRowData.getDecpOrgId(), index);
                dataModel.setValue(DECOMPOSE_PERSONS, (Object)decpRowData.getChargePersonsId().toArray(), index);
                dataModel.setValue(HASNEXTSTEP, (Object)decpRowData.isHasNextStep(), index);
            }
            dataModel.endInit();
            this.getView().updateView(ENTRY_ENTITY);
        }
    }

    private void selectEntityDataToModel(DecpStepData stepData) {
        if (stepData != null) {
            stepData.getRowDataList().clear();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
            int index = 0;
            for (DynamicObject rowObj : entryEntity) {
                DecpRowData decpRowData = new DecpRowData();
                DynamicObject orderOrg = rowObj.getDynamicObject(ORDER_ORG);
                DynamicObject decpOrg = rowObj.getDynamicObject(DECOMPOSE_ORG);
                DynamicObjectCollection decpUsers = rowObj.getDynamicObjectCollection(DECOMPOSE_PERSONS);
                if (orderOrg == null && decpOrg == null && (decpUsers == null || decpUsers.isEmpty())) continue;
                boolean hasNext = rowObj.getBoolean(HASNEXTSTEP);
                decpRowData.setDecpOrgId(Long.valueOf(decpOrg == null ? 0L : decpOrg.getLong("id")));
                decpRowData.setOrderOrgId(Long.valueOf(orderOrg == null ? 0L : orderOrg.getLong("id")));
                decpRowData.setChargePersonsId(decpUsers.stream().map(user -> user.getLong("fbasedataid_id")).collect(Collectors.toList()));
                decpRowData.setHasNextStep(hasNext);
                decpRowData.setRowIndex(index);
                decpRowData.setRowId(Long.valueOf(rowObj.getLong("id")));
                stepData.getRowDataList().add(decpRowData);
                ++index;
            }
        }
    }

    private String getOrCacheLastTabKey(String tabKey) {
        if (tabKey != null) {
            this.getPageCache().put("lastTabKey", tabKey);
        } else {
            tabKey = this.getPageCache().get("lastTabKey");
        }
        return tabKey;
    }
}

