/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.decomposescheme;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.applybill.SplitStatus;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.formplugin.decomposescheme.BgSplitSchemeUtil;
import kd.epm.eb.formplugin.decomposescheme.DecomposefilterContainerModelListPlugin;
import kd.epm.eb.model.utils.UserSelectUtil;

public class DecomposeSchemeListPlugin
extends DecomposefilterContainerModelListPlugin {
    private static final String COPYSIGN = "copy";

    public void initialize() {
        super.initialize();
        this.bizctrlrangeFilterKey = "bizctrlrange.number";
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opType = ((FormOperate)args.getSource()).getType();
        ListSelectedRowCollection rows = args.getListSelectedData();
        if ("delete".equals(opType)) {
            ArrayList<String> billNos = new ArrayList<String>(16);
            for (ListSelectedRow row : rows) {
                long pk = (Long)row.getPrimaryKeyValue();
                Boolean existsFlag = this.checkSplitStatus(pk);
                if (!existsFlag.booleanValue()) continue;
                billNos.add(row.getNumber());
            }
            if (billNos.size() > 0) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7f16\u53f7%1\u751f\u6210\u5206\u89e3\u5355\u5df2\u5206\u89e3\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"DecomposeSchemeListPlugin_3_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{billNos}));
            }
        } else if (COPYSIGN.equals(opType)) {
            this.copyScheme();
            args.setCancel(true);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter parameter = e.getParameter();
        parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
    }

    private void copyScheme() {
        BillList billListControl = this.getBillListControl();
        Map dynas = billListControl.getModel().loadReferenceDataBatch((DynamicObjectType)billListControl.getEntityType(), billListControl.getSelectedRows().getPrimaryKeyValues());
        if (dynas.size() == 0) {
            return;
        }
        Map<Long, Set<String>> allSchemeNumber = this.getAllSchemeNumber();
        Date now = TimeServiceHelper.now();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        DynamicObject userObj = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user");
        DynamicObject[] newObjs = new DynamicObject[dynas.size()];
        int count = 0;
        HashSet<String> numbers = new HashSet<String>(16);
        for (DynamicObject obj : dynas.values()) {
            DynamicObject cloneobj = (DynamicObject)OrmUtils.clone((IDataEntityBase)obj, (boolean)true, (boolean)true);
            String sourceNum = obj.getString("number");
            Long modelId = obj.getLong("model.id");
            String newNumber = this.getCopySchemeNum(allSchemeNumber, modelId, sourceNum);
            if (newNumber.length() > 50) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u590d\u5236\u540e\u7f16\u7801\u957f\u5ea6\u8d85\u8fc750\u4e2a\u5b57\u7b26\uff0c%1\u3002", (String)"DecomposeSchemeListPlugin_24_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{newNumber}));
            }
            cloneobj.set("number", (Object)newNumber);
            cloneobj.set("modifier", (Object)userObj);
            cloneobj.set("creator", (Object)userObj);
            cloneobj.set("createtime", (Object)now);
            cloneobj.set("modifytime", (Object)now);
            cloneobj.set("ishide", (Object)Character.valueOf('0'));
            newObjs[count] = cloneobj;
            numbers.add(newNumber);
            ++count;
        }
        SaveServiceHelper.save((DynamicObject[])newObjs);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f", (String)"DecomposeSchemeListPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        OperationLogUtil.log((String)this.getBizAppId(), (String)this.getView().getEntityId(), null, (String)COPYSIGN, (MultiLangEnumBridge)new MultiLangEnumBridge("\u590d\u5236", "DecomposeSchemeListPlugin_31", "epm-eb-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u7f16\u53f7%1$s\uff0c\u590d\u5236\u6210\u529f\u3002", "DecomposeSchemeListPlugin_59", "epm-eb-formplugin"), (String[])new String[]{((Object)numbers).toString()});
        billListControl.refresh();
    }

    private String getCopySchemeNum(Map<Long, Set<String>> allSchemeNumber, Long modelId, String sourceNum) {
        sourceNum = sourceNum + COPYSIGN;
        Set<String> existNums = allSchemeNumber.get(modelId);
        int beginIndex = 1;
        String matchRegex = sourceNum + "[1-9][0-9]*";
        if (existNums != null) {
            for (String num : existNums) {
                int index;
                if (!num.matches(matchRegex) || (index = Integer.parseInt(num.replace(sourceNum, ""))) < beginIndex) continue;
                beginIndex = index + 1;
            }
        }
        sourceNum = sourceNum + beginIndex;
        return sourceNum;
    }

    private Map<Long, Set<String>> getAllSchemeNumber() {
        DynamicObject[] dynamicObjects;
        HashMap<Long, Set<String>> result = new HashMap<Long, Set<String>>();
        for (DynamicObject dy : dynamicObjects = BusinessDataServiceHelper.load((String)"eb_decomposescheme", (String)"model.id,number", null)) {
            Long modelId = dy.getLong("model.id");
            String number = dy.getString("number");
            Set numbers = result.computeIfAbsent(modelId, key -> new HashSet(16));
            numbers.add(number);
        }
        return result;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (key.equals("tblimport")) {
            this.showImportForm();
        } else if (key.equals("tblexport")) {
            this.exportSchemes();
        } else if (key.equals("ishide")) {
            this.hideSchemes(true);
        } else if (key.equals("isvisible")) {
            this.hideSchemes(false);
        }
    }

    private void hideSchemes(boolean isHide) {
        BillList billList = this.getBillListControl();
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u884c", (String)"DecomposeSchemeListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        List schemeIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])schemeIds.toArray(), (DynamicObjectType)billList.getEntityType());
        HashSet<String> numbers = new HashSet<String>(load.length);
        for (DynamicObject object : load) {
            object.set("ishide", (Object)Character.valueOf(isHide ? (char)'1' : '0'));
            numbers.add(object.getString("number"));
        }
        SaveServiceHelper.save((DynamicObject[])load);
        billList.refresh();
        MultiLangEnumBridge opName = isHide ? new MultiLangEnumBridge("\u9690\u85cf", "DecomposeSchemeListPlugin_28", "epm-eb-formplugin") : new MultiLangEnumBridge("\u53d6\u6d88\u9690\u85cf", "DecomposeSchemeListPlugin_29", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = isHide ? new MultiLangEnumBridge("\u7f16\u53f7%1$s\uff0c\u9690\u85cf\u6210\u529f\u3002", "DecomposeSchemeListPlugin_60", "epm-eb-formplugin") : new MultiLangEnumBridge("\u7f16\u53f7%1$s\uff0c\u53d6\u6d88\u9690\u85cf\u6210\u529f\u3002", "DecomposeSchemeListPlugin_61", "epm-eb-formplugin");
        OperationLogUtil.log((String)this.getBizAppId(), (String)this.getView().getEntityId(), null, (String)COPYSIGN, (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, (String[])new String[]{((Object)numbers).toString()});
    }

    private void showImportForm() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_splitscheme_import");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "SchemeImport"));
        this.getView().showForm(formShowParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("SchemeImport") && (returnData = closedCallBackEvent.getReturnData()) != null && returnData.equals("ok")) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f", (String)"DecomposeSchemeListPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            BillList billList = this.getBillListControl();
            billList.refresh();
        }
    }

    private void exportSchemes() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u884c", (String)"DecomposeSchemeListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        List schemeIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])schemeIds.toArray(), (DynamicObjectType)billList.getEntityType());
        BgSplitSchemeUtil.exportSchemes(load, this.getView());
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        List pkIds;
        super.afterDoOperation(e);
        String type = ((AbstractOperate)e.getSource()).getOperateKey();
        if (type.equals("delete") && (pkIds = e.getOperationResult().getSuccessPkIds()) != null && pkIds.size() > 0) {
            List ids = pkIds.stream().map(id -> Long.parseLong(id.toString())).collect(Collectors.toList());
            ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
            filters.add(new QFilter("decomposescheme", "in", ids));
            DeleteServiceHelper.delete((String)"eb_bgdecompose", (QFilter[])filters.toArray(new QFilter[filters.size()]));
        }
    }

    private Set<Long> getSplitOrgByScheme(long schemeId) {
        Set<Long> orgIds = new HashSet<Long>(16);
        if (schemeId == 0L) {
            return orgIds;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("decomposescheme", "=", (Object)schemeId));
        filters.add(new QFilter("splitstatus", "=", (Object)SplitStatus.SPLITEND.getValue()));
        DynamicObjectCollection orgDys = QueryServiceHelper.query((String)"eb_bgdecompose", (String)"org", (QFilter[])filters.toArray(new QFilter[filters.size()]));
        if (orgDys != null && orgDys.size() > 0) {
            orgIds = orgDys.stream().map(dy -> dy.getLong("org")).collect(Collectors.toSet());
        }
        return orgIds;
    }

    private Boolean checkSplitStatus(long schemeId) {
        Set<Long> orgIds = this.getSplitOrgByScheme(schemeId);
        Boolean isSplite = false;
        if (orgIds.size() > 0) {
            isSplite = true;
        }
        return isSplite;
    }

    @Override
    public Long getModelId() {
        Long modelId = IDUtils.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"));
        if (IDUtils.isNotNull((Long)modelId)) {
            return modelId;
        }
        return 0L;
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        List modelIds = args.getSelectMainOrgIds();
        if (modelIds != null && modelIds.size() > 0) {
            Long newModelid = (Long)modelIds.get(0);
            String oldModelCache = this.getPageCache().get("KEY_MODEL_ID");
            if (newModelid != null && !newModelid.toString().equals(oldModelCache)) {
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)newModelid);
                this.getPageCache().put("KEY_MODEL_ID", newModelid.toString());
            }
        }
    }

    @Override
    protected String getModelIDFilterKey() {
        return "model.id";
    }

    @Override
    protected String getModelCacheKey() {
        return "KEY_MODEL_ID";
    }

    @Override
    protected String getModelFilterKey() {
        return "model.name";
    }
}

