/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.decomposescheme;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.applybill.DecpRowData;
import kd.epm.eb.common.applybill.DecpStepData;
import kd.epm.eb.common.applybill.DecpStepManager;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.excel.BgExcelWriter;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.NumberToTextConverter;

public class SplitSchemeImport
extends AbstractFormPlugin
implements UploadListener {
    private static Log log = LogFactory.getLog(SplitSchemeImport.class);
    protected boolean erroFlag = false;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btndownload", "btndwntemp"});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Button)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
            try {
                String file_url = this.getPageCache().get("file_url");
                if (file_url == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5bfc\u5165\u6570\u636e\u3002", (String)"ApproveRelatImport_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                List urls = (List)SerializationUtils.fromJsonString((String)file_url, List.class);
                ArrayList<String> errorInfo = new ArrayList<String>();
                if (urls.isEmpty()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5bfc\u5165\u6570\u636e\u3002", (String)"ApproveRelatImport_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                for (String url : urls) {
                    String[] reqParams = new URL(url).getQuery().split("&");
                    HashMap<String, String> map = new HashMap<String, String>(reqParams.length);
                    for (String param : reqParams) {
                        String[] p = param.split("=");
                        map.put(p[0], p[1]);
                    }
                    TempFileCacheDownloadable.Content content = fileCache.get((String)map.get("configKey"), (String)map.get("id"));
                    InputStream inputStream = content.getInputStream();
                    String fileName = content.getFilename();
                    try {
                        this.readFile(inputStream);
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                        String message = e.getMessage();
                        errorInfo.add(fileName + " : " + message);
                    }
                }
                if (errorInfo.size() > 0) {
                    this.showErrorInfo(errorInfo);
                }
                this.getView().returnDataToParent((Object)"ok");
                this.getView().close();
            }
            catch (Exception e) {
                log.error((Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        } else if (key.equals("btndwntemp")) {
            this.downTemplate();
        }
    }

    private void downTemplate() {
        BgExcelWriter excelWriter = BgExcelWriter.getInstance().readTemplateByClasspath("SplitScheme/SplitSchemeTemplate.xlsx");
        Workbook workbook = excelWriter.getWorkbook();
        Sheet sheet = workbook.getSheet("Sheet1");
        int lastRowNum = sheet.getLastRowNum();
        for (int rowIndex = 0; rowIndex < lastRowNum; ++rowIndex) {
            Row row = sheet.getRow(rowIndex);
            short lastCellNum = row.getLastCellNum();
            for (short colIndex = 0; colIndex < lastCellNum; colIndex = (short)(colIndex + 1)) {
                String cellValue;
                CellType cellType;
                Cell cell = row.getCell((int)colIndex);
                if (cell == null || (cellType = cell.getCellType()) != CellType.STRING || (cellValue = cell.getStringCellValue()) == null || !cellValue.startsWith("SplitSchemeTemplate")) continue;
                cellValue = this.getString(cellValue);
                cell.setCellValue(cellValue);
            }
        }
        String fileName = ResManager.loadKDString((String)"\u5206\u89e3\u65b9\u6848\u5bfc\u5165\u6a21\u677f.xlsx", (String)"SplitSchemeImport_26", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String url = excelWriter.getDownloadUrl(fileName);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
    }

    private String getString(String key) {
        String val = "";
        switch (key) {
            case "SplitSchemeTemplate_0": {
                val = ResManager.loadKDString((String)"PS:\n1\u3001\u7ea2\u8272\u6807\u8bc6\u9879\u4e3a\u5fc5\u586b\uff0c\u4e0d\u80fd\u6709\u7a7a\u884c\u3002\n2\u3001SCHEME_HEAD\u6807\u8bc6\u8868\u5934\u6570\u636e\uff0cSCHEME_STEPS\u6807\u8bc6\u5f00\u59cb\u8bfb\u53d6\u6b65\u9aa4\u6570\u636e\uff0cSCHEME_STEPEND\u6807\u8bc6\u6bcf\u4e2a\u6b65\u9aa4\u6570\u636e\u7684\u7ed3\u675f\uff0c\u6240\u4ee5\u4e0d\u8981\u6539\u52a8\u3002\n3\u3001\u5bfc\u51fa\u7684\u65b9\u6848\u6587\u4ef6\u53ef\u4ee5\u4f5c\u4e3a\u6a21\u677f\u76f4\u63a5\u8fdb\u884c\u5bfc\u5165\u3002", (String)key, (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "SplitSchemeTemplate_1": {
                val = ResManager.loadKDString((String)"\u7f16\u7801", (String)key, (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "SplitSchemeTemplate_2": {
                val = ResManager.loadKDString((String)"\u540d\u79f0", (String)key, (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "SplitSchemeTemplate_3": {
                val = ResManager.loadKDString((String)"\u4f53\u7cfb(\u7f16\u7801)", (String)key, (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "SplitSchemeTemplate_4": {
                val = ResManager.loadKDString((String)"\u4f53\u7cfb(\u540d\u79f0)", (String)key, (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "SplitSchemeTemplate_5": {
                val = ResManager.loadKDString((String)"\u72b6\u6001\uff080\u8868\u793a\u7981\u7528\uff0c1\u8868\u793a\u542f\u7528\uff09", (String)key, (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "SplitSchemeTemplate_6": {
                val = ResManager.loadKDString((String)"\u8bf4\u660e", (String)key, (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "SplitSchemeTemplate_7": {
                val = ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b(\u7f16\u7801)", (String)key, (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "SplitSchemeTemplate_8": {
                val = ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b(\u540d\u79f0)", (String)key, (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "SplitSchemeTemplate_9": {
                val = ResManager.loadKDString((String)"step1(\u5f53\u524d\u5355\u5143\u683c\u586b\u6b65\u9aa4\u7f16\u7801)", (String)key, (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "SplitSchemeTemplate_10": {
                val = ResManager.loadKDString((String)"\u7b2c\u4e00\u6b65(\u5f53\u524d\u5355\u5143\u683c\u586b\u6b65\u9aa4\u540d\u79f0)", (String)key, (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "SplitSchemeTemplate_11": {
                val = ResManager.loadKDString((String)"\u4e0b\u8fbe\u7ec4\u7ec7(\u7f16\u7801)", (String)key, (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "SplitSchemeTemplate_12": {
                val = ResManager.loadKDString((String)"\u4e0b\u8fbe\u7ec4\u7ec7(\u540d\u79f0)", (String)key, (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "SplitSchemeTemplate_13": {
                val = ResManager.loadKDString((String)"\u5206\u89e3\u7ec4\u7ec7(\u7f16\u7801)", (String)key, (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "SplitSchemeTemplate_14": {
                val = ResManager.loadKDString((String)"\u5206\u89e3\u7ec4\u7ec7(\u540d\u79f0)", (String)key, (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "SplitSchemeTemplate_15": {
                val = ResManager.loadKDString((String)"\u5206\u89e3\u8d1f\u8d23\u4eba(\u5de5\u53f7)", (String)key, (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "SplitSchemeTemplate_16": {
                val = ResManager.loadKDString((String)"\u5206\u89e3\u8d1f\u8d23\u4eba(\u540d\u79f0)", (String)key, (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "SplitSchemeTemplate_17": {
                val = ResManager.loadKDString((String)"\u6709\u4e0b\u4e00\u6b65\u5206\u89e3(true\u6807\u8bc6\u6709\uff0cfalse\u6807\u8bc6\u6ca1\u6709)", (String)key, (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            case "SplitSchemeTemplate_18": {
                val = ResManager.loadKDString((String)"\u7b2c\u4e8c\u6b65", (String)key, (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
        }
        return val;
    }

    private void showErrorInfo(List<String> errorInfo) {
        StringBuilder sb = new StringBuilder();
        for (String mess : errorInfo) {
            sb.append(mess);
            sb.append('\n');
        }
        this.getView().showMessage(ResManager.loadKDString((String)"\u5bfc\u5165\u5df2\u5b8c\u6210\uff0c\u4f46\u5b58\u5728\u5bfc\u5165\u5931\u8d25\u7684\u6587\u4ef6\u3002", (String)"SplitSchemeImport_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
    }

    private void readFile(InputStream inputStream) {
        Workbook sheets = this.toXsl(inputStream);
        Sheet sheet = sheets.getSheetAt(0);
        this.toObj(sheet);
    }

    private Workbook toXsl(InputStream inputStream) {
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)inputStream);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u4ec5\u652f\u6301Excel\u683c\u5f0f\u6587\u6863\u3002", (String)"SplitSchemeImport_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return workbook;
    }

    private boolean toObj(Sheet sheet) {
        DynamicObject dynamicObject = this.readHead(sheet);
        Long modelId = dynamicObject.getLong("model");
        Long bizCtrlRangeId = dynamicObject.getLong("bizctrlrange");
        Map viewIds = BusinessModelServiceHelper.getViewIds((Long)bizCtrlRangeId);
        Long viewId = (Long)viewIds.get(SysDimensionEnum.Entity.getNumber());
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        DecpStepManager stepManager = this.readStepData(sheet, modelCacheHelper, viewId);
        Long firstStepOrderOrg = this.checkFirstStepOrderOrg(stepManager);
        dynamicObject.set("releaseorg", (Object)firstStepOrderOrg);
        dynamicObject.set("rowsdata", (Object)SerializationUtils.toJsonString((Object)stepManager));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5bfc\u5165", "SplitSchemeImport_27", "epm-eb-formplugin");
        MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u7f16\u53f7\uff1a%1$s\uff0c\u5bfc\u5165\u6210\u529f\u3002", "SplitSchemeImport_28", "epm-eb-formplugin");
        OperationLogUtil.log((String)this.getView().getFormShowParameter().getAppId(), (String)dynamicObject.getDataEntityType().getName(), null, (String)"import", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[]{dynamicObject.getString("number")});
        return true;
    }

    private Long checkFirstStepOrderOrg(DecpStepManager stepManager) {
        Long orgId = null;
        DecpStepData stepDataByIndex = stepManager.getStepDataByIndex(0);
        List rowDataList = stepDataByIndex.getRowDataList();
        for (DecpRowData rowData : rowDataList) {
            if (orgId == null) {
                orgId = rowData.getOrderOrgId();
                continue;
            }
            if (orgId.equals(rowData.getOrderOrgId())) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u7b2c\u4e00\u4e2a\u6b65\u9aa4\u4e2d\uff0c\u4e0b\u8fbe\u7ec4\u7ec7\u4e0d\u4e00\u81f4\u3002", (String)"SplitSchemeImport_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return orgId;
    }

    private DecpStepManager readStepData(Sheet sheet, IModelCacheHelper modelCacheHelper, Long viewId) {
        int matchIndex = this.matchSign(sheet, 0, "SCHEME_STEPS");
        if (matchIndex == -1) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u6b65\u9aa4\u6807\u8bc6%1\u672a\u627e\u5230\u3002", (String)"SplitSchemeImport_4_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{"SCHEME_STEPS"}));
        }
        int stepCount = 0;
        int lastRowNum = sheet.getLastRowNum();
        int relaLastRowNum = 0;
        for (int i = lastRowNum; i > 0; --i) {
            Row row = sheet.getRow(i);
            Cell cell = row.getCell(0);
            CellType cellType = cell.getCellType();
            if (cellType == null || cellType == CellType.BLANK) continue;
            relaLastRowNum = i;
            break;
        }
        DecpStepManager stepManager = new DecpStepManager();
        while (matchIndex < relaLastRowNum) {
            DecpStepData stepData = this.readStepHead(sheet, matchIndex, ++stepCount);
            matchIndex += 2;
            matchIndex = this.readStepRowData(sheet, stepData, matchIndex, modelCacheHelper, viewId);
            if (stepData.getRowDataList().size() == 0) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u6b65\u9aa4\u201c%1\u201d\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SplitSchemeImport_5", (String)"epm-eb-formplugin", (Object[])new Object[]{stepData.getNumber()}));
            }
            stepManager.addStepData(stepData);
        }
        return stepManager;
    }

    private int readStepRowData(Sheet sheet, DecpStepData stepData, int beginIndex, IModelCacheHelper modelCacheHelper, Long viewId) {
        Row row;
        int lastRowNum = sheet.getLastRowNum();
        ++beginIndex;
        HashSet<String> orgNumbs = new HashSet<String>(16);
        HashSet<String> userNumbs = new HashSet<String>(16);
        ArrayList<DecpStepRowData> rowDatas = new ArrayList<DecpStepRowData>();
        while (beginIndex <= lastRowNum && !this.isStepEndRow(row = sheet.getRow(beginIndex))) {
            if (row == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u6b65\u9aa4%1\u83b7\u53d6\u5230\u7a7a\u884c\u3002", (String)"SplitSchemeImport_6", (String)"epm-eb-formplugin", (Object[])new Object[]{stepData.getNumber()}));
            }
            DecpStepRowData decpStepRowData = this.readStepRowData(row);
            orgNumbs.add(decpStepRowData.getDecpOrgNum());
            orgNumbs.add(decpStepRowData.getOrderOrgNum());
            userNumbs.addAll(decpStepRowData.getUsersNum());
            rowDatas.add(decpStepRowData);
            ++beginIndex;
        }
        Map<String, Long> members = modelCacheHelper.getMembers(SysDimensionEnum.Entity.getNumber(), viewId, orgNumbs).stream().collect(Collectors.toMap(member -> member.getNumber(), member -> member.getId()));
        Map userObjs = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", userNumbs)});
        HashMap users = new HashMap(userObjs.size());
        userObjs.values().forEach(user -> users.put(user.getString("number"), user.getLong("id")));
        for (DecpStepRowData rowData : rowDatas) {
            Long decpOrgMemberId = members.get(rowData.getDecpOrgNum());
            if (decpOrgMemberId == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u672a\u627e\u5230\u7f16\u7801\u4e3a%1\u7684\u7ec4\u7ec7\u6210\u5458\u3002", (String)"SplitSchemeImport_7", (String)"epm-eb-formplugin", (Object[])new Object[]{rowData.getDecpOrgNum()}));
            }
            Long orderOrgMemberId = members.get(rowData.getOrderOrgNum());
            if (orderOrgMemberId == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u672a\u627e\u5230\u7f16\u7801\u4e3a%1\u7684\u7ec4\u7ec7\u6210\u5458\u3002", (String)"SplitSchemeImport_7", (String)"epm-eb-formplugin", (Object[])new Object[]{rowData.getOrderOrgNum()}));
            }
            List<String> usersNum = rowData.getUsersNum();
            ArrayList<Long> usersId = new ArrayList<Long>(usersNum.size());
            for (String userNum : usersNum) {
                Long userId = (Long)users.get(userNum);
                if (userId == null) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u7528\u6237%1\u4e0d\u5b58\u5728\u3002", (String)"SplitSchemeImport_8", (String)"epm-eb-formplugin", (Object[])new Object[]{userNum}));
                }
                usersId.add(userId);
            }
            DecpRowData decpRowData = new DecpRowData();
            decpRowData.setOrderOrgId(orderOrgMemberId);
            decpRowData.setDecpOrgId(decpOrgMemberId);
            decpRowData.setChargePersonsId(usersId);
            decpRowData.setHasNextStep(rowData.isHasNext());
            stepData.getRowDataList().add(decpRowData);
        }
        return beginIndex;
    }

    private boolean isStepEndRow(Row row) {
        if (row == null) {
            return false;
        }
        Cell cell = row.getCell(0);
        String stringCellValue = this.getStringValue(cell);
        return "SCHEME_STEPEND".equals(stringCellValue);
    }

    private DecpStepRowData readStepRowData(Row row) {
        int rowNum = row.getRowNum() + 1;
        Cell cell = row.getCell(0);
        String orderOrgNum = this.getStringValue(cell);
        if (StringUtils.isEmpty((CharSequence)orderOrgNum)) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u4e0b\u8fbe\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"SplitSchemeImport_9", (String)"epm-eb-formplugin", (Object[])new Object[]{rowNum}));
        }
        cell = row.getCell(2);
        String splitOrgNum = this.getStringValue(cell);
        if (StringUtils.isEmpty((CharSequence)splitOrgNum)) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u5206\u89e3\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"SplitSchemeImport_10", (String)"epm-eb-formplugin", (Object[])new Object[]{rowNum}));
        }
        cell = row.getCell(4);
        String userNum = this.getStringValue(cell);
        ArrayList<String> userNums = null;
        if (!StringUtils.isEmpty((CharSequence)userNum)) {
            String[] userNumbers = userNum.split(",");
            userNums = new ArrayList<String>(userNumbers.length);
            for (String num : userNumbers) {
                if (!StringUtils.isNotEmpty((CharSequence)num)) continue;
                userNums.add(num);
            }
        }
        if (userNums == null || userNums.isEmpty()) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u4e0b\u5206\u89e3\u8d1f\u8d23\u4eba\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"SplitSchemeImport_11", (String)"epm-eb-formplugin", (Object[])new Object[]{rowNum}));
        }
        cell = row.getCell(6);
        String hasNext = this.getStringValue(cell);
        if (StringUtils.isEmpty((CharSequence)hasNext) || !hasNext.equalsIgnoreCase("true") && !hasNext.equalsIgnoreCase("false")) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u201c\u6709\u4e0b\u4e00\u6b65\u5206\u89e3\u201d\u6807\u8bc6\u9519\u8bef\u3002", (String)"SplitSchemeImport_12", (String)"epm-eb-formplugin", (Object[])new Object[]{rowNum}));
        }
        DecpStepRowData decpStepRowData = new DecpStepRowData(orderOrgNum, splitOrgNum, userNums, Boolean.parseBoolean(hasNext));
        return decpStepRowData;
    }

    private DecpStepData readStepHead(Sheet sheet, int matchIndex, int stepIndex) {
        Row row;
        if ((row = sheet.getRow(++matchIndex)) == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u83b7\u53d6\u7b2c%1\u6b65\u9aa4\u7f16\u7801\u540d\u79f0\u4fe1\u606f\u884c\u5931\u8d25\u3002", (String)"SplitSchemeImport_13", (String)"epm-eb-formplugin", (Object[])new Object[]{stepIndex}));
        }
        Cell cell = row.getCell(0);
        String number = this.getStringValue(cell);
        if (this.checkStepNum(number)) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u6b65\u9aa4\u7f16\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"SplitSchemeImport_14", (String)"epm-eb-formplugin", (Object[])new Object[]{stepIndex}));
        }
        cell = row.getCell(1);
        String name = this.getStringValue(cell);
        if (name == null || name.length() > 50) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u6b65\u9aa4\u540d\u79f0\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"SplitSchemeImport_15", (String)"epm-eb-formplugin", (Object[])new Object[]{stepIndex}));
        }
        DecpStepData stepData = new DecpStepData(name, number);
        return stepData;
    }

    private boolean checkStepNum(String stepNum) {
        return stepNum == null || !stepNum.matches("step[0-9]+") || stepNum.length() > 50;
    }

    private DynamicObject readHead(Sheet sheet) {
        String status;
        Cell cell;
        String number;
        int beginIndex = this.matchSign(sheet, 0, "SCHEME_HEAD");
        if (beginIndex == -1) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u627e\u4e0d\u5230\u8868\u5934\u6807\u8bc6%1\u3002", (String)"SplitSchemeImport_16_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{"SCHEME_HEAD"}));
        }
        Row row = sheet.getRow(beginIndex + 2);
        if (row == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u8868\u5934\u4fe1\u606f\u884c\u4e0d\u80fd\u4e3a\u7a7a\uff1a\u201c%1\u201d\u3002", (String)"SplitSchemeImport_17_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{beginIndex}));
        }
        DynamicObject dyObj = BusinessDataServiceHelper.newDynamicObject((String)"eb_decomposescheme");
        int colIndex = 0;
        if (StringUtils.isEmpty((CharSequence)(number = this.getStringValue(cell = row.getCell(colIndex++))))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"SplitSchemeImport_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String checkNumberRule = NumberCheckUtils.checkNumberRule((String)number);
        if (StringUtils.isNotEmpty((CharSequence)checkNumberRule)) {
            throw new KDBizException(checkNumberRule);
        }
        dyObj.set("number", (Object)number);
        cell = row.getCell(colIndex++);
        String name = this.getStringValue(cell);
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"SplitSchemeImport_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (name.length() > 50) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u5141\u8bb8\u8d85\u8fc750\u4e2a\u5b57\u7b26\u3002", (String)"SplitSchemeImport_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        dyObj.set("name", (Object)name);
        cell = row.getCell(colIndex);
        String modelNum = this.getStringValue(cell);
        if (StringUtils.isEmpty((CharSequence)modelNum)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"SplitSchemeImport_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObject modelObj = QueryServiceHelper.queryOne((String)"epm_model", (String)"id", (QFilter[])new QFilter[]{new QFilter("shownumber", "=", (Object)modelNum), new QFilter("reporttype", "=", (Object)ApplicationTypeEnum.BGMD.getIndex())});
        if (modelObj == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%1 \u7684\u4f53\u7cfb\u4e0d\u5b58\u5728\u3002", (String)"SplitSchemeImport_22", (String)"epm-eb-formplugin", (Object[])new Object[]{modelNum}));
        }
        dyObj.set("model", (Object)modelObj.getLong("id"));
        if (QueryServiceHelper.exists((String)"eb_decomposescheme", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter("model", "=", (Object)modelObj.getLong("id"))})) {
            throw new KDBizException(ResManager.loadResFormat((String)"%1\u4f53\u7cfb\u4e0b\u5df2\u5b58\u5728\u7f16\u7801\u4e3a%2\u7684\u65b9\u6848\u3002", (String)"SplitSchemeImport_23_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{modelNum, number}));
        }
        colIndex += 2;
        if (StringUtils.isEmpty((CharSequence)(status = this.getStringValue(cell = row.getCell(colIndex++)))) || !status.equals("0") && !status.equals("1")) {
            status = "0";
        }
        dyObj.set("enable", (Object)status);
        cell = row.getCell(colIndex++);
        String explain = this.getStringValue(cell);
        dyObj.set("explain", (Object)explain);
        cell = row.getCell(colIndex++);
        String bizCtrlRangeNum = this.getStringValue(cell);
        if (StringUtils.isEmpty((CharSequence)bizCtrlRangeNum)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"SplitSchemeImport_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Long modelId = modelObj.getLong("id");
        DynamicObject bizCtrlRangeObj = QueryServiceHelper.queryOne((String)"eb_businessmodel", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bizCtrlRangeNum), new QFilter("model", "=", (Object)modelId)});
        if (bizCtrlRangeObj == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%1 \u7684\u4e1a\u52a1\u6a21\u578b\u4e0d\u5b58\u5728\u3002", (String)"SplitSchemeImport_25", (String)"epm-eb-formplugin", (Object[])new Object[]{bizCtrlRangeNum}));
        }
        dyObj.set("bizctrlrange", (Object)bizCtrlRangeObj.getLong("id"));
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Date now = TimeServiceHelper.now();
        dyObj.set("creator", (Object)userId);
        dyObj.set("modifier", (Object)userId);
        dyObj.set("createtime", (Object)now);
        dyObj.set("modifytime", (Object)now);
        return dyObj;
    }

    private String getStringValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        if (CellType.STRING.equals((Object)cell.getCellType())) {
            return cell.getStringCellValue().trim();
        }
        if (CellType.NUMERIC.equals((Object)cell.getCellType())) {
            return NumberToTextConverter.toText((double)cell.getNumericCellValue()).trim();
        }
        if (CellType.BOOLEAN.equals((Object)cell.getCellType())) {
            return Boolean.toString(cell.getBooleanCellValue());
        }
        return "";
    }

    private int matchSign(Sheet firstSheet, int beginRowIndex, String sing) {
        int matchIndex = -1;
        int lastRowNum = firstSheet.getLastRowNum();
        while (beginRowIndex <= lastRowNum) {
            String number;
            Cell cell;
            Row row = firstSheet.getRow(beginRowIndex);
            if (row != null && (cell = row.getCell(0)) != null && (number = cell.getStringCellValue()) != null && number.equals(sing)) {
                matchIndex = beginRowIndex;
                break;
            }
            ++beginRowIndex;
        }
        return matchIndex;
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        String file_url = this.getPageCache().get("file_url");
        List urls = null;
        urls = file_url == null ? new ArrayList(10) : (List)SerializationUtils.fromJsonString((String)file_url, List.class);
        for (Object url : evt.getUrls()) {
            urls.add((String)((Map)url).get("url"));
        }
        if (urls.size() > 0) {
            this.getPageCache().put("file_url", SerializationUtils.toJsonString(urls));
        }
    }

    public void afterRemove(UploadEvent evt) {
        Object[] objects;
        String file_url = this.getPageCache().get("file_url");
        if (file_url == null) {
            return;
        }
        List urls = (List)SerializationUtils.fromJsonString((String)file_url, List.class);
        for (Object object : objects = evt.getUrls()) {
            String url = (String)((Map)object).get("url");
            urls.remove(url);
        }
        this.getPageCache().put("file_url", SerializationUtils.toJsonString((Object)urls));
    }

    private static class DecpStepRowData {
        private String orderOrgNum;
        private String decpOrgNum;
        private List<String> usersNum;
        private boolean hasNext;

        public String getOrderOrgNum() {
            return this.orderOrgNum;
        }

        public String getDecpOrgNum() {
            return this.decpOrgNum;
        }

        public List<String> getUsersNum() {
            return this.usersNum;
        }

        public boolean isHasNext() {
            return this.hasNext;
        }

        public DecpStepRowData(String orderOrgNum, String decpOrgNum, List<String> usersNum, boolean hasNext) {
            this.orderOrgNum = orderOrgNum;
            this.decpOrgNum = decpOrgNum;
            this.usersNum = usersNum;
            this.hasNext = hasNext;
        }
    }
}

