/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.enums.dimensionEnums.MemberFunctionPermEnum;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.cube.dimension.entitys.DimManagerInfo;
import kd.epm.eb.formplugin.dimension.action.IAction;
import kd.epm.eb.formplugin.sonmodel.MainSubAbstractFormPlugin;
import kd.epm.eb.model.permission.MemberPermHelper;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDimFormPlugin
extends MainSubAbstractFormPlugin {
    public static final Log log = LogFactory.getLog(AbstractDimFormPlugin.class);
    protected static final String CACHE_MODEL_ADMIN = "isModelAdmin";

    protected boolean memberPermCheck(String actionKey, @NotNull DimManagerInfo dimInfo) {
        if (this.isModelAdmin(dimInfo)) {
            return true;
        }
        MemberFunctionPermEnum memberPermEnum = MemberFunctionPermEnum.getMemberPermEnum((String)actionKey);
        if (memberPermEnum == null) {
            return true;
        }
        if (!this.checkDimPermission(memberPermEnum.getFunctionKey(), dimInfo.getDimension().getNumber(), dimInfo.getMember().getNumber(), dimInfo.getViewId())) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u60a8\u6ca1\u6709%1\u6210\u5458\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"DimensionManagerList_56", (String)"epm-eb-formplugin", (Object[])new Object[]{memberPermEnum.getFunctionName()}));
            return false;
        }
        return true;
    }

    protected boolean isModelAdmin(@NotNull DimManagerInfo dimInfo) {
        String cache = this.getPageCache().get(CACHE_MODEL_ADMIN);
        if (cache != null) {
            return "1".equals(cache);
        }
        boolean admin = MemberPermHelper.ifUserHasRootPermByModel((Long)this.getUserId(), (Long)dimInfo.getModel().getId());
        if (admin) {
            this.getPageCache().put(CACHE_MODEL_ADMIN, "1");
        }
        return admin;
    }

    protected void executeAction(@NotNull String actionKey, boolean hasDoAction, Object ... actionParams) {
        IAction action = this.getAction(actionKey, this.getDimManagerInfo());
        if (action == null) {
            return;
        }
        action.setActionKey(actionKey);
        action.setActionParams(actionParams);
        this.executeAction(action, hasDoAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeAction(@NotNull IAction action, boolean hasDoAction) {
        LogStats stats = new LogStats("budget-log : ");
        stats.add("begin-" + action.getActionKey());
        action.setStats(stats);
        try {
            if (hasDoAction) {
                this.executeAction(action);
            } else {
                action.beforeAction();
                if (!action.isCallBack() && action.isBeforeAction()) {
                    this.executeAction(action);
                }
            }
        }
        finally {
            stats.addInfo("end-" + action.getActionKey());
            log.info(stats.toString());
        }
    }

    protected void executeAction(@NotNull String actionKey) {
        this.executeAction(actionKey, false, new Object[0]);
    }

    protected void executeAction(@NotNull IAction action) {
        try {
            action.doAction();
        }
        finally {
            action.afterAction();
        }
    }

    @Override
    protected abstract DimManagerInfo getDimManagerInfo();

    protected abstract IAction getAction(String var1, DimManagerInfo var2);
}

