/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.utils.TreeEntryEntityUtils;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.ModelCacheServiceHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;

public abstract class AbstractDimensionMemberTreeSingleF7Plugin
extends AbstractFormPlugin {
    private static final String ROWLIST = "rowlist";
    private static final String FOCUS = "focus";

    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        ArrayList<QFilter> dimFilter = new ArrayList<QFilter>(16);
        this.setDimFilter(dimFilter);
        this.beforeInitTree(dimFilter);
        this.initTree(dimFilter);
        this.setDimensionCombo();
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok", "imageup", "imagedown"});
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(searchEnterEvent -> {
            if (searchEnterEvent.getText() != null && !"".equals(searchEnterEvent.getText())) {
                this.searchMember(searchEnterEvent.getText().toLowerCase().trim());
            } else {
                this.getPageCache().put(ROWLIST, null);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"AbstractDimensionMemberTreeSingleF7Plugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            this.setReturnDataToParent();
        }
        if ("imageup".equals(key) || "imagedown".equals(key)) {
            String serial = this.getPageCache().get(ROWLIST);
            if (StringUtils.isEmpty((String)serial)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u641c\u7d22\u9700\u8981\u7684\u5185\u5bb9\u3002", (String)"AbstractDimensionMemberTreeSingleF7Plugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            List list = (List)ObjectSerialUtil.deSerializedBytes((String)serial);
            if (list == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u641c\u7d22\u9700\u8981\u7684\u5185\u5bb9\u3002", (String)"AbstractDimensionMemberTreeSingleF7Plugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            serial = this.getPageCache().get(FOCUS);
            int focusrow = (Integer)ObjectSerialUtil.deSerializedBytes((String)serial);
            if ("imageup".equals(key)) {
                if ((focusrow = ((Integer)list.get(list.indexOf(focusrow) - 1)).intValue()) == -1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"AbstractDimensionMemberTreeSingleF7Plugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else if ("imagedown".equals(key) && (focusrow = ((Integer)list.get(list.indexOf(focusrow) + 1)).intValue()) == -1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"AbstractDimensionMemberTreeSingleF7Plugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put(FOCUS, ObjectSerialUtil.toByteSerialized((Object)focusrow));
            int[] eids = TreeEntryEntityUtils.focus((IDataModel)this.getModel(), (int)focusrow);
            TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl("treeentryentity");
            treeEntry.expandOne(eids);
            treeEntry.selectRows(focusrow);
        }
    }

    private void initTree(List<QFilter> dimFilter) {
        DynamicObjectCollection memberColls = this.getDimDynamiObjectCollection(dimFilter);
        String entity = this.getDimensionMemberTreeModel();
        Map<Long, String> dimension = this.getNeedDimensionMap();
        boolean iscurrency = this.getDimensionNumber().equalsIgnoreCase(SysDimensionEnum.Currency.getNumber());
        TreeNode rootTreeNode = this.buildTree(memberColls, iscurrency, dimension);
        this.initTreeEntryentity(rootTreeNode);
        this.expandTree(entity);
    }

    private void searchMember(String text) {
        ArrayList<Integer> list = new ArrayList<Integer>(16);
        list.add(-1);
        DynamicObjectCollection obj = this.getModel().getEntryEntity("treeentryentity");
        int i = 0;
        for (DynamicObject o : obj) {
            if ((o.getString("name") + o.getString("number")).toLowerCase().contains(text.toLowerCase())) {
                list.add(i);
            }
            ++i;
        }
        list.add(-1);
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl("treeentryentity");
        if (list.size() <= 2) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"AbstractDimensionMemberTreeSingleF7Plugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(ROWLIST, ObjectSerialUtil.toByteSerialized(list));
        int focusrow = (Integer)list.get(1);
        this.getPageCache().put(FOCUS, ObjectSerialUtil.toByteSerialized((Object)focusrow));
        int[] eids = TreeEntryEntityUtils.focus((IDataModel)this.getModel(), (int)focusrow);
        treeEntry.collapse(0);
        treeEntry.expandOne(eids);
        treeEntry.selectRows(focusrow);
    }

    private void setReturnDataToParent() {
        DynamicObject entryEntityRow = this.getEntryEntityRow();
        Object data = this.setReturnData(entryEntityRow);
        if (this.selectNotLeaf()) {
            this.getView().returnDataToParent(data);
            this.getView().close();
        } else if (SysDimensionEnum.Entity.getNumber().equalsIgnoreCase(this.getDimensionNumber())) {
            this.getView().returnDataToParent(data);
            this.getView().close();
        } else if (entryEntityRow.getBoolean("isleaf")) {
            this.getView().returnDataToParent(data);
            this.getView().close();
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u660e\u7ec6\u8282\u70b9", (String)"AbstractDimensionMemberTreeSingleF7Plugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    protected abstract Object setReturnData(DynamicObject var1);

    private String getDimensionNumber() {
        String dimNum = this.setDimNum();
        return dimNum;
    }

    protected DynamicObject getEntryEntityRow() {
        int index = this.getModel().getEntryCurrentRowIndex("treeentryentity");
        if (index == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u6839\u8282\u70b9", (String)"AbstractDimensionMemberTreeSingleF7Plugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return this.getModel().getEntryRowEntity("treeentryentity", index);
    }

    private void expandTree(String entity) {
        int count;
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        treeEntryGrid.setCollapse(false);
        if ((entity.equals("epm_entitymembertree") || entity.equals("epm_accountmembertree") || entity.equals("epm_changetypemembertree")) && (count = this.getModel().getEntryRowCount("treeentryentity")) > 1) {
            int[] col = this.getModel().getEntryNextRows("treeentryentity", 1, true);
            IClientViewProxy po = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            po.invokeControlMethod("treeentryentity", "collapseAllNode", new Object[]{col});
        }
    }

    private void initTreeEntryentity(TreeNode rootNode) {
        DynamicObjectCollection treeentryentity = this.getModel().getEntryEntity("treeentryentity");
        this.setTreeEntryEntity(rootNode, treeentryentity);
    }

    private void setTreeEntryEntity(TreeNode treeNode, DynamicObjectCollection treeentryentity) {
        if (treeNode.getChildrenMap() == null) {
            return;
        }
        for (TreeNode treeNode1 : treeNode.getChildrenMap().values()) {
            DynamicObject dynamicObject = treeNode1.getDynamicObject();
            DynamicObject entityDy = treeentryentity.addNew();
            entityDy.set("id", (Object)dynamicObject.getLong("id"));
            entityDy.set("pid", (Object)dynamicObject.getLong("parent"));
            entityDy.set("number", dynamicObject.get("number"));
            entityDy.set("name", dynamicObject.get("name"));
            entityDy.set("memberid", dynamicObject.get("id"));
            entityDy.set("isleaf", dynamicObject.get("isleaf"));
            entityDy.set("dimension", dynamicObject.get("dimension"));
            this.setTreeEntryEntity(treeNode1, treeentryentity);
        }
    }

    private TreeNode buildTree(DynamicObjectCollection memberColls, boolean iscurrency, Map<Long, String> dimension) {
        int rows = memberColls.size();
        HashMap<Long, TreeNode> idNodeMap = new HashMap<Long, TreeNode>(16);
        for (int index = 0; index < rows; ++index) {
            DynamicObject memberObject = (DynamicObject)memberColls.get(index);
            boolean isleaf = (Boolean)memberObject.get("isleaf");
            long id = memberObject.getLong("id");
            if (iscurrency && "PC".equals(memberObject.getString("number"))) {
                --rows;
                continue;
            }
            TreeNode treeNode = idNodeMap.get(id);
            if (treeNode == null) {
                treeNode = new TreeNode(id, isleaf);
            }
            if (treeNode.isIsleaf()) {
                treeNode.setChildrenMap(null);
            }
            treeNode.init(memberObject, idNodeMap);
        }
        if (!this.isNeedCutLeaf()) {
            return (TreeNode)idNodeMap.get(0L);
        }
        return this.removeEmptyParentNode(idNodeMap, dimension);
    }

    private TreeNode removeEmptyParentNode(HashMap<Long, TreeNode> idNodeMap, Map<Long, String> dimension) {
        TreeNode treeNode = idNodeMap.get(0L);
        this.cutLeaf(treeNode, idNodeMap, dimension);
        return idNodeMap.get(0L);
    }

    private void cutLeaf(TreeNode treeNode, HashMap<Long, TreeNode> idNodeMap, Map<Long, String> dimension) {
        if (treeNode.getChildrenMap() == null) {
            return;
        }
        Iterator<TreeNode> iterator = treeNode.getChildrenMap().values().iterator();
        while (iterator.hasNext()) {
            TreeNode child = iterator.next();
            this.cutLeaf(child, idNodeMap, dimension);
            if (child.isIsleaf() && dimension.get(child.getId()) == null && treeNode.getId() != 0L) {
                iterator.remove();
            }
            if (child.isIsleaf() || dimension.get(child.getId()) != null || !child.getChildrenMap().isEmpty() || treeNode.getId() == 0L) continue;
            idNodeMap.remove(child.getId());
            iterator.remove();
        }
    }

    private Map<Long, String> getNeedDimensionMap() {
        if (!this.isNeedCutLeaf()) {
            return new HashMap<Long, String>(16);
        }
        Map<Long, String> childNumbers = new HashMap<Long, String>(16);
        List<Member> children = null;
        Model model = ModelCacheContext.getOrCreate((Long)this.getModelId()).getModelobj();
        HashMap<Long, String> containsNumber = new HashMap<Long, String>(16);
        String dimensionNumber = this.getDimensionNumber();
        List memberList = this.getDimmensionRang();
        for (Map memberCondition : memberList) {
            childNumbers.clear();
            String range = (String)memberCondition.get("scope");
            if ("10".equals(range)) {
                childNumbers.put(Long.valueOf((String)memberCondition.get("id")), (String)memberCondition.get("number"));
            } else {
                Member member = ModelCacheServiceHelper.getMember((Model)model, (String)dimensionNumber, (String)((String)memberCondition.get("number")));
                children = this.queryMemberByRange(range, member);
                if (children != null && !children.isEmpty()) {
                    childNumbers = children.stream().collect(Collectors.toMap(BaseCache::getId, BaseCache::getNumber));
                }
            }
            containsNumber.putAll(childNumbers);
        }
        return containsNumber;
    }

    private List<Member> queryMemberByRange(String range, Member member) {
        List children = null;
        switch (range) {
            case "20": {
                children = member.getChildren();
                break;
            }
            case "30": {
                children = member.getChildren();
                children.add(member);
                break;
            }
            case "40": {
                children = ModelCacheServiceHelper.getChildren((Member)member, (boolean)false);
                break;
            }
            case "50": {
                children = ModelCacheServiceHelper.getChildren((Member)member, (boolean)true);
                break;
            }
            case "60": {
                children = ModelCacheServiceHelper.getBrother((Long)0L, (Member)member, (boolean)false);
                break;
            }
            case "70": {
                children = ModelCacheServiceHelper.getBrother((Long)0L, (Member)member, (boolean)true);
                break;
            }
            case "90": {
                children = ModelCacheServiceHelper.getDetailChildren((Member)member);
                break;
            }
            case "110": {
                children = ModelCacheServiceHelper.getNotDetailChildren((Member)member);
            }
        }
        return children;
    }

    private List getDimmensionRang() {
        String memberlist = this.getPageCache().get("dimRang");
        if (StringUtils.isEmpty((String)memberlist)) {
            return new ArrayList();
        }
        return SerializationUtils.fromJsonStringToList((String)memberlist, Map.class);
    }

    private Long getModelId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
    }

    private String getDimId() {
        return this.setDimId();
    }

    protected abstract String setDimId();

    protected abstract String setDimNum();

    private DynamicObjectCollection getDimDynamiObjectCollection(List<QFilter> dimFilters) {
        DynamicObjectCollection dynamicObjectCollection = this.queryDimensionMember(dimFilters.toArray(new QFilter[dimFilters.size()]));
        return dynamicObjectCollection;
    }

    private DynamicObjectCollection queryDimensionMember(QFilter ... qFilters) {
        return QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)this.getDimensionMemberTreeModel(), (String)"id,number,name,parent,level,isleaf,dimension,dseq,longnumber", (QFilter[])qFilters, (String)"level desc");
    }

    private String getDimensionMemberTreeModel() {
        String dimNum = this.getDimensionNumber();
        return SysDimensionEnum.getMemberTreemodelByNumber((String)dimNum);
    }

    private void beforeInitTree(List<QFilter> dimFilter) {
        dimFilter.add(new QFilter("dimension", "=", (Object)this.getDimId()));
    }

    private void setDimensionCombo() {
        String comboName = this.setDimName();
        ComboEdit dimensioncombo = (ComboEdit)this.getView().getControl("dimensioncombo");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        comboItems.add(new ComboItem(new LocaleString(comboName), "1"));
        dimensioncombo.setComboItems(comboItems);
        this.getModel().setValue("dimensioncombo", (Object)"1");
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"dimensioncombo"});
    }

    protected abstract void setDimFilter(List<QFilter> var1);

    protected abstract boolean isNeedCutLeaf();

    protected abstract boolean selectNotLeaf();

    protected abstract String setDimName();

    private class TreeNode {
        private Long id;
        private boolean isleaf;
        private DynamicObject dynamicObject;
        private TreeNode parentNode = null;
        private Map<Integer, TreeNode> childrenMap = new TreeMap<Integer, TreeNode>();

        TreeNode(Long id, boolean isleaf) {
            this.id = id;
            this.isleaf = isleaf;
        }

        public void init(DynamicObject memberObject, HashMap<Long, TreeNode> idNodeMap) {
            long parent = memberObject.getLong("parent");
            int dseq = memberObject.getInt("dseq");
            this.setDynamicObject(memberObject);
            TreeNode parentNode = idNodeMap.get(parent);
            if (parentNode == null) {
                parentNode = new TreeNode(parent, false);
                idNodeMap.put(parentNode.getId(), parentNode);
            }
            this.setParentNode(parentNode);
            this.getParentNode().getChildrenMap().put(dseq, this);
        }

        public Long getId() {
            return this.id;
        }

        public boolean isIsleaf() {
            return this.isleaf;
        }

        public DynamicObject getDynamicObject() {
            return this.dynamicObject;
        }

        public void setDynamicObject(DynamicObject dynamicObject) {
            this.dynamicObject = dynamicObject;
        }

        public TreeNode getParentNode() {
            return this.parentNode;
        }

        public void setParentNode(TreeNode parentNode) {
            this.parentNode = parentNode;
        }

        public Map<Integer, TreeNode> getChildrenMap() {
            return this.childrenMap;
        }

        public void setChildrenMap(Map<Integer, TreeNode> childrenMap) {
            this.childrenMap = childrenMap;
        }
    }
}

