/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.servicehelper.DimensionServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.formplugin.sonmodel.MainSubAbstractBasePlugin;
import kd.epm.eb.model.serviceHelper.DataSetServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class AddDimemsionPlugin
extends MainSubAbstractBasePlugin
implements ClickListener {
    private static String MODEL = "model";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"bar_confirm", "bar_cancel"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = this.getModelId();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.getModel().setValue("model", (Object)modelId);
            this.getModel().setValue("status", (Object)"C");
        }
    }

    public void afterLoadData(EventObject e) {
        this.getView().setEnable(Boolean.FALSE, new String[]{"number", "shortnumber"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeClick(BeforeClickEvent evt) {
        block5: {
            OperationStatus status;
            super.beforeClick(evt);
            String key = ((Control)evt.getSource()).getKey();
            if ("bar_confirm".equals(key) && OperationStatus.ADDNEW.equals((Object)(status = this.getView().getFormShowParameter().getStatus()))) {
                Long modelId = this.getModelId();
                DLock dLock = DLock.createReentrant((String)("bgmd/dimension/create/" + modelId));
                dLock.fastMode();
                try {
                    if (dLock.tryLock(20000L)) {
                        this.getModel().setValue("membermodel", (Object)"epm_userdefinedmembertree");
                        this.getModel().setValue("membertable", (Object)"t_eb_structofdefined");
                        String fieldmapped = DimensionServiceHelper.getMappedSeq((long)modelId);
                        this.getModel().setValue("fieldmapped", (Object)fieldmapped);
                        this.getModel().setValue("dseq", (Object)DimensionServiceHelper.getDimSeq((long)modelId));
                        break block5;
                    }
                    throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u6709\u5176\u4ed6\u64cd\u4f5c\u8005\u6b63\u5728\u65b0\u589e\u7ef4\u5ea6\uff0c\u8bf7\u7a0d\u540e\u4fdd\u5b58\u3002", (String)"AddDimemsionPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                finally {
                    dLock.unlock();
                }
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String key = evt.getOperateKey();
        if ("save".equals(key) && evt.getOperationResult().isSuccess()) {
            this.getPageCache().put("status", "success");
            this.getView().returnDataToParent((Object)"addNew");
            Long id = (Long)evt.getOperationResult().getSuccessPkIds().get(0);
            boolean issys = (Boolean)this.getModel().getValue("issysdimension");
            if (!issys) {
                this.addBaseDimView(id);
                Long modelId = this.getModelId();
                IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
                if (NewEbAppUtil.isNewEbModel((Long)modelId)) {
                    DynamicObject dataSet = this.addCustomDimWithBizModelAndDataset(modelId, id);
                    if (dataSet == null) {
                        return;
                    }
                    DynamicObject model = dataSet.getDynamicObject("model");
                    if (ShrekOlapServiceHelper.needDMLOlap((DynamicObject)model)) {
                        Dataset dataset = new Dataset(Long.valueOf(dataSet.getLong("id")), dataSet.getString("number"));
                        dataset.addViewIds(BusinessModelServiceHelper.getViewIds((Long)dataSet.getLong("businessmodel.id")));
                        dataset.addDimension(modelCacheHelper.getDimension(id));
                        ShrekOlapServiceHelper.addCubeDimension((Model)Model.of((DynamicObject)model), (Dataset)dataset, Collections.singletonList(id), (IModelCacheHelper)modelCacheHelper, (ShrekConfig)ShrekConfigServiceHelper.getBgMDConfig());
                    }
                } else if (modelCacheHelper.getModelobj().isModelByEB()) {
                    this.addGroupControlRuleOboDimByEb(id, modelCacheHelper);
                    try {
                        this.updateDefinedID(id, modelCacheHelper, modelId);
                    }
                    catch (Throwable e) {
                        log.info("updateDefinedID-error:", (Object)e);
                    }
                }
            }
            this.getView().close();
        }
    }

    private void updateDefinedID(Long id, IModelCacheHelper modelCacheHelper, Long modelId) {
        if (modelCacheHelper == null || id == null || modelCacheHelper.getDimension(id) == null) {
            return;
        }
        Dimension dimension = modelCacheHelper.getDimension(id);
        if (!BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) {
            return;
        }
        Member noneMember = dimension.getMember(null, dimension.getNoneNumber());
        if (noneMember == null || noneMember.getId() == null || noneMember.getId() == 0L) {
            return;
        }
        String userDefined = BgControlUtils.getUserDefinedIdField((Dimension)dimension);
        if (StringUtils.isEmpty((String)userDefined)) {
            return;
        }
        DB.execute((DBRoute)BgBaseConstant.epm, (String)("update t_eb_bgcontrolrecord set " + userDefined + " = ? where fmodelid = ? and " + userDefined + " = 0"), (Object[])new Object[]{noneMember.getId(), modelId});
        CacheServiceHelper.clearEntityCache((String)"eb_bgcontrolrecord");
    }

    private void addGroupControlRuleOboDimByEb(Long id, IModelCacheHelper modelCacheHelper) {
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        qFilter.and("group", ">", (Object)0L);
        Collection groupControlRuleCollection = BusinessDataServiceHelper.loadFromCache((String)"eb_bgcontrolrulemain", (QFilter[])qFilter.toArray()).values();
        if (CollectionUtils.isNotEmpty(groupControlRuleCollection)) {
            List dimensionList = modelCacheHelper.getDimensionList();
            int index = 0;
            for (Dimension dimension : dimensionList) {
                if (dimension.isPreset()) continue;
                ++index;
            }
            List<DynamicObject> groupControlRuleList = groupControlRuleCollection.stream().collect(Collectors.toList());
            for (DynamicObject groupControlRule : groupControlRuleList) {
                DynamicObjectCollection groupDims = groupControlRule.getDynamicObjectCollection("groupdims");
                DynamicObject rowGroupDim = new DynamicObject(groupDims.getDynamicObjectType());
                rowGroupDim.set("groupdim", (Object)id);
                rowGroupDim.set("isobodim", (Object)true);
                rowGroupDim.set("obodimindex", (Object)index);
                rowGroupDim.set("ismemberrange", (Object)false);
                groupDims.add((Object)rowGroupDim);
            }
            SaveServiceHelper.save((DynamicObject[])groupControlRuleList.toArray(new DynamicObject[0]));
        }
    }

    private void addBaseDimView(Long dimId) {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        long modelId = model.getLong("id");
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Model modelObj = modelCacheHelper.getModelobj();
        boolean modelByEB = modelObj.isModelByEB();
        if (modelByEB) {
            return;
        }
        String shortnumber = (String)this.getModel().getValue("shortnumber");
        String dimName = String.valueOf(this.getModel().getValue("name"));
        Long viewGroupId = null;
        String id = this.getExistViewId(modelId, dimId);
        DynamicObject dynamicObject = null;
        if (StringUtils.isEmpty((String)id)) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_dimensionview");
            long newid = GlobalIdUtil.genGlobalLongId();
            dynamicObject.set("id", (Object)newid);
            String number = shortnumber + "001";
            dynamicObject.set("number", (Object)number);
            dynamicObject.set("model", (Object)model.getString("id"));
            dynamicObject.set("dimension", (Object)dimId);
            dynamicObject.set("level", (Object)1);
            dynamicObject.set("dseq", (Object)1);
            dynamicObject.set("longnumber", (Object)("!" + number));
            dynamicObject.set("isleaf", (Object)Boolean.TRUE);
            dynamicObject.set("source", (Object)"1");
            dynamicObject.set("parent", (Object)0L);
            dynamicObject.set("usage", (Object)"0");
            dynamicObject.set("baseview", (Object)0L);
            dynamicObject.set("creater", (Object)UserUtils.getUserId());
            dynamicObject.set("createdate", (Object)TimeServiceHelper.now());
            dynamicObject.set("description", (Object)"");
        } else {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_dimensionview");
        }
        String existViewGroupId = this.getExistViewGroupId(modelId, dimId);
        if (StringUtils.isEmpty((String)existViewGroupId) && !modelByEB) {
            viewGroupId = GlobalIdUtil.genGlobalLongId();
            ArrayList<DynamicObject> save = new ArrayList<DynamicObject>(16);
            DynamicObject viewGroupDyn = BusinessDataServiceHelper.newDynamicObject((String)"eb_dimensionview_group");
            viewGroupDyn.set("id", (Object)viewGroupId);
            viewGroupDyn.set("number", (Object)(shortnumber + "001"));
            viewGroupDyn.set("name", (Object)ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u9884\u7f6e\u89c6\u56fe\u7ec4", (String)"AddDimemsionPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{dimName}));
            viewGroupDyn.set("type", (Object)"1");
            viewGroupDyn.set("defaultview", (Object)dynamicObject.getLong("id"));
            viewGroupDyn.set("description", (Object)"");
            viewGroupDyn.set("model", (Object)model.getString("id"));
            viewGroupDyn.set("creater", (Object)UserUtils.getUserId());
            viewGroupDyn.set("createdate", (Object)TimeServiceHelper.now());
            viewGroupDyn.set("modifier", (Object)UserUtils.getUserId());
            viewGroupDyn.set("modifydate", (Object)TimeServiceHelper.now());
            viewGroupDyn.set("dimension", (Object)dimId);
            viewGroupDyn.set("source", (Object)"1");
            viewGroupDyn.set("parent", (Object)0L);
            save.add(viewGroupDyn);
            SaveServiceHelper.save((DynamicObject[])save.toArray(new DynamicObject[0]));
            dynamicObject.set("viewgroup", (Object)viewGroupId);
            QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
            qfBuilder.add("dimension", "=", (Object)dimId);
            DynamicObject[] viewMembers = BusinessDataServiceHelper.load((String)"eb_viewmember", (String)"view", (QFilter[])qfBuilder.toArray());
            if (viewMembers.length > 0) {
                for (DynamicObject viewMember : viewMembers) {
                    viewMember.set("view", (Object)dynamicObject.getLong("id"));
                }
                SaveServiceHelper.save((DynamicObject[])viewMembers);
            }
        }
        dynamicObject.set("name", (Object)ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u57fa\u51c6\u89c6\u56fe", (String)"AddDimemsionPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[]{dimName}));
        dynamicObject.set("modifier", (Object)UserUtils.getUserId());
        dynamicObject.set("modifydate", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private String getExistViewId(long modelId, Long dimId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        QFilter qFilter1 = new QFilter("dimension", "=", (Object)dimId);
        QFilter qFilter2 = new QFilter("source", "=", (Object)"1");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_dimensionview", (String)"id", (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2});
        if (dynamicObject == null) {
            return "";
        }
        return dynamicObject.getString("id");
    }

    private String getExistViewGroupId(long modelId, Long dimId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        QFilter qFilter1 = new QFilter("dimension", "=", (Object)dimId);
        QFilter qFilter2 = new QFilter("source", "=", (Object)"1");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_dimensionview_group", (String)"id", (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2});
        if (dynamicObject == null) {
            return "";
        }
        return dynamicObject.getString("id");
    }

    public void click(EventObject evt) {
        OperationStatus status;
        super.click(evt);
        if ("bar_confirm".equals(((Control)evt.getSource()).getKey()) && OperationStatus.EDIT.equals((Object)(status = this.getView().getFormShowParameter().getStatus()))) {
            String newname = String.valueOf(this.getModel().getValue("name"));
            String shortnumber = String.valueOf(this.getModel().getValue("shortnumber"));
            long modelId = this.getModelId();
            String membermodel = String.valueOf(this.getModel().getValue("membermodel"));
            if ("success".equals(this.getPageCache().get("status"))) {
                if ("epm_userdefinedmembertree".equals(membermodel)) {
                    this.updateXNoneName(modelId, membermodel, shortnumber, newname);
                }
                this.syncOlapData(modelId, Convert.toStr((Object)this.getModel().getValue("number")));
            }
        }
    }

    private void syncOlapData(Long modelId, String dimNumber) {
        DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"epm_model");
        List<Dataset> datasets = null;
        if (StringUtils.isNotEmpty((String)dimNumber) && ShrekOlapServiceHelper.needDMLOlap((DynamicObject)model)) {
            Model modelOfShrek = Model.of((DynamicObject)model);
            if (NewEbAppUtil.isNewEbModel((Long)modelId)) {
                DynamicObject datasetObj = DataSetServiceHelper.loadDefault((Long)modelId);
                datasets = Collections.singletonList(Dataset.of((DynamicObject)datasetObj));
            } else {
                datasets = modelOfShrek.isModelByEB() ? Collections.singletonList(new Dataset(modelOfShrek.getId(), modelOfShrek.getNumber())) : DatasetServiceHelper.getAllDatasets((Long)modelId, (String)dimNumber);
            }
            if (!datasets.isEmpty()) {
                ShrekConfig config = ShrekConfigServiceHelper.getDefaultConfig((DynamicObject)model);
                ShrekOlapServiceHelper.updateDimension((Model)modelOfShrek, datasets, (String)dimNumber, null, (ShrekConfig)config);
            }
        }
    }

    private void updateXNoneName(long modelId, String entityNum, String dimShortNum, String newName) {
        DynamicObject[] viewmembers;
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("number", "=", (Object)(dimShortNum + "None"));
        DynamicObject dot = BusinessDataServiceHelper.loadSingle((String)entityNum, (String)"*", (QFilter[])new QFilter[]{qFilter});
        newName = ResManager.loadResFormat((String)"\u4e0d\u533a\u5206%1", (String)"AddDimemsionPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{newName});
        dot.set("name", (Object)newName);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dot});
        QFilter qFilter1 = new QFilter("model", "=", (Object)modelId);
        qFilter1.and("memberid", "=", dot.getPkValue());
        for (DynamicObject viewmember : viewmembers = BusinessDataServiceHelper.load((String)"eb_viewmember", (String)"name", (QFilter[])new QFilter[]{qFilter1})) {
            viewmember.set("name", (Object)newName);
        }
        SaveServiceHelper.save((DynamicObject[])viewmembers);
    }

    private DynamicObject addCustomDimWithBizModelAndDataset(Long modelId, Long dimensionId) {
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew((String)"addCustomDim");){
            DynamicObject datasetObj;
            DynamicObject row;
            DynamicObject bizModel = NewEbAppUtil.getDefaultObj((String)"eb_businessmodel", (Long)modelId, (String)"viewentry,viewentry.viewgroup,viewentry.dimension", null);
            if (bizModel == null) {
                DynamicObject dynamicObject = null;
                return dynamicObject;
            }
            long viewGroupId = 0L;
            QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
            qfBuilder.add("dimension", "=", (Object)dimensionId);
            DynamicObject dimensionViewGroup = BusinessDataServiceHelper.loadSingle((String)"eb_dimensionview_group", (String)"id", (QFilter[])qfBuilder.toArray());
            if (dimensionViewGroup != null) {
                viewGroupId = dimensionViewGroup.getLong("id");
            }
            long bizModelId = bizModel.getLong("id");
            long entryId = GlobalIdUtil.genGlobalLongId();
            boolean isExist = false;
            String querySql = "select fid from t_eb_viewentry where fid = ? and fdimensionid = ? and fviewgroupid = ?";
            try (DataSet ds = DB.queryDataSet((String)this.getClass().toString(), (DBRoute)BgBaseConstant.epm, (String)querySql, (Object[])new Object[]{bizModelId, dimensionId, viewGroupId});){
                if (ds != null && ds.hasNext()) {
                    isExist = true;
                }
            }
            if (!isExist) {
                DynamicObjectCollection viewEntry = bizModel.getDynamicObjectCollection("viewentry");
                row = new DynamicObject(viewEntry.getDynamicObjectType());
                row.set("dimension", (Object)dimensionId);
                row.set("viewgroup", (Object)viewGroupId);
                viewEntry.add((Object)row);
                DynamicObject[] dynamicObjects = new DynamicObject[]{bizModel};
                SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            }
            if ((datasetObj = NewEbAppUtil.getDefaultObj((String)"eb_dataset", (Long)modelId, (String)"model,businessmodel", null)) == null) {
                row = null;
                return row;
            }
            long datasetId = datasetObj.getLong("id");
            boolean isDatasetDimExist = false;
            String datasetDimQuerySql = "select fid from t_eb_datasetdim where fid = ? and fdatasetdim = ?";
            try (DataSet ds = DB.queryDataSet((String)this.getClass().toString(), (DBRoute)BgBaseConstant.epm, (String)datasetDimQuerySql, (Object[])new Object[]{datasetId, dimensionId});){
                if (ds != null && ds.hasNext()) {
                    isDatasetDimExist = true;
                }
            }
            if (!isDatasetDimExist) {
                String datasetFields = "fid,fentryid,fseq,fdatasetdim";
                String datasetInsertSql = "insert into t_eb_datasetdim(" + datasetFields + ") values(?,?,?,?)";
                DB.execute((DBRoute)BgBaseConstant.epm, (String)datasetInsertSql, (Object[])new Object[]{datasetId, entryId, 0L, dimensionId});
            }
            CubeUtils.get().checkBusModel(modelId, Long.valueOf(bizModelId));
            DynamicObject dynamicObject = datasetObj;
            return dynamicObject;
        }
        catch (Exception ex) {
            try {
                tx.markRollback();
                throw new KDBizException(ex.getMessage());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong(this.getView().getFormShowParameter().getCustomParams().get(MODEL));
    }
}

