/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.servicehelper.DimensionServiceHelper;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.business.utils.TreeEntryEntityUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.DimMembActionEnum;
import kd.epm.eb.common.enums.dimensionEnums.DimOperationEnum;
import kd.epm.eb.common.enums.dimensionEnums.DimShowPropertyEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.enums.dimensionEnums.ViewGroupTypeEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.member.f7.MemberParamsUtils;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.cube.dimension.entitys.DimManagerInfo;
import kd.epm.eb.cube.dimension.entitys.DimensionInfo;
import kd.epm.eb.cube.dimension.entitys.ModelInfo;
import kd.epm.eb.formplugin.dimension.AbstractDimFormPlugin;
import kd.epm.eb.formplugin.dimension.action.BailOrgAction;
import kd.epm.eb.formplugin.dimension.action.BudgetPeriodAddNewAction;
import kd.epm.eb.formplugin.dimension.action.BudgetPeriodModifyStartDateAction;
import kd.epm.eb.formplugin.dimension.action.CurrencyImportAction;
import kd.epm.eb.formplugin.dimension.action.DimAddNewAction;
import kd.epm.eb.formplugin.dimension.action.DimDeleteAction;
import kd.epm.eb.formplugin.dimension.action.DimEditAction;
import kd.epm.eb.formplugin.dimension.action.IAction;
import kd.epm.eb.formplugin.dimension.action.MemberAddNewAction;
import kd.epm.eb.formplugin.dimension.action.MemberAddPeriodAction;
import kd.epm.eb.formplugin.dimension.action.MemberAdjustAction;
import kd.epm.eb.formplugin.dimension.action.MemberCustomPropertyAction;
import kd.epm.eb.formplugin.dimension.action.MemberCutAction;
import kd.epm.eb.formplugin.dimension.action.MemberDeleteAction;
import kd.epm.eb.formplugin.dimension.action.MemberDownAction;
import kd.epm.eb.formplugin.dimension.action.MemberEditAction;
import kd.epm.eb.formplugin.dimension.action.MemberExportAction;
import kd.epm.eb.formplugin.dimension.action.MemberFileImportAction;
import kd.epm.eb.formplugin.dimension.action.MemberImportAction;
import kd.epm.eb.formplugin.dimension.action.MemberNameUpAction;
import kd.epm.eb.formplugin.dimension.action.MemberPasteAction;
import kd.epm.eb.formplugin.dimension.action.MemberRelationAction;
import kd.epm.eb.formplugin.dimension.action.MemberSyncAction;
import kd.epm.eb.formplugin.dimension.action.MemberSysImportAction;
import kd.epm.eb.formplugin.dimension.action.MemberUpAction;
import kd.epm.eb.formplugin.dimension.action.ViewCopyAction;
import kd.epm.eb.formplugin.dimension.action.ViewDeleteAction;
import kd.epm.eb.formplugin.dimension.action.ViewEditAction;
import kd.epm.eb.formplugin.dimension.action.ViewGroupAddNewAction;
import kd.epm.eb.formplugin.dimension.action.ViewGroupDeleteAction;
import kd.epm.eb.formplugin.dimension.action.ViewGroupEditAction;
import kd.epm.eb.formplugin.dimension.action.ViewMemberCutAction;
import kd.epm.eb.formplugin.dimension.action.ViewMemberEditAction;
import kd.epm.eb.formplugin.dimension.action.ViewMemberPasteAction;
import kd.epm.eb.model.utils.ModelUtil;
import org.jetbrains.annotations.NotNull;

public abstract class BaseDimensionManager
extends AbstractDimFormPlugin
implements TreeNodeClickListener,
TreeNodeQueryListener,
BeforeF7SelectListener,
HyperLinkClickListener,
SearchEnterListener {
    protected static final String TREE_DIM = "dimtree";
    public static final String TREE_VIEW = "viewtree";
    protected static final String TREE_ENTRY_ENTITY = "treeentryentity";
    public static final int MAX_LEVEL = 20;
    protected static final String BTN_REFRESH = "btn_refresh";
    protected static final String BTN_CLOSE = "btn_close";
    protected static final String BTN_ADDDIM = "btn_adddim";
    protected static final String BTN_EDITDIM = "btn_editdim";
    protected static final String BTN_DELDIM = "btn_deldim";
    private static final String BTN_DISABLE = "btn_disable";
    private static final String BTN_ENABLE = "btn_enable";
    protected static final String BTN_ADDVIEW = "btn_addview";
    protected static final String BTN_EDITVIEW = "btn_editview";
    protected static final String BTN_DELVIEW = "btn_delview";
    protected static final String BTN_COPYVIEW = "btn_copyview";
    public static final String BTN_ADDMEMBER = "btn_addmember";
    public static final String BTN_DELMEMBER = "btn_delmember";
    public static final String BTN_EDITMEMBER = "btn_editmember";
    public static final String BTN_EDITVIEWMEMBER = "btn_editviewmember";
    public static final String BTN_UPMEMBER = "btn_upmove";
    public static final String BTN_DOWNMEMBER = "btn_downmove";
    public static final String BTN_CUT = "btn_cut";
    public static final String BTN_PASTE = "btn_paste";
    public static final String BTN_BATCHMODDIFY = "btn_batchmodify";
    public static final String BTN_CUSTOMPROPERTY = "btn_customproperty";
    public static final String BTN_DIMMEMRELAT = "btn_dimmemrelat";
    public static final String BTN_ADDPERIOD = "btn_addperiod";
    public static final String BTN_SYSIMPORT = "btn_sysimport";
    public static final String BTN_MEMBERIMPORT = "btn_memberimport";
    public static final String BTN_FILEIMPORT = "btn_fileimport";
    public static final String BTN_FILEEXPORT = "btn_fileexport";
    public static final String BTN_BAIL_ORG = "btn_bailorg";
    public static final String BTN_ADJUSTORG = "btn_adjustorg";
    public static final String BTN_ADMINORG = "btn_adminorg";
    public static final String BTN_BUSORG = "btn_busorg";
    public static final String BTN_COSTORG = "btn_costorg";
    public static final String BTN_MEMBER_SYNC = "btn_sync";
    public static final String BTN_MOD_STARTDATE = "btn_modifystartdate";
    public static final String DELVIEW = "delView";
    public static final String CONFIRM_DELDIM = "delDimConfirmBack";
    public static final String CONFIRM_DELVIEW = "delViewConfirmBack";
    public static final String CONFIRM_DELMEMBER = "delMemberConfirmBack";
    public static final String CONFIRM_DELVIEWGROUP = "delViewGroupConfirmBack";
    public static final String CONFIRM_PASTEMEMBER = "pasteMemberConfirmBack";
    public static final String CONFIRM_SORT_MEMBER = "sortMemberConfirmBack";
    public static final String CONFIRM_UP_NAME_ADMIN = "updateNameByAdminConfirmBack";
    public static final String CONFIRM_UP_NAME_BUS = "updateNameByBusConfirmBack";
    public static final String CONFIRM_UP_NAME_COST = "updateNameByCostConfirmBack";
    public static final String CLOSE_ADDDIM = "addDimCloseBack";
    public static final String CLOSE_EDITDIM = "editDimCloseBack";
    public static final String CLOSE_ADDVIEW = "addViewCloseBack";
    public static final String CLOSE_EDITVIEW = "editViewCloseBack";
    public static final String CLOSE_REFESHMEMBER = "refreshMemberCloseBack";
    public static final String CLOSE_CURRENCYIMPORY = "currencyImport";
    protected static final String CACHE_SEARCHRESULT = "searchResult";
    protected static final String CACHE_CURRENTFOCUS = "currentFocus";
    public static final String CACHE_CUTMEMBERIDS = "cutMemberIds";
    public static final String CACHE_CUT_VIEW_MEMBERIDS = "cutViewMemberIds";
    protected static final String CACHE_DIMTREE = "dimTreeCache";
    protected DimManagerInfo dimInfo = null;
    public static final String DIM_INFO = "dimInfo";
    public static final String BD_CURRENCY = "bdcurrency";
    public static final String LABEL_MEMBERNAME = "membername";
    private static final Set<String> virtualDims = new HashSet<String>();

    @Override
    protected DimManagerInfo getDimManagerInfo() {
        if (this.dimInfo != null) {
            return this.dimInfo;
        }
        String _dimInfoStr = this.getPageCache().get(DIM_INFO);
        if (_dimInfoStr != null) {
            return (DimManagerInfo)SerializationUtils.deSerializeFromBase64((String)_dimInfoStr);
        }
        return new DimManagerInfo();
    }

    protected void cacheDimManagerInfo() {
        if (this.isNewEbForm()) {
            DynamicObject datasetObj = NewEbAppUtil.getDefaultObj((String)"eb_dataset", (Long)this.getModelId());
            Long datasetId = datasetObj.getLong("id");
            this.dimInfo.setDataset(datasetId.longValue());
        }
        this.getPageCache().put(DIM_INFO, SerializationUtils.serializeToBase64((Object)this.dimInfo));
    }

    protected void setMemberId() {
        this.dimInfo = this.getDimManagerInfo();
        if (this.dimInfo != null) {
            Long selectMemberId = this.getSelectMemberId();
            if (selectMemberId == null || selectMemberId == 0L) {
                return;
            }
            this.dimInfo.setMember(selectMemberId.longValue());
            if (this.dimInfo.getMember() != null) {
                this.dimInfo.getMember().setSeq(this.getSelectIndex());
            }
        }
    }

    protected Long getSelectMemberId() {
        DynamicObject object;
        int[] selectRows = this.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREE_ENTRY_ENTITY);
            DynamicObject[] entities = treeEntry.getEntryData().getDataEntitys();
            if (entities != null && entities.length > 0) {
                treeEntry.selectRows(0);
            }
            selectRows = new int[]{0};
        }
        if ((object = this.getModel().getEntryRowEntity(TREE_ENTRY_ENTITY, selectRows[0])) != null) {
            return object.getLong("id");
        }
        return 0L;
    }

    protected int[] getSelectRows() {
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREE_ENTRY_ENTITY);
        return treeEntry.getSelectRows();
    }

    protected int getSelectIndex() {
        int[] selectRows = this.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            return selectRows[0];
        }
        return 0;
    }

    public void initialize() {
        super.initialize();
        TreeView dimTree = (TreeView)this.getControl(TREE_DIM);
        dimTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeEntryGrid memberTree = (TreeEntryGrid)this.getControl(TREE_ENTRY_ENTITY);
        memberTree.addCellClickListener((TreeNodeQueryListener)this);
        memberTree.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap", "operationtoor"});
        this.addClickListeners(new String[]{BTN_ADDDIM, BTN_EDITDIM, BTN_DELDIM});
        this.addClickListeners(new String[]{BTN_ADDMEMBER, BTN_DELMEMBER, BTN_UPMEMBER, BTN_DOWNMEMBER});
        this.addClickListeners(new String[]{BTN_SYSIMPORT, BTN_FILEIMPORT, BTN_FILEEXPORT});
        this.addClickListeners(new String[]{BTN_DISABLE, BTN_ENABLE});
        BasedataEdit model = (BasedataEdit)this.getView().getControl("model");
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TreeView dimTree = (TreeView)this.getControl(TREE_DIM);
        dimTree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
        if (IDUtils.isNull((Long)modelId)) {
            modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        }
        if (IDUtils.isNull((Long)modelId)) {
            modelId = UserSelectUtils.getUserSelectModelId((IFormView)this.getView());
        }
        if (IDUtils.isNull((Long)modelId)) {
            String entityId = this.getView().getEntityId();
            ApplicationTypeEnum application = this.isNewEbForm() ? ApplicationTypeEnum.BG : ModelUtil.queryApp((IFormView)this.getView());
            modelId = ModelUtil.getDefaultModel((String)entityId, (ApplicationTypeEnum)application);
        }
        if (IDUtils.isNull((Long)modelId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4efb\u4f55\u4f53\u7cfb\uff0c\u8bf7\u65b0\u589e\u4f53\u7cfb\u3002", (String)"EbDimensionManagerList_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        modelId = this.getModelIdAfterCreateNewData(modelId);
        this.getModel().setValue("model", (Object)modelId);
        this.dimInfo = this.getDimManagerInfo();
        this.dimInfo.setModel(modelId.longValue());
        this.cacheDimManagerInfo();
        this.initDimensionTree(EnumTime.A);
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_BATCHMODDIFY});
        if (this.isNewEbForm()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_DIMMEMRELAT});
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyKey = e.getProperty().getName();
        if ("model".equals(propertyKey)) {
            this.propertyChanged_model(e);
        }
    }

    protected void propertyChanged_model(PropertyChangedArgs e) {
        DynamicObject newModel = (DynamicObject)e.getChangeSet()[0].getNewValue();
        this.dimInfo = this.getDimManagerInfo();
        ModelInfo modelInfo = this.dimInfo.getModel();
        long lastSelectModel = 0L;
        if (modelInfo != null) {
            lastSelectModel = modelInfo.getId();
        }
        this.getPageCache().remove("isModelAdmin");
        if (newModel != null) {
            long modelId = newModel.getLong("id");
            if (modelId == lastSelectModel) {
                return;
            }
            UserSelectUtils.saveUserSelectModelId((IFormView)this.getView(), (long)modelId);
            this.dimInfo.setModel(modelId);
            this.dimInfo.setView(Long.valueOf(0L));
            TreeView tree = (TreeView)this.getView().getControl(TREE_DIM);
            tree.deleteAllNodes();
            this.initDimensionTree(EnumTime.A);
            this.refreshList();
        } else {
            this.getModel().setValue("model", (Object)lastSelectModel);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if ("model".equals(key)) {
            this.beforeF7Select_Model(evt);
        } else if (BD_CURRENCY.equals(key)) {
            this.beforeF7Select_Currency(evt);
        }
    }

    protected void beforeF7Select_Model(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        ArrayList qFilterList = ((BasedataEdit)this.getControl("model")).getQFilters();
        if (qFilterList == null) {
            qFilterList = new ArrayList();
        }
        qFilterList.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
        showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        NewF7Utils.dealSelectRows((ListShowParameter)showParameter, (BeforeF7SelectEvent)evt);
    }

    protected void beforeF7Select_Currency(BeforeF7SelectEvent evt) {
        QFilter qf = new QFilter("status", "=", (Object)"C");
        ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
        param.getListFilterParameter().setFilter(qf);
        CloseCallBack aa = new CloseCallBack((IFormPlugin)this, CLOSE_CURRENCYIMPORY);
        evt.getFormShowParameter().setCloseCallBack(aa);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemClickKey = evt.getItemKey();
        if (BTN_CLOSE.equals(itemClickKey)) {
            return;
        }
        this.getModelId();
        this.setMemberId();
        if (this.checkModel()) {
            return;
        }
        if (!this.memberPermCheck(itemClickKey, this.getDimManagerInfo())) {
            return;
        }
        switch (itemClickKey) {
            case "btn_refresh": {
                this.refreshList();
                this.clearModelCache();
                break;
            }
            case "btn_addmember": 
            case "btn_sysimport": 
            case "btn_memberimport": 
            case "btn_fileimport": 
            case "btn_fileexport": 
            case "btn_customproperty": 
            case "btn_dimmemrelat": 
            case "btn_addperiod": 
            case "btn_deldim": 
            case "btn_delmember": 
            case "btn_downmove": 
            case "btn_upmove": 
            case "btn_cut": 
            case "btn_paste": 
            case "btn_bailorg": 
            case "btn_adjustorg": 
            case "btn_adminorg": 
            case "btn_busorg": 
            case "btn_costorg": 
            case "btn_sync": 
            case "btn_modifystartdate": {
                this.executeAction(itemClickKey);
                break;
            }
            case "btn_disable": 
            case "btn_enable": {
                Long modelId = this.getModelId();
                String dimNumber = this.dimInfo.getDimension().getNumber();
                Long viewId = 0L;
                if (!View.NoViewDimNums.contains(dimNumber)) {
                    viewId = this.dimInfo.getViewId();
                }
                MemberF7Parameter f7Param = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
                f7Param.setCanSelectRoot(false);
                if (BTN_DISABLE.equals(itemClickKey)) {
                    f7Param.setForDisable(true);
                } else {
                    f7Param.setForEnable(true);
                }
                f7Param.setShowDisable(true);
                f7Param.setShowDisableVisible(false);
                f7Param.setVerifyManagerPermission(true);
                f7Param.setVerifyPermission(false);
                f7Param.setViewId(viewId);
                NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, itemClickKey));
                break;
            }
        }
        this.cacheDimManagerInfo();
    }

    @Override
    public void click(EventObject evt) {
        String clickKey;
        super.click(evt);
        if (this.checkModel()) {
            return;
        }
        switch (clickKey = ((Control)evt.getSource()).getKey()) {
            case "btn_adddim": 
            case "btn_editdim": {
                this.executeAction(clickKey, true, new Object[0]);
                break;
            }
            case "btn_addview": 
            case "btn_editview": 
            case "btn_copyview": 
            case "btn_delview": 
            case "btn_deldim": {
                this.getPageCache().put("groupType", ViewGroupTypeEnum.GROUP.getIndex());
                this.executeAction(clickKey);
                break;
            }
        }
        this.cacheDimManagerInfo();
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (MessageBoxResult.Yes != evt.getResult()) {
            return;
        }
        this.dimInfo = this.getDimManagerInfo();
        switch (evt.getCallBackId()) {
            case "delDimConfirmBack": 
            case "delMemberConfirmBack": 
            case "pasteMemberConfirmBack": 
            case "updateNameByAdminConfirmBack": 
            case "updateNameByBusConfirmBack": 
            case "updateNameByCostConfirmBack": 
            case "delViewGroupConfirmBack": 
            case "delViewConfirmBack": {
                this.executeAction(evt.getCallBackId(), true, new Object[0]);
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        Object returnData = evt.getReturnData();
        switch (actionId = evt.getActionId()) {
            case "refreshMemberCloseBack": {
                if (!View.NoViewDimNums.contains(this.getDimManagerInfo().getDimension().getNumber()) && !this.isEB()) {
                    String tag = this.getPageCache().get("tag");
                    String currentNodeKey = this.getPageCache().get("currentNodeKey");
                    this.refreshListOrViewMember(currentNodeKey, tag);
                    break;
                }
                this.refreshMember();
                break;
            }
            case "addDimCloseBack": {
                if (returnData == null) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65b0\u589e\u6210\u529f\u3002", (String)"DimensionManagerList_69", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
                this.initDimensionTree(EnumTime.B);
                this.refreshMember();
                this.clearSearchCache();
                break;
            }
            case "editDimCloseBack": {
                if (returnData == null) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DimensionManagerList_70", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
                this.initDimensionTree(EnumTime.C);
                this.refreshMember();
                break;
            }
            case "currencyImport": {
                this.executeAction(actionId, true, evt.getReturnData());
                this.getModel().setValue(BD_CURRENCY, null);
            }
            case "btn_disable": 
            case "btn_enable": {
                if (!View.NoViewDimNums.contains(this.getDimManagerInfo().getDimension().getNumber()) && !this.getDimManagerInfo().getModel().isEb()) {
                    String tag = this.getPageCache().get("tag");
                    String currentNodeKey = this.getPageCache().get("currentNodeKey");
                    this.refreshListOrViewMember(currentNodeKey, tag);
                    break;
                }
                this.refreshMember();
                break;
            }
        }
    }

    protected boolean isEB() {
        return ApplicationTypeEnum.EB.getAppnum().equals(this.getAppNum()) && !NewEbAppUtil.isNewEbModel((Long)this.getModelId());
    }

    protected String getAppNum() {
        return this.getView().getFormShowParameter().getAppId();
    }

    public void refreshListOrViewMember(String id, String tag) {
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent evt) {
        super.hyperLinkClick(evt);
        this.dimInfo = this.getDimManagerInfo();
        this.setMemberId();
        if (!this.checkDimPermission("EDIT", this.dimInfo.getDimension().getNumber(), this.dimInfo.getMember().getNumber(), this.dimInfo.getViewId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u4fee\u6539\u8be5\u7ef4\u5ea6\u6210\u5458\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"DimensionManagerList_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.executeAction(BTN_EDITMEMBER);
        this.cacheDimManagerInfo();
    }

    protected boolean checkModel() {
        this.dimInfo = this.getDimManagerInfo();
        if (this.dimInfo.getModel() == null || IDUtils.isNull((long)this.dimInfo.getModelId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"EbDimensionManagerList_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    protected Set<Long> getBaseViewHasPermMemberIds(DimManagerInfo dimInfo, boolean isVirtual) {
        Member rootMember;
        long modelId = dimInfo.getModel().getId();
        DimensionInfo dimension = dimInfo.getDimension();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Set hasPermMemberIds = DimMembPermUtil.getDimManagerHasPermMembIds((Long)modelId, (Long)this.getUserId(), (String)dimension.getNumber(), (Long)dimInfo.getViewId(), (boolean)isVirtual);
        if (hasPermMemberIds == null) {
            hasPermMemberIds = Sets.newLinkedHashSet();
        }
        if ((rootMember = !View.NoViewDimNums.contains(dimension.getNumber()) && !this.isEB() ? modelCache.getRootMember(dimension.getNumber(), dimInfo.getViewId()) : modelCache.getRootMember(dimension.getNumber(), null)) != null) {
            hasPermMemberIds.add(rootMember.getId());
        }
        return hasPermMemberIds;
    }

    public boolean isBudgetPeriod(@NotNull DimManagerInfo dimInfo) {
        return SysDimensionEnum.BudgetPeriod.getNumber().equals(dimInfo.getDimension().getNumber());
    }

    public boolean isChangeType(@NotNull DimManagerInfo dimInfo) {
        return "ChangeType".equals(dimInfo.getDimension().getNumber());
    }

    protected boolean isEntity(@NotNull DimManagerInfo dimInfo) {
        return "Entity".equals(dimInfo.getDimension().getNumber());
    }

    @Override
    protected IAction getAction(String actionKey, DimManagerInfo dimInfo) {
        IAction action = null;
        switch (actionKey) {
            case "btn_addmember": {
                action = this.getMemberAddNewAction(dimInfo);
                action.setPermKey(DimMembActionEnum.ADDCHILD.getKey());
                break;
            }
            case "btn_editmember": {
                action = this.getMemberEditAction(dimInfo);
                action.setPermKey(DimMembActionEnum.EDIT.getKey());
                break;
            }
            case "btn_editviewmember": {
                action = this.getViewMemberEditAction(dimInfo);
                action.setPermKey(DimMembActionEnum.EDIT.getKey());
                break;
            }
            case "btn_deldim": 
            case "delDimConfirmBack": {
                action = new DimDeleteAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                break;
            }
            case "btn_delmember": 
            case "delMemberConfirmBack": {
                action = new MemberDeleteAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                action.setPermKey(DimMembActionEnum.DELETE.getKey());
                break;
            }
            case "btn_downmove": {
                action = new MemberDownAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                action.setPermKey(DimMembActionEnum.EDIT.getKey());
                break;
            }
            case "btn_upmove": {
                action = new MemberUpAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                action.setPermKey(DimMembActionEnum.EDIT.getKey());
                break;
            }
            case "btn_cut": {
                action = IDUtils.isNotNull((Long)dimInfo.getViewId()) ? new ViewMemberCutAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo) : new MemberCutAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                action.setPermKey(DimMembActionEnum.EDIT.getKey());
                break;
            }
            case "btn_paste": 
            case "pasteMemberConfirmBack": {
                action = IDUtils.isNotNull((Long)dimInfo.getViewId()) ? new ViewMemberPasteAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo) : new MemberPasteAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                action.setPermKey(DimMembActionEnum.EDIT.getKey());
                break;
            }
            case "btn_adddim": {
                action = new DimAddNewAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                break;
            }
            case "btn_editdim": {
                action = new DimEditAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                break;
            }
            case "btn_memberimport": {
                action = new MemberImportAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                break;
            }
            case "btn_sysimport": {
                action = new MemberSysImportAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                break;
            }
            case "btn_fileimport": {
                action = new MemberFileImportAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                break;
            }
            case "btn_fileexport": {
                action = new MemberExportAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                break;
            }
            case "btn_customproperty": {
                action = new MemberCustomPropertyAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                break;
            }
            case "btn_dimmemrelat": {
                action = new MemberRelationAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                break;
            }
            case "btn_addperiod": {
                action = new MemberAddPeriodAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                action.setPermKey(DimMembActionEnum.ADDCHILD.getKey());
                break;
            }
            case "currencyImport": {
                action = new CurrencyImportAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                break;
            }
            case "btn_addview": {
                action = new ViewGroupAddNewAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                break;
            }
            case "btn_editview": {
                String tag = this.getView().getPageCache().get("tag");
                if (StringUtils.isEmpty((String)tag) || "group".equals(tag) || "dir".equals(tag)) {
                    action = new ViewGroupEditAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                    break;
                }
                action = new ViewEditAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                break;
            }
            case "btn_copyview": {
                action = new ViewCopyAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                break;
            }
            case "btn_delview": 
            case "delViewGroupConfirmBack": {
                String tag1 = this.getView().getPageCache().get("tag");
                if ("group".equals(tag1) || "dir".equals(tag1)) {
                    action = new ViewGroupDeleteAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                    break;
                }
                action = new ViewDeleteAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                break;
            }
            case "btn_bailorg": {
                action = new BailOrgAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                break;
            }
            case "btn_adminorg": 
            case "updateNameByAdminConfirmBack": {
                action = new MemberNameUpAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo, BTN_ADMINORG);
                break;
            }
            case "btn_busorg": 
            case "updateNameByBusConfirmBack": {
                action = new MemberNameUpAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo, BTN_BUSORG);
                break;
            }
            case "btn_costorg": 
            case "updateNameByCostConfirmBack": {
                action = new MemberNameUpAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo, BTN_COSTORG);
                break;
            }
            case "btn_adjustorg": {
                action = new MemberAdjustAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                break;
            }
            case "btn_sync": {
                action = new MemberSyncAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                break;
            }
            case "btn_modifystartdate": {
                action = new BudgetPeriodModifyStartDateAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                break;
            }
            case "delView": 
            case "delViewConfirmBack": {
                action = new ViewDeleteAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                break;
            }
        }
        return action;
    }

    protected IAction getMemberAddNewAction(DimManagerInfo dimInfo) {
        MemberAddNewAction action = this.isBudgetPeriod(dimInfo) ? new BudgetPeriodAddNewAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo) : new MemberAddNewAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
        return action;
    }

    protected IAction getMemberEditAction(DimManagerInfo dimInfo) {
        return new MemberEditAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
    }

    protected IAction getViewMemberEditAction(DimManagerInfo dimInfo) {
        return new ViewMemberEditAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
    }

    public void initDimensionTree(EnumTime clickTime) {
        this.dimInfo = this.getDimManagerInfo();
        TreeView tree = (TreeView)this.getView().getControl(TREE_DIM);
        TreeNode root = new TreeNode();
        root.setId("root");
        List<TreeNode> dimensionNodes = this.listDimNodes();
        for (TreeNode node : dimensionNodes) {
            root.addChild(node);
        }
        this.getPageCache().put(CACHE_DIMTREE, SerializationUtils.serializeToBase64((Object)root));
        tree.deleteAllNodes();
        tree.addNode(root);
        tree.expand("root");
        if (clickTime == EnumTime.A) {
            this.initDimTree(tree, root);
        } else if (clickTime == EnumTime.B) {
            this.addNewDimTree(tree, root, this.dimInfo);
        } else if (clickTime == EnumTime.C) {
            this.refreshDimTree(tree, root, this.dimInfo);
        }
        this.cacheDimManagerInfo();
    }

    public List<TreeNode> listDimNodes() {
        ArrayList dimensionNodes = Lists.newArrayListWithExpectedSize((int)100);
        Set<String> hideDims = this.getHideDims();
        if (this.isNewEbForm() || NewEbAppUtil.isOldEbModel((Long)this.getModelId())) {
            hideDims.remove(SysDimensionEnum.Account.getNumber());
        } else {
            hideDims.add(SysDimensionEnum.Account.getNumber());
        }
        List dims = DimensionServiceHelper.queryAllDim((Long)this.dimInfo.getModel().getId(), (String)"id,name,number,shortnumber,membermodel,issysdimension,dseq");
        for (DynamicObject dim : dims) {
            String number = dim.getString("number");
            if (this.isNewEbForm() && SysDimensionEnum.InternalCompany.getNumber().equals(number) || hideDims.contains(number)) continue;
            TreeNode dimensionNode = new TreeNode();
            dimensionNode.setId(dim.getString("id"));
            dimensionNode.setText(String.format("%s(%s)", dim.getString("name"), dim.getString("shortnumber")));
            dimensionNode.setData((Object)dim);
            dimensionNodes.add(dimensionNode);
        }
        return dimensionNodes;
    }

    private void initDimTree(TreeView tree, TreeNode root) {
        String dimId = (String)this.getView().getFormShowParameter().getCustomParam("datasetDimId");
        TreeNode node = null;
        if (StringUtils.isNotEmpty((String)dimId)) {
            node = root.getTreeNode(dimId, 20);
        }
        if (node == null) {
            node = (TreeNode)root.getChildren().get(0);
        }
        tree.focusNode(node);
        tree.treeNodeClick("root", node.getId());
        this.dimInfo.setDimension(Long.parseLong(node.getId()));
    }

    private void addNewDimTree(TreeView tree, TreeNode root, DimManagerInfo dimInfo) {
        TreeNode focusNode = (TreeNode)root.getChildren().get(root.getChildren().size() - 1);
        tree.focusNode(focusNode);
        tree.treeNodeClick("root", focusNode.getId());
        dimInfo.setDimension(Long.parseLong(focusNode.getId()));
    }

    private void refreshDimTree(TreeView tree, TreeNode root, DimManagerInfo dimInfo) {
        long focusNodeId = dimInfo.getDimension().getId();
        tree.focusNode(root.getTreeNode(String.valueOf(focusNodeId), 10));
    }

    protected abstract Set<String> getHideDims();

    protected void refreshList() {
        if (View.NoViewDimNums.contains(this.getDimManagerInfo().getDimension().getNumber()) || this.isEB()) {
            this.refreshMember();
        } else {
            String nodeId = this.getPageCache().get("currentNodeKey");
            String tag = this.getPageCache().get("tag");
            this.refreshListOrViewMember(nodeId, tag);
        }
        this.clearCache();
    }

    protected void clearModelCache() {
        Long modelId = this.getModelId();
        CubeUtils.updateCubeVersion((Long)modelId);
        ModelCacheContext.removeModel((Long)modelId);
        MemberPropCacheService.rebulid((Long)modelId);
    }

    public void refreshMember() {
        LogStats stats = new LogStats("member-log:");
        stats.addInfo("begin-refreshMember.");
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREE_ENTRY_ENTITY);
        int focusRowIndex = this.getModel().getEntryCurrentRowIndex(TREE_ENTRY_ENTITY);
        ArrayList expandIds = (ArrayList)treeEntry.getExpandNodes();
        if (expandIds == null) {
            expandIds = new ArrayList();
        }
        this.initMemberTree();
        stats.add("end-initMemberTree.");
        treeEntry = (TreeEntryGrid)this.getControl(TREE_ENTRY_ENTITY);
        LinkedHashSet _expandIdSet = new LinkedHashSet(expandIds);
        ArrayList<Integer> rowIndexs = new ArrayList<Integer>();
        DynamicObjectCollection objs = null;
        for (int i = 0; i < _expandIdSet.size(); ++i) {
            int row = -1;
            if (objs == null) {
                objs = this.getModel().getEntryEntity(TREE_ENTRY_ENTITY);
            }
            for (int j = 0; j < objs.size(); ++j) {
                if (!_expandIdSet.contains(((DynamicObject)objs.get(j)).getString("id"))) continue;
                row = j;
                if (rowIndexs.contains(row)) {
                    row = -1;
                    continue;
                }
                rowIndexs.add(row);
                break;
            }
            if (row < 0) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("rowkey", row);
            map.put("id", ((DynamicObject)objs.get(row)).get("id"));
            treeEntry.loadChildrenData(map);
            objs = null;
        }
        treeEntry.expandOne(rowIndexs.stream().mapToInt(Integer::intValue).toArray());
        this.afterRefreshMemberExpandOne(treeEntry, focusRowIndex);
        this.clearCache();
        stats.addInfo("end-refreshMember.");
        log.info(stats.toString());
    }

    public int getEntryEntityRow(Long id) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TREE_ENTRY_ENTITY);
        for (DynamicObject object : entryEntity) {
            if (id.longValue() != object.getLong("id")) continue;
            return object.getInt("seq") - 1;
        }
        return -1;
    }

    protected void afterRefreshMemberExpandOne(TreeEntryGrid treeEntry, int focusRowIndex) {
        try {
            Object rowcount = treeEntry.getEntryData().getData().get("rowcount");
            if (rowcount != null && Integer.parseInt(rowcount.toString()) <= focusRowIndex) {
                focusRowIndex = 0;
            }
        }
        catch (Exception e) {
            log.error("get rowcount error, " + e.getMessage(), (Throwable)e);
            focusRowIndex = 0;
        }
        treeEntry.selectRows(focusRowIndex);
    }

    protected void initMemberTree() {
        this.dimInfo = this.getDimManagerInfo();
        Long viewId = this.dimInfo.getViewId();
        String selectFields = this.getSelectFields(this.dimInfo);
        String[] properties = this.getProperties(this.dimInfo);
        QFBuilder builder = this.getQueryMemberBuilder(this.dimInfo);
        boolean isVirtual = this.isVirtual(this.dimInfo);
        this.getModel().beginInit();
        this.getModel().deleteEntryData(TREE_ENTRY_ENTITY);
        DynamicObjectCollection _members = QueryServiceHelper.query((String)this.getEntityNumber(this.dimInfo), (String)selectFields, (QFilter[])builder.toArray(), (String)this.getMemberTreeOrderBy());
        DynamicObject[] members = _members != null ? (DynamicObject[])_members.toArray((Object[])new DynamicObject[_members.size()]) : new DynamicObject[]{};
        members = this.reGetMember(members, selectFields);
        TreeEntryEntityUtils.buildMemberTree((IDataModel)this.getModel(), (DynamicObject[])members, (String[])properties, (boolean)isVirtual, (Long)viewId);
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREE_ENTRY_ENTITY);
        if (isVirtual) {
            treeEntry.setCollapse(true);
            treeEntry.expandOne(0);
        } else {
            treeEntry.setCollapse(false);
        }
        String[] allShowFields = DimShowPropertyEnum.getEnumBySign((String)"all").getShowlist();
        this.getView().setVisible(Boolean.FALSE, allShowFields);
        this.getView().setVisible(Boolean.TRUE, properties);
        this.getModel().endInit();
        this.getView().updateView(TREE_ENTRY_ENTITY);
        treeEntry.selectRows(0);
    }

    protected void initMemberTreeV2(String id, Long tarId) {
    }

    protected String getMemberTreeOrderBy() {
        return "level, dseq, number";
    }

    protected static Set<String> getVirtualDims() {
        return virtualDims;
    }

    protected boolean isVirtual(DimManagerInfo dimInfo) {
        String dimNumber = dimInfo.getDimension().getNumber();
        return !dimInfo.getDimension().isSysDimension() || BaseDimensionManager.getVirtualDims().contains(dimNumber);
    }

    protected abstract String getSelectFields(DimManagerInfo var1);

    protected abstract String[] getProperties(DimManagerInfo var1);

    protected String getEntityNumber(DimManagerInfo dimInfo) {
        if (IDUtils.isNull((Long)dimInfo.getViewId())) {
            return dimInfo.getDimension().getMembermodel();
        }
        return "eb_viewmember";
    }

    protected QFBuilder getQueryMemberBuilder(DimManagerInfo dimInfo) {
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)dimInfo.getModel().getId());
        builder.add("dimension", "=", (Object)dimInfo.getDimension().getId());
        builder.add("membersource", "!=", (Object)MemberSourceEnum.COSMIC_INVISIBLE.getIndex());
        if (!dimInfo.getDimension().getNumber().equals(SysDimensionEnum.AuditTrail.getNumber())) {
            builder.add("enable", "=", (Object)"1");
        }
        return builder;
    }

    public void forceMember(DimManagerInfo dimInfo) {
        if (dimInfo == null) {
            return;
        }
        boolean force = false;
        DynamicObjectCollection dcs = this.getModel().getEntryEntity(TREE_ENTRY_ENTITY);
        if (dimInfo.getMember().getSeq() >= 0 && dimInfo.getMember().getSeq() < dcs.size() && ((DynamicObject)dcs.get(dimInfo.getMember().getSeq())).getString("number").equals(dimInfo.getMember().getNumber())) {
            TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(TREE_ENTRY_ENTITY);
            entryGrid.selectRows(dimInfo.getMember().getSeq());
            force = true;
        }
        if (!force) {
            int count = dcs.size();
            for (int index = 0; index < count; ++index) {
                if (!((DynamicObject)dcs.get(index)).getString("number").equals(dimInfo.getMember().getNumber())) continue;
                TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(TREE_ENTRY_ENTITY);
                entryGrid.selectRows(index);
                break;
            }
        }
    }

    public void clearCache() {
        this.clearSearchCache();
        this.clearCutCache();
    }

    protected void clearSearchCache() {
        this.getPageCache().remove(CACHE_CURRENTFOCUS);
        this.getPageCache().remove(CACHE_SEARCHRESULT);
    }

    protected void clearCutCache() {
        this.getPageCache().remove(CACHE_CUTMEMBERIDS);
        this.getPageCache().remove(CACHE_CUT_VIEW_MEMBERIDS);
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        DynamicObject next;
        this.dimInfo = this.getDimManagerInfo();
        int rowKey = evt.getRowKey();
        if (rowKey <= 0 || !this.isVirtual(this.dimInfo)) {
            return;
        }
        int entryRowCount = this.getModel().getEntryRowCount(TREE_ENTRY_ENTITY);
        DynamicObject parent = this.getModel().getEntryRowEntity(TREE_ENTRY_ENTITY, rowKey);
        long parentId = parent.getLong("id");
        DynamicObject dynamicObject = next = rowKey + 2 > entryRowCount ? null : this.getModel().getEntryRowEntity(TREE_ENTRY_ENTITY, rowKey + 1);
        if (next != null && next.getLong("pid") == parentId && StringUtils.isNotEmpty((String)next.getString("number"))) {
            return;
        }
        QFBuilder builder = this.getQueryChildrenBuilder(this.dimInfo, parent);
        DynamicObjectCollection _members = QueryServiceHelper.query((String)this.getEntityNumber(this.dimInfo), (String)this.getSelectFields(this.dimInfo), (QFilter[])builder.toArray(), (String)"dseq,number");
        DynamicObject[] members = _members != null ? (DynamicObject[])_members.toArray((Object[])new DynamicObject[_members.size()]) : new DynamicObject[]{};
        this.reGetMember(members, this.getSelectFields(this.dimInfo));
        TreeEntryEntityUtils.batchInsertTreeEntryRows((IDataModel)this.getModel(), (DynamicObject[])members, (String[])this.getProperties(this.dimInfo), (int)rowKey, (Long)parentId);
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREE_ENTRY_ENTITY);
        String expandAll = this.getPageCache().get("expandAll");
        if (StringUtils.isEmpty((String)expandAll)) {
            this.getView().updateView(TREE_ENTRY_ENTITY);
        }
        this.getModel().updateCache();
        this.collapseExpNode(rowKey + 1, members.length, treeEntry);
        this.selectRows(treeEntry, rowKey);
    }

    protected QFBuilder getQueryChildrenBuilder(DimManagerInfo dimInfo, DynamicObject parent) {
        long modelId = dimInfo.getModel().getId();
        long dimensionId = dimInfo.getDimension().getId();
        long parentId = parent.getLong("id");
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)modelId);
        builder.add("dimension", "=", (Object)dimensionId);
        builder.add("parent", "=", (Object)parentId);
        builder.add("enable", "=", (Object)"1");
        builder.add("membersource", "!=", (Object)MemberSourceEnum.COSMIC_INVISIBLE.getIndex());
        return builder;
    }

    private void collapseExpNode(int beginRow, int rowCount, TreeEntryGrid entryGrid) {
        if (rowCount == 0) {
            return;
        }
        int[] allRowIndexs = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            allRowIndexs[i] = beginRow + i;
        }
        entryGrid.collapseOne(allRowIndexs);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        log.info("baseDimensionManger-treeNodeClick");
        this.clearCutCache();
        this.dimInfo = this.getDimManagerInfo();
        TreeView tree = (TreeView)evt.getSource();
        TreeView.TreeState state = tree.getTreeState();
        Map focusNode = state.getFocusNode();
        if (TREE_DIM.equals(tree.getKey())) {
            this.getPageCache().remove("currentNodeKey");
            this.dimTreeNodeClick(evt, this.dimInfo, focusNode);
        } else if (focusNode != null && TREE_VIEW.equals(tree.getKey())) {
            this.viewTreeNodeClick(evt, this.dimInfo, focusNode);
        }
        this.dimInfo.setMemberNull();
        this.clickTreeAction(tree);
        this.cacheDimManagerInfo();
    }

    protected void dimTreeNodeClick(TreeNodeEvent evt, DimManagerInfo dimInfo, Map<String, Object> focusNode) {
        if (focusNode != null) {
            String dimensionId = focusNode.get("id").toString();
            dimInfo.setDimension(Long.parseLong(dimensionId));
            dimInfo.setView(Long.valueOf(0L));
        }
    }

    protected void viewTreeNodeClick(TreeNodeEvent evt, DimManagerInfo dimInfo, Map<String, Object> focusNode) {
    }

    protected void clickTreeAction(TreeView tree) {
        String key = tree.getKey();
        if (TREE_DIM.equals(key)) {
            this.setLabelName(ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u6210\u5458", (String)"DimensionManagerList_3", (String)"epm-eb-formplugin", (Object[])new Object[]{this.dimInfo.getDimension().getName()}));
        } else if (TREE_VIEW.equals(key)) {
            this.setLabelName(ResManager.loadResFormat((String)"%1\u6210\u5458", (String)"DimensionManagerList_42", (String)"epm-eb-formplugin", (Object[])new Object[]{this.dimInfo.getView().getName()}));
        }
        Long viewId = this.dimInfo.getViewId();
        this.setHyperLink(viewId);
        this.setBtnVisible(this.dimInfo);
        if (View.NoViewDimNums.contains(this.dimInfo.getDimension().getNumber()) || this.dimInfo.getModel().isEb()) {
            this.initMemberTree();
        }
    }

    protected void setHyperLink(Long viewId) {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREE_ENTRY_ENTITY);
        if ("BudgetPeriod".equals(this.dimInfo.getDimension().getNumber())) {
            Boolean showFlag = Boolean.FALSE;
            if (MemberParamsUtils.isPeriodUserDefine((long)this.getModelId())) {
                showFlag = Boolean.TRUE;
            }
            treeEntryGrid.setColumnProperty("number", "ln", (Object)showFlag);
        } else if (this.isChangeType(this.dimInfo) || this.isEntity(this.dimInfo)) {
            treeEntryGrid.setColumnProperty("number", "ln", (Object)Boolean.TRUE);
        } else if (IDUtils.isNull((Long)viewId)) {
            treeEntryGrid.setColumnProperty("number", "ln", (Object)Boolean.TRUE);
        } else {
            treeEntryGrid.setColumnProperty("number", "ln", (Object)Boolean.FALSE);
        }
    }

    protected void setLabelName(String name) {
        Label label = (Label)this.getControl(LABEL_MEMBERNAME);
        label.setText(name);
    }

    protected void setBtnVisible(DimManagerInfo dimInfo) {
        String memberKey = dimInfo.getDimension().getMembermodel();
        Long viewId = dimInfo.getViewId();
        if (IDUtils.isNotNull((Long)viewId)) {
            QFilter qFilter = new QFilter("id", "=", (Object)viewId);
            DynamicObject view = QueryServiceHelper.queryOne((String)"eb_dimensionview", (String)"id,usage", (QFilter[])qFilter.toArray());
            memberKey = view != null && "1".equals(view.getString("usage")) ? "analyseView" : "noButton";
        }
        String[] operateKeys = this.getOperateKeys(memberKey);
        this.getView().setVisible(Boolean.FALSE, this.getOperateAllKeys());
        this.getView().setVisible(Boolean.TRUE, operateKeys);
    }

    protected String[] getOperateKeys(String entityNumber) {
        return DimOperationEnum.getOperateKeys((long)this.getModelId(), (String)entityNumber);
    }

    protected String[] getOperateAllKeys() {
        return DimOperationEnum.ALL.getOperateKeys();
    }

    public void search(SearchEnterEvent evt) {
        if (this.isSearch(evt)) {
            this.clearSearchCache();
            this.doSearch(evt);
        }
    }

    private boolean isSearch(SearchEnterEvent evt) {
        String text = evt.getText().trim().toLowerCase();
        this.dimInfo = this.getDimManagerInfo();
        if (this.dimInfo.getModel() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"EbDimensionManagerList_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.dimInfo.getDimension() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6", (String)"EbDimensionManagerList_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isEmpty((String)text)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8981\u67e5\u8be2\u7684\u5185\u5bb9\u3002", (String)"EbDimensionManagerList_33", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    abstract void doSearch(SearchEnterEvent var1);

    @Override
    public Long getModelId() {
        Object model = this.getModel().getValue("model");
        if (model == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"DimensionManagerList_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return ((DynamicObject)model).getLong("id");
    }

    protected DynamicObject[] reGetMember(DynamicObject[] members, String selectFields) {
        return members;
    }

    protected Long getModelIdAfterCreateNewData(Long modelId) {
        return modelId;
    }

    protected void selectRows(TreeEntryGrid treeEntry, int rowKey) {
        treeEntry.selectRows(rowKey);
    }

    @Override
    public void mainSubReadyForDataBeforeItemClick() {
        super.mainSubReadyForDataBeforeItemClick();
        this.setMemberId();
    }

    static {
        virtualDims.add(SysDimensionEnum.Entity.getNumber());
        virtualDims.add(SysDimensionEnum.Account.getNumber());
        virtualDims.add(SysDimensionEnum.BudgetPeriod.getNumber());
        virtualDims.add(SysDimensionEnum.InternalCompany.getNumber());
    }

    public static enum EnumTime {
        A,
        B,
        C;

    }
}

