/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.servicehelper.DimensionServiceHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.EbDimOperationEnum;
import kd.epm.eb.common.enums.dimensionEnums.EbDimShowPropertyEnum;
import kd.epm.eb.common.enums.dimensionEnums.EbMemberSelectFields;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.TreeNodeUtils;
import kd.epm.eb.cube.dimension.entitys.DimManagerInfo;
import kd.epm.eb.formplugin.dimension.BaseDimensionManager;

public class EbDimensionManagerList
extends BaseDimensionManager {
    private static final String MEMBER_PREVIOUS = "upmember";
    private static final String MEMBER_DOWN = "downmember";
    private static final String SEARCH_MEMBER = "searchmember";
    public static final Set<String> hideEbDims = new HashSet<String>();

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{MEMBER_PREVIOUS, MEMBER_DOWN});
        Search searchMember = (Search)this.getControl(SEARCH_MEMBER);
        searchMember.addEnterListener((SearchEnterListener)this);
        this.addF7SelectListener(this, new String[]{"model"});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"btn_addperiod", "btn_customproperty"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"btn_addperiod", "btn_customproperty"});
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent evt) {
        super.hyperLinkClick(evt);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        this.dimInfo = this.getDimManagerInfo();
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "upmember": 
            case "downmember": {
                this.memberSearchOperate(key);
                break;
            }
        }
        this.cacheDimManagerInfo();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "btn_addperiod": {
                this.updatePeriodStatus(evt);
                this.refreshMember();
                break;
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
    }

    @Override
    protected Set<String> getHideDims() {
        return hideEbDims;
    }

    @Override
    protected QFBuilder getQueryMemberBuilder(DimManagerInfo dimInfo) {
        QFBuilder builder = super.getQueryMemberBuilder(dimInfo);
        if (!this.isModelAdmin(dimInfo)) {
            builder.add("id", "in", this.getBaseViewHasPermMemberIds(dimInfo, this.isVirtual(dimInfo)));
        } else if (this.isVirtual(dimInfo)) {
            builder.add("level", "in", (Object)new int[]{1, 2});
        }
        if ("Entity".equals(dimInfo.getDimension().getNumber())) {
            builder.add("number", "!=", (Object)"RatePreset");
        }
        return builder;
    }

    @Override
    protected String getSelectFields(DimManagerInfo dimInfo) {
        return EbMemberSelectFields.getSelectFields((String)dimInfo.getDimension().getMembermodel());
    }

    @Override
    protected String[] getProperties(DimManagerInfo dimInfo) {
        EbDimShowPropertyEnum showProp = EbDimShowPropertyEnum.getEnumBySign((String)dimInfo.getDimension().getMembermodel());
        return showProp.getShowlist();
    }

    @Override
    protected void setBtnVisible(DimManagerInfo dimInfo) {
        super.setBtnVisible(dimInfo);
        String memberKey = dimInfo.getDimension().getMembermodel();
        if ("epm_periodmembertree".equals(memberKey)) {
            if (dimInfo.getModel().getPeriodStatus().size() == 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"btn_addperiod"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"btn_addperiod"});
            }
        }
    }

    @Override
    protected String[] getOperateKeys(String entityNumber) {
        return EbDimOperationEnum.getOperateKeys((String)entityNumber);
    }

    @Override
    protected String[] getOperateAllKeys() {
        return EbDimOperationEnum.ALL.getOperateKeys();
    }

    @Override
    public void search(SearchEnterEvent evt) {
        super.search(evt);
    }

    @Override
    void doSearch(SearchEnterEvent evt) {
        String text = evt.getText().trim().toLowerCase();
        this.searchMember(text);
    }

    private void searchMember(String text) {
        TreeNode root = this.getAllSearchMember();
        if (root == null) {
            return;
        }
        ArrayList<String> searchResult = new ArrayList<String>(10);
        this.getSearchResult(searchResult, root, text);
        if (searchResult.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u9879\u3002", (String)"EbDimensionManagerList_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String focusId = (String)searchResult.get(0);
        long selectMemberId = this.getSelectMemberId();
        String matchId = this.findMatchChild(root, String.valueOf(selectMemberId), searchResult);
        if (matchId != null) {
            focusId = matchId;
        }
        ArrayList<String> parentList = new ArrayList<String>(16);
        this.findHasLoadParent(root, focusId, parentList);
        ArrayList<Integer> expendRows = new ArrayList<Integer>(parentList.size());
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
        for (int i = parentList.size() - 1; i > 0; --i) {
            String parentId = (String)parentList.get(i);
            int rowIndex = this.getEntryEntityRow(parentId);
            expendRows.add(rowIndex);
            this.expendOneEvevt(rowIndex, treeEntryGrid);
        }
        int row = this.getEntryEntityRow((String)parentList.get(0));
        this.getView().updateView("treeentryentity");
        treeEntryGrid.expandOne(expendRows.stream().mapToInt(Integer::intValue).toArray());
        treeEntryGrid.selectRows(row);
        this.getPageCache().put("currentFocus", focusId);
        this.getPageCache().put("searchResult", SerializationUtils.serializeToBase64(searchResult));
    }

    private void memberSearchOperate(String key) {
        String focusid = this.getPageCache().get("currentFocus");
        String result = this.getPageCache().get("searchResult");
        if (focusid == null || result == null) {
            return;
        }
        List searchResult = (List)SerializationUtils.deSerializeFromBase64((String)result);
        int i = searchResult.indexOf(focusid);
        if (i == -1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5931\u8d25\u3002", (String)"EbDimensionManagerList_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (MEMBER_PREVIOUS.equals(key)) {
            if (--i < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u7b2c\u4e00\u6761", (String)"EbDimensionManagerList_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if (MEMBER_DOWN.equals(key) && ++i > searchResult.size() - 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd9\u662f\u6700\u540e\u4e00\u6761\u8bb0\u5f55\u3002", (String)"EbDimensionManagerList_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        focusid = (String)searchResult.get(i);
        TreeNode root = this.getAllSearchMember();
        ArrayList<String> parentList = new ArrayList<String>(16);
        this.findHasLoadParent(root, focusid, parentList);
        ArrayList<Integer> expendRows = new ArrayList<Integer>(parentList.size());
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
        for (int j = parentList.size() - 1; j > 0; --j) {
            String parentId = (String)parentList.get(j);
            int rowIndex = this.getEntryEntityRow(parentId);
            expendRows.add(rowIndex);
            this.expendOneEvevt(rowIndex, treeEntryGrid);
        }
        this.getView().updateView("treeentryentity");
        treeEntryGrid.expandOne(expendRows.stream().mapToInt(Integer::intValue).toArray());
        treeEntryGrid.selectRows(this.getEntryEntityRow((String)parentList.get(0)));
        this.getPageCache().put("currentFocus", focusid);
    }

    private int getEntryEntityRow(String id) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("treeentryentity");
        for (DynamicObject object : entryEntity) {
            if (!id.equals(object.getString("id"))) continue;
            return object.getInt("seq") - 1;
        }
        return -1;
    }

    private void findHasLoadParent(TreeNode root, String id, List<String> parentList) {
        if (root == null || id == null || parentList == null) {
            return;
        }
        parentList.add(id);
        TreeNode node = root.getTreeNode(id, 20);
        if (node != null) {
            String parentId = node.getParentid();
            if ("0".equals(parentId)) {
                return;
            }
            TreeNode parent = root.getTreeNode(parentId, 20);
            if (parent == null) {
                parentList.add(root.getId());
                return;
            }
            this.findHasLoadParent(root, parentId, parentList);
        }
    }

    private TreeNode getAllSearchMember() {
        long modelId = this.dimInfo.getModel().getId();
        long dimensionId = this.dimInfo.getDimension().getId();
        String memberKey = this.dimInfo.getDimension().getMembermodel();
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        qfBuilder.add("dimension", "=", (Object)dimensionId);
        qfBuilder.add("enable", "=", (Object)"1");
        if (!this.isModelAdmin(this.dimInfo)) {
            qfBuilder.add("id", "in", this.getBaseViewHasPermMemberIds(this.dimInfo, false));
        }
        if ("Entity".equals(this.dimInfo.getDimension().getNumber())) {
            qfBuilder.add("number", "!=", (Object)"RatePreset");
        }
        String selectFields = "id,name,number,parent,dseq";
        DynamicObjectCollection query = QueryServiceHelper.query((String)memberKey, (String)selectFields, (QFilter[])qfBuilder.toArray(), (String)"level,dseq");
        TreeNode root = null;
        HashMap<String, TreeNode> members = new HashMap<String, TreeNode>(query.size());
        for (DynamicObject member : query) {
            String number = member.getString("number");
            TreeNode node = TreeNodeUtils.createTreeNodeByObject((DynamicObject)member, (String)number, (String[])new String[]{"id", "name", "number", "parent", "dseq"});
            members.put(member.getString("id"), node);
            if (root != null || !this.dimInfo.getDimension().getNumber().equals(number)) continue;
            root = node;
        }
        if (root == null) {
            return null;
        }
        String shareFields = "id,number,name,parent,dseq,storagetype,isleaf,modifier.name as modifier,modifytime";
        Map shareMembers = DimensionServiceHelper.queryShareMemberGroupByParentId((Long)modelId, (Long)dimensionId, (String)shareFields);
        root.setParentid("0");
        return TreeNodeUtils.createTreeContainShare(members, root, (Map)shareMembers);
    }

    private String findMatchChild(TreeNode root, String id, List<String> searchResult) {
        List children;
        if (searchResult.contains(id)) {
            return id;
        }
        TreeNode treeNode = root.getTreeNode(id, 20);
        if (treeNode != null && (children = treeNode.getChildren()) != null) {
            for (TreeNode child : children) {
                String temp = this.findMatchChild(child, child.getId(), searchResult);
                if (temp == null) continue;
                return temp;
            }
        }
        return null;
    }

    @Override
    protected void setHyperLink(Long viewId) {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
        if ("BudgetPeriod".equals(this.dimInfo.getDimension().getNumber())) {
            treeEntryGrid.setColumnProperty("number", "ln", (Object)Boolean.TRUE);
        }
    }

    private void getSearchResult(List<String> searchResult, TreeNode root, String text) {
        List children;
        if (searchResult == null || root == null) {
            return;
        }
        String id = root.getId();
        HashMap data = (HashMap)root.getData();
        String _number = (String)data.get("number");
        String _name = (String)data.get("name");
        if (StringUtils.isNotEmpty((String)_number) && _number.toLowerCase().contains(text) || StringUtils.isNotEmpty((String)_name) && _name.toLowerCase().contains(text)) {
            searchResult.add(id);
        }
        if ((children = root.getChildren()) != null) {
            for (TreeNode child : children) {
                this.getSearchResult(searchResult, child, text);
            }
        }
    }

    private void expendOneEvevt(int row, TreeEntryGrid treeEntry) {
        TreeNodeEvent treeNodeEvent = new TreeNodeEvent((Object)treeEntry);
        treeNodeEvent.setRowKey(row);
        this.queryTreeNodeChildren(treeNodeEvent);
    }

    private void updatePeriodStatus(ClosedCallBackEvent evt) {
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        this.dimInfo = this.getDimManagerInfo();
        List list = (List)SerializationUtils.fromJsonString((String)returnData.toString(), List.class);
        List periodStatus = this.dimInfo.getModel().getPeriodStatus();
        periodStatus.removeAll(list);
        if (periodStatus.size() == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_addperiod"});
        }
        this.cacheDimManagerInfo();
    }

    static {
        hideEbDims.add(SysDimensionEnum.Process.getNumber());
        hideEbDims.add(SysDimensionEnum.Scenario.getNumber());
        hideEbDims.add(SysDimensionEnum.DataType.getNumber());
    }
}

