/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.tree.EntityAdjustTreeBuilder;
import kd.epm.eb.business.tree.MemberTreeBuilder;
import kd.epm.eb.common.enums.F7RangeTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.F7TreeUtils;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.tree.TreeNodeUtils;
import kd.epm.eb.cube.dimension.entitys.DimManagerInfo;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.dimension.action.BaseOperationAction;
import kd.epm.eb.formplugin.dimension.action.MoveBatchMoveAction;
import kd.epm.eb.formplugin.dimension.utils.CheckDecomposeUtils;
import kd.epm.eb.formplugin.dimension.utils.CheckOffsetUtils;
import kd.epm.eb.formplugin.dimension.utils.MemberCheckUtils;
import kd.epm.eb.formplugin.memberf7.newf7.base.SearchControlPojo;
import kd.epm.eb.formplugin.memberf7.newf7.face.ISearchTree;
import kd.epm.eb.formplugin.utils.PluginUtils;
import org.jetbrains.annotations.NotNull;

public class EntityAdjustPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
ISearchTree,
TreeNodeQueryListener {
    private static final Log log = LogFactory.getLog(EntityAdjustPlugin.class);
    private static final String LEFT_TREE = "lefttree";
    private static final String RIGHT_TREE = "righttree";
    private static final String VIEW_OLD_VALUE = "view_old_value";
    private static final String VIEW_NEW_VALUE = "view_new_value";
    private static final String BTN_MOVE = "btnmove";
    private static final String BTN_SUBMIT = "btnsubmit";
    private static final String BTN_CANCEL = "btncancel";
    private static final String CALLBACK_SUBMIT = "callBack_submit";
    private static final String CALLBACK_CANCEL = "callBack_cancel";
    private static final String CALLBACK_SWITCH_F7 = "callBack_switchF7";
    private static final String LEAF_CACHE_KEY = "CACHE_F7_TREE_MEMBER_NODE_DATA_lefttree";
    private static final String LEAF_PROPERTY_CACHE_KEY = "CACHE_F7_TREE_MEMBER_NODE_DATA_treeproperty";
    private static final String RIGHT_CACHE_KEY = "CACHE_F7_TREE_MEMBER_NODE_DATA_righttree";
    private static final String ENTITY_MOVE_NODE_IDS = "entityMoveNodeIds";

    public void initialize() {
        super.initialize();
        this.getPageCache().put("model", IDUtils.toString(PluginUtils.getCustomParams(this.getView(), "model")));
        BasedataEdit _f7View = (BasedataEdit)this.getView().getControl("view");
        if (_f7View != null) {
            _f7View.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{BTN_MOVE, BTN_SUBMIT, BTN_CANCEL});
        this.innerInitialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long initViewId = this.initView();
        this.initTree(initViewId);
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        MemberF7Parameter f7Param = this.getF7Parameter();
        if (f7Param == null) {
            return;
        }
        ComboEdit showScope = (ComboEdit)this.getControl("showscope");
        showScope.setComboItems(f7Param.getRangeItems());
        this.setDefaultValue(f7Param, "showscope");
    }

    protected void setDefaultValue(MemberF7Parameter f7Param, String controlKey) {
        if (f7Param.getDefRangeValue() != null) {
            this.getModel().setValue(controlKey, (Object)String.valueOf(f7Param.getDefRangeValue().getIndex()));
        } else {
            this.getModel().setValue(controlKey, (Object)String.valueOf(RangeEnum.ONLY.getIndex()));
        }
    }

    private void initTree(Long viewId) {
        this.removeLeftSearchText();
        this.removeRightSearchText();
        this.clearCache();
        this.initLeftTree(viewId);
        this.initRightTree(viewId);
    }

    private void clearCache() {
        this.putMoveNodeIds(null);
        this.putLeftTreeCache(null);
        this.putLeftPropertyTreeCache(null);
        this.putRightTreeCache(null);
    }

    private Long initView() {
        Long viewId = IDUtils.toLong(PluginUtils.getCustomParams(this.getView(), "viewId"));
        this.getModel().setValue("view", (Object)viewId);
        return viewId;
    }

    protected Long getViewId() {
        DynamicObject view = (DynamicObject)this.getModel().getValue("view");
        if (view != null) {
            return view.getLong("id");
        }
        return null;
    }

    private void initLeftTree(Long viewId) {
        MemberF7Parameter f7Param = this.getF7Param(viewId);
        f7Param.setStepLoad(false);
        f7Param.setFunctionType(1);
        f7Param.setCanSelectRoot(false);
        f7Param.addCustomCommFilter(new QFilter("isoffsetentry", "=", (Object)Character.valueOf('0')));
        EntityAdjustTreeBuilder.get((MemberF7Parameter)f7Param).setTreeKey(LEFT_TREE).buildTree((TreeView)this.getControl(LEFT_TREE), this.getPageCache());
        this.initPropertyTree();
    }

    private void initRightTree(Long viewId) {
        MemberF7Parameter f7Param = this.getF7Param(viewId);
        f7Param.addCustomCommFilter(new QFilter("isoffsetentry", "=", (Object)Character.valueOf('0')));
        EntityAdjustTreeBuilder.get((MemberF7Parameter)f7Param).setTreeKey(RIGHT_TREE).buildTree((TreeView)this.getControl(RIGHT_TREE), this.getPageCache());
    }

    protected MemberF7Parameter getF7Param(Long viewId) {
        Long modelId = IDUtils.toLong(PluginUtils.getCustomParams(this.getView(), "model"));
        Long dimensionId = IDUtils.toLong(PluginUtils.getCustomParams(this.getView(), "dimensionId"));
        String dimensionNumber = (String)PluginUtils.getCustomParams(this.getView(), "dimensionNumber");
        String dimensionName = (String)PluginUtils.getCustomParams(this.getView(), "dimensionName");
        MemberF7Parameter f7Param = new MemberF7Parameter();
        f7Param.setFields("id,name,number,parent.id,isleaf,memberid,membersource");
        f7Param.setModelId(modelId);
        f7Param.setDimensionId(dimensionId);
        f7Param.setDimensionNumber(dimensionNumber);
        f7Param.setDimensionName(dimensionName);
        if (IDUtils.isNotNull((Long)viewId)) {
            f7Param.setViewId(viewId);
        }
        f7Param.setEntityNumber(SysDimensionEnum.Entity.getMemberTreemodel());
        f7Param.setVerifyPermission(false);
        f7Param.setCutTree(false);
        f7Param.setShowLeaf(true);
        f7Param.setRangeType(F7RangeTypeEnum.CUSTOMIZE);
        f7Param.setCusRange((List)Lists.newArrayList((Object[])new String[]{RangeEnum.ALL.getIndStr(), RangeEnum.ALL_EXCLUDE.getIndStr(), RangeEnum.ALL_DETAIL.getIndStr()}));
        f7Param.setDefRangeValue(RangeEnum.ALL);
        f7Param.setShowCustomProperty(true);
        return f7Param;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if ("view".equals(evt.getProperty().getName())) {
            this.beforeF7Select_view(evt);
        }
    }

    protected void beforeF7Select_view(BeforeF7SelectEvent evt) {
        Long modelId = IDUtils.toLong(PluginUtils.getCustomParams(this.getView(), "model"));
        Long dimensionId = IDUtils.toLong(PluginUtils.getCustomParams(this.getView(), "dimensionId"));
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        ArrayList<QFilter> filters = ((BasedataEdit)evt.getSource()).getQFilters();
        if (filters == null) {
            filters = new ArrayList<QFilter>();
        }
        filters.add(new QFilter("model", "=", (Object)modelId));
        filters.add(new QFilter("dimension", "=", (Object)dimensionId));
        showParameter.setListFilterParameter(new ListFilterParameter(filters, null));
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        if ("view".equals(evt.getProperty().getName())) {
            this.propertyChanged_view(evt);
        }
    }

    protected void propertyChanged_view(PropertyChangedArgs evt) {
        if (evt.getChangeSet() == null || evt.getChangeSet().length == 0) {
            return;
        }
        String cacheOldView = this.getPageCache().get(VIEW_OLD_VALUE);
        ChangeData changeData = evt.getChangeSet()[0];
        String oldView = changeData.getOldValue() != null ? String.valueOf(((DynamicObject)changeData.getOldValue()).getLong("id")) : "";
        this.getPageCache().put(VIEW_OLD_VALUE, oldView);
        String newView = changeData.getNewValue() != null ? String.valueOf(((DynamicObject)changeData.getNewValue()).getLong("id")) : "";
        this.getPageCache().put(VIEW_NEW_VALUE, newView);
        if (newView.equals(cacheOldView)) {
            this.clearViewChange();
            return;
        }
        Map<String, String> moveNodeIds = this.getMoveNodeIds();
        if (moveNodeIds != null && !moveNodeIds.isEmpty()) {
            String title = ResManager.loadKDString((String)"\u5f53\u524d\u89c6\u56fe\u6709\u6210\u5458\u79fb\u52a8\u8bb0\u5f55\uff0c\u662f\u5426\u653e\u5f03\u5f53\u524d\u7684\u79fb\u52a8\u8bb0\u5f55\u5e76\u4e14\u5207\u6362\u89c6\u56fe\uff1f", (String)"EntityAdjustPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(title, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACK_SWITCH_F7, (IFormPlugin)this));
            return;
        }
        this.changeView();
    }

    private void clearViewChange() {
        this.getPageCache().remove(VIEW_OLD_VALUE);
        this.getPageCache().remove(VIEW_NEW_VALUE);
    }

    private void changeView() {
        String oldView = this.getPageCache().get(VIEW_OLD_VALUE);
        String newView = this.getPageCache().get(VIEW_NEW_VALUE);
        this.clearCache();
        this.clearViewChange();
        if (StringUtils.isEmpty((String)newView) && StringUtils.isNotEmpty((String)oldView)) {
            this.getModel().setValue("view", (Object)Long.parseLong(oldView));
            this.getView().updateView("view");
            return;
        }
        if (StringUtils.isNotEmpty((String)newView)) {
            this.initTree(Long.parseLong(newView));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "btnmove": {
                this.click_move();
                break;
            }
            case "btnsubmit": {
                this.click_submit();
                break;
            }
            case "btncancel": {
                this.click_cancel();
            }
        }
        this.click_search(evt);
    }

    protected void click_move() {
        try {
            TreeInfo info = this.checkCanMove();
            if (info.canMove) {
                this.moveNode(info);
            }
        }
        catch (Exception ex) {
            log.error("move-error", (Throwable)ex);
            this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u7ec4\u7ec7\u6279\u91cf\u8c03\u6574\u9519\u8bef\uff08%1\uff09", (String)"MoveBatchMoveAction_0", (String)"epm-eb-formplugin", (Object[])new Object[]{ex.getMessage()}));
        }
    }

    protected void click_submit() {
        Map<String, String> moveNodeIds = this.getMoveNodeIds();
        if (moveNodeIds == null || moveNodeIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u79fb\u52a8\u7684\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EntityAdjustPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        String title = ResManager.loadKDString((String)"\u63d0\u4ea4\u540e\u5f53\u524d\u7ec4\u7ec7\u89c6\u56fe\u4f1a\u6309\u8c03\u6574\u540e\u7684\u7ec4\u7ec7\u6811\u8fdb\u884c\u66f4\u65b0\uff0c\u8be5\u8c03\u6574\u4e0d\u53ef\u64a4\u9500\uff0c\u662f\u5426\u8fdb\u884c\u8c03\u6574\u64cd\u4f5c\uff1f", (String)"EntityAdjustPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        StringBuilder sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5ba1\u89c6\u7ec4\u7ec7\u8c03\u6574\u5bf9\u4ee5\u4e0b\u65b9\u9762\u7684\u5f71\u54cd\uff1a", (String)"EntityAdjustPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\\r\\n").append(ResManager.loadKDString((String)"1\u3001\u4e0e\u8c03\u6574\u7ec4\u7ec7\u76f8\u5173\u7684\u7f16\u5236\u89c6\u56fe\u6216\u7edf\u8ba1\u5206\u6790\u89c6\u56fe\uff1b", (String)"EntityAdjustPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\\r\\n").append(ResManager.loadKDString((String)"2\u3001\u4e0e\u8c03\u6574\u7ec4\u7ec7\u76f8\u5173\u7684\u4e1a\u52a1\u89c4\u5219\u3001\u52fe\u7a3d\u5173\u7cfb\uff1b", (String)"EntityAdjustPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\\r\\n").append(ResManager.loadKDString((String)"3\u3001\u4e0e\u8c03\u6574\u7ec4\u7ec7\u76f8\u5173\u7684\u9884\u7b97\u63a7\u5236\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\uff1b", (String)"EntityAdjustPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\\r\\n").append(ResManager.loadKDString((String)"4\u3001\u4e0e\u8c03\u6574\u7ec4\u7ec7\u76f8\u5173\u7684\u7ef4\u5ea6\u6210\u5458\u5173\u7cfb\u3002", (String)"EntityAdjustPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().showConfirm(title, sb.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CALLBACK_SUBMIT, (IFormPlugin)this));
    }

    protected void click_cancel() {
        Map<Long, Long> memberParentMap = this.getMemberParentMap();
        if (memberParentMap.isEmpty()) {
            this.closeAndReleaseMutex(false);
        } else {
            String title = ResManager.loadKDString((String)"\u8fd8\u6709\u672a\u63d0\u4ea4\u7684\u79fb\u52a8\u64cd\u4f5c\uff0c\u662f\u5426\u7ee7\u7eed\u9000\u51fa\uff1f", (String)"EntityAdjustPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(title, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CALLBACK_CANCEL, (IFormPlugin)this));
        }
    }

    protected void closeAndReleaseMutex(boolean refreshParent) {
        try {
            String dimensionId = IDUtils.toString(PluginUtils.getCustomParams(this.getView(), "dimensionId"));
            MutexHelper.release((String)"epm_dimension", (String)"modify", (String)dimensionId);
        }
        finally {
            if (refreshParent) {
                this.getView().returnDataToParent((Object)"refreshMemberCloseBack");
            }
            this.getView().close();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (MessageBoxResult.Yes != event.getResult()) {
            if (CALLBACK_SWITCH_F7.equals(event.getCallBackId())) {
                String oldView = this.getPageCache().get(VIEW_OLD_VALUE);
                this.getModel().setValue("view", (Object)Long.parseLong(oldView));
                this.getView().updateView("view");
            }
            return;
        }
        switch (event.getCallBackId()) {
            case "callBack_submit": {
                this.callBack_submit();
                break;
            }
            case "callBack_switchF7": {
                this.changeView();
                break;
            }
            case "callBack_cancel": {
                this.callBack_cancel();
            }
        }
    }

    protected void callBack_cancel() {
        this.closeAndReleaseMutex(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void callBack_submit() {
        block6: {
            Long modelId = IDUtils.toLong(PluginUtils.getCustomParams(this.getView(), "model"));
            Long dimensionId = IDUtils.toLong(PluginUtils.getCustomParams(this.getView(), "dimensionId"));
            DynamicObject view = (DynamicObject)this.getModel().getValue("view");
            try {
                Map<Long, Long> memberParentMap = this.getMemberParentMap();
                if (memberParentMap.isEmpty()) break block6;
                DimManagerInfo dimInfo = new DimManagerInfo();
                dimInfo.setModel(modelId.longValue());
                dimInfo.setDimension(dimensionId.longValue());
                dimInfo.setView(Long.valueOf(view != null ? view.getLong("id") : 0L));
                MoveBatchMoveAction batchMove = new MoveBatchMoveAction(this.getView(), (IFormPlugin)this, this.getModel(), this.getPageCache(), dimInfo);
                batchMove.setMemberParentMap(memberParentMap);
                LogStats stats = new LogStats("member-log:");
                stats.addInfo("begin-batchMove-entity.");
                batchMove.setStats(stats);
                try {
                    batchMove.beforeAction();
                    if (batchMove.isBeforeAction()) {
                        batchMove.doAction();
                    }
                }
                finally {
                    batchMove.afterAction();
                    this.closeAndReleaseMutex(true);
                    log.info(stats.toString());
                }
            }
            catch (Exception ex) {
                log.error("move-submit-error:", (Throwable)ex);
                this.getView().getParentView().showErrorNotification(ResManager.loadResFormat((String)"\u7ec4\u7ec7\u6279\u91cf\u8c03\u6574\u9519\u8bef\uff08%1\uff09", (String)"MoveBatchMoveAction_0", (String)"epm-eb-formplugin", (Object[])new Object[]{ex.getMessage()}));
                this.getView().sendFormAction(this.getView().getParentView());
            }
        }
    }

    protected Map<Long, Long> getMemberParentMap() {
        Map<String, String> moveNodeIds = this.getMoveNodeIds();
        if (moveNodeIds == null || moveNodeIds.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap memberParentMap = Maps.newLinkedHashMapWithExpectedSize((int)moveNodeIds.size());
        for (Map.Entry<String, String> entry : moveNodeIds.entrySet()) {
            String[] parents = entry.getValue().split("@");
            memberParentMap.put(IDUtils.toLong((Object)entry.getKey()), IDUtils.toLong((Object)parents[1]));
        }
        return memberParentMap;
    }

    protected TreeInfo checkCanMove() {
        Long modelId = IDUtils.toLong(PluginUtils.getCustomParams(this.getView(), "model"));
        Long dimensionId = IDUtils.toLong(PluginUtils.getCustomParams(this.getView(), "dimensionId"));
        DynamicObject view = (DynamicObject)this.getModel().getValue("view");
        Long viewId = view.getLong("id");
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)modelId);
        builder.add("view", "=", (Object)viewId);
        builder.add("dimension", "=", (Object)dimensionId);
        String memberNumber = "Entity";
        if (!"1".equals(view.getString("source"))) {
            memberNumber = memberNumber + "_" + view.getString("number");
        }
        builder.add("number", "=", (Object)memberNumber);
        DynamicObject root = QueryServiceHelper.queryOne((String)"eb_viewmember", (String)"memberid as id", (QFilter[])builder.toArray());
        TreeInfo treeInfo = this.getTreeInfo();
        treeInfo.leftTree = this.getLeftTreeCache();
        treeInfo.srcAllNodeIds = Sets.newLinkedHashSet();
        treeInfo.srcNodeIds = this.getLeftCheckedNodeIds(treeInfo.leftTree);
        this.filterTreeInfo(treeInfo);
        LinkedHashSet srcParentIds = Sets.newLinkedHashSet();
        if (CollectionUtils.isEmpty(treeInfo.srcNodeIds)) {
            if (this.isSelectProperty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5c5e\u6027\u6ca1\u6709\u542b\u6709\u5c5e\u6027\u503c\u7684\u6210\u5458\uff0c\u4e0d\u80fd\u8fdb\u884c\u7ec4\u7ec7\u8c03\u6574\u3002", (String)"EntityAdjustPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5de6\u6811\u4e0a\u9700\u8981\u79fb\u52a8\u7684\u7ec4\u7ec7\u6210\u5458\u3002", (String)"EntityAdjustPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            }
            return treeInfo;
        }
        for (String srcNodeId : treeInfo.srcNodeIds) {
            TreeNode parent;
            TreeNode node = treeInfo.leftTree.getTreeNode(srcNodeId);
            if (StringUtils.equals((String)node.getId(), (String)root.getString("id"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u6210\u5458\u4e0d\u53ef\u79fb\u52a8\u3002", (String)"EntityAdjustPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return treeInfo;
            }
            if (BaseOperationAction.checkInnerRefSource(true, (String)this.getMemberSource(node)) && BaseOperationAction.checkInnerRefSource(true, (String)this.getMemberSource(parent = treeInfo.leftTree.getTreeNode(node.getParentid())))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u5185\u5f15\u7528\u6210\u5458\u4e0d\u80fd\u79fb\u52a8\u3002", (String)"EntityAdjustPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return treeInfo;
            }
            srcParentIds.add(node.getParentid());
            TreeNodeUtils.getChildrenNodeIds((TreeNode)node, treeInfo.srcAllNodeIds);
        }
        treeInfo.rightTree = this.getRightTreeCache();
        treeInfo.destNodeId = this.getRightSelectedNodeId();
        this.filterTreeInfo(treeInfo);
        TreeNode desNode = treeInfo.rightTree.getTreeNode(treeInfo.destNodeId);
        if (StringUtils.isEmpty((String)treeInfo.destNodeId) || desNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53f3\u6811\u4e0a\u76ee\u6807\u7ec4\u7ec7\u6210\u5458\u3002", (String)"EntityAdjustPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return treeInfo;
        }
        MemberCheckUtils utils = MemberCheckUtils.get();
        try {
            if (BaseOperationAction.checkInnerRefSource(true, (String)this.getMemberSource(desNode))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u79fb\u52a8\u5230\u7ec4\u5185\u5f15\u7528\u6210\u5458\u4e0b\u9762\u3002", (String)"EntityAdjustPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return treeInfo;
            }
            HashSet<Long> _srcNodeIds = new HashSet<Long>(IDUtils.toLongs(treeInfo.srcNodeIds));
            if (CheckOffsetUtils.get().checkParent(modelId, dimensionId, _srcNodeIds)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u79fb\u52a8\u6210\u5458\u7684\u7236\u6210\u5458\u4e0b\u53ea\u6709\u5f53\u524d\u7ec4\u7ec7\u4e14\u7236\u6210\u5458\u662f\u5408\u5e76\u8282\u70b9\uff0c\u4e0d\u5141\u8bb8\u79fb\u52a8\u3002", (String)"EntityAdjustPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return treeInfo;
            }
            if (CheckDecomposeUtils.get().checkParent(modelId, dimensionId, viewId, _srcNodeIds)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u79fb\u52a8\u6210\u5458\u662f\u5206\u89e3\u6210\u5458\u6216\u8005\u79fb\u52a8\u6210\u5458\u7684\u7236\u6210\u5458\u4e0b\u53ea\u6709\u5f53\u524d\u7ec4\u7ec7\u4e14\u7236\u6210\u5458\u662f\u5206\u89e3\u8282\u70b9\uff0c\u4e0d\u5141\u8bb8\u79fb\u52a8\u3002", (String)"EntityAdjustPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return treeInfo;
            }
            if (!utils.checkIsLeaf(modelId, dimensionId, viewId, CollectionUtils.asSet((Object[])new Long[]{IDUtils.toLong((Object)treeInfo.destNodeId)}))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u6210\u5458\u5df2\u7ecf\u6709\u6570\u636e\u6216\u8005\u63a7\u5236\u8bb0\u5f55\u3001\u63a7\u5236\u6620\u5c04\u3001\u8c03\u6574\u8bb0\u5f55\u3001\u7533\u62a5\u6570\u636e\uff0c\u4e0d\u80fd\u8c03\u6574\u6210\u975e\u660e\u7ec6\u6210\u5458\u3002", (String)"EntityAdjustPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return treeInfo;
            }
            if (utils.checkIsAllLeaf(modelId, dimensionId, viewId, CollectionUtils.asSet((Object[])new Long[]{IDUtils.toLong((Object)treeInfo.destNodeId)}))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u6210\u5458\u5728\u5176\u5b83\u89c6\u56fe\u4e5f\u662f\u660e\u7ec6\u6210\u5458\uff0c\u4e0d\u80fd\u8c03\u6574\u6210\u975e\u660e\u7ec6\u6210\u5458\u3002", (String)"EntityAdjustPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return treeInfo;
            }
        }
        catch (Exception ex) {
            this.getView().showTipNotification(ex.getMessage());
            return treeInfo;
        }
        if (treeInfo.srcAllNodeIds.contains(treeInfo.destNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9700\u8981\u79fb\u52a8\u7684\u6210\u5458\u4e0d\u80fd\u79fb\u52a8\u5230\u81ea\u5df1\u6216\u8005\u81ea\u5df1\u7684\u4e0b\u7ea7\u6210\u5458\u4e0b\u9762\u3002", (String)"EntityAdjustPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return treeInfo;
        }
        if (srcParentIds.contains(treeInfo.destNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u79fb\u52a8\u7684\u6210\u5458\u4e0d\u80fd\u79fb\u52a8\u5230\u5f53\u524d\u6210\u5458\u7684\u7236\u6210\u5458\u7684\u4e0b\u7ea7\u3002", (String)"EntityAdjustPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return treeInfo;
        }
        treeInfo.canMove = true;
        return treeInfo;
    }

    protected TreeInfo getTreeInfo() {
        return new TreeInfo();
    }

    protected void filterTreeInfo(TreeInfo treeInfo) {
    }

    protected void moveNode(TreeInfo treeInfo) {
        LinkedHashMap oldParentMap = Maps.newLinkedHashMap();
        TreeView leftTree = (TreeView)this.getControl(LEFT_TREE);
        TreeView rightTree = (TreeView)this.getControl(RIGHT_TREE);
        for (String srcNodeId : treeInfo.srcNodeIds) {
            TreeNode srcNode = treeInfo.leftTree.getTreeNode(srcNodeId);
            oldParentMap.put(srcNode.getId(), srcNode.getParentid());
            leftTree.deleteNode(srcNodeId);
            rightTree.deleteNode(srcNodeId);
            treeInfo.leftTree.deleteChildNode(srcNodeId);
            treeInfo.rightTree.deleteChildNode(srcNodeId);
            TreeNode srcParent = treeInfo.leftTree.getTreeNode(srcNode.getParentid());
            TreeNode destParent = treeInfo.rightTree.getTreeNode(srcNode.getParentid());
            if (srcParent != null && srcParent.getChildren().isEmpty()) {
                srcParent.setChildren(null);
                leftTree.updateNode(srcParent);
            }
            if (destParent != null && destParent.getChildren().isEmpty()) {
                destParent.setChildren(null);
                rightTree.updateNode(destParent);
            }
            srcNode.setParentid(treeInfo.destNodeId);
            leftTree.addNode(srcNode);
            rightTree.addNode(srcNode);
            TreeNode destNode = treeInfo.leftTree.getTreeNode(treeInfo.destNodeId);
            if (destNode != null) {
                destNode.addChild(srcNode);
            }
            if ((destNode = treeInfo.rightTree.getTreeNode(treeInfo.destNodeId)) == null) continue;
            destNode.addChild(srcNode);
        }
        Map<String, String> moveNodeIds = this.getMoveNodeIds();
        for (String _srcNodeId : treeInfo.srcNodeIds) {
            String _parent = moveNodeIds.get(_srcNodeId);
            if (_parent == null) {
                moveNodeIds.put(_srcNodeId, (String)oldParentMap.get(_srcNodeId) + '@' + treeInfo.destNodeId);
                continue;
            }
            if (StringUtils.equals((String)_parent, (String)(treeInfo.destNodeId + '@' + (String)oldParentMap.get(_srcNodeId)))) {
                moveNodeIds.remove(_srcNodeId);
                continue;
            }
            String[] _parents = _parent.split("@");
            moveNodeIds.put(_srcNodeId, _parents[0] + '@' + treeInfo.destNodeId);
        }
        this.putMoveNodeIds(moveNodeIds);
        this.putLeftTreeCache(treeInfo.leftTree);
        this.putRightTreeCache(treeInfo.rightTree);
    }

    protected List<String> getLeftCheckedNodeIds(TreeNode treeRoot) {
        List<String> selectedNodes = null;
        if (this.isSelectProperty()) {
            TreeView leftTree = (TreeView)this.getControl("treeproperty");
            if (leftTree != null) {
                selectedNodes = leftTree.getTreeState().getCheckedNodeIds();
            }
            if ((selectedNodes = this.queryOrgIdByProperty(selectedNodes, this.getViewId())) != null) {
                Iterator it = selectedNodes.iterator();
                while (it.hasNext()) {
                    if (treeRoot != null && treeRoot.getTreeNode((String)it.next()) != null) continue;
                    it.remove();
                }
            }
        } else {
            TreeView leftTree = (TreeView)this.getControl(LEFT_TREE);
            if (leftTree != null) {
                selectedNodes = leftTree.getTreeState().getCheckedNodeIds();
            }
            String range = (String)this.getModel().getValue("showscope");
            if (selectedNodes != null && !StringUtils.isEmpty((String)range) && !RangeEnum.ALL.getIndStr().equals(range)) {
                selectedNodes = this.querySelectNodeByRange(treeRoot, selectedNodes, range);
            }
        }
        return this.filterSelectedNodeIds(selectedNodes, treeRoot);
    }

    private List<String> querySelectNodeByRange(TreeNode treeRoot, List<String> selectedNodes, String range) {
        if (treeRoot == null || selectedNodes == null || selectedNodes.isEmpty() || StringUtils.isEmpty((String)range)) {
            return null;
        }
        ArrayList<String> nodeIds = new ArrayList<String>(selectedNodes.size());
        for (String nodeId : selectedNodes) {
            TreeNode node = treeRoot.getTreeNode(nodeId);
            if (node == null) continue;
            if (RangeEnum.ALL_EXCLUDE.getIndStr().equals(range)) {
                if (node.getChildren() == null) continue;
                node.getChildren().forEach(f -> nodeIds.add(f.getId()));
                continue;
            }
            this.addDetail(nodeIds, node);
        }
        return nodeIds;
    }

    private void addDetail(List<String> nodeIds, TreeNode node) {
        if (nodeIds == null || node == null) {
            return;
        }
        if (node.getChildren() != null && !node.getChildren().isEmpty()) {
            for (TreeNode child : node.getChildren()) {
                this.addDetail(nodeIds, child);
            }
        } else {
            nodeIds.add(node.getId());
        }
    }

    protected boolean isSelectProperty() {
        return "tabproperty".equals(((Tab)this.getControl("tabapleft")).getCurrentTab());
    }

    protected List<String> filterSelectedNodeIds(List<String> selectedNodes, TreeNode treeNode) {
        if (selectedNodes == null || selectedNodes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList parentIds = Lists.newArrayListWithExpectedSize((int)32);
        LinkedHashSet selectedNodeIds = Sets.newLinkedHashSetWithExpectedSize((int)selectedNodes.size());
        for (String nodeId : selectedNodes) {
            if (selectedNodeIds.isEmpty()) {
                selectedNodeIds.add(nodeId);
                continue;
            }
            parentIds.clear();
            TreeNodeUtils.getParentIds((String)nodeId, (TreeNode)treeNode, (Collection)parentIds);
            if (CollectionUtils.include((Collection)selectedNodeIds, (Collection)parentIds)) continue;
            selectedNodeIds.add(nodeId);
        }
        return new ArrayList<String>(selectedNodeIds);
    }

    protected TreeNode getLeftTreeCache() {
        return this.getTreeCache(LEAF_CACHE_KEY);
    }

    protected TreeNode getRightTreeCache() {
        return this.getTreeCache(RIGHT_CACHE_KEY);
    }

    private TreeNode getTreeCache(@NotNull String cacheKey) {
        return F7TreeUtils.getCacheTreeNodeData((IPageCache)this.getPageCache(), (String)cacheKey);
    }

    protected void putLeftTreeCache(TreeNode treeNode) {
        if (treeNode == null) {
            this.getPageCache().remove(LEAF_CACHE_KEY);
        } else {
            this.putTreeCache(LEAF_CACHE_KEY, treeNode);
        }
    }

    protected void putLeftPropertyTreeCache(TreeNode treeNode) {
        if (treeNode == null) {
            this.getPageCache().remove(LEAF_PROPERTY_CACHE_KEY);
        } else {
            this.putTreeCache(LEAF_PROPERTY_CACHE_KEY, treeNode);
        }
    }

    protected void putRightTreeCache(TreeNode treeNode) {
        if (treeNode == null) {
            this.getPageCache().remove(RIGHT_CACHE_KEY);
        } else {
            this.putTreeCache(RIGHT_CACHE_KEY, treeNode);
        }
    }

    private void putTreeCache(@NotNull String cacheKey, @NotNull TreeNode treeNode) {
        F7TreeUtils.cacheTreeNodeData((IPageCache)this.getPageCache(), (String)cacheKey, (TreeNode)treeNode);
    }

    protected String getRightSelectedNodeId() {
        TreeView leftTree = (TreeView)this.getControl(RIGHT_TREE);
        if (leftTree != null) {
            return leftTree.getTreeState().getFocusNodeId();
        }
        return null;
    }

    protected void putMoveNodeIds(Map<String, String> moveNodeIds) {
        if (moveNodeIds == null) {
            this.getPageCache().remove(ENTITY_MOVE_NODE_IDS);
        } else {
            this.getPageCache().put(ENTITY_MOVE_NODE_IDS, JSON.toJSONString(moveNodeIds));
        }
    }

    protected Map<String, String> getMoveNodeIds() {
        String _cacheStr = this.getPageCache().get(ENTITY_MOVE_NODE_IDS);
        if (StringUtils.isNotEmpty((String)_cacheStr)) {
            return (Map)JSON.parseObject((String)_cacheStr, LinkedHashMap.class);
        }
        return new LinkedHashMap<String, String>();
    }

    @Override
    public MemberF7Parameter getF7Parameter() {
        return this.getF7Param(null);
    }

    @Override
    public SearchControlPojo getMemberTreePojo() {
        SearchControlPojo pojo = ISearchTree.super.getMemberTreePojo();
        pojo.setTreeCacheKey(LEAF_CACHE_KEY);
        return pojo;
    }

    @Override
    public SearchControlPojo getPropertyTreePojo() {
        SearchControlPojo pojo = ISearchTree.super.getPropertyTreePojo();
        pojo.setTreeCacheKey("CACHE_TREE_PROPERTY_NODE_DATA");
        return pojo;
    }

    @Override
    public SearchControlPojo getRightTreePojo() {
        SearchControlPojo pojo = ISearchTree.super.getRightTreePojo();
        pojo.setTreeCacheKey(MemberTreeBuilder.get((MemberF7Parameter)this.getF7Parameter()).setTreeKey(RIGHT_TREE).getCacheTreeKey());
        return pojo;
    }

    public Object getMemberSource(TreeNode node) {
        if (node == null) {
            return null;
        }
        return node.getLongText();
    }

    public static class TreeInfo {
        public List<String> srcNodeIds = null;
        public Set<String> srcAllNodeIds = null;
        public TreeNode leftTree = null;
        public String destNodeId = null;
        public TreeNode rightTree = null;
        public boolean canMove = false;
    }
}

