/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.tree.AbstractTreeNode;
import kd.epm.eb.common.tree.ICEntityTreeNode;
import kd.epm.eb.common.tree.TreeModel;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.model.utils.ICEntityTreeBuilder;

public class LTreeRListPlugin
extends AbstractFormPlugin {
    private static final String TREELEFT = "treeleft";
    private static final String TREELEFTNODECLICK = "treeleftnodeclick";
    private static final String BILLLISTAP = "billlistap";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok"});
        final TreeView tree = (TreeView)this.getView().getControl(TREELEFT);
        final BillList billList = (BillList)this.getControl(BILLLISTAP);
        String formId = this.getBillFormId();
        billList.setBillFormId(formId);
        billList.setEntityId(formId);
        billList.addSetFilterListener(new SetFilterListener(){

            public void setFilter(SetFilterEvent event) {
                String serial = LTreeRListPlugin.this.getPageCache().get(LTreeRListPlugin.TREELEFTNODECLICK);
                String formId = LTreeRListPlugin.this.getBillFormId();
                QFilter qFilter = LTreeRListPlugin.this.getBillListFilter(formId);
                if (StringUtils.isNotEmpty((String)serial)) {
                    event.getQFilters().add(qFilter);
                } else {
                    event.getQFilters().clear();
                    event.getQFilters().add(qFilter);
                }
                event.setOrderBy("longnumber");
            }
        });
        tree.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                LTreeRListPlugin.this.treenodeClick(tree);
                billList.setClearSelection(true);
                billList.refresh();
            }
        });
    }

    public <T> T deSerializedBytes(String serial) {
        return (T)(serial == null ? null : ObjectSerialUtil.deSerializedBytes((String)serial));
    }

    public String toByteSerialized(Object t) {
        return ObjectSerialUtil.toByteSerialized((Object)t);
    }

    public void click(EventObject evt) {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        if (billList.getSelectedRows() == null || billList.getSelectedRows().size() < 1) {
            return;
        }
        ListSelectedRow selectRow = billList.getCurrentSelectedRowInfo();
        long id = (Long)selectRow.getPrimaryKeyValue();
        String formId = this.getBillFormId();
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)id, (String)formId);
        if ("epm_icmembertree".equalsIgnoreCase(formId) && !dy.getBoolean("isleaf")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u660e\u7ec6\u6210\u5458\u3002", (String)"LTreeRListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().setReturnData((Object)dy);
        this.getView().returnDataToParent((Object)dy);
        this.getView().close();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initLeftTree();
    }

    private void treenodeClick(TreeView tree) {
        TreeView.TreeState state = tree.getTreeState();
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        String formId = this.getBillFormId();
        if (state.getFocusNode() != null) {
            long id = Long.parseLong((String)state.getFocusNode().get("id"));
            this.getPageCache().put(TREELEFTNODECLICK, this.toByteSerialized(id));
        }
        QFilter qFilter = this.getBillListFilter(formId);
        billList.setFilter(qFilter);
        billList.setOrderBy("longnumber");
        billList.refresh();
    }

    public void initLeftTree() {
        QFBuilder qfBuilder;
        String formId = this.getBillFormId();
        DynamicObjectCollection doc = QueryServiceHelper.query((String)formId, (String)"id,name,number,parent,isleaf,0 as storagetype", (QFilter[])(qfBuilder = this.getTreeFilter(formId)).toArray());
        ICEntityTreeNode root = ICEntityTreeBuilder.getICEntityTreeNode((DynamicObjectCollection)doc);
        if (root != null) {
            TreeView tree = (TreeView)this.getControl(TREELEFT);
            tree.deleteAllNodes();
            this.buildLeftTree((AbstractTreeNode<Object>)root);
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
            qFilter.and(new QFilter("isleaf", "=", (Object)Character.valueOf('1')));
            billList.setFilter(qFilter);
            billList.refresh();
        }
    }

    private void buildLeftTree(AbstractTreeNode<Object> root) {
        TreeView tree = (TreeView)this.getControl(TREELEFT);
        if (root != null) {
            TreeModel treemodel = new TreeModel(root);
            TreeNode nodeRoot = treemodel.buildEntryTree(tree);
            nodeRoot.iterate(999, v -> v.setIsOpened(false));
            nodeRoot.iterate(0, v -> v.setIsOpened(true));
            if (root.getChildren() == null) {
                return;
            }
            this.getPageCache().put(TREELEFTNODECLICK, this.toByteSerialized(root.getId()));
            tree.treeNodeClick("", root.getId().toString());
        }
    }

    @Override
    public Long getModelId() {
        String modelId = this.getView().getFormShowParameter().getCustomParams().get("KEY_MODEL_ID").toString();
        return Long.valueOf(modelId);
    }

    private String getBillFormId() {
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("formid");
        if (StringUtils.isEmpty((String)formId)) {
            formId = "epm_icmembertree";
        }
        return formId;
    }

    private String getSeparator() {
        String separator = (String)this.getView().getFormShowParameter().getCustomParam("separator");
        if (StringUtils.isEmpty((String)separator)) {
            separator = "!";
        }
        return separator;
    }

    private QFBuilder getTreeFilter(String formId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("model", "=", (Object)this.getModelId()));
        if (!"eb_reportcatalog".equalsIgnoreCase(formId)) {
            qfBuilder.add(new QFilter("isleaf", "=", (Object)Character.valueOf('0')));
        }
        if ("eb_reportcatalog".equalsIgnoreCase(formId)) {
            qfBuilder.add(new QFilter("creator", "=", (Object)UserUtils.getUserId()));
            qfBuilder.add(new QFilter("number", "!=", (Object)"share"));
        }
        return qfBuilder;
    }

    private QFilter getBillListFilter(String formId) {
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        String serial = this.getPageCache().get(TREELEFTNODECLICK);
        if (StringUtils.isNotEmpty((String)serial)) {
            long id = (Long)this.deSerializedBytes(serial);
            DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)id, (String)formId, (String)"number");
            String number = dy == null ? "" : dy.getString("number");
            String separator = this.getSeparator();
            QFilter leafFilter = new QFilter("longnumber", "like", (Object)("%" + number + separator + "%"));
            if (!"eb_reportcatalog".equalsIgnoreCase(formId)) {
                leafFilter.and(new QFilter("isleaf", "=", (Object)Character.valueOf('1')));
            }
            QFilter rootFilter = new QFilter("number", "=", (Object)number).and(new QFilter("model", "=", (Object)this.getModelId()));
            qFilter.and(leafFilter.or(rootFilter));
        }
        if ("eb_reportcatalog".equalsIgnoreCase(formId)) {
            qFilter.and(new QFilter("creator", "=", (Object)UserUtils.getUserId()));
            qFilter.and(new QFilter("number", "!=", (Object)"share"));
        }
        return qFilter;
    }
}

