/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.shrek.controller.IShrekSave;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class OlapDataClear
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(OlapDataClear.class);
    private static final String FILTER_ENTITY = "filterentity";
    private static final String COLUMN_DIM_NAME = "dimname";
    private static final String COLUMN_DIM_NUMBER = "dimnumber";
    private static final String COLUMN_MEM_NAME = "memname";
    private static final String COLUMN_MEM_NUMBER = "memnumber";
    private static final String COLUMN_DATA = "data";
    private static final String RESULT_ENTITY = "resultentity";
    private static final String CACHE_MODEL = "modelCache";
    private static final String CACHE_DEFINE_DIMKEYS = "defineDimKeys";
    private static final String BTN_QUERY = "btn_query";
    private static final String BTN_CLEAR = "btn_clear";
    private static final List<String> ignoreDimArr = new ArrayList<String>(Arrays.asList("Scenario", "Process"));
    private static final Map<String, Object> ignoreDimMap = new HashMap<String, Object>();
    private static final Boolean aTrue;
    private static final Boolean aFalse;
    private static final String FMONEY = "FMONEY";
    private IModelCacheHelper modelCacheHelper = null;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{COLUMN_MEM_NAME});
    }

    public void afterCreateNewData(EventObject e) {
        ArrayList<Dimension> dimensionList;
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
        if (modelId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"OlapDataClear_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(CACHE_MODEL, String.valueOf(modelId));
        IModelCacheHelper modelContext = this.getModelCacheHelper(modelId);
        Model model = modelContext.getModelobj();
        if (model.isModelByEB()) {
            dimensionList = modelContext.getDimensionList();
            this.getView().setVisible(aFalse, new String[]{"panel"});
        } else {
            dimensionList = new ArrayList<Dimension>(0);
            this.setBaseDataEditMustInput();
        }
        this.buildFilterEntity(dimensionList);
        this.buildResultEntity(dimensionList);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_query": {
                this.clearEntryData(RESULT_ENTITY);
                this.handleQueryData();
                break;
            }
            case "btn_clear": {
                if (!this.checkIfSelection()) {
                    return;
                }
                this.handleClearData();
                break;
            }
        }
    }

    private boolean checkIfSelection() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(RESULT_ENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u6570\u636e\u3002", (String)"OlapDataClear_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void handleQueryData() {
        List<MembersKey> olapDataList = this.queryOlapData();
        List<MembersKey> olapDataListFilter = this.filterResultNullData(olapDataList);
        this.buildResultData(olapDataListFilter);
    }

    private void clearEntryData(String entryId) {
        int entryRowCount = this.getModel().getEntryRowCount(entryId);
        if (entryRowCount > 0) {
            this.getModel().deleteEntryData(entryId);
        }
    }

    private List<MembersKey> filterResultNullData(List<MembersKey> olapDataList) {
        if (olapDataList == null) {
            return new ArrayList<MembersKey>();
        }
        ArrayList<MembersKey> olapDataListFilter = new ArrayList<MembersKey>();
        for (MembersKey membersKey : olapDataList) {
            Object[] keys = membersKey.getKeys();
            if (keys == null || keys[0] == null) continue;
            olapDataListFilter.add(membersKey);
        }
        return olapDataListFilter;
    }

    private List<MembersKey> queryOlapData() {
        IModelCacheHelper modelContext = this.getModelCacheHelper(IDUtils.toLong((Object)this.getPageCache().get(CACHE_MODEL)));
        Model model = modelContext.getModelobj();
        Dataset dataset = new Dataset(model.getId(), model.getNumber());
        SelectCommandInfo query = new SelectCommandInfo();
        int filterEntryRowCount = this.getModel().getEntryRowCount(FILTER_ENTITY);
        for (int i = 0; i < filterEntryRowCount; ++i) {
            String dimNumber = this.getModel().getEntryRowEntity(FILTER_ENTITY, i).getString(COLUMN_DIM_NUMBER);
            query.addDims(new String[]{dimNumber});
            String numberListStr = (String)this.getModel().getValue(COLUMN_MEM_NUMBER, i);
            if (StringUtils.isEmpty((String)numberListStr)) continue;
            String[] numbers = numberListStr.split(",");
            query.addFilter(dimNumber, numbers);
        }
        query.addMeasures(new String[]{FMONEY});
        return ShrekOlapServiceHelper.queryData((Model)model, (Dataset)dataset, (SelectCommandInfo)query);
    }

    public IModelCacheHelper getModelCacheHelper(Long modelId) {
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        }
        return this.modelCacheHelper;
    }

    private void handleClearData() {
        IDataModel dataModel = this.getModel();
        EntryGrid entryGrid = (EntryGrid)this.getControl(RESULT_ENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        ArrayList<DynamicObject> modifyDynamicObjects = new ArrayList<DynamicObject>(selectRows.length);
        if (selectRows.length == 0) {
            return;
        }
        for (int selectRow : selectRows) {
            DynamicObject entryRowEntity = dataModel.getEntryRowEntity(RESULT_ENTITY, selectRow);
            entryRowEntity.set(COLUMN_DATA, (Object)"null");
            modifyDynamicObjects.add(entryRowEntity);
        }
        this.updateOlapData(modifyDynamicObjects);
        this.getView().updateView(RESULT_ENTITY);
    }

    private void updateOlapData(List<DynamicObject> modifyDynamicObjects) {
        if (modifyDynamicObjects == null) {
            return;
        }
        IModelCacheHelper modelContext = this.getModelCacheHelper(this.getModelId());
        Model model = modelContext.getModelobj();
        Dataset dataset = new Dataset(model.getId(), model.getNumber());
        List dimKeys = modelContext.getDimensionList();
        if (dimKeys == null) {
            return;
        }
        ArrayList<String> dimNumberValueList = null;
        Map map = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_DEFINE_DIMKEYS), HashMap.class);
        String dimNumber = "";
        String dimNumberValue = "";
        LogStats stats = new LogStats("budget-shrek-log : ");
        stats.add("begin-clear-data.");
        stats.addInfo("user:" + UserUtils.getUserName() + "; userId:" + UserUtils.getUserId());
        try (IShrekSave shrekOlapSave = ShrekOlapServiceHelper.saveData((Model)model, (Dataset)dataset, (String[])modelContext.getDimensionNums(), (Map)ShrekIdCodeUtils.getDefaultIdCodes((LogStats)stats));){
            for (DynamicObject dynamicObject : modifyDynamicObjects) {
                dimNumberValueList = new ArrayList<String>(dimKeys.size());
                for (Dimension dim : dimKeys) {
                    dimNumber = dim.getNumber();
                    if (map.get(dimNumber) != null) {
                        dimNumber = (String)map.get(dimNumber);
                    }
                    dimNumberValue = ignoreDimArr.contains(dimNumber) ? ignoreDimMap.get(dimNumber).toString() : dynamicObject.getString(dimNumber);
                    dimNumberValueList.add(dimNumberValue);
                }
                shrekOlapSave.add(dimNumberValueList.toArray(new String[0]), null);
            }
        }
        stats.add("end-clear-data.");
        log.info(stats.toString());
    }

    private void buildResultData(List<MembersKey> olapDataList) {
        if (olapDataList.isEmpty()) {
            return;
        }
        int rowIndex = 0;
        Map map = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_DEFINE_DIMKEYS), HashMap.class);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(FILTER_ENTITY);
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper(this.getModelId());
        Map dimensionMap = modelCacheHelper.getDimensionMap();
        IDataModel model = this.getModel();
        model.beginInit();
        this.getModel().batchCreateNewEntryRow(RESULT_ENTITY, olapDataList.size());
        for (MembersKey membersKey : olapDataList) {
            Object[] keys = membersKey.getKeys();
            DynamicObject dynamicObject = model.getEntryRowEntity(RESULT_ENTITY, rowIndex++);
            int length = keys.length;
            for (int i = 0; i < length; ++i) {
                String prop;
                Object value = null;
                if (i == 0) {
                    prop = COLUMN_DATA;
                } else {
                    Member member;
                    prop = ((DynamicObject)entryEntity.get(i - 1)).get(COLUMN_DIM_NUMBER).toString();
                    Dimension dimension = (Dimension)dimensionMap.get(prop);
                    if (dimension != null && (member = dimension.getStructOfMember((String)keys[i])) != null) {
                        value = member.getName() + "\r\n" + member.getNumber();
                    }
                }
                if (map.get(prop) != null) {
                    prop = (String)map.get(prop);
                }
                dynamicObject.set(prop, value != null ? value : keys[i]);
            }
        }
        this.getModel().endInit();
        this.getView().updateView(RESULT_ENTITY);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "memname": {
                this.openMemberF7();
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        ListSelectedRowCollection data = (ListSelectedRowCollection)returnData;
        ArrayList<String> numbers = new ArrayList<String>(data.size());
        ArrayList<String> names = new ArrayList<String>(data.size());
        for (ListSelectedRow datum : data) {
            numbers.add(datum.getNumber());
            names.add(datum.getName());
        }
        int row = Integer.parseInt(actionId);
        this.getModel().setValue(COLUMN_MEM_NUMBER, (Object)String.join((CharSequence)",", numbers), row);
        this.getModel().setValue(COLUMN_MEM_NAME, (Object)String.join((CharSequence)",", names), row);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String key = ((Control)e.getSource()).getKey();
        Object value = e.getValue();
        if (COLUMN_MEM_NAME.equals(key) && value.toString().length() == 0) {
            this.getModel().setValue(COLUMN_MEM_NUMBER, (Object)"");
        }
    }

    private void buildFilterEntity(List<Dimension> dimensionList) {
        IDataModel dataModel = this.getModel();
        for (Dimension value : dimensionList) {
            Dimension dimension = value;
            if (ignoreDimArr.contains(dimension.getNumber())) continue;
            int rowIndex = dataModel.createNewEntryRow(FILTER_ENTITY);
            DynamicObject row = dataModel.getEntryRowEntity(FILTER_ENTITY, rowIndex);
            row.set(COLUMN_DIM_NAME, (Object)dimension.getName());
            row.set(COLUMN_DIM_NUMBER, (Object)dimension.getNumber());
        }
        this.getView().updateView(FILTER_ENTITY);
    }

    private void buildResultEntity(List<Dimension> dimensionList) {
        IFormView iFormView = this.getView();
        EntryGrid control = (EntryGrid)this.getControl(RESULT_ENTITY);
        List controls = control.getControls();
        iFormView.setVisible(aFalse, (String[])controls.stream().map(Control::getKey).toArray(String[]::new));
        HashMap<String, String> defineKeys = new HashMap<String, String>(16);
        int defineIndex = 1;
        for (Dimension dimension : dimensionList) {
            if (dimension.isPreset()) {
                iFormView.setVisible(aTrue, new String[]{dimension.getNumber().toLowerCase()});
                continue;
            }
            String defineDimKey = "dim" + defineIndex;
            iFormView.setVisible(aTrue, new String[]{defineDimKey});
            control.setColumnProperty(defineDimKey, "header", (Object)new LocaleString(dimension.getName()));
            defineKeys.put(dimension.getNumber(), defineDimKey);
            ++defineIndex;
        }
        iFormView.setVisible(aTrue, new String[]{COLUMN_DATA});
        this.getPageCache().put(CACHE_DEFINE_DIMKEYS, SerializationUtils.toJsonString(defineKeys));
    }

    private void setBaseDataEditMustInput() {
        BasedataEdit bizrange = (BasedataEdit)this.getControl("bizrange");
        bizrange.setMustInput(true);
        bizrange = (BasedataEdit)this.getControl("bizmodel");
        bizrange.setMustInput(true);
    }

    private void openMemberF7() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(FILTER_ENTITY);
        int focusRow = entryGrid.getEntryState().getFocusRow();
        if (focusRow < 0) {
            return;
        }
        long modelId = this.getModelId();
        String dimNumber = this.getModel().getValue(COLUMN_DIM_NUMBER, focusRow).toString();
        String memNumbers = this.getModel().getValue(COLUMN_MEM_NUMBER, focusRow).toString();
        MemberF7Parameter f7Param = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
        if (memNumbers.length() > 0) {
            List members = ModelCacheContext.getOrCreate((Long)modelId).getMembers(dimNumber, null, Arrays.asList(memNumbers.split(",")));
            Set collect = members.stream().map(m -> m.getId()).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(collect)) {
                f7Param.setSelectIds(collect);
            }
            ModelCacheContext.remove();
        }
        if (SysDimensionEnum.AuditTrail.getNumber().equals(dimNumber)) {
            f7Param.setShowNotEnable(true);
        }
        f7Param.setHideDecompose(false);
        f7Param.setHideBudgetOccupation(false);
        NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, String.valueOf(focusRow)));
    }

    @Override
    public Long getModelId() {
        return Long.valueOf(this.getPageCache().get(CACHE_MODEL));
    }

    static {
        ignoreDimMap.put("Scenario", "NoScenario");
        ignoreDimMap.put("Process", "IRpt");
        aTrue = Boolean.TRUE;
        aFalse = Boolean.FALSE;
    }
}

