/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension;

import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.dimensionEnums.ViewMemberSourceEnum;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.utils.PluginUtils;
import org.apache.commons.collections4.CollectionUtils;

public class ViewMemberRefPlugin
extends AbstractFormPlugin {
    private static final String ENTRYENTITY = "entryentity";
    public static final String BTN_CONFIRM = "btnok";
    public static final Log log = LogFactory.getLog(ViewMemberRefPlugin.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CONFIRM});
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        try {
            DynamicObjectCollection query;
            super.afterCreateNewData(e);
            Long model = (Long)PluginUtils.getCustomParams(this.getView(), "model");
            if (model == null || model == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u5b58\u5728", (String)"ViewMemberRefPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter qFilter = new QFilter("model", "=", (Object)model);
            Long dimension = (Long)PluginUtils.getCustomParams(this.getView(), "dimension");
            if (dimension != null && dimension != 0L) {
                qFilter.and("dimension", "=", (Object)dimension);
            }
            Long view = (Long)PluginUtils.getCustomParams(this.getView(), "view");
            String number = (String)PluginUtils.getCustomParams(this.getView(), "number");
            if (StringUtils.isNotEmpty((String)number)) {
                qFilter.and("number", "=", (Object)number);
            }
            if (CollectionUtils.isEmpty((Collection)(query = QueryServiceHelper.query((String)"eb_viewmember", (String)"id,number,name,shownumber,view.id,view.name,membersource,refview.id", (QFilter[])qFilter.toArray())))) {
                return;
            }
            Map<String, DynamicObject> map = query.stream().collect(Collectors.toMap(x -> x.getString("view.id") + "_" + x.getString("number"), Function.identity(), (x1, x2) -> x1));
            List<DynamicObject> refList = query.stream().sorted(Comparator.comparing(o -> view.longValue() == o.getLong("view.id") ? 0 : 1).thenComparing(x -> x.getString("membersource"))).collect(Collectors.toList());
            this.rebuildEntryEntity(map, refList);
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u64cd\u4f5c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458[tranceId:%1]\u3002", (String)"EbExamineEditPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent evt) {
        try {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, evt.getRowIndex());
            HashMap<String, Long> map = new HashMap<String, Long>(16);
            Long tarid = entryRowEntity.getLong("tarid");
            Long tarviewid = null;
            if (tarid == null || tarid == 0L) {
                tarid = entryRowEntity.getLong("orgid");
                tarviewid = entryRowEntity.getLong("orgviewid");
            } else {
                tarviewid = entryRowEntity.getLong("tarviewid");
            }
            map.put("tarid", tarid);
            map.put("tarviewid", tarviewid);
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u64cd\u4f5c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458[tranceId:%1]\u3002", (String)"EbExamineEditPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
    }

    public void rebuildEntryEntity(Map<String, DynamicObject> map, List<DynamicObject> refList) {
        if (CollectionUtils.isEmpty(refList)) {
            return;
        }
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData(ENTRYENTITY);
        this.getModel().beginInit();
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, refList.size());
        int rowIndex = 0;
        for (DynamicObject origin : refList) {
            Long orgId = origin.getLong("refview.id");
            DynamicObject object = map.get(orgId + "_" + origin.getString("number"));
            if (orgId != null && orgId != 0L) {
                if (object != null && !ViewMemberSourceEnum.ADD.getIndex().equals(origin.getString("membersource")) && !ViewMemberSourceEnum.PRESET.getIndex().equals(origin.getString("membersource"))) {
                    dataModel.setValue("orgview", (Object)object.getString("view.name"), rowIndex);
                    dataModel.setValue("orgnumber", (Object)object.getString("number"), rowIndex);
                    dataModel.setValue("orgshownumber", (Object)object.getString("shownumber"), rowIndex);
                    dataModel.setValue("orgname", (Object)object.getString("name"), rowIndex);
                    dataModel.setValue("orgid", (Object)object.getLong("id"), rowIndex);
                    dataModel.setValue("orgviewid", (Object)object.getLong("view.id"), rowIndex);
                }
                dataModel.setValue("tarview", (Object)origin.getString("view.name"), rowIndex);
                dataModel.setValue("tarnumber", (Object)origin.getString("number"), rowIndex);
                dataModel.setValue("tarshownumber", (Object)origin.getString("shownumber"), rowIndex);
                dataModel.setValue("tarname", (Object)origin.getString("name"), rowIndex);
                dataModel.setValue("tarid", (Object)origin.getLong("id"), rowIndex);
                dataModel.setValue("tarviewid", (Object)origin.getLong("view.id"), rowIndex);
                dataModel.setValue("totarview", (Object)ResManager.loadKDString((String)"\u8df3\u8f6c", (String)"ViewMemberRefPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), rowIndex);
            } else {
                dataModel.setValue("orgview", (Object)origin.getString("view.name"), rowIndex);
                dataModel.setValue("orgnumber", (Object)origin.getString("number"), rowIndex);
                dataModel.setValue("orgshownumber", (Object)origin.getString("shownumber"), rowIndex);
                dataModel.setValue("orgname", (Object)origin.getString("name"), rowIndex);
                dataModel.setValue("orgid", (Object)origin.getString("id"), rowIndex);
                dataModel.setValue("orgviewid", (Object)origin.getString("view.id"), rowIndex);
                dataModel.setValue("totarview", (Object)ResManager.loadKDString((String)"\u8df3\u8f6c", (String)"ViewMemberRefPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), rowIndex);
            }
            ++rowIndex;
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_CONFIRM.equals(key)) {
            this.getView().close();
        }
    }

    @Override
    public Long getModelId() {
        Long model = (Long)PluginUtils.getCustomParams(this.getView(), "model");
        if (model != null) {
            return model;
        }
        return 0L;
    }
}

