/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.action;

import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.IFormPlugin;
import kd.epm.eb.common.enums.dimensionEnums.DimMembActionEnum;
import kd.epm.eb.cube.dimension.entitys.DimManagerInfo;
import kd.epm.eb.formplugin.dimension.action.IAction;
import kd.epm.eb.formplugin.dimension.action.MemberAddNewAction;
import kd.epm.eb.formplugin.dimension.action.MemberCutAction;
import kd.epm.eb.formplugin.dimension.action.MemberDeleteAction;
import kd.epm.eb.formplugin.dimension.action.MemberPermAction;
import org.jetbrains.annotations.NotNull;

public class ActionFactory {
    public static DimManagerInfo buildDim(long modelId, long dimensionId, long memberId) {
        return ActionFactory.buildDim(modelId, dimensionId, memberId, null);
    }

    public static DimManagerInfo buildDim(long modelId, long dimensionId, long memberId, Long viewId) {
        DimManagerInfo dimInfo = new DimManagerInfo();
        dimInfo.setModel(modelId);
        dimInfo.setDimension(dimensionId);
        if (viewId != null) {
            dimInfo.setView(viewId);
        }
        dimInfo.setMember(memberId);
        return dimInfo;
    }

    public static IAction getAction(@NotNull DimMembActionEnum actionEnum, @NotNull IFormView view, @NotNull IFormPlugin plugin, @NotNull IDataModel dataModel, @NotNull IPageCache pageCache, @NotNull DimManagerInfo dimInfo) {
        IAction action;
        if (DimMembActionEnum.ADDCHILD == actionEnum || DimMembActionEnum.ADDBROTHER == actionEnum || DimMembActionEnum.ADDAGAIN == actionEnum) {
            action = ActionFactory.getAddNewAction(view, plugin, dataModel, pageCache, dimInfo);
        } else if (DimMembActionEnum.CUT == actionEnum) {
            action = ActionFactory.getCutAction(view, plugin, dataModel, pageCache, dimInfo);
        } else if (DimMembActionEnum.PASTE == actionEnum) {
            action = ActionFactory.getPasteAction(view, plugin, dataModel, pageCache, dimInfo);
        } else if (DimMembActionEnum.DELETE == actionEnum) {
            action = ActionFactory.getDeleteAction(view, plugin, dataModel, pageCache, dimInfo);
        } else {
            throw new IllegalStateException();
        }
        return action;
    }

    private static IAction getAddNewAction(@NotNull IFormView view, @NotNull IFormPlugin plugin, @NotNull IDataModel dataModel, @NotNull IPageCache pageCache, @NotNull DimManagerInfo dimInfo) {
        MemberAddNewAction action = new MemberAddNewAction(view, plugin, dataModel, pageCache, dimInfo);
        action.setActionKey("btn_addmember");
        action.setPermKey(DimMembActionEnum.ADDCHILD.getKey());
        return action;
    }

    private static IAction getCutAction(@NotNull IFormView view, @NotNull IFormPlugin plugin, @NotNull IDataModel dataModel, @NotNull IPageCache pageCache, @NotNull DimManagerInfo dimInfo) {
        MemberCutAction action = new MemberCutAction(view, plugin, dataModel, pageCache, dimInfo);
        action.setActionKey("btn_cut");
        action.setPermKey(DimMembActionEnum.EDIT.getKey());
        return action;
    }

    private static IAction getPasteAction(@NotNull IFormView view, @NotNull IFormPlugin plugin, @NotNull IDataModel dataModel, @NotNull IPageCache pageCache, @NotNull DimManagerInfo dimInfo) {
        MemberCutAction action = new MemberCutAction(view, plugin, dataModel, pageCache, dimInfo);
        action.setActionKey("btn_paste");
        action.setPermKey(DimMembActionEnum.EDIT.getKey());
        return action;
    }

    private static IAction getDeleteAction(@NotNull IFormView view, @NotNull IFormPlugin plugin, @NotNull IDataModel dataModel, @NotNull IPageCache pageCache, @NotNull DimManagerInfo dimInfo) {
        MemberDeleteAction action = new MemberDeleteAction(view, plugin, dataModel, pageCache, dimInfo);
        action.setActionKey("btn_delmember");
        action.setPermKey(DimMembActionEnum.DELETE.getKey());
        return action;
    }

    public static IAction getMemberPermAction(@NotNull IFormView view, @NotNull IFormPlugin plugin, @NotNull IDataModel dataModel, @NotNull IPageCache pageCache, @NotNull DimManagerInfo dimInfo, @NotNull String actionKey, @NotNull DimMembActionEnum actionEnum) {
        MemberPermAction action = new MemberPermAction(view, plugin, dataModel, pageCache, dimInfo, false);
        action.setActionKey(actionKey);
        action.setPermKey(actionEnum.getKey());
        return action;
    }
}

