/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.action;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.enums.dimensionEnums.ViewMemberSourceEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.cube.dimension.entitys.DimManagerInfo;
import kd.epm.eb.formplugin.dimension.action.IAction;
import kd.epm.eb.formplugin.dimension.action.verification.IVerification;
import kd.epm.eb.formplugin.dimension.action.verification.VerificationBuild;
import org.jetbrains.annotations.NotNull;

public class BaseOperationAction
implements IAction {
    protected static final Log log = LogFactory.getLog(BaseOperationAction.class);
    protected static final String OPENAPI = "openapi";
    public static final String OPERATION_BATCH_UPDATE_KEY = "modify";
    private final IFormView view;
    private final IFormPlugin plugin;
    private final IDataModel dataModel;
    private final IPageCache pageCache;
    private final DimManagerInfo dimInfo;
    private String setActionKey = null;
    private String permKey = null;
    private boolean beforeAction = false;
    private boolean doAction = false;
    private boolean afterAction = true;
    private boolean callBack = false;
    private Object[] actionParams;
    private LogStats stats = null;
    private IModelCacheHelper modelCache = null;

    protected IFormView getView() {
        return this.view;
    }

    protected IFormPlugin getPlugin() {
        return this.plugin;
    }

    protected IDataModel getDataModel() {
        return this.dataModel;
    }

    protected IPageCache getPageCache() {
        return this.pageCache;
    }

    public DimManagerInfo getDimInfo() {
        return this.dimInfo;
    }

    @Override
    public void setActionKey(String setActionKey) {
        this.setActionKey = setActionKey;
    }

    @Override
    public String getActionKey() {
        return this.setActionKey;
    }

    @Override
    public void setPermKey(String permKey) {
        this.permKey = permKey;
    }

    @Override
    public String getPermKey() {
        return this.permKey;
    }

    protected void setBeforeAction(boolean beforeAction) {
        this.beforeAction = beforeAction;
    }

    @Override
    public boolean isBeforeAction() {
        return this.beforeAction;
    }

    protected void setDoAction(boolean doAction) {
        this.doAction = doAction;
    }

    protected boolean isDoAction() {
        return this.doAction;
    }

    public void setAfterAction(boolean afterAction) {
        this.afterAction = afterAction;
    }

    public boolean isAfterAction() {
        return this.afterAction;
    }

    @Override
    public boolean isCallBack() {
        return this.callBack;
    }

    @Override
    public void setCallBack(boolean callBack) {
        this.callBack = callBack;
    }

    @Override
    public void setActionParams(Object[] actionParams) {
        this.actionParams = actionParams;
    }

    @Override
    public Object[] getActionParams() {
        return this.actionParams;
    }

    @Override
    public void setStats(@NotNull LogStats stats) {
        this.stats = stats;
    }

    protected LogStats getStats() {
        return this.stats;
    }

    public BaseOperationAction(@NotNull IFormView view, @NotNull IFormPlugin plugin, @NotNull IDataModel dataModel, @NotNull IPageCache pageCache, @NotNull DimManagerInfo dimInfo) {
        this.view = view;
        this.plugin = plugin;
        this.dataModel = dataModel;
        this.pageCache = pageCache;
        this.dimInfo = dimInfo;
    }

    @Override
    public void beforeAction() {
        this.setBeforeAction(true);
        long selectMemberId = this.getDimInfo().getMember().getId();
        if (IDUtils.isNull((long)selectMemberId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u5458\u884c\u3002", (String)"DimensionManagerList_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.setBeforeAction(false);
            return;
        }
        IVerification verification = this.getVerification();
        if (verification != null && !verification.verification()) {
            this.setBeforeAction(false);
        }
    }

    @Override
    public void doAction() {
        this.setDoAction(true);
    }

    @Override
    public void afterAction() {
    }

    @Override
    public IVerification getVerification() {
        return VerificationBuild.of(this.getDimInfo(), this, this.getPlugin(), this.getView(), this.getPageCache());
    }

    @Override
    public String getResult() {
        return null;
    }

    @Override
    public IModelCacheHelper getModelCache(@NotNull Long modelId) {
        if (this.modelCache == null || this.modelCache.getModelobj().getId().compareTo(modelId) != 0) {
            this.modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        }
        return this.modelCache;
    }

    public IModelCacheHelper getModelCache(@NotNull Long modelId, boolean reBuilder) {
        this.modelCache = ModelCacheContext.getOrCreate((Long)modelId, (boolean)reBuilder);
        return this.modelCache;
    }

    public void writeLog(String wordKey, String opKey, MultiLangEnumBridge opName, MultiLangEnumBridge opDescription, String[] opDescArgs) {
        OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), (String)wordKey, (String)opKey, (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])opDescArgs);
    }

    public void writeLog(String wordKey, String opKey, MultiLangEnumBridge opName, MultiLangEnumBridge opDescription, String[] opDescArgs, boolean status) {
        OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), (String)wordKey, (String)opKey, (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])opDescArgs, (boolean)status);
    }

    protected String getBizAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }

    protected String getBizEntityNumber() {
        if (OPENAPI.equals(this.getView().getPageId())) {
            return OPENAPI;
        }
        return this.getDataModel().getDataEntityType().getName();
    }

    protected void dealError(String errorInfo) {
        if (OPENAPI.equals(this.getBizEntityNumber())) {
            throw new KDBizException(errorInfo);
        }
        this.getView().showTipNotification(errorInfo);
    }

    public static boolean checkPresetSource(boolean hasView, String dimShortNumber, String memberModel, String memberNumber, String memberSource) {
        boolean re;
        if (hasView) {
            re = ViewMemberSourceEnum.PRESET.getIndex().equals(memberSource);
            if (!re) {
                re = StringUtils.equals((String)memberModel, (String)"epm_userdefinedmembertree") && StringUtils.equals((String)(dimShortNumber + "None"), (String)memberNumber);
            }
        } else {
            re = MemberSourceEnum.PRESET.getIndex().equals(memberSource) || MemberSourceEnum.COSMIC_INVISIBLE.getIndex().equals(memberSource);
        }
        return re;
    }

    public static boolean checkRefSource(boolean hasView, String memberSource) {
        return hasView && (ViewMemberSourceEnum.INNER_REF.getIndex().equals(memberSource) || ViewMemberSourceEnum.OUTER_REF.getIndex().equals(memberSource));
    }

    public static boolean checkInnerRefSource(boolean hasView, String memberSource) {
        return hasView && StringUtils.equals((String)ViewMemberSourceEnum.INNER_REF.getIndex(), (String)memberSource);
    }

    protected String getMemberModel(DimManagerInfo dimManager) {
        return IDUtils.isNull((Long)dimManager.getViewId()) ? dimManager.getDimension().getMembermodel() : "eb_viewmember";
    }
}

