/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.servicehelper.DimensionServiceHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.cube.dimension.entitys.DimManagerInfo;
import kd.epm.eb.formplugin.dimension.action.MemberPermAction;
import org.jetbrains.annotations.NotNull;

public class CurrencyImportAction
extends MemberPermAction {
    public CurrencyImportAction(@NotNull IFormView view, @NotNull IFormPlugin plugin, @NotNull IDataModel dataModel, @NotNull IPageCache pageCache, @NotNull DimManagerInfo dimInfo) {
        super(view, plugin, dataModel, pageCache, dimInfo);
    }

    @Override
    public void doAction() {
        Object[] save;
        Throwable currency;
        super.doAction();
        Object[] _actionParams = this.getActionParams();
        if (_actionParams == null || _actionParams.length == 0) {
            this.getStats().addInfo("action params data is null.");
            return;
        }
        Object _returnData = _actionParams[0];
        if (_returnData == null) {
            this.getStats().addInfo("return data is null.");
            return;
        }
        long modelId = this.getDimInfo().getModel().getId();
        long dimensionId = this.getDimInfo().getDimension().getId();
        ListSelectedRowCollection returnData1 = (ListSelectedRowCollection)_returnData;
        ArrayList<String> existedNumbers = new ArrayList<String>(16);
        DynamicObjectCollection _objects = QueryServiceHelper.query((String)"epm_currencymembertree", (String)"number", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
        for (DynamicObject _currency : _objects) {
            existedNumbers.add(_currency.getString("number"));
        }
        List collect = returnData1.stream().filter(row -> this.checkCurrencyNumbers(row.getNumber(), existedNumbers)).collect(Collectors.toList());
        Long parentId = DimensionServiceHelper.queryMemberIdByNumber((String)"epm_currencymembertree", (long)modelId, (String)"Currency").getLong("id");
        int dseq = DimensionServiceHelper.getDSeq((long)parentId, (String)"epm_currencymembertree");
        ArrayList<Throwable> objects = new ArrayList<Throwable>(collect.size());
        for (ListSelectedRow select : collect) {
            currency = DimensionServiceHelper.createCurrencyMember((Long)modelId, (Long)dimensionId, (String)select.getNumber(), (String)select.getName(), (Long)parentId, (MemberSourceEnum)MemberSourceEnum.SYSTEM_IMPORT, (int)dseq);
            objects.add(currency);
            ++dseq;
        }
        currency = null;
        try (TXHandle tx = TX.requiresNew((String)"currencyImport");){
            try {
                save = SaveServiceHelper.save((DynamicObject[])objects.toArray(new DynamicObject[0]));
            }
            catch (Throwable ex) {
                log.error("importSysCurrency-error:", ex);
                tx.markRollback();
                throw new KDBizException(ex.getMessage());
            }
        }
        catch (Throwable throwable) {
            currency = throwable;
            throw throwable;
        }
        if (collect.size() < returnData1.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u8fc7\u6ee4\u4e0d\u7b26\u5408\u9884\u7b97\u7f16\u7801\u89c4\u5219\u7684\u5bfc\u5165\u6210\u5458\u3002", (String)"DimensionManagerList_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        CubeUtils.get().checkDimension(Long.valueOf(modelId), Long.valueOf(dimensionId));
        DynamicObject model = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"epm_model");
        if (save != null && save.length > 0 && ShrekOlapServiceHelper.needDMLOlap((DynamicObject)model)) {
            List datasets = DatasetServiceHelper.getDatasets((DynamicObject)model, (String)"Currency");
            ShrekOlapServiceHelper.addCubeMembers((Model)Model.of((DynamicObject)model), (List)datasets, (String)SysDimensionEnum.Currency.getNumber(), (List)Member.of(Arrays.asList((DynamicObject[])save), (boolean)false), (ShrekConfig)ShrekConfigServiceHelper.getDefaultConfig((DynamicObject)model));
        }
    }

    private boolean checkCurrencyNumbers(String number, List<String> numbers) {
        if (number == null || StringUtils.isEmpty((String)number.trim())) {
            return false;
        }
        String regEx = "^(?!_)[a-zA-Z0-9_.]+$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(number);
        if (!matcher.matches()) {
            return false;
        }
        if (number.contains("..") || number.startsWith(".")) {
            return false;
        }
        if (number.equalsIgnoreCase("other") || number.equalsIgnoreCase("all") || number.equalsIgnoreCase("none") || number.equalsIgnoreCase("null")) {
            return false;
        }
        return !numbers.contains(number);
    }
}

