/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.action;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageTypes;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.quote.CheckQuote;
import kd.epm.eb.business.quote.MemberQuote;
import kd.epm.eb.business.quote.QuoteBuilder;
import kd.epm.eb.business.quote.QuoteCheckResult;
import kd.epm.eb.business.utils.DatasetCheckUtil;
import kd.epm.eb.common.cache.DimMembPermVerHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.permission.MembPermRecordUtil;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.cube.dimension.entitys.DimManagerInfo;
import kd.epm.eb.formplugin.dimension.BaseDimensionManager;
import kd.epm.eb.formplugin.dimension.action.BaseOperationAction;
import kd.epm.eb.formplugin.dimension.action.verification.IVerification;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class DimDeleteAction
extends BaseOperationAction {
    public DimDeleteAction(@NotNull IFormView view, @NotNull IFormPlugin plugin, @NotNull IDataModel dataModel, @NotNull IPageCache pageCache, @NotNull DimManagerInfo dimInfo) {
        super(view, plugin, dataModel, pageCache, dimInfo);
    }

    @Override
    public boolean isCallBack() {
        return true;
    }

    @Override
    public void beforeAction() {
        long modelId;
        this.setBeforeAction(true);
        IVerification verification = this.getVerification();
        if (verification != null && !verification.verification()) {
            this.setBeforeAction(false);
        }
        if (!this.isBeforeAction()) {
            return;
        }
        DimManagerInfo dimInfo = this.getDimInfo();
        boolean isSysDimension = dimInfo.getDimension().isSysDimension();
        if (isSysDimension) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ef4\u5ea6\u4e3a\u9884\u7f6e\u7ef4\u5ea6\uff0c\u4e0d\u53ef\u4ee5\u88ab\u5220\u9664\u3002", (String)"DimensionManagerList_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.setBeforeAction(false);
            return;
        }
        if (this.checkDimQuote()) {
            this.setBeforeAction(false);
        }
        if (NewEbAppUtil.isNewEbModel((Long)(modelId = dimInfo.getModelId()))) {
            DynamicObject defaultDataSet = NewEbAppUtil.getDefaultObj((String)"eb_dataset", (Long)modelId);
            long dataSetId = defaultDataSet.getLong("id");
            if (DatasetCheckUtil.checkQutoByTemplate((Long)modelId, (Long)dataSetId)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u9884\u7b97\u6a21\u677f\u5df2\u5f15\u7528\u6570\u636e\u96c6\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u7ef4\u5ea6\u3002", (String)"DataSetListPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (DatasetCheckUtil.checkQutoByBizrule((long)modelId, (long)dataSetId)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u5df2\u5f15\u7528\u6570\u636e\u96c6\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u7ef4\u5ea6\u3002", (String)"DataSetListPlugin_70", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (DatasetCheckUtil.checkQutoByApllyTemplate((Long)modelId, (Long)dataSetId)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u9884\u7b97\u7533\u62a5\u6a21\u677f\u5df2\u5f15\u7528\u6570\u636e\u96c6\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u7ef4\u5ea6\u3002", (String)"DataSetListPlugin_72", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if (this.isBeforeAction()) {
            String description = ResManager.loadKDString((String)"\u5220\u9664\u8be5\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u7684\u540c\u65f6\u4f1a\u5220\u9664\u5176\u5305\u542b\u7684\u6240\u6709\u7ef4\u5ea6\u6210\u5458\uff0c\u662f\u5426\u7ee7\u7eed\u5220\u9664\uff1f", (String)"DimensionManagerList_8", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(description, MessageBoxOptions.YesNo, new ConfirmCallBackListener("delDimConfirmBack"));
        }
    }

    private boolean checkDimQuote() {
        CheckQuote checkQuote = QuoteBuilder.build((Long)this.getDimInfo().getModel().getId(), (Long)this.getDimInfo().getDimension().getId(), (Long)this.getDimInfo().getDimension().getId(), (MemberTypeEnum)MemberTypeEnum.DIMENSION);
        QuoteCheckResult check = MemberQuote.get().checkQuoteResult(checkQuote);
        if (check.isHasQuote()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u7ef4\u5ea6\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DimDeleteAction_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), check.getMsg(), MessageTypes.Default);
        }
        return check.isHasQuote();
    }

    @Override
    public void doAction() {
        super.doAction();
        boolean isSysDimension = this.getDimInfo().getDimension().isSysDimension();
        if (isSysDimension) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ef4\u5ea6\u4e3a\u9884\u7f6e\u7ef4\u5ea6\uff0c\u4e0d\u53ef\u4ee5\u88ab\u5220\u9664\u3002", (String)"DimensionManagerList_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.setDoAction(false);
            return;
        }
        if (this.checkDimQuote()) {
            this.setDoAction(false);
        }
        if (this.isDoAction()) {
            this.deleteDim();
        }
    }

    private void deleteDim() {
        block20: {
            QFBuilder builder = new QFBuilder();
            builder.add("model", "=", (Object)this.getDimInfo().getModel().getId());
            builder.add("dimension", "=", (Object)this.getDimInfo().getDimension().getId());
            QFilter[] filters = builder.toArrays();
            IModelCacheHelper modelCache = this.getModelCache(this.getDimInfo().getModel().getId());
            Model model = modelCache.getModelobj();
            try (TXHandle tx = TX.requiresNew((String)"delDim");){
                DeleteServiceHelper.delete((String)this.getDimInfo().getDimension().getMembermodel(), (QFilter[])filters);
                this.getStats().add("over-delete-member.");
                MembPermRecordUtil.delPermRecordByDims((Long)model.getId(), (Set)Sets.newHashSet((Object[])new Long[]{this.getDimInfo().getDimension().getId()}), null);
                DimMembPermVerHelper.updateVer4BatDimension(Collections.singletonList(this.getDimInfo().getDimension().getId()), (Long)model.getId(), (boolean)false);
                this.getStats().add("over-delete-member-permission.");
                DeleteServiceHelper.delete((String)"eb_viewmember", (QFilter[])filters);
                DeleteServiceHelper.delete((String)"eb_dimensionview", (QFilter[])filters);
                DeleteServiceHelper.delete((String)"eb_dimensionview_group", (QFilter[])filters);
                this.getStats().add("over-delete-view-member.");
                DeleteServiceHelper.delete((String)"epm_dimension", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getDimInfo().getDimension().getId())});
                this.getStats().add("over-delete-dim.");
                Long modelId = model.getId();
                if (model.isModelByEB()) {
                    ShrekOlapServiceHelper.dropCubeDimension((Model)modelCache.getModelobj(), (Dataset)new Dataset(modelId, model.getNumber()), (String)this.getDimInfo().getDimension().getNumber());
                    this.getStats().add("over-delete-shrek-dim.");
                    this.updateGroupControlRuleGroupDimsByEb(modelId);
                }
                if (!NewEbAppUtil.isNewEbModel((Long)modelId)) break block20;
                DynamicObject defaultDataSet = NewEbAppUtil.getDefaultObj((String)"eb_dataset", (Long)modelId, (String)"model,businessmodel", null);
                if (defaultDataSet == null) {
                    return;
                }
                try {
                    String deleteViewSql = "delete from t_eb_viewentry where fdimensionid = ?";
                    DB.execute((DBRoute)BgBaseConstant.epm, (String)deleteViewSql, (Object[])new Object[]{this.getDimInfo().getDimension().getId()});
                    String deleteSql = "delete from t_eb_datasetdim where fdatasetdim = ?";
                    DB.execute((DBRoute)BgBaseConstant.epm, (String)deleteSql, (Object[])new Object[]{this.getDimInfo().getDimension().getId()});
                    if (ShrekOlapServiceHelper.needDMLOlap((DynamicObject)defaultDataSet.getDynamicObject("model"))) {
                        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
                        Dataset dataset = new Dataset(Long.valueOf(defaultDataSet.getLong("id")), defaultDataSet.getString("number"));
                        dataset.addViewIds(BusinessModelServiceHelper.getViewIds((Long)defaultDataSet.getLong("businessmodel.id")));
                        dataset.addDimension(modelCacheHelper.getDimension(Long.valueOf(this.getDimInfo().getDimension().getId())));
                        ShrekOlapServiceHelper.dropCubeDimensions((Model)model, (Dataset)dataset);
                        this.getStats().add("over-delete-shrek-dim.");
                    }
                }
                catch (Exception ex) {
                    log.error("delete-dim-error:", (Throwable)ex);
                    tx.markRollback();
                    throw new KDBizException(ex.getMessage());
                }
            }
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DimensionManagerList_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void updateGroupControlRuleGroupDimsByEb(Long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("group", ">", (Object)0L);
        Collection groupControlRuleCollection = BusinessDataServiceHelper.loadFromCache((String)"eb_bgcontrolrulemain", (QFilter[])qFilter.toArray()).values();
        if (CollectionUtils.isNotEmpty(groupControlRuleCollection)) {
            List<DynamicObject> groupControlRuleList = groupControlRuleCollection.stream().collect(Collectors.toList());
            for (DynamicObject groupControlRule : groupControlRuleList) {
                DynamicObjectCollection groupDims = groupControlRule.getDynamicObjectCollection("groupdims");
                groupDims.removeIf(groupDim -> groupDim.getDynamicObject("groupdim") == null || groupDim.getDynamicObject("groupdim").getLong("id") == this.getDimInfo().getDimension().getId());
                DynamicObjectCollection oboMemRanges = groupControlRule.getDynamicObjectCollection("obomemranges");
                oboMemRanges.removeIf(oboMemRange -> oboMemRange.getDynamicObject("obodim") == null || oboMemRange.getDynamicObject("obodim").getLong("id") == this.getDimInfo().getDimension().getId());
            }
            SaveServiceHelper.save((DynamicObject[])groupControlRuleList.toArray(new DynamicObject[0]));
        }
    }

    @Override
    public void afterAction() {
        super.afterAction();
        DimManagerInfo dimInfo = this.getDimInfo();
        long dimId = dimInfo.getDimension().getId();
        String dimNumber = dimInfo.getDimension().getNumber();
        long modelId = dimInfo.getModel().getId();
        String modelNumber = dimInfo.getModel().getNumber();
        if (this.getPlugin() instanceof BaseDimensionManager) {
            ((BaseDimensionManager)this.getPlugin()).initDimensionTree(BaseDimensionManager.EnumTime.A);
            ((BaseDimensionManager)this.getPlugin()).refreshMember();
        }
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664\u7ef4\u5ea6", "DimensionManagerList_26", "epm-eb-formplugin");
        MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u4f53\u7cfb\uff1a(%1$s)\u5220\u9664\u7ef4\u5ea6\uff1a(%2$s)", "DimensionManagerList_24", "epm-eb-formplugin");
        this.writeLog(dimNumber, "delete", opName, opDescription, new String[]{modelNumber, dimNumber});
        CubeUtils.get().deleteDimension(Long.valueOf(modelId), Long.valueOf(dimId));
    }
}

