/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.action;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageTypes;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.quote.CheckQuote;
import kd.epm.eb.business.quote.MemberQuote;
import kd.epm.eb.business.quote.QuoteBuilder;
import kd.epm.eb.business.quote.QuoteCheckResult;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.enums.dimensionEnums.ViewMemberSourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.utils.CommonCheckUtil;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.cube.dimension.entitys.DimManagerInfo;
import kd.epm.eb.formplugin.dataset.DataSetListPlugin;
import kd.epm.eb.formplugin.dimension.BaseDimensionManager;
import kd.epm.eb.formplugin.dimension.action.MemberPermAction;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.olap.service.view.ViewMemberManager;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class MemberDeleteAction
extends MemberPermAction {
    private final List<String> memberNumbers = Lists.newLinkedList();
    private static final String[] IC_PRESET = new String[]{"ICTotal", "ICEntity", "ICNone", "ICOEntity"};
    private static final String[] CT_PRESET = new String[]{"BOP", "CurrentPeriod", "EBChanges", "EndingBalance", "YTD", "ActualChanges", "ControlChanges", "DataIntegration", "Execute", "Occupation"};

    public MemberDeleteAction(@NotNull IFormView view, @NotNull IFormPlugin plugin, @NotNull IDataModel dataModel, @NotNull IPageCache pageCache, @NotNull DimManagerInfo dimInfo) {
        super(view, plugin, dataModel, pageCache, dimInfo);
    }

    @Override
    public boolean isCallBack() {
        return true;
    }

    @Override
    public void beforeAction() {
        long selectMemberId;
        super.beforeAction();
        if (!this.isBeforeAction()) {
            return;
        }
        int level = this.getDimInfo().getMember().getLevel();
        if (level <= 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u7ef4\u5ea6\u6210\u5458\u7684\u6839\u8282\u70b9\u3002", (String)"DimMemBaseAction_2", (String)"epm-eb-cube", (Object[])new Object[0]));
            this.setBeforeAction(false);
            return;
        }
        IModelCacheHelper modelCache = this.getModelCache(this.getDimInfo().getModelId());
        Dimension dimension = modelCache.getDimension(Long.valueOf(this.getDimInfo().getDimensionId()));
        String number = this.getDimInfo().getMember().getNumber();
        if (SysDimensionEnum.InternalCompany.getNumber().equals(dimension.getNumber()) && StringUtils.equalsAny((CharSequence)number, (CharSequence[])IC_PRESET)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u9884\u7f6e\u6210\u5458\u3002", (String)"DimMemBaseAction_3", (String)"epm-eb-cube", (Object[])new Object[0]));
            this.setBeforeAction(false);
            return;
        }
        if (SysDimensionEnum.ChangeType.getNumber().equals(dimension.getNumber()) && StringUtils.equalsAny((CharSequence)number, (CharSequence[])CT_PRESET)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u9884\u7f6e\u6210\u5458\u3002", (String)"DimMemBaseAction_3", (String)"epm-eb-cube", (Object[])new Object[0]));
            this.setBeforeAction(false);
            return;
        }
        if (dimension.getNoneNumber().equals(number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u7ef4\u5ea6\u7684\u4e0d\u533a\u5206\u6210\u5458\u3002", (String)"DimMemBaseAction_2_1", (String)"epm-eb-cube", (Object[])new Object[0]));
            this.setBeforeAction(false);
            return;
        }
        String memberSource = this.getDimInfo().getMember().getMembersource();
        String appIndex = ModelUtil.queryApp((IFormView)this.getView()).getIndex();
        if (!View.NoViewDimNums.contains(this.getDimInfo().getDimension().getNumber()) && !ApplicationTypeEnum.EB.getIndex().equals(appIndex)) {
            if (ViewMemberSourceEnum.PRESET.getIndex().equals(memberSource)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u9884\u7f6e\u6210\u5458\u3002", (String)"DimMemBaseAction_3", (String)"epm-eb-cube", (Object[])new Object[0]));
                this.setBeforeAction(false);
                return;
            }
        } else if (MemberSourceEnum.PRESET.getIndex().equals(memberSource)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u9884\u7f6e\u6210\u5458\u3002", (String)"DimMemBaseAction_3", (String)"epm-eb-cube", (Object[])new Object[0]));
            this.setBeforeAction(false);
            return;
        }
        String dimensionNumber = this.getDimInfo().getDimension().getNumber();
        if (SysDimensionEnum.AuditTrail.getNumber().equals(dimensionNumber) && !CommonCheckUtil.checkCanCutOrDelete((IModelCacheHelper)modelCache, (String)this.getDimInfo().getMember().getNumber())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u8c03\u6574\u5206\u89e3\u7528\u9014\u7684\u7ebf\u7d22\u6210\u5458\u65f6\uff0c\u81f3\u5c11\u5b58\u5728\u4e00\u4e2a\u540c\u5c42\u7ea7\u7684\u62a5\u8868\u586b\u62a5\u7528\u9014\u6210\u5458\u3002", (String)"DimMemBaseAction_57", (String)"epm-eb-cube", (Object[])new Object[0]));
            return;
        }
        long modelId = this.getDimInfo().getModelId();
        long viewId = this.getDimInfo().getViewId();
        long mId = selectMemberId = this.getDimInfo().getMemberId();
        boolean onlyCurrView = false;
        if (!View.NoViewDimNums.contains(this.getDimInfo().getDimension().getNumber()) && !ApplicationTypeEnum.EB.getIndex().equals(appIndex)) {
            DynamicObject viewMember = BusinessDataServiceHelper.loadSingleFromCache((Object)selectMemberId, (String)"eb_viewmember", (String)"id,memberid,membersource");
            mId = viewMember.getLong("memberid");
            if (ViewMemberSourceEnum.INNER_REF.getIndex().equals(viewMember.getString("membersource"))) {
                onlyCurrView = true;
            }
        }
        CheckQuote checkQuote = QuoteBuilder.build((Long)modelId, (Long)this.getDimInfo().getDimensionId(), (Long)viewId, (Set)Sets.newHashSet((Object[])new Long[]{mId}), (MemberTypeEnum)MemberTypeEnum.MEMBER);
        checkQuote.setCheckChild(true);
        checkQuote.setOnlyCurrView(onlyCurrView);
        checkQuote.addExclude(MemberQuoteResourceEnum.ViewMember);
        QuoteCheckResult quote = MemberQuote.get().checkQuoteResult(checkQuote);
        if (quote.isHasQuote()) {
            this.setBeforeAction(false);
            this.getView().showMessage(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664 \u3002", (String)"DimMemBaseAction_22", (String)"epm-eb-cube", (Object[])new Object[0]), quote.getMsg(), MessageTypes.Default);
            return;
        }
        if (this.isBeforeAction()) {
            String description = ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u5f53\u524d\u6210\u5458\u53ca\u5176\u6240\u6709\u4e0b\u7ea7\u6210\u5458\uff1f", (String)"DimensionManagerList_14", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(description, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delMemberConfirmBack", this.getPlugin()));
        }
    }

    @Override
    public void doAction() {
        super.doAction();
        if (this.isDoAction()) {
            LogStats stats = new LogStats("budget-log : ");
            stats.addInfo("begin-delete-member.");
            try {
                Set delSet = !View.NoViewDimNums.contains(this.getDimInfo().getDimension().getNumber()) && !this.getDimInfo().getModel().isEb() ? ViewMemberManager.getInstance().deleteViewMember(this.getDimInfo().getModel().getId(), this.getDimInfo().getDimension().getNumber(), this.getDimInfo().getViewId(), Long.valueOf(this.getDimInfo().getMember().getId())) : ViewMemberManager.getInstance().deleteDimMember(this.getDimInfo().getModel().getId(), this.getDimInfo().getDimension().getNumber(), Long.valueOf(this.getDimInfo().getMember().getId()));
                this.memberNumbers.addAll(delSet);
            }
            finally {
                stats.addInfo("end-delete-member.");
                log.info(stats.toString());
            }
        }
    }

    @Override
    public void afterAction() {
        super.afterAction();
        if (this.getPlugin() instanceof BaseDimensionManager) {
            if (!View.NoViewDimNums.contains(this.getDimInfo().getDimension().getNumber()) && !this.getDimInfo().getModel().isEb()) {
                String tag = this.getPageCache().get("tag");
                String currentNodeKey = this.getPageCache().get("currentNodeKey");
                ((BaseDimensionManager)this.getPlugin()).refreshListOrViewMember(currentNodeKey, tag);
            } else {
                ((BaseDimensionManager)this.getPlugin()).refreshMember();
            }
            ((BaseDimensionManager)this.getPlugin()).clearCache();
        }
        if (this.getPlugin() instanceof DataSetListPlugin) {
            ((DataSetListPlugin)this.getPlugin()).refreshMembers();
            ((DataSetListPlugin)this.getPlugin()).clearCache();
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DimensionManagerList_71", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664\u7ef4\u5ea6\u6210\u5458", "DimensionManagerList_32", "epm-eb-formplugin");
        MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u5220\u9664(%1$s)\u7ef4\u5ea6\u7684\u6210\u5458", "DimensionManagerList_33", "epm-eb-formplugin");
        String opDetail = StringUtils.join(this.memberNumbers, (char)',');
        this.writeLog(this.getDimInfo().getMember().getNumber(), "delete", opName, opDescription, new String[]{opDetail});
    }
}

