/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.action;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.IFormPlugin;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.excelImport.POIUtils;
import kd.epm.eb.cube.dimension.DimensionFactory;
import kd.epm.eb.cube.dimension.ImportAndExport.Export.DimMemberExportBasePlugin;
import kd.epm.eb.cube.dimension.entitys.DimManagerInfo;
import kd.epm.eb.cube.dimension.entitys.DimensionInfo;
import kd.epm.eb.formplugin.dimension.action.BaseOperationAction;
import org.jetbrains.annotations.NotNull;

public class MemberExportAction
extends BaseOperationAction {
    public MemberExportAction(@NotNull IFormView view, @NotNull IFormPlugin plugin, @NotNull IDataModel dataModel, @NotNull IPageCache pageCache, @NotNull DimManagerInfo dimInfo) {
        super(view, plugin, dataModel, pageCache, dimInfo);
    }

    @Override
    public void doAction() {
        DynamicObject defDataset;
        super.doAction();
        DimensionInfo dimension = this.getDimInfo().getDimension();
        if (dimension == null) {
            this.setDoAction(false);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6", (String)"DimensionManagerList_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        long modelId = this.getDimInfo().getModel().getId();
        long dimensionId = this.getDimInfo().getDimension().getId();
        String dimensionNumber = this.getDimInfo().getDimension().getNumber();
        String memberKey = this.getDimInfo().getDimension().getMembermodel();
        Long viewId = 0L;
        if (!this.getModelCache(modelId).getModelobj().isModelByEB() && !View.NoViewDimNums.contains(dimensionNumber)) {
            viewId = this.getViewId(this.getDimInfo());
        }
        Long datasetId = 0L;
        if (SysDimensionEnum.Account.getNumber().equals(dimensionNumber) && (defDataset = NewEbAppUtil.getDefaultObj((String)"eb_dataset", (Long)modelId)) != null) {
            datasetId = defDataset.getLong("id");
        }
        try {
            DimMemberExportBasePlugin exportBase = DimensionFactory.getDimMemExportPlugin((String)memberKey, (long)modelId, (long)dimensionId, (long)viewId, (String)dimensionNumber, (long)datasetId);
            String url = exportBase.exportData();
            if (StringUtils.isNotEmpty((String)url)) {
                POIUtils.downloadFile((IFormView)this.getView(), (String)url);
            }
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u7ef4\u5ea6\u6210\u5458\u6587\u4ef6\u5bfc\u51fa", "DimensionManagerList_80", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u7ef4\u5ea6\u6210\u5458\u6587\u4ef6\u5bfc\u51fa\u6210\u529f\u3002", "DimensionManagerList_81", "epm-eb-formplugin");
            this.writeLog(null, "export", opName, opDesc, null);
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((IFormView)this.getView(), (String)"memberExportAction-error", (Throwable)ex);
        }
    }

    protected Long getViewId(DimManagerInfo dimInfo) {
        Long viewId = dimInfo.getView() != null ? dimInfo.getView().getId() : 0L;
        if (IDUtils.isNull((Long)viewId)) {
            return DimensionViewServiceHelper.getInstance().queryBaseViewId(Long.valueOf(dimInfo.getModel().getId()), Long.valueOf(dimInfo.getDimension().getId()));
        }
        return viewId;
    }
}

