/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.action;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.DynamicObjectUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.cube.dimension.entitys.DimManagerInfo;
import kd.epm.eb.formplugin.dimension.BaseDimensionManager;
import kd.epm.eb.formplugin.dimension.action.MemberPermAction;
import org.jetbrains.annotations.NotNull;

public class MemberNameUpAction
extends MemberPermAction {
    private String updateType = null;
    private int size = 0;
    private final Set<String> updateNumber = new HashSet<String>();

    public MemberNameUpAction(@NotNull IFormView view, @NotNull IFormPlugin plugin, @NotNull IDataModel dataModel, @NotNull IPageCache pageCache, @NotNull DimManagerInfo dimInfo) {
        super(view, plugin, dataModel, pageCache, dimInfo);
    }

    public MemberNameUpAction(@NotNull IFormView view, @NotNull IFormPlugin plugin, @NotNull IDataModel dataModel, @NotNull IPageCache pageCache, @NotNull DimManagerInfo dimInfo, String updateType) {
        this(view, plugin, dataModel, pageCache, dimInfo);
        this.updateType = updateType;
    }

    @Override
    protected boolean verifyPerm() {
        return false;
    }

    @Override
    public boolean isCallBack() {
        return true;
    }

    @Override
    public void beforeAction() {
        super.beforeAction();
        if (!this.isBeforeAction()) {
            return;
        }
        switch (this.updateType) {
            case "btn_adminorg": {
                String description = ResManager.loadKDString((String)"\u6309\u884c\u653f\u7ec4\u7ec7\u4fe1\u606f\uff0c\u66f4\u65b0\u540c\u7f16\u7801\u7684\u9884\u7b97\u7ec4\u7ec7\u540d\u79f0\uff0c\u786e\u5b9a\u6267\u884c\uff1f", (String)"MemberNameUpAction_0", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(description, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("updateNameByAdminConfirmBack", this.getPlugin()));
                break;
            }
            case "btn_busorg": {
                String description = ResManager.loadKDString((String)"\u6309\u4e1a\u52a1\u5355\u5143\u4fe1\u606f\uff0c\u66f4\u65b0\u540c\u7f16\u7801\u7684\u9884\u7b97\u7ec4\u7ec7\u540d\u79f0\uff0c\u786e\u5b9a\u6267\u884c\uff1f", (String)"MemberNameUpAction_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(description, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("updateNameByBusConfirmBack", this.getPlugin()));
                break;
            }
            case "btn_costorg": {
                String description = ResManager.loadKDString((String)"\u6309\u6210\u672c\u4e2d\u5fc3\u66f4\u65b0\u76f8\u540c\u7f16\u7801\u7684\u9884\u7b97\u7ec4\u7ec7\u540d\u79f0\uff0c\u662f\u5426\u786e\u5b9a\u6267\u884c\uff1f", (String)"MemberNameUpAction_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(description, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("updateNameByCostConfirmBack", this.getPlugin()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAction() {
        super.doAction();
        LogStats stats = new LogStats("budget-log : ");
        stats.addInfo("begin-update-member-name.");
        AppLogInfo logInfo = null;
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u7ec4\u7ec7\u66f4\u65b0", "MemberNameUpAction_3", "epm-eb-formplugin");
        String bizAppId = this.getView().getFormShowParameter().getAppId();
        try {
            switch (this.updateType) {
                case "btn_adminorg": {
                    this.size = this.doUpdateByAdmin();
                    MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u6309\u884c\u653f\u7ec4\u7ec7\u66f4\u65b0\u5f53\u524d\u7ec4\u7ec7\u6210\u5458\u7684\u540d\u79f0\uff0c\u5171\u66f4\u65b0%1$s\u4e2a\u3002", "MemberNameUpAction_4", "epm-eb-formplugin");
                    logInfo = OperationLogUtil.buildLogInfo((String)bizAppId, (String)SysDimensionEnum.Entity.getMemberTreemodel(), null, (String)"save", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (String[])new String[]{String.valueOf(this.size)});
                    break;
                }
                case "btn_busorg": {
                    this.size = this.doUpdateByBusinessOrg();
                    MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u6309\u4e1a\u52a1\u5355\u5143\u66f4\u65b0\u5f53\u524d\u7ec4\u7ec7\u6210\u5458\u7684\u540d\u79f0\uff0c\u5171\u66f4\u65b0%1$s\u4e2a\u3002", "MemberNameUpAction_5", "epm-eb-formplugin");
                    logInfo = OperationLogUtil.buildLogInfo((String)bizAppId, (String)SysDimensionEnum.Entity.getMemberTreemodel(), null, (String)"save", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (String[])new String[]{String.valueOf(this.size)});
                    break;
                }
                case "btn_costorg": {
                    this.size = this.doUpdateByCostCenter();
                    MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u6309\u6210\u672c\u4e2d\u5fc3\u66f4\u65b0\u5f53\u524d\u7ec4\u7ec7\u6210\u5458\u7684\u540d\u79f0\uff0c\u5171\u66f4\u65b0%1$s\u4e2a\u3002", "MemberNameUpAction_6", "epm-eb-formplugin");
                    logInfo = OperationLogUtil.buildLogInfo((String)bizAppId, (String)SysDimensionEnum.Entity.getMemberTreemodel(), null, (String)"save", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (String[])new String[]{String.valueOf(this.size)});
                }
            }
            OperationLogUtil.log(logInfo);
        }
        catch (Exception ex) {
            log.error("update-member-name-error:", (Throwable)ex);
            this.getView().showErrorNotification(ex.getMessage());
        }
        finally {
            stats.addInfo("end-update-member-name.");
            log.info(stats.toString());
        }
    }

    private int doUpdateByAdmin() {
        List rst;
        QFBuilder builder = new QFBuilder();
        builder.add("enable", "=", (Object)Character.valueOf('1'));
        builder.add("fisadministrative", "=", (Object)Character.valueOf('1'));
        builder.add("structure.view", "=", (Object)Integer.valueOf(OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType()));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryAdminOrg", (String)"bos_adminorg", (String)"id,number,name", (QFilter[])builder.toArray(), null);){
            rst = CommonServiceHelper.transDataSet((DataSet)ds);
        }
        return this.updateEntityName(rst);
    }

    private int doUpdateByBusinessOrg() {
        List rst;
        QFBuilder builder = new QFBuilder();
        builder.add("enable", "=", (Object)Character.valueOf('1'));
        builder.add("structure.view", "=", (Object)Integer.valueOf(OrgViewTypeEnum.IS_ORGUNIT.getViewType()));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryBusOrg", (String)"bos_org", (String)"id,number,name", (QFilter[])builder.toArrays(), null);){
            rst = CommonServiceHelper.transDataSet((DataSet)ds);
        }
        return this.updateEntityName(rst);
    }

    private int doUpdateByCostCenter() {
        List rst;
        QFilter filter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryCostOrg", (String)"bos_costcenter", (String)"id,number,name", (QFilter[])filter.toArray(), null);){
            rst = CommonServiceHelper.transDataSet((DataSet)ds);
        }
        return this.updateEntityName(rst);
    }

    public Set<String> getUpdateNumber() {
        return this.updateNumber;
    }

    private int updateEntityName(List<Map<String, Object>> orgUnits) {
        String orgUnitName;
        if (orgUnits == null || orgUnits.isEmpty()) {
            return 0;
        }
        HashMap<String, String> orgUnitMap = new HashMap<String, String>(orgUnits.size());
        for (Map<String, Object> _orgUnit : orgUnits) {
            orgUnitMap.put((String)_orgUnit.get("number"), (String)_orgUnit.get("name"));
        }
        int size = 0;
        ArrayList updates = Lists.newArrayListWithExpectedSize((int)orgUnits.size());
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)this.getDimInfo().getModelId());
        builder.add("dimension", "=", (Object)this.getDimInfo().getDimensionId());
        builder.add("number", "in", orgUnitMap.keySet());
        DynamicObject[] members = BusinessDataServiceHelper.load((String)SysDimensionEnum.Entity.getMemberTreemodel(), (String)"id,number,name", (QFilter[])builder.toArrays());
        if (members != null && members.length > 0) {
            for (DynamicObject _member : members) {
                orgUnitName = (String)orgUnitMap.get(_member.getString("number"));
                if (!StringUtils.isNotEmpty((String)orgUnitName) || StringUtils.equals((String)_member.getString("name"), (String)orgUnitName)) continue;
                _member.set("name", (Object)orgUnitName);
                this.getUpdateNumber().add(_member.getString("number"));
                updates.add(_member);
            }
            if (!updates.isEmpty()) {
                size = updates.size();
                DynamicObjectUtils.update((List)updates);
            }
        }
        updates.clear();
        DynamicObject[] viewMembers = BusinessDataServiceHelper.load((String)"eb_viewmember", (String)"id,number,name", (QFilter[])builder.toArrays());
        if (members != null && members.length > 0) {
            for (DynamicObject _member : viewMembers) {
                orgUnitName = (String)orgUnitMap.get(_member.getString("number"));
                if (!StringUtils.isNotEmpty((String)orgUnitName) || StringUtils.equals((String)_member.getString("name"), (String)orgUnitName)) continue;
                _member.set("name", (Object)orgUnitName);
                this.getUpdateNumber().add(_member.getString("number"));
                updates.add(_member);
            }
            if (!updates.isEmpty()) {
                DynamicObjectUtils.update((List)updates);
            }
        }
        return size;
    }

    @Override
    public void afterAction() {
        super.afterAction();
        if (this.getPlugin() instanceof BaseDimensionManager) {
            if (!View.NoViewDimNums.contains(this.getDimInfo().getDimension().getNumber()) && !this.getDimInfo().getModel().isEb()) {
                String tag = this.getPageCache().get("tag");
                String currentNodeKey = this.getPageCache().get("currentNodeKey");
                ((BaseDimensionManager)this.getPlugin()).refreshListOrViewMember(currentNodeKey, tag);
            } else {
                ((BaseDimensionManager)this.getPlugin()).refreshMember();
            }
            ((BaseDimensionManager)this.getPlugin()).clearCache();
        }
        CubeUtils.updateDimensionVersion((Long)this.getDimInfo().getModelId(), (Long)this.getDimInfo().getDimensionId());
        if (this.size > 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f\u3002", (String)"MemberNameUpAction_3", (String)"epm-eb-cube", (Object[])new Object[0]), Integer.valueOf(1000));
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9884\u7b97\u7ec4\u7ec7\u5bf9\u5e94\u7684\u4e1a\u52a1\u7ec4\u7ec7\u65e0\u53d8\u5316\uff0c\u65e0\u9700\u66f4\u65b0\u3002", (String)"MemberNameUpAction_7", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
        }
    }
}

