/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.action;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageTypes;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.quote.CheckQuote;
import kd.epm.eb.business.quote.MemberQuote;
import kd.epm.eb.business.quote.QuoteBuilder;
import kd.epm.eb.business.quote.QuoteCheckResult;
import kd.epm.eb.business.servicehelper.DimensionServiceHelper;
import kd.epm.eb.common.bgmddatalock.BgmdDataLockCacheHelper;
import kd.epm.eb.common.bgmddatalock.DataLockPageUserSelect;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.model.Pair;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.sonmodel.BgmdMainSubControlHelper;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.threadpool.EBThreadPoolExecutor;
import kd.epm.eb.cube.dimension.entitys.DimManagerInfo;
import kd.epm.eb.cube.dimension.entitys.MemberInfo;
import kd.epm.eb.formplugin.dataModelTrans.config.DataModelTransEnum;
import kd.epm.eb.formplugin.dataset.DataSetListPlugin;
import kd.epm.eb.formplugin.dimension.BaseDimensionManager;
import kd.epm.eb.formplugin.dimension.action.MemberPermAction;
import kd.epm.eb.formplugin.rulemanage.RuleUpdateServiceImpl;
import kd.epm.eb.olap.service.view.ViewMemberManager;
import org.jetbrains.annotations.NotNull;

public class MemberPasteAction
extends MemberPermAction {
    public MemberPasteAction(@NotNull IFormView view, @NotNull IFormPlugin plugin, @NotNull IDataModel dataModel, @NotNull IPageCache pageCache, @NotNull DimManagerInfo dimInfo) {
        super(view, plugin, dataModel, pageCache, dimInfo);
    }

    @Override
    public boolean isCallBack() {
        return true;
    }

    @Override
    public void beforeAction() {
        super.beforeAction();
        if (!this.isBeforeAction()) {
            return;
        }
        this.checkPaste();
        if (!"openapi".equals(this.getBizEntityNumber()) && this.isBeforeAction()) {
            String msg = ResManager.loadKDString((String)"\u786e\u5b9a\u5c06\u526a\u5207\u7684\u6210\u5458\u53ca\u5176\u6240\u6709\u4e0b\u7ea7\u6210\u5458\u7c98\u8d34\u4e3a\u5f53\u524d\u9009\u62e9\u7684\u6210\u5458\u7684\u4e0b\u7ea7\u6210\u5458\u5417\uff1f", (String)"DimensionManagerList_20", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("pasteMemberConfirmBack", this.getPlugin()));
        }
    }

    protected void checkPaste() {
        String cutMemberCache = this.getPageCache().get(this.getPasteMemberKey());
        if (StringUtils.isEmpty((String)cutMemberCache)) {
            if ("openapi".equals(this.getBizEntityNumber())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u9700\u8981\u79fb\u52a8\u7684\u6210\u5458\u3002", (String)"DimensionManagerList_75", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.setBeforeAction(false);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u526a\u5207\u6210\u5458\u3002", (String)"DimensionManagerList_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DimManagerInfo cutMember = (DimManagerInfo)SerializationUtils.deSerializeFromBase64((String)cutMemberCache);
        this.baseDataCheck(cutMember);
        if (this.isBeforeAction()) {
            this.bizDataCheck(cutMember);
        }
    }

    protected String getPasteMemberKey() {
        return "cutMemberIds";
    }

    protected void baseDataCheck(DimManagerInfo cutMember) {
        DynamicObject cutObject = this.queryObject(cutMember);
        if (cutObject == null) {
            this.setBeforeAction(false);
            this.getView().showMessage(ResManager.loadKDString((String)"\u8981\u526a\u5207\u7684\u6210\u5458\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DimMemBaseAction_48", (String)"epm-eb-cube", (Object[])new Object[0]));
            return;
        }
        DynamicObject pasteObject = this.queryObject(this.getDimInfo());
        if (pasteObject == null) {
            this.setBeforeAction(false);
            this.getView().showMessage(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u7ef4\u5ea6\u6210\u5458\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"DimMemBaseAction_50", (String)"epm-eb-cube", (Object[])new Object[0]));
            return;
        }
        if (!Objects.equals(this.getDimInfo().getModelId(), cutMember.getModel().getId())) {
            this.setBeforeAction(false);
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u4f53\u7cfb\u201c%1\u201d\u4e0e\u526a\u5207\u6210\u5458\u7684\u4f53\u7cfb\u201c%2\u201d\u4e0d\u4e00\u81f4\u3002", (String)"DimensionManagerList_67", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getDimInfo().getModel().getNumber(), cutMember.getModel().getNumber()}));
            return;
        }
        if (!Objects.equals(this.getDimInfo().getDimensionId(), cutMember.getDimension().getId())) {
            this.setBeforeAction(false);
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u4e0e\u526a\u5207\u6210\u5458\u7684\u7ef4\u5ea6\u201c%2\u201d\u4e0d\u4e00\u81f4\u3002", (String)"DimensionManagerList_68", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getDimInfo().getDimension().getNumber(), cutMember.getDimension().getNumber()}));
        }
    }

    protected DynamicObject queryObject(DimManagerInfo dimManagerInfo) {
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)dimManagerInfo.getModelId());
        builder.add("dimension", "=", (Object)dimManagerInfo.getDimensionId());
        if (IDUtils.isNotNull((Long)dimManagerInfo.getViewId())) {
            builder.add("view", "=", (Object)dimManagerInfo.getViewId());
        }
        builder.add("number", "=", (Object)dimManagerInfo.getMember().getNumber());
        return QueryServiceHelper.queryOne((String)this.getMemberModel(dimManagerInfo), (String)"id", (QFilter[])builder.toArray());
    }

    protected void bizDataCheck(DimManagerInfo cutMember) {
        DynamicObject parent;
        long modelId = this.getDimInfo().getModelId();
        long dimensionId = this.getDimInfo().getDimensionId();
        long selectMemberId = this.getDimInfo().getMemberId();
        long parentId = this.getDimInfo().getMember().getParentId();
        String dimensionNumber = this.getDimInfo().getDimension().getNumber();
        if (SysDimensionEnum.AuditTrail.getNumber().equals(dimensionNumber) && "BudgetOccupation".equals(this.getDimInfo().getMember().getNumber())) {
            this.dealError(ResManager.loadKDString((String)"\u5728\u9014\u5360\u7528\u9884\u7b97\u4e0d\u5141\u8bb8\u65b0\u589e\u4e0b\u7ea7\u3002", (String)"DimMemBaseAction_24", (String)"epm-eb-cube", (Object[])new Object[0]));
            this.setBeforeAction(false);
            return;
        }
        if (SysDimensionEnum.ChangeType.getNumber().equals(dimensionNumber) && (parent = BusinessDataServiceHelper.loadSingleFromCache((Object)parentId, (String)"eb_viewmember", (String)"id,number")) != null && "ActualChanges".equals(parent.getString("number"))) {
            this.dealError(ResManager.loadKDString((String)"\u5b9e\u9645\u6570\u521d\u59cb\u5316\u4e0b\u7ea7\u4e0d\u5141\u8bb8\u65b0\u589e\u4e0b\u7ea7\u3002", (String)"DimensionManagerList_64", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.setBeforeAction(false);
            return;
        }
        if (IDUtils.isNotNull((Long)this.getDimInfo().getViewId())) {
            DynamicObject selectMember = BusinessDataServiceHelper.loadSingleFromCache((Object)selectMemberId, (String)"eb_viewmember", (String)"memberid");
            selectMemberId = selectMember.getLong("memberid");
        }
        CheckQuote quote = QuoteBuilder.build((Long)modelId, (Long)dimensionId, (Long)this.getDimInfo().getViewId(), (Set)CollectionUtils.asSet((Object[])new Long[]{selectMemberId}), (MemberTypeEnum)MemberTypeEnum.MEMBER);
        QuoteCheckResult result = MemberQuote.get().checkQuoteDataResult(quote);
        if (result.isHasQuote()) {
            if ("openapi".equals(this.getBizEntityNumber())) {
                throw new KDBizException(result.getMsg());
            }
            this.setBeforeAction(false);
            this.getView().showMessage(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u5df2\u88ab\u5f15\u7528\uff0c \u4e0d\u5141\u8bb8\u7c98\u8d34\u3002", (String)"DimMemBaseAction_23", (String)"epm-eb-cube", (Object[])new Object[0]), result.getMsg(), MessageTypes.Default);
            return;
        }
        Set childrenIds = DimensionServiceHelper.getAllChildrenId((String)cutMember.getDimension().getMembermodel(), (Long)cutMember.getModel().getId(), (Long)cutMember.getDimension().getId(), (Long)cutMember.getViewId(), (Long)cutMember.getMember().getId(), (boolean)true);
        if (childrenIds.contains(this.getDimInfo().getMemberId())) {
            if ("openapi".equals(this.getBizEntityNumber())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u53ef\u5c06\u6210\u5458\u79fb\u52a8\u5230\u81ea\u8eab\u6216\u81ea\u8eab\u4e0b\u7ea7\u6210\u5458\u4e0b\u3002", (String)"DimensionManagerList_76", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.setBeforeAction(false);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5c06\u526a\u5207\u7684\u6210\u5458\u7c98\u5e16\u5230\u81ea\u5df1\u6216\u81ea\u5df1\u4e0b\u7ea7\u7684\u6210\u5458\u4e0b\u3002", (String)"DimMemBaseAction_9", (String)"epm-eb-cube", (Object[])new Object[0]));
        }
    }

    @Override
    public void doAction() {
        super.doAction();
        if (this.isDoAction()) {
            this.memberPaste();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void memberPaste() {
        String cutMemberCache = this.getPageCache().get(this.getPasteMemberKey());
        if (StringUtils.isEmpty((String)cutMemberCache)) {
            if ("openapi".equals(this.getBizEntityNumber())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u9700\u8981\u79fb\u52a8\u7684\u6210\u5458\u3002", (String)"DimensionManagerList_75", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.setAfterAction(false);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u526a\u5207\u6210\u5458\u3002", (String)"DimMemBaseAction_41", (String)"epm-eb-cube", (Object[])new Object[0]));
            return;
        }
        DimManagerInfo cutMember = (DimManagerInfo)SerializationUtils.deSerializeFromBase64((String)cutMemberCache);
        long modelId = this.getDimInfo().getModel().getId();
        long dimensionId = this.getDimInfo().getDimension().getId();
        long selectMemberId = this.getDimInfo().getMember().getId();
        long cutMemberId = cutMember.getMember().getId();
        String _entityNumber = this.getMemberModel(this.getDimInfo());
        DynamicObject cutObject = this.queryObject(cutMember);
        if (cutObject == null) {
            this.dealError(ResManager.loadKDString((String)"\u8981\u526a\u5207\u7684\u6210\u5458\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DimMemBaseAction_48", (String)"epm-eb-cube", (Object[])new Object[0]));
            this.setAfterAction(false);
            return;
        }
        DynamicObject pasteObject = this.queryObject(this.getDimInfo());
        if (pasteObject == null) {
            this.dealError(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u7ef4\u5ea6\u6210\u5458\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"DimMemBaseAction_50", (String)"epm-eb-cube", (Object[])new Object[0]));
            this.setAfterAction(false);
            return;
        }
        long memberId = selectMemberId;
        if (IDUtils.isNotNull((Long)this.getDimInfo().getViewId())) {
            DynamicObject selectMember = BusinessDataServiceHelper.loadSingleFromCache((Object)memberId, (String)"eb_viewmember", (String)"memberid");
            memberId = selectMember.getLong("memberid");
        }
        CheckQuote quote = QuoteBuilder.build((Long)modelId, (Long)dimensionId, (Long)this.getDimInfo().getViewId(), (Set)CollectionUtils.asSet((Object[])new Long[]{memberId}), (MemberTypeEnum)MemberTypeEnum.MEMBER);
        QuoteCheckResult result = MemberQuote.get().checkQuoteDataResult(quote);
        if (result.isHasQuote()) {
            if ("openapi".equals(this.getBizEntityNumber())) {
                throw new KDBizException(result.getMsg());
            }
            this.setAfterAction(false);
            this.getView().showMessage(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u5df2\u88ab\u5f15\u7528\uff0c \u4e0d\u5141\u8bb8\u7c98\u8d34\u3002", (String)"DimMemBaseAction_23", (String)"epm-eb-cube", (Object[])new Object[0]), result.getMsg(), MessageTypes.Default);
            return;
        }
        Set childrenIds = DimensionServiceHelper.getAllChildrenId((String)_entityNumber, (Long)modelId, (Long)dimensionId, (Long)cutMember.getViewId(), (Long)cutMemberId, (boolean)true);
        if (childrenIds.isEmpty()) {
            this.setAfterAction(false);
            this.getStats().addInfo("childrenIds is null.");
            return;
        }
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)cutMember.getModelId());
        builder.add("dimension", "=", (Object)cutMember.getDimensionId());
        if (IDUtils.isNotNull((Long)cutMember.getViewId())) {
            builder.add("view", "=", (Object)cutMember.getViewId());
        }
        builder.add("id", "in", (Object)childrenIds);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)_entityNumber, (String)"id,number,longnumber,parent,level,dseq,modifytime,modifier", (QFilter[])builder.toArray(), (String)"level");
        if (load == null || load.length == 0) {
            this.setAfterAction(false);
            this.getStats().addInfo("load is null.");
            return;
        }
        Map<Long, DynamicObject> memberMap = Arrays.stream(load).collect(Collectors.toMap(m -> m.getLong("id"), m -> m));
        DynamicObject _cutMember = memberMap.get(cutMember.getMember().getId());
        if (_cutMember == null) {
            if ("openapi".equals(this.getBizEntityNumber())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u9700\u8981\u79fb\u52a8\u7684\u6210\u5458\u3002", (String)"DimensionManagerList_75", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u526a\u5207\u6210\u5458\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"DimensionManagerList_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.setAfterAction(false);
            return;
        }
        if (_cutMember.getDynamicObject("parent").getLong("id") == selectMemberId) {
            this.setAfterAction(false);
            this.getStats().addInfo("cutMember parent is currMember.");
            return;
        }
        MemberInfo currMember = this.getDimInfo().getMember();
        _cutMember.set("longnumber", (Object)(currMember.getLongnumber() + "!" + _cutMember.getString("number")));
        _cutMember.set("level", (Object)(currMember.getLevel() + 1));
        _cutMember.set("parent", (Object)currMember.getId());
        _cutMember.set("dseq", (Object)DimensionServiceHelper.getDSeq((long)currMember.getId(), (String)this.getMemberModel(this.getDimInfo()), (long)this.getDimInfo().getViewId()));
        HashSet pasteNumbers = Sets.newHashSetWithExpectedSize((int)(load.length + 2));
        int in = load.length;
        for (int i = 1; i < in; ++i) {
            DynamicObject _child = load[i];
            DynamicObject _parent = memberMap.get(_child.getDynamicObject("parent").getLong("id"));
            _child.set("longnumber", (Object)(_parent.getString("longnumber") + "!" + _child.getString("number")));
            _child.set("level", (Object)(_parent.getInt("level") + 1));
            pasteNumbers.add(_child.getString("number"));
        }
        try (TXHandle tx = TX.requiresNew((String)"pasteMember");){
            try {
                SaveServiceHelper.save((DynamicObject[])load);
                DimensionServiceHelper.updateIsLeafByParentId((Long[])new Long[]{cutMember.getMember().getParentId(), this.getDimInfo().getMember().getId()}, (Long)modelId, (Long)dimensionId, (String)_entityNumber);
                pasteNumbers.add(cutMember.getMember().getNumber());
                pasteNumbers.add(this.getDimInfo().getMember().getNumber());
                this.updateMainSubSign(pasteNumbers, cutMember.getView() != null ? cutMember.getView().getNumber() : null);
            }
            catch (Exception ex) {
                log.error("member-paste-error:", (Throwable)ex);
                tx.markRollback();
                throw new KDBizException(ex.getMessage());
            }
        }
        finally {
            CubeUtils.get().checkDimension(Long.valueOf(this.getDimInfo().getModel().getId()), Long.valueOf(this.getDimInfo().getDimension().getId()));
            ModelCacheContext.removeModel((Long)modelId);
        }
        if (!"openapi".equals(this.getBizEntityNumber()) || this.isBeforeAction()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7c98\u8d34\u6210\u529f\u3002", (String)"DimensionManagerList_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getPageCache().remove("cutMemberIds");
        this.getPageCache().remove("cutViewMemberIds");
        EBThreadPoolExecutor.executeOnce(() -> {
            if (this.getDimInfo().getModel().isEb()) {
                ShrekOlapServiceHelper.clearParentDataNullForEb((Long)cutMember.getMember().getParentId(), (String)cutMember.getDimension().getMembermodel());
                this.syncDataLockWhenEntityParse(cutMember, this.getDimInfo());
            } else {
                if (IDUtils.isNotNull((Long)this.getDimInfo().getViewId())) {
                    ViewMemberManager.getInstance().syncViewMember(this.getDimInfo().getModelId(), this.getDimInfo().getDimension().getNumber(), this.getDimInfo().getViewId().longValue(), null);
                }
                this.syncOlapMembersWhenPaste(cutMember);
                RuleUpdateServiceImpl.getInstance().updateAfterMemberPaste(modelId, this.getDimInfo().getDimension().getId(), childrenIds);
            }
        }, (String)"memberPaste");
    }

    private void updateMainSubSign(Set<String> pasteNumbers, String viewNumber) {
        DimManagerInfo dimManagerInfo = this.getDimInfo();
        if (dimManagerInfo != null) {
            Set allSubIds;
            Long modelId = dimManagerInfo.getModel().getId();
            String dataMeta = dimManagerInfo.getDimension().getMembermodel();
            if (StringUtils.isNotEmpty((String)viewNumber)) {
                dataMeta = "eb_viewmember";
            }
            if (!(allSubIds = BgmdMainSubControlHelper.getInstance().getAllSubIds(modelId)).isEmpty()) {
                QFilter qFilter = new QFilter("model", "in", (Object)allSubIds);
                if (StringUtils.isNotEmpty((String)viewNumber)) {
                    qFilter.and("view.number", "=", (Object)viewNumber);
                }
                qFilter.and("number", "in", pasteNumbers);
                if (DataModelTransEnum.userdefine.getFormID().equalsIgnoreCase(dataMeta)) {
                    qFilter.and("dimension.number", "in", (Object)dimManagerInfo.getDimension().getNumber());
                }
                DynamicObjectCollection numberList = QueryServiceHelper.query((String)dataMeta, (String)"id", (QFilter[])qFilter.toArray());
                HashSet<Long> ids = new HashSet<Long>(16);
                for (DynamicObject dynamicObject : numberList) {
                    ids.add(dynamicObject.getLong("id"));
                }
                BgmdMainSubControlHelper.getInstance().updateSubSign(this.getDimInfo().getDimension().getMembermodel(), "3", ids);
            }
        }
    }

    @Override
    public void afterAction() {
        super.afterAction();
        if (!this.isAfterAction()) {
            return;
        }
        if (this.getPlugin() instanceof BaseDimensionManager) {
            if (!View.NoViewDimNums.contains(this.getDimInfo().getDimension().getNumber()) && !this.getDimInfo().getModel().isEb()) {
                String tag = this.getPageCache().get("tag");
                String currentNodeKey = this.getPageCache().get("currentNodeKey");
                ((BaseDimensionManager)this.getPlugin()).refreshListOrViewMember(currentNodeKey, tag);
            } else {
                ((BaseDimensionManager)this.getPlugin()).refreshMember();
            }
            ((BaseDimensionManager)this.getPlugin()).clearCache();
        }
        if (this.getPlugin() instanceof DataSetListPlugin) {
            ((DataSetListPlugin)this.getPlugin()).refreshMembers();
            ((DataSetListPlugin)this.getPlugin()).setTab(true);
            ((DataSetListPlugin)this.getPlugin()).clearCache();
        }
        this.writeLog(this.getDimInfo().getMember().getNumber(), "paste", this.getOpName(), this.getOpDescription(), new String[]{this.getDimInfo().getDimension().getName(), this.getDimInfo().getMember().getName() + '-' + this.getDimInfo().getMember().getNumber()});
    }

    protected MultiLangEnumBridge getOpName() {
        return new MultiLangEnumBridge("\u7ef4\u5ea6\u6210\u5458\u7c98\u8d34", "MemberPasteAction_0", "epm-eb-formplugin");
    }

    protected MultiLangEnumBridge getOpDescription() {
        return new MultiLangEnumBridge("\u7ef4\u5ea6-%1$s\uff0c\u7c98\u8d34\u7ef4\u5ea6\u6210\u5458\u53ca\u5b50\u6210\u5458-(%2$s)", "MemberPasteAction_1", "epm-eb-formplugin");
    }

    private void syncOlapMembersWhenPaste(DimManagerInfo cutMember) {
        DynamicObject model = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getDimInfo().getModel().getId(), (String)"epm_model");
        String entityNumber = this.getDimInfo().getDimension().getMembermodel();
        String dimNum = this.getDimInfo().getDimension().getNumber();
        ShrekConfig config = this.getModelCache(this.getDimInfo().getModel().getId()).getModelobj().isModelByEB() ? ShrekConfigServiceHelper.getEBConfig() : ShrekConfigServiceHelper.getBgMDConfig();
        List datasets = DatasetServiceHelper.getDatasets((DynamicObject)model, (String)dimNum);
        Model _model = Model.of((DynamicObject)model);
        this.updateParentDynamicCalc(cutMember.getMember().getParentId(), datasets, _model, entityNumber, dimNum, config);
        this.updateParentDynamicCalc(this.getDimInfo().getMember().getId(), datasets, _model, entityNumber, dimNum, config);
    }

    private void updateParentDynamicCalc(Long parentId, List<Dataset> datasets, Model model, String entityNumber, String dimNum, ShrekConfig config) {
        boolean hasView = IDUtils.isNotNull((Long)this.getDimInfo().getViewId());
        String selectFields = "id,number,dseq,aggoprt,isleaf,level";
        if (hasView) {
            selectFields = "id,number,dseq,aggoprt,isleaf,level,memberid";
        } else if (SysDimensionEnum.Account.getNumber().equals(dimNum)) {
            selectFields = "id,number,dseq,dataset,aggoprt,isleaf,level";
        }
        String _entityNumber = hasView ? "eb_viewmember" : entityNumber;
        DynamicObject parent = BusinessDataServiceHelper.loadSingleFromCache((String)_entityNumber, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)parentId)});
        List children = DimensionServiceHelper.queryChildren((String)selectFields, (long)parentId, (String)_entityNumber);
        if (SysDimensionEnum.Account.getNumber().equals(dimNum) && SysDimensionEnum.Account.getNumber().equals(parent.getString("number"))) {
            for (Dataset dataset : datasets) {
                List _children = children.stream().filter(doj -> dataset.getId().equals(doj.getLong("dataset"))).collect(Collectors.toList());
                ShrekOlapServiceHelper.updateCubeMember((Model)model, (Dataset)dataset, (String)dimNum, (Member)Member.of((DynamicObject)parent, _children), (ShrekConfig)config);
            }
        } else {
            ShrekOlapServiceHelper.updateCubeMember((Model)model, datasets, (String)dimNum, (Member)Member.of((DynamicObject)parent, (Collection)children), (ShrekConfig)config);
        }
    }

    private void syncDataLockWhenEntityParse(DimManagerInfo cutMember, DimManagerInfo currMember) {
        if (!SysDimensionEnum.Entity.getNumber().equals(this.getDimInfo().getDimension().getNumber())) {
            return;
        }
        long modelId = currMember.getModel().getId();
        long currMemberId = currMember.getMember().getId();
        long cutParentId = cutMember.getMember().getParentId();
        IModelCacheHelper modelCacheHelper = this.getModelCache(modelId);
        Member currentMember = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), currMember.getViewId(), Long.valueOf(currMemberId));
        Member parentMember = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), cutMember.getViewId(), Long.valueOf(cutParentId));
        List allFather = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), cutMember.getViewId(), parentMember.getNumber(), RangeEnum.ANCESTOR.getIndex());
        HashMap<String, Integer> fatherSortMap = new HashMap<String, Integer>(allFather.size());
        int index = 0;
        for (Member member : allFather) {
            fatherSortMap.put(member.getNumber(), index++);
        }
        List bizModelIdList = BusinessModelServiceHelper.getInstance().getRefBaseViewBizModelIdsByDimId(Long.valueOf(modelId), Long.valueOf(currMember.getDimension().getId()));
        for (Long bizModelId : bizModelIdList) {
            QFilter qFilter = new QFilter("model", "=", (Object)modelId);
            qFilter.and(new QFilter("businessmodel", "=", (Object)bizModelId));
            qFilter.and(new QFilter("entity", "in", fatherSortMap.keySet()).or(new QFilter("entity", "=", (Object)currentMember.getNumber())));
            DataLockPageUserSelect tryKey = null;
            HashMap<DataLockPageUserSelect, Pair> collectMap = new HashMap<DataLockPageUserSelect, Pair>(16);
            boolean needskip = false;
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"bgmdDataLockBuildCache", (String)"bgmd_datalock", (String)"year,version,datatype,audittrail,entity,periodinteger", (QFilter[])qFilter.toArray(), (String)"year,version,datatype,audittrail");
            Object object = null;
            try {
                while (dataSet.hasNext()) {
                    Row next = dataSet.next();
                    Long l = next.getLong("year");
                    Long versionId = next.getLong("version");
                    Long datatypeId = next.getLong("datatype");
                    Long audittrailId = next.getLong("audittrail");
                    DataLockPageUserSelect currentKey = new DataLockPageUserSelect(l.longValue(), versionId.longValue(), datatypeId.longValue(), audittrailId.longValue());
                    if (tryKey == null || !tryKey.equals((Object)currentKey)) {
                        needskip = false;
                        tryKey = currentKey;
                    }
                    if (needskip) continue;
                    String entityNumber = next.getString("entity");
                    Integer periodinteger = next.getInteger("periodinteger");
                    if (currentMember.getNumber().equals(entityNumber)) {
                        collectMap.remove(tryKey);
                        needskip = true;
                        continue;
                    }
                    Pair pair = (Pair)collectMap.get(tryKey);
                    index = (Integer)fatherSortMap.get(entityNumber);
                    if (pair != null) {
                        Integer oldIndex = (Integer)pair.getKey();
                        if (index >= oldIndex) continue;
                        collectMap.put(tryKey, new Pair((Object)index, (Object)periodinteger));
                        continue;
                    }
                    collectMap.put(tryKey, new Pair((Object)index, (Object)periodinteger));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (dataSet != null) {
                    if (object != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
            ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(16);
            for (Map.Entry entry : collectMap.entrySet()) {
                DataLockPageUserSelect key = (DataLockPageUserSelect)entry.getKey();
                Pair pair = (Pair)entry.getValue();
                DynamicObject datalockDoj = BusinessDataServiceHelper.newDynamicObject((String)"bgmd_datalock");
                datalockDoj.set("model", (Object)modelId);
                datalockDoj.set("businessmodel", (Object)bizModelId);
                datalockDoj.set("year", (Object)key.getPeriod());
                datalockDoj.set("version", (Object)key.getVersion());
                datalockDoj.set("datatype", (Object)key.getDataType());
                datalockDoj.set("audittrail", (Object)key.getAuditTrail());
                datalockDoj.set("entity", (Object)currentMember.getNumber());
                datalockDoj.set("periodinteger", pair.getValue());
                dynamicObjects.add(datalockDoj);
            }
            if (!org.apache.commons.collections4.CollectionUtils.isNotEmpty(dynamicObjects)) continue;
            SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
            BusinessDataServiceHelper.removeCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bgmd_datalock"));
            BgmdDataLockCacheHelper.clearDataLock((Long)modelId, (Long)bizModelId);
        }
    }
}

