/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.action;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.dimensionEnums.DimMembActionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.cube.dimension.entitys.DimManagerInfo;
import kd.epm.eb.formplugin.dimension.action.BaseOperationAction;
import org.jetbrains.annotations.NotNull;

public class MemberPermAction
extends BaseOperationAction {
    private String result = "";
    private boolean showResult = true;

    public MemberPermAction(@NotNull IFormView view, @NotNull IFormPlugin plugin, @NotNull IDataModel dataModel, @NotNull IPageCache pageCache, @NotNull DimManagerInfo dimInfo) {
        super(view, plugin, dataModel, pageCache, dimInfo);
    }

    public MemberPermAction(@NotNull IFormView view, @NotNull IFormPlugin plugin, @NotNull IDataModel dataModel, @NotNull IPageCache pageCache, @NotNull DimManagerInfo dimInfo, boolean showResult) {
        super(view, plugin, dataModel, pageCache, dimInfo);
        this.showResult = showResult;
    }

    @Override
    public String getResult() {
        return this.result;
    }

    public boolean isShowResult() {
        return this.showResult;
    }

    public void setShowResult(boolean showResult) {
        this.showResult = showResult;
    }

    protected boolean verifyPerm() {
        return true;
    }

    @Override
    public void beforeAction() {
        DimMembActionEnum actionEnum;
        DynamicObject dynamicObject;
        super.beforeAction();
        if (!this.isBeforeAction()) {
            return;
        }
        if (!this.verifyPerm()) {
            return;
        }
        long modelId = this.getDimInfo().getModelId();
        long memberId = this.getDimInfo().getMemberId();
        if (IDUtils.isNull((long)modelId) || IDUtils.isNull((long)memberId)) {
            this.setBeforeAction(false);
            return;
        }
        Long userId = UserUtils.getUserId();
        Long dimId = this.getDimInfo().getDimension().getId();
        Long viewId = this.getDimInfo().getViewId();
        if (!View.NoViewDimNums.contains(this.getDimInfo().getDimension().getNumber()) && (dynamicObject = QueryServiceHelper.queryOne((String)"eb_viewmember", (String)"memberid", (QFilter[])new QFilter("id", "=", (Object)memberId).toArray())) != null) {
            memberId = dynamicObject.getLong("memberid");
        }
        if ((actionEnum = DimMembActionEnum.getActionEnumByKey((String)this.getPermKey())) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u6210\u5458\u7684\u6743\u9650\u3002", (String)"DimMemBaseAction_42", (String)"epm-eb-cube", (Object[])new Object[0]));
        }
        switch (actionEnum) {
            case ADDAGAIN: {
                boolean hasPerm = DimMembPermHelper.hasManagerPerm((Long)memberId, (Long)viewId, (Long)dimId, (Long)userId, (Long)modelId);
                if (hasPerm) break;
                this.result = ResManager.loadKDString((String)"\u65e0\u4e0a\u7ea7\u6210\u5458\u7684\u7ba1\u7406\u6743\u9650\uff0c\u4e0d\u53ef\u8fde\u7eed\u65b0\u589e", (String)"DimMemBaseAction_12", (String)"epm-eb-cube", (Object[])new Object[0]);
                break;
            }
            case ADDCHILD: {
                boolean hasPerm = DimMembPermHelper.hasManagerPerm((Long)memberId, (Long)viewId, (Long)dimId, (Long)userId, (Long)modelId);
                if (hasPerm) break;
                this.result = ResManager.loadKDString((String)"\u65e0\u8be5\u6210\u5458\u7684\u7ba1\u7406\u6743\u9650\uff0c\u4e0d\u53ef\u65b0\u589e", (String)"DimMemBaseAction_13", (String)"epm-eb-cube", (Object[])new Object[0]);
                break;
            }
            case DELETE: {
                boolean hasPerm = DimMembPermHelper.hasManagerPerm((Long)memberId, (Long)viewId, (Long)dimId, (Long)userId, (Long)modelId);
                if (hasPerm) break;
                this.result = ResManager.loadKDString((String)"\u65e0\u8be5\u6210\u5458\u7684\u7ba1\u7406\u6743\u9650\uff0c\u4e0d\u53ef\u5220\u9664", (String)"DimMemBaseAction_14", (String)"epm-eb-cube", (Object[])new Object[0]);
                break;
            }
            case EDIT: {
                boolean hasPerm = DimMembPermHelper.hasManagerPerm((Long)memberId, (Long)viewId, (Long)dimId, (Long)userId, (Long)modelId);
                if (hasPerm) break;
                this.result = ResManager.loadKDString((String)"\u65e0\u8be5\u6210\u5458\u7684\u7ba1\u7406\u6743\u9650\uff0c\u4e0d\u53ef\u7f16\u8f91", (String)"DimMemBaseAction_15", (String)"epm-eb-cube", (Object[])new Object[0]);
                break;
            }
            case MOVEUP: 
            case MOVEDOWN: {
                DynamicObject _member = this.getMemberObj();
                memberId = _member != null ? _member.getLong("parent") : 0L;
                boolean hasPerm = DimMembPermHelper.hasManagerPerm((Long)memberId, (Long)viewId, (Long)dimId, (Long)userId, (Long)modelId);
                if (hasPerm) break;
                this.result = ResManager.loadKDString((String)"\u65e0\u4e0a\u7ea7\u6210\u5458\u7684\u7ba1\u7406\u6743\u9650\uff0c\u4e0d\u53ef\u79fb\u52a8", (String)"DimMemBaseAction_16", (String)"epm-eb-cube", (Object[])new Object[0]);
                break;
            }
            case PASTE: {
                boolean hasPerm = DimMembPermHelper.hasManagerPerm((Long)memberId, (Long)viewId, (Long)dimId, (Long)userId, (Long)modelId);
                if (hasPerm) break;
                if ("openapi".equals(this.getBizEntityNumber())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u4e0a\u7ea7\u6210\u5458\u7684\u7ba1\u7406\u6743\u9650\uff0c\u4e0d\u53ef\u79fb\u52a8", (String)"DimMemBaseAction_16", (String)"epm-eb-cube", (Object[])new Object[0]));
                }
                this.result = ResManager.loadKDString((String)"\u65e0\u7c98\u8d34\u6210\u5458\u7684\u7ba1\u7406\u6743\u9650\uff0c\u4e0d\u53ef\u7c98\u8d34", (String)"DimMemBaseAction_17", (String)"epm-eb-cube", (Object[])new Object[0]);
                break;
            }
            case CUT: {
                boolean hasPerm = DimMembPermHelper.hasManagerPerm((Long)memberId, (Long)viewId, (Long)dimId, (Long)userId, (Long)modelId);
                if (hasPerm) break;
                if ("openapi".equals(this.getBizEntityNumber())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u7ef4\u5ea6\u6210\u5458\u7684\u7ba1\u7406\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u79fb\u52a8\u3002", (String)"DimMemBaseAction_44", (String)"epm-eb-cube", (Object[])new Object[0]));
                }
                this.result = ResManager.loadKDString((String)"\u65e0\u526a\u5207\u6210\u5458\u7684\u7ba1\u7406\u6743\u9650\uff0c\u4e0d\u53ef\u526a\u5207", (String)"DimMemBaseAction_18", (String)"epm-eb-cube", (Object[])new Object[0]);
                break;
            }
        }
        if (StringUtils.isNotEmpty((String)this.result)) {
            this.setBeforeAction(false);
            if (this.isShowResult()) {
                this.getView().showTipNotification(this.result);
            }
        }
    }

    private DynamicObject getMemberObj() {
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)this.getDimInfo().getModelId());
        builder.add("dimension", "=", (Object)this.getDimInfo().getDimensionId());
        builder.add("id", "=", (Object)this.getDimInfo().getMemberId());
        return QueryServiceHelper.queryOne((String)this.getDimInfo().getDimension().getMembermodel(), (String)"id,parent", (QFilter[])builder.toArrays());
    }
}

