/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.action;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.cube.dimension.entitys.DimManagerInfo;
import kd.epm.eb.formplugin.dimension.action.MemberMoveAction;
import kd.epm.eb.olap.service.view.ViewMemberManager;
import org.jetbrains.annotations.NotNull;

public class MemberUpAction
extends MemberMoveAction {
    public MemberUpAction(@NotNull IFormView view, @NotNull IFormPlugin plugin, @NotNull IDataModel dataModel, @NotNull IPageCache pageCache, @NotNull DimManagerInfo dimInfo) {
        super(view, plugin, dataModel, pageCache, dimInfo);
    }

    @Override
    public void doAction() {
        super.doAction();
        if (this.isDoAction()) {
            LogStats stats = new LogStats("budget-log : ");
            stats.addInfo("begin-up-member.");
            try {
                this.upMember(stats);
            }
            finally {
                stats.addInfo("end-up-member.");
                log.info(stats.toString());
            }
        }
    }

    private void upMember(LogStats stats) {
        String dimShortNumber = this.getDimInfo().getDimension().getShortNumber();
        String entityNumber = this.getDimInfo().getDimension().getMembermodel();
        boolean hasView = IDUtils.isNotNull((Long)this.getDimInfo().getViewId());
        if (hasView) {
            entityNumber = "eb_viewmember";
        }
        String fields = "id,number,dseq,membersource,parent.id";
        DynamicObject selectMember = BusinessDataServiceHelper.loadSingle((Object)this.getDimInfo().getMember().getId(), (String)entityNumber, (String)fields);
        int begin_sel_seq = selectMember.getInt("dseq");
        if (begin_sel_seq <= 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u5df2\u7ecf\u662f\u8be5\u5c42\u6b21\u7b2c\u4e00\u884c\u3002", (String)"DimensionManagerList_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            QFBuilder builder = new QFBuilder();
            builder.add("model", "=", (Object)this.getDimInfo().getModel().getId());
            if (IDUtils.isNotNull((Long)this.getDimInfo().getViewId())) {
                builder.add("view", "=", (Object)this.getDimInfo().getViewId());
            }
            builder.add("dimension", "=", (Object)this.getDimInfo().getDimension().getId());
            builder.add("parent", "=", (Object)this.getDimInfo().getMember().getParentId());
            builder.add("dseq", "<", (Object)begin_sel_seq);
            DynamicObjectCollection dcs = QueryServiceHelper.query((String)"queryMemBrother", (String)entityNumber, (String)"id", (QFilter[])builder.toArray(), (String)"dseq desc", (int)1);
            if (dcs != null && !dcs.isEmpty()) {
                DynamicObject parent;
                DynamicObject targetMember = (DynamicObject)dcs.get(0);
                if ((targetMember = BusinessDataServiceHelper.loadSingle((Object)targetMember.get("id"), (String)entityNumber, (String)fields)) == null) {
                    return;
                }
                if (MemberUpAction.checkPresetSource(hasView, dimShortNumber, this.getDimInfo().getDimension().getMembermodel(), targetMember.getString("number"), targetMember.getString("membersource"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u79fb\u52a8\u9884\u7f6e\u6210\u5458\u3002", (String)"DimMemBaseAction_4", (String)"epm-eb-cube", (Object[])new Object[0]));
                    return;
                }
                if (MemberUpAction.checkRefSource(hasView, targetMember.getString("membersource")) && MemberUpAction.checkInnerRefSource(true, (parent = BusinessDataServiceHelper.loadSingleFromCache((Object)targetMember.getLong("parent.id"), (String)"eb_viewmember", (String)"id, membersource")).getString("membersource"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u5185\u5f15\u7528\u6210\u5458\u4e0d\u5141\u8bb8\u79fb\u52a8\u3002", (String)"DimMemBaseAction_5", (String)"epm-eb-cube", (Object[])new Object[0]));
                    return;
                }
                stats.addInfo("targetMember-begin:number = " + targetMember.getString("number") + ", seq=" + targetMember.getInt("dseq"));
                int target_sel_Seq = targetMember.getInt("dseq");
                targetMember.set("dseq", (Object)begin_sel_seq);
                selectMember.set("dseq", (Object)target_sel_Seq);
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{selectMember, targetMember});
                stats.addInfo("selectMember:number=" + selectMember.getString("number") + ", seq=" + selectMember.getInt("dseq") + ", beginSeq=" + begin_sel_seq);
                stats.addInfo("targetMember:number=" + targetMember.getString("number") + ", seq=" + targetMember.getInt("dseq") + ", beginSeq=" + target_sel_Seq);
                if (hasView) {
                    DynamicObject parent2 = BusinessDataServiceHelper.loadSingle((Object)targetMember.get("parent.id"), (String)entityNumber, (String)"id,memberid");
                    ViewMemberManager.getInstance().syncViewMemberDeq(this.getDimInfo().getModel().getId(), this.getDimInfo().getDimension().getNumber(), this.getDimInfo().getViewId().longValue(), parent2);
                }
                this.getDimInfo().getMember().setSeq(target_sel_Seq);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u5df2\u7ecf\u662f\u8be5\u5c42\u6b21\u7b2c\u4e00\u884c\u3002", (String)"DimensionManagerList_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

