/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.action;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.servicehelper.DimensionServiceHelper;
import kd.epm.eb.common.cache.DimMembPermVerHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.eventbus.EventBusUtil;
import kd.epm.eb.common.eventbus.event.MemberChangeEvent;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.shrek.service.ShrekCubeServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.DynamicObjectUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.control.utils.BgMemMappingServiceHelper;
import kd.epm.eb.cube.dimension.entitys.DimManagerInfo;
import kd.epm.eb.formplugin.dimension.action.MemberPermAction;
import kd.epm.eb.formplugin.dimension.utils.MemberCheckUtils;
import kd.epm.eb.olap.service.view.ViewMemberManager;
import org.jetbrains.annotations.NotNull;

public class MoveBatchMoveAction
extends MemberPermAction {
    private Map<Long, Long> memberParentMap = null;

    public void setMemberParentMap(Map<Long, Long> memberParentMap) {
        this.memberParentMap = memberParentMap;
    }

    public Map<Long, Long> getMemberParentMap() {
        return this.memberParentMap;
    }

    public MoveBatchMoveAction(@NotNull IFormView view, @NotNull IFormPlugin plugin, @NotNull IDataModel dataModel, @NotNull IPageCache pageCache, @NotNull DimManagerInfo dimInfo) {
        super(view, plugin, dataModel, pageCache, dimInfo);
    }

    @Override
    public void beforeAction() {
        this.setBeforeAction(true);
        MemberCheckUtils utils = MemberCheckUtils.get();
        try {
            if (!utils.checkIsLeaf(this.getDimInfo().getModelId(), this.getDimInfo().getDimensionId(), this.getDimInfo().getViewId(), new HashSet<Long>(this.getMemberParentMap().values()))) {
                this.setBeforeAction(false);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u6210\u5458\u5df2\u7ecf\u6709\u6570\u636e\u6216\u8005\u63a7\u5236\u8bb0\u5f55\u3001\u8c03\u6574\u8bb0\u5f55\u3001\u7533\u62a5\u6570\u636e\uff0c\u4e0d\u80fd\u8c03\u6574\u6210\u975e\u660e\u7ec6\u6210\u5458\u3002", (String)"EntityAdjustPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            }
            if (utils.checkIsAllLeaf(this.getDimInfo().getModelId(), this.getDimInfo().getDimensionId(), this.getDimInfo().getViewId(), new HashSet<Long>(this.getMemberParentMap().values()))) {
                this.setBeforeAction(false);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u6210\u5458\u5728\u5176\u5b83\u89c6\u56fe\u4e5f\u662f\u660e\u7ec6\u6210\u5458\uff0c\u4e0d\u80fd\u8c03\u6574\u6210\u975e\u660e\u7ec6\u6210\u5458\u3002", (String)"EntityAdjustPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            }
        }
        catch (Exception ex) {
            this.setBeforeAction(false);
            this.getView().showTipNotification(ex.getMessage(), Integer.valueOf(2000));
        }
    }

    @Override
    protected boolean verifyPerm() {
        return false;
    }

    @Override
    public void doAction() {
        super.doAction();
        try {
            if (this.isBeforeAction()) {
                this.$doAction();
            } else {
                this.getStats().addInfo("beforeAction is false");
            }
        }
        catch (Exception ex) {
            this.setDoAction(false);
            log.error("batchMoveEntity-error:", (Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u7ec4\u7ec7\u6279\u91cf\u8c03\u6574\u9519\u8bef\uff08%1\uff09", (String)"MoveBatchMoveAction_0", (String)"epm-eb-formplugin", (Object[])new Object[]{ex.getMessage()}));
        }
        finally {
            this.getStats().add("end-do-batchMove-entity.");
        }
    }

    private void $doAction() {
        String fields;
        String entityNumber;
        DynamicObject view = null;
        Long modelId = this.getDimInfo().getModelId();
        Long dimensionId = this.getDimInfo().getDimensionId();
        Long viewId = this.getDimInfo().getViewId();
        if (IDUtils.isNotNull((Long)viewId)) {
            view = BusinessDataServiceHelper.loadSingleFromCache((Object)viewId, (String)"eb_dimensionview", (String)"id,number,name,source,usag");
        }
        QFBuilder builder = new QFBuilder();
        if (view == null) {
            entityNumber = SysDimensionEnum.Entity.getMemberTreemodel();
            fields = "id,name,number,level,isleaf,dseq,longnumber,parent.id";
        } else {
            entityNumber = "eb_viewmember";
            fields = "id,name,number,level,isleaf,dseq,memberid,longnumber,parent.id";
        }
        LinkedHashMap cacheMemberMap = Maps.newLinkedHashMap();
        LinkedHashMap dseqMap = Maps.newLinkedHashMap();
        LinkedHashSet parentIds = Sets.newLinkedHashSet();
        ArrayList<AppLogInfo> logs = new ArrayList<AppLogInfo>(this.getMemberParentMap().size());
        BizModel model = new BizModel(BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"epm_model"));
        DynamicObject dimension = BusinessDataServiceHelper.loadSingleFromCache((Object)dimensionId, (String)"epm_dimension");
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u7ec4\u7ec7\u6279\u91cf\u8c03\u6574", "MoveBatchMoveAction_1", "epm-eb-formplugin");
        MultiLangEnumBridge opDetail = new MultiLangEnumBridge("\u4f53\u7cfb(%1$s)\u4e0b\u7684(%2$s)\u7ef4\u5ea6\u6210\u5458(%3$s)\u7531\u539f\u6765\u7684(%4$s)\u6210\u5458\u4e0b\u79fb\u52a8\u5230\u76ee\u6807(%5$s)\u6210\u5458\u4e0b\u3002", "MoveBatchMoveAction_2", "epm-eb-formplugin");
        String bizAppId = ApplicationTypeEnum.BGMD.getAppnum();
        if (model.isNewEBByModel()) {
            bizAppId = ApplicationTypeEnum.BG.getAppnum();
        }
        for (Map.Entry<Long, Long> entry : this.getMemberParentMap().entrySet()) {
            builder.clear();
            builder.add("model", "=", (Object)modelId);
            builder.add("dimension", "=", (Object)dimensionId);
            if (view == null) {
                builder.add("id", "in", (Object)CollectionUtils.asList((Object[])new Long[]{entry.getKey(), entry.getValue()}));
            } else {
                builder.add("view", "=", (Object)viewId);
                builder.add("memberid", "in", (Object)CollectionUtils.asList((Object[])new Long[]{entry.getKey(), entry.getValue()}));
            }
            DynamicObject[] moveMembers = BusinessDataServiceHelper.load((String)entityNumber, (String)fields, (QFilter[])builder.toArray(), (String)"level,number");
            Map<Long, DynamicObject> moveMemberMap = view == null ? Arrays.stream(moveMembers).collect(Collectors.toMap(m -> m.getLong("id"), m -> m)) : Arrays.stream(moveMembers).collect(Collectors.toMap(m -> m.getLong("memberid"), m -> m));
            DynamicObject member = moveMemberMap.get(entry.getKey());
            DynamicObject newParent = moveMemberMap.get(entry.getValue());
            DynamicObject oldParent = BusinessDataServiceHelper.loadSingleFromCache((Object)member.getLong("parent.id"), (String)entityNumber, (String)fields);
            String[] opArgs = new String[]{model.getName() + '-' + model.getNumber(), dimension.getString("name") + '-' + dimension.getString("number"), member.getString("name") + '-' + member.getString("number"), oldParent.getString("name") + '-' + oldParent.getString("number"), newParent.getString("name") + '-' + newParent.getString("number")};
            AppLogInfo logInfo = OperationLogUtil.buildLogInfo((String)bizAppId, (String)entityNumber, (String)member.getString("number"), (String)"batchMove", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDetail, (String[])opArgs);
            logs.add(logInfo);
            parentIds.add(newParent.getLong("id"));
            parentIds.add(oldParent.getLong("id"));
            builder.clear();
            builder.add("model", "=", (Object)modelId);
            builder.add("dimension", "=", (Object)dimensionId);
            if (view != null) {
                builder.add("view", "=", (Object)viewId);
            }
            QFilter filter = view == null ? new QFilter("id", "=", (Object)member.getLong("id")) : new QFilter("memberid", "=", (Object)member.getLong("memberid"));
            filter.or("longnumber", "like", (Object)(member.getString("longnumber") + "!%"));
            builder.add(filter);
            cacheMemberMap.clear();
            Map members = BusinessDataServiceHelper.loadFromCache((String)entityNumber, (String)fields, (QFilter[])builder.toArray(), (String)"longnumber");
            for (DynamicObject _member : members.values()) {
                if (member.getLong("id") == _member.getLong("id")) {
                    _member.set("longnumber", (Object)(newParent.getString("longnumber") + '!' + _member.getString("number")));
                    _member.set("level", (Object)(newParent.getInt("level") + 1));
                    Long parentId = newParent.getLong("id");
                    _member.set("parent", (Object)parentId);
                    Integer dseq = (Integer)dseqMap.get(parentId);
                    dseq = dseq == null ? Integer.valueOf(DimensionServiceHelper.getDSeq((long)parentId, (String)entityNumber)) : Integer.valueOf(dseq + 1);
                    dseqMap.put(parentId, dseq);
                    _member.set("dseq", (Object)dseq);
                } else {
                    DynamicObject _parent = (DynamicObject)cacheMemberMap.get(_member.getLong("parent.id"));
                    _member.set("longnumber", (Object)(_parent.getString("longnumber") + '!' + _member.getString("number")));
                    _member.set("level", (Object)(_parent.getInt("level") + 1));
                }
                cacheMemberMap.put(_member.getLong("id"), _member);
            }
            TXHandle tx = TX.requiresNew((String)"batchMoveEntity");
            Throwable throwable = null;
            try {
                try {
                    DynamicObjectUtils.save((DynamicObject[])cacheMemberMap.values().toArray(new DynamicObject[0]));
                    DimensionServiceHelper.updateIsLeafByParentId((Long[])parentIds.toArray(new Long[0]), (Long)modelId, (Long)dimensionId, (String)entityNumber);
                    ViewMemberManager.getInstance().syncViewMember(modelId.longValue(), "Entity", viewId.longValue(), null);
                    OperationLogUtil.log(logs);
                }
                catch (Exception ex) {
                    tx.markRollback();
                    log.error("batchMoveEntity-TX-Error:", (Throwable)ex);
                    throw new KDBizException(CommonServiceHelper.getStackTraceStr((Throwable)ex));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
            }
        }
    }

    @Override
    public void afterAction() {
        super.afterAction();
        if (!this.isDoAction()) {
            return;
        }
        this.getStats().addInfo("begin-after-doAction.");
        Long modelId = this.getDimInfo().getModelId();
        Long dimensionId = this.getDimInfo().getDimensionId();
        Long viewId = this.getDimInfo().getViewId();
        CubeUtils.updateDimensionVersion((Long)modelId, (Long)dimensionId);
        EventBusUtil.asyncPost((Object)new MemberChangeEvent(modelId, dimensionId, viewId));
        DimMembPermVerHelper.updateVer4MembChanged((Long)viewId, (Long)modelId, (Long)dimensionId, (String)"afterBatchEntityMove");
        CubeUtils.clearCentralizedCache((Long)modelId, (Long)dimensionId);
        BgMemMappingServiceHelper.clearCacheByModel((Long)modelId, (Long)dimensionId);
        IModelCacheHelper modelCacheHelper = this.getModelCache(modelId, true);
        ShrekConfig config = ShrekConfigServiceHelper.getDefaultConfig((Model)modelCacheHelper.getModelobj());
        if (!this.getDimInfo().getModel().isEb()) {
            List datasets = DatasetServiceHelper.getDatasetsByViewId((Long)this.getDimInfo().getModelId(), (Long)viewId);
            if (datasets.isEmpty()) {
                this.getStats().addInfo("datasets is null.");
            } else {
                for (Dataset dataset : datasets) {
                    try {
                        if (ShrekCubeServiceHelper.existCube((Model)modelCacheHelper.getModelobj(), (Dataset)dataset)) {
                            ShrekCubeServiceHelper.updateCube((Model)modelCacheHelper.getModelobj(), (Dataset)dataset, (IModelCacheHelper)modelCacheHelper, (ShrekConfig)config);
                            continue;
                        }
                        ShrekCubeServiceHelper.createCube((Model)modelCacheHelper.getModelobj(), (Dataset)dataset, (IModelCacheHelper)modelCacheHelper, (ShrekConfig)config);
                    }
                    catch (Exception ex) {
                        log.error("shrek-updateCube-error:", (Throwable)ex);
                        throw new KDBizException(ex.getMessage());
                    }
                }
            }
        }
        this.getStats().add("end-after-doAction.");
    }
}

