/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.action;

import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageTypes;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.quote.CheckQuote;
import kd.epm.eb.business.quote.MemberQuote;
import kd.epm.eb.business.quote.QuoteBuilder;
import kd.epm.eb.business.quote.QuoteCheckResult;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.cube.dimension.entitys.DimManagerInfo;
import kd.epm.eb.formplugin.dimension.DimensionManagerList;
import kd.epm.eb.formplugin.dimension.action.BaseOperationAction;
import kd.epm.eb.olap.service.view.ViewGroupManager;
import org.jetbrains.annotations.NotNull;

public class ViewDeleteAction
extends BaseOperationAction {
    public ViewDeleteAction(@NotNull IFormView view, @NotNull IFormPlugin plugin, @NotNull IDataModel dataModel, @NotNull IPageCache pageCache, @NotNull DimManagerInfo dimInfo) {
        super(view, plugin, dataModel, pageCache, dimInfo);
    }

    @Override
    public boolean isCallBack() {
        return true;
    }

    @Override
    public void beforeAction() {
        this.setBeforeAction(true);
        Long viewId = this.getDimInfo().getViewId();
        if (IDUtils.isNull((Long)viewId)) {
            this.setBeforeAction(false);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u89c6\u56fe\u5185\u5bb9\u4e0d\u53ef\u5220\u9664\u3002", (String)"DimensionManagerList_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("1".equals(this.getDimInfo().getView().getSource())) {
            this.setBeforeAction(false);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u89c6\u56fe\u5185\u5bb9\u4e0d\u53ef\u5220\u9664\u3002", (String)"DimensionManagerList_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!ModelServiceHelper.isUserHasRootPermByModel((long)UserUtils.getUserId(), (Long)this.getDimInfo().getModelId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u4f53\u7cfb\u7ba1\u7406\u5458\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u89c6\u56fe\u5220\u9664\u64cd\u4f5c\u3002", (String)"DimensionManagerList_91", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            return;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)this.getDimInfo().getModelId()));
        builder.add(new QFilter("viewentry.viewgroup.defaultview.id", "=", (Object)viewId));
        if (QueryServiceHelper.exists((String)"eb_businessmodel", (QFilter[])builder.toArray())) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u89c6\u56fe\u5df2\u7ecf\u88ab\u4e1a\u52a1\u6a21\u578b\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"MemberCutAction_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qFilter = new QFilter("dimension", "=", (Object)this.getDimInfo().getDimensionId()).and("model", "=", (Object)this.getDimInfo().getModelId()).and("refview", "=", (Object)viewId);
        boolean exists = QueryServiceHelper.exists((String)"eb_viewmember", (QFilter[])qFilter.toArray());
        if (exists) {
            this.setBeforeAction(false);
            this.getView().showMessage(ResManager.loadKDString((String)"\u89c6\u56fe\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ViewDeleteAction_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.checkDimQuote()) {
            this.setBeforeAction(false);
            return;
        }
        if (this.isBeforeAction()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u8be5\u89c6\u56fe\u5c06\u540c\u65f6\u5220\u9664\u5176\u5305\u542b\u7684\u6240\u6709\u89c6\u56fe\u6210\u5458\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DimensionManagerList_11", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("delViewConfirmBack"));
        }
    }

    private boolean checkDimQuote() {
        CheckQuote checkQuote = QuoteBuilder.build((Long)this.getDimInfo().getModelId(), (Long)this.getDimInfo().getDimensionId(), (Long)this.getDimInfo().getViewId(), (MemberTypeEnum)MemberTypeEnum.VIEW);
        QuoteCheckResult check = MemberQuote.get().checkQuoteResult(checkQuote);
        if (check.isHasQuote()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u89c6\u56fe\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ViewDeleteAction_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), check.getMsg(), MessageTypes.Default);
        }
        return check.isHasQuote();
    }

    @Override
    public void doAction() {
        super.doAction();
        if (this.checkDimQuote()) {
            this.setDoAction(false);
        }
        if (this.isDoAction()) {
            this.deleteView();
        }
    }

    private void deleteView() {
        Long modelId = this.getDimInfo().getModelId();
        Long dimensionId = this.getDimInfo().getDimensionId();
        String modelNumber = this.getDimInfo().getModel().getNumber();
        String dimensionNumber = this.getDimInfo().getDimension().getNumber();
        String viewNumber = this.getDimInfo().getView().getNumber();
        String focusNodeId = this.getView().getPageCache().get("currentNodeKey");
        if (StringUtils.isEmpty((String)focusNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u89c6\u56fe\u3002", (String)"DimensionManagerList_85", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode viewTreeNode = (TreeNode)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("viewTreeCache"));
        TreeNode treeNode = viewTreeNode.getTreeNode(focusNodeId, 20);
        LinkedList<Long> viewIds = new LinkedList<Long>();
        this.getViewTreeId(treeNode, viewIds);
        try (TXHandle tx = TX.required((String)"deleteView");){
            try {
                ViewGroupManager.getInstance().deleteViews(modelId, this.getDimInfo().getDimension().getNumber(), viewIds);
                SqlBuilder sqlBuilder = new SqlBuilder();
                sqlBuilder.append("update t_eb_dimensionview_group set fdefaultview = 0 where fmodelid = ? and", new Object[]{modelId});
                sqlBuilder.appendIn("fdefaultview", viewIds.toArray());
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664\u89c6\u56fe", "DimensionManagerList_31", "epm-eb-formplugin");
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u4f53\u7cfb\uff1a%1$s, \u7ef4\u5ea6\uff1a%2$s, \u5220\u9664\u89c6\u56fe\uff1a%3$s", "DimensionManagerList_30", "epm-eb-formplugin");
                this.writeLog(viewNumber, "delete", opName, opDesc, new String[]{modelNumber, dimensionNumber, viewNumber});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DimensionManagerList_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            catch (Exception ex) {
                log.error("deleteView-error:", (Throwable)ex);
                tx.markRollback();
                throw new KDBizException(ex.getMessage());
            }
            finally {
                for (Long viewId : viewIds) {
                    CubeUtils.get().deleteView(modelId, dimensionId, viewId);
                }
            }
        }
    }

    private void getViewTreeId(TreeNode treeNode, List<Long> viewIds) {
        viewIds.add(Long.valueOf(treeNode.getId()));
        List children = treeNode.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                this.getViewTreeId(child, viewIds);
            }
        }
    }

    @Override
    public void afterAction() {
        super.afterAction();
        ((DimensionManagerList)this.getPlugin()).initViewTree();
    }
}

