/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.action;

import java.util.Collections;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageTypes;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.quote.CheckQuote;
import kd.epm.eb.business.quote.MemberQuote;
import kd.epm.eb.business.quote.QuoteBuilder;
import kd.epm.eb.business.quote.QuoteCheckResult;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.cube.dimension.entitys.DimManagerInfo;
import kd.epm.eb.formplugin.dimension.DimensionManagerList;
import kd.epm.eb.formplugin.dimension.action.BaseOperationAction;
import kd.epm.eb.formplugin.dimension.action.verification.IVerification;
import kd.epm.eb.olap.service.view.ViewGroupManager;
import org.jetbrains.annotations.NotNull;

public class ViewGroupDeleteAction
extends BaseOperationAction {
    private DynamicObject dynamicObject = null;

    public ViewGroupDeleteAction(@NotNull IFormView view, @NotNull IFormPlugin plugin, @NotNull IDataModel dataModel, @NotNull IPageCache pageCache, @NotNull DimManagerInfo dimInfo) {
        super(view, plugin, dataModel, pageCache, dimInfo);
    }

    @Override
    public boolean isCallBack() {
        return true;
    }

    @Override
    public void beforeAction() {
        this.setBeforeAction(true);
        IVerification verification = this.getVerification();
        if (verification != null && !verification.verification()) {
            this.setBeforeAction(false);
        }
        if (!this.isBeforeAction()) {
            return;
        }
        String currentNodeKey = this.getView().getPageCache().get("currentNodeKey");
        if (StringUtils.isEmpty((String)currentNodeKey)) {
            this.setBeforeAction(false);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u89c6\u56fe\u5206\u7ec4\u3002", (String)"ViewGroupEditAction_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        long id = Long.parseLong(currentNodeKey);
        if (!QueryServiceHelper.exists((String)"eb_dimensionview_group", (Object)id)) {
            this.setBeforeAction(false);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u89c6\u56fe\u5206\u7ec4\u3002", (String)"ViewGroupEditAction_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_dimensionview_group");
        String number = this.dynamicObject.getString("number");
        if ("default".equals(number)) {
            this.setBeforeAction(false);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u89c6\u56fe\u5206\u7ec4\u4e0d\u53ef\u5220\u9664\u3002", (String)"ViewGroupDeleteAction_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!ModelServiceHelper.isUserHasRootPermByModel((long)UserUtils.getUserId(), (Long)this.getDimInfo().getModelId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u4f53\u7cfb\u7ba1\u7406\u5458\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u89c6\u56fe\u7ec4\u5220\u9664\u64cd\u4f5c\u3002", (String)"ViewGroupDeleteAction_8", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            return;
        }
        if (QueryServiceHelper.exists((String)"eb_dimensionview", (QFilter[])new QFilter("viewgroup", "=", (Object)id).toArray())) {
            this.setBeforeAction(false);
            this.getView().showMessage(ResManager.loadKDString((String)"\u89c6\u56fe\u7ec4\u4e0b\u6709\u89c6\u56fe\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ViewGroupDeleteAction_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (QueryServiceHelper.exists((String)"eb_dimensionview_group", (QFilter[])new QFilter("parent.id", "=", (Object)id).toArray())) {
            this.setBeforeAction(false);
            this.getView().showMessage(ResManager.loadKDString((String)"\u89c6\u56fe\u7ec4\u4e0b\u6709\u76ee\u5f55\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ViewGroupDeleteAction_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.isBeforeAction()) {
            String description = ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u5f53\u524d\u89c6\u56fe\u5206\u7ec4\uff1f", (String)"ViewGroupDeleteAction_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(description, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delViewGroupConfirmBack", this.getPlugin()));
        }
    }

    private boolean checkDimQuote() {
        String currentNodeKey = this.getView().getPageCache().get("currentNodeKey");
        long id = Long.parseLong(currentNodeKey);
        CheckQuote checkQuote = QuoteBuilder.build((Long)this.getDimInfo().getModelId(), (Long)this.getDimInfo().getDimensionId(), (Long)id, (MemberTypeEnum)MemberTypeEnum.VIEWGROUP);
        QuoteCheckResult check = MemberQuote.get().checkQuoteResult(checkQuote);
        if (check.isHasQuote()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u89c6\u56fe\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ViewDeleteAction_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), check.getMsg(), MessageTypes.Default);
        }
        return check.isHasQuote();
    }

    @Override
    public void doAction() {
        super.doAction();
        if (this.checkDimQuote()) {
            this.setDoAction(false);
        }
        if (this.isDoAction()) {
            this.deleteViewGroup();
        }
    }

    private void deleteViewGroup() {
        String currentNodeKey;
        String dimensionNumber;
        String modelNumber;
        Throwable throwable;
        TXHandle tx;
        block17: {
            block18: {
                block19: {
                    tx = TX.required((String)"deleteViewGroup");
                    throwable = null;
                    modelNumber = this.getDimInfo().getModel().getNumber();
                    dimensionNumber = this.getDimInfo().getDimension().getNumber();
                    currentNodeKey = this.getView().getPageCache().get("currentNodeKey");
                    if (!StringUtils.isEmpty((String)currentNodeKey)) break block17;
                    this.setBeforeAction(false);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u89c6\u56fe\u5206\u7ec4\u3002", (String)"ViewGroupEditAction_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    if (tx == null) break block18;
                    if (throwable == null) break block19;
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                tx.close();
            }
            return;
        }
        try {
            try {
                long id = Long.parseLong(currentNodeKey);
                this.dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_dimensionview_group");
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664\u89c6\u56fe", "DimensionManagerList_31", "epm-eb-formplugin");
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u4f53\u7cfb\uff1a%1$s, \u7ef4\u5ea6\uff1a%2$s, \u5220\u9664\u89c6\u56fe\u5206\u7ec4\uff1a%3$s", "ViewGroupDeleteAction_4", "epm-eb-formplugin");
                this.writeLog(this.dynamicObject.getString("number"), "delete", opName, opDesc, new String[]{modelNumber, dimensionNumber, this.dynamicObject.getString("number")});
                ViewGroupManager.getInstance().deleteViewGroup(Long.valueOf(this.getDimInfo().getModelId()), this.getDimInfo().getDimension().getNumber(), Collections.singletonList(id));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DimensionManagerList_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                log.error((Throwable)e);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002", (String)"ViewGroupDeleteAction_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (tx != null) {
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Override
    public void afterAction() {
        super.afterAction();
        ((DimensionManagerList)this.getPlugin()).initViewTree();
    }
}

