/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.action.verification;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.enums.dimensionEnums.ViewMemberSourceEnum;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.cube.dimension.entitys.DimManagerInfo;
import kd.epm.eb.formplugin.dimension.action.BaseOperationAction;
import kd.epm.eb.formplugin.dimension.action.IAction;
import kd.epm.eb.formplugin.dimension.action.verification.IVerification;
import kd.epm.eb.model.utils.ModelUtil;
import org.jetbrains.annotations.NotNull;

public abstract class BaseMemberVerification
implements IVerification {
    private final DimManagerInfo dimInfo;
    private final IAction action;
    private final IFormPlugin plugin;
    private final IFormView view;
    private final IPageCache pageCache;
    private static final Set<String> PASTE_DIM_ROOT = new HashSet<String>();
    private static final Map<String, Set<String>> PASTE_PRESET = new HashMap<String, Set<String>>();
    protected static final String OPENAPI = "openapi";

    protected DimManagerInfo getDimInfo() {
        return this.dimInfo;
    }

    protected IAction getAction() {
        return this.action;
    }

    protected IFormPlugin getPlugin() {
        return this.plugin;
    }

    protected IFormView getView() {
        return this.view;
    }

    protected IPageCache getPageCache() {
        return this.pageCache;
    }

    public BaseMemberVerification(@NotNull DimManagerInfo dimInfo, @NotNull IAction action, @NotNull IFormPlugin plugin, @NotNull IFormView view, @NotNull IPageCache pageCache) {
        this.dimInfo = dimInfo;
        this.action = action;
        this.plugin = plugin;
        this.view = view;
        this.pageCache = pageCache;
    }

    @Override
    public boolean verification() {
        boolean verify;
        switch (this.action.getActionKey()) {
            case "btn_addmember": {
                verify = this.verifyAddNew();
                break;
            }
            case "btn_editmember": {
                verify = this.verifyEdit();
                break;
            }
            case "btn_delmember": {
                verify = this.verifyDelete();
                break;
            }
            default: {
                verify = this.verifyOther();
            }
        }
        return verify;
    }

    private boolean verifyCosmicMember() {
        DimManagerInfo dimInfo = this.getDimInfo();
        String dimensionNumber = dimInfo.getDimension().getNumber();
        long memberId = dimInfo.getMemberId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getDimInfo().getModel().getId());
        Member member = modelCache.getMember(dimensionNumber, dimInfo.getViewId(), Long.valueOf(memberId));
        if (member != null) {
            Member parentMember;
            List children;
            String parentNumber = member.getParentNumber();
            Member cosmicMember = modelCache.getMember(dimensionNumber, this.getDimInfo().getViewId(), parentNumber + "._inv");
            if (cosmicMember != null && (children = (parentMember = modelCache.getMember(dimensionNumber, this.getDimInfo().getViewId(), parentNumber)).getChildrenNotWithCosmic()).size() == 1) {
                this.getView().showMessage(ResManager.loadResFormat((String)"%1\u7684\u4e0a\u7ea7\u6709\u672a\u5904\u7406\u7684\u5ba1\u6279\u8c03\u6574\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u53d8\u6210\u660e\u7ec6\u6210\u5458\uff0c\u81f3\u5c11\u9700\u6709\u4e00\u4e2a\u4e0b\u7ea7\u6210\u5458\u3002", (String)"DimMemBaseAction_56", (String)"epm-eb-cube", (Object[])new Object[]{member.getName()}));
                return false;
            }
        }
        return true;
    }

    protected boolean verifyAddNew() {
        String entityNumber;
        String memberNumber = this.getDimInfo().getMember().getNumber();
        String memberSource = this.getDimInfo().getMember().getMembersource();
        String noneNumber = this.getDimInfo().getDimension().getShortNumber() + "None";
        String string = entityNumber = IDUtils.isNotNull((Long)this.getDimInfo().getViewId()) ? "eb_viewmember" : this.getDimInfo().getDimension().getMembermodel();
        if (MemberSourceEnum.PRESET.getIndex().equals(memberSource) && noneNumber.equals(memberNumber)) {
            this.dealError(ResManager.loadKDString((String)"\u201c\u4e0d\u533a\u5206\u6210\u5458\u201d\u4e0d\u5141\u8bb8\u65b0\u589e\u4e0b\u7ea7\u6210\u5458\u3002", (String)"DefinedDimensionAction_0", (String)"epm-eb-cube", (Object[])new Object[0]));
            return false;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)this.getDimInfo().getMember().getId());
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)entityNumber, (String)"disable", (QFilter[])qFilter.toArray());
        if (dynamicObject != null && dynamicObject.getBoolean("disable")) {
            this.dealError(ResManager.loadKDString((String)"\u7981\u7528\u7684\u6210\u5458\u4e0d\u5141\u8bb8\u65b0\u589e\u4e0b\u7ea7\u6210\u5458\u3002", (String)"DefinedDimensionAction_3", (String)"epm-eb-cube", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected boolean verifyEdit() {
        return true;
    }

    protected boolean verifyDelete() {
        int level = this.getDimInfo().getMember().getLevel();
        if (level <= 1) {
            this.dealError(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u7ef4\u5ea6\u6210\u5458\u7684\u6839\u8282\u70b9\u3002", (String)"DimMemBaseAction_2", (String)"epm-eb-cube", (Object[])new Object[0]));
            return false;
        }
        String memberSource = this.getDimInfo().getMember().getMembersource();
        String appIndex = ModelUtil.queryApp((IFormView)this.getView()).getIndex();
        if (!View.NoViewDimNums.contains(this.getDimInfo().getDimension().getNumber()) && !ApplicationTypeEnum.EB.getIndex().equals(appIndex)) {
            if (ViewMemberSourceEnum.PRESET.getIndex().equals(memberSource)) {
                this.dealError(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u9884\u7f6e\u6210\u5458\u3002", (String)"DimMemBaseAction_3", (String)"epm-eb-cube", (Object[])new Object[0]));
                return false;
            }
        } else if (MemberSourceEnum.PRESET.getIndex().equals(memberSource)) {
            this.dealError(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u9884\u7f6e\u6210\u5458\u3002", (String)"DimMemBaseAction_3", (String)"epm-eb-cube", (Object[])new Object[0]));
            return false;
        }
        return this.verifyCosmicMember();
    }

    protected boolean verifyOther() {
        boolean verify = true;
        switch (this.getAction().getActionKey()) {
            case "btn_cut": {
                verify = this.verifyCut();
                break;
            }
            case "btn_paste": {
                verify = this.verifyPaste();
                if (verify) break;
                this.getPageCache().remove("cutMemberIds");
                this.getPageCache().remove("cutViewMemberIds");
                break;
            }
            case "btn_downmove": 
            case "btn_upmove": {
                verify = this.verifyMove();
            }
        }
        return verify;
    }

    protected boolean verifyCut() {
        boolean re = this.verifyCosmicMember();
        if (re) {
            DynamicObject parent;
            boolean hasView = IDUtils.isNotNull((Long)this.getDimInfo().getViewId());
            if (BaseOperationAction.checkPresetSource(hasView, this.getDimInfo().getDimension().getShortNumber(), this.getDimInfo().getDimension().getMembermodel(), this.getDimInfo().getMember().getNumber(), this.getDimInfo().getMember().getMembersource())) {
                this.dealError(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u526a\u5207\u9884\u7f6e\u6210\u5458\u3002", (String)"DimMemBaseAction_6", (String)"epm-eb-cube", (Object[])new Object[0]));
                re = false;
            } else if (BaseOperationAction.checkRefSource(hasView, this.getDimInfo().getMember().getMembersource()) && (parent = BusinessDataServiceHelper.loadSingle((Object)this.getDimInfo().getMember().getParentId(), (String)"eb_viewmember", (String)"id,membersource")) != null && BaseOperationAction.checkInnerRefSource(true, parent.getString("membersource"))) {
                this.dealError(ResManager.loadKDString((String)"\u5f15\u7528\u6210\u5458\u4e0d\u5141\u8bb8\u526a\u5207\u3002", (String)"DimMemBaseAction_7", (String)"epm-eb-cube", (Object[])new Object[0]));
                re = false;
            }
        }
        return re;
    }

    protected void dealError(String errorInfo) {
        if (OPENAPI.equals(this.getBizEntityNumber())) {
            throw new KDBizException(errorInfo);
        }
        this.getView().showTipNotification(errorInfo);
    }

    protected boolean verifyPaste() {
        String _entityNumber;
        int level = this.getDimInfo().getMember().getLevel();
        String dimShortNumber = this.getDimInfo().getDimension().getShortNumber();
        String memberModel = this.getDimInfo().getDimension().getMembermodel();
        String memberSource = this.getDimInfo().getMember().getMembersource();
        boolean hasView = IDUtils.isNotNull((Long)this.getDimInfo().getViewId());
        String string = _entityNumber = hasView ? "eb_viewmember" : this.getDimInfo().getDimension().getMembermodel();
        if (BaseOperationAction.checkInnerRefSource(hasView, memberSource)) {
            this.dealError(ResManager.loadKDString((String)"\u5f15\u7528\u6210\u5458\u4e0d\u5141\u8bb8\u7c98\u8d34\u4e0b\u7ea7\u3002", (String)"DimMemBaseAction_8", (String)"epm-eb-cube", (Object[])new Object[0]));
            return false;
        }
        if (level == 2 && BaseOperationAction.checkPresetSource(hasView, dimShortNumber, memberModel, this.getDimInfo().getMember().getNumber(), memberSource) && BgDimensionServiceHelper.hasUserDefinedDimension((String)this.getDimInfo().getDimension().getMembermodel())) {
            this.dealError(ResManager.loadKDString((String)"\u201c\u4e0d\u533a\u5206\u6210\u5458\u201d\u4e0d\u5141\u8bb8\u65b0\u589e\u4e0b\u7ea7\u3002", (String)"DefinedDimensionAction_2", (String)"epm-eb-cube", (Object[])new Object[0]));
            return false;
        }
        if (!this.verifyPreset(hasView)) {
            return false;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)this.getDimInfo().getMember().getId());
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)_entityNumber, (String)"disable", (QFilter[])qFilter.toArray());
        if (dynamicObject != null && dynamicObject.getBoolean("disable")) {
            this.dealError(ResManager.loadKDString((String)"\u7981\u7528\u7684\u6210\u5458\u4e0d\u5141\u8bb8\u65b0\u589e\u4e0b\u7ea7\u6210\u5458\u3002", (String)"DefinedDimensionAction_3", (String)"epm-eb-cube", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected boolean verifyPreset(boolean hasView) {
        boolean re = true;
        Set<String> lawful = PASTE_PRESET.get(this.getDimInfo().getDimension().getNumber());
        if (lawful != null && lawful.contains(this.getDimInfo().getMember().getNumber())) {
            return true;
        }
        if (SysDimensionEnum.ChangeType.getNumber().equals(this.getDimInfo().getDimension().getNumber()) && "ActualChanges".equals(this.getDimInfo().getMember().getNumber())) {
            this.dealError(ResManager.loadKDString((String)"\u5b9e\u9645\u6570\u521d\u59cb\u5316\u4e0b\u7ea7\u4e0d\u5141\u8bb8\u65b0\u589e\u4e0b\u7ea7\u3002", (String)"DimensionManagerList_64", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            re = false;
        }
        String dimShortNumber = this.getDimInfo().getDimension().getShortNumber();
        String memberModel = this.getDimInfo().getDimension().getMembermodel();
        if (re && BaseOperationAction.checkPresetSource(hasView, dimShortNumber, memberModel, this.getDimInfo().getMember().getNumber(), this.getDimInfo().getMember().getMembersource())) {
            if (this.checkLawfulDim(this.getDimInfo().getDimension().getMembermodel())) {
                DynamicObject parent;
                String rootMemberNumber = this.getDimInfo().getDimension().getNumber();
                if (IDUtils.isNotNull((Long)this.getDimInfo().getViewId())) {
                    if (!"1".equals(this.getDimInfo().getView().getSource())) {
                        rootMemberNumber = this.getDimInfo().getDimension().getNumber() + "_" + this.getDimInfo().getView().getNumber();
                    }
                    parent = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getDimInfo().getMember().getId(), (String)"eb_viewmember", (String)"id,number");
                } else {
                    parent = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getDimInfo().getMember().getId(), (String)this.getDimInfo().getDimension().getMembermodel(), (String)"id,number");
                }
                if (StringUtils.notEquals((String)rootMemberNumber, (String)parent.getString("number"))) {
                    this.dealError(ResManager.loadKDString((String)"\u9884\u7f6e\u6210\u5458\u4e0d\u5141\u8bb8\u65b0\u589e\u4e0b\u7ea7\u6210\u5458\u3002", (String)"DimMemBaseAction_8_1", (String)"epm-eb-cube", (Object[])new Object[0]));
                    re = false;
                }
            } else {
                this.dealError(ResManager.loadKDString((String)"\u9884\u7f6e\u6210\u5458\u4e0d\u5141\u8bb8\u65b0\u589e\u4e0b\u7ea7\u6210\u5458\u3002", (String)"DimMemBaseAction_8_1", (String)"epm-eb-cube", (Object[])new Object[0]));
                re = false;
            }
        }
        return re;
    }

    private boolean checkLawfulDim(String entityModel) {
        return PASTE_DIM_ROOT.contains(entityModel);
    }

    protected boolean verifyMove() {
        DynamicObject parent;
        String dimShortNumber = this.getDimInfo().getDimension().getShortNumber();
        String memberModel = this.getDimInfo().getDimension().getMembermodel();
        String memberSource = this.getDimInfo().getMember().getMembersource();
        if (BaseOperationAction.checkPresetSource(IDUtils.isNotNull((Long)this.getDimInfo().getViewId()), dimShortNumber, memberModel, this.getDimInfo().getMember().getNumber(), memberSource)) {
            this.dealError(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u79fb\u52a8\u9884\u7f6e\u6210\u5458\u3002", (String)"DimMemBaseAction_4", (String)"epm-eb-cube", (Object[])new Object[0]));
            return false;
        }
        if (BaseOperationAction.checkRefSource(IDUtils.isNotNull((Long)this.getDimInfo().getViewId()), this.getDimInfo().getMember().getMembersource()) && (parent = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getDimInfo().getMember().getParentId(), (String)"eb_viewmember", (String)"id, membersource")) != null && BaseOperationAction.checkInnerRefSource(true, parent.getString("membersource"))) {
            this.dealError(ResManager.loadKDString((String)"\u7ec4\u5185\u5f15\u7528\u6210\u5458\u4e0d\u5141\u8bb8\u79fb\u52a8\u3002", (String)"DimMemBaseAction_5", (String)"epm-eb-cube", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected String getBizEntityNumber() {
        if (OPENAPI.equals(this.getView().getPageId())) {
            return OPENAPI;
        }
        return this.getView().getModel().getDataEntityType().getName();
    }

    static {
        PASTE_PRESET.put("Account", CollectionUtils.asSet((Object[])new String[]{"Account"}));
        PASTE_PRESET.put("Version", CollectionUtils.asSet((Object[])new String[]{"Version"}));
        PASTE_PRESET.put("DataType", CollectionUtils.asSet((Object[])new String[]{"Budget", "Actual"}));
        PASTE_PRESET.put("ChangeType", CollectionUtils.asSet((Object[])new String[]{"ActualChanges"}));
        PASTE_PRESET.put("AuditTrail", CollectionUtils.asSet((Object[])new String[]{"AuditTrail", "ATTotal", "EntityInput"}));
        PASTE_DIM_ROOT.add(SysDimensionEnum.Entity.getMemberTreemodel());
        PASTE_DIM_ROOT.add(SysDimensionEnum.ChangeType.getMemberTreemodel());
        PASTE_DIM_ROOT.add("epm_userdefinedmembertree");
    }
}

