/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.customproperty;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.Save;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.servicehelper.DimensionPropertyServiceHelper;
import kd.epm.eb.business.utils.CheckStringsUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;

public class CustomPropertyEditPlugin
extends AbstractBasePlugin {
    public void afterCreateNewData(EventObject e) {
        IFormView iFormView = this.getView();
        String dimensionId = (String)iFormView.getFormShowParameter().getCustomParam("dimensionId");
        String modelId = (String)iFormView.getFormShowParameter().getCustomParam("model");
        if (StringUtils.isEmpty((String)dimensionId) || StringUtils.isEmpty((String)modelId)) {
            iFormView.showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u6216\u7ef4\u5ea6\u4e0d\u5b58\u5728\uff0c\u8bf7\u8fd4\u56de\u540e\u91cd\u8bd5\u3002", (String)"CustomPropertyEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            iFormView.setEnable(Boolean.valueOf(false), new String[]{"number", "name"});
            return;
        }
        this.getPageCache().put("dimensionId", dimensionId);
        this.getPageCache().put("modelId", modelId);
        this.getModel().setValue("dimension", (Object)dimensionId);
        this.getModel().setValue("model", (Object)modelId);
        int maxdseq = DimensionPropertyServiceHelper.getInstance().getMaxSeq(Long.valueOf(Long.parseLong(modelId)), Long.valueOf(Long.parseLong(dimensionId)));
        this.getModel().setValue("dseq", (Object)(maxdseq + 1));
        this.getModel().setValue("source", (Object)"0");
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opType = ((FormOperate)args.getSource()).getType();
        if ("save".equals(opType)) {
            DynamicObject model = (DynamicObject)this.getModel().getValue("model");
            DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension");
            if (model == null || dimension == null) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bfb\u53d6\u4f53\u7cfb\u548c\u7ef4\u5ea6\u5931\u8d25\uff0c\u8bf7\u8fd4\u56de\u540e\u91cd\u8bd5\u3002", (String)"CustomPropertyEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            String number = (String)this.getModel().getValue("number");
            if (!CheckStringsUtil.checkAllowNumStart((String)number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4ec5\u5141\u8bb8\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3002", (String)"CustomPropertyEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                args.setCancel(true);
                return;
            }
            String msgNumber = this.check("number", model);
            if (StringUtils.isNotEmpty((String)msgNumber)) {
                this.getView().showTipNotification(msgNumber);
                args.setCancel(true);
                return;
            }
            OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
            if (StringUtils.isEmpty((String)name.getLocaleValue())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u540d\u79f0\u3002", (String)"OrganizationViewEditPlugin_45", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String msgName = this.check("name", model);
            if (StringUtils.isNotEmpty((String)msgName)) {
                this.getView().showTipNotification(msgName);
                args.setCancel(true);
                return;
            }
            this.getModel().setValue("modifier", (Object)UserUtils.getUserId());
            this.getModel().setValue("modifydate", (Object)TimeServiceHelper.now());
            this.getModel().setValue("version", (Object)DBServiceHelper.genGlobalLongId());
        }
        if ("close".equals(opType)) {
            this.getModel().setDataChanged(false);
        }
    }

    private String check(String field, DynamicObject model) {
        DynamicObject cusProperty;
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", model.get("id"));
        if ("number".equals(field)) {
            String number = (String)this.getModel().getValue("number");
            builder.add("number", "=", (Object)number);
        } else if ("name".equals(field)) {
            OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
            builder.add("name", "=", (Object)name.getLocaleValue().trim());
        }
        Object id = this.getModel().getValue("id");
        if (id instanceof Long) {
            builder.add(new QFilter("id", "!=", id));
        }
        if ((cusProperty = QueryServiceHelper.queryOne((String)"eb_customproperty", (String)"id, dimension.number, dimension.name", (QFilter[])builder.toArray())) != null) {
            if ("number".equals(field)) {
                return ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u81ea\u5b9a\u4e49\u5c5e\u6027\u3002", (String)"CustomPropertyEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[]{cusProperty.getString("dimension.name")});
            }
            return ResManager.loadResFormat((String)"\u201c%1\u201d\u7ef4\u5ea6\u4e0b\u5df2\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u81ea\u5b9a\u4e49\u5c5e\u6027\u3002", (String)"CustomPropertyEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{cusProperty.getString("dimension.name")});
        }
        return "";
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        boolean issuccess = e.getOperationResult().getValidateResult().isSuccess();
        List ids = e.getOperationResult().getSuccessPkIds();
        if (e.getSource() instanceof Save && issuccess && ids.size() > 0) {
            this.getView().returnDataToParent((Object)String.valueOf(ids.get(0)));
            this.getView().close();
        }
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong((Object)((DynamicObject)this.getModel().getValue("model")).get("id"));
    }
}

