/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.customproperty;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.quote.CheckQuote;
import kd.epm.eb.business.quote.MemberQuote;
import kd.epm.eb.business.quote.QuoteCheckResult;
import kd.epm.eb.business.servicehelper.DimensionPropertyServiceHelper;
import kd.epm.eb.business.templateperm.TemplatePermServiceHelper;
import kd.epm.eb.business.utils.CheckStringsUtil;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.entity.property.CustomPropertyUtils;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.eventbus.EventBusUtil;
import kd.epm.eb.common.eventbus.event.PropValueChangeEvent;
import kd.epm.eb.common.permission.MembPermRecordUtil;
import kd.epm.eb.common.sonmodel.BgmdMainSubControlHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.fileImport.FileImportUtils;
import kd.epm.eb.cube.dimension.ImportAndExport.CustomEntity;
import kd.epm.eb.formplugin.sonmodel.MainSubAbstractFormPlugin;
import kd.epm.eb.spread.utils.DimPropertyHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CustomPropertySetPlugin
extends MainSubAbstractFormPlugin {
    private static final String TREEVIEW = "treeviewap";
    private static final String ADD_PROPERTY = "addproperty";
    private static final String EDIT_PROPERTY = "editproperty";
    private static final String DEL_PROPERTY = "delproperty";
    private static final String MOVE_UP = "moveup";
    private static final String MOVE_DOWN = "movedown";
    private static final String ADD_VALUE = "addvalue";
    private static final String DEL_VALUE = "delvalue";
    private static final String REFRESH = "refresh";
    private static final String IMPORT = "import";
    private static final String EXPORT = "export";
    private static final String IMPORTPAGE = "importPage";
    private static final String DIMENSION = "dimensionId";
    private static final String MODEL = "model";
    private static final String ADD_PROPERTY_CLOSECALLBACK = "addPorpertycallback";
    private static final String FOCUSNODEID = "focusNodeId";
    private static final String PRE_FOCUSNODEID = "pre_focusNodeId";
    private static final String ENTRYENTITY = "entryentity";
    private static String[] vectorArr = new String[]{"addproperty", "editproperty", "delproperty", "movedown", "moveup"};
    private static String[] labelArr = new String[]{"refresh", "import", "export"};
    private static final Log log = LogFactory.getLog(CustomPropertySetPlugin.class);
    public static final int MAX_PROPERTY_SIZE = 15;

    public void initialize() {
        super.initialize();
        final TreeView tree = (TreeView)this.getView().getControl(TREEVIEW);
        tree.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                CustomPropertySetPlugin.this.treeOnClick(tree, true, true);
            }
        });
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{ADD_PROPERTY, EDIT_PROPERTY, DEL_PROPERTY, MOVE_UP, MOVE_DOWN, ADD_VALUE, DEL_VALUE, REFRESH, IMPORT, EXPORT});
    }

    public void afterCreateNewData(EventObject e) {
        Long dimensionId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam(DIMENSION));
        Long modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam(MODEL));
        if (IDUtils.isNull((Long)dimensionId) || IDUtils.isNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u6216\u7ef4\u5ea6\u4e0d\u5b58\u5728\uff0c\u8bf7\u8fd4\u56de\u540e\u91cd\u8bd5\u3002", (String)"CustomPropertySetPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(DIMENSION, dimensionId.toString());
        this.getPageCache().put(MODEL, modelId.toString());
        this.initTree(null);
    }

    protected void treeOnClick(TreeView tree, boolean isNeedCheck, boolean isNeedRefresh) {
        String nodeId = tree.getTreeState().getFocusNodeId();
        if (nodeId == null) {
            return;
        }
        if (isNeedCheck) {
            this.beforeChangeProperty(nodeId);
        } else {
            if (isNeedRefresh) {
                this.refreshEntry(nodeId);
            }
            this.getPageCache().put(PRE_FOCUSNODEID, this.getPageCache().get(FOCUSNODEID));
            this.getPageCache().put(FOCUSNODEID, nodeId);
        }
    }

    private void refreshEntry(String propertyId) {
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData(ENTRYENTITY);
        if (StringUtils.isEmpty((String)propertyId)) {
            return;
        }
        DynamicObjectCollection dynamicObjects = DimensionPropertyServiceHelper.getInstance().queryDimensionPropertyValuie(Long.valueOf(Long.parseLong(propertyId)), "id,number,name");
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            dataModel.batchCreateNewEntryRow(ENTRYENTITY, dynamicObjects.size());
            for (int i = 0; i < dynamicObjects.size(); ++i) {
                dataModel.setValue("number", (Object)((DynamicObject)dynamicObjects.get(i)).getString("number"), i);
                dataModel.setValue("name", (Object)((DynamicObject)dynamicObjects.get(i)).getString("name"), i);
                dataModel.setValue("property", (Object)((DynamicObject)dynamicObjects.get(i)).getString("id"), i);
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"number"});
            }
        }
    }

    private void initTree(String nodeId) {
        TreeNode root = this.createRootNode();
        DynamicObjectCollection properties = DimensionPropertyServiceHelper.getInstance().queryDimensionPropertys(this.getModelId(), Long.valueOf(this.getDimensionId()), "id,number,name");
        TreeNode tree = this.createTree(root, properties);
        this.cacheTree(tree);
        TreeView treeView = (TreeView)this.getControl(TREEVIEW);
        treeView.deleteAllNodes();
        treeView.addNode(tree);
        treeView.expand("0");
        if (StringUtils.isEmpty((String)nodeId)) {
            if (root.getChildren() != null && root.getChildren().size() > 0) {
                treeView.focusNode((TreeNode)root.getChildren().get(0));
            } else {
                treeView.focusNode(root);
            }
        } else {
            TreeNode node = tree.getTreeNode(nodeId, 5);
            treeView.focusNode(node);
        }
        this.treeOnClick(treeView, false, true);
    }

    private void cacheTree(TreeNode tree) {
        this.getPageCache().put("tree", SerializationUtils.serializeToBase64((Object)tree));
    }

    private TreeNode getCacheTree() {
        if (this.getPageCache().get("tree") != null) {
            TreeNode tree = (TreeNode)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("tree"));
            return tree;
        }
        return null;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        TreeView tree = (TreeView)this.getControl(TREEVIEW);
        String nodeId = tree.getTreeState().getFocusNodeId();
        switch (key) {
            case "addproperty": {
                DynamicObjectCollection dynamicObjects = DimensionPropertyServiceHelper.getInstance().queryDimensionPropertys(this.getModelId(), Long.valueOf(this.getDimensionId()), "id");
                if (dynamicObjects != null && dynamicObjects.size() >= 15) {
                    this.initTree(null);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u5141\u8bb8\u65b0\u589e15\u4e2a\u81ea\u5b9a\u4e49\u5c5e\u6027\u3002", (String)"CustomPropertySetPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.openPropertyPage(null, ADD_PROPERTY);
                break;
            }
            case "editproperty": {
                this.openPropertyPage(nodeId, EDIT_PROPERTY);
                break;
            }
            case "delproperty": {
                if (StringUtils.isEmpty((String)nodeId) || StringUtils.equals((String)"0", (String)nodeId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u81ea\u5b9a\u4e49\u5c5e\u6027\u3002", (String)"CustomPropertySetPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                String msg = this.beforedelProperty(nodeId);
                if (StringUtils.isNotEmpty((String)msg)) {
                    this.getView().showTipNotification(msg);
                    return;
                }
                msg = DimPropertyHelper.beforeDelPropertyByQuoteTemplate((String)nodeId);
                if (StringUtils.isNotEmpty((String)msg)) {
                    this.getView().showTipNotification(msg);
                    return;
                }
                QuoteCheckResult quoteCheckResult = MemberQuote.get().checkQuoteResult(new CheckQuote(this.getModelId(), Long.valueOf(0L), (Set)Sets.newHashSet((Object[])new Long[]{IDUtils.toLong((Object)nodeId)}), MemberTypeEnum.ATTRIBUTE));
                if (quoteCheckResult.isHasQuote()) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5c5e\u6027\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u53ef\u5220\u9664", (String)"CustomPropertySetPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]), quoteCheckResult.getMsg(), MessageTypes.Default);
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u6240\u9009\u81ea\u5b9a\u4e49\u5c5e\u6027\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"CustomPropertySetPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_property", (IFormPlugin)this));
                break;
            }
            case "moveup": {
                this.moveUp(nodeId);
                this.updateMainSubSign();
                break;
            }
            case "movedown": {
                this.moveDown(nodeId);
                this.updateMainSubSign();
                break;
            }
            case "addvalue": {
                if (StringUtils.isEmpty((String)nodeId) || "0".equals(nodeId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u81ea\u5b9a\u4e49\u5c5e\u6027\u3002", (String)"CustomPropertySetPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getModel().createNewEntryRow(ENTRYENTITY);
                break;
            }
            case "delvalue": {
                this.beforeDelete();
                break;
            }
            case "refresh": {
                this.refreshEntry(nodeId);
                break;
            }
            case "import": {
                this.openImportPage();
                break;
            }
            case "export": {
                this.exportData();
                break;
            }
        }
    }

    private void moveUp(String id) {
        if (StringUtils.isEmpty((String)id) || StringUtils.equals((String)"0", (String)id)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u81ea\u5b9a\u4e49\u5c5e\u6027\u3002", (String)"CustomPropertySetPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String memberformkey = "eb_customproperty";
        DynamicObject pro1 = BusinessDataServiceHelper.newDynamicObject((String)memberformkey);
        pro1 = BusinessDataReader.loadSingle((Object)id, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)pro1.getDynamicObjectType().getName()));
        int seq = this.getDseq(Long.parseLong(id), memberformkey);
        if (seq == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u81ea\u5b9a\u4e49\u5c5e\u6027\u4f4d\u7f6e\u5df2\u7ecf\u662f\u7b2c\u4e00\u884c\u3002", (String)"CustomPropertySetPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qf1 = new QFilter("dseq", "<", (Object)pro1.getInt("dseq"));
        QFilter qf2 = new QFilter("dimension", "=", (Object)this.getDimensionId());
        QFilter[] filters = new QFilter[]{qf1, qf2};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)memberformkey, (String)"id,dseq", (QFilter[])filters, (String)"dseq desc", (int)1);
        if (seq != 0) {
            if (dcs != null && dcs.size() > 0) {
                DynamicObject pro2 = BusinessDataReader.loadSingle((Object)((DynamicObject)dcs.get(0)).get("id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)pro1.getDynamicObjectType().getName()));
                int selectseq = pro1.getInt("dseq");
                int movedseq = pro2.getInt("dseq");
                pro2.set("dseq", (Object)selectseq);
                pro1.set("dseq", (Object)movedseq);
                Object[] objs = new Object[]{pro1, pro2};
                try {
                    SaveServiceHelper.save((IDataEntityType)pro1.getDataEntityType(), (Object[])objs);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.initTree(id);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u81ea\u5b9a\u4e49\u5c5e\u6027\u4f4d\u7f6e\u5df2\u7ecf\u662f\u7b2c\u4e00\u884c\u3002", (String)"CustomPropertySetPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    private void moveDown(String id) {
        int maxseq;
        if (StringUtils.isEmpty((String)id) || StringUtils.equals((String)"0", (String)id)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u81ea\u5b9a\u4e49\u5c5e\u6027\u3002", (String)"CustomPropertySetPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String memberformkey = "eb_customproperty";
        DynamicObject pro1 = BusinessDataServiceHelper.newDynamicObject((String)memberformkey);
        pro1 = BusinessDataReader.loadSingle((Object)id, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)pro1.getDynamicObjectType().getName()));
        int seq = this.getDseq(Long.parseLong(id), memberformkey);
        if (seq == (maxseq = this.getMaxDSeq())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u81ea\u5b9a\u4e49\u5c5e\u6027\u4f4d\u7f6e\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u884c\u3002", (String)"CustomPropertySetPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qf1 = new QFilter("dseq", ">", (Object)pro1.getInt("dseq"));
        QFilter qf2 = new QFilter("dimension", "=", (Object)this.getDimensionId());
        QFilter[] filters = new QFilter[]{qf2, qf1};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)memberformkey, (String)"id,dseq", (QFilter[])filters, (String)"dseq", (int)1);
        if (dcs != null && dcs.size() > 0) {
            DynamicObject pro2 = BusinessDataReader.loadSingle((Object)((DynamicObject)dcs.get(0)).get("id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)pro1.getDynamicObjectType().getName()));
            int selectseq = pro1.getInt("dseq");
            int movedseq = pro2.getInt("dseq");
            pro2.set("dseq", (Object)selectseq);
            pro1.set("dseq", (Object)movedseq);
            Object[] objs = new Object[]{pro1, pro2};
            try {
                SaveServiceHelper.save((IDataEntityType)pro1.getDataEntityType(), (Object[])objs);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u81ea\u5b9a\u4e49\u5c5e\u6027\u4f4d\u7f6e\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u884c\u3002", (String)"CustomPropertySetPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.initTree(id);
    }

    public int getMaxDSeq() {
        QFilter fdimenId = new QFilter("dimension", "=", (Object)this.getDimensionId());
        QFilter[] filters = new QFilter[]{fdimenId};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)"eb_customproperty", (String)"dseq", (QFilter[])filters, (String)"dseq desc");
        if (dcs != null) {
            if (dcs.size() == 0) {
                return 0;
            }
            return ((DynamicObject)dcs.get(0)).getInt("dseq");
        }
        return 0;
    }

    private int getDseq(long id, String entityId) {
        QFilter propertyQf = new QFilter("id", "=", (Object)id);
        QFilter[] filters = new QFilter[]{propertyQf};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)entityId, (String)"dseq", (QFilter[])filters, (String)"dseq");
        if (dcs != null && dcs.size() == 1) {
            return ((DynamicObject)dcs.get(0)).getInt("dseq");
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteProperty(String nodeId) {
        String msg = DimPropertyHelper.beforeDelPropertyByQuoteTemplate((String)nodeId);
        if (StringUtils.isNotEmpty((String)msg)) {
            this.getView().showTipNotification(msg);
            return;
        }
        try {
            DimensionPropertyServiceHelper.getInstance().deleteProperty(new Object[]{nodeId});
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664\u81ea\u5b9a\u4e49\u5c5e\u6027", "CustomPropertySetPlugin_41", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u81ea\u5b9a\u4e49\u5c5e\u6027\u5220\u9664\u6210\u529f\u3002", "CustomPropertySetPlugin_42", "epm-eb-formplugin");
            this.writeLog("delete", opName, opDesc);
            this.initTree(null);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"CustomPropertySetPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"delete-customProperty", (Throwable)ex);
        }
        finally {
            MemberPropCacheService.updateVersion((Long)this.getModelId(), (Long)this.getDimensionId());
        }
    }

    private String beforedelProperty(String nodeId) {
        String msg = "";
        boolean isExist = DimensionPropertyServiceHelper.getInstance().checkPropertyExistValue(Long.valueOf(Long.parseLong(nodeId)));
        if (isExist) {
            msg = ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u81ea\u5b9a\u4e49\u5c5e\u6027\u542b\u6709\u5c5e\u6027\u503c\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"CustomPropertySetPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return msg;
    }

    private void beforeDelete() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] rows = entryGrid.getSelectRows();
        if (rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u884c\u6570\u636e\u3002", (String)"CustomPropertySetPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean flag = true;
        HashSet<Long> cusPropertiesIds = new HashSet<Long>(rows.length);
        for (int row : rows) {
            DynamicObject rowData = this.getModel().getEntryRowEntity(ENTRYENTITY, row);
            if (rowData == null || rowData.get("property") == null) continue;
            cusPropertiesIds.add(rowData.getDynamicObject("property").getLong("id"));
            flag = false;
        }
        if (flag) {
            this.getModel().deleteEntryRows(ENTRYENTITY, rows);
        } else {
            String checkRefMsg = CustomPropertyUtils.checkRefCustomPropertyValue(cusPropertiesIds);
            QuoteCheckResult quoteCheckResult = MemberQuote.get().checkQuoteResult(new CheckQuote(this.getModelId(), Long.valueOf(0L), cusPropertiesIds, MemberTypeEnum.ATTRIBUTEVALUE));
            if (!quoteCheckResult.isHasQuote()) {
                long dimensionId = IDUtils.toLong((Object)this.getPageCache().get(DIMENSION));
                quoteCheckResult = MemberQuote.get().checkQuoteResult(new CheckQuote(this.getModelId(), Long.valueOf(dimensionId), cusPropertiesIds, MemberTypeEnum.ATTRIBUTEVALUE));
            }
            if (quoteCheckResult.isHasQuote()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5c5e\u6027\u503c\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u53ef\u5220\u9664", (String)"CustomPropertySetPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[0]), quoteCheckResult.getMsg(), MessageTypes.Default);
                return;
            }
            if (StringUtils.isNotEmpty((String)checkRefMsg)) {
                this.getView().showTipNotification(checkRefMsg);
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u6240\u9009\u5c5e\u6027\u503c\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"CustomPropertySetPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_propertyValue", (IFormPlugin)this));
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String msg;
        super.confirmCallBack(evt);
        String key = evt.getCallBackId();
        TreeView tree = (TreeView)this.getControl(TREEVIEW);
        String nodeId = tree.getTreeState().getFocusNodeId();
        TreeNode root = this.getCacheTree();
        if ("delete_propertyValue".equals(key) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.deleteEntryRow();
        } else if ("savePropertyValue".equals(key)) {
            if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
                nodeId = this.getPageCache().get(PRE_FOCUSNODEID);
                if (StringUtils.isEmpty((String)nodeId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5c5e\u6027\u4e0d\u5b58\u5728", (String)"CustomPropertySetPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                msg = this.checkBeforeSave();
                if (StringUtils.isNotEmpty((String)msg)) {
                    this.getView().showTipNotification(msg);
                    if (root != null) {
                        TreeNode node = root.getTreeNode(nodeId, 5);
                        tree.focusNode(node);
                    }
                    this.treeOnClick(tree, false, false);
                    return;
                }
                this.save(nodeId);
            } else {
                this.refreshEntry(nodeId);
                this.getPageCache().put(PRE_FOCUSNODEID, this.getPageCache().get(FOCUSNODEID));
                this.getPageCache().put(FOCUSNODEID, nodeId);
            }
        } else if ("savePropertyValBfeClick".equals(key)) {
            String clickSign = this.getPageCache().get("clickSign");
            if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
                if (nodeId == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5c5e\u6027\u503c\u5bf9\u5e94\u7684\u5c5e\u6027\u4e0d\u5b58\u5728\u3002", (String)"CustomPropertySetPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                String msg2 = this.checkBeforeSave();
                if (StringUtils.isNotEmpty((String)msg2)) {
                    this.getView().showTipNotification(msg2);
                    return;
                }
                this.save(nodeId);
            } else if (StringUtils.isNotEmpty((String)clickSign)) {
                this.invokeClickByNumber(clickSign);
            }
        } else if ("delete_property".equals(key) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.deleteProperty(nodeId);
        } else if ("saveBeforeClose".equals(key)) {
            if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
                if (nodeId == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5c5e\u6027\u503c\u5bf9\u5e94\u7684\u5c5e\u6027\u4e0d\u5b58\u5728\u3002", (String)"CustomPropertySetPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                msg = this.checkBeforeSave();
                if (StringUtils.isNotEmpty((String)msg)) {
                    this.getView().showTipNotification(msg);
                    return;
                }
                this.save(nodeId);
            }
            this.getPageCache().put("close", "true");
            this.getView().close();
        }
        HashSet sets = Sets.newHashSet((Object[])new String[]{"delete_propertyValue", "savePropertyValue", "savePropertyValBfeClick", "delete_property", "saveBeforeClose"});
        if (sets.contains(key) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.updateMainSubSign();
        }
    }

    private void updateMainSubSign() {
        Long memberId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("memberId"));
        String dataMeta = (String)this.getView().getFormShowParameter().getCustomParam("dataMeta");
        String membernumber = (String)this.getView().getFormShowParameter().getCustomParam("membernumber");
        if (memberId != 0L && StringUtils.isNotEmpty((String)dataMeta) && StringUtils.isNotEmpty((String)membernumber)) {
            Long modelId = this.getModelId();
            BgmdMainSubControlHelper instance = BgmdMainSubControlHelper.getInstance();
            Set allSubIds = instance.getAllSubIds(modelId);
            if (CollectionUtils.isNotEmpty((Collection)allSubIds)) {
                QFilter qFilter = new QFilter("number", "=", (Object)membernumber);
                qFilter.and(MODEL, "in", (Object)allSubIds);
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)dataMeta, (String)"id", (QFilter[])qFilter.toArray());
                if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
                    HashSet ids = new HashSet(16);
                    dynamicObjects.forEach(e -> ids.add(e.getLong("id")));
                    instance.updateSubSign(dataMeta, "3", ids);
                }
            }
        }
    }

    private void invokeClickByNumber(String apNumber) {
        Button btn = (Button)this.getControl(apNumber);
        btn.addClickListener((ClickListener)this);
        btn.click();
    }

    private void deleteEntryRow() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] rows = entryGrid.getSelectRows();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (int row : rows) {
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(ENTRYENTITY, row);
            if (dynamicObject == null || dynamicObject.get("property") == null) continue;
            ids.add(dynamicObject.getLong("property.id"));
        }
        try (TXHandle txHandle = TX.required((String)"delPropVals");){
            try {
                DynamicObjectCollection propertyValueList = QueryServiceHelper.query((String)"eb_custompropertyvalue", (String)"number, property.number", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                LinkedHashMap<String, Set> propertyIdAndValueNumbersMap = new LinkedHashMap<String, Set>(16);
                for (DynamicObject dynamicObject : propertyValueList) {
                    Set strings = propertyIdAndValueNumbersMap.computeIfAbsent(dynamicObject.getString("property.number"), t -> new HashSet(16));
                    strings.add(dynamicObject.getString("number"));
                }
                Set allSubIds = BgmdMainSubControlHelper.getInstance().getAllSubIds(this.getModelId());
                for (Map.Entry entry : propertyIdAndValueNumbersMap.entrySet()) {
                    QFilter qFilter = new QFilter("property.model", "in", (Object)allSubIds);
                    qFilter.and("property.number", "=", entry.getKey());
                    qFilter.and("number", "in", entry.getValue());
                    DynamicObjectCollection subModelPropertyValueIds = QueryServiceHelper.query((String)"eb_custompropertyvalue", (String)"id", (QFilter[])qFilter.toArray());
                    HashSet<Long> subPropertyValueIds = new HashSet<Long>(16);
                    for (DynamicObject subModelPropertyValueId : subModelPropertyValueIds) {
                        subPropertyValueIds.add(subModelPropertyValueId.getLong("id"));
                    }
                    if (!CollectionUtils.isNotEmpty(subPropertyValueIds)) continue;
                    BgmdMainSubControlHelper.getInstance().updateSubSign("eb_custompropertyvalue", "2", subPropertyValueIds);
                }
                DeleteServiceHelper.delete((String)"eb_custompropertyvalue", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                MembPermRecordUtil.dealPermRecordAndVerByPropValIds((Long)this.getModelId(), (Long)this.getDimensionId(), ids);
                TemplatePermServiceHelper.deletePropertyAllocateRecord(ids);
                this.getModel().deleteEntryRows(ENTRYENTITY, rows);
            }
            catch (Exception e) {
                txHandle.markRollback();
                log.error((Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("btnconfirm".equals(key)) {
            TreeView tree = (TreeView)this.getControl(TREEVIEW);
            String nodeId = tree.getTreeState().getFocusNodeId();
            if (nodeId == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5c5e\u6027\u503c\u5bf9\u5e94\u7684\u5c5e\u6027\u4e0d\u5b58\u5728\u3002", (String)"CustomPropertySetPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            String msg = this.checkBeforeSave();
            if (StringUtils.isNotEmpty((String)msg)) {
                this.getView().showTipNotification(msg);
                return;
            }
            this.save(nodeId);
            this.updateMainSubSign();
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58\u81ea\u5b9a\u4e49\u5c5e\u6027\u503c", "CustomPropertySetPlugin_35", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u81ea\u5b9a\u4e49\u5c5e\u6027\u503c\u4fdd\u5b58\u6210\u529f\u3002", "CustomPropertySetPlugin_36", "epm-eb-formplugin");
            this.writeLog("save", opName, opDesc);
            this.getView().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(String nodeId) {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(ENTRYENTITY);
        HashMap<Long, Integer> existIds = new HashMap<Long, Integer>();
        ArrayList<Integer> addRows = new ArrayList<Integer>();
        for (DynamicObject entry : entrys) {
            if (entry.get("property") != null && StringUtils.isNotEmpty((String)entry.getString("property.id"))) {
                existIds.put(entry.getLong("property.id"), entry.getInt("seq") - 1);
                continue;
            }
            addRows.add(entry.getInt("seq") - 1);
        }
        ArrayList<DynamicObject> saves = new ArrayList<DynamicObject>(16);
        DynamicObject[] exists = BusinessDataServiceHelper.load((Object[])existIds.keySet().toArray(new Long[0]), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"eb_custompropertyvalue").getDynamicObjectType());
        for (DynamicObject exist : exists) {
            DynamicObject dynamicObject;
            Long existId = exist.getLong("id");
            Integer seq = (Integer)existIds.get(existId);
            if (seq == null || (dynamicObject = this.getModel().getEntryRowEntity(ENTRYENTITY, seq.intValue())) == null) continue;
            exist.set("number", (Object)dynamicObject.getString("number"));
            exist.set("name", (Object)dynamicObject.getString("name"));
            exist.set("modifier", (Object)UserUtils.getUserId());
            exist.set("modifydate", (Object)TimeServiceHelper.now());
            exist.set("dseq", (Object)((Integer)existIds.get(existId) + 1));
            saves.add(exist);
        }
        for (Integer addRow : addRows) {
            DynamicObject newProperty = BusinessDataServiceHelper.newDynamicObject((String)"eb_custompropertyvalue");
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(ENTRYENTITY, addRow.intValue());
            if (dynamicObject == null || StringUtils.isEmpty((String)dynamicObject.getString("number")) || StringUtils.isEmpty((String)dynamicObject.getString("name"))) continue;
            newProperty.set("number", (Object)dynamicObject.getString("number"));
            newProperty.set("name", (Object)dynamicObject.getString("name"));
            newProperty.set("source", (Object)"0");
            newProperty.set("property", (Object)nodeId);
            newProperty.set("creater", (Object)UserUtils.getUserId());
            newProperty.set("modifier", (Object)UserUtils.getUserId());
            newProperty.set("createdate", (Object)TimeServiceHelper.now());
            newProperty.set("modifydate", (Object)TimeServiceHelper.now());
            newProperty.set("dseq", (Object)(addRow + 1));
            saves.add(newProperty);
        }
        try {
            SaveServiceHelper.save((DynamicObject[])saves.toArray(new DynamicObject[0]));
        }
        catch (Exception modelId) {
        }
        finally {
            Long modelId = this.getModelId();
            Long dimensionId = this.getDimensionId();
            if (IDUtils.isNotNull((Long)dimensionId)) {
                MemberPropCacheService.updateVersion((Long)modelId, (Long)dimensionId);
            } else {
                MemberPropCacheService.updateVersion((Long)modelId, Collections.singletonList(Long.parseLong(nodeId)));
            }
            EventBusUtil.asyncPost((Object)new PropValueChangeEvent(modelId));
        }
        this.initTree(nodeId);
    }

    @Override
    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (Arrays.asList(vectorArr).contains(key) || Arrays.asList(labelArr).contains(key)) {
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRYENTITY);
            if (dynamicObjects == null || dynamicObjects.size() == 0) {
                return;
            }
            boolean flag = this.check(dynamicObjects);
            if (flag) {
                if (this.getPageCache().get("clickSign") != null) {
                    this.getPageCache().remove("clickSign");
                } else {
                    evt.setCancel(true);
                    this.getPageCache().put("clickSign", key);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u6709\u4fee\u6539\u5c5e\u6027\u503c\uff0c\u662f\u5426\u4fdd\u5b58\u3002", (String)"CustomPropertySetPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("savePropertyValBfeClick", (IFormPlugin)this));
                }
            }
        }
    }

    private void beforeChangeProperty(String nodeId) {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRYENTITY);
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            this.refreshEntry(nodeId);
            this.getPageCache().put(PRE_FOCUSNODEID, this.getPageCache().get(FOCUSNODEID));
            this.getPageCache().put(FOCUSNODEID, nodeId);
            return;
        }
        boolean flag = this.check(dynamicObjects);
        this.getPageCache().put(PRE_FOCUSNODEID, this.getPageCache().get(FOCUSNODEID));
        this.getPageCache().put(FOCUSNODEID, nodeId);
        if (flag) {
            this.getPageCache().put("treeOnClick", "1");
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u6709\u4fee\u6539\u5c5e\u6027\u503c\uff0c\u662f\u5426\u4fdd\u5b58\u3002", (String)"CustomPropertySetPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("savePropertyValue", (IFormPlugin)this));
        } else {
            this.refreshEntry(nodeId);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String close = this.getPageCache().get("close");
        if (StringUtils.isNotEmpty((String)close)) {
            return;
        }
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRYENTITY);
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            return;
        }
        boolean flag = this.check(dynamicObjects);
        if (flag) {
            e.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u6709\u4fee\u6539\u5c5e\u6027\u503c\uff0c\u662f\u5426\u4fdd\u5b58\u3002", (String)"CustomPropertySetPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("saveBeforeClose", (IFormPlugin)this));
        }
    }

    private boolean check(DynamicObjectCollection dynamicObjects) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (StringUtils.isEmpty((String)dynamicObject.getString("property.id"))) {
                return true;
            }
            String number = dynamicObject.getString("number");
            String numberOld = dynamicObject.getString("property.number");
            String name = dynamicObject.getString("name");
            String nameOld = dynamicObject.getString("property.name");
            if (nameOld.equals(name) && numberOld.equals(number)) continue;
            return true;
        }
        return false;
    }

    private String checkBeforeSave() {
        if (StringUtils.isNotEmpty((String)String.valueOf(this.getPageCache().get("treeOnClick")))) {
            try {
                this.canDoOperation("btnconfirm");
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        HashMap<String, Integer> map1 = new HashMap<String, Integer>();
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRYENTITY);
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            return "";
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (StringUtils.isNotEmpty((String)dynamicObject.getString("number"))) {
                if (!CheckStringsUtil.checkAllowNumStartForCustonProperty((String)dynamicObject.getString("number"))) {
                    return ResManager.loadKDString((String)"\u5c5e\u6027\u503c\u7f16\u7801\u53ea\u80fd\u5305\u542b\u534a\u89d2\u6570\u5b57\u548c\u534a\u89d2\u5b57\u6bcd\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"CustomPropertySetPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
                if (StringUtils.isNotEmpty((String)dynamicObject.getString("name"))) {
                    if (map.containsKey(dynamicObject.getString("number"))) {
                        int row1 = (Integer)map.get(dynamicObject.getString("number"));
                        int row2 = dynamicObject.getInt("seq");
                        return ResManager.loadResFormat((String)"\u7b2c%1\u884c\u4e0e%2\u884c\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"CustomPropertySetPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[]{row1, row2});
                    }
                    if (map1.containsKey(dynamicObject.getString("name"))) {
                        int row1 = (Integer)map1.get(dynamicObject.getString("name"));
                        int row2 = dynamicObject.getInt("seq");
                        return ResManager.loadResFormat((String)"\u7b2c%1\u884c\u4e0e%2\u884c\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"CustomPropertySetPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[]{row1, row2});
                    }
                    map.put(dynamicObject.getString("number"), dynamicObject.getInt("seq"));
                    map1.put(dynamicObject.getString("name"), dynamicObject.getInt("seq"));
                    continue;
                }
                return ResManager.loadResFormat((String)"\u8bf7\u586b\u5199\u7b2c%1\u884c\u540d\u79f0\u3002", (String)"CustomPropertySetPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[]{dynamicObject.getInt("seq")});
            }
            return ResManager.loadResFormat((String)"\u8bf7\u586b\u5199\u7b2c%1\u884c\u7f16\u7801\u3002", (String)"CustomPropertySetPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[]{dynamicObject.getInt("seq")});
        }
        return "";
    }

    private void openPropertyPage(String id, String keyNum) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("eb_customproperty");
        showParameter.setCustomParam(MODEL, (Object)this.getPageCache().get(MODEL));
        showParameter.setCustomParam(DIMENSION, (Object)this.getPageCache().get(DIMENSION));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ADD_PROPERTY_CLOSECALLBACK);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(true);
        if (keyNum.equals(ADD_PROPERTY)) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u81ea\u5b9a\u4e49\u5c5e\u6027", (String)"CustomPropertySetPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            showParameter.setStatus(OperationStatus.ADDNEW);
        } else {
            if (keyNum.equals(EDIT_PROPERTY) && (StringUtils.isEmpty((String)id) || StringUtils.equals((String)"0", (String)id))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4fee\u6539\u9879", (String)"CustomPropertySetPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            showParameter.setPkId((Object)id);
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setCustomParam("id", (Object)id);
            showParameter.setCaption(ResManager.loadKDString((String)"\u4fee\u6539\u81ea\u5b9a\u4e49\u5c5e\u6027", (String)"CustomPropertySetPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        Object backData = closedCallBackEvent.getReturnData();
        if (backData != null && ADD_PROPERTY_CLOSECALLBACK.equals(key)) {
            String newId = String.valueOf(backData);
            this.updateMainSubSign();
            this.initTree(newId);
        }
        if ((backData != null || StringUtils.isNotEmpty((String)this.getPageCache().get("importUpdate"))) && IMPORTPAGE.equals(key)) {
            this.updateMainSubSign();
            this.initTree(null);
        }
    }

    private TreeNode createRootNode() {
        TreeNode root = new TreeNode();
        root.setId("0");
        root.setParentid("");
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"CustomPropertySetPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return root;
    }

    private TreeNode createTree(TreeNode root, DynamicObjectCollection properties) {
        ArrayList<TreeNode> childs = new ArrayList<TreeNode>();
        for (DynamicObject property : properties) {
            TreeNode node = new TreeNode();
            node.setId(property.getString("id"));
            node.setParentid("0");
            node.setText(property.getString("name"));
            node.setData((Object)property);
            childs.add(node);
        }
        root.setChildren(childs);
        return root;
    }

    @Override
    public Long getModelId() {
        String modelId = this.getPageCache().get(MODEL);
        if (StringUtils.isEmpty((String)modelId)) {
            return 0L;
        }
        return Long.valueOf(modelId);
    }

    private long getDimensionId() {
        String dimensionId = this.getPageCache().get(DIMENSION);
        if (StringUtils.isEmpty((String)dimensionId)) {
            return 0L;
        }
        return Long.parseLong(dimensionId);
    }

    private void openImportPage() {
        this.getPageCache().remove("importUpdate");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epm_import");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam(MODEL, (Object)this.getModelId());
        showParameter.setCustomParam(DIMENSION, (Object)this.getDimensionId());
        showParameter.setCaption(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5c5e\u6027 - \u5bfc\u5165", (String)"CustomPropertySetPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)"epm_import");
        showParameter.setFormConfig(formConfig);
        showParameter.addCustPlugin("kd.epm.eb.formplugin.importplugin.CustomPropertyImport");
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, IMPORTPAGE);
        showParameter.setCloseCallBack(callBack);
        this.getView().showForm(showParameter);
    }

    private void exportData() {
        List<CustomEntity> structOfMember = this.getStructOfMember();
        if (structOfMember.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ef4\u5ea6\u65e0\u81ea\u5b9a\u4e49\u5c5e\u6027\u3002", (String)"CustomPropertySetPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            XSSFWorkbook excelBook = new XSSFWorkbook();
            FileImportUtils fileImportUtils = new FileImportUtils();
            int ll = 3;
            ArrayList header = Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"*\u5c5e\u6027\u7f16\u7801", (String)"CustomPropertySetPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"*\u5c5e\u6027\u540d\u79f0", (String)"CustomPropertySetPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"*\u5c5e\u6027\u503c\u7f16\u7801", (String)"CustomPropertySetPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"*\u5c5e\u6027\u503c\u540d\u79f0", (String)"CustomPropertySetPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0])});
            XSSFSheet billSheet = excelBook.createSheet(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5c5e\u6027", (String)"CustomPropertySetPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            XSSFCellStyle cellStyle = excelBook.createCellStyle();
            XSSFRow title = billSheet.createRow(0);
            XSSFCell cell = title.createCell(0);
            this.setCellValue(cell, ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5c5e\u6027\u5bfc\u51fa", (String)"CustomPropertySetPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            cellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.index);
            XSSFRow remarks = billSheet.createRow(1);
            XSSFCell xssfCell = remarks.createCell(0);
            this.setCellValue(xssfCell, ResManager.loadKDString((String)"\u7ea2\u8272*\u5fc5\u586b\u3002\u66f4\u65b0\u529f\u80fd\u4e0d\u53ef\u66f4\u65b0\u5c5e\u6027\u7f16\u7801\u3001\u5c5e\u6027\u540d\u79f0\u548c\u5c5e\u6027\u503c\u7f16\u7801\u3002\u53ea\u66f4\u65b0\u586b\u5199\u4e86\u6570\u636e\u7684\u5c5e\u6027\uff0c\u4e0d\u586b\u4e0d\u66f4\u65b0\u3002\u591a\u4e2a\u5c5e\u6027\u503c\u9700\u8981\u548c\u5c5e\u6027\u4e00\u4e00\u5bf9\u5e94", (String)"CustomPropertySetPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            CellStyle cellstyle = fileImportUtils.createCellstyle((Cell)xssfCell);
            Font xssfFont = fileImportUtils.createXSSFFont((Cell)xssfCell);
            fileImportUtils.setFontColor(cellstyle, xssfFont, IndexedColors.RED);
            XSSFRow remark = billSheet.createRow(2);
            for (int i = 0; i < header.size(); ++i) {
                XSSFCell cell1 = remark.createCell(i);
                cell1.setCellStyle((CellStyle)cellStyle);
                this.setCellValue(cell1, (String)header.get(i));
                CellStyle cellstyle1 = fileImportUtils.createCellstyle((Cell)cell1);
                fileImportUtils.setBackgroundColor(cellstyle1, IndexedColors.GREY_25_PERCENT);
                Font xssfFont2 = fileImportUtils.createXSSFFont((Cell)cell1);
                fileImportUtils.setFontColor(cellstyle1, xssfFont2, IndexedColors.RED);
                billSheet.setColumnWidth(i, 3584);
            }
            for (CustomEntity customEntity : structOfMember) {
                List parent = customEntity.getParent();
                for (CustomEntity entity : parent) {
                    int cellNum = 0;
                    XSSFRow row = billSheet.createRow(ll++);
                    XSSFCell cell0 = row.createCell(cellNum++);
                    this.setCellValue(cell0, customEntity.getNumber());
                    XSSFCell cell1 = row.createCell(cellNum++);
                    this.setCellValue(cell1, customEntity.getName());
                    XSSFCell cell2 = row.createCell(cellNum++);
                    this.setCellValue(cell2, entity.getNumber());
                    XSSFCell cell3 = row.createCell(cellNum);
                    this.setCellValue(cell3, entity.getName());
                }
            }
            this.exportEntity(excelBook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportEntity(XSSFWorkbook excelBook) {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            try {
                excelBook.write((OutputStream)outStream);
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
            try {
                outStream.flush();
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5c5e\u6027.xlsx", (String)"CustomPropertySetPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]), (InputStream)inStream, 10000);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
        }
    }

    private void setCellValue(XSSFCell cell, String value) {
        cell.setCellType(CellType.STRING);
        cell.setCellValue(value);
    }

    private List<CustomEntity> getStructOfMember() {
        ArrayList<CustomEntity> customList = new ArrayList<CustomEntity>(16);
        DynamicObjectCollection query = this.selectCustomLeft();
        for (DynamicObject dynamicObject : query) {
            CustomEntity entity = this.setCustomEntity(dynamicObject);
            customList.add(entity);
        }
        for (CustomEntity entity : customList) {
            ArrayList<CustomEntity> parent = new ArrayList<CustomEntity>(16);
            DynamicObjectCollection objects = this.selectCustomFight(entity.getId());
            for (DynamicObject object : objects) {
                CustomEntity customEntity = this.setSeconEntity(object);
                parent.add(customEntity);
            }
            entity.setParent(parent);
        }
        return customList;
    }

    private DynamicObjectCollection selectCustomLeft() {
        QFilter qfModel = new QFilter(MODEL, "=", (Object)this.getModelId());
        QFilter qfDimension = new QFilter("dimension", "=", (Object)this.getDimensionId());
        return QueryServiceHelper.query((String)"eb_customproperty", (String)this.getSelectFieter(), (QFilter[])new QFilter[]{qfModel, qfDimension}, (String)"dseq");
    }

    private CustomEntity setCustomEntity(DynamicObject dynamicObject) {
        CustomEntity customEntity = new CustomEntity();
        customEntity.setId(Long.valueOf(dynamicObject.getLong("id")));
        customEntity.setNumber(dynamicObject.getString("number"));
        customEntity.setName(dynamicObject.getString("name"));
        customEntity.setSource(dynamicObject.getInt("source"));
        customEntity.setDseq(dynamicObject.getInt("dseq"));
        return customEntity;
    }

    private DynamicObjectCollection selectCustomFight(Long customId) {
        QFilter qfDimensionLefa = new QFilter("property", "=", (Object)customId);
        return QueryServiceHelper.query((String)"eb_custompropertyvalue", (String)this.getSelectFieterDseq(), (QFilter[])new QFilter[]{qfDimensionLefa});
    }

    private CustomEntity setSeconEntity(DynamicObject object) {
        CustomEntity customSeconEntity = new CustomEntity();
        customSeconEntity.setId(Long.valueOf(object.getLong("id")));
        customSeconEntity.setNumber(object.getString("number"));
        customSeconEntity.setName(object.getString("name"));
        customSeconEntity.setSource(object.getInt("source"));
        customSeconEntity.setProperty(Long.valueOf(object.getLong("property")));
        customSeconEntity.setDseq(object.getInt("dseq"));
        return customSeconEntity;
    }

    private String getSelectFieterDseq() {
        return "id,name,number,property,source,creater,modifier,createdate,modifydate,dseq";
    }

    private String getSelectFieter() {
        return "id,name,number,source,model,dimension,creater,modifier,createdate,modifydate,dseq";
    }
}

