/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.dimensionrelation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.dimension.dimensionrelation.DimensionRelationUtils;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.DimRelationScope;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.viewgroup.ViewGroupServiceHelper;
import kd.epm.eb.formplugin.AbstractListPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class DimensionRelationPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    private static final String BUSINESSMODEL = "businessmodel";
    private static final String DIMENSION = "dimension";
    private static final String DIMENSION_PROPERTY = "dimproperty";
    private static final String DIMENSION_VIEW = "dimviews";
    private static final String AFFECTRANGE = "affectrange";
    private static final String BTN_ADD = "btn_add";
    private static final String BTN_DEL = "btn_del";
    private static final String BTN_UP = "btn_up";
    private static final String BTN_DOWN = "btn_down";
    private static final String ENTRYENTITY = "entryentity";
    private static final int DIM_MAX_COUNT = 6;
    private static final int DIM_MIN_COUNT = 2;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, new String[]{BUSINESSMODEL, DIMENSION, DIMENSION_VIEW, DIMENSION_PROPERTY});
        this.addAfterF7SelectListener(this, new String[]{DIMENSION_VIEW});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("model", this.getView().getFormShowParameter().getCustomParam("modelId"));
        this.getView().setEnable(Boolean.valueOf(false), new String[]{AFFECTRANGE});
        this.setViewEnable();
        this.setBusinessModelVisible();
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{AFFECTRANGE});
        if (this.isModify().booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
            this.setBtnAddEnable();
            if (this.checkInUse().booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{BUSINESSMODEL, AFFECTRANGE, BTN_ADD, BTN_DEL, BTN_UP, BTN_DOWN});
                DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity(ENTRYENTITY);
                for (int i = 0; i < entryEntitys.size(); ++i) {
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{DIMENSION});
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{DIMENSION_VIEW});
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{DIMENSION_PROPERTY});
                }
            } else {
                this.setViewEnable();
            }
            this.setBusinessModelVisible();
        }
    }

    private Boolean checkInUse() {
        boolean isUse = false;
        Object object = this.getModel().getValue("id");
        Long id = IDUtils.toLong((Object)object);
        if (object != null) {
            isUse = QueryServiceHelper.exists((String)"epm_dimmemberrelation", (QFilter[])new QFilter[]{new QFilter("relationid", "=", (Object)id)});
        }
        if (!isUse) {
            QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
            qFilter.and(new QFilter("dimrelationinfo2.fbasedataid", "=", (Object)id));
            isUse = QueryServiceHelper.exists((String)"eb_templateentity", (QFilter[])qFilter.toArray());
        }
        return isUse;
    }

    private void setBusinessModelVisible() {
        boolean isVisible = false;
        Object range = this.getModel().getValue(AFFECTRANGE);
        if (range != null) {
            isVisible = DimRelationScope.BIZMODEL.getIndex().equals(range);
        }
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{BUSINESSMODEL});
    }

    private void setBusinessmodelEmpty() {
        this.getModel().setValue(BUSINESSMODEL, null);
    }

    private void clearEntryEntityData() {
        DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject entryEntity : entryEntitys) {
            entryEntity.set(DIMENSION, null);
            entryEntity.set(DIMENSION_VIEW, null);
            entryEntity.set(DIMENSION_PROPERTY, null);
        }
        this.getView().updateView(ENTRYENTITY);
    }

    private void setViewEnable() {
        DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity(ENTRYENTITY);
        for (int i = 0; i < entryEntitys.size(); ++i) {
            DynamicObject entity = (DynamicObject)entryEntitys.get(i);
            DynamicObject dimension = entity.getDynamicObject(DIMENSION);
            boolean viewEnable = false;
            boolean propertyEnable = false;
            if (dimension != null) {
                viewEnable = this.checkHasView(dimension);
                propertyEnable = this.checkHasProperty(dimension);
            }
            this.getView().setEnable(Boolean.valueOf(viewEnable), i, new String[]{DIMENSION_VIEW});
            this.getView().setEnable(Boolean.valueOf(propertyEnable), i, new String[]{DIMENSION_PROPERTY});
        }
    }

    private Boolean checkHasView(DynamicObject dimension) {
        String dimNumber = dimension.getString("number");
        return !View.NoViewDimNums.contains(dimNumber);
    }

    private Boolean checkHasProperty(DynamicObject dimension) {
        String dimNumber = dimension.getString("number");
        if (SysDimensionEnum.Entity.getNumber().equals(dimNumber) || !dimension.getBoolean("issysdimension")) {
            QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
            qFilter.and(new QFilter(DIMENSION, "=", (Object)dimension.getLong("id")));
            return QueryServiceHelper.exists((String)"eb_customproperty", (QFilter[])new QFilter[]{qFilter});
        }
        return false;
    }

    @Override
    public Long getModelId() {
        return ((DynamicObject)this.getModel().getValue("model")).getLong("id");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "affectrange": {
                this.setBusinessModelVisible();
                this.setBusinessmodelEmpty();
                this.clearEntryEntityData();
                this.setBtnAddEnable();
                break;
            }
            case "businessmodel": {
                this.clearEntryEntityData();
                break;
            }
            case "dimension": {
                this.afterSelectDimension(e);
                break;
            }
        }
    }

    private void afterSelectDimension(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet.length > 0) {
            int rowIndex = changeSet[0].getRowIndex();
            Object newValue = changeSet[0].getNewValue();
            if (newValue == null) {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{DIMENSION_PROPERTY, DIMENSION_VIEW});
            } else {
                DynamicObject dim = (DynamicObject)this.getModel().getValue(DIMENSION, rowIndex);
                if (dim != null) {
                    String dimNumber = dim.getString("number");
                    Boolean hasView = this.checkHasView(dim);
                    this.getView().setEnable(hasView, rowIndex, new String[]{DIMENSION_VIEW});
                    this.getModel().setValue(DIMENSION_VIEW, null, rowIndex);
                    if (hasView.booleanValue()) {
                        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
                        Object range = this.getModel().getValue(AFFECTRANGE);
                        if (DimRelationScope.BIZMODEL.getIndex().equals(range)) {
                            Set<Long> businessIds = this.getBusinessModelIds();
                            Long viewId = 0L;
                            for (Long businessId : businessIds) {
                                Map views = modelCache.getViewsByBusModelIncludeBase(businessId);
                                Long tempViewId = (Long)views.get(dimNumber);
                                if (viewId == 0L) {
                                    viewId = tempViewId;
                                    continue;
                                }
                                if (viewId.equals(tempViewId)) continue;
                                throw new KDBizException(ResManager.loadResFormat((String)"\u5f53\u524d\u9009\u62e9\u7684\u4e1a\u52a1\u6a21\u578b\u5728%1\u7ef4\u5ea6\u4e0d\u5b58\u5728\u5171\u540c\u7684\u7ef4\u5ea6\u89c6\u56fe\u3002", (String)"DimensionRelationPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[]{dim.getString("name")}));
                            }
                            this.getModel().setValue(DIMENSION_VIEW, (Object)viewId, rowIndex);
                        } else {
                            QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
                            qFilter.and(new QFilter(DIMENSION, "=", dim.getPkValue()));
                            qFilter.and(new QFilter("source", "=", (Object)"1"));
                            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_dimensionview", (String)"id", (QFilter[])qFilter.toArray());
                        }
                    }
                    this.getView().setEnable(this.checkHasProperty(dim), rowIndex, new String[]{DIMENSION_PROPERTY});
                    this.getModel().setValue(DIMENSION_PROPERTY, null, rowIndex);
                }
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            if (!this.validate()) {
                args.setCancel(true);
                return;
            }
            Object range = this.getModel().getValue(AFFECTRANGE);
            if (DimRelationScope.BIZMODEL.getIndex().equals(range)) {
                String end;
                String name = this.getModel().getValue("name").toString();
                if (!name.endsWith(end = "(*)")) {
                    name = name + end;
                }
                this.getModel().setValue("name", (Object)name);
            }
            if (!this.isModify().booleanValue()) {
                Object seqObj = this.getView().getFormShowParameter().getCustomParam("dseq");
                if (Objects.isNull(seqObj)) {
                    this.getModel().setValue("dseq", (Object)1);
                } else {
                    this.getModel().setValue("dseq", (Object)(Integer.parseInt(seqObj.toString()) + 1));
                }
                this.getModel().setValue("createtime", (Object)TimeServiceHelper.now());
                this.getModel().setValue("creator", (Object)UserUtils.getUserId());
            }
            this.getModel().setValue("modifytime", (Object)TimeServiceHelper.now());
            this.getModel().setValue("modifier", (Object)UserUtils.getUserId());
            this.getModel().setValue("version", (Object)DBServiceHelper.genGlobalLongId());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        this.setBtnAddEnable();
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.setBtnAddEnable();
    }

    private void setBtnAddEnable() {
        int limit;
        int rowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
        if (rowCount < (limit = DimRelationScope.BIZMODEL.getIndex().equals(this.getModel().getValue(AFFECTRANGE)) ? 2 : 6)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_ADD});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_ADD});
        }
    }

    private boolean validate() {
        Long id = (Long)this.getModel().getValue("id");
        Object number = this.getModel().getValue("number");
        Object name = this.getModel().getValue("name");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        if (entryEntity.size() < 2) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c112\u4e2a\u7ef4\u5ea6\u3002", (String)"DimensionRelationPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (DimRelationScope.BIZMODEL.getIndex().equals(this.getModel().getValue(AFFECTRANGE)) && entryEntity.size() > 2) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f71\u54cd\u8303\u56f4\u4e3a\u4e1a\u52a1\u6a21\u578b\u7684\u65b9\u6848\u53ea\u80fd\u9009\u62e9\u4e24\u4e2a\u7ef4\u5ea6\u3002", (String)"DimensionRelationPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (entryEntity.size() > 6) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u591a\u5141\u8bb8\u9009\u62e96\u4e2a\u7ef4\u5ea6\u3002", (String)"DimensionRelationPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean notAccount = false;
        MulBasedataDynamicObjectCollection businessCollection = (MulBasedataDynamicObjectCollection)this.getModel().getValue(BUSINESSMODEL);
        if (DimRelationScope.BIZMODEL.getIndex().equals(this.getModel().getValue(AFFECTRANGE)) && businessCollection.size() > 1) {
            notAccount = true;
        }
        for (DynamicObject dynamicObject : entryEntity) {
            DynamicObjectCollection dimViews;
            DynamicObject dimension = dynamicObject.getDynamicObject(DIMENSION);
            if (dimension == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5173\u8054\u7ef4\u5ea6\u3002", (String)"DimensionRelationPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (this.checkHasView(dimension).booleanValue() && CollectionUtils.isEmpty((Collection)(dimViews = dynamicObject.getDynamicObjectCollection(DIMENSION_VIEW)))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ef4\u5ea6\u89c6\u56fe\u3002", (String)"DimensionRelationPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (!notAccount || !StringUtils.equals((String)SysDimensionEnum.Account.getNumber(), (String)dimension.getString("number"))) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u62e9\u79d1\u76ee\u65f6\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528\u591a\u4e2a\u4e1a\u52a1\u6a21\u578b\u3002", (String)"DimensionRelationPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (Objects.nonNull(number)) {
            String num = number.toString();
            String numTrim = num.trim();
            if (this.checkNumberRepeat(num)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\u3002", (String)"DimensionRelationPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (!num.equals(numTrim)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u5141\u8bb8\u8f93\u5165\u7a7a\u683c\u3002", (String)"DimensionRelationPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (num.matches("[\u4e00-\u9fa5]+")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u5141\u8bb8\u8f93\u5165\u4e2d\u6587\u3002", (String)"DimensionRelationPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
            String tip = NumberCheckUtils.checkNumberRule((String)num);
            if (StringUtils.isNotEmpty((String)tip)) {
                this.getView().showErrorNotification(tip);
                return false;
            }
        }
        if (name == null || StringUtils.isEmpty((String)name.toString())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"DimensionRelationPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.checkNameRepeat(name.toString(), id)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"DimensionRelationPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean enable = (Boolean)this.getModel().getValue("enable");
        if (enable && DimRelationScope.BIZMODEL.getIndex().equals(this.getModel().getValue(AFFECTRANGE))) {
            Long modelId = this.getModelId();
            Set<Long> businessIds = this.getBusinessModelIds();
            if (businessIds.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"DimensionRelationPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
            for (Long businessId : businessIds) {
                List<DynamicObject> templates = this.getTemplates(modelId, businessId);
                if (templates != null && templates.size() > 0) {
                    for (DynamicObject template : templates) {
                        DynamicObjectCollection dimrelationinfos = template.getDynamicObjectCollection("dimrelationinfo2");
                        List<Long> dimRelations = dimrelationinfos.stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toList());
                        boolean dimPropertyNotSameType = this.isDimPropertyNotSameType(modelId, businessId, id, dimRelations);
                        if (dimPropertyNotSameType) {
                            this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u5df2\u9009\u591a\u4e2a\u7ef4\u5ea6\u5173\u7cfb\u4e2d\uff0c\u540c\u4e00\u4e2a\u7ef4\u5ea6\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u6309\u5c5e\u6027\u548c\u6309\u6210\u5458\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"DynamicTemplateEdit_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            return false;
                        }
                        boolean dimRepeat = this.isDimRepeat(modelId, businessId, id, dimRelations);
                        if (dimRepeat) {
                            this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u591a\u4e2a\u65b9\u6848\u95f4\u7ef4\u5ea6\u53ca\u7ef4\u5ea6\u89c6\u56fe\u4e0d\u5141\u8bb8\u51fa\u73b0\u4e24\u4e2a\u4ee5\u4e0a\u7684\u91cd\u590d\u3002", (String)"DynamicTemplateEdit_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            return false;
                        }
                        boolean circle = this.isCircle(modelId, businessId, id, dimRelations);
                        if (!circle) continue;
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65b0\u589e\u540e\u5c06\u5f62\u6210\u7ef4\u5ea6\u5faa\u73af\u4f9d\u8d56\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"DimensionRelationPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return false;
                    }
                    continue;
                }
                boolean dimPropertyNotSameType = this.isDimPropertyNotSameType(modelId, businessId, id, new ArrayList<Long>(10));
                if (dimPropertyNotSameType) {
                    this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u540c\u4e00\u7ef4\u5ea6\u4e0e\u7ef4\u5ea6\u89c6\u56fe\u7684\u7ec4\u5408\uff0c\u53ea\u652f\u6301\u4e00\u79cd\u8bbe\u7f6e\u65b9\u5f0f\uff0c\u8981\u4e48\u6309\u7ef4\u5ea6\u6210\u5458\u8bbe\u7f6e\uff0c\u8981\u4e48\u6309\u7ef4\u5ea6\u5c5e\u6027\u8bbe\u7f6e\u3002", (String)"DynamicTemplateEdit_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return false;
                }
                boolean dimRepeat = this.isDimRepeat(modelId, businessId, id, new ArrayList<Long>(10));
                if (dimRepeat) {
                    this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u591a\u4e2a\u65b9\u6848\u95f4\u7ef4\u5ea6\u53ca\u7ef4\u5ea6\u89c6\u56fe\u4e0d\u5141\u8bb8\u51fa\u73b0\u4e24\u4e2a\u4ee5\u4e0a\u7684\u91cd\u590d\u3002", (String)"DynamicTemplateEdit_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return false;
                }
                boolean circle = this.isCircle(modelId, businessId, id, new ArrayList<Long>(10));
                if (!circle) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65b0\u589e\u540e\u5c06\u5f62\u6210\u7ef4\u5ea6\u5faa\u73af\u4f9d\u8d56\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"DimensionRelationPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private List<DynamicObject> getTemplates(Long modelId, Long bizModelId) {
        String selectFields = "id,name,number,model,dataset,dataset.businessmodel,dimrelationinfo2";
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(new QFilter("dataset.businessmodel", "=", (Object)bizModelId));
        qFilter.and(new QFilter("isrelation", "=", (Object)"1"));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"eb_templateentity", (String)selectFields, (QFilter[])qFilter.toArray());
        return Arrays.stream(dynamicObjects).filter(e -> e.getDynamicObjectCollection("dimrelationinfo2").size() > 0).collect(Collectors.toList());
    }

    public boolean isDimPropertyNotSameType(Long modelId, Long bizModelId, Long newRelationId, List<Long> relationIds) {
        relationIds.add(newRelationId);
        return DimensionRelationUtils.isDimPropertyNotSameType((Long)modelId, (Long)bizModelId, relationIds);
    }

    public boolean isDimRepeat(Long modelId, Long bizModelId, Long newRelationId, List<Long> relationIds) {
        relationIds.add(newRelationId);
        return DimensionRelationUtils.isDimRepeat((Long)modelId, (Long)bizModelId, relationIds);
    }

    public boolean isCircle(Long modelId, Long bizModelId, Long newRelationId, List<Long> relationIds) {
        relationIds.add(newRelationId);
        return DimensionRelationUtils.isCircle((Long)modelId, (Long)bizModelId, relationIds);
    }

    private boolean checkNumberRepeat(String number) {
        if (!this.isModify().booleanValue()) {
            QFilter qf = new QFilter("model", "=", (Object)this.getModelId());
            qf.and(new QFilter("number", "=", (Object)number));
            return QueryServiceHelper.exists((String)"epm_dimensionrelation", (QFilter[])new QFilter[]{qf});
        }
        return false;
    }

    private boolean checkNameRepeat(String name, Long id) {
        QFilter qf = new QFilter("model", "=", (Object)this.getModelId());
        qf.and(new QFilter("id", "!=", (Object)id));
        qf.and(new QFilter("name", "=", (Object)name));
        return QueryServiceHelper.exists((String)"epm_dimensionrelation", (QFilter[])new QFilter[]{qf});
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key;
        switch (key = event.getProperty().getName()) {
            case "businessmodel": {
                this.businessModelBeforeF7(event);
                break;
            }
            case "dimension": {
                this.dimensionBeforeF7(event, key);
                break;
            }
            case "dimviews": 
            case "dimproperty": {
                this.beforeSelectViewOrProperty(event, key);
                break;
            }
        }
    }

    @Override
    public void afterF7Select(AfterF7SelectEvent event) {
        super.afterF7Select(event);
        String key = ((MulBasedataEdit)event.getSource()).getFieldKey();
        if (DIMENSION_VIEW.equals(key)) {
            Object[] viewIds = event.getListSelectedRowCollection().getPrimaryKeyValues();
            boolean sameGroupIdByViews = ViewGroupServiceHelper.getInstance().isSameGroupIdByViews(Arrays.stream(viewIds).map(IDUtils::toLong).collect(Collectors.toList()));
            if (!sameGroupIdByViews) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u540c\u89c6\u56fe\u5206\u7ec4\u4e0b\u7684\u89c6\u56fe\u3002", (String)"DimensionRelationPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private Set<Long> getBusinessModelIds() {
        MulBasedataDynamicObjectCollection businessCollection = (MulBasedataDynamicObjectCollection)this.getModel().getValue(BUSINESSMODEL);
        return businessCollection.stream().filter(e -> e.getDynamicObject("fbasedataid") != null).map(e -> e.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
    }

    private void dimensionBeforeF7(BeforeF7SelectEvent event, String key) {
        Object range = this.getModel().getValue(AFFECTRANGE);
        if (range == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f71\u54cd\u8303\u56f4\u3002", (String)"DimensionRelationPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        long modelId = this.getModelId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensionList = null;
        if (DimRelationScope.BIZMODEL.getIndex().equals(range)) {
            Set<Long> businessIds = this.getBusinessModelIds();
            if (businessIds.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"DimensionRelationPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            for (Long businessId : businessIds) {
                if (dimensionList == null) {
                    dimensionList = modelCache.getDimensionListByBusModel(businessId);
                    continue;
                }
                List list = modelCache.getDimensionListByBusModel(businessId);
                dimensionList = dimensionList.stream().filter(item -> list.contains(item)).collect(Collectors.toList());
            }
        } else {
            QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
            DynamicObjectCollection doc = QueryServiceHelper.query((String)"epm_dimension", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (doc == null || doc.size() == 0) {
                return;
            }
            dimensionList = modelCache.getDimensionList();
        }
        Set<Object> dimensionIds = new HashSet(16);
        if (dimensionList != null) {
            dimensionIds = dimensionList.stream().map(BaseCache::getId).collect(Collectors.toSet());
        }
        dimensionIds.removeAll(this.getExistDimensionSet());
        if (event.getFormShowParameter() instanceof ListShowParameter) {
            ArrayList<QFilter> qFilterList;
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            DynamicObject value = (DynamicObject)this.getModel().getValue(key);
            if (value != null) {
                Long pkValue = (Long)value.getPkValue();
                dimensionIds.add(pkValue);
                showParameter.setSelectedRow(value.getPkValue());
            }
            if ((qFilterList = ((BasedataEdit)this.getControl(key)).getQFilters()) == null) {
                qFilterList = new ArrayList<QFilter>(16);
            }
            qFilterList.add(new QFilter("id", "in", dimensionIds));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, "dseq"));
        }
    }

    private void businessModelBeforeF7(BeforeF7SelectEvent event) {
        if (event.getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(BUSINESSMODEL)).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>(16);
            }
            qFilterList.add(new QFilter("model", "=", (Object)this.getModelId()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    private void beforeSelectViewOrProperty(BeforeF7SelectEvent event, String key) {
        int row = event.getRow();
        DynamicObject dim = (DynamicObject)this.getModel().getValue(DIMENSION, row);
        if (dim == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"DimensionRelationPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        long modelId = this.getModelId();
        if (event.getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(key)).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>(16);
            }
            Object range = this.getModel().getValue(AFFECTRANGE);
            if (DimRelationScope.BIZMODEL.getIndex().equals(range) && DIMENSION_VIEW.equals(key)) {
                IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
                Set<Long> businessIds = this.getBusinessModelIds();
                if (businessIds.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"DimensionRelationPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    event.setCancel(true);
                    return;
                }
                Long viewId = 0L;
                for (Long businessId : businessIds) {
                    Map views = modelCache.getViewsByBusModelIncludeBase(businessId);
                    Long tempViewId = (Long)views.get(dim.getString("number"));
                    if (viewId == 0L) {
                        viewId = tempViewId;
                        continue;
                    }
                    if (viewId.equals(tempViewId)) continue;
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5f53\u524d\u9009\u62e9\u7684\u4e1a\u52a1\u6a21\u578b\u5728%1\u7ef4\u5ea6\u4e0d\u5b58\u5728\u5171\u540c\u7684\u7ef4\u5ea6\u89c6\u56fe\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u7ef4\u5ea6\u89c6\u56fe\u3002", (String)"DimensionRelationPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[]{dim.getString("name")}));
                    event.setCancel(true);
                    return;
                }
                QFilter qFilter = new QFilter("baseview", "=", (Object)viewId);
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_dimensionview", (String)"id", (QFilter[])qFilter.toArray());
                List viewIds = dynamicObjects.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
                viewIds.add(viewId);
                qFilterList.add(new QFilter("id", "in", viewIds));
            } else {
                qFilterList.add(new QFilter(DIMENSION, "=", (Object)dim.getLong("id")));
                qFilterList.add(new QFilter("model", "=", (Object)modelId));
            }
            if (DIMENSION_PROPERTY.equals(key)) {
                showParameter.setMultiSelect(false);
            } else {
                showParameter.setMultiSelect(true);
            }
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    private Set<Long> getExistDimensionSet() {
        DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity(ENTRYENTITY);
        HashSet<Long> ids = new HashSet<Long>(16);
        for (DynamicObject entity : entryEntitys) {
            DynamicObject dynamicObject = entity.getDynamicObject(DIMENSION);
            if (dynamicObject == null) continue;
            ids.add(dynamicObject.getLong("id"));
        }
        return ids;
    }

    private Boolean isModify() {
        boolean isModify = false;
        Object id = this.getModel().getValue("id");
        if (id != null) {
            isModify = Long.parseLong(id.toString()) != 0L;
        }
        return isModify;
    }
}

