/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.dimensionrelation;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.dimension.dimensionrelation.DimRelation;
import kd.epm.eb.common.dimension.dimensionrelation.DimRelationEntry;
import kd.epm.eb.common.dimension.dimensionrelation.DimensionRelationUtils;
import kd.epm.eb.common.dimension.dimensionrelation.dao.DimRelDao;
import kd.epm.eb.common.entity.property.CustomProperty;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.PropRangeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.excel.ExcelImExportUtils;
import kd.epm.eb.common.utils.period.BgPeriodHelper;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DimensionRelationUploadPlugin
extends AbstractFormPlugin
implements UploadListener {
    protected static Log log = LogFactory.getLog(DimensionRelationUploadPlugin.class);
    private static final String CURRENT_SCHEME_ID = "currentNodeId";
    private static final String TEMPPATH = "dimensionrelation/dimensionrelation.xlsx";
    private static final String SPILTSTR = "$_$";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btndownload"});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"newandcover"});
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>(16);
        dataMap.put("maxatmcount", 1);
        this.getView().updateControlMetadata("attachmentpanelap", dataMap);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.importData();
                break;
            }
            case "btndownload": {
                this.downloadTemplate();
                break;
            }
        }
    }

    private DimRelation getCurRelation() {
        DimRelation dimRelation = null;
        String relationCache = this.getView().getParentView().getPageCache().get("dimRelation");
        if (StringUtils.isNotEmpty((CharSequence)relationCache)) {
            dimRelation = (DimRelation)SerializationUtils.deSerializeFromBase64((String)relationCache);
        }
        return dimRelation;
    }

    private void importData() {
        DimRelation curRelation = this.getCurRelation();
        if (curRelation == null) {
            return;
        }
        int count = 0;
        List head = (List)this.getView().getFormShowParameter().getCustomParam("head");
        ExcelImExportUtils.Sheet sheet = new ExcelImExportUtils.Sheet(0, 2, 0, head.size());
        String fileUrl = this.getPageCache().get("file_url");
        HashMap<String, Constable> resultMap = new HashMap<String, Constable>(10);
        resultMap.put("count", Integer.valueOf(count));
        List dataList = ExcelImExportUtils.getInstance().read(fileUrl, sheet);
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            this.getView().returnDataToParent(resultMap);
            this.getView().close();
        }
        HashMap<Integer, String> headKey = new HashMap<Integer, String>(16);
        List viewIds = curRelation.getDimMap().values().stream().flatMap(e -> e.getViewIds().stream()).filter(IDUtils::isNotNull).collect(Collectors.toList());
        Map viewInfo = DimensionViewServiceHelper.getInstance().getViewInfoById(viewIds);
        if (!this.validExcel(dataList, head, headKey, curRelation, viewInfo).booleanValue()) {
            resultMap.put("count", Integer.valueOf(-1));
            this.getView().returnDataToParent(resultMap);
            this.getView().close();
            return;
        }
        List<DynamicObject> mapObjList = this.toObj(dataList, headKey, curRelation, viewInfo);
        count = this.saveImportData(mapObjList);
        resultMap.put("count", Integer.valueOf(count));
        if (count != dataList.size()) {
            resultMap.put("repeat", Boolean.valueOf(true));
        } else {
            resultMap.put("repeat", Boolean.valueOf(false));
        }
        this.getView().returnDataToParent(resultMap);
        this.getView().close();
    }

    private DynamicObject getProperty(String property, String number) {
        QFilter qFilter = new QFilter("property", "=", (Object)Long.parseLong(property));
        QFilter qFilter1 = new QFilter("number", "=", (Object)number);
        return QueryServiceHelper.queryOne((String)"eb_custompropertyvalue", (String)"id", (QFilter[])new QFilter[]{qFilter, qFilter1});
    }

    /*
     * Enabled aggressive block sorting
     */
    private Boolean validExcel(List<String[]> dataList, List<String> head, Map<Integer, String> headKey, DimRelation curRelation, Map<Long, DynamicObject> viewInfo) {
        if (dataList == null) return Boolean.FALSE;
        if (dataList.size() == 0) {
            return Boolean.FALSE;
        }
        Long modelId = this.getModelId();
        String[] strings = dataList.get(0);
        ArrayList<ExcelImExportUtils.ErrorMark> errorMarkList = new ArrayList<ExcelImExportUtils.ErrorMark>(16);
        for (int i = 0; i < strings.length; ++i) {
            Boolean hasErr;
            block37: {
                block36: {
                    String headNumber;
                    String number;
                    String headStr = StringUtils.trim((String)strings[i]);
                    hasErr = Boolean.FALSE;
                    if (StringUtils.isEmpty((CharSequence)headStr) || !headStr.contains("(")) break block36;
                    String numberKey = number = headStr.split("\\(")[1];
                    if (number.endsWith(")")) {
                        numberKey = number.substring(0, number.length() - 1);
                    }
                    numberKey = StringUtils.trim((String)numberKey);
                    String headNumberKey = headNumber = StringUtils.trimToEmpty((String)head.get(i)).split("\\(")[1];
                    if (headNumber.endsWith(")")) {
                        headNumberKey = headNumber.substring(0, headNumber.length() - 1);
                    }
                    if (numberKey.equals(headNumberKey = StringUtils.trim((String)headNumberKey))) {
                        if (!headKey.containsValue(headNumberKey)) {
                            headKey.put(i, headNumberKey);
                        }
                        break block37;
                    } else {
                        hasErr = Boolean.TRUE;
                    }
                    break block37;
                }
                hasErr = Boolean.TRUE;
            }
            if (!hasErr.booleanValue()) continue;
            errorMarkList.add(new ExcelImExportUtils.ErrorMark(0, ResManager.loadKDString((String)"\u7ef4\u5ea6\u5934\u5bfc\u5165\u9519\u8bef\u3002", (String)"DimensionRelationUploadPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0])));
            dataList.set(0, strings);
            break;
        }
        if (CollectionUtils.isNotEmpty(errorMarkList)) {
            this.exportExcel(dataList, errorMarkList);
            return Boolean.FALSE;
        }
        dataList.remove(0);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelId);
        if (curRelation == null) {
            return Boolean.FALSE;
        }
        Map<String, DimRelationEntry> relationDimMap = curRelation.getDimMap().values().stream().collect(Collectors.toMap(DimRelationEntry::getDimNumber, v -> v, (o1, o2) -> o2));
        int j = 0;
        while (true) {
            Iterator<Map.Entry<Integer, String>> iterator;
            String[] dataArr;
            Member endMember;
            Member startMember;
            if (j < dataList.size()) {
                startMember = null;
                endMember = null;
                dataArr = dataList.get(j);
                iterator = headKey.entrySet().iterator();
            } else {
                boolean bl;
                if (CollectionUtils.isNotEmpty(errorMarkList)) {
                    this.exportExcel(dataList, errorMarkList);
                }
                if (!CollectionUtils.isNotEmpty(errorMarkList)) {
                    bl = true;
                    return bl;
                }
                bl = false;
                return bl;
            }
            while (iterator.hasNext()) {
                Map.Entry<Integer, String> entry = iterator.next();
                String value = dataArr[entry.getKey()];
                String headField = StringUtils.trim((String)entry.getValue());
                if (!(null == head || "status".equals(headField) || "startperiod".equals(headField) || "endperiod".equals(headField) || headField.contains("Range") || headField.contains("view"))) {
                    if (StringUtils.isEmpty((CharSequence)value)) {
                        errorMarkList.add(new ExcelImExportUtils.ErrorMark(j, ResManager.loadResFormat((String)"%1\u7684\u6210\u5458\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"DimensionRelationUploadPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[]{headField})));
                        break;
                    }
                    DimRelationEntry relationEntry = relationDimMap.get(headField);
                    if (relationEntry == null) {
                        errorMarkList.add(new ExcelImExportUtils.ErrorMark(j, ResManager.loadResFormat((String)"%1\u4e0d\u662f\u6709\u6548\u7ef4\u5ea6\u6210\u5458\u3002", (String)"DimensionRelationUploadPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[]{headField})));
                        break;
                    }
                    Long propertyId = relationEntry.getPropertyId();
                    if (propertyId != 0L) {
                        CustomProperty customProperty = memberPropCache.getProperty(propertyId);
                        List propertyValues = memberPropCache.getPropertyValuesByProp(relationEntry.getDimNumber(), propertyId);
                        List propertyValueNumbers = propertyValues.stream().map(CustomPropertyValue::getNumber).collect(Collectors.toList());
                        if (!propertyValueNumbers.contains(value)) {
                            errorMarkList.add(new ExcelImExportUtils.ErrorMark(j, ResManager.loadResFormat((String)"%1\u4e0d\u662f\u5c5e\u6027\u201c%2\u201d\u7684\u6210\u5458\u3002", (String)"DimensionRelationUploadPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[]{value, customProperty.getNumber()})));
                            break;
                        }
                    } else {
                        Member member;
                        Long viewId;
                        block35: {
                            viewId = 0L;
                            if (!View.NoViewDimNums.contains(headField)) {
                                String viewNumber = dataArr[entry.getKey() + 3];
                                if (StringUtils.isNotEmpty((CharSequence)viewNumber)) {
                                    Optional<DynamicObject> optional = viewInfo.values().stream().filter(e -> e.getLong("dimension") == relationEntry.getDimensionId().longValue() && viewNumber.equals(e.getString("number"))).findFirst();
                                    DynamicObject dynamicObject = optional.orElse(null);
                                    if (dynamicObject != null && relationEntry.getViewIds().contains(dynamicObject.getLong("id"))) {
                                        viewId = dynamicObject.getLong("id");
                                        break block35;
                                    } else {
                                        errorMarkList.add(new ExcelImExportUtils.ErrorMark(j, ResManager.loadResFormat((String)"%1\u975e\u7ef4\u5ea6\u201c%2\u201d\u7684\u7ef4\u5ea6\u89c6\u56fe\u3002", (String)"DimensionRelationUploadPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[]{viewNumber, headField})));
                                        break;
                                    }
                                }
                                errorMarkList.add(new ExcelImExportUtils.ErrorMark(j, ResManager.loadResFormat((String)"%1\u975e\u7ef4\u5ea6\u201c%2\u201d\u7684\u7ef4\u5ea6\u89c6\u56fe\u3002", (String)"DimensionRelationUploadPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[]{viewNumber, headField})));
                                break;
                            }
                        }
                        if ((member = modelCache.getMember(headField, viewId, value)) == null) {
                            errorMarkList.add(new ExcelImExportUtils.ErrorMark(j, ResManager.loadResFormat((String)"%1\u975e\u7ef4\u5ea6\u201c%2\u201d\u7684\u6210\u5458\u3002", (String)"DimensionRelationUploadPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{value, headField})));
                            break;
                        }
                        Member rootMember = modelCache.getRootMember(headField, viewId);
                        if (value.equals(rootMember.getNumber()) || value.equals(headField)) {
                            errorMarkList.add(new ExcelImExportUtils.ErrorMark(j, ResManager.loadResFormat((String)"%1\u4e0d\u5141\u8bb8\u4e3a\u201c%2\u201d\u7684\u6839\u6210\u5458\u3002", (String)"DimensionRelationUploadPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[]{value, headField})));
                            break;
                        }
                    }
                }
                if (headField.contains("Range")) {
                    boolean rangeIsValid;
                    String rangeDim;
                    DimRelationEntry relationEntry;
                    if ((headField = headField.trim()).contains(" ")) {
                        headField = headField.substring(headField.lastIndexOf(" ") + 1);
                    }
                    if ((relationEntry = relationDimMap.get(rangeDim = headField.replace("Range", ""))) == null) {
                        errorMarkList.add(new ExcelImExportUtils.ErrorMark(j, ResManager.loadResFormat((String)"%1\u4e0d\u662f\u6709\u6548\u7ef4\u5ea6\u6210\u5458\u3002", (String)"DimensionRelationUploadPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[]{headField})));
                        break;
                    }
                    Long propertyId = relationEntry.getPropertyId();
                    if (propertyId != 0L) {
                        PropRangeEnum propRange = PropRangeEnum.getRangeByName((String)value);
                        rangeIsValid = DimensionRelationUtils.VALID_PROP_RANGE.contains(propRange);
                    } else {
                        RangeEnum range = RangeEnum.getRangeByName((String)value);
                        rangeIsValid = DimensionRelationUtils.VALID_RANGE.contains(range);
                    }
                    if (!rangeIsValid) {
                        errorMarkList.add(new ExcelImExportUtils.ErrorMark(j, ResManager.loadResFormat((String)"%1\u4e0d\u662f\u6709\u6548\u7684\u6210\u5458\u8303\u56f4", (String)"DimensionRelationUploadPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[]{value})));
                        break;
                    }
                }
                if ("startperiod".equals(headField) && !StringUtils.isEmpty((CharSequence)value) && (startMember = modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, value)) == null) {
                    errorMarkList.add(new ExcelImExportUtils.ErrorMark(j, ResManager.loadResFormat((String)"%1\u4e0d\u662f\u671f\u95f4\u7684\u6210\u5458", (String)"DimensionRelationUploadPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[]{value})));
                    break;
                }
                if ("endperiod".equals(headField) && !StringUtils.isEmpty((CharSequence)value) && (endMember = modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, value)) == null) {
                    errorMarkList.add(new ExcelImExportUtils.ErrorMark(j, ResManager.loadResFormat((String)"%1\u4e0d\u662f\u671f\u95f4\u7684\u6210\u5458", (String)"DimensionRelationUploadPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[]{value})));
                    break;
                }
                if (startMember == null || endMember == null || BgPeriodHelper.comparePeriod((String)startMember.getNumber(), (String)endMember.getNumber()) <= 0) continue;
                errorMarkList.add(new ExcelImExportUtils.ErrorMark(j, ResManager.loadResFormat((String)"\u7981\u7528\u671f\u95f4\u5e94\u5927\u4e8e\u6216\u7b49\u4e8e\u542f\u7528\u671f\u95f4\u3002", (String)"DimensionRelationListPlugin_41", (String)"epm-eb-formplugin", (Object[])new Object[0])));
                break;
            }
            ++j;
        }
    }

    private void exportExcel(List<String[]> dataList, List<ExcelImExportUtils.ErrorMark> errorMarkList) {
        String filename = this.getFileName(ResManager.loadKDString((String)"\u5bfc\u5165\u51fa\u9519\u8be6\u60c5", (String)"DimensionRelationUploadPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        Pair headDataInfo = DimensionRelationUtils.getHeadDataInfo((String)this.getSchemeId());
        ExcelImExportUtils.Sheet sheet = new ExcelImExportUtils.Sheet(0, 2, 0, 0, Short.valueOf((short)10));
        String url = ExcelImExportUtils.getInstance().writeWithTemplateWithError(TEMPPATH, filename, (List)headDataInfo.getLeft(), dataList, sheet, errorMarkList, (List)headDataInfo.getRight());
        ExcelImExportUtils.getInstance().download(this.getView(), url);
    }

    private List<DynamicObject> toObj(List<String[]> dataList, Map<Integer, String> headKey, DimRelation curRelation, Map<Long, DynamicObject> viewInfo) {
        ArrayList<DynamicObject> objList = new ArrayList<DynamicObject>(dataList.size());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Map propertyMap = (Map)this.getView().getFormShowParameter().getCustomParam("property");
        if (curRelation == null) {
            return objList;
        }
        Map relationDimMap = curRelation.getDimMap();
        StringBuilder select = new StringBuilder();
        for (String[] row : dataList) {
            String status;
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"epm_dimmemberrelation"));
            dynamicObject.set("relationid", (Object)this.getSchemeId());
            long startPeriod = 0L;
            long endPeriod = 0L;
            if (headKey.containsValue("startperiod") && headKey.containsValue("endperiod")) {
                Member endMember;
                Member startMember = modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, row[row.length - 2]);
                if (startMember != null) {
                    startPeriod = startMember.getId();
                }
                if ((endMember = modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, row[row.length - 1])) != null) {
                    endPeriod = endMember.getId();
                }
                status = row[row.length - 3];
            } else {
                status = row[row.length - 1];
            }
            dynamicObject.set("startperiod", (Object)startPeriod);
            dynamicObject.set("endperiod", (Object)endPeriod);
            dynamicObject.set("status", (Object)(ResManager.loadKDString((String)"\u7981\u7528", (String)"OffsetRuleListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(status) ? Boolean.FALSE : Boolean.TRUE));
            int index = 1;
            for (int i = 0; i < row.length; ++i) {
                RangeEnum range;
                PropRangeEnum propRange;
                String head = headKey.get(i);
                if (!(null == head || "status".equals(head) || "startperiod".equals(head) || "endperiod".equals(head) || head.contains("Range") || head.contains("view"))) {
                    String property = (String)propertyMap.get(head);
                    if (!StringUtils.isEmpty((CharSequence)property) && !"0".equals(property)) {
                        dynamicObject.set("dimension" + index, this.getProperty(property, row[i]).get("id"));
                    } else {
                        Member member;
                        Dimension dimension = modelCache.getDimension(head);
                        if (dimension == null) continue;
                        Long viewId = 0L;
                        if (!View.NoViewDimNums.contains(dimension.getNumber())) {
                            String viewNumber = row[i + 3];
                            DimRelationEntry relationEntry = (DimRelationEntry)relationDimMap.get("dimension" + index);
                            Optional<DynamicObject> optional = viewInfo.values().stream().filter(e -> e.getLong("dimension") == relationEntry.getDimensionId().longValue() && viewNumber.equals(e.getString("number"))).findFirst();
                            DynamicObject viewObj = optional.orElse(null);
                            viewId = viewObj == null ? 0L : viewObj.getLong("id");
                            dynamicObject.set("dimension" + index + "view", (Object)viewId);
                        }
                        if ((member = dimension.getMember(viewId, row[i])) == null) continue;
                        dynamicObject.set("dimension" + index, (Object)member.getId());
                    }
                    select.append("dimension").append(index).append(",");
                    continue;
                }
                if (null == head || !head.contains("Range")) continue;
                DimRelationEntry relationEntry = (DimRelationEntry)relationDimMap.get("dimension" + index);
                int rangeIndex = relationEntry.getPropertyId() != 0L ? ((propRange = PropRangeEnum.getRangeByName((String)row[i])) != null ? propRange.getIndex() : PropRangeEnum.PROP_DETAIL.getIndex()) : ((range = RangeEnum.getRangeByName((String)row[i])) != null ? range.getIndex() : RangeEnum.ONLY.getIndex());
                dynamicObject.set("dimension" + index + "range", (Object)rangeIndex);
                ++index;
            }
            objList.add(dynamicObject);
            if (null != this.getPageCache().get("select")) continue;
            this.getPageCache().put("select", select.toString());
        }
        return objList;
    }

    private int saveImportData(List<DynamicObject> mapObjList) {
        int count = 0;
        if (mapObjList == null || mapObjList.size() == 0) {
            return count;
        }
        Map<String, DynamicObject> existsDyMap = this.getExitsMemRelationDyMap();
        Long relationId = IDUtils.toLong((Object)this.getSchemeId());
        int maxSeq = DimensionRelationUtils.getMaxSeq((Long)relationId);
        String[] dims = this.getPageCache().get("select").split(",");
        List<String> dimRangeFields = Arrays.stream(dims).map(dim -> dim + "range").collect(Collectors.toList());
        ArrayList<DynamicObject> saveExistsDys = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> saveNewDys = new ArrayList<DynamicObject>(16);
        Long userId = UserUtils.getUserId();
        Date time = TimeServiceHelper.now();
        HashSet<String> repeat = new HashSet<String>(10);
        for (DynamicObject relationObj : mapObjList) {
            String curKey = this.getMemRelationDyKey(relationObj);
            if (!repeat.add(curKey)) continue;
            if (existsDyMap.containsKey(curKey)) {
                DynamicObject existsDy = existsDyMap.get(curKey);
                existsDy.set("status", relationObj.get("status"));
                existsDy.set("modifier", (Object)userId);
                existsDy.set("modifytime", (Object)time);
                existsDy.set("startperiod", relationObj.get("startperiod"));
                existsDy.set("endperiod", relationObj.get("endperiod"));
                dimRangeFields.forEach(field -> existsDy.set(field, relationObj.get(field)));
                saveExistsDys.add(existsDy);
                continue;
            }
            relationObj.set("model", (Object)this.getModelId());
            relationObj.set("creator", (Object)userId);
            relationObj.set("createtime", (Object)time);
            relationObj.set("dseq", (Object)(++maxSeq));
            relationObj.set("modifier", (Object)userId);
            relationObj.set("modifytime", (Object)time);
            saveNewDys.add(relationObj);
        }
        if (saveExistsDys.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])saveExistsDys.toArray(new DynamicObject[0]));
            count += saveExistsDys.size();
        }
        if (saveNewDys.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])saveNewDys.toArray(new DynamicObject[0]));
            count += saveNewDys.size();
        }
        DimRelDao.getInstance().updateVersion(this.getModelId().longValue(), relationId.longValue());
        return count;
    }

    private Map<String, DynamicObject> getExitsMemRelationDyMap() {
        DynamicObject[] dys;
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>(16);
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        qFilter.and(new QFilter("relationid", "=", (Object)Long.parseLong(this.getSchemeId())));
        String fields = "id," + this.getPageCache().get("select") + "dimension1range,dimension2range,dimension3range,dimension4range,dimension5range,dimension6range,status,dseq,modifier,modifytime,startperiod,endperiod";
        for (DynamicObject dy : dys = BusinessDataServiceHelper.load((String)"epm_dimmemberrelation", (String)fields, (QFilter[])new QFilter[]{qFilter})) {
            String key = this.getMemRelationDyKey(dy);
            result.put(key, dy);
        }
        return result;
    }

    private String getMemRelationDyKey(DynamicObject dy) {
        StringBuilder key = new StringBuilder();
        String select = this.getPageCache().get("select");
        for (String dim : select.split(",")) {
            key.append(dy.getString(dim)).append(SPILTSTR);
        }
        Long startPeriod = dy.get("startperiod") instanceof Long ? (Long)dy.get("startperiod") : Long.valueOf(dy.getLong("startperiod_id"));
        Long endPeriod = dy.get("endperiod") instanceof Long ? (Long)dy.get("endperiod") : Long.valueOf(dy.getLong("endperiod_id"));
        key.append(startPeriod).append(SPILTSTR).append(endPeriod);
        return key.toString();
    }

    private void downloadTemplate() {
        Pair headDataInfo = DimensionRelationUtils.getHeadDataInfo((String)this.getSchemeId());
        String filename = this.getFileName("");
        ExcelImExportUtils.Sheet sheet = new ExcelImExportUtils.Sheet(0, 2, 0, 0, Short.valueOf((short)10));
        sheet.setTitle(ResManager.loadKDString((String)"\u7ef4\u5ea6\u5173\u7cfb\u8bb0\u5f55", (String)"DimensionRelationUploadPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        sheet.setTip(ResManager.loadKDString((String)"\u7ea2\u8272*\u5fc5\u586b", (String)"DimensionRelationUploadPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        sheet.setTitlePosition(0, 0);
        sheet.setTipPosition(1, 0);
        String url = ExcelImExportUtils.getInstance().writeWithTemplate(TEMPPATH, filename, (List)headDataInfo.getLeft(), new ArrayList(1), sheet, null, (List)headDataInfo.getRight());
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
    }

    private String getFileName(String extName) {
        return ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458\u5173\u7cfb%1_%2", (String)"DimensionRelationUploadPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[]{extName, DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        String fileUrl = this.getPageCache().get("file_url");
        List urls = null;
        urls = fileUrl == null ? new ArrayList(10) : (List)SerializationUtils.fromJsonString((String)fileUrl, List.class);
        for (Object url : evt.getUrls()) {
            urls.add((String)((Map)url).get("url"));
        }
        this.getPageCache().put("file_url", SerializationUtils.toJsonString(urls));
    }

    public void afterRemove(UploadEvent evt) {
        Object[] objects;
        String file_url = this.getPageCache().get("file_url");
        if (file_url == null) {
            return;
        }
        List urls = (List)SerializationUtils.fromJsonString((String)file_url, List.class);
        for (Object object : objects = evt.getUrls()) {
            String url = (String)((Map)object).get("url");
            urls.remove(url);
        }
        this.getPageCache().put("file_url", SerializationUtils.toJsonString((Object)urls));
    }

    @Override
    public Long getModelId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("model");
    }

    private String getSchemeId() {
        return (String)this.getView().getFormShowParameter().getCustomParam(CURRENT_SCHEME_ID);
    }
}

