/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.dimensionrelation;

import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;

public class DimensionRelationUtils {
    public static long getMembersKeyHashId(Map<String, String> dimMemMap) {
        if (dimMemMap == null || dimMemMap.size() == 0) {
            return 0L;
        }
        Map<String, String> sortDimMemMap = DimensionRelationUtils.sortMapByKey(dimMemMap);
        String key = SerializationUtils.toJsonString(sortDimMemMap);
        long hashid = DimensionRelationUtils.getHashCode(key);
        return hashid;
    }

    public static long getHashCode(String key) {
        Long keyId = Hashing.sha256().hashString((CharSequence)key, StandardCharsets.UTF_8).padToLong();
        return keyId;
    }

    public static <T> Map<String, T> sortMapByKey(Map<String, T> map) {
        Map<Object, Object> result = new LinkedHashMap(16);
        if (map == null || map.size() == 0) {
            return result;
        }
        List<String> orderKeys = map.keySet().stream().collect(Collectors.toList());
        Collections.sort(orderKeys);
        result = DimensionRelationUtils.sortDimByorder(map, orderKeys);
        return result;
    }

    public static <T> Map<String, T> sortDimByorder(Map<String, T> allDimMap, List<String> orderDims) {
        LinkedHashMap<String, T> result = new LinkedHashMap<String, T>(16);
        for (String dimNum : orderDims) {
            if (!allDimMap.containsKey(dimNum)) continue;
            result.put(dimNum, allDimMap.get(dimNum));
        }
        return result;
    }
}

