/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.dimensionrelation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.entity.memberF7.LeftTreeF7Parameter;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.excel.ExcelImExportUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.dimension.dimensionrelation.DimensionRelationListPlugin;
import kd.epm.eb.formplugin.dimension.dimensionrelation.DimensionRelationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class MultiDimensionRelationListPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
BeforeF7SelectListener,
SearchEnterListener {
    public static final String CACHE_RELATION_DIM = "cache_relation_dim";
    public static final String CACHE_F7KEY_DIM_MAP = "cache_f7key_dim_map";
    public static final String tempPath = "dimensionrelation/multidimensionrelation.xlsx";
    private static final String BTN_ADDDIMRELAT = "btn_adddimrelat";
    private static final String BTN_EDITDIMRELAT = "btn_editdimrelat";
    private static final String BTN_DELDIMRELAT = "btn_deldimrelat";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BTN_ADDMEMBER = "btn_addmember";
    private static final String BTN_DELMEMBER = "btn_delmember";
    private static final String BTN_SAVEMEMBER = "btn_savemember";
    private static final String BTN_UPMOVE = "btn_upmove";
    private static final String BTN_DOWNMOVE = "btn_downmove";
    private static final String BTN_CUT = "btn_cut";
    private static final String BTN_PASTE = "btn_paste";
    private static final String BTN_IMPORT = "btn_import";
    private static final String BTN_EXPORT = "btn_export";
    private static final String DIMRELATTREE = "dimrelattree";
    private static final String TREEENTRYENTITY = "treeentryentity";
    private static final String REALTIONSEARCH = "searchdimrelat";
    private static final String MEMBERSEARCH = "searchmember";
    private static final String UPDIMRELAT = "updimrelat";
    private static final String DOWNDIMRELAT = "downdimrelat";
    private static final String UPMEMBER = "upmember";
    private static final String DOWNMEMBER = "downmember";
    private static final String CUSTOM_DIMENSION_1 = "customize1";
    private static final String CUSTOM_DIMENSION_2 = "customize2";
    private static final String CUSTOM_DIMENSION_3 = "customize3";
    private static final String KEY_USERDEFINED_F7_PREFIX = "customize";
    private static final String CURRENT_SCHEME_ID = "currentNodeId";
    private static final String CALLBCAK_IMPORT_CLOSE = "import_close";
    private static final String DIMENSIONMAP = "dims";
    private static final Log log = LogFactory.getLog(DimensionRelationListPlugin.class);
    private static final Set<String> dimSet = new HashSet<String>(Arrays.asList("entity", "account", "year", "period", "budgetperiod", "version", "currency", "datatype", "changetype", "audittrail", "metric", "internalcompany", "scenario", "process"));
    private static final Set<String> customDimSet = new HashSet<String>(Arrays.asList("customize1", "customize2", "customize3"));
    Map<String, String> allF7Map = null;
    Map<String, Map<String, String>> relationSchemeDims = null;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_ADDDIMRELAT, BTN_EDITDIMRELAT, BTN_DELDIMRELAT, BTN_ADDMEMBER, BTN_DELMEMBER, BTN_UPMOVE, BTN_DOWNMOVE, BTN_CUT, BTN_PASTE, UPDIMRELAT, DOWNDIMRELAT, UPMEMBER, DOWNMEMBER, BTN_IMPORT, BTN_EXPORT});
        this.addItemClickListeners(new String[]{"toolbarap"});
        TreeView treeView = (TreeView)this.getView().getControl(DIMRELATTREE);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addBeforeF7SelectListener();
        Search relationSearch = (Search)this.getControl(REALTIONSEARCH);
        relationSearch.addEnterListener((SearchEnterListener)this);
        Search memberSearch = (Search)this.getControl(MEMBERSEARCH);
        memberSearch.addEnterListener((SearchEnterListener)this);
    }

    private void addBeforeF7SelectListener() {
        BasedataEdit f7 = null;
        for (String dim : dimSet) {
            f7 = (BasedataEdit)this.getControl(dim);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        for (String dim : customDimSet) {
            f7 = (BasedataEdit)this.getControl(dim);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("modelId");
        this.getModel().setValue("model", (Object)modelId);
        this.getPageCache().put("modelId", modelId.toString());
        this.initAllDimVisiable();
        this.initTree();
    }

    private void setDefaultNode() {
        TreeView treeView = (TreeView)this.getView().getControl(DIMRELATTREE);
        String rootCache = this.getPageCache().get("rootNode");
        TreeNode root = (TreeNode)ObjectSerialUtil.deSerializedBytes((String)rootCache);
        List childNodeList = root.getChildren();
        if (childNodeList != null && childNodeList.size() != 0) {
            treeView.focusNode((TreeNode)childNodeList.get(0));
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"status", "modifier", "modifytime"});
            String nodeId = this.getSchememId();
            if (StringUtils.isEmpty((CharSequence)nodeId)) {
                this.treeNodeClick(new TreeNodeEvent(new Object(), (Object)root.getId(), (Object)((TreeNode)childNodeList.get(0)).getId()));
            } else {
                TreeNode currentNode = this.getNode(nodeId);
                if (currentNode == null) {
                    return;
                }
                this.clickTreeNode(nodeId);
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"status", "modifier", "modifytime"});
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        String dimkey = event.getProperty().getName();
        if (!dimkey.equals("model")) {
            this.dimMemF7Select(event);
        }
    }

    public void dimMemF7Select(BeforeF7SelectEvent e) {
        String dimkey = e.getProperty().getName();
        Map<String, String> f7Key2DimMap = this.getAllF7Map();
        String dimNum = f7Key2DimMap.get(dimkey);
        LeftTreeF7Parameter leftTreeF7Parameter = new LeftTreeF7Parameter();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        qFilterList.add(this.getDimQFilter(dimkey, dimNum));
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().addAll(qFilterList);
        leftTreeF7Parameter.setMultiple(true);
        leftTreeF7Parameter.setOnlyLeaf(true);
        leftTreeF7Parameter.setqFilters(qFilterList);
        String dimPosKey = this.getCacheDimPosKey(dimkey);
        this.getPageCache().put(dimPosKey, String.valueOf(e.getRow()));
        this.switchLeftTreeF7(e, 0L, leftTreeF7Parameter);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        this.clearAllCache();
        String nodeId = evt.getNodeId().toString();
        this.getPageCache().put(CURRENT_SCHEME_ID, nodeId);
        this.setBillDimVisiable();
        this.refreshBilllist();
        this.clearMemberSearchCache();
        this.getPageCache().put("cutMemberRow", null);
    }

    private void setBillDimVisiable() {
        this.initAllDimVisiable();
        EntryGrid entryGrid = (EntryGrid)this.getControl(TREEENTRYENTITY);
        Map<String, String> f7Key2DimMap = this.getAllF7Map();
        Map<String, Map<String, String>> dimsMap = this.getRelationSchemeDims();
        for (Map.Entry<String, String> entry : f7Key2DimMap.entrySet()) {
            String dimNum = entry.getValue();
            String f7Key = entry.getKey();
            String f7Keyname = StringUtils.join((Object[])new String[]{f7Key, "name"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{f7Key, f7Keyname});
            Map<String, String> dimMap = dimsMap.get(dimNum);
            entryGrid.setColumnProperty(f7Keyname, "header", (Object)new LocaleString(StringUtils.join((Object[])new String[]{dimMap.get("dimname"), ResManager.loadKDString((String)"\u540d\u79f0", (String)"DimensionRelationListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0])})));
            entryGrid.setColumnProperty(f7Key, "header", (Object)new LocaleString(StringUtils.join((Object[])new String[]{dimMap.get("dimname"), ResManager.loadKDString((String)"\u5185\u7801", (String)"DimensionRelationListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0])})));
        }
    }

    private void initAllDimVisiable() {
        ArrayList<String> columns = new ArrayList<String>(16);
        for (String dim : dimSet) {
            columns.add(dim);
            columns.add(StringUtils.join((Object[])new String[]{dim, "name"}));
        }
        for (int i = 1; i <= 3; ++i) {
            columns.add(KEY_USERDEFINED_F7_PREFIX + i);
            columns.add(KEY_USERDEFINED_F7_PREFIX + i + "name");
        }
        this.getView().setVisible(Boolean.valueOf(false), columns.toArray(new String[columns.size()]));
    }

    private Map<String, Map<String, String>> getDimRelationMap(Long schemeId) {
        LinkedHashMap<String, Map<String, String>> result = new LinkedHashMap<String, Map<String, String>>(16);
        QFilter qFilter1 = new QFilter("model", "=", (Object)this.getModelId());
        QFilter qFilter2 = new QFilter("id", "=", (Object)schemeId);
        String fields = "entryentity.dimension dimid,entryentity.dimension.number dimnum, entryentity.dimension.name dimname,entryentity.dimensionview dimview";
        DynamicObjectCollection dimRowDys = QueryServiceHelper.query((String)"epm_multidimrelation", (String)fields, (QFilter[])new QFilter[]{qFilter1, qFilter2});
        for (DynamicObject dimRowDy : dimRowDys) {
            HashMap<String, String> dimMap = new HashMap<String, String>(16);
            String dimNum = dimRowDy.getString("dimnum");
            String dimName = dimRowDy.getString("dimname");
            String dimId = dimRowDy.getString("dimid");
            String viewId = dimRowDy.getString("dimview");
            dimMap.put("dimnum", dimNum);
            dimMap.put("dimname", dimName);
            dimMap.put("dimid", dimId);
            dimMap.put("viewid", viewId);
            result.put(dimNum, dimMap);
        }
        return result;
    }

    private Map<String, Map<String, String>> getRelationSchemeDims() {
        if (this.relationSchemeDims != null) {
            return this.relationSchemeDims;
        }
        Map<Object, Object> result = new LinkedHashMap(16);
        if (this.getPageCache().get(CACHE_RELATION_DIM) != null) {
            result = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_RELATION_DIM), Map.class);
        } else {
            Long schemeId = this.getPageCache().get(CURRENT_SCHEME_ID) == null ? 0L : Long.parseLong(this.getPageCache().get(CURRENT_SCHEME_ID));
            result = this.getDimRelationMap(schemeId);
            this.getPageCache().put(CACHE_RELATION_DIM, SerializationUtils.toJsonString(result));
        }
        this.relationSchemeDims = result;
        return result;
    }

    private Map<String, String> getAllF7Map() {
        if (this.allF7Map != null) {
            return this.allF7Map;
        }
        LinkedHashMap<String, String> f7KeyMap = new LinkedHashMap(16);
        if (this.getPageCache().get(CACHE_F7KEY_DIM_MAP) != null) {
            f7KeyMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_F7KEY_DIM_MAP), Map.class);
        } else {
            Map<String, Map<String, String>> dimsMap = this.getRelationSchemeDims();
            AtomicInteger userdefined_index = new AtomicInteger(1);
            for (String dimnumber : dimsMap.keySet()) {
                String memberTreemodel = SysDimensionEnum.getMemberTreemodelByNumber((String)dimnumber);
                boolean isuserdefined = false;
                if ("epm_userdefinedmembertree".equals(memberTreemodel)) {
                    isuserdefined = true;
                }
                String f7key = dimnumber.toLowerCase();
                if (isuserdefined) {
                    f7key = KEY_USERDEFINED_F7_PREFIX + userdefined_index.get();
                    userdefined_index.incrementAndGet();
                }
                f7KeyMap.put(f7key, dimnumber);
            }
            this.getPageCache().put(CACHE_F7KEY_DIM_MAP, SerializationUtils.toJsonString(f7KeyMap));
        }
        this.allF7Map = f7KeyMap;
        return f7KeyMap;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_adddimrelat": 
            case "btn_editdimrelat": {
                this.openDimensionPage(key);
                break;
            }
            case "btn_deldimrelat": {
                this.delete();
                break;
            }
            case "btn_addmember": {
                this.addMemberEntry();
                break;
            }
            case "btn_delmember": {
                this.deleteMember();
                break;
            }
            case "btn_upmove": 
            case "btn_downmove": {
                this.memberMove(key);
                break;
            }
            case "updimrelat": 
            case "downdimrelat": {
                this.dimUpAndDown(key);
                break;
            }
            case "upmember": 
            case "downmember": {
                this.memberUpAndDown(key);
                break;
            }
            case "btn_import": {
                this.importExcel();
                break;
            }
            case "btn_export": {
                this.exportExcel();
                break;
            }
        }
    }

    private void delete() {
        TreeView treeView = (TreeView)this.getView().getControl(DIMRELATTREE);
        String nodeId = treeView.getTreeState().getFocusNodeId();
        if (StringUtils.isEmpty((CharSequence)nodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u7ef4\u5ea6\u5173\u7cfb\u65b9\u6848\u3002", (String)"DimensionRelationListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u65b9\u6848\u5c06\u540c\u65f6\u5220\u9664\u6240\u6709\u6210\u5458\u5173\u7cfb\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"DimensionRelationListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleteRelation", (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        if (mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
            if ("deleteRelation".equals(callBackId)) {
                TreeView treeView = (TreeView)this.getView().getControl(DIMRELATTREE);
                String nodeId = treeView.getTreeState().getFocusNodeId();
                int size = DeleteServiceHelper.delete((String)"epm_multidimrelation", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(nodeId))});
                if (size > 0) {
                    DeleteServiceHelper.delete((String)"epm_multidimmemrelation", (QFilter[])new QFilter[]{this.getMemberQFilter(nodeId)});
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"DimensionRelationListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25", (String)"DimensionRelationListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                this.getView().getPageCache().put(CURRENT_SCHEME_ID, null);
            } else if ("deleteRelationMember".equals(callBackId)) {
                EntryGrid entity = (EntryGrid)this.getView().getControl(TREEENTRYENTITY);
                int[] rows = entity.getSelectRows();
                HashSet<Long> ids = new HashSet<Long>(16);
                HashMap<String, Map<String, String>> deleteMembers = new HashMap<String, Map<String, String>>(16);
                for (int row : rows) {
                    Object id = this.getModel().getValue("id", row);
                    if (Objects.isNull(id) || Objects.equals("", id)) continue;
                    ids.add(Long.parseLong(id.toString()));
                    Map<String, String> dimMemMap = this.getDimMemByRow(row);
                    deleteMembers.put(id.toString(), dimMemMap);
                }
                DeleteServiceHelper.delete((String)"epm_multidimmemrelation", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                this.getModel().deleteEntryRows(TREEENTRYENTITY, rows);
                if (deleteMembers.size() != 0) {
                    log.info("DimensionRelationList.deleteMember: " + SerializationUtils.toJsonString(deleteMembers));
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DimensionRelationListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.refreshAll();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_refresh": {
                this.refreshAll();
                break;
            }
            case "btn_savemember": {
                this.saveMember();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "model": {
                DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
                DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
                if (newValue == null) {
                    this.getModel().setValue("model", (Object)oldValue);
                    return;
                }
                this.getPageCache().put("modelId", ((DynamicObject)this.getModel().getValue("model")).getString("id"));
                this.initAllDimVisiable();
                this.clearAllCache();
                this.refreshAll();
                break;
            }
        }
    }

    private void clearAllCache() {
        this.getPageCache().put(CURRENT_SCHEME_ID, null);
        this.getPageCache().remove(CACHE_F7KEY_DIM_MAP);
        this.getPageCache().remove(CACHE_RELATION_DIM);
        this.clearAllSearchCache();
    }

    private void clearAllSearchCache() {
        this.clearTreeSearchCache();
        this.clearMemberSearchCache();
    }

    private void clearTreeSearchCache() {
        Search search = (Search)this.getControl(REALTIONSEARCH);
        search.setSearchKey("");
        this.getPageCache().put("relatSearchResult", null);
    }

    private void clearMemberSearchCache() {
        Search search = (Search)this.getControl(MEMBERSEARCH);
        search.setSearchKey("");
        this.getPageCache().put("memberSearchResult", null);
    }

    private void openDimensionPage(String key) {
        FormShowParameter formShowParameter = null;
        String seqCache = this.getPageCache().get("biggestTreeSeq");
        if (BTN_EDITDIMRELAT.equals(key)) {
            TreeView treeView = (TreeView)this.getView().getControl(DIMRELATTREE);
            String nodeId = treeView.getTreeState().getFocusNodeId();
            if (StringUtils.isEmpty((CharSequence)nodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u5173\u7cfb\u3002", (String)"DimensionRelationListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, String> openParameter = new HashMap<String, String>(16);
            openParameter.put("formId", "epm_multidimrelation");
            openParameter.put("pkId", nodeId);
            formShowParameter = FormShowParameter.createFormShowParameter(openParameter);
            formShowParameter.setCustomParam("pkId", (Object)nodeId);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "MODIFY"));
        } else {
            formShowParameter = new FormShowParameter();
            if (StringUtils.isNotEmpty((CharSequence)seqCache)) {
                int seq = (Integer)SerializationUtils.fromJsonString((String)seqCache, Integer.class);
                formShowParameter.setCustomParam("dseq", (Object)seq);
            }
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ADD"));
        }
        formShowParameter.setFormId("epm_multidimrelation");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("modelId", (Object)this.getModelId());
        this.getView().showForm(formShowParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        switch (key) {
            case "ADD": {
                this.addAndNodifyBack(closedCallBackEvent);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65b0\u589e\u6210\u529f", (String)"MultiDimensionRelationListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                break;
            }
            case "MODIFY": {
                this.addAndNodifyBack(closedCallBackEvent);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f", (String)"MultiDimensionRelationListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                break;
            }
            case "import_close": {
                this.importCloseBack(closedCallBackEvent);
                break;
            }
            default: {
                this.dimSelectCloseBack(closedCallBackEvent);
            }
        }
    }

    private void addAndNodifyBack(ClosedCallBackEvent closedCallBackEvent) {
        this.refreshAll();
        String pkId = closedCallBackEvent.getReturnData().toString();
        this.clickTreeNode(pkId);
    }

    private void importCloseBack(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        Long count = (Long)closedCallBackEvent.getReturnData();
        if (count < 0L) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DimensionRelationListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (count != 0L) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6210\u529f\u5bfc\u5165", (String)"MultiDimensionRelationListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]) + " " + count + " " + ResManager.loadKDString((String)"\u6761\u6570\u636e\u3002", (String)"MultiDimensionRelationListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            String nodeId = this.getSchememId();
            this.clickTreeNode(nodeId);
        }
    }

    private void clickTreeNode(String nodeId) {
        if (!StringUtils.isEmpty((CharSequence)nodeId)) {
            TreeView treeView = (TreeView)this.getControl(DIMRELATTREE);
            treeView.focusNode(this.getNode(nodeId));
            this.treeNodeClick(new TreeNodeEvent((Object)"", (Object)"", (Object)nodeId));
        }
    }

    public void search(SearchEnterEvent event) {
        Search search = (Search)event.getSource();
        String key = search.getKey();
        String text = event.getText().trim().toLowerCase();
        if (MEMBERSEARCH.equals(key)) {
            this.memberSearch(text);
        } else {
            this.relationSearch(text);
        }
    }

    private void refreshAll() {
        this.refreshTree();
        this.refreshBilllist();
    }

    private void refreshTree() {
        this.initTree();
    }

    private void refreshBilllist() {
        this.getModel().deleteEntryData(TREEENTRYENTITY);
        TreeView treeView = (TreeView)this.getView().getControl(DIMRELATTREE);
        QFilter qFilter = this.getMemberQFilter(treeView.getTreeState().getFocusNodeId());
        String selFields = "id,status,modifier,modifytime,dseq,entryentity.dimension,entryentity.membernum,entryentity.memberid";
        DynamicObject[] memDys = BusinessDataServiceHelper.load((String)"epm_multidimmemrelation", (String)selFields, (QFilter[])new QFilter[]{qFilter}, (String)"dseq");
        if (memDys == null || memDys.length == 0) {
            return;
        }
        Map<String, String> f72DimMap = this.getAllF7Map();
        Map<String, String> dim2F7Map = f72DimMap.entrySet().stream().collect(Collectors.toMap(tem -> (String)tem.getValue(), tem -> (String)tem.getKey()));
        this.getModel().batchCreateNewEntryRow(TREEENTRYENTITY, memDys.length);
        int row = 0;
        for (DynamicObject doj : memDys) {
            this.getModel().setValue("id", (Object)doj.getLong("id"), row);
            this.getModel().setValue("status", (Object)doj.getBoolean("status"), row);
            this.getModel().setValue("modifier", (Object)doj.getDynamicObject("modifier"), row);
            this.getModel().setValue("modifytime", (Object)doj.getDate("modifytime"), row);
            DynamicObjectCollection dimDys = doj.getDynamicObjectCollection("entryentity");
            for (DynamicObject dimDy : dimDys) {
                String dimnum = dimDy.getString("dimension");
                String f7Key = dim2F7Map.get(dimnum);
                if (f7Key == null) continue;
                this.getModel().setValue(f7Key, (Object)dimDy.getLong("memberid"), row);
            }
            ++row;
        }
        this.getView().updateView(TREEENTRYENTITY);
    }

    @Override
    public Long getModelId() {
        return this.getLongCacheByKey("modelId");
    }

    public String getCurrentDimNumber(String controlKey) {
        Map<String, String> f7Key2DimMap = this.getAllF7Map();
        return f7Key2DimMap.get(controlKey);
    }

    private String getSchememId() {
        return this.getCacheByKey(CURRENT_SCHEME_ID);
    }

    private String getCacheByKey(String key) {
        String cacheValue = "";
        if (this.getPageCache().get(key) != null) {
            cacheValue = this.getPageCache().get(key);
        }
        return cacheValue;
    }

    private Long getLongCacheByKey(String key) {
        Long id = 0L;
        String idStr = this.getCacheByKey(key);
        if (!StringUtils.isEmpty((CharSequence)idStr)) {
            id = Long.parseLong(idStr);
        }
        return id;
    }

    private void initTree() {
        int maxSeq = 0;
        TreeView treeView = (TreeView)this.getView().getControl(DIMRELATTREE);
        treeView.deleteAllNodes();
        String selects = "id, name, dseq";
        DynamicObjectCollection relationId = QueryServiceHelper.query((String)"epm_multidimrelation", (String)selects, (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId())}, (String)"dseq");
        String rootNodeId = "0";
        TreeNode root = new TreeNode();
        root.setId(rootNodeId);
        root.setParentid(null);
        root.setText(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u5173\u7cfb", (String)"DimensionRelationListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        HashMap<String, String> data = new HashMap<String, String>(16);
        data.put("id", rootNodeId);
        data.put("name", root.getText());
        data.put("level", "1");
        root.setData(data);
        if (relationId != null && relationId.size() != 0) {
            for (DynamicObject relation : relationId) {
                ArrayList<TreeNode> children = root.getChildren();
                if (children == null) {
                    children = new ArrayList<TreeNode>(16);
                    root.setChildren(children);
                }
                TreeNode relationNode = new TreeNode();
                relationNode.setParentid(rootNodeId);
                relationNode.setId(relation.getString("id"));
                relationNode.setText(relation.getString("name"));
                HashMap<String, String> data2 = new HashMap<String, String>(16);
                data2.put("id", relation.getString("id"));
                data2.put("name", relation.getString("name"));
                data2.put("level", "2");
                relationNode.setData(data2);
                children.add(relationNode);
            }
            maxSeq = ((DynamicObject)relationId.get(relationId.size() - 1)).getInt("dseq");
        }
        treeView.addNode(root);
        treeView.expand(rootNodeId);
        this.getPageCache().put("rootNode", ObjectSerialUtil.toByteSerialized((Object)root));
        this.getPageCache().put("biggestTreeSeq", SerializationUtils.toJsonString((Object)maxSeq));
        this.setDefaultNode();
    }

    private void saveMember() {
        EntryGrid treeEntry = (EntryGrid)this.getControl(TREEENTRYENTITY);
        TreeView treeView = (TreeView)this.getControl(DIMRELATTREE);
        String relatId = treeView.getTreeState().getFocusNodeId();
        int[] rows = treeEntry.getSelectRows();
        if (rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4fdd\u5b58\u7684\u884c\u3002", (String)"DimensionRelationListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<DynamicObject> memberList = new HashSet<DynamicObject>(16);
        int dseq = 0;
        ArrayList<Integer> errRowSet = new ArrayList<Integer>(16);
        QFilter qFilter = this.getMemberQFilter(treeView.getTreeState().getFocusNodeId());
        DynamicObjectCollection seqDynamic = QueryServiceHelper.query((String)"epm_multidimmemrelation", (String)"dseq", (QFilter[])new QFilter[]{qFilter}, (String)"dseq");
        if (seqDynamic != null && seqDynamic.size() != 0) {
            dseq = ((DynamicObject)seqDynamic.get(seqDynamic.size() - 1)).getInt("dseq");
        }
        HashSet<Long> hashIdSet = new HashSet<Long>(16);
        for (int row : rows) {
            String id = this.getSelectId(row);
            String userId = RequestContext.get().getUserId();
            Date time = TimeServiceHelper.now();
            DynamicObject member = null;
            Map<String, String> dimMemMap = this.getDimMemByRow(row);
            long hashId = DimensionRelationUtils.getMembersKeyHashId(dimMemMap);
            if (hashIdSet.contains(hashId)) {
                errRowSet.add(row + 1);
                continue;
            }
            hashIdSet.add(hashId);
            int checkRow = this.saveCheck(row, dimMemMap, relatId);
            if (checkRow != -1) {
                errRowSet.add(checkRow + 1);
                continue;
            }
            HashMap<String, String> saveInfo = new HashMap<String, String>(16);
            if (StringUtils.isNotEmpty((CharSequence)id)) {
                member = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(id), (String)"epm_multidimmemrelation");
                saveInfo.put("saveType", "modify");
            } else {
                member = BusinessDataServiceHelper.newDynamicObject((String)"epm_multidimmemrelation");
                long newid = GlobalIdUtil.genGlobalLongId();
                member.set("id", (Object)newid);
                member.set("dseq", (Object)(++dseq));
                member.set("relationid", (Object)relatId);
                member.set("model", (Object)this.getModelId());
                member.set("creator", (Object)userId);
                member.set("createtime", (Object)time);
                saveInfo.put("saveType", "new");
                saveInfo.put("id", String.valueOf(newid));
            }
            member.set("status", this.getModel().getValue("status", row));
            member.set("entryhashid", (Object)hashId);
            Map<String, String> f72DimMap = this.getAllF7Map();
            DynamicObjectCollection memEntryDys = member.getDynamicObjectCollection("entryentity");
            memEntryDys.clear();
            for (Map.Entry<String, String> dimKey : f72DimMap.entrySet()) {
                String f7key = dimKey.getKey();
                String dimNum = dimKey.getValue();
                String memnum = "";
                long memid = 0L;
                DynamicObject dimDynamicObject = (DynamicObject)this.getModel().getValue(f7key, row);
                if (dimDynamicObject != null) {
                    memnum = dimDynamicObject.getString("number");
                    memid = dimDynamicObject.getLong("id");
                }
                DynamicObject newDy = memEntryDys.addNew();
                newDy.set("dimension", (Object)dimNum);
                newDy.set("membernum", (Object)memnum);
                newDy.set("memberid", (Object)memid);
            }
            this.getModel().setValue("modifier", (Object)userId, row);
            this.getModel().setValue("modifytime", (Object)time, row);
            if (StringUtils.isNotEmpty((CharSequence)((CharSequence)saveInfo.get("id")))) {
                this.getModel().setValue("id", saveInfo.get("id"), row);
            }
            member.set("modifier", (Object)userId);
            member.set("modifytime", (Object)time);
            memberList.add(member);
        }
        SaveServiceHelper.save((DynamicObject[])memberList.toArray(new DynamicObject[0]));
        CacheServiceHelper.clearRelation((Long)IDUtils.toLong((Object)relatId));
        if (errRowSet.size() == 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DimensionRelationListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            String rowString = ((Integer)errRowSet.get(0)).toString();
            if (errRowSet.size() > 1) {
                for (int i = 1; i < errRowSet.size(); ++i) {
                    rowString = StringUtils.join((Object[])new Serializable[]{rowString, ", ", (Serializable)errRowSet.get(i)});
                }
            }
            this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u6570\u636e\u672a\u586b\u5199\u5b8c\u6574\u6216\u4e0e\u5df2\u4fdd\u5b58\u7684\u6570\u636e\u51b2\u7a81\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"DimensionRelationListPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[]{rowString}));
            treeEntry.selectRows((Integer)errRowSet.get(0) - 1);
        }
    }

    private int saveCheck(int row, Map<String, String> dimMemMap, String relationId) {
        String dimMem3;
        Map<String, Map<String, String>> dimsMap = this.getRelationSchemeDims();
        String firstDim = this.getDimInfoByKey(dimsMap, 0, "dimnum");
        String secondDim = this.getDimInfoByKey(dimsMap, 1, "dimnum");
        String threeDim = this.getDimInfoByKey(dimsMap, 2, "dimnum");
        String dimMem1 = dimMemMap.get(firstDim) == null ? "" : dimMemMap.get(firstDim);
        String dimMem2 = dimMemMap.get(secondDim) == null ? "" : dimMemMap.get(secondDim);
        String string = dimMem3 = dimMemMap.get(threeDim) == null ? "" : dimMemMap.get(threeDim);
        if (StringUtils.isEmpty((CharSequence)dimMem1)) {
            return row;
        }
        if (StringUtils.isEmpty((CharSequence)dimMem2) && StringUtils.isEmpty((CharSequence)dimMem3)) {
            return row;
        }
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        qFilter.and(new QFilter("relationid", "=", (Object)IDUtils.toLong((Object)relationId)));
        this.getCheckFilter(dimMemMap, qFilter);
        Object id = this.getModel().getValue("id", row);
        if (id == null || "".equals(id)) {
            if (QueryServiceHelper.exists((String)"epm_multidimmemrelation", (QFilter[])new QFilter[]{qFilter})) {
                return row;
            }
        } else {
            qFilter.and(new QFilter("id", "!=", (Object)IDUtils.toLong((Object)id)));
            boolean exists = QueryServiceHelper.exists((String)"epm_multidimmemrelation", (QFilter[])new QFilter[]{qFilter});
            if (exists) {
                return row;
            }
        }
        return -1;
    }

    private void getCheckFilter(Map<String, String> dimMemMap, QFilter qFilter) {
        long hashId = DimensionRelationUtils.getMembersKeyHashId(dimMemMap);
        qFilter.and(new QFilter("entryhashid", "=", (Object)hashId));
    }

    private Map<String, String> getDimMemByRow(int rowIndex) {
        Map<String, String> f72DimMap = this.getAllF7Map();
        LinkedHashMap<String, String> dimMemMap = new LinkedHashMap<String, String>(16);
        for (Map.Entry<String, String> dimKey : f72DimMap.entrySet()) {
            String f7key = dimKey.getKey();
            String dimNum = dimKey.getValue();
            String memnum = "";
            DynamicObject dimDynamicObject = (DynamicObject)this.getModel().getValue(f7key, rowIndex);
            if (dimDynamicObject != null) {
                memnum = dimDynamicObject.getString("number");
            }
            dimMemMap.put(dimNum, memnum);
        }
        return dimMemMap;
    }

    private String getSelectId(int row) {
        Object id = this.getModel().getValue("id", row);
        if (Objects.equals("", id)) {
            return null;
        }
        return id.toString();
    }

    private void deleteMember() {
        EntryGrid entity = (EntryGrid)this.getView().getControl(TREEENTRYENTITY);
        int[] rows = entity.getSelectRows();
        if (rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u884c\u3002", (String)"DimensionRelationListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u6240\u9009\u884c\uff1f", (String)"DimensionRelationListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleteRelationMember", (IFormPlugin)this));
    }

    private void addMemberEntry() {
        if (this.getPageCache().get(CURRENT_SCHEME_ID) != null) {
            EntryGrid treeEntry = (EntryGrid)this.getView().getControl(TREEENTRYENTITY);
            this.getModel().createNewEntryRow(TREEENTRYENTITY);
            treeEntry.selectRows(treeEntry.getEntryData().getEndIndex() - 1);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u5173\u7cfb\u3002", (String)"DimensionRelationListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private QFilter getDimQFilter(String dimkey, String dimNum) {
        QFilter qf = null;
        long modelId = this.getModelId();
        qf = this.getViewQFilter(dimkey, dimNum);
        qf.and(new QFilter("model", "=", (Object)modelId));
        qf.and("level", ">", (Object)1);
        if (dimkey.contains("custom")) {
            qf.and(new QFilter("dimension.number", "=", (Object)dimNum));
        } else if (dimkey.equals("entity")) {
            qf.and(new QFilter("number", "!=", (Object)"RatePreset"));
        } else if (dimkey.equals("version")) {
            qf.and("isactual", "!=", (Object)"1");
        } else if (dimkey.equals("year")) {
            qf.and("longnumber", "like", (Object)"Year!AllYear!%");
        }
        return qf;
    }

    private QFilter getViewQFilter(String dimKey, String dimNum) {
        Map<String, Map<String, String>> dimsMap = this.getRelationSchemeDims();
        String viewId = null;
        if (dimsMap.containsKey(dimNum)) {
            viewId = dimsMap.get(dimNum).get("viewid");
        }
        String memberkey = SysDimensionEnum.getMemberTreemodelByNumberIgnoreCase((String)dimNum);
        HashSet<String> numberSet = new HashSet<String>(16);
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)this.getModelId());
        qfBuilder.add("enable", "=", (Object)"1");
        boolean isBaseView = this.isBaseView(viewId);
        if ("changetype".equals(dimKey)) {
            if (isBaseView) {
                viewId = String.valueOf(DimensionViewServiceHelper.getInstance().queryBaseViewIdByNumber(this.getModelId(), SysDimensionEnum.ChangeType.getNumber()));
            }
            qfBuilder.add(new QFilter("view", "=", (Object)Long.valueOf(viewId)).or("view", "=", (Object)0L));
        } else if ("entity".equals(dimKey) && isBaseView) {
            qfBuilder.add(new QFilter("offsetsource", "!=", (Object)"2"));
        } else if (!isBaseView) {
            qfBuilder.add("view", "=", (Object)Long.valueOf(viewId));
            memberkey = "eb_viewmember";
            qfBuilder.add("isleaf", "=", (Object)true);
        }
        DynamicObjectCollection members = QueryServiceHelper.query((String)memberkey, (String)"id, number", (QFilter[])qfBuilder.toArray());
        for (DynamicObject member : members) {
            numberSet.add(member.getString("number"));
        }
        return new QFilter("number", "in", numberSet);
    }

    private boolean isBaseView(String viewId) {
        if ("0".equals(viewId)) {
            return true;
        }
        DynamicObject view = QueryServiceHelper.queryOne((String)"eb_dimensionview", (String)"source", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)IDUtils.toLong((Object)viewId))});
        return view == null || !"0".equals(view.getString("source"));
    }

    private QFilter getMemberQFilter(String relationId) {
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        qFilter.and(new QFilter("relationid", "=", (Object)IDUtils.toLong((Object)relationId)));
        return qFilter;
    }

    private void memberMove(String key) {
        if (this.checkSelectEntry().booleanValue()) {
            return;
        }
        EntryGrid treeEntry = (EntryGrid)this.getView().getControl(TREEENTRYENTITY);
        int[] rows = treeEntry.getSelectRows();
        if (rows == null || rows.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"DimensionRelationListPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        int exchangerow = -1;
        if (BTN_DOWNMOVE.equals(key)) {
            if (rows[0] == treeEntry.getEntryData().getEndIndex() - 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u884c\uff0c\u65e0\u6cd5\u4e0b\u79fb\u3002", (String)"DimensionRelationListPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            exchangerow = rows[0] + 1;
        } else {
            if (0 == rows[0]) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u662f\u7b2c\u4e00\u884c\uff0c\u65e0\u6cd5\u4e0a\u79fb\u3002", (String)"DimensionRelationListPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            exchangerow = rows[0] - 1;
        }
        this.exchangeRows(rows[0], exchangerow);
    }

    private void memberSearch(String text) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(TREEENTRYENTITY);
        int selectRow = -1;
        Map<String, Map<String, String>> dimsMap = this.getRelationSchemeDims();
        ArrayList<Integer> searchResult = new ArrayList<Integer>(16);
        int maxIndex = entryGrid.getEntryData().getEndIndex();
        Map<String, String> f72DimMap = this.getAllF7Map();
        Map<String, String> dim2F7Map = f72DimMap.entrySet().stream().collect(Collectors.toMap(tem -> (String)tem.getValue(), tem -> (String)tem.getKey()));
        for (int i = 0; i < maxIndex; ++i) {
            Boolean exists = false;
            for (String dimKey : dimsMap.keySet()) {
                String f7key = dim2F7Map.get(dimKey);
                DynamicObject dimDynamicObject = (DynamicObject)this.getModel().getValue(f7key, i);
                if (dimDynamicObject == null || !dimDynamicObject.getString("number").toLowerCase().contains(text) && !dimDynamicObject.getString("name").toLowerCase().contains(text)) continue;
                exists = true;
                break;
            }
            if (!exists.booleanValue()) continue;
            if (selectRow == -1) {
                selectRow = i;
            }
            searchResult.add(i);
        }
        if (selectRow == -1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u4fe1\u606f\u3002", (String)"DimensionRelationListPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        entryGrid.selectRows(selectRow);
        this.getPageCache().put("memberSearchResult", ObjectSerialUtil.toByteSerialized(searchResult));
    }

    private void relationSearch(String text) {
        TreeView treeView = (TreeView)this.getControl(DIMRELATTREE);
        String rootCache = this.getPageCache().get("rootNode");
        if (StringUtils.isEmpty((CharSequence)rootCache)) {
            return;
        }
        TreeNode focusNode = null;
        ArrayList<TreeNode> resultNode = new ArrayList<TreeNode>(16);
        TreeNode root = (TreeNode)ObjectSerialUtil.deSerializedBytes((String)rootCache);
        List childNode = root.getChildren();
        if (childNode == null) {
            return;
        }
        for (TreeNode cNode : childNode) {
            String info = cNode.getText().trim();
            if (!info.contains(text)) continue;
            if (focusNode == null) {
                focusNode = cNode;
            }
            resultNode.add(cNode);
        }
        if (focusNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u4fe1\u606f\u3002", (String)"DimensionRelationListPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        treeView.focusNode(focusNode);
        this.getPageCache().put("relatSearchResult", ObjectSerialUtil.toByteSerialized(resultNode));
    }

    private void dimUpAndDown(String key) {
        String resultCache = this.getPageCache().get("relatSearchResult");
        if (StringUtils.isEmpty((CharSequence)resultCache)) {
            return;
        }
        int currentNodeIndex = -1;
        List nodes = (List)ObjectSerialUtil.deSerializedBytes((String)resultCache);
        TreeView treeView = (TreeView)this.getControl(DIMRELATTREE);
        Map focusNode = treeView.getTreeState().getFocusNode();
        TreeNode node = null;
        for (int i = 0; i < nodes.size(); ++i) {
            node = (TreeNode)nodes.get(i);
            if (!node.getId().equalsIgnoreCase(focusNode.get("id").toString())) continue;
            currentNodeIndex = i;
            break;
        }
        if (currentNodeIndex == -1) {
            treeView.focusNode((TreeNode)nodes.get(0));
        } else if (currentNodeIndex == 0 && UPDIMRELAT.equals(key)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u662f\u7b2c\u4e00\u884c\u6570\u636e\u3002", (String)"DimensionRelationListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (currentNodeIndex == nodes.size() - 1 && DOWNDIMRELAT.equals(key)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u662f\u6700\u540e\u4e00\u884c\u6570\u636e\u3002", (String)"DimensionRelationListPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            currentNodeIndex = UPDIMRELAT.equals(key) ? --currentNodeIndex : ++currentNodeIndex;
            treeView.focusNode((TreeNode)nodes.get(currentNodeIndex));
        }
    }

    private void memberUpAndDown(String key) {
        String resultCache = this.getPageCache().get("memberSearchResult");
        if (StringUtils.isEmpty((CharSequence)resultCache)) {
            return;
        }
        int currentRowIndex = -1;
        List rows = (List)ObjectSerialUtil.deSerializedBytes((String)resultCache);
        EntryGrid entryGrid = (EntryGrid)this.getControl(TREEENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length != 1) {
            entryGrid.selectRows(((Integer)rows.get(0)).intValue());
            return;
        }
        for (int i = 0; i < rows.size(); ++i) {
            int row = (Integer)rows.get(i);
            if (row != selectRows[0]) continue;
            currentRowIndex = i;
            break;
        }
        if (currentRowIndex == -1) {
            entryGrid.selectRows(((Integer)rows.get(0)).intValue());
        } else if (currentRowIndex == 0 && UPMEMBER.equals(key)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u662f\u7b2c\u4e00\u884c\u6570\u636e\u3002", (String)"DimensionRelationListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (currentRowIndex == rows.size() - 1 && DOWNMEMBER.equals(key)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u662f\u6700\u540e\u4e00\u884c\u6570\u636e\u3002", (String)"DimensionRelationListPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            currentRowIndex = UPMEMBER.equals(key) ? --currentRowIndex : ++currentRowIndex;
            entryGrid.selectRows(((Integer)rows.get(currentRowIndex)).intValue());
        }
    }

    private void exchangeRows(int row, int exchangerow) {
        EntryGrid treeEntry = (EntryGrid)this.getControl(TREEENTRYENTITY);
        String userId = RequestContext.get().getUserId();
        Date modifytime = TimeServiceHelper.now();
        DynamicObject moveDynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(this.getModel().getValue("id", row).toString()), (String)"epm_multidimmemrelation");
        moveDynamicObject.set("dseq", (Object)exchangerow);
        moveDynamicObject.set("modifier", (Object)userId);
        moveDynamicObject.set("modifytime", (Object)modifytime);
        DynamicObject exchangeDynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(this.getModel().getValue("id", exchangerow).toString()), (String)"epm_multidimmemrelation");
        exchangeDynamicObject.set("dseq", (Object)row);
        exchangeDynamicObject.set("modifier", (Object)userId);
        exchangeDynamicObject.set("modifytime", (Object)modifytime);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{moveDynamicObject, exchangeDynamicObject});
        this.refreshBilllist();
        treeEntry.selectRows(exchangerow);
    }

    private TreeNode getNode(String nodeId) {
        String rootCache = this.getPageCache().get("rootNode");
        TreeNode root = (TreeNode)ObjectSerialUtil.deSerializedBytes((String)rootCache);
        return root.getTreeNode(nodeId, 10);
    }

    private Boolean checkSelectEntry() {
        int[] rows;
        EntryGrid treeEntry = (EntryGrid)this.getControl(TREEENTRYENTITY);
        for (int row : rows = treeEntry.getSelectRows()) {
            Object seq = this.getModel().getValue("id", row);
            if (!Objects.isNull(seq) && !seq.equals("")) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7684\u6570\u636e\u4e2d\u5305\u542b\u672a\u4fdd\u5b58\u7684\u6570\u636e\uff0c\u8bf7\u5148\u4fdd\u5b58\u3002", (String)"DimensionRelationListPlugin_58", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void importExcel() {
        Long modelId = this.getModelId();
        String schemeId = this.getSchememId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"DimensionRelationListPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isEmpty((CharSequence)schemeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u5173\u7cfb\u3002", (String)"DimensionRelationListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, Map<String, String>> dimsMap = this.getRelationSchemeDims();
        String firstDim = this.getDimInfoByKey(dimsMap, 0, "dimnum");
        String secondDim = this.getDimInfoByKey(dimsMap, 1, "dimnum");
        String threeDim = this.getDimInfoByKey(dimsMap, 2, "dimnum");
        if (StringUtils.isEmpty((CharSequence)firstDim)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u53d6\u7ef4\u5ea6\u4e00", (String)"DimensionRelationListPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isEmpty((CharSequence)secondDim)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u53d6\u7ef4\u5ea6\u4e8c", (String)"DimensionRelationListPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isEmpty((CharSequence)threeDim)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u7ef4\u5ea6\u4e09\u201d\u3002", (String)"MultiDimensionRelationListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> openParameter = new HashMap<String, String>(16);
        openParameter.put("formId", "epm_import");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(openParameter);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("model", (Object)modelId);
        showParameter.setCustomParam(CURRENT_SCHEME_ID, (Object)schemeId);
        showParameter.setCustomParam(DIMENSIONMAP, (Object)SerializationUtils.toJsonString(this.getRelationSchemeDims()));
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)"epm_import");
        formConfig.getPlugins().clear();
        showParameter.setFormConfig(formConfig);
        showParameter.addCustPlugin("kd.epm.eb.formplugin.dimension.dimensionrelation.MultiDimensionRelationUploadPlugin");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBCAK_IMPORT_CLOSE));
        this.getView().showForm(showParameter);
    }

    private void exportExcel() {
        ArrayList<String[]> dataList = new ArrayList<String[]>(16);
        List<String[]> headDataList = this.getHeadDataList();
        Map<String, String> f72DimMap = this.getAllF7Map();
        List dimMapList = f72DimMap.keySet().stream().collect(Collectors.toList());
        if (dimMapList == null || dimMapList.size() == 0) {
            return;
        }
        String dimControlKey1 = (String)dimMapList.get(0);
        String dimControlKey2 = (String)dimMapList.get(1);
        String dimControlKey3 = (String)dimMapList.get(2);
        if (f72DimMap.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u5173\u7cfb\u3002", (String)"DimensionRelationListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        List<DynamicObject> exportRowDys = this.getExportRowDys();
        for (DynamicObject row : exportRowDys) {
            DynamicObject dim3Dy;
            DynamicObject dim2Dy;
            String[] data = null;
            String stateStr = row.getBoolean("status") ? ResManager.loadKDString((String)"\u542f\u7528", (String)"DimensionRelationListPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7981\u7528", (String)"DimensionRelationListPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            String firstMemNum = "";
            String firstMemName = "";
            String secondMemNum = "";
            String secondMemName = "";
            String threeMemNum = "";
            String threeMemName = "";
            DynamicObject dim1Dy = row.getDynamicObject(dimControlKey1);
            if (dim1Dy != null) {
                firstMemNum = dim1Dy.getString("number");
                firstMemName = dim1Dy.getString("name");
            }
            if ((dim2Dy = row.getDynamicObject(dimControlKey2)) != null) {
                secondMemNum = dim2Dy.getString("number");
                secondMemName = dim2Dy.getString("name");
            }
            if ((dim3Dy = row.getDynamicObject(dimControlKey3)) != null) {
                threeMemNum = dim3Dy.getString("number");
                threeMemName = dim3Dy.getString("name");
            }
            data = new String[]{firstMemNum, firstMemName, secondMemNum, secondMemName, threeMemNum, threeMemName, stateStr};
            dataList.add(data);
        }
        String filename = this.getFileName();
        ExcelImExportUtils.Sheet sheet = new ExcelImExportUtils.Sheet(0, 2, 0, 0);
        String url = ExcelImExportUtils.getInstance().writeWithTemplate(tempPath, filename, headDataList, dataList, sheet);
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
    }

    private List<DynamicObject> getExportRowDys() {
        ArrayList<DynamicObject> rowDys = new ArrayList<DynamicObject>(16);
        EntryGrid treeEntry = (EntryGrid)this.getControl(TREEENTRYENTITY);
        int[] rows = treeEntry.getSelectRows();
        DynamicObject dataEntity = this.getModel().getDataEntity(Boolean.TRUE.booleanValue());
        if (rows == null || rows.length == 0) {
            rowDys.addAll((Collection<DynamicObject>)dataEntity.getDynamicObjectCollection(TREEENTRYENTITY));
        } else {
            for (int i : rows) {
                rowDys.add((DynamicObject)dataEntity.getDynamicObjectCollection(TREEENTRYENTITY).get(i));
            }
        }
        return rowDys;
    }

    private String getFileName() {
        Map<String, Map<String, String>> dimsMap = this.getRelationSchemeDims();
        String dimname1 = this.getDimInfoByKey(dimsMap, 0, "dimname");
        String dimname2 = this.getDimInfoByKey(dimsMap, 1, "dimname");
        String dimname3 = this.getDimInfoByKey(dimsMap, 2, "dimname");
        String dimRelationName = dimname1 + "_" + dimname2 + "_" + dimname3;
        String filename = ResManager.loadResFormat((String)"\u7ef4\u5ea6(%1)\u6210\u5458\u4f9d\u8d56\u5173\u7cfb_%2", (String)"DimensionRelationListPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[]{dimRelationName, DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        return filename;
    }

    private List<String[]> getHeadDataList() {
        Map<String, Map<String, String>> dimsMap = this.getRelationSchemeDims();
        String dimnum1 = this.getDimInfoByKey(dimsMap, 0, "dimnum");
        String dimname1 = this.getDimInfoByKey(dimsMap, 0, "dimname");
        String dimnum2 = this.getDimInfoByKey(dimsMap, 1, "dimnum");
        String dimname2 = this.getDimInfoByKey(dimsMap, 1, "dimname");
        String dimnum3 = this.getDimInfoByKey(dimsMap, 2, "dimnum");
        String dimname3 = this.getDimInfoByKey(dimsMap, 2, "dimname");
        String numFormat = ResManager.loadKDString((String)"*\u6210\u5458\u7f16\u7801\uff08%s\uff09", (String)"DimensionRelationListPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String nameFormat = ResManager.loadKDString((String)"\u6210\u5458\u540d\u79f0\uff08%s\uff09", (String)"DimensionRelationListPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String stateHead = ResManager.loadKDString((String)"*\u72b6\u6001", (String)"DimensionRelationListPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String[] headData = new String[]{String.format(numFormat, dimnum1), String.format(nameFormat, dimname1), String.format(numFormat, dimnum2), String.format(nameFormat, dimname2), String.format(numFormat, dimnum3), String.format(nameFormat, dimname3), stateHead};
        ArrayList<String[]> headDataList = new ArrayList<String[]>(16);
        headDataList.add(headData);
        return headDataList;
    }

    private String getDimInfoByKey(Map<String, Map<String, String>> dimsMap, int index, String key) {
        String value = "";
        int pos = 0;
        for (Map.Entry<String, Map<String, String>> entry : dimsMap.entrySet()) {
            if (pos == index) {
                value = entry.getValue().get(key);
                break;
            }
            ++pos;
        }
        return value;
    }

    private void dimSelectCloseBack(ClosedCallBackEvent event) {
        IDataModel model = this.getModel();
        if (event.getReturnData() == null) {
            return;
        }
        String key = event.getActionId();
        if (!customDimSet.contains(key) && !dimSet.contains(key)) {
            return;
        }
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)event.getReturnData();
        if (returnData == null || returnData.size() == 0) {
            return;
        }
        String dimPosKey = this.getCacheDimPosKey(key);
        String startRowStr = this.getPageCache().get(dimPosKey);
        int startRow = Integer.parseInt(startRowStr);
        this.getModel().setValue(key, returnData.get(0).getPrimaryKeyValue(), startRow);
        int entryCount = model.getEntryRowCount(TREEENTRYENTITY);
        if (returnData.size() > 1) {
            for (int i = 1; i < returnData.size(); ++i) {
                int curentPos = startRow + i;
                if (curentPos >= entryCount) {
                    curentPos = model.insertEntryRow(TREEENTRYENTITY, curentPos);
                } else if (model.getValue(key, curentPos) != null) {
                    curentPos = model.insertEntryRow(TREEENTRYENTITY, curentPos);
                }
                model.setValue(key, returnData.get(i).getPrimaryKeyValue(), curentPos);
            }
        }
    }

    private String getCacheDimPosKey(String key) {
        return key + "_index";
    }
}

