/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.dimensionrelation;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.DimRelationScope;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class MultiDimensionRelationPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    private static final String BUSINESSMODEL = "businessmodel";
    private static final String DIMENSION_FIRST = "dimension1";
    private static final String DIMENSION_SECOND = "dimension2";
    private static final String DIMENSION_THREE = "dimension3";
    private static final String FIRST_DIMENSION_VIEW = "dimensionview1";
    private static final String SECOND_DIMENSION_VIEW = "dimensionview2";
    private static final String THREE_DIMENSION_VIEW = "dimensionview3";
    private static final String AFFECTRANGE = "affectrange";
    private static final String CACHEKEY_DIMENSION = "cacheKeyDimension";
    private static final String CACHEKEYBINDDATAFLAG = "cacheKeyBindDataFlag";
    private Map<String, Long> dimensionCache = new HashMap<String, Long>(16);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, new String[]{BUSINESSMODEL, DIMENSION_FIRST, DIMENSION_SECOND, DIMENSION_THREE, FIRST_DIMENSION_VIEW, SECOND_DIMENSION_VIEW, THREE_DIMENSION_VIEW});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("model", this.getView().getFormShowParameter().getCustomParam("modelId"));
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getPageCache().put(CACHEKEYBINDDATAFLAG, "1");
        if (this.isModify().booleanValue()) {
            this.loadFromDimensionEntry();
            this.getModel().getValue(BUSINESSMODEL);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        this.setViewEnable();
        this.setBusinessModelVisible();
        if (this.isModify().booleanValue()) {
            this.setEnable();
        }
        model.setDataChanged(false);
        this.getPageCache().remove(CACHEKEYBINDDATAFLAG);
    }

    private void setDimensionEntry() {
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        int rowIndex1 = model.createNewEntryRow("entryentity");
        model.setValue("dimension", model.getValue(DIMENSION_FIRST), rowIndex1);
        model.setValue("dimensionview", model.getValue(FIRST_DIMENSION_VIEW), rowIndex1);
        model.setValue("ismaindim", (Object)"1", rowIndex1);
        int rowIndex2 = model.createNewEntryRow("entryentity");
        model.setValue("dimension", model.getValue(DIMENSION_SECOND), rowIndex2);
        model.setValue("dimensionview", model.getValue(SECOND_DIMENSION_VIEW), rowIndex2);
        model.setValue("ismaindim", (Object)"0", rowIndex2);
        int rowIndex3 = model.createNewEntryRow("entryentity");
        model.setValue("dimension", model.getValue(DIMENSION_THREE), rowIndex3);
        model.setValue("dimensionview", model.getValue(THREE_DIMENSION_VIEW), rowIndex3);
        model.setValue("ismaindim", (Object)"0", rowIndex3);
    }

    private void loadFromDimensionEntry() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryRows = model.getDataEntity().getDynamicObjectCollection("entryentity");
        int order = 1;
        for (int i = 0; i < entryRows.size() && i < 3; ++i) {
            model.setValue("dimension" + order, (Object)((DynamicObject)entryRows.get(i)).getDynamicObject("dimension"));
            model.setValue("dimensionview" + order, (Object)((DynamicObject)entryRows.get(i)).getDynamicObject("dimensionview"));
            ++order;
        }
    }

    private void setEnable() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        if (this.checkInUse().booleanValue()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BUSINESSMODEL, DIMENSION_FIRST, DIMENSION_SECOND, DIMENSION_THREE, FIRST_DIMENSION_VIEW, SECOND_DIMENSION_VIEW, THREE_DIMENSION_VIEW, AFFECTRANGE});
        } else {
            this.setViewEnable();
        }
        this.setBusinessModelVisible();
    }

    private Boolean checkInUse() {
        boolean isUse = false;
        Object object = this.getModel().getValue("id");
        if (object != null) {
            String id = object.toString();
            isUse = QueryServiceHelper.exists((String)"epm_multidimmemrelation", (QFilter[])new QFilter[]{new QFilter("relationid", "=", (Object)IDUtils.toLong((Object)id))});
        }
        return isUse;
    }

    private void setBusinessModelVisible() {
        boolean isVisible = false;
        Object range = this.getModel().getValue(AFFECTRANGE);
        if (range != null) {
            isVisible = DimRelationScope.BIZMODEL.getIndex().equals(range);
        }
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{BUSINESSMODEL});
    }

    private void setViewEnable() {
        this.setViewEnable(DIMENSION_FIRST, this.getViewByDim(DIMENSION_FIRST));
        this.setViewEnable(DIMENSION_SECOND, this.getViewByDim(DIMENSION_SECOND));
        this.setViewEnable(DIMENSION_THREE, this.getViewByDim(DIMENSION_THREE));
    }

    private void setViewEnable(String dimKey, String viewKey) {
        boolean enable = false;
        DynamicObject dim = (DynamicObject)this.getModel().getValue(dimKey);
        if (dim != null) {
            enable = this.checkHasView(dim);
        }
        this.getView().setEnable(Boolean.valueOf(enable), new String[]{viewKey});
    }

    private Boolean checkHasView(DynamicObject dimension) {
        String dimNumber = dimension.getString("number");
        if (SysDimensionEnum.ChangeType.getNumber().equals(dimNumber) || SysDimensionEnum.AuditTrail.getNumber().equals(dimNumber)) {
            return false;
        }
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        qFilter.and(new QFilter("dimension", "=", (Object)dimension.getLong("id")));
        return QueryServiceHelper.exists((String)"eb_dimensionview", (QFilter[])new QFilter[]{qFilter});
    }

    private List<DynamicObject> getBusinessModel() {
        DynamicObject dimension = (DynamicObject)this.getModel().getValue(DIMENSION_FIRST);
        long dimensionId1 = dimension.getLong("id");
        long view1 = this.getViewId(DIMENSION_FIRST, dimension);
        dimension = (DynamicObject)this.getModel().getValue(DIMENSION_SECOND);
        long dimensionId2 = dimension.getLong("id");
        long view2 = this.getViewId(DIMENSION_SECOND, dimension);
        dimension = (DynamicObject)this.getModel().getValue(DIMENSION_THREE);
        long view3 = this.getViewId(DIMENSION_THREE, dimension);
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        DynamicObject[] bizModel = BusinessDataServiceHelper.load((String)"eb_businessmodel", (String)"viewentry.dimension, viewentry.view", (QFilter[])new QFilter[]{qFilter});
        ArrayList<DynamicObject> retBiz = new ArrayList<DynamicObject>(16);
        for (DynamicObject bizmodel : bizModel) {
            DynamicObjectCollection viewEntry = bizmodel.getDynamicObjectCollection("viewentry");
            HashSet<Long> dimensionIds = new HashSet<Long>(16);
            HashSet<Long> viewIds = new HashSet<Long>(16);
            for (DynamicObject infos : viewEntry) {
                dimensionIds.add(infos.getLong("dimension_id"));
                long viewId = infos.getLong("view_id");
                if (viewId == 0L) continue;
                viewIds.add(viewId);
            }
            if (!dimensionIds.contains(dimensionId1) || !dimensionIds.contains(dimensionId2) || view1 != 0L && !viewIds.contains(view1) || view2 != 0L && !viewIds.contains(view2) || view3 != 0L && !viewIds.contains(view3)) continue;
            retBiz.add(bizmodel);
        }
        return retBiz;
    }

    private Long getViewId(String dimKey, DynamicObject dimension) {
        long view = 0L;
        if (this.checkHasView(dimension).booleanValue()) {
            DynamicObject object = (DynamicObject)this.getModel().getValue(this.getViewByDim(dimKey));
            if (object != null) {
                view = object.getLong("id");
            } else {
                QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
                qFilter.and(new QFilter("dimension", "=", (Object)dimension.getLong("id")));
                qFilter.and(new QFilter("source", "=", (Object)"1"));
                DynamicObject query = QueryServiceHelper.queryOne((String)"eb_dimensionview", (String)"id", (QFilter[])new QFilter[]{qFilter});
                if (query != null) {
                    view = query.getLong("id");
                }
            }
        }
        return view;
    }

    @Override
    public Long getModelId() {
        return ((DynamicObject)this.getModel().getValue("model")).getLong("id");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "affectrange": {
                this.setBusinessModelVisible();
            }
            case "dimensionview1": 
            case "dimensionview2": 
            case "dimensionview3": {
                Boolean isBindData = this.isBindData();
                if (isBindData.booleanValue()) break;
                this.getModel().setValue(BUSINESSMODEL, null);
                break;
            }
            case "dimension1": 
            case "dimension2": 
            case "dimension3": {
                this.afterSelectDimension(e, key);
            }
        }
    }

    private Boolean isBindData() {
        String bingDataFalg = this.getPageCache().get(CACHEKEYBINDDATAFLAG);
        return !StringUtils.isEmpty((String)bingDataFalg) && bingDataFalg.equals("1");
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        Long id = (Long)this.getModel().getValue("id");
        if (id != 0L) {
            this.getView().returnDataToParent((Object)id);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getSource() instanceof Save && args.getOperationResult().isSuccess()) {
            this.getView().close();
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            this.checkRequireField();
            this.validate();
            this.setDimensionEntry();
            if (!this.isModify().booleanValue()) {
                Object seqObj = this.getView().getFormShowParameter().getCustomParam("dseq");
                if (Objects.isNull(seqObj)) {
                    this.getModel().setValue("dseq", (Object)1);
                } else {
                    this.getModel().setValue("dseq", (Object)(Integer.parseInt(seqObj.toString()) + 1));
                }
                this.getModel().setValue("createtime", (Object)TimeServiceHelper.now());
                this.getModel().setValue("creator", (Object)RequestContext.get().getUserId());
            }
            this.getModel().setValue("modifytime", (Object)TimeServiceHelper.now());
            this.getModel().setValue("modifier", (Object)RequestContext.get().getUserId());
        }
    }

    private void checkRequireField() {
        ArrayList<String> tips = new ArrayList<String>(16);
        Object name = this.getModel().getValue("name");
        Object number = this.getModel().getValue("number");
        Object dimension1 = this.getModel().getValue(DIMENSION_FIRST);
        Object dimension2 = this.getModel().getValue(DIMENSION_SECOND);
        Object dimension3 = this.getModel().getValue(DIMENSION_THREE);
        Object affectrange = this.getModel().getValue(AFFECTRANGE);
        if (number == null || StringUtils.isEmpty((String)number.toString())) {
            tips.add(ResManager.loadKDString((String)"\u7f16\u7801", (String)"MultiDimensionRelationPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (name == null || StringUtils.isEmpty((String)name.toString())) {
            tips.add(ResManager.loadKDString((String)"\u540d\u79f0", (String)"MultiDimensionRelationPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (dimension1 == null || StringUtils.isEmpty((String)dimension1.toString())) {
            tips.add(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4e00", (String)"MultiDimensionRelationPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (dimension2 == null || StringUtils.isEmpty((String)dimension2.toString())) {
            tips.add(ResManager.loadKDString((String)"\u5173\u8054\u7ef4\u5ea6\u4e00", (String)"MultiDimensionRelationPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (dimension3 == null || StringUtils.isEmpty((String)dimension3.toString())) {
            tips.add(ResManager.loadKDString((String)"\u5173\u8054\u7ef4\u5ea6\u4e8c", (String)"MultiDimensionRelationPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (affectrange == null || StringUtils.isEmpty((String)affectrange.toString())) {
            tips.add(ResManager.loadKDString((String)"\u5f71\u54cd\u8303\u56f4", (String)"MultiDimensionRelationPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (CollectionUtils.isNotEmpty(tips)) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u586b\u5199%1\u3002", (String)"MultiDimensionRelationPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", tips)}));
        }
    }

    protected boolean checkSepcialNumber(String value) {
        String regEx = "^(?!_)[-a-zA-Z0-9_.]+$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(value);
        if (!matcher.matches()) {
            return true;
        }
        return value.contains("..") || value.startsWith(".") || value.startsWith("-");
    }

    private void validate() {
        Object number = this.getModel().getValue("number");
        Object name = this.getModel().getValue("name");
        if (Objects.nonNull(number)) {
            String num = number.toString().trim();
            if (this.checkSepcialNumber(num)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u53ef\u80fd\u5305\u542b\u4e2d\u6587\u3001\u7279\u6b8a\u5b57\u7b26\u6216\u8005\u4ee5\u7279\u6b8a\u5b57\u7b26\u5f00\u5934\u3002", (String)"AccountMemberImport_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (this.checkNumberRepeat(num)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\u3002", (String)"DimensionRelationPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((String)num) || StringUtils.isEmpty((String)name.toString())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u6216\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"DimMemberMappingPlugin_44", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (number.toString().matches("[\u4e00-\u9fa5]+")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u5141\u8bb8\u8f93\u5165\u4e2d\u6587\u3002", (String)"DimensionRelationPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean checkNumberRepeat(String number) {
        if (!this.isModify().booleanValue()) {
            QFilter qf = new QFilter("model", "=", (Object)this.getModelId());
            qf.and(new QFilter("number", "=", (Object)number));
            return QueryServiceHelper.exists((String)"epm_multidimrelation", (QFilter[])new QFilter[]{qf});
        }
        return false;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key;
        switch (key = event.getProperty().getName()) {
            case "businessmodel": {
                this.businessModelBeforeF7(event);
                break;
            }
            case "dimension1": 
            case "dimension2": 
            case "dimension3": {
                this.dimensionBeforeF7(event, key);
                break;
            }
            case "dimensionview1": 
            case "dimensionview2": 
            case "dimensionview3": {
                this.beforeSelectView(event, key);
                break;
            }
        }
    }

    private void dimensionBeforeF7(BeforeF7SelectEvent event, String key) {
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"epm_dimension", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (doc == null || doc.size() == 0) {
            return;
        }
        Set dimensionId = doc.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        Set<Long> otherDimIds = this.getOtherDims(key);
        dimensionId.removeAll(otherDimIds);
        if (event.getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(key)).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>(16);
            }
            qFilterList.add(new QFilter("id", "in", dimensionId));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    private Set<Long> getOtherDims(String key) {
        HashSet<Long> result = new HashSet<Long>(16);
        ArrayList<String> dimKeys = new ArrayList<String>(16);
        dimKeys.add(DIMENSION_FIRST);
        dimKeys.add(DIMENSION_SECOND);
        dimKeys.add(DIMENSION_THREE);
        dimKeys.remove(key);
        Map<String, Long> dimensionMap = this.getDimensionCache();
        for (String dimKey : dimKeys) {
            result.add(dimensionMap.get(dimKey));
        }
        return result;
    }

    private void businessModelBeforeF7(BeforeF7SelectEvent event) {
        DynamicObject dimension = (DynamicObject)this.getModel().getValue(DIMENSION_FIRST);
        if (dimension == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6\u4e00\u3002", (String)"DimensionRelationPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        dimension = (DynamicObject)this.getModel().getValue(DIMENSION_SECOND);
        if (dimension == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6\u4e8c\u3002", (String)"DimensionRelationPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        dimension = (DynamicObject)this.getModel().getValue(DIMENSION_THREE);
        if (dimension == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6\u4e09\u3002", (String)"DimensionRelationPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        List<DynamicObject> doc = this.getBusinessModel();
        Set businessModelId = doc.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        if (event.getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(BUSINESSMODEL)).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>(16);
            }
            qFilterList.add(new QFilter("id", "in", businessModelId));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    private void beforeSelectView(BeforeF7SelectEvent event, String key) {
        DynamicObject dim = null;
        if (FIRST_DIMENSION_VIEW.equals(key)) {
            dim = (DynamicObject)this.getModel().getValue(DIMENSION_FIRST);
        } else if (SECOND_DIMENSION_VIEW.equals(key)) {
            dim = (DynamicObject)this.getModel().getValue(DIMENSION_SECOND);
        } else if (THREE_DIMENSION_VIEW.equals(key)) {
            dim = (DynamicObject)this.getModel().getValue(DIMENSION_THREE);
        }
        if (event.getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(key)).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>(16);
            }
            if (dim != null) {
                qFilterList.add(new QFilter("dimension", "=", (Object)dim.getLong("id")));
            }
            qFilterList.add(new QFilter("model", "=", (Object)this.getModelId()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    private void afterSelectDimension(PropertyChangedArgs e, String key) {
        long dimensionId = 0L;
        ChangeData[] data = e.getChangeSet();
        if (data == null || data.length == 0) {
            return;
        }
        Object value = data[0].getNewValue();
        if (value != null) {
            dimensionId = ((DynamicObject)value).getLong("id");
            this.setDimensionCache(key, dimensionId);
            this.getModel().setValue(this.getViewByDim(key), null);
            this.setViewEnable(key, this.getViewByDim(key));
            Boolean isBindData = this.isBindData();
            if (!isBindData.booleanValue()) {
                this.getModel().setValue(BUSINESSMODEL, null);
            }
        }
    }

    private String getViewByDim(String key) {
        HashMap<String, String> dimViewMap = new HashMap<String, String>(16);
        dimViewMap.put(DIMENSION_FIRST, FIRST_DIMENSION_VIEW);
        dimViewMap.put(DIMENSION_SECOND, SECOND_DIMENSION_VIEW);
        dimViewMap.put(DIMENSION_THREE, THREE_DIMENSION_VIEW);
        return (String)dimViewMap.get(key);
    }

    private Map<String, Long> getDimensionCache() {
        if (this.dimensionCache != null && this.dimensionCache.size() > 0) {
            return this.dimensionCache;
        }
        if (this.getPageCache().get(CACHEKEY_DIMENSION) != null) {
            this.dimensionCache = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHEKEY_DIMENSION), Map.class);
        }
        return this.dimensionCache;
    }

    private void setDimensionCache(String key, Long dimensionId) {
        Map<String, Long> dimensionMap = this.getDimensionCache();
        dimensionMap.put(key, dimensionId);
        this.dimensionCache = dimensionMap;
        String dimensionJsonStr = SerializationUtils.toJsonString(this.dimensionCache);
        this.getPageCache().put(CACHEKEY_DIMENSION, dimensionJsonStr);
    }

    private Boolean isModify() {
        boolean isModify = false;
        Object id = this.getModel().getValue("id");
        if (id != null) {
            isModify = Long.parseLong(id.toString()) != 0L;
        }
        return isModify;
    }
}

