/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.dimensionrelation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.excel.ExcelImExportUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.dimension.dimensionrelation.DimensionRelationUtils;
import kd.epm.eb.formplugin.dimension.dimensionrelation.entity.DimMemRelationObj;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class MultiDimensionRelationUploadPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final String DIMENSIONMAP = "dims";
    private static final String CURRENT_SCHEME_ID = "currentNodeId";
    private static final String TEMPPATH = "dimensionrelation/multidimensionrelation.xlsx";
    Map<String, Map<String, String>> relationSchemeDims = null;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btndownload"});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"newandcover"});
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>(16);
        dataMap.put("maxatmcount", 1);
        this.getView().updateControlMetadata("attachmentpanelap", dataMap);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.importData();
                break;
            }
            case "btndownload": {
                this.downloadTemplate();
                break;
            }
        }
    }

    private void importData() {
        long count = 0L;
        ExcelImExportUtils.Sheet sheet = new ExcelImExportUtils.Sheet(0, 3, 0, 7);
        String file_url = this.getPageCache().get("file_url");
        List dataList = ExcelImExportUtils.getInstance().read(file_url, sheet);
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"MultiDimensionRelationUploadPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (!this.validExcel(dataList).booleanValue()) {
            this.getView().returnDataToParent((Object)-1L);
            this.getView().close();
            return;
        }
        List<DimMemRelationObj> mapObjList = this.toObj(dataList);
        count = this.saveImportData(mapObjList);
        this.getView().returnDataToParent((Object)count);
        this.getView().close();
    }

    private Boolean validExcel(List<String[]> dataList) {
        Boolean hasErr = Boolean.FALSE;
        if (dataList == null || dataList.size() == 0) {
            return hasErr;
        }
        Long modelId = this.getModelId();
        Map<String, Map<String, String>> dimsMap = this.getRelationSchemeDims();
        String dim1 = this.getDimInfoByKey(dimsMap, 0, "dimnum");
        long dimView1 = Long.parseLong(this.getDimInfoByKey(dimsMap, 0, "viewid"));
        String dim2 = this.getDimInfoByKey(dimsMap, 1, "dimnum");
        long dimView2 = Long.parseLong(this.getDimInfoByKey(dimsMap, 1, "viewid"));
        String dim3 = this.getDimInfoByKey(dimsMap, 2, "dimnum");
        long dimView3 = Long.parseLong(this.getDimInfoByKey(dimsMap, 2, "viewid"));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List allDim1Members = modelCache.getMembers(Long.valueOf(dimView1), dim1);
        List allDim2Members = modelCache.getMembers(Long.valueOf(dimView2), dim2);
        List allDim3Members = modelCache.getMembers(Long.valueOf(dimView3), dim3);
        for (int i = 0; i < dataList.size(); ++i) {
            Object[] row = dataList.get(i);
            String dimMem1 = row[0] == null ? "" : row[0];
            String dimMem2 = row[2] == null ? "" : row[2];
            String dimMem3 = row[4] == null ? "" : row[4];
            String status = row[6];
            ArrayList<String> errList = new ArrayList<String>(16);
            if (StringUtils.isEmpty((CharSequence)dimMem1)) {
                errList.add(ResManager.loadResFormat((String)"%1\u7684\u6210\u5458\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"DimensionRelationUploadPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[]{dim1}));
                hasErr = Boolean.TRUE;
            } else if (allDim1Members.stream().noneMatch(e -> e.getNumber().equals(dimMem1))) {
                errList.add(ResManager.loadResFormat((String)"%1\u975e\u7ef4\u5ea6\u201c%2\u201d\u7684\u6210\u5458\u3002", (String)"DimensionRelationUploadPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{dimMem1, dim1}));
                hasErr = Boolean.TRUE;
            }
            if (StringUtils.isEmpty((CharSequence)dimMem2) && StringUtils.isEmpty((CharSequence)dimMem3)) {
                errList.add(ResManager.loadResFormat((String)"%1\u7684\u6210\u5458\u4e0d\u5141\u8bb8\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"MultiDimensionRelationUploadPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{dim2}));
                hasErr = Boolean.TRUE;
            }
            if (!StringUtils.isEmpty((CharSequence)dimMem2) && allDim2Members.stream().noneMatch(e -> e.getNumber().equals(dimMem2))) {
                errList.add(ResManager.loadResFormat((String)"%1\u975e\u7ef4\u5ea6\u201c%2\u201d\u7684\u6210\u5458\u3002", (String)"DimensionRelationUploadPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{dimMem2, dim2}));
                hasErr = Boolean.TRUE;
            }
            if (!StringUtils.isEmpty((CharSequence)dimMem3) && allDim3Members.stream().noneMatch(e -> e.getNumber().equals(dimMem3))) {
                errList.add(ResManager.loadResFormat((String)"%1\u975e\u7ef4\u5ea6\u201c%2\u201d\u7684\u6210\u5458\u3002", (String)"DimensionRelationUploadPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{dimMem3, dim3}));
                hasErr = Boolean.TRUE;
            }
            if (dataList.stream().filter(e -> dimMem1.equals(e[0]) && dimMem2.equals(e[2]) && dimMem3.equals(e[4])).count() > 1L) {
                errList.add(ResManager.loadResFormat((String)"\u5b58\u5728\u6210\u5458\u7ec4\u5408\u7f16\u7801\u201c%1,%2,%3\u201d\u91cd\u590d\u7684\u884c\u3002", (String)"DimensionRelationUploadPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{dimMem1, dimMem2, dimMem3}));
                hasErr = Boolean.TRUE;
            }
            if (StringUtils.isEmpty((CharSequence)status)) {
                errList.add(ResManager.loadKDString((String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (String)"DimensionRelationUploadPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                hasErr = Boolean.TRUE;
            }
            if (!hasErr.booleanValue() || errList.size() <= 0) continue;
            dataList.set(i, (String[])ArrayUtils.add((Object[])row, (Object)String.join((CharSequence)",", errList)));
        }
        if (hasErr.booleanValue()) {
            String filename = this.getFileName(ResManager.loadKDString((String)"\u5bfc\u5165\u51fa\u9519\u8be6\u60c5", (String)"DimensionRelationUploadPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            List<String[]> headDataList = this.getHeadDataList();
            ExcelImExportUtils.Sheet sheet = new ExcelImExportUtils.Sheet(0, 2, 0, 0);
            String url = ExcelImExportUtils.getInstance().writeWithTemplate(TEMPPATH, filename, headDataList, dataList, sheet);
            ExcelImExportUtils.getInstance().download(this.getView(), url);
        }
        return hasErr == false;
    }

    private List<DimMemRelationObj> toObj(List<String[]> dataList) {
        Map<String, Map<String, String>> dimsMap = this.getRelationSchemeDims();
        String dim1 = this.getDimInfoByKey(dimsMap, 0, "dimnum");
        String dim1Name = this.getDimInfoByKey(dimsMap, 0, "dimname");
        String dim1View = this.getDimInfoByKey(dimsMap, 0, "viewid");
        String dim2 = this.getDimInfoByKey(dimsMap, 1, "dimnum");
        String dim2Name = this.getDimInfoByKey(dimsMap, 1, "dimname");
        String dim2View = this.getDimInfoByKey(dimsMap, 1, "viewid");
        String dim3 = this.getDimInfoByKey(dimsMap, 2, "dimnum");
        String dim3Name = this.getDimInfoByKey(dimsMap, 2, "dimname");
        String dim3View = this.getDimInfoByKey(dimsMap, 2, "viewid");
        ArrayList<DimMemRelationObj> objList = new ArrayList<DimMemRelationObj>(dataList.size());
        for (String[] row : dataList) {
            DimMemRelationObj relationObj = new DimMemRelationObj();
            relationObj.setDim1Num(dim1);
            relationObj.setDim1Name(dim1Name);
            relationObj.setDim1View(Long.parseLong(dim1View));
            relationObj.setMem1Num(row[0]);
            relationObj.setDim2Num(dim2);
            relationObj.setDim2Name(dim2Name);
            relationObj.setDim2View(Long.parseLong(dim2View));
            relationObj.setMem2Num(row[2]);
            relationObj.setDim3Num(dim3);
            relationObj.setDim3Name(dim3Name);
            relationObj.setDim3View(Long.parseLong(dim3View));
            relationObj.setMem3Num(row[4]);
            String stateStr = row[6];
            relationObj.setState(ResManager.loadKDString((String)"\u542f\u7528", (String)"DimensionRelationUploadPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(stateStr) ? Boolean.TRUE : Boolean.FALSE);
            objList.add(relationObj);
        }
        return objList;
    }

    private long saveImportData(List<DimMemRelationObj> mapObjList) {
        long count = 0L;
        if (mapObjList == null || mapObjList.size() == 0) {
            return count;
        }
        Map<Long, DynamicObject> existsDyMap = this.getExitstMemRelationDyMap();
        Long maxSeq = existsDyMap.values().stream().mapToLong(dy -> dy.getLong("dseq")).summaryStatistics().getMax();
        Map<String, Map<String, String>> dimsMap = this.getRelationSchemeDims();
        String dim1 = this.getDimInfoByKey(dimsMap, 0, "dimnum");
        String dim2 = this.getDimInfoByKey(dimsMap, 1, "dimnum");
        String dim3 = this.getDimInfoByKey(dimsMap, 2, "dimnum");
        ArrayList<DynamicObject> saveExistsDys = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> saveNewDys = new ArrayList<DynamicObject>(16);
        String userId = RequestContext.get().getUserId();
        Date time = TimeServiceHelper.now();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        for (DimMemRelationObj relationObj : mapObjList) {
            long curKey = this.getDimMemRelationObjKey(relationObj);
            if (existsDyMap.containsKey(curKey)) {
                DynamicObject existsDy = existsDyMap.get(curKey);
                existsDy.set("status", (Object)relationObj.getState());
                existsDy.set("modifier", (Object)userId);
                existsDy.set("modifytime", (Object)time);
                saveExistsDys.add(existsDy);
                continue;
            }
            DynamicObject newDy = BusinessDataServiceHelper.newDynamicObject((String)"epm_multidimmemrelation");
            maxSeq = maxSeq + 1L;
            newDy.set("dseq", (Object)maxSeq);
            newDy.set("relationid", (Object)Long.parseLong(this.getSchemeId()));
            newDy.set("entryhashid", (Object)curKey);
            newDy.set("model", (Object)this.getModelId());
            newDy.set("creator", (Object)userId);
            newDy.set("createtime", (Object)time);
            newDy.set("status", (Object)relationObj.getState());
            newDy.set("modifier", (Object)userId);
            newDy.set("modifytime", (Object)time);
            DynamicObjectCollection memEntryDys = newDy.getDynamicObjectCollection("entryentity");
            memEntryDys.clear();
            Member mem1 = modelCache.getMember(dim1, relationObj.getDim1View(), relationObj.getMem1Num());
            Member mem2 = modelCache.getMember(dim2, relationObj.getDim2View(), relationObj.getMem2Num());
            Member mem3 = modelCache.getMember(dim3, relationObj.getDim3View(), relationObj.getMem3Num());
            DynamicObject newDy1 = memEntryDys.addNew();
            this.setMemEntryRow(relationObj.getDim1Num(), mem1.getNumber(), mem1.getId(), newDy1);
            if (mem2 != null) {
                DynamicObject newDy2 = memEntryDys.addNew();
                this.setMemEntryRow(relationObj.getDim2Num(), mem2.getNumber(), mem2.getId(), newDy2);
            }
            if (mem3 != null) {
                DynamicObject newDy3 = memEntryDys.addNew();
                this.setMemEntryRow(relationObj.getDim3Num(), mem3.getNumber(), mem3.getId(), newDy3);
            }
            saveNewDys.add(newDy);
        }
        if (saveExistsDys.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])saveExistsDys.toArray(new DynamicObject[saveExistsDys.size()]));
            count += (long)saveExistsDys.size();
        }
        if (saveNewDys.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])saveNewDys.toArray(new DynamicObject[saveNewDys.size()]));
            count += (long)saveNewDys.size();
        }
        return count;
    }

    private long getDimMemRelationObjKey(DimMemRelationObj relationObj) {
        LinkedHashMap<String, String> dimMap = new LinkedHashMap<String, String>(16);
        dimMap.put(relationObj.getDim1Num(), relationObj.getMem1Num());
        dimMap.put(relationObj.getDim2Num(), relationObj.getMem2Num());
        dimMap.put(relationObj.getDim3Num(), relationObj.getMem3Num());
        return DimensionRelationUtils.getMembersKeyHashId(dimMap);
    }

    private void setMemEntryRow(String dimNum, String memNum, long memId, DynamicObject newDy) {
        newDy.set("dimension", (Object)dimNum);
        newDy.set("membernum", (Object)memNum);
        newDy.set("memberid", (Object)memId);
    }

    private Map<Long, DynamicObject> getExitstMemRelationDyMap() {
        DynamicObject[] dys;
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(16);
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        qFilter.and(new QFilter("relationid", "=", (Object)Long.parseLong(this.getSchemeId())));
        String fields = "entryhashid,status,dseq,modifier,modifytime";
        for (DynamicObject dy : dys = BusinessDataServiceHelper.load((String)"epm_multidimmemrelation", (String)fields, (QFilter[])new QFilter[]{qFilter})) {
            Long key = dy.getLong("entryhashid");
            result.put(key, dy);
        }
        return result;
    }

    private void downloadTemplate() {
        List<String[]> headDataList = this.getHeadDataList();
        String filename = this.getFileName("");
        ExcelImExportUtils.Sheet sheet = new ExcelImExportUtils.Sheet(0, 2, 0, 0);
        String url = ExcelImExportUtils.getInstance().writeWithTemplate(TEMPPATH, filename, headDataList, new ArrayList(1), sheet);
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
    }

    private String getFileName(String extName) {
        Map<String, Map<String, String>> dimsMap = this.getRelationSchemeDims();
        String dimname1 = this.getDimInfoByKey(dimsMap, 0, "dimname");
        String dimname2 = this.getDimInfoByKey(dimsMap, 1, "dimname");
        String dimname3 = this.getDimInfoByKey(dimsMap, 2, "dimname");
        String dimRelationName = dimname1 + "_" + dimname2 + "_" + dimname3;
        String filename = ResManager.loadResFormat((String)"\u7ef4\u5ea6(%1)\u6210\u5458\u4f9d\u8d56\u5173\u7cfb%2_%3", (String)"DimensionRelationUploadPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[]{dimRelationName, extName, DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        return filename;
    }

    private List<String[]> getHeadDataList() {
        Map<String, Map<String, String>> dimsMap = this.getRelationSchemeDims();
        String dimnum1 = this.getDimInfoByKey(dimsMap, 0, "dimnum");
        String dimname1 = this.getDimInfoByKey(dimsMap, 0, "dimname");
        String dimnum2 = this.getDimInfoByKey(dimsMap, 1, "dimnum");
        String dimname2 = this.getDimInfoByKey(dimsMap, 1, "dimname");
        String dimnum3 = this.getDimInfoByKey(dimsMap, 2, "dimnum");
        String dimname3 = this.getDimInfoByKey(dimsMap, 2, "dimname");
        String numFormat = ResManager.loadKDString((String)"*\u6210\u5458\u7f16\u7801\uff08%s\uff09", (String)"DimensionRelationUploadPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String nameFormat = ResManager.loadKDString((String)"\u6210\u5458\u540d\u79f0\uff08%s\uff09", (String)"DimensionRelationUploadPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String stateHead = ResManager.loadKDString((String)"*\u72b6\u6001", (String)"DimensionRelationUploadPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String[] headData = new String[]{String.format(numFormat, dimnum1), String.format(nameFormat, dimname1), String.format(numFormat, dimnum2), String.format(nameFormat, dimname2), String.format(numFormat, dimnum3), String.format(nameFormat, dimname3), stateHead};
        ArrayList<String[]> headDataList = new ArrayList<String[]>(16);
        headDataList.add(headData);
        return headDataList;
    }

    private String getDimInfoByKey(Map<String, Map<String, String>> dimsMap, int index, String key) {
        String value = "";
        int pos = 0;
        for (Map.Entry<String, Map<String, String>> entry : dimsMap.entrySet()) {
            if (pos == index) {
                value = entry.getValue().get(key);
                break;
            }
            ++pos;
        }
        return value;
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        String file_url = this.getPageCache().get("file_url");
        List urls = null;
        urls = file_url == null ? new ArrayList(10) : (List)SerializationUtils.fromJsonString((String)file_url, List.class);
        for (Object url : evt.getUrls()) {
            urls.add((String)((Map)url).get("url"));
        }
        this.getPageCache().put("file_url", SerializationUtils.toJsonString(urls));
    }

    public void afterRemove(UploadEvent evt) {
        Object[] objects;
        String file_url = this.getPageCache().get("file_url");
        if (file_url == null) {
            return;
        }
        List urls = (List)SerializationUtils.fromJsonString((String)file_url, List.class);
        for (Object object : objects = evt.getUrls()) {
            String url = (String)((Map)object).get("url");
            urls.remove(url);
        }
        this.getPageCache().put("file_url", SerializationUtils.toJsonString((Object)urls));
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
    }

    private Map<String, Map<String, String>> getRelationSchemeDims() {
        Map<String, Map<String, String>> result = new LinkedHashMap<String, Map<String, String>>(16);
        if (this.relationSchemeDims != null) {
            return this.relationSchemeDims;
        }
        String paramStr = (String)this.getView().getFormShowParameter().getCustomParam(DIMENSIONMAP);
        if (!StringUtils.isEmpty((CharSequence)paramStr)) {
            this.relationSchemeDims = (Map)SerializationUtils.fromJsonString((String)paramStr, Map.class);
            result = this.relationSchemeDims;
        }
        return result;
    }

    private String getSchemeId() {
        return (String)this.getView().getFormShowParameter().getCustomParam(CURRENT_SCHEME_ID);
    }
}

