/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.dimensionrelation;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.dimension.dimensionrelation.DimRelation;
import kd.epm.eb.common.dimension.dimensionrelation.DimRelationEntry;
import kd.epm.eb.common.dimension.dimensionrelation.DimensionRelationUtils;
import kd.epm.eb.common.dimension.dimensionrelation.PropertyInfo;
import kd.epm.eb.common.dimension.dimensionrelation.dao.DimMemRelDao;
import kd.epm.eb.common.dimension.dimensionrelation.dao.DimRelDao;
import kd.epm.eb.common.enums.PropRangeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.convert.Convert;
import org.apache.commons.lang3.StringUtils;

public class RelationEntryGridControl
extends EntryGrid {
    private static final String START_PERIOD = "startperiod";
    private static final String END_PERIOD = "endperiod";
    private static final String SPILTSTR = "$_$";
    private static final String ZERO = "0";
    private static final String ONE = "1";
    private boolean addRow = false;

    public DimRelation getCurRelation() {
        DimRelation dimRelation = null;
        String relationCache = this.getView().getPageCache().get("dimRelation");
        if (StringUtils.isNotEmpty((CharSequence)relationCache)) {
            dimRelation = (DimRelation)SerializationUtils.deSerializeFromBase64((String)relationCache);
        }
        return dimRelation;
    }

    public Long getModelId() {
        return IDUtils.toLong((Object)this.getCacheByKey("modelId"));
    }

    public void setPageRows(int rows) {
        if (this.onFetchPageData(1, rows)) {
            super.setPageRows(rows);
            this.getView().updateView(this.key);
        }
    }

    public void setPageIndex(int pageIndex) {
        super.setPageIndex(pageIndex);
    }

    public void setPageIndex(int pageIndex, boolean isSave) {
        if (isSave) {
            this.getView().getPageCache().put("isSave", ONE);
        } else {
            this.getView().getPageCache().put("isSave", ZERO);
        }
        this.setPageIndex(pageIndex);
    }

    public void addRow() {
        AbstractGrid.GridState entryState = this.getEntryState();
        Integer currentPageIndex = entryState.getCurrentPageIndex();
        int newEntryRow = 0;
        int rows = entryState.getPageRows();
        int entryRowCount = this.getModel().getEntryRowCount(this.getKey());
        if (entryRowCount % rows == 0) {
            int maxPage = ++entryRowCount % rows == 0 ? entryRowCount / rows : entryRowCount / rows + 1;
            this.addRow = true;
            this.setPageIndex(maxPage);
        } else {
            int maxPage;
            int n = maxPage = entryRowCount % rows == 0 ? entryRowCount / rows : entryRowCount / rows + 1;
            if (currentPageIndex != maxPage) {
                this.setPageIndex(maxPage);
            }
            newEntryRow = this.getModel().createNewEntryRow(this.getKey());
            int startRowIndex = (maxPage - 1) * rows;
            this.setEntryPageInfo(rows, ++entryRowCount, startRowIndex);
            this.getModel().setValue("rowtype", (Object)ONE, newEntryRow);
            this.setDefaultDimRange(newEntryRow);
        }
    }

    private void setDefaultDimRange(int rowIndex) {
        DimRelation curRelation = this.getCurRelation();
        Map dimMap = curRelation.getDimMap();
        for (Map.Entry entry : dimMap.entrySet()) {
            boolean isProp;
            int defaultVal;
            DimRelationEntry relationEntry = (DimRelationEntry)entry.getValue();
            Long propertyId = relationEntry.getPropertyId();
            if (propertyId == null || propertyId == 0L) {
                defaultVal = RangeEnum.ONLY.getIndex();
                isProp = false;
            } else {
                defaultVal = PropRangeEnum.PROP_DETAIL.getIndex();
                isProp = true;
            }
            this.setRangeComboItem((String)entry.getKey(), rowIndex, String.valueOf(defaultVal), isProp);
        }
    }

    private void setRangeComboItem(String dimKey, int rowIndex, String value, boolean isProp) {
        String comboKey = dimKey + "range";
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(comboKey);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(5);
        if (!isProp) {
            items.add(new ComboItem(new LocaleString(RangeEnum.ONLY.getName()), String.valueOf(RangeEnum.ONLY.getIndex())));
            items.add(new ComboItem(new LocaleString(RangeEnum.ALL.getName()), String.valueOf(RangeEnum.ALL.getIndex())));
            items.add(new ComboItem(new LocaleString(RangeEnum.ALL_DETAIL.getName()), String.valueOf(RangeEnum.ALL_DETAIL.getIndex())));
            items.add(new ComboItem(new LocaleString(RangeEnum.ALL_NOTDETAIL.getName()), String.valueOf(RangeEnum.ALL_NOTDETAIL.getIndex())));
        } else {
            items.add(new ComboItem(new LocaleString(PropRangeEnum.PROP_DETAIL.getName()), String.valueOf(PropRangeEnum.PROP_DETAIL.getIndex())));
            items.add(new ComboItem(new LocaleString(PropRangeEnum.PROP_NOT_DETAIL.getName()), String.valueOf(PropRangeEnum.PROP_NOT_DETAIL.getIndex())));
            items.add(new ComboItem(new LocaleString(PropRangeEnum.PROP_ALL.getName()), String.valueOf(PropRangeEnum.PROP_ALL.getIndex())));
        }
        comboEdit.setComboItems(items);
        this.getView().getModel().setValue(comboKey, (Object)value, rowIndex);
    }

    protected boolean onFetchPageData(int pageIndex, int pageRows) {
        this.refreshBillList(pageIndex, pageRows);
        return true;
    }

    public void refreshBillList(int pageIndex, int pageCount) {
        IPageCache pageCache = this.getView().getPageCache();
        String isSave = pageCache.get("isSave");
        if (!ZERO.equals(isSave)) {
            this.saveMember(false);
        }
        pageCache.remove("isSave");
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        DimRelation curRelation = this.getCurRelation();
        if (curRelation == null) {
            return;
        }
        this.getModel().deleteEntryData(this.getKey());
        int maxSeq = 0;
        int startRowIndex = (pageIndex - 1) * pageCount;
        IDataModel dataModel = this.getModel();
        IFormView formView = this.getView();
        if (this.addRow) {
            int entryRowCount = this.getModel().getEntryRowCount(this.getKey());
            this.setEntryPageInfo(pageCount, 0, 0);
            int newEntryRow = this.getModel().createNewEntryRow(this.getKey());
            this.getModel().setValue("rowtype", (Object)ONE, newEntryRow);
            this.setDefaultDimRange(newEntryRow);
            this.setEntryPageInfo(pageCount, entryRowCount + 1, startRowIndex);
            this.addRow = false;
        } else {
            QFilter qFilter = this.getMemberQFilter(this.getCurRelation().getRelationId());
            int totalCount = DimMemRelDao.getInstance().getTotalCount(qFilter);
            this.getModel().beginInit();
            this.setEntryPageInfo(pageCount, 0, 0);
            if (totalCount < 1) {
                return;
            }
            List data = DimMemRelDao.getInstance().getData(qFilter, startRowIndex, pageCount);
            if (data.size() > 0) {
                this.getModel().batchCreateNewEntryRow(this.getKey(), data.size());
                Map propertyInfoMap = DimensionRelationUtils.getPropertyInfoMap((List)data, (DimRelation)curRelation);
                int row = 0;
                for (DynamicObject doj : data) {
                    this.getModel().setValue("id", (Object)doj.getLong("id"), row);
                    Map dimMap = curRelation.getDimMap();
                    for (Map.Entry entry : dimMap.entrySet()) {
                        String rangeValue;
                        DimRelationEntry relationEntry = (DimRelationEntry)entry.getValue();
                        Long propertyId = relationEntry.getPropertyId();
                        Long viewId = doj.getLong((String)entry.getKey() + "view_id");
                        Dimension dimension = modelCache.getDimension(relationEntry.getDimensionId());
                        String dimNumber = dimension.getNumber();
                        if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) {
                            formView.setEnable(Boolean.valueOf(false), row, new String[]{START_PERIOD});
                            formView.setEnable(Boolean.valueOf(false), row, new String[]{END_PERIOD});
                        }
                        long memberId = doj.getLong((String)entry.getKey());
                        if (propertyId == null || propertyId == 0L) {
                            Member member = viewId == null || viewId == 0L ? modelCache.getMember(dimNumber, Long.valueOf(0L), Long.valueOf(memberId)) : modelCache.getMember(dimNumber, viewId, Long.valueOf(memberId));
                            if (member == null) continue;
                            dataModel.setValue((String)entry.getKey(), (Object)member.getNumber(), row);
                            dataModel.setValue((String)entry.getKey() + "id", (Object)member.getId(), row);
                            dataModel.setValue((String)entry.getKey() + "name", (Object)member.getName(), row);
                            rangeValue = doj.getString((String)entry.getKey() + "range");
                            dataModel.setValue((String)entry.getKey() + "range", (Object)rangeValue, row);
                            this.setRangeComboItem((String)entry.getKey(), row, rangeValue, false);
                            if (View.NoViewDimNums.contains(dimNumber)) continue;
                            dataModel.setValue((String)entry.getKey() + "vid", (Object)viewId, row);
                            dataModel.setValue((String)entry.getKey() + "vnumber", (Object)doj.getString((String)entry.getKey() + "view.number"), row);
                            dataModel.setValue((String)entry.getKey() + "vname", (Object)doj.getString((String)entry.getKey() + "view.name"), row);
                            continue;
                        }
                        PropertyInfo propertyInfo = (PropertyInfo)propertyInfoMap.get(memberId);
                        if (propertyInfo == null) continue;
                        dataModel.setValue((String)entry.getKey(), (Object)propertyInfo.getNumber(), row);
                        dataModel.setValue((String)entry.getKey() + "id", (Object)propertyInfo.getId(), row);
                        dataModel.setValue((String)entry.getKey() + "name", (Object)propertyInfo.getName(), row);
                        rangeValue = doj.getString((String)entry.getKey() + "range");
                        dataModel.setValue((String)entry.getKey() + "range", (Object)rangeValue, row);
                        this.setRangeComboItem((String)entry.getKey(), row, rangeValue, true);
                    }
                    dataModel.setValue(START_PERIOD, doj.get(START_PERIOD), row);
                    dataModel.setValue(END_PERIOD, doj.get(END_PERIOD), row);
                    dataModel.setValue("status", (Object)doj.getBoolean("status"), row);
                    dataModel.setValue("modifier", (Object)doj.getString("modifier_id"), row);
                    dataModel.setValue("modifytime", (Object)doj.getString("modifytime"), row);
                    maxSeq = doj.getInt("dseq");
                    ++row;
                }
            }
            this.setEntryPageInfo(pageCount, totalCount, startRowIndex);
        }
        this.getView().getPageCache().put("billMaxSeq", String.valueOf(maxSeq));
        dataModel.endInit();
        this.getModel().updateCache();
    }

    public void setEntryPageInfo(int pageSize, int rowCount, int startRowIndex) {
        DynamicObject billObj = this.getModel().getDataEntity(true);
        billObj.getDataEntityState().setEntryPageSize(this.getKey(), pageSize);
        billObj.getDataEntityState().setEntryRowCount(this.getKey(), rowCount);
        billObj.getDataEntityState().setEntryStartRowIndex(this.getKey(), startRowIndex);
    }

    private QFilter getMemberQFilter(Long relationId) {
        return new QFilter("relationid", "=", (Object)relationId);
    }

    public void saveMember(boolean isShowSuccessMsg) {
        List<Integer> rows = this.getRowsToSave();
        this.saveMember(rows, isShowSuccessMsg);
    }

    public void saveMember(List<Integer> rows, boolean isShowSuccessMsg) {
        if (rows.size() < 1) {
            return;
        }
        HashSet<DynamicObject> memberList = new HashSet<DynamicObject>(16);
        ArrayList<Integer> errRowSet = new ArrayList<Integer>(16);
        ArrayList<Integer> repeatRowSet = new ArrayList<Integer>(16);
        ArrayList<Integer> sucSaveRows = new ArrayList<Integer>(16);
        HashSet<String> membersSet = new HashSet<String>(16);
        DimRelation curRelation = this.getCurRelation();
        if (curRelation == null) {
            return;
        }
        int seq = this.getIntCacheByKey("billMaxSeq");
        Long userId = UserUtils.getUserId();
        Date time = TimeServiceHelper.now();
        for (int row : rows) {
            String pkid = this.getSelectId(row);
            DynamicObject member = null;
            QFilter repeatQFilter = this.getMemberQFilter(curRelation.getRelationId());
            if (!this.saveCheck(row, curRelation, repeatQFilter)) {
                errRowSet.add(row + 1);
                continue;
            }
            DynamicObject startperiod = (DynamicObject)this.getModel().getValue(START_PERIOD, row);
            DynamicObject endperiod = (DynamicObject)this.getModel().getValue(END_PERIOD, row);
            Long startperiodId = 0L;
            Long endperiodId = 0L;
            if (startperiod != null) {
                startperiodId = startperiod.getLong("id");
            }
            if (endperiod != null) {
                endperiodId = endperiod.getLong("id");
            }
            if (!this.saveCheckRepeat(row, repeatQFilter, startperiodId, endperiodId)) {
                repeatRowSet.add(row);
                sucSaveRows.add(row);
                continue;
            }
            if (StringUtils.isNotEmpty((CharSequence)pkid)) {
                member = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(pkid), (String)"epm_dimmemberrelation");
            } else {
                member = BusinessDataServiceHelper.newDynamicObject((String)"epm_dimmemberrelation");
                long newId = GlobalIdUtil.genGlobalLongId();
                member.set("id", (Object)newId);
                member.set("dseq", (Object)(++seq));
                member.set("relationid", (Object)curRelation.getRelationId());
                member.set("model", (Object)this.getModelId());
                member.set("creator", (Object)userId);
                member.set("createtime", (Object)time);
            }
            member.set("status", this.getModel().getValue("status", row));
            IDataModel dataModel = this.getModel();
            Map dimMap = curRelation.getDimMap();
            StringBuilder membersId = new StringBuilder();
            for (Map.Entry entry : dimMap.entrySet()) {
                Long memberId = (Long)dataModel.getValue((String)entry.getKey() + "id", row);
                member.set((String)entry.getKey(), (Object)memberId);
                Long viewId = (Long)dataModel.getValue((String)entry.getKey() + "vid", row);
                member.set((String)entry.getKey() + "view", (Object)viewId);
                String range = (String)dataModel.getValue((String)entry.getKey() + "range", row);
                member.set((String)entry.getKey() + "range", (Object)range);
                membersId.append(memberId).append(SPILTSTR).append(range).append(SPILTSTR);
            }
            membersId.append(startperiodId).append(SPILTSTR).append(endperiodId);
            if (!membersSet.add(membersId.toString())) {
                repeatRowSet.add(row);
                sucSaveRows.add(row);
                continue;
            }
            this.setRowProperty(userId, time, String.valueOf(member.get("id")), row);
            member.set(START_PERIOD, (Object)startperiod);
            member.set(END_PERIOD, (Object)endperiod);
            member.set("modifier", (Object)userId);
            member.set("modifytime", (Object)time);
            memberList.add(member);
            sucSaveRows.add(row);
        }
        SaveServiceHelper.save((DynamicObject[])memberList.toArray(new DynamicObject[0]));
        CacheServiceHelper.clearRelation((Long)curRelation.getRelationId());
        this.updateRowType(sucSaveRows);
        DimRelDao.getInstance().updateVersion(this.getModelId().longValue(), curRelation.getRelationId().longValue());
        if (errRowSet.size() == 0) {
            if (isShowSuccessMsg) {
                if (repeatRowSet.size() > 0) {
                    int[] rowIndexes = repeatRowSet.stream().mapToInt(Integer::intValue).toArray();
                    this.setRowBackcolor("#FFF8E1", rowIndexes);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff0c\u5df2\u8df3\u8fc7\u91cd\u590d\u6570\u636e\u3002", (String)"DimensionRelationListPlugin_49", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DimensionRelationListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        } else {
            this.focusRow((Integer)errRowSet.get(0) - 1);
            String rowString = errRowSet.stream().map(e -> e + "").collect(Collectors.joining(","));
            throw new KDBizException(ResManager.loadResFormat((String)"\u5f53\u524d\u9875\uff0c\u7b2c%1\u884c\u6570\u636e\u672a\u586b\u5199\u5b8c\u6574\u3002", (String)"DimensionRelationListPlugin_50", (String)"epm-eb-formplugin", (Object[])new Object[]{rowString}));
        }
    }

    private void updateRowType(List<Integer> sucSaveRows) {
        if (sucSaveRows.size() == 0) {
            return;
        }
        sucSaveRows.forEach(e -> this.getModel().setValue("rowtype", (Object)ZERO, e.intValue()));
    }

    private void focusRow(int row) {
        RelationEntryGridControl entryGridControl = (RelationEntryGridControl)this.getView().getControl(this.key);
        entryGridControl.selectRows(row);
    }

    private void setRowProperty(Long userId, Date time, String id, int row) {
        this.getModel().setValue("modifier", (Object)userId, row);
        this.getModel().setValue("modifytime", (Object)time, row);
        this.getModel().setValue("id", (Object)id, row);
    }

    private boolean saveCheck(int row, DimRelation curRelation, QFilter qFilter) {
        Map dimMap = curRelation.getDimMap();
        IDataModel dataModel = this.getModel();
        for (Map.Entry entry : dimMap.entrySet()) {
            Long pkid = (Long)dataModel.getValue((String)entry.getKey() + "id", row);
            String range = (String)dataModel.getValue((String)entry.getKey() + "range", row);
            if (pkid == null || pkid == 0L || StringUtils.isBlank((CharSequence)range)) {
                return false;
            }
            qFilter.and(new QFilter((String)entry.getKey(), "=", (Object)pkid));
            qFilter.and(new QFilter((String)entry.getKey() + "range", "=", (Object)range));
        }
        return true;
    }

    private boolean saveCheckRepeat(int row, QFilter qFilter, Long startperiod, Long endperiod) {
        String id = this.getSelectId(row);
        if (id != null) {
            qFilter.and(new QFilter("id", "!=", (Object)Convert.toLong((Object)id)));
        }
        qFilter.and(new QFilter(START_PERIOD, "=", (Object)startperiod));
        qFilter.and(new QFilter(END_PERIOD, "=", (Object)endperiod));
        return !QueryServiceHelper.exists((String)"epm_dimmemberrelation", (QFilter[])new QFilter[]{qFilter});
    }

    public String getSelectId(int row) {
        Object id = this.getModel().getValue("id", row);
        if (id == null || Objects.equals("", id)) {
            return null;
        }
        return id.toString();
    }

    public List<Integer> getRowsToSave() {
        ArrayList<Integer> rows = new ArrayList<Integer>(16);
        int entryRowCount = this.getModel().getEntryRowCount(this.getKey());
        Integer currentPageIndex = this.getEntryState().getCurrentPageIndex();
        int pageRow = this.getPageRow();
        int startRowIndex = (currentPageIndex - 1) * pageRow;
        int endRowIndex = Math.min(startRowIndex + pageRow, entryRowCount);
        for (int i = startRowIndex; i < endRowIndex; ++i) {
            Object rowType = this.getModel().getValue("rowtype", i);
            if (rowType == null || ZERO.equals(rowType.toString())) continue;
            rows.add(i);
        }
        return rows;
    }

    private int getIntCacheByKey(String key) {
        String cacheValue = this.getCacheByKey(key);
        return StringUtils.isEmpty((CharSequence)cacheValue) ? 0 : Integer.parseInt(cacheValue);
    }

    private String getCacheByKey(String key) {
        String cacheValue = this.getView().getPageCache().get(key);
        return cacheValue == null ? "" : cacheValue;
    }
}

