/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.group;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.enums.dimensionEnums.ViewGroupTypeEnum;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.olap.service.view.ViewGroupManager;
import kd.epm.eb.olap.service.view.bean.DimensionViewGroup;
import org.apache.commons.lang.StringUtils;

public class DimensionViewGroupEditPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(DimensionViewGroupEditPlugin.class);
    private static final String BUTTON_OK = "button_ok";
    private static final String MODEL_KEY = "model";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter customParam = super.getView().getFormShowParameter();
        if (Objects.equals(OperationStatus.EDIT, customParam.getStatus()) || Objects.equals(OperationStatus.VIEW, customParam.getStatus())) {
            Long id = (Long)customParam.getCustomParam("id");
            if (id == null) {
                throw new KDBizException(ResManager.loadKDString((String)"id\u4e0d\u80fd\u4e3a\u7a7a", (String)"DimensionViewGroupEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"type"});
            DynamicObject editObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_dimensionview_group");
            String type = (String)editObj.get("type");
            if ("1".equals(type)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"defaultview", "controlview"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"defaultview", "controlview"});
            }
            this.getModel().setValue("id", editObj.get("id"));
            this.getModel().setValue("number", editObj.get("number"));
            this.getModel().setValue("name", editObj.get("name"));
            this.getModel().setValue("parent", editObj.get("parent.id"));
            this.getModel().setValue(MODEL_KEY, editObj.get(MODEL_KEY));
            this.getModel().setValue("creater", editObj.get("creater"));
            this.getModel().setValue("createdate", editObj.get("createdate"));
            this.getModel().setValue("modifier", editObj.get("modifier"));
            this.getModel().setValue("modifydate", editObj.get("modifydate"));
            this.getModel().setValue("dimension", editObj.get("dimension.id"));
            this.getModel().setValue("type", (Object)type);
            this.getModel().setValue("defaultview", editObj.get("defaultview.id"));
            this.getModel().setValue("description", editObj.get("description"));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
            DimensionViewGroup dimensionViewGroup = DimensionViewGroup.of((DynamicObject)editObj);
            this.getPageCache().put("dimensionViewGroup", SerializationUtils.serializeToBase64((Object)dimensionViewGroup));
        } else if (Objects.equals(OperationStatus.ADDNEW, customParam.getStatus())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"defaultview", "controlview"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"type"});
            String groupType = (String)customParam.getCustomParam("groupType");
            String currIdString = (String)customParam.getCustomParam("currId");
            long currId = Long.parseLong(currIdString);
            Long model = (Long)customParam.getCustomParam(MODEL_KEY);
            Long dimensionId = (Long)customParam.getCustomParam("dimensionId");
            this.getModel().setValue(MODEL_KEY, (Object)model);
            this.getModel().setValue("creater", (Object)UserUtils.getUserId());
            this.getModel().setValue("createdate", (Object)TimeServiceHelper.now());
            this.getModel().setValue("dimension", (Object)dimensionId);
            this.getModel().setValue("type", (Object)groupType);
            this.getModel().setValue("source", (Object)"0");
            DimensionViewGroup dimensionViewGroup = new DimensionViewGroup();
            if (ViewGroupTypeEnum.DIM.getIndex().equals(groupType)) {
                dimensionViewGroup.setParent(Long.valueOf(currId));
                this.getModel().setValue("parent", (Object)currId);
            }
            dimensionViewGroup.setDescription((ILocaleString)((OrmLocaleValue)this.getModel().getValue("description")));
            dimensionViewGroup.setDefaultViewId(null);
            dimensionViewGroup.setDimensionId(dimensionId);
            dimensionViewGroup.setType(groupType);
            dimensionViewGroup.setSource("0");
            dimensionViewGroup.setModelId(model);
            this.getPageCache().put("dimensionViewGroup", SerializationUtils.serializeToBase64((Object)dimensionViewGroup));
        }
    }

    @Override
    public void registerListener(EventObject e) {
        BasedataEdit _f7ControlView;
        super.registerListener(e);
        this.addClickListeners(new String[]{BUTTON_OK});
        BasedataEdit _f7View = (BasedataEdit)this.getView().getControl("defaultview");
        if (_f7View != null) {
            _f7View.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((_f7ControlView = (BasedataEdit)this.getView().getControl("controlview")) != null) {
            _f7ControlView.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String close = this.getPageCache().get("close");
        if (!"true".equals(close) && this.getModel().getDataChanged()) {
            String message = ResManager.loadKDString((String)"\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"BgTaskPackageEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(message, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("barclose", (IFormPlugin)this));
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String key = event.getCallBackId();
        if ("barclose".equals(key) && MessageBoxResult.Yes.getValue() == event.getResult().getValue()) {
            this.getPageCache().put("close", "true");
            this.getView().close();
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "button_ok": {
                MultiLangEnumBridge opDesc;
                MultiLangEnumBridge opName;
                String type;
                OperationStatus status = super.getView().getFormShowParameter().getStatus();
                if (Objects.equals(OperationStatus.VIEW, status)) {
                    this.getView().close();
                    return;
                }
                String dimensionViewGroupJson = this.getPageCache().get("dimensionViewGroup");
                if (StringUtils.isEmpty((String)dimensionViewGroupJson)) {
                    return;
                }
                DimensionViewGroup dimensionViewGroup = (DimensionViewGroup)SerializationUtils.deSerializeFromBase64((String)dimensionViewGroupJson);
                dimensionViewGroup.setNumber((String)this.getModel().getValue("number"));
                OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
                dimensionViewGroup.setName(name);
                dimensionViewGroup.setDescription((ILocaleString)((OrmLocaleValue)this.getModel().getValue("description")));
                DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("defaultview");
                if (dynamicObject != null) {
                    dimensionViewGroup.setDefaultViewId(Long.valueOf(dynamicObject.getLong("id")));
                }
                if (StringUtils.isNotEmpty((String)(type = (String)this.getModel().getValue("type")))) {
                    dimensionViewGroup.setType(type);
                }
                try (TXHandle th = TX.required((String)"saveViewGroup");){
                    try {
                        ViewGroupManager.getInstance().saveViewGroup(dimensionViewGroup);
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                        MultiLangEnumBridge opName2 = new MultiLangEnumBridge("\u4fdd\u5b58", "ExamineCategoryAddPlugin_0", "epm-eb-formplugin");
                        MultiLangEnumBridge opDesc2 = new MultiLangEnumBridge("\u5206\u7c7b\u4fdd\u5b58\u5931\u8d25", "ExamineCategoryAddPlugin_1", "epm-eb-formplugin");
                        this.writeLog(dimensionViewGroup.getNumber(), "save", opName2, opDesc2, null, false);
                        th.markRollback();
                        throw new KDBizException(e.getMessage());
                    }
                }
                if (Objects.equals(OperationStatus.EDIT, status)) {
                    opName = new MultiLangEnumBridge("\u89c6\u56fe\u5206\u7ec4\u4fee\u6539", "DimensionViewGroupEditPlugin_2", "epm-eb-formplugin");
                    opDesc = new MultiLangEnumBridge("\u89c6\u56fe\u5206\u7ec4\u4fee\u6539\u4fee\u6539\u6210\u529f", "DimensionViewGroupEditPlugin_3", "epm-eb-formplugin");
                    this.writeLog(dimensionViewGroup.getNumber(), "update", opName, opDesc, null);
                } else {
                    opName = new MultiLangEnumBridge("\u89c6\u56fe\u5206\u7ec4\u65b0\u589e", "DimensionViewGroupEditPlugin_4", "epm-eb-formplugin");
                    opDesc = new MultiLangEnumBridge("\u89c6\u56fe\u5206\u7ec4\u65b0\u589e\u6210\u529f", "DimensionViewGroupEditPlugin_5", "epm-eb-formplugin");
                    this.writeLog(dimensionViewGroup.getNumber(), "addnew", opName, opDesc, null);
                }
                this.getModel().setDataChanged(false);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"DimensionViewGroupEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.getView().close();
                break;
            }
        }
    }

    @Override
    public String getBizAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }

    @Override
    public Long getModelId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam(MODEL_KEY);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        String f7Key = event.getProperty().getName();
        ListShowParameter showP = (ListShowParameter)event.getFormShowParameter();
        List qs = showP.getListFilterParameter().getQFilters();
        Long modelId = this.getModelId();
        qs.add(new QFilter(MODEL_KEY, "=", (Object)modelId));
        switch (f7Key) {
            case "controlview": 
            case "defaultview": {
                DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("dimension");
                if (dynamicObject != null) {
                    qs.add(new QFilter("dimension", "=", (Object)dynamicObject.getLong("id")));
                }
                Long id = (Long)this.getModel().getValue("id");
                Set allViewByGroupId = ViewGroupManager.getInstance().getAllViewByGroupId(Collections.singletonList(id));
                qs.add(new QFilter("id", "in", (Object)allViewByGroupId));
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("type".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            String dimensionViewGroupJson = this.getPageCache().get("dimensionViewGroup");
            if (StringUtils.isEmpty((String)dimensionViewGroupJson)) {
                return;
            }
            DimensionViewGroup dimensionViewGroup = (DimensionViewGroup)SerializationUtils.deSerializeFromBase64((String)dimensionViewGroupJson);
            FormShowParameter customParam = super.getView().getFormShowParameter();
            if ("2".equals(newVal)) {
                String currIdString = (String)customParam.getCustomParam("currId");
                long currId = Long.parseLong(currIdString);
                this.getModel().setValue("parent", (Object)currId);
                dimensionViewGroup.setParent(Long.valueOf(currId));
            } else {
                this.getModel().setValue("parent", (Object)0);
                dimensionViewGroup.setParent(Long.valueOf(0L));
            }
            this.getPageCache().put("dimensionViewGroup", SerializationUtils.serializeToBase64((Object)dimensionViewGroup));
        }
    }
}

