/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dimension.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.control.utils.BgControlUtils;

public class CheckControlUtils {
    public static CheckControlUtils get() {
        return new CheckControlUtils();
    }

    public boolean checkControlMapping(Long modelId, Set<Long> busModelIds, Object[] memberIdsAry) {
        if (IDUtils.isNull((Long)modelId) || busModelIds == null || busModelIds.isEmpty() || memberIdsAry == null || memberIdsAry.length == 0) {
            return false;
        }
        HashSet<Long> itemMappingIds = new HashSet<Long>();
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid from t_eb_dimmembermapping where fmodel = ? and fdim = ? and ", new Object[]{modelId, SysDimensionEnum.Entity.getNumber()});
        sql.appendIn("fbussmodelid", busModelIds.toArray());
        try (DataSet ds = DB.queryDataSet((String)"queryControlMapping", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    itemMappingIds.add(row.getLong("fid"));
                }
            }
        }
        if (!itemMappingIds.isEmpty()) {
            sql = new SqlBuilder();
            sql.append("select top 1 fdimmemberid from t_eb_membermapping where ", new Object[0]).appendIn("fid", itemMappingIds.toArray());
            sql.append(" and ", new Object[0]).appendIn("fdimmemberid", memberIdsAry);
            ds = DB.queryDataSet((String)"queryControlMapping", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
            var7_7 = null;
            try {
                if (ds != null && ds.hasNext()) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Throwable throwable) {
                var7_7 = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (var7_7 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            var7_7.addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        return false;
    }

    public boolean checkControlRecord(Long modelId, Set<Long> busModelIds, Object[] memberIdsAry) {
        if (busModelIds == null || busModelIds.isEmpty()) {
            return false;
        }
        ArrayList tables = Lists.newArrayListWithExpectedSize((int)busModelIds.size());
        for (Long busModelId : busModelIds) {
            tables.add(BgControlUtils.getBgControlRecordTable((Long)modelId, (Long)busModelId));
        }
        for (String _table : tables) {
            if (!DB.exitsTable((DBRoute)BgBaseConstant.epm, (String)_table)) continue;
            SqlBuilder sql = new SqlBuilder();
            sql.append("select top 1 forgunitid from " + _table + " where fmodelid = ? and ", new Object[]{modelId});
            sql.appendIn("forgunitid", memberIdsAry);
            DataSet ds = DB.queryDataSet((String)"queryControlOrg", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
            Throwable throwable = null;
            try {
                if (ds == null || !ds.hasNext()) continue;
                boolean bl = true;
                return bl;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
        return false;
    }
}

